  
***

# iOS 10

<!--
<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 10 logo</p></summary>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_logo.svg)

<!--
</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_Homescreen_iPhone_7.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_10_Homescreen_iPhone_7.png)

( **Predecessor:** [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) | **iOS 10** | **Successor:** [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) )

iOS 10 is the tenth major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc., being the successor to [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/). It was announced at the company's Worldwide Developers Conference on June 13, 2016, and was released on September 13, that year. It was succeeded by [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/) on September 19, 2017.

iOS 10 incorporates changes to 3D Touch and the lock screen. There are new features to some apps: Messages has additional emojis and third-party apps can extend functionality in iMessage, Maps has a redesigned interface and additional third-party functions, the Home app manages "HomeKit"-enabled accessories, Photos has algorithmic search and categorization of media known as "Memories," and Siri is compatible with third-party app-specific requests, such as starting workouts apps, sending IMs, using Lyft or Uber or to use payment functions. iOS 10 is the final version to support 32-bit devices and apps. In [iOS 10.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), Apple introduced its new file system, APFS.

Reviews of iOS 10 were positive. Reviewers highlighted the significant updates to iMessage, Siri, Photos, 3D Touch, and the lock screen as welcome changes. The third-party extension support to iMessage meant it was "becoming a platform," although the user interface was criticized for being difficult to understand. Third-party integration in Siri was "great," although the voice assistant was criticized for not having become smarter than before. Reviewers were impressed with the image recognition technology in Photos, although noting it was still a "work in progress" with a higher error rate than the competition. 3D Touch "finally feels useful" and "works in almost every part of the OS." The lock screen was "far more customizable than before," and reviewers enjoyed that notification bubbles could be expanded to see more information without needing to unlock the phone.

A month after release, iOS 10 was installed on 54% of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices, a "slightly slower migration" than for the release of [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/), speculated as being caused by an early release issue that may have "put some [users] off downloading the update." User adoption of iOS 10 steadily increased in the following months, eventually totaling 89% of active devices in September 2017.

## History

### Introduction and initial release

iOS 10 was introduced at the Apple Worldwide Developers Conference keynote address on June 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/). The first beta release was made available to registered developers following the keynote. Apple released the first public beta release on July 7, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/).

iOS 10 was officially released on September 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/).

### Updates

Version 	Build 	Release date 	Notes

10.0 	13A346 	September 13, 2016 	Initial release

10.0.1 	14A403 	Released 4 minutes after bugged iOS 10.0 build was released. Fixes bug which bricked devices after updating

10.0.2 	14A456 	September 23, 2016 	

Fixes an issue that could temporarily prevent headphone audio controls from working

Fixes an issue that caused Photos to quit for some users when turning on iCloud Photo Library

Fixes an issue that prevented enabling some app extensions

10.0.3 	14A551 	October 17, 2016 	Fixes an issue where cellular connectivity could drop on iPhone 7 and iPhone 7 Plus

10.1 	14B72

14B72c 	October 24, 2016 	

Introduces Portrait Mode for iPhone 7 Plus that creates a depth effect that keeps your subject sharp while creating a beautifully blurred background

Transit support for every major train, subway, ferry and national bus line, as well as local bus systems for Tokyo, Osaka and Nagoya

New Option to replay bubble and full screen effects in iMessage

10.1.1 	14B100 	October 31, 2016 	

Fixes an issue where Health data could not be viewed for some users

Security fixes

14B150 	November 9, 2016

10.2 	14C92 	December 12, 2016 	

New TV app for United States

Replaces a Videos app found in previous iOS versions

Emojis were redesigned

Over 100 new emoji including new faces, food, animals, sports and professions

Unicode 9.0 support

New wallpapers for iPhone 7 and iPhone 7 Plus

If you press power button five times, iPhone will call emergency services (India only)

10.2.1 	14D27 	January 23, 2017

General bug fixes and performance improvements

Improves power management during peak workloads to avoid unexpected shutdowns

10.3 	14E277 	March 27, 2017 	

Introduction of [APFS](https://github.com/seanpm2001/WacOS/wiki/APFS/), Apple's new file system. Upon installation, devices are converted from [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS-Plus/) to [APFS](https://github.com/seanpm2001/WacOS/wiki/APFOS/).

New «Find my AirPods» tool to help users locate lost AirPods

Siri can now display cricket scores from the Indian Premier League and the International Cricket Council

The weather icon in the Maps app includes 3D Touch to show hourly forecasts

CarPlay includes new shortcuts for launching recently used apps

Podcasts app supports 3D Touch and widget in Today view

In Settings, when choosing an alphanumeric code with numbers only, passcodes can no longer be shorter than 4 characters in length. An error displays saying that "this passcode must be longer"

An alert is now displayed to indicate that 32-bit apps need to be updated and will no longer work in future versions of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/)

Bug fixes:

Fixes an issue related to the Messages app where the app would freeze and crash upon receiving a long text message

Fixes an issue where the Telephoto lens on the iPhone 7 Plus would not activate while in the 2x zoom mode

Fixes an issue in Notification Center where tapping the search bar in between the Today view and Notification Center would cause the Springboard to crash and reload

Fixes an issue on iPad Pro where the Apple Pencil’s battery wouldn’t charge above 5%

10.3.1 	14E304 	April 3, 2017 	Security patches and bug fixes

10.3.2	14F89

14F90

14F91

14F8089 	May 15, 2017 	General bug fixes and stability improvements

10.3.3 	14G60 	July 19, 2017 	

Adds new wallpapers for 12.9-inch iPad Pro

Fixes security vulnerabilities

10.3.4 	14G61 	July 22, 2019 	Fixes an issue that would prevent cellular devices from maintaining an accurate GPS position after November 3, 2019

iPhone 7 and iPhone 7 Plus only

Initial release on iPad (5th generation)

Initial release on iPad Pro 10.5-inch and iPad Pro 12.9-inch (2nd generation)

iPad (5th generation) only

iPad mini 4 (Wi-Fi + Cellular) only

iPad Pro 10.5-inch and iPad Pro 12.9-inch (2nd generation) only

iPhone 5 and iPad (4th generation) (Wi-Fi + Cellular) only

## System features

### Control Center

The Control Center has been redesigned and split into three pages: one for general settings, such as quick toggles for airplane mode and orientation lock, one for audio controls and one for controlling HomeKit (internet of things) appliances, if used.

3D Touch capabilities have been added to several toggles.

### Home screen

Apps can show a widget when their home-screen icon is accessed with 3D Touch.

Most default apps included with [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices can be hidden from the home screen and 're-downloaded' from the App Store. Upon doing this, the sandbox of the respective app is removed, which contains user data, settings and caches. The app is also hidden from other places, such as the "Today" view, the Settings app and "Share Sheets", through which the user can interact with the app from within another app. This feature was first hinted at during an interview in September [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), in which Apple CEO Tim Cook stated that Apple was "looking at" allowing customers to remove unused stock apps.

iOS 10 allows users to prioritize certain app downloads by using 3D Touch.

### Keyboard

QuickType virtual keyboards, which provide word-completion capabilities, can predict likely responses to questions and suggest relevant information based on location, calendar availability or contacts.

The "Define" feature in previous [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) versions has been replaced by "Look Up," and now expands its utility from just providing definitions to retrieving information from locations, web browsing history, downloaded apps, suggested websites, and more.

The QuickType keyboard will allow the user to type in multiple languages if the user selects the desired languages in the "Dictionary" and "Keyboard" settings menus.

The user has the ability to change keyboard settings specifically for physical keyboards (such as autocorrect and auto-capitalization).

### Lock screen

The "slide to unlock" mechanism on the lock screen has been removed in favor of pressing the home button.

Similar to the feature on the Apple Watch, "Raise to Wake" wakes up the device when the user lifts it. This function requires a device with an M9 motion coprocessor or newer.

The "Today" view of Notification Center has been replaced by widgets, and is accessible by swiping from left to right. On the iPad, widgets can be displayed in a two-column layout.

### Notification Center

The Notification Center no longer has a "Today" view.

Notifications, now larger, can expand to display more information and all unread notifications can be cleared at once, using 3D Touch.

Apps that need to be updated frequently can now have notifications that update live.

The Notification Center contains a Spotlight search bar.

### Settings

A new Magnifier setting was added which allows users to triple-click the home button to launch the Camera app with magnification enabled.

There are also new "Color Filters" settings to compensate for a user's color blindness. Color Filters options include grayscale, red/green filter for protanopia, green/red filter for deuteranopia, and blue/yellow filter for tritanopia.

For the Messages application, users can now turn on Low Quality Image mode, which saves "your poor iPhone from stuffing itself full of images" based on new animated stickers and GIFs that can be sent in iMessage.

The Wi-Fi menu in Settings now shows warnings about the security of a network and whether a network lacks Internet connectivity. This is shown to the user as small subtext under the Wi-Fi's network's name.

"Raise to Wake" can be enabled or disabled in Settings.

In [iOS 10.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), a "Preserve Settings" feature allows users to set the Camera app to launch with certain settings by default. Options include launching with the Video or Square mode rather than the Photo mode, preserving the last-used filter, and preserving the capture settings for Live Photos.

Music added to Apple Music on one device can now be automatically downloaded to other devices using the "Automatic Downloads" setting.

The Settings allows the user the option to have routes in the Maps app avoid toll roads and/or highways.

In [iOS 10.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), Settings was updated to feature information relating to a user's Apple ID account in the main menu, and features a section that allows users to see which old, unmaintained apps won't work in future versions of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/). Additionally, users can now see a breakdown of their iCloud storage.

The user can enable a setting to have Siri announce incoming callers, with options for "Always," "Headphones & Car," "Headphones Only," and "Never".

### CarPlay

iOS 10 now allows users to rearrange and remove apps from their CarPlay display, through Settings.

In [iOS 10.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), Maps on CarPlay added electric vehicle charging stations.

### Universal Clipboard

As part of the overall Continuity features introduced in iOS 8, a new Universal Clipboard feature allows users of Mac personal computers running macOS Sierra and [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices running iOS 10 to easily copy material to and from different devices through iCloud.

As part of Continuity, a new "Continuity Keyboard" feature allows users to type text on an iPhone and have the text appear on an Apple TV running tvOS 10, avoiding the Siri Remote for text input.

### Other changes

iOS 10 features new sound effects for locking the device and for keyboard clicks.

In the event that a device detects liquid in the Lightning port, a notice warns the user to disconnect the Lightning cable and allow the port to dry.

iOS 10 also allows TTY calls to be made without any additional hardware.

iOS 10 allows users to find their Apple Watch using Find My iPhone.

Spotlight can now search the contents of the user's iCloud Drive.

Storage is reported to the user in the base 10 (1 kilobyte equals 1000 bytes) format instead of base 2, which was used in older [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) versions.

## App features

### App Store

iOS 10 allows developers to buy advertisement spots in the App Store when users search for content. It also brings back the "Categories" section, which replaces the "Explore" section introduced in [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/).

In [iOS 10.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), developers gained the ability to respond to user reviews, and "Helpful" and "Not Helpful" review labels can help surface the most relevant customer reviews.

### Calendar

In iOS 10, users can now change what day of the week the calendar starts on, as well as alert settings for birthdays and events, and calendar type (Gregorian, Chinese, Hebrew, Islamic).

### Camera

Music will no longer stop playing when the Camera app is launched, unless the user decides to record a video or take a Live Photo. Live Photos can be taken with filters (previously only available for still photos).

In [iOS 10.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), the iPhone 7 Plus received a new depth of field portrait camera mode, using both the wide-angle and telephoto lenses on the phone to "create shallow depth of field portrait photos with blurred backgrounds".

### Clock

The Clock app now employs a dark theme.

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_Clock_app_screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/10/IOS_Clock_app_screenshot.png)

-The analog stopwatch face_

A new "Bedtime" feature reminds the user when to go to bed to get the desired amount of sleep. There is also a new stopwatch face, accessed by swiping to the left.

### Contacts

The Contacts app in iOS 10 allows users to set default phone numbers and email addresses for contacts who have multiple numbers or addresses. The app also allows the user to add and remove contacts from the Favorite Contacts list.

### Home

Home is a new app that allows users to manage appliances compatible with HomeKit, Apple's API for home automation. In the app, users can add compatible HomeKit accessories, such as locks, lights, and thermostats, and then directly control the appliances through the app.

A "Scenes" panel allows many devices to be controlled at once to fit a mood or setting. Geo-fencing activates scheduled sequences following the user's location.

### Mail

The Mail app now allows users to unsubscribe from mailing lists with an Unsubscribe button. Users can dismiss the message to unsubscribe for a particular mailing list by tapping the "X" at the top right corner, preventing the Mail app from displaying the unsubscribe button for that mailing list again later.

Apple has added back support for HTML5 video in Mail, which was previously stopped in [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/).

Mail can filter messages, either by unread/read, or by categories.

iOS 10 also changes how email threading works, by placing the oldest email at the top by default. An option in Settings lets users revert to the previous threading system with the most recent message on top. Additionally, the new threaded conversations allow users to tap a message to see a scrollable stream of messages inside the thread.

### Maps

Maps has been redesigned and updated with additional features, including scanning calendar events for locations, learning from a user's typical actions, and a redesigned driving view.

A marker can be automatically placed to indicate the user's parked car. The marker can also tell the user when they last parked their car, and a Notes field allows the user to enter information, such as parking garage number, in the app.

The app now helps users find the nearest gas station, fast-food restaurant or coffee shop, by swiping up from the bottom of the screen. Maps also estimates how long the detour will take.

Users can add third-party extensions to the Maps app, which enable additional functionality, such as a restaurant-booking extension can help the user reserve a table from inside the Maps app.

Users can now pan and zoom while in navigation mode.

The app displays the current temperature and weather conditions in the bottom right corner. In [iOS 10.3](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), the app also allows the user to see a weather forecast by using 3D Touch on the current temperature. This functionality allows users to see an hour-by-hour breakdown of the area that they are looking at.

### Messages

The Messages app incorporates its own App Store, which lets users download third-party iMessage apps that can be accessed within iMessage conversations. Users can use them to send stickers, play games or send rich content, such as media previews, to recipients. The Messages App Store has three navigation fields: Featured, Categories, and Manage.

The app has been updated to include many visual effects. Chat bubbles, for example, can be sent with a "loud" or "gentle" animation that the recipient sees upon receiving. "Invisible ink" effect obscures the message until the recipient swipes across it. Full-screen effects like balloons, confetti or fireworks can be sent. There is also support for interactions similar to the Apple Watch, such as sending quick sketches and recording and sending the user's heartbeat. In order to use the screen and bubble effects, the Reduce Motion setting needs to be turned off.

Messages now allows users to send handwritten notes. This is done by turning the device to landscape mode for iPhones (landscape or portrait for iPad users) and then tapping the handwriting squiggle. The Messages app automatically saves recently used notes, to make it easier to send them again. A handwritten message can be deleted in the same way an app is deleted; by holding down on the message and pressing Delete. The message can also be saved as a picture file.

New emojis have been added, as well as additional features related to emoji. Emojis appear 3x bigger if messages are sent with up to three emojis and no text, the keyboard can now predict emojis to use, and an emoji replacement feature attempts to match words in messages and replace them with emojis of the same meaning.

Since the Game Center app has been removed, Messages now handles actions such as inviting friends to a game.

Read receipts can now be turned on or off for individual contacts rather than for all contacts.

### Music

The Music app has been redesigned, with an emphasis placed on usability. The "For You" section has been reorganized, with a playlist offering daily music recommendations. The "New" tab has been renamed "Browse". A new tab for music that has been downloaded called "Downloaded Music" has been added.

Lyrics are viewable for songs in-app in iOS 10. The "Search" tab includes recent and trending searches. An "Optimized Storage" option removes downloaded music that the user hasn't played in a while.

### News

The News app, taking cues from the Music layout, has been redesigned to incorporate bold headings and a newspaper-esque layout in the redesigned "For You" tab. News also features support for subscriptions and provides notifications for breaking news.

### Notes

Notes now has a collaboration feature. This allows users to share a note and collaborate with other users, who can add and remove text from a note. Users tap a "round yellow badge with a person and a plus sign" and can then send invitations through text, email, or by link.

### Photos

Apple added deep learning capabilities for sorting and searching in the Photos app.

A new "Memories" feature can automatically recognize and compile related photos and create short, shareable music videos. local facial recognition functionality was added to bundle together pictures of certain people.

iOS 10 allows users to add doodles and text on a photo, using a new "Markup" feature. If the user edits a Live Photo using Markup, the image will be turned into a still image.

Live Photos can now be edited by the Photos app. This allows users to trim the clip, change the still frame, add a filter and add digital image stabilization to the Live Photo so it is "buttery smooth".

The app also has an upgraded auto-enhance feature and adds a "Brilliance" slider.

### Phone

The Phone app can transcribe received visual voicemails.

Siri can announce the name and phone number of incoming calls. The system can mark suspected spam callers on the call screen upon incoming calls.

Contacts can be enabled for "Emergency Bypass", in which the phone will always make sounds and vibrations when receiving notifications from the chosen contacts, even during Do Not Disturb mode.

In the Favorites screen, users can customize what action each favorited contact will enable from a click, including call, FaceTime, SMS, or email.

Users can save voicemails through AirDrop, iMessage, iCloud Drive, and other apps through a share menu.

### Safari

Apple Pay is now available through the Safari app.

There is no limit to how many tabs users can have open at the same time.

On supported iPads, Safari has a unique "Split View" for viewing two Safari browser tabs in 50/50 mode next to each other.

Users can also search for keywords in specific tabs, close all tabs with a single click, and reopen recently closed tabs by long-pressing on the plus icon. Users can also search for items in the Bookmarks and Reading List.
TV

Included in the [iOS 10.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update is a "TV" app. The app, which is only available in the United States, offers a simple, unified experience of content from different video apps, as long as each service supports the feature. The new app replaces the Videos app found in previous [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) versions.

## Developer APIs

iOS 10 gives third-party developers access to APIs to three major [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) system apps and services: Siri, iMessage, and Maps. Developers can:

Turn certain activities into Siri voice commands, allowing users to speak voice queries into the Siri personal assistant and Siri returning results from the respective apps. Apps that can integrate with Siri are limited to: sending messages, starting calls, sending and requesting payments, search for photos and videos, ordering taxicab or ride-sharing services, and managing workouts.

Add dedicated apps to the iMessage App Store, that lets users add unique sticker packs, share rich content, or interact with certain app functions entirely within an iMessage conversation.

Add extensions to Apple Maps, so apps with specific functionality useful in a map, such as a restaurant-booking app, can integrate with the mapping service to handle app functionality directly in the Maps app.

iOS 10 allows third-party camera apps to capture RAW image format pictures. Support for shooting photos in Adobe's DNG RAW format is limited to devices with at least a 12MP camera and a third-party app that supports it, as Apple did not enable the feature in the native Camera app.

iOS 10 allows VoIP apps to have the same functionality and interface as the Phone and FaceTime apps have, through the use of a CallKit API.

## Removed functionality

Native support for the VPN protocol PPTP was removed. Apple recommends alternatives which it considers to be more secure.

The options to group notifications by app in Notification Center and customize the order of notifications were removed.

The Game Center app has been removed, as is the case on macOS Sierra.

## Reception

In his review, The Verge's Dieter Bohn wrote that the new features introduced in iOS 10 are "an evolution of some of the design and interaction ideas that Apple has been working on for a couple of years". He wrote that iMessage is "becoming a platform all its own", and although he liked that extensions mean access to information from apps without needing to open the respective apps, he wrote that new iMessage interface is difficult to understand and that the use of "third-party apps, stickers, crazy confetti effects, and emoji all over the place" is a "nightmare", although finishing with "Or maybe that's a wonderland, not a nightmare. Your call." Regarding third-party support in Siri, he called it "great", while noting the limited class of apps ("calls, messaging, payments, photos, ride-sharing apps, some CarPlay systems, and workouts"), and that sometimes a button press was required to complete the process. Beyond app integrations, he criticized Siri, writing "Siri doesn't seem to have gotten a whole lot smarter than you remember". Bohn enjoyed the new machine learning technology present in the Photos app, writing that he was "impressed" by Apple's image recognition technology, which he noted is done locally on the device, but did criticize the error rate, where he compares the technology to Google Photos as a step ahead. Bohn liked the new designs for the Music and Maps apps, saying both the redesigns were "for the better". Bohn particularly enjoyed the new lock screen, where he highlighted that notification bubbles can be 3D Touch-ed to access more information, all without needing to unlock the phone. Other small bits of new features he liked included "deletable" apps, upgraded "widgets" when 3D Touch-ing a home screen icon, and breaking news notifications in Apple News. Overall, Bohn referred to iOS 10 as "Still a walled garden, but with more doors".

Engadget's Devindra Hardawar wrote that iOS 10 is Apple "basically polishing a pearl." Hardawar noted that the major changes in the release focus on features rather than the visual interface. He wrote that the lock screen is now "far more customizable than before." He praised the new features added to 3D Touch, writing that it "finally feels useful," where he likes that "3D Touch works in almost every part of the OS." In regard to iMessage, he wrote that it has new features that are "particularly useful", including "Invisible ink" that obscures text in a conversation when others might be looking, but criticized the user interface, writing that it "needs some work". The "Memories" feature in the new Photos app "usually turned out well", but wrote that "they're still clearly a work in progress." Hardawar praised the new Apple Music app, but added that "really, anything is better than the last iteration." He also liked lyrics support. He wrote that Siri's third-party support was "actually starting to get useful," but did run into accuracy issues. He finished by writing that although iOS 10 does add features seen in Google's Android operating system before, the mobile industry is "shamelessly getting "inspired" by the competition". His summary states that "iOS 10 is a collection of useful changes to an already solid OS".

In October 2016, a month after its initial release, 54% of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices were running iOS 10, a "slightly slower migration" than for the release of '[iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) in the preceding year, a result speculated by MacRumors's Tim Hardwick as being caused by an early release issue that disabled some devices and may have "put some [users] off downloading the update." User adoption increased to 76% of active devices in January 2017, 79% in February 2017, 86% in June 2017, 87% in July 2017, and 89% in September 2017 before the release of [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/).

## Problems

### Initial release bricking issue

The initial public release of iOS 10 on September 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/) saw many iPhones and iPads temporarily disabled, or "bricked", by the over-the-air update, requiring bricked devices to be connected to a Mac or PC with iTunes in order to retry the update or restore the device to factory settings. Apple quickly released [iOS 10.0.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), and issued a statement: "We experienced a brief issue with the software update process, affecting a small number of users during the first hour of availability. The problem was quickly resolved and we apologize to those customers."

### Local backup encryption issue

In September [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), it was discovered that the encryption of local [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) backups made with iTunes is weaker for iOS 10 devices than for devices running [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/). Russian software firm ElcomSoft discovered that the iOS 10 backup process skips several security checks, making it "approximately 2,500 times" faster to try passwords, enabling 6 million password tries per second compared to the 2,400 password tries per second for the same process ElcomSoft has used on [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/). The firm stated that the impact is "severe". Apple acknowledged the problem, said it planned to issue a security update, but also stated that iCloud backups were not affected. The [iOS 10.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update subsequently fixed the issue.

### Battery shutdowns and throttling

Some [iOS 10.1.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) users reported that their devices were prone to unexpectedly shutting down at or around 30% battery charge (with one user describing the battery percentage as dropping unexpectedly from 30% to 1% before doing so, but still registering as 30% when plugging it in to charge it). Apple began the process of diagnosing this bug in [iOS 10.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), and stated following the release of [iOS 10.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) that it had reduced the occurrence of these shutdowns by "more than 80%" on iPhone 6S models and "over 70%" on iPhone 6 models. It also became possible to reboot the device after an unexpected shutdown without plugging it into power.

In December [2017](https://github.com/seanpm2001/WacOS/wiki/2017/), speculation emerged that Apple had been intentionally throttling the performance of older iPhone models based on battery health, especially on the iPhone 6S (which, in a separate issue, also had isolated incidents of a battery manufacturing issue that was also causing system instability), after a user benchmark showed a variance in performance after a battery replacement. The developers of Geekbench confirmed that there had been sizable decreases on benchmark scores on iPhone 6 devices running [iOS 10.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) and later, and iPhone 7 devices since [iOS 11.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) and later. These led to concerns that Apple was instituting planned obsolescence policies in order to encourage sales of newer iPhone models.

Later that month, Apple admitted that since iOS [10.2.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), it had been implementing performance management techniques on older iPhone models to preserve system stability, especially in situations where their batteries are "less capable of supplying peak current demands," such as cold weather, age, or low charge. Apple stated that these measures were intended to help "deliver the best experience for customers, which includes overall performance and prolonging the life of their devices." The company announced that it would offer a discount on out-of-warranty battery replacements during [2018](https://github.com/seanpm2001/WacOS/wiki/2018/).

## Supported devices

With this release, Apple dropped support for devices with either an A5 or an A5X chip: the iPhone 4S, iPad 2, iPad (3rd generation), iPad Mini (1st generation), and iPod Touch (5th generation). It is also the last version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) to support devices with a 32-bit processor, such as the iPhone 5 and 5C, or the iPad (4th generation), and it is also the last version of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) to support 32-bit apps.

### iPhone

iPhone 5

iPhone 5C

iPhone 5S

iPhone 6

iPhone 6 Plus

iPhone 6S

iPhone 6S Plus

iPhone SE (1st generation)

iPhone 7

iPhone 7 Plus
	
### iPod Touch

iPod Touch (6th generation)
	
### iPad

iPad (4th generation)

iPad Air

iPad Air 2

iPad (2017)

iPad Mini 2

iPad Mini 3

iPad Mini 4

iPad Pro (12.9-inch 1st generation)

iPad Pro (12.9-inch 2nd generation)

iPad Pro (9.7-inch)

iPad Pro (10.5-inch)

**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## Sources

[Wikipedia - iOS 10](https://en.wikipedia.org/wiki/IOS_10/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday September 27th at 4:02 pm`

**Last revised on:** `2021 Monday September 27th at 4:02 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `510`

**Article version:** `1 (2021 Monday September 27th at 4:02 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

