  
***

# iOS 8

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 8 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_logo.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_Homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/08/IOS_8_Homescreen.png)

( **Predecessor:** [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/) | **Successor:** [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) )

iOS 8 is the eighth major release of the [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) mobile operating system developed by Apple Inc., being the successor to [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/). It was announced at the company's Worldwide Developers Conference on June 2, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), and was released on September 17, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/). It was succeeded by [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) on September 16, [2015](https://github.com/seanpm2001/WacOS/wiki/2015/).

iOS 8 incorporated significant changes to the operating system. It introduced Continuity, a cross-platform (Mac, iPhone, and iPad) system that enables communication between devices in different product categories, such as the ability to answer calls and reply to SMS on the Mac and iPad. Continuity includes a "Handoff" feature that lets users start a task on one device and continue on another. Other changes included a new Spotlight Suggestions search results feature that provides more detailed results, Family Sharing, where a family can link together their accounts to share content, with one parent as the administrator with permission controls, an updated keyboard with QuickType, providing contextual predictive word suggestions and Extensibility, which allows for easier sharing of content between apps. Third-party developers got additional features to integrate their apps deeper into the operating system, including support for widgets in the Notification Center, and the ability to make keyboards that users can replace the default [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) keyboard with.

App updates in the release included the new Health app, which can aggregate data from different fitness apps, as well as enabling a Medical ID accessible on the lock screen for emergencies, support for iCloud Photo Library in the Photos app, which enables photos to be synchronized and stored in the cloud, and iCloud Drive, which lets users store files in the cloud and browse them across devices. In [iOS 8.4](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), Apple updated its Music app with a streaming service called Apple Music, and a 24-hour radio station called Apple Music 1.

Reception of iOS 8 was positive. Critics praised Continuity and Extensibility as major features enabling easier control and interaction between different apps and devices. They also liked the QuickType keyboard word suggestions, and highlighted Spotlight Suggestions for making the iPhone "almost a portable search portal for everything.” However, reviewers noted that the full potential for iOS 8 would only be realized once third-party developers integrated their apps to support new features, particularly widgets in the Notification Center.

Roughly a week after release, iOS 8 had reached 46% of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) usage share. In October [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), it was reported that the adoption rate had "stalled,” only increasing by "a single percentage point" from the previous month. This situation was blamed on the requirement of a high amount of free storage space to install the upgrade, especially difficult for iPhones sold with 8 or 16 gigabytes of maximum storage space. The following December, iOS 8 had reached 63% usage share, a notable 16% increase from the October measurement.

## History

### Introduction and initial release

iOS 8 was introduced at the company's Worldwide Developers Conference on June 2, 2014, with the first beta made available to conference attendees after the keynote presentation.

iOS 8 was officially released on September 17, 2014.

Updates

Version 	Build 	Release date 	Notes

8.0 	12A365

12A366 	September 17, 2014 	Initial release

8.0.1 	12A402 	September 24, 2014 	Bug fixes

8.0.2 	12A405 	September 25, 2014 	Fixes the issues encountered in iOS 8.0.1

8.1 	12B410

12B41 	October 20, 2014 	New features:

Apple Pay for iPhone 6 and 6 Plus in the United States;

iCloud Photo Library in beta status;

restored the Camera Roll in Photos;

Continuity features, which enable iPhone users to read and send SMS and MMS from their iPad and Mac;

Instant Hotspot: allows Mac users to remotely activate the "Personal hotspot" feature on a nearby iPhone

8.1.1 	12B435

12B436 	November 17, 2014 	Bug fixes and performance improvements for iPhone 4S and iPad 2

8.1.2 	12B440 	December 9, 2014 	Fixes an issue where ringtones purchased through the iTunes Store would be removed from an iOS device[13]

8.1.3 	12B466 	January 27, 2015 	Bug fixes, including a security fix for the Pangu jailbreak; reduced the amount of storage space required to perform an iOS update

8.2 	12D508 	March 9, 2015 	Support for the Apple Watch, with the Apple Watch app on iPhone, providing App Store and configuration options access; Health with options for units of measurement; as well as many stability improvements and bug fixes.

8.3	12F69

12F70 	April 8, 2015 	New features:

Emoji improvements, such as an updated emoji keyboard picker that organizes emoji into categories, new diversified emoji, and skin tone modifiers

New languages for Siri

Support for wireless CarPlay

Major bug fixes and improvements

8.4 	12H143 	June 30, 2015 	Introduces Apple Music; audiobooks have been moved from the Music app to the iBooks app.

8.4.1 	12H321 	August 13, 2015 	Fixes for Apple Music; fixes a security issue that allowed the TaiG jailbreak to work.

Initial release on iPhone 6 and iPhone 6 Plus

iPhone 6 Plus only

The update was withdrawn due to cellular and Touch ID issues on iPhone 6 and iPhone 6 Plus

Initial release on iPad Air 2 and iPad mini 3

iPhone 4S, iPhone 5, iPhone 5C, iPhone 5S, iPhone 6, iPhone 6 Plus and iPod Touch (5th generation) only

iPhone 6, iPhone 6 Plus, iPad Air 2 and iPad mini 3 only

iOS 8.3 is the first iOS version to have a public beta test

iPhone 4S, iPhone 5, iPhone 5C, iPhone 5S, iPhone 6 and iPhone 6 Plus only

Initial release on iPod touch (6th generation)

## System features

### Continuity

iOS 8 introduced Continuity, a cross-platform (Mac, iPhone, and iPad) system that enables communication between devices in different product categories. Continuity enables phone call functionality for the iPad and Mac, in which calls are routed through the iPhone over to a secondary device. The secondary device then serves as a speaker phone. This also brings SMS support to the iPad and Mac, an extension of the iMessage feature in previous versions.

Continuity adds a feature called "Handoff," that lets users start a task on one device and continue on another, such as composing an e-mail on the iPhone and then continuing it on the iPad before sending it on the Mac. In order to support Handoff and Continuity, Macs needed to have the [OS X Yosemite](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-10-Yosemite/) operating system, which was released in October 2014, as well as support for Bluetooth low energy.

### Spotlight

iOS 8 introduced Spotlight Suggestions, a new search feature that integrates with many websites and services to show more detailed search results, including snippets of Wikipedia articles, local news, quick access to apps installed on the device, iTunes content, movie showtimes, nearby places, and info from various websites. Spotlight Suggestions are available on the iOS home screen as well as in the Safari web browser search bar.

### Notifications

The drop-down Notification Center has now been redesigned to allow widget functionality. Third-party developers can add widget support to their apps that let users see information in the Notification Center without having to open each respective app. Users can add, rearrange, or remove any widgets, at any time. Examples of widgets include a Weather app showing current weather, and a Calendar app showing upcoming events.

Notifications are now actionable, allowing users to reply to a message while it appears as a quick drop-down, or act on a notification through the Notification Center.

### Keyboard

iOS 8 includes a new predictive typing feature called QuickType, which displays word predictions above the keyboard as the user types.

Apple now allows third-party developers to make keyboard apps that users can replace the default [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) keyboard with. For added privacy, Apple added a settings toggle called "Allow Full Access", that optionally enables the keyboard to act outside its app sandbox, such as synchronizing keyboard data to the cloud, third-party keyboards are not allowed to use Siri for voice dictation, and some secure text fields do not allow input.

### Family Sharing

iOS 8 introduced Family Sharing, which allows up to 6 people to register unique iTunes accounts that are then linked together, with one parent becoming the administrator, controlling the overall experience. Purchases made on one account can be shared with the other family members, but purchases made by kids under 13 years of age require parental approval. Purchases made by adults will not be visible for the kids at all.

Family Sharing also extends into apps, a Shared album is automatically generated in the Photos app of each family member, allowing everyone to add photos, videos, and comments to a shared place. An Ask to Buy feature allows anyone to request the purchase of items in the App Store, iTunes Store, and iBooks Store, as well as in-app purchases and iCloud storage, with the administrator having the option to either approve or deny the purchase.

### Multitasking

The multitasking screen shows a list of recently called and favorited contacts. The feature can be turned off in Settings.

### Other

iOS 8 includes an additional data roaming option in Settings for European users, allowing greater control over data usage abroad.

The Siri personal voice assistant now has integrated Shazam support. Asking Siri "What song is this?" will identify what song is playing.

Wi-Fi calling has been added to allow mobile phone calls over Wi-Fi. Mobile operator carriers can then enable the Voice-over-Wi-Fi functionality in their services.

## App features

### Photos and Camera

#### Camera app

The Camera app gets two new features; time-lapse and self-timer. Time-lapse records frames at shorter intervals than normal film frequencies and builds them into movies, showing events in a faster speed. Self-timer gives the user the option of a three-second or ten-second countdown before automatically taking a photo. iPads can now take pictures in panoramic mode.

#### iCloud Photo Library

iOS 8 added iCloud Photo Library support to the Photos app, enabling photo synchronization between different Apple devices. Photos and videos were backed up in full resolution and in their original formats. This feature almost meant that lower-quality versions of photos could be cached on the device rather than the full-size images, potentially saving significant storage space on models with limited storage availability.

#### Search

The Photos app received better search, with different search categorization options, including Nearby, One Year Ago, Favorites, and Home, based on geolocation and date of photo capture.

#### Editing

Additionally, the Photos app gained more precise editing controls, including improved rotation; one-touch auto-enhancement tools; and deeper color adjustments, such as brightness, contrast, exposure, and shadows. There is also an option to hide a photo without deleting it.

#### Extensions

Apple added an Extensibility feature in iOS 8, that allows filters and effects from third-party apps to be accessed directly from within a menu in the standard Photos app, rather than having to import and export photos through each respective app to apply effects.
Camera Roll

In the initial release of iOS 8, Apple removed a "Camera Roll" feature from the Photos app. Camera Roll was an overview of all photos on the device, but was replaced by a "Recently Added" photo view displaying photos by how recently the user captured them.

Despite being replaced by a "Recently Added" album, the removal of Camera Roll sparked user complaints, which Apple returned the feature in the [iOS 8.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update.

### Messages

In iOS 8, Messages gets new features for group conversations, including a Do Not Disturb mode that disables conversation notifications, as well as the ability to remove participants from the chat. A new Tap to Talk chat button lets users send quick voice comments to a recipient, and a Record button allows users to record short videos.

For interaction between two Apple users, the Messages app allows users to send short picture, video or audio clips with a 2-minute expiration time.

In the Settings app, the user has the option to have messages be automatically deleted after a certain time period.

### Safari

In the Safari web browser, developers can now add support for Safari Password Sharing, which allows them to share credentials between sites they own and apps they own, potentially cutting down on the number of times users need to type in credentials for their apps and services. The browser also adds support for the WebGL graphics API.

### iCloud Drive

In a similar style as a file manager, the iCloud Drive is a file hosting service that, once enabled in Settings, lets users save any kind of file in the app, and the media is synchronized to other iOS devices, as well as the Mac.

### App Store

In iOS 8, Apple updated App Store with an "Explore" tab providing improved app discovery, trending searches in the "Search" tab, and the ability for developers to bundle multiple apps into a single discounted package. New "preview" videos allow developers to visually show an app's function.

### Health

HealthKit is a service that allows developers to make apps that integrate with the new Health app. The Health app primarily aggregates data from fitness apps installed on the user's device, except for steps and flights climbed, which are tracked through the motion processor on the user's iPhone. Users can enter their medical history in Medical ID, which is accessible on the lock screen, in case of an emergency.

### HomeKit

HomeKit serves as a software framework that lets users set up their iPhone to configure, communicate with, and control smart-home appliances. By designing rooms, items and actions in the HomeKit service, users can enable automatic actions in the house through a simple voice dictation to Siri or through apps.

Manufacturers of HomeKit-enabled devices are required to purchase a license, and all HomeKit products are required to have an encryption co-processor. Equipment manufactured without HomeKit-support can be enabled for use through a "gateway" product, such as a hub that connects between those devices and the HomeKit service.

### Passbook

The Passbook app on iOS 8 was updated to include Apple Pay, a digital payment service, available on iPhone 6 and 6 Plus with the release of [iOS 8.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/).

### Music

A new music streaming service, Apple Music, was introduced in the iOS 8.4 update. It allows subscribers to listen to an unlimited number of songs on-demand through subscriptions. With the release of the music service, the standard Music app on iOS was revamped both visually and functionally to include Apple Music, as well as the 24-hour live radio station Beats 1.

### Notes

Notes received rich text editing support, with the ability to bold, italicize or underline text; and image support, allowing users to post photos in the app.

### Weather

The Weather app now uses weather data from The Weather Channel instead of Yahoo!. The app also received slight changes in the user interface. In March 2019, Yahoo ended support for the Weather app on [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/) and earlier.

### Tips

iOS 8 added a new "Tips" app, that shows tips and brief information about the features in iOS on a weekly basis.

### Touch ID

iOS 8 allows Touch ID to be used in third-party apps.

## Reception

iOS 8 received positive reviews. Brad Molen of Engadget highlighted Continuity as a major advancement for users with multiple Apple devices. He also praised the Extensibility feature, allowing apps to share data, and liked the support for third-party keyboards. However, Molen noted that some of the new introductions - Family Sharing, Continuity, and iCloud Drive - require further diving into the Apple ecosystem to work. He particularly enjoyed actionable notifications and third-party widget support in Notification Center. Charles Arthur of The Guardian also liked Extensibility, as well as the new QuickType word suggestions functionality in the iOS keyboard. He criticized the lack of an option for choosing default apps, and he also criticized the Settings menu for being confusing and unintuitive. Darrell Etherington of TechCrunch praised the improvements to iMessage, writing: "Best for me has been the ability to mute and leave group conversations, which is something I've been sorely missing since the introduction of group iMessage conversations." He liked the new search and editing features in Photos, and the QuickType feature in the keyboard, but particularly highlighted Spotlight Suggestions as "one of the better features of iOS 8, even if it's a small service addition," noting that "it makes your iPhone almost a portable search portal for everything." Martin Bryant of The Next Web wrote that "The real advances here are yet to come," adding that "Apple has included demonstrations of what can be done, but the true power of what's under the hood will be realized over the coming days, weeks and months" as third-party developers gradually incorporate new features into their apps.

On September 23, [2014](https://github.com/seanpm2001/WacOS/wiki/2-14/), "roughly a week" after the release of iOS 8, user adoption of iOS 8 had reached 46%. In October 2014, Andrew Cunningham of Ars Technica reported that iOS 8 user adoption rate had "stalled," only climbing "a single percentage point" since the previous September measurement of 46%. Cunningham blamed the "over-the-air" update requiring 5 gigabytes to install, an "unusually large amount" that may have posed challenges to those using 8 gigabyte and 16 gigabyte devices. As an alternative, Apple offered the update via its iTunes software, but Cunningham noted that "An iTunes hookup is going to be even more out of the way these days than it was a few years ago, not least because Apple has spent the last three years coaching people to use their iDevices independently of their computers." In December, a new report from Ars Technica stated that iOS 8 usage had increased to 63%, up "a solid 16 percent."

## Problems

### App crash rate

A study by Apteligent (formerly Crittercism) found that the rate at which apps crashed in their tests was 3.56% on iOS 8, higher than the 2% found on [iOS 7.1](https://github.com/seanpm2001/WacOS/wiki/iOS-7/).

### 8.0.1 update issues

In September [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), the [iOS 8.0.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update caused significant issues with Touch ID on iPhone 6 and cellular network connectivity on some models. Apple stated that affected users should reinstall the initial iOS 8 release until version [8.0.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) was ready.

[iOS 8.0.2](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) was released one day after [8.0.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), with a fix for issues caused by the [8.0.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update.

### Miscellaneous bugs

Forbes published several articles focusing on problems in iOS 8 regarding Wi-Fi and battery, Bluetooth, and calendar.

### "Effective power" text message crash

In May [2015](https://github.com/seanpm2001/WacOS/wiki/2015/), news outlets reported on a bug where receiving a text message with a specific combination of symbols and Arabic characters, caused the Messages application to crash and the iPhone to reboot.

The bug, named "effective power," could potentially continuously reboot a device if the message was visible on the lock screen.

The flaw was exploited for the purpose of trolling, by intentionally causing others' phones to crash.

The bug was fixed in [iOS 8.4](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/), an update released in June [2015](https://github.com/seanpm2001/WacOS/wiki/2015/).

## Hoaxes

In September [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), a hoax Apple advertisement for an alleged feature called "Wave" of iOS 8 circulated on Twitter, which promised users that they would be able to recharge their iPhone by heating it in a microwave oven. This feature does not exist, and the media cited numerous people reporting on Twitter that they had destroyed their iPhone by following the procedure described in the advertisement.

## Supported devices

With this release, Apple dropped support for the iPhone 4.

### iPhone

iPhone 4S

iPhone 5

iPhone 5C

iPhone 5S

iPhone 6

iPhone 6 Plus
	
### iPod Touch


iPod Touch (5th generation)

iPod Touch (6th generation)
	
### iPad

iPad 2

iPad (3rd generation)

iPad (4th generation)

iPad Air

iPad Air 2

iPad Mini (1st generation)

iPad Mini 2

iPad Mini 3

**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## Sources

[Wikipedia - iOS 8](https://en.wikipedia.org/wiki/IOS_8/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Sunday September 26th at 2:26 pm`

**Last revised on:** `2021 Sunday September 26th at 2:26 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Sunday September 26th at 2:26 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

