  
***

# iPadOS 13

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPadOS/IPadOS_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPadOS/IPadOS_wordmark.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPadOS/IPadOS_13_Screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iPadOS/IPadOS_13_Screenshot.png)

( **Predecessor:** [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) / [iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/) | **Successor:** [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/) )

iPadOS 13 is the first major release of the [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/) mobile operating system developed by Apple Inc. for their iPad line of tablet computers. The successor to [iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/) on those devices, it was announced at the company's 2019 Worldwide Developers Conference (WWDC) on June 3, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/), as a derivation from [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), with a greater emphasis on multitasking and tablet-centric features. It was released on September 24, [2019](https://github.com/seanpm2001/WacOS/wiki/2019/). It was succeeded by [iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/), released on September 16, [2020](https://github.com/seanpm2001/WacOS/wiki/2020/).

## History

The first iPad was released in [2010](https://github.com/seanpm2001/WacOS/wiki/2010/) and ran [iPhone OS](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS/) [3.2](iPhoneOS-version-history), which added support for the larger device to the operating system, previously only used on the iPhone and iPod Touch. This shared operating system was rebranded as "[iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/)" with the release of [iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/).

The operating system initially had rough feature parity running on the iPhone, iPod Touch, and iPad, with variations in user interface depending on screen size, and minor differences in the selection of apps included. However, over time, the variant of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) for the iPad incorporated a growing set of differentiating features, such as picture-in-picture, the ability to display multiple running apps simultaneously (both introduced with [iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/) in [2015](https://github.com/seanpm2001/WacOS/wiki/2015/)), drag and drop, and a dock that more closely resembled the one in [macOS](https://github.com/seanpm2001/WacOS/wiki/MacOS/) than the one on the iPhone (added in [2017](https://github.com/seanpm2001/WacOS/wiki/2017/) with [iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/)). Standard iPad apps were increasingly designed to support the optional use of a keyboard.

To emphasize the different feature set available on the iPad, and to signal their intention to develop the platforms in divergent directions, at WWDC 2019 Apple announced that the variant of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) that runs on the iPad would be rebranded as "[iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/)." The new naming strategy began with [iPadOS 13.1](https://github.com/seanpm2001/WacOS/wiki/iPadOS-version-history/), in [2019](https://github.com/seanpm2001/WacOS/wiki/2019/).

## Updates

The releases of iPadOS 13 began with 13.1, 13.0 was never publicly released, even though beta testing for iPadOS 13 started with 13.0.

Version 	Build 	Release Date 	Reference 	Notes

13.1 	17A844 	September 24, 2019 	 	Initial release on iPad (7th generation)

13.1.1 	17A854 	September 27, 2019 		

13.1.2 	17A860 	September 30, 2019 	

13.1.3 	17A878 	October 15, 2019 		

13.2 	17B84 	October 28, 2019 		

13.2.2 	17B102 	November 7, 2019 		

13.2.3 	17B111 	November 18, 2019 		

13.3 	17C54 	December 10, 2019 	

13.3.1 	17D50 	January 28, 2020 		

13.4 	17E255 	March 24, 2020 	 	Adds complete support for mice and trackpads, previously an accessibility feature only.

Initial release on iPad Pro (4th generation)

13.4.1 	17E262 	April 7, 2020 		

13.5 	17F75 	May 20, 2020 	 	

13.5.1 	17F80 	June 1, 2020 	

13.6 	17G68 	July 15, 2020 	 	

13.6.1 	17G80 	August 12, 2020 	

13.7 	17H35 	September 1, 2020 	 	Bug fixes

Legend:   Past   Current   Beta

## Features

### Home Screen

Unlike previous versions of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), the icon grid displays up to five rows and six columns of apps, regardless of whether the device is in portrait or landscape orientation. The first page of the home screen can be configured to show a column of widgets from applications for easy access. Spotlight Search is no longer part of the widgets but can still be accessed by swiping down from the center of the home screen or pressing Command + Space on a connected keyboard.

### Multitasking

[iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/) features a multitasking system developed with more capabilities compared to [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), with features like Slide Over and Split View that make it possible to use multiple different applications simultaneously. Double-clicking the Home Button or swiping up from the bottom of the screen and pausing will display all currently active spaces. Each space can feature a single app, or a Split View featuring two apps. The user can also swipe left or right on the Home Indicator to go between spaces at any time, or swipe left/right with four fingers.

While using an app, swiping up slightly from the bottom edge of the screen will summon the [Dock](https://github.com/seanpm2001/WacOS/wiki/iPadOS-dock/), where apps stored within can be dragged to different areas of the current space to be opened in either Split View or Slide Over. Dragging an app to the left or right edge of the screen will create a Split View, which will allow both apps to be used side by side. The size of the two apps in Split View can be adjusted by dragging a pill shaped icon in the center of the vertical divider and dragging the divider all the way to one side of the screen closes the respective app. If the user drags an app from the dock over the current app, it will create a floating window called Slide Over which can be dragged to either the left or right side of the screen. A Slide Over window can be hidden by swiping it off the right side of the screen, and swiping left from the right edge of the screen will restore it. Slide Over apps can also be cycled between by swiping left or right on the Home Indicator in the Slide Over window and pulling up on it will open an app switcher for Slide Over windows. A pill shaped icon at the top of apps in Split View or Slide Over allows them to be switched in an out of Split View and Slide Over.

The user can now have several instances of a single app open at once. A new mode similar to [macOS's](https://github.com/seanpm2001/WacOS/wiki/MacPS/) Mission Control has been added which allows the user to see all of the instances of an app.

In many applications, a notable exception being YouTube, videos can be shrunk down into a picture-in-picture window so the user can continue watching it while using other apps. This window containing the video can be resized by pinching and spreading and can be docked to any of the four corners of the screen. It can also be hidden by swiping it off the side of the screen and is denoted by an arrow at the edge where the video is hidden and swiping it will bring it back onscreen.

### Safari

iPadOS Safari now shows desktop versions of websites by default, includes a download manager, and has 30 new keyboard shortcuts if an external keyboard is connected.

### Sidecar

Sidecar allows for an iPad to function as a second monitor for [macOS](https://github.com/seanpm2001/WacOS/wiki/MacOS/), named in reference to articulated motorcycles. When using Sidecar, the Apple Pencil can be used to emulate a graphics tablet for applications like Photoshop.] This feature is supported only on iPads compatible with the Apple Pencil.

### Storage

In addition to accessing local storage for general use, [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/) allows external storage, such as USB flash drives, portable hard drives, and solid state drives to be connected to an iPad via the Files app. The iPad Pro (3rd generation) connects over USB-C, while the Lightning Camera Connection Kit can be used with previous iPads.

### Mouse and trackpad support

Support for mice and trackpads was available since the first public release, albeit as an accessibility feature only. Complete support was added in [version 13.4](https://github.com/seanpm2001/WacOS/wiki/iPadOS-version-history/), which included multitouch gestures for trackpads, and allowed third-party apps to implement new features supporting mice and trackpads.

### Supported devices

iPadOS 13 supports iPads with an Apple A8 or A8X chip or later, dropping support for devices with the A7 chip, more specifically the first-generation iPad Air and the iPad Mini 2 and iPad Mini 3. Devices supporting iPadOS 13 include:

iPad Air 2

iPad Air (3rd generation)

iPad (5th generation)

iPad (6th generation)

iPad (7th generation)

iPad Mini 4

iPad Mini (5th generation)

All iPad Pro models

An upgrade to iPadOS 13 is automatically offered to supported devices.

***

## Sources

[Wikipedia - iPadOS 13](https://en.wikipedia.org/wiki/IPadOS_13)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Saturday, September 25th at 3:43 pm`

**Last revised on:** `2021 Saturday, September 25th at 3:43 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021, Saturday, September 25th at 3:43 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

