  
***

# iOS 7

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 7 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7_Logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7_Logo.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7.1_homescreen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_7.1_homescreen.png)

iOS 7 is the seventh major release of the iOS mobile operating system developed by Apple Inc., being the successor to [iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/). It was announced at the company's Worldwide Developers Conference on June 10, [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), and was released on September 18 of that year. It was succeeded by [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/) on September 17, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/).

iOS 7 introduced a completely redesigned user interface, a design credited to a team led by Apple's former senior vice president of design, Jony Ive. The new look, featuring flatter icons, a new slide-to-unlock function, and new animations, was described by Ive as "profound and enduring beauty in simplicity". The new design was implemented throughout the operating system, including the Notification Center, which was updated with three tabs offering different views of information; notifications visible on the lock screen; a redesigned Siri voice assistant offering visual indicators; and a Control Center offering easy access to the most commonly used features. iOS 7 also introduced AirDrop, a wireless sharing technology; CarPlay, phone and car integration; and automatic app updates in the App Store.

Reception of iOS 7 was mixed. The new design language was criticized, with critics noting the implementation of design changes rather than actual productivity improvements, and citing examples such as animations delaying access, lack of icon consistency, and buttons being hidden as negative aspects of the user experience. The addition of the Control Center was praised, as were updates to Siri and multitasking. Shortly after release, there were reports of the new design causing sickness, a trend explained as being caused by animations with similar effects as car sickness.

User adoption of iOS 7 was fast. Its [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) market share was reported to be as high as 35% after one day, and installed on 200 million devices within 5 days, which Apple stated was "the fastest software upgrade in history."

## History

### Introduction and initial release

iOS 7 was introduced at the Apple Worldwide Developers Conference on June 10, 2013. A beta release was made available to registered developers after the announcement.

iOS 7 was officially released on September 18, 2013.

### Updates

Version 	Build 	Release date 	Notes

7.0 	11A465

11A466	September 18, 2013 	Initial release

7.0.1 	11A470a 	September 20, 2013 	iTunes purchases can now be done with Touch ID

7.0.2 	11A501 	September 26, 2013 	Lock screen bypass fix; restored Greek keyboard functionality for passcode entry

7.0.3 	11B511 	October 23, 2013 	Support for iCloud Keychain, password generator for the Safari web browser; bug fixes

7.0.4 	11B554a 	November 14, 2013 	Bug fixes addressing FaceTime calls failing

7.0.5 	11B601 	January 29, 2014 	Fix correcting network provisioning for some iPhone 5S and iPhone 5C models in China.

7.0.6 	11B651 	February 21, 2014 	Fix for an SSL connection verification issue.

7.1 	11D167

11D169 	March 10, 2014 	New features:

Touch ID improvements

CarPlay

Home screen crash fix

Visual updates for the shift and caps lock keys on the keyboard

Refined icons for standard apps

UI redesigns for Phone app and shutdown screen

Performance improvements for iPhone 4

7.1.1 	11D201 	April 22, 2014 	Bug fixes

7.1.2 	11D257 	June 30, 2014 	Bug fixes and improved iBeacon connectivity and stability.

Initial release on iPhone 5C and iPhone 5S

iPhone 5C and iPhone 5S only

Initial release on iPad Air and iPad mini 2

iPhone 4 (GSM) only

## System features

### Design

iOS 7 introduced a complete visual overhaul of the user interface. With "sharper, flatter icons, slimmer fonts, a new slide-to-unlock function, and a new control panel that slides up from the bottom of the screen for frequently accessed settings," the operating system also significantly redesigned the standard pre-installed apps from Apple. Jonathan Ive, Apple's head of design, commented that "There is a profound and enduring beauty in simplicity, in clarity, in efficiency. True simplicity is derived from so much more than just the absence of clutter and ornamentation - it's about bringing order to complexity. iOS 7 is a clear representation of these goals. It has a whole new structure that is coherent and applied across the entire system." The background colour of the Boot screen matches the device's front bezel colour of white or black, with the oppositely coloured brand logo.

### AirDrop

iOS 7 introduced AirDrop, a wireless sharing technology accessible from the share icon, which lets users send files from their local device to other, nearby [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices. It can be enabled in the Control Center, with options for controlling its discovery by other devices, including Off, Contacts Only, and Everyone.

At launch, AirDrop was only available on the iPhone 5 and later, fourth-generation iPad and later, all iPad Minis, and the fifth-generation iPod Touch.

### Control Center

iOS 7 introduced the Control Center, a menu that users can access by swiping up from the bottom of the screen, providing access to frequently used settings such as Airplane Mode, Wi-Fi, Bluetooth, Do Not Disturb Mode, and Rotation Lock. There is a slider for adjusting screen brightness, controls for music playback, along with a volume slider. A Flashlight toggle is also available, as is an icon for quickly accessing the camera.

### Notification Center

iOS 7 overhauled the Notification Center, with both visual and functional changes. It has three tabs; "Today" (information on what's coming during the day), "All," and "Missed." Notifications are now visible on the phone's lock screen, and notifications are synchronized across devices, so users don't need to dismiss the same notification multiple times on different devices.

### App switcher

iOS 7 expanded the screen for app switching. Users double-pressed the home button and were taken out of the current app for a view of full-screen thumbnails of recently accessed apps.

### CarPlay

CarPlay (formerly [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) in the Car), released as part of iOS 7.1, integrates with selected car models to offer phone interaction, including music controls and Maps navigation, through the car's display. Users can also talk to Siri to send messages hands-free. It supports all Lightning-equipped iPhones with [iOS 7.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) or later.

### Siri

Siri features a new design where the assistant fades in with the background app being blurred. While speaking, visual vocal waves appear, that form into a spinning circle as the device communicates with Apple's servers. Siri can now control a limited set of device settings, including Bluetooth. The assistant can alternatively send the user directly to the settings menu if their query cannot be controlled by voice, or otherwise, displays an error if the request can't be processed. For searching the Internet, Bing became the default search engine, and Siri's web resources were expanded to include Wikipedia. Siri was also more deeply connected into Twitter, offering full tweet search.

iOS 7 also allowed the user to change Siri's gender, with new options for male and female voices.

### Other

Spotlight search is accessed by holding and dragging down the home screen.

iOS 7 came with new wallpapers that included a "Parallax" effect; the icons appear to be moving as the user moves the phone around, producing an "illusion that the icons are floating above the background wallpaper".

In Settings, users have the option to make custom vibrations for certain types of notifications, turn off the parallax wallpaper animation effect using a Reduce Motion setting, and block callers, with the block applying across multiple devices and apps, including Phone, Messages, and FaceTime.

On the home screen, newly installed apps and recently updated apps have a blue dot next to them until the user opens the app for the first time.

Folders are updated to incorporate different pages, similar to the home screen layout, allowing for a significant expansion of folder functionality. Each page of a folder can contain up to nine apps, and there can be 15 pages in total, allowing for a total of 135 apps in a single folder.

## App features

### App Store

The App Store received several significant changes in iOS 7. Users can enable automatic app updates. Users can now view a history of updates to each installed app. With location services enabled, the App Store has a Near Me tab that recommends popular apps based on the user's geographic location. It also became possible to download older versions of apps, in case new [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) versions left older devices incompatible for system updates, allowing users to maintain a working copy of the last supported update of each app.

### Photos and Camera

iOS 7 introduced a square photo mode for the Camera app, enabling "Instagram-style photos". Also new are live filters; nine different filter options that each change the photo's appearance. Further improvements to the camera included the ability to pinch-to-zoom during video recording, and a Burst mode for easily taking successive photos by holding the shutter button, causing the phone to take 10 frames per second.[42] On the iPhone 5S, a slow-motion video option was added, with the ability to shoot a video at a high frame rate of 120 frames per second. All iPhones record slow motion video with audio. It can be edited in the Photos app, where users can decide where to start and end the slow-motion part.

The Photos app was updated with new categorization options. Three tabs on the bottom, "Photos," "Shared," and "Albums," each open to different app sections featuring galleries. On the main Photos interface, the app displays a timeline of all photos, sorted into "Years," "Collections," and "Moments." Filters were added, allowing users to choose from several types of filters to add to their photos. Alongside existing options for sharing pictures, the app was updated with support for the new AirDrop functionality.

### Camera user interface

The iOS 7 camera user interface has been redesigned. Elements such as the shutter button use flat design with simple geometrical shapes.

Switching between the camera modes is done using swiping gestures or tapping on the name of the mode (text) near the on-screen shutter button.

The camera user interfaces of all succeeding [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) versions are based on this layout and design introduced in iOS 7.

### Camera controls

The redesigned camera interface offers new controls for adjusting exposure value and locking the autofocus.

Tapping inside the viewfinder adjusts the focus and exposure to that area in the camera's field of view. In order to hold (lock) the current focus and exposure state, the desired location inside of the viewfinder can be tapped and held down for half a second. This is known as the AE/AF lock or AF/AE lock.

After tapping, with or without locked focus/exposure, the exposure value can be adjusted by swiping up or down. In case AE/AF lock is activated, the exposure will be fixed indefinitely until unlocked manually.

These controls are also available during both normal and slow motion (high frame rate) video recording and also for both front camera photo and front camera video modes.

### Music

The Music app integrated Apple's iTunes Radio service; a station-based music service that let users choose an artist, with the service generating a "station" based on that and similar artists' songs. Users were able to skip songs and search through the history of previous songs, in addition to being able to purchase the songs directly from the iTunes Store while playing. iTunes Radio also had a feature that showed songs currently trending on Twitter. iTunes Radio was free and ad-supported, but users could subscribe to iTunes Match, that enabled ad-free playback.

After more than two years of release, iTunes Radio was eventually discontinued in January 2016, with the features moving to the new Apple Music music subscription service and Beats 1 radio station.

### Safari

In iOS 7, the Safari web browser received multiple significant updates. The two search bars found in previous iterations of the browser have been combined into a single "Smart Search" field. Tab management was improved to allow more than eight open tabs at once, as well as stacking tabs on top of each other vertically as opposed to a horizontal card view. The option to enter a Private tab was built into the app itself rather than in Settings menus, and a new "Do Not Track" button allows the user to further manage their privacy levels.

### Maps

Apple Maps now features turn-by-turn walking directions.

The design of Maps was updated to feature a full-screen view, where interface elements such as the search bar disappear from view, alongside new translucent search and lower toolbars, and a Night Mode that automatically activates when users drive at night. A separate Siri volume control is available in Maps, enabling users to "change the relative volume of Siri's voice feedback independently of the system volume, so it doesn't shout too loud over your background music."

### Weather

The Weather app on iOS 7 received significant changes, including a new icon, the absence of a static weather indicator on the app thumbnail on the home screen, and new dynamic, visual representations of the current weather.

### FaceTime

iOS 7 has its own FaceTime app on iPhone, with FaceTime Audio, a feature that allows users to call while on Wi-Fi. FaceTime Audio is accessible from the Phone app, the Contacts app, or the FaceTime app itself. It is available on devices running iOS 7 or later.

### Messages

The Messages app allows users to see timestamps for every message they have sent or received.

## Reception

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/07/Letterpress_screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/07/Letterpress_screenshot.png)

_The Verge wrote that the 2013 [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) redesign's flat, minimalist design language was informed by apps including the 2013 word game Letterpress (pictured)._

The reception of iOS 7 was mixed. Mark Rogowsky of Forbes criticized multiple aspects of the new design, including the 3D effect on the home screen wallpaper, writing that "the interaction between iOS 7 and the screen background is challenging at best", and writing that the new overall design language for the operating system "now has your icons fly into the screen whenever you unlock it like some kind of videogame effect. It's pointless, delays your access to the phone by a fraction of a second and is arguably distracting". Joshua Topolsky of The Verge also criticized the design, noting lack of icon consistency in different parts of the OS, as well as writing that "instead of correcting issues with the notification panel and alerts, Apple has simply given them a fresh coat of paint and several layers of sub-navigation [...] doing nothing to actually speed up your productivity on the device."

The Nielsen Norman Group, a research company, wrote an extensive report on the user-experience of iOS 7, summarizing the report as "Flat design hides calls to action, and swiping around the edges can interfere with carousels and scrolling."

David Pogue of The New York Times, however, liked the minimalist design of iOS 7, writing that "The longer you spend with the new OS, the more you're grateful for the fixing and de-annoyifying on display," and that "you can swipe upward from the bottom of the screen to open the Control Center: a compact, visual palette of controls for the settings and functions you're most likely to need." He also praised the improvements to the Siri voice assistant, writing that Siri "is much better." He concluded by writing: "The structure, layout, and features represent some of Apple's best work. The look of iOS 7 — well, that judgment is up to you."

Darrell Etherington of TechCrunch focused on many of the new features introduced, praising the Control Center as being "incredibly useful", AirDrop as being "great" (although noting the lack of interoperability between [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and Mac at the time), Siri as being "more generally useful", and the new multitasking features as "smarter", with the multitasking screen being "much better". In conclusion, he wrote that "There's no question that iOS 7 will be a dramatic change from the iOS many users already know and love, but on balance it's an update packed with plenty of new features that make using Apple's mobile devices easier and more enjoyable".

Some critics noted the influence of competition from other mobile platforms on the design and functionality of iOS 7. Of note were the use of concepts from Android and Windows Phone, such as a similarly minimal and typographic design, Control Center being an equivalent to similar settings toggles on the notification shade of Android, a similar multitasking menu to WebOS, and even the design of the Weather app being almost identical to those on Windows 8 and HTC Sense. Sascha Segan of PC Magazine stated that "Apple's brilliance is in putting the pieces together and marketing them. Apple's developer APIs and its history of making money for developers still reign supreme—there's less piracy than on Android, and a bigger audience and more design flexibility than on Windows Phone."

The adoption rate of iOS 7 was reported to be as high as 35% after one day. Within five days, iOS 7 was installed on more than 200 million devices, which Apple claimed was "the fastest software upgrade in history." In August [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), it was reported that 91% of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) devices ran iOS 7 at the time.

## Problems

### Design causing sickness

In September [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), Pranav Dixit of Fast Company reported about user complaints shared on Apple's support forums that the new design of iOS 7, including "many zoom animations while multitasking and opening and closing apps, in addition to a slight parallax effect" were causing users to feel sick. Dixit noted that while the parallax effect could be turned off, most animations did not have such an option.

Dr. George Kikano, "division chief of family medicine at UH Case Medical Center in Ohio," told Fox News that "There's some validity to this, for people who are susceptible." Fox News wrote that Dr. Kikano said "It's a new "parallax" function that causes the background of the phone to subtly move back and forth, a feature that leads to an effect not unlike car sickness. The inner ear is responsible for balance, the eyes for vision. When things are out of sync you feel dizzy, nauseous. Some people get it, some people don't, and some people get used to it."

### Battery drain

Adrian Kingsley-Hughes of ZDNet wrote in March 2014 that iPhone and iPad users reported battery drain with the [iOS 7.1](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/) update. In lab testing, Andrew Cunningham of Ars Technica found some hardware models experienced minor battery depletion, while others experienced no statistically significant changes.

### Lock screen bypass

Dom Esposito of 9to5Mac reported in June 2014 that a new lock screen bypass method had been discovered in iOS 7, allowing access to the phone in "5 seconds under certain circumstances". The issue was later fixed.

## Hoaxes

During the iOS 7 release, fake advertisements claimed that the update would cause devices to become waterproof, and that AirDrop was a mechanism for protecting the device's screen from breaking when dropped.

## Supported devices

With this release, Apple dropped support for older devices, specifically the iPhone 3GS and the fourth-generation iPod Touch.

**iPhone**

iPhone 4

iPhone 4S

iPhone 5

iPhone 5C

iPhone 5S

**iPod Touch**

iPod Touch (5th generation)

**iPad**

iPad 2

iPad (3rd generation)

iPad (4th generation)

iPad Air

iPad Mini (1st generation)

iPad Mini 2
    
**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## Sources

[Wikipedia - iOS 7](https://en.wikipedia.org/wiki/IOS_7/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Saturday September 25th at 5:33 pm`

**Last revised on:** `2021 Saturday September 25th at 5:33 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Saturday September 25th at 5:33 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

