  
***

# NeXT (company)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/NeXT_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/NeXT_logo.svg)

_Not to be confused with [NeXTSTEP (Operating system)](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP)_

NeXT, Inc. (later NeXT Computer, Inc. and NeXT Software, Inc.) was an American computer and software company founded in [1985](https://github.com/seanpm2001/WacOS/wiki/1985/) by Apple Computer co-founder [Steve Jobs](https://github.com/seanpm2001/WacOS/wiki/Steve_Jobs/). Based in Redwood City, California, the company developed and manufactured a series of computer workstations intended for the higher education and business markets. NeXT was founded by Jobs after he was forced out of Apple, along with several co-workers. NeXT introduced the first NeXT Computer in [1988](https://github.com/seanpm2001/WacOS/wiki/1988/), and the smaller NeXTstation in [1990](https://github.com/seanpm2001/WacOS/wiki/1990/). The NeXT computers experienced relatively limited sales, with estimates of about 50,000 units shipped in total. Nevertheless, their innovative object-oriented [NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP/) operating system and development environment (Interface Builder) were highly influential.

The first major outside investment was from Ross Perot, who invested after seeing a segment about NeXT on a [1986](https://github.com/seanpm2001/WacOS/wiki/1986/) PBS documentary titled Entrepreneurs. In [1987](https://github.com/seanpm2001/WacOS/wiki/1987/), he invested $20 million in exchange for 16 percent of NeXT's stock and subsequently joined the board of directors in [1988](https://github.com/seanpm2001/WacOS/wiki/1988/).

NeXT later released much of the NeXTSTEP system as a programming environment standard called [OpenStep](https://github.com/seanpm2001/WacOS/wiki/OPENSTEP/). NeXT withdrew from the hardware business in 1993 to concentrate on marketing OPENSTEP for Mach, its own OpenStep implementation, for several original equipment manufacturers (OEMs). NeXT also developed WebObjects, one of the first enterprise web application frameworks. WebObjects never became very popular because of its initial high price of $50,000, but it remains a prominent early example of a Web server based on dynamic page generation rather than on static content.

Apple purchased NeXT in 1997 for $429 million and 1.5 million shares of Apple stock. The merger converted Steve Jobs from Chairman and CEO of NeXT to an advisory role at Apple, the company he had co-founded in 1976; and it promised to port NeXT's operating system to Macintosh hardware, combine it with the legacy application layer of Mac OS, and yield [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/). In following decades, the new operating system was renamed [OS X](https://github.com/seanpm2001/WacOS/wiki/OS-X-Version-history/) and then later [macOS](https://github.com/seanpm2001/WacOS/wiki/MacOS/) and was adapted into the embedded multimedia platforms of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), [watchOS](https://github.com/seanpm2001/WacOS/wiki/watchOS/), and [tvOS](https://github.com/seanpm2001/WacOS/wiki/tvOS/) to serve as the basis of Apple's later hardware lines: iPhone, iPad, Apple Watch, and Apple TV.

## History

### Background

In [1985](https://github.com/seanpm2001/WacOS/wiki/1985/), Apple co-founder Steve Jobs led Apple's SuperMicro division, which was responsible for the development of the Macintosh and Lisa personal computers. The Macintosh had been successful on university campuses partly because of the Apple University Consortium, which allowed students and institutions to buy the computers at a discount.  The consortium had earned more than $50 million on computers by February [1984](https://github.com/seanpm2001/WacOS/wiki/1984/).

Jobs visited university departments and faculty members to sell Macintosh. Jobs met Paul Berg, a Nobel Laureate in chemistry, at a luncheon held in Silicon Valley to honor François Mitterrand, then President of France. Berg was frustrated by the time and expense of researching recombinant DNA via wet laboratories, and suggested that Jobs should use his influence at Apple to create for higher education a "3M computer", a term for a workstation with one megabyte of random-access memory (RAM), a one-megapixel display, and one megaFLOPS of CPU performance.

Jobs was intrigued by Berg's concept of a workstation and contemplated starting a higher education computer company in late 1985, amid increasing turmoil at Apple. Jobs's division did not release upgraded versions of the Macintosh and much of the Macintosh Office system. As a result, sales plummeted, and Apple was forced to write off millions of dollars in unsold inventory. Apple's chief executive officer (CEO) John Sculley ousted Jobs from his day-to-day role at Apple, replacing him with Jean-Louis Gassée in 1985.  Later that year, Jobs began a power struggle to regain control of the company. The board of directors sided with Sculley while Jobs took a business trip to Western Europe and the Soviet Union on behalf of Apple.

### Original NeXT team

After several months of being sidelined, Jobs resigned from Apple on September 13, 1985. He told the board he was leaving to set up a new computer company, and that he would be taking several Apple employees from the SuperMicro division with him. He also told the board that his new company would not compete with Apple and might even consider licensing its designs back to them to market under the Macintosh brand.

A number of former Apple employees followed him to NeXT, including Joanna Hoffman, Bud Tribble, George Crow, Rich Page, Susan Barnes, Susan Kare, and Dan'l Lewin. After consulting with major educational buyers from around the country, including a follow-up meeting with Paul Berg, a tentative specification for the workstation was drawn up. It was designed to be powerful enough to run wet lab simulations and cheap enough for college students to use in their dormitory rooms. Before the specifications were finished, however, Apple sued NeXT for "nefarious schemes" to take advantage of the cofounders' insider information. Jobs remarked, "It is hard to think that a $2 billion company with 4,300-plus people couldn't compete with six people in blue jeans." The suit was eventually dismissed before trial.

In 1986, Jobs recruited the famous graphic designer Paul Rand to create a brand identity for $100,000. Jobs recalled, "I asked him if he would come up with a few options, and he said, 'No, I will solve your problem for you and you will pay me. You don’t have to use the solution. If you want options go talk to other people.'" Rand created a 20-page brochure detailing the brand, including the precise angle used for the logo (28°) and a new company name spelling, NeXT.

### 1987–93: NeXT Computer

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/First_Web_Server.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/First_Web_Server.jpg)

This original NeXT Computer was used by Tim Berners-Lee at CERN, and became the world's first Web server and ran the world's first Web browser in 1990.

I want some kid at Stanford to be able to cure cancer in his dorm room.

Steve Jobs, on the purpose of the new NeXT cube

NeXT changed its business plan in mid-1986. The company decided to develop both computer hardware and software, instead of just a low-end workstation. A team led by Avie Tevanian, who was a Mach kernel engineer at Carnegie Mellon University, was to develop the [NeXTSTEP operating system](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP/). The hardware division, led by Rich Page—one of NeXT's cofounders who had previously led Apple's Lisa team—designed and developed the hardware. NeXT's first factory was completed in Fremont, California, in 1987.  It was capable of producing 150,000 machines per year.  NeXT's first workstation is officially named the NeXT Computer, nicknamed "the cube" because of its distinctive magnesium one-foot (30 cm) cubic case, designed by Apple IIc case designer Frogdesign in accordance with an edict from Jobs.

The original design team had anticipated completing the computer in early 1987 to be ready for sale for US$3,000 by midyear. The NeXT Computer received standing ovations when revealed at a lavish, invitation-only gala event, "NeXT Introduction – the Introduction to the NeXT Generation of Computers for Education" at the Louise M. Davies Symphony Hall, in San Francisco, California, on October 12, 1988. The following day, selected educators and software developers were invited (for a $100 registration fee) to attend the first public technical overview of the NeXT computer at an event called "The NeXT Day" held at the San Francisco Hilton. This event gave developers interested in developing NeXT software an insight into the software architecture, object-oriented programming, and developing for the NeXT Computer. The luncheon speaker was Steve Jobs.

The first machines were tested in 1989, after which NeXT started selling limited numbers to universities with a beta version of the NeXTSTEP operating system installed. Initially the NeXT Computer was targeted at U.S. higher education establishments only, with a base price of US$6,500 (equivalent to $13,571 in 2020). The machine was widely reviewed in magazines, generally concentrating on the hardware. When asked if he was upset that the computer's debut was delayed by several months, Jobs responded, "Late? This computer is five years ahead of its time!"

The NeXT Computer was based on the 25 MHz Motorola 68030 central processing unit (CPU). The Motorola 88000 RISC chip was originally considered, but was not available in sufficient quantities. It includes between 8 and 64 MB of random-access memory (RAM), a 256 MB magneto-optical (MO) drive, a 40 MB (swap-only), 330 MB, or 660 MB hard disk drive, 10BASE2 Ethernet, NuBus, and a 17-inch MegaPixel grayscale display measuring 1120 by 832 pixels. In 1989 a typical new PC, Macintosh, or Amiga computer included a few megabytes of RAM, a 640×480 16-color or a 320x240 4,096-color display, a 10- to 20-megabyte hard drive, and few networking capabilities. It is the first computer to have shipped with a general-purpose DSP chip (Motorola 56001) on the motherboard. This supports sophisticated music and sound processing, including the Music Kit software.

The magneto-optical drive manufactured by Canon Inc. is the primary mass storage device. This drive technology was relatively new to the market, and the NeXT is the first computer to have used it. MO drives were cheaper but much slower than hard drives; Jobs negotiated Canon's cost of $150 per blank MO disk down to a retail cost of only $50, and they have an average seek time of 96 ms. The design makes it impossible to move files between computers without a network, because each NeXT Computer has only one MO drive and the disk can not be removed without shutting down the system. Storage options proved challenging for the first NeXT Computers. The drive's limitations of speed and capacity make it insufficient as the primary medium running the NeXTSTEP operating system.

In 1989, NeXT struck a deal for former Compaq reseller Businessland to sell the NeXT Computer in select markets nationwide. Selling through a retailer was a major change from NeXT's original business model of only selling directly to students and educational institutions. Businessland founder David Norman predicted that sales of the NeXT Computer would surpass sales of Compaq computers after 12 months.

In 1989, Canon invested US$100 million in NeXT, giving it a 16.67 percent stake and making NeXT worth almost $600 million. Canon invested in NeXT with the condition of using the NeXTSTEP environment with its own workstations, which would mean a greatly expanded market for the software. After NeXT exited the hardware business, Canon produced a line of PCs called object.station, including models 31, 41, 50, and 52, specifically designed to run NeXTSTEP for Intel. Canon also served as NeXT's distributor in Japan.

The NeXT Computer was first released on the retail market in 1990, for US$9,999 (equivalent to $19,807 in 2020). NeXT's original investor Ross Perot resigned from the board of directors in June 1991 to dedicate more time to Perot Systems, a Plano, Texas-based systems integrator.

### Second generation

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/NeXTstation.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXT/NeXTstation.jpg)

A NeXTstation with the original keyboard, mouse and the NeXT MegaPixel monitor

NeXT released a second generation of workstations in 1990. The new range includes a revised NeXT Computer, renamed the NeXTcube, and the NeXTstation, nicknamed "the slab" for its form-factor of a low-rise box. Jobs explicitly ensured that NeXT staff did not use the nickname "pizza box", so that the NeXT machines would not be compared to competing Sun workstations which already had that nickname. The magneto-optical drive was replaced with a 2.88 MB floppy drive but 2.88 MB floppy disks were expensive and the technology failed to supplant the 1.44 MB floppy. Realizing this, NeXT utilized the CD-ROM drive, which eventually became an industry standard for storage. Color graphics were available on the NeXTstation Color and on the NeXTdimension graphics processor hardware for the NeXTcube. The new computers were cheaper and faster than their predecessors, with the new Motorola 68040 processor.

In 1992, NeXT launched "Turbo" variants of the NeXTcube and NeXTstation, with a 33 MHz 68040 processor and the maximum RAM capacity increased to 128 MB. NeXT sold 20,000 computers in 1992, and NeXT counted upgraded motherboards on back order as system sales. This is a small number compared with competitors, but the company reported sales of $140 million for the year which encouraged Canon to invest a further $30 million to keep the company afloat.

    In its existence, Next has sold a total of 50,000 copies of Nextstep, says Jobs. It's not much of an installed base, so he predicts the company will ship 50,000 Nextstep packages in 1993. But Next needs to increase its volume three-fold in order to build enough momentum to forestall Microsoft and Taligent in the object-oriented software business.

### UnixWorld, April 1993

In total, 50,000 NeXT machines were sold, including thousands to the then super secret National Reconnaissance Office located in Chantilly, Virginia. NeXT's long-term plan was to migrate to the emerging high-performance industry standard Reduced Instruction Set Computing (RISC) architecture, with the NeXT RISC Workstation (NRW). Initially the NRW was to be based on the Motorola 88110 processor, but due to a lack of confidence in Motorola's commitment to the 88000-series architecture in the time leading up to the AIM alliance's transition to PowerPC, it was later redesigned around dual PowerPC 601s. NeXT produced some motherboards and enclosures, but exited the hardware business before full production.

### Software applications

NeXT computers were delivered with Mathematica pre-installed. Several developers used the NeXT platform to write pioneering programs. Tim Berners-Lee used a NeXT Computer in 1990 to create the first Web browser and Web server; accordingly, NeXT was instrumental in the development of the World Wide Web.

NeXT systems were used by professors for scientific and engineering applications, and for developing finished newspaper layouts using News. George Mason University in the early 1990s had a set of NeXT workstations for publishing, as well as Silicon Graphics for CAD/GL and Mathematica for astrophysics. The games Doom, Doom II: Hell on Earth, and Quake were developed by id Software on NeXT machines. Other games based on the Doom engine, such as Heretic and Hexen: Beyond Heretic by Raven Software, as well as Strife by Rogue Entertainment, were also developed on NeXT hardware using id's tools.

Other commercial programs were released for NeXT computers, including Altsys Virtuoso, a vector drawing program with page-layout features which was ported to Mac OS and Microsoft Windows as Aldus FreeHand v4, and the Lotus Improv spreadsheet program. The systems were bundled with a number of smaller built-in applications, such as the Merriam-Webster Collegiate Dictionary, Oxford Quotations, the complete works of William Shakespeare, and the Digital Librarian search engine to access them.

### 1993–96: NeXT Software, Inc.

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXTSTEP/NeXTSTEP_desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/NeXTSTEP/NeXTSTEP_desktop.png)

[NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP/), the operating system used by the NeXTcube and NeXTstation

NeXT started porting the [NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP/) operating system to IBM PC compatible computers using the Intel 80486 processor in late 1991 because of a change in business strategy to withdraw from the hardware business entirely. A demonstration of the port was displayed at the NeXTWorld Expo in January 1992. By mid-1993 the product was complete and version 3.1, also known as NeXTSTEP 486, was released. Prior to this release, Chrysler planned to buy 3,000 copies in 1992.

NeXTSTEP 3.x was later ported to PA-RISC and SPARC-based platforms, for a total of four versions: NeXTSTEP/NeXT (for NeXT's own hardware), NeXTSTEP/Intel, NeXTSTEP/PA-RISC, and NeXTSTEP/SPARC. Although the three other ports were not widely used, NeXTSTEP gained popularity at institutions such as First Chicago NBD, Swiss Bank Corporation, O'Connor and Company, and other organizations owing to its programming model. It was used by many American federal agencies, such as United States Naval Research Laboratory, the National Security Agency, the Advanced Research Projects Agency, the Central Intelligence Agency, and the National Reconnaissance Office. Some IBM PC clone vendors offered somewhat customized hardware solutions that were delivered running NeXTSTEP on Intel, such as the Elonex NextStation and the Canon object.station 41.

NeXT withdrew from the hardware business in 1993 and the company was renamed NeXT Software, Inc.; consequently, 300 of the 540 staff employees were laid off. NeXT negotiated to sell the hardware business, including the Fremont factory, to Canon which later pulled out of the deal. Work on the PowerPC machines was stopped, along with all hardware production. CEO of Sun Microsystems Scott McNealy announced plans to invest $10 million in 1993 and use NeXT software in future Sun systems. NeXT partnered with Sun to create OpenStep which is NeXTSTEP's application layer hosted on a third party operating system.

After exiting the hardware business, NeXT focused on other operating systems, in effect returning to the original business plan. New products based on OpenStep were released, including OpenStep Enterprise, a version for Microsoft's Windows NT. The company launched WebObjects, a platform for building large-scale dynamic web applications. Many large businesses, including Dell, Disney, WorldCom, and the BBC, used WebObjects for a short time. Eventually WebObjects was used solely to power Apple's iTunes Store and most of its corporate website, until the software was discontinued.

### 1996–97: purchase by Apple

We went for one of our, you know, signature Steve Jobs walks around Palo Alto, and ... we happened to see someone who was in that meeting from the [Apple] management team who said, 'You guys won easily, no problem. You have nothing to worry about.'

Avie Tevanian, presenting NeXT versus Be to Apple

Apple Computer announced the intention to acquire NeXT on December 20, 1996. Apple paid $429 million in cash, which went to the initial investors and 1.5 million Apple shares, which went to Steve Jobs, who was deliberately not given cash for his part in the deal. The main purpose of the acquisition was to use NeXTSTEP as a foundation to replace the dated classic Mac OS, instead of BeOS or the in-development Copland. The deal was finalized on February 7, 1997, bringing Jobs back to Apple as a consultant, who was later appointed as interim CEO. In 2000, Jobs took the CEO position as a permanent assignment, holding the position until his resignation on August 24, 2011; Jobs died six weeks later on October 5, 2011 from complications of a relapsed pancreatic neuroendocrine tumor.

Several NeXT executives replaced their Apple counterparts when Steve Jobs restructured the company's board of directors. Over the next five years the NeXTSTEP operating system was ported to the PowerPC architecture. At the same time, an Intel port and OpenStep Enterprise toolkit for Windows were both produced. That operating system is code named [Rhapsody](https://github.com/seanpm2001/WacOS/wiki/Rhapsody/), while the crossplatform toolkit is called "Yellow Box". For backward compatibility Apple added the "Blue Box" to [Rhapsody](https://github.com/seanpm2001/WacOS/wiki/Rhapsody/), allowing existing Mac applications to be run in a self-contained cooperative multitasking environment.

A server version of the new operating system was released as Mac OS X Server 1.0 in 1999, and the first consumer version, Mac OS X 10.0, in 2001. The OpenStep developer toolkit was renamed Cocoa. [Rhapsody's](https://github.com/seanpm2001/WacOS/wiki/Rhapsody/) Blue Box was renamed Classic Environment and changed to run applications full-screen without requiring a separate window. Apple included an updated version of the original Macintosh toolbox, called Carbon, that gave existing Mac applications access to the environment without the constraints of Blue Box. Some of NeXTSTEP's interface features are used in Mac OS X, including the Dock, the Services menu, the Finder's "Column" view, and the Cocoa text system.

NeXTSTEP's processor-independent capabilities were retained in Mac OS X, leading to both PowerPC and Intel x86 versions (although only PowerPC versions were publicly available before 2006). Apple moved to Intel processors by August 2006.

### Corporate culture and community

Jobs created a different corporate culture at NeXT in terms of facilities, salaries, and benefits. Jobs had experimented with some structural changes at Apple but at NeXT he abandoned conventional corporate structures, instead making a "community" with "members" instead of employees. There were only two different salaries at NeXT until the early 1990s. Team members who joined before 1986 were paid US$75,000 (equivalent to $177,072 in 2020) and those who joined afterward were paid US$50,000 (equivalent to $118,048 in 2020). This caused a few awkward situations where managers were paid less than their employees. Employees were given performance reviews and raises every six months because of the spartan salary plans. To foster openness, all employees had full access to the payrolls, although few employees ever took advantage of the privilege. NeXT's health insurance plan offered benefits to not only married couples but unmarried couples and same-sex couples, although the latter privilege was later withdrawn due to insurance complications.[8]: 80  The payroll schedule was also very different from other companies in Silicon Valley at the time because instead of being delivered twice a month in arrears at the end of the pay period, it was delivered once a month in advance.

Jobs found office space in Palo Alto, California, at 3475 Deer Creek Road, occupying a glass-and-concrete building which featured a staircase designed by architect I. M. Pei. The first floor used hardwood flooring and large worktables where the workstations would be assembled. To avoid inventory errors, NeXT used the just-in-time (JIT) inventory strategy. The company contracted out for all major components such as mainboards and cases and had the finished components shipped to the first floor for assembly. The second floor was the office space with an open floor plan. The only enclosed rooms were Jobs's office and a few conference rooms.

As NeXT expanded, more office space was needed. The company rented an office at 800 and 900 Chesapeake Drive in Redwood City, also designed by Pei. The architectural centerpiece was a "floating" staircase with no visible supports. The open floor plan was retained, although furnishings became luxurious, with $5,000 chairs, $10,000 sofas, and Ansel Adams prints.

NeXT's first campus in Palo Alto was subsequently occupied by Internet Shopping Network (a subsidiary of Home Shopping Network) in 1994, and later by SAP AG. Its second campus in Redwood City was occupied by ApniCure and OncoMed Pharmaceuticals Inc.

The first issue of NeXTWORLD magazine was printed in 1991. It was published in San Francisco by Integrated Media and edited by Michael Miley and later Dan Ruby. It was the only mainstream periodical to discuss NeXT computers, the operating system, and NeXT software. The publication was discontinued in 1994 after only four volumes. A NeXTWORLD Expo followed as a developer conference, held in 1991 and 1992 at the San Francisco Civic Center and in 1993 and 1994 at the Moscone Center in San Francisco, with Steve Jobs as the keynote speaker.

### Legacy

Though not very profitable, the company had a wide-ranging impact on the computer industry. Object-oriented programming and graphical user interfaces became more common after the 1988 release of the NeXTcube and NeXTSTEP. The technologically successful platform was often held as the trendsetter when other companies started to emulate the success of NeXT's object-oriented system.

Widely seen as a response to NeXT, Microsoft announced the Cairo project in 1991; the Cairo specification included similar object-oriented user interface features for a coming consumer version of Windows NT. Although Cairo was ultimately abandoned, some elements were integrated into other projects. By 1994, Microsoft and NeXT were collaborating on a Windows NT port of OpenStep which was never released.

By 1993, Taligent was considered by the press to be a competitor in objects and operating systems even without any product release, with NeXT being a main point of comparison. For the first few years, Taligent's theoretical newness was often compared to NeXT's older but mature and commercially established platform, but Taligent's debut release in 1995 was called "too little, too late" especially compared to NeXT.

WebObjects failed to achieve wide popularity partly because of the initial high price of US$50,000, but it remains the first and most prominent early example of a web application server that enabled dynamic page generation based on user interactions as opposed to static content. WebObjects had been bundled with macOS Server and Xcode, but was removed in 2009 and discontinued as of 2016.

**This article is a modified copy of its Wikipedia counterpart and needs to be rewritten for originality.**

***

## See also

[NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP/) - The main software project of NeXT and the predecessor to OPENSTEP and Mac OS X

[OPENSTEP](https://github.com/seanpm2001/WacOS/wiki/OPENSTEP/) - The successor to NeXTSTEP and the codebase for the majority of future Apple projects, including Mac OS X, OS X, Modern MacOS, iPhoneOS, iOS, iPadOS, and more.

[Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C/) - The language used in NeXTSTEP

[Mac OS X 10.0 (Cheetah)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) - The successor to OPENSTEP

[NeXT Character set](https://github.com/seanpm2001/WacOS/wiki/NeXT-character-set/) - The character set used by NeXT and NeXTSTEP.

***

## Sources

[Wikipedia - NeXT](https://en.wikipedia.org/wiki/NeXT)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Saturday September 25th at 2:30 pm`

**Last revised on:** `2021 Saturday September 25th at 2:30 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Saturday September 25th at 2:30 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

