  
***

# MacOS 10.12 (Sierra)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_wordmark.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_Desktop.png)

( **Predecessor:** [OS X 10.11 (El Capitan))](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-11-El-Capitan/) | **Successor:** [MacOS 10.13 (High Sierra)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-13-High-Sierra/) )

macOS Sierra (version 10.12) is the thirteenth major release of macOS (formerly known as [OS X](https://github.com/seanpm2001/WacOS/wiki/OS-X-version-history/) and [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-version-history/)), Apple Inc.'s desktop and server operating system for Macintosh computers. The name "macOS" stems from the intention to uniform the operating system's name with that of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/), watchOS and tvOS. Sierra is named after the Sierra Nevada mountain range in California and Nevada. Its major new features concern Continuity, iCloud, and windowing, as well as support for Apple Pay and Siri.

The first beta of macOS Sierra was released to developers shortly following the 2016 WWDC keynote on June 13, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/). The first public-beta release followed on July 7, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/). It was released to end users on September 20, [2016](https://github.com/seanpm2001/WacOS/wiki/2016/), as a free upgrade through the Mac App Store and it was succeeded by [macOS High Sierra](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-13-High-Sierra/) on September 25, [2017](https://github.com/seanpm2001/WacOS/wiki/2017/).

## System requirements

macOS Sierra requires at least 2 GB of RAM and 8 GB of storage space and will run on:

iMac: Late 2009 or newer

MacBook and MacBook 12-inch: Late 2009 or newer

MacBook Pro: Mid 2010 or newer

MacBook Air: Late 2010 or newer

Mac Mini: Mid 2010 or newer

Mac Pro: Mid 2010 or newer

Xserve is no longer compatible.

Sierra is the first version of macOS since [OS X Mountain Lion](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/), released in [2012](https://github.com/seanpm2001/WacOS/wiki/2012/), that does not run on all computers that the previous version supported. Developers have created workarounds to install macOS Sierra on some Mac computers that are no longer officially supported as long as they are packed with a CPU that supports SSE4.1. This requires using a patch to modify the install image.

## Changes

The default desktop picture is an image of Lone Pine Peak.

## System features

### Siri

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/Siri_for_macOS_Sierra_Demo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/Siri_for_macOS_Sierra_Demo.png)

_A demonstration of Siri on macOS Sierra Beta_

The user can access the Siri intelligent assistant via the Dock, the menu bar or a keyboard shortcut and results are shown in a window in the upper-right corner. Siri can send messages, search the web, find files and adjust settings. Results can be dropped into other applications or pinned to Notification Center. For instance, pictures from search results can be dragged into a document.

### iCloud Drive and Optimized Storage

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/Optimized_Storage_Suggestions.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/Optimized_Storage_Suggestions.png)

_This image shows what the Optimized Storage suggestions are_

iCloud Drive can upload the user's documents and desktop directories and sync them to other devices. The System Information application has a new section that gives the user detailed information about space usage per application or file and provides tools and suggestions for freeing up space. For instance, the user can let the system upload old files to iCloud Drive and remove their local copies, keeping them available on-demand in Finder. It can also remove old files from trash automatically. iTunes can delete watched, purchased films and TV programs from its library.

### Auto Unlock and Universal Clipboard

Building upon Continuity, an "umbrella term. features that facilitate the communication between (Apple devices)" using Bluetooth and Wi-Fi, Sierra adds two features. With Auto Unlock, the user can unlock their user account by holding a paired Apple Watch close to the device. Time of flight is used to prevent relay attacks. Auto Unlock requires a Mac that was introduced in [2013](https://github.com/seanpm2001/WacOS/wiki/2013/) or later. With Universal Clipboard, the user can share the clipboard for cut, copy and paste between macOS Sierra and [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/) devices, including text and rich content, such as pictures or videos.

### Tabs and Picture-in-Picture

Applications that support multiple windows can support multiple tabs within a single window, allowing the user to keep windows organized similarly to Safari. With Picture-in-Picture, videos can be played in a window that follows the user across the system.

### Apple File System

Apple released a preview of a new file system in Sierra, called [Apple File System (APFS)](https://github.com/seanpm2001/WacOS/wiki/APFS/), to overcome the limitations of [HFS Plus](https://github.com/seanpm2001/WacOS/wiki/HFS-Plus/). It is intended for solid-state drives and flash memory and will adopt several features found in modern file systems, such as snapshots and cloning, as well as native support for features that Apple already provides in [HFS Plus](https://github.com/seanpm2001/WacOS/wiki/HFS-Plus/) through supplementary software, such as file-system encryption and TRIM support. The file system was released in macOS High Sierra.

### Night Shift

Night Shift is new in macOS 10.12.4, with the same functionality as its iOS counterpart. Night Shift reduces blue light at night to aid sleep. This can be scheduled in the System Preferences app (in the Displays menu) and can be toggled on or off in the Notification Center or using Siri.

Since this feature relies on the Metal framework, Night Shift is not available on all systems that support macOS Sierra.

### Application features

#### Photos

Apple says it has improved the face recognition of the Photos application, adding object and scene recognition. It groups similar pictures together using faces, locations and object recognition to create "memories". Memories contain picture slideshows with transitions and music selected by the algorithm, which can be modified to the user's liking. The "People" album organizes photos by the people in them, and Places shows all photos on a world map.

#### Safari and Apple Pay

Safari provides an "extension point" which enables developers to bundle Safari extensions within their Cocoa applications and communicate with them directly from the applications. Safari conceals the presence of installed "legacy" plug-ins, such as Adobe Flash Player, Java applets, Microsoft Silverlight, and [QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) – from websites and requires the user to enable a specific plug-in on a per-use or per-website basis.

Apple Pay allows vendors to embed an Apple Pay button on their websites. In Safari, users can click the Apple Pay button to check out, then complete a purchase using an iPhone or Apple Watch. Apple Pay requires a Mac that supports Continuity (2012 or later models) and either an iPhone 6 or later with [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/), or an Apple Watch with watchOS 3.

#### Messages

The Messages app adds aesthetic effects to messages, such as three times bigger emojis and click back with hearts or thumbs-up on a message bubble. The ability to play YouTube videos and preview links in a conversation was introduced. Users can view interactive content added to iMessage in [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/). The app also allows you to turn on or off read receipts on a conversation by conversation basis.

#### iTunes

Apple Music within iTunes has been redesigned, making it simpler to find favorite songs and discover new ones. A new "For You" tab has been added, which suggests new music the user might like (similar to the existing Genius). A refined MiniPlayer with the ability to view lyrics while listening has also been introduced.

#### Notes

The Notes app allows the user to share and collaborate on notes. This is done by clicking on a share button at the top of the window.

#### Other changes

Disk Utility regains the ability to format and manage RAID sets, after it was removed in [El Capitan](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-11-El-Capitan/).

Finder has an option to show folders always at the top of the view hierarchy, for instance in list views.

Mail adds a control to the top of email lists to quickly filter them, for instance, by read status or the presence of attachments.

#### Other applications found on macOS 10.12 Sierra

AirPort Utility

App Store

Archive Utility

Audio MIDI Setup

Automator

Bluetooth File Exchange

Boot Camp Assistant

Calculator

Calendar

Chess

ColorSync Utility)

Console

Contacts

Dictionary

Digital Color Meter

DVD Player

FaceTime

Font Book

Game Center

GarageBand (may not be pre-installed)

Grab

Grapher

iBooks (now Apple Books)

iMovie (may not be pre-installed)

iTunes

Image Capture

Ink (can only be accessed by connecting a graphics tablet to your Mac)

Keychain Access

Keynote (may not be pre-installed)

Migration Assistant

Numbers (may not be pre-installed)

Pages (may not be pre-installed)

Photo Booth

Preview

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) Player

Reminders

Script Editor

Stickies

System Information

Terminal

[TextEdit](https://github.com/seanpm2001/WacOS/wiki/TextEdit/)

Time Machine

VoiceOver Utility

X11/XQuartz (may not be pre-installed)

## Security improvements

### Gatekeeper

macOS Sierra slightly changes the Gatekeeper user interface and adds two new mechanisms. A new default in System Preferences hides the "Anywhere" option which allows the user to disable the mechanism and execute programs from any source without needing to approve each new one individually.

The first new mechanism allows developers to code-sign disk images that can be verified as a unit by the system. This allows developers to guarantee the integrity of external files that are distributed alongside the application bundle on the same disk image. An attacker could infect these external files with malicious code and with them exploit a vulnerability in the application, without having to break the signature of the application bundle itself. By signing the disk image, the developer can prevent tampering and force an attacker to repackage the files onto a new disk image, requiring a valid developer certificate to pass Gatekeeper without a warning.

The second new mechanism is "path randomization", which executes application bundles from a random, hidden path and prevents them from accessing external files relative to their location. To avoid this, the developer has to distribute the application bundle and its external files on a signed disk image or in a signed installer package. The user can avoid this mechanism by moving the application bundle without its external files to a new location.

### Directory permissions and sudo

The Unix permissions for writing to the /Volumes directory are now restricted to root and no longer "world-writable". Apple expanded System Integrity Protection to /Library/Application Support/com.apple.TCC, a directory that contains a list of applications that are allowed to "control the computer", and restricts write access to programs which were signed with an Apple "private entitlement". The file-hosting service Dropbox has been criticized for manipulating the directory to add their Dropbox application to the list, rather than asking the user to do it for them explicitly in System Preferences.

The sudo command-line utility with which a user can execute a command as another user, typically as root, is configured with the "tty_tickets" flag by default, restricting the session timeout to the terminal session (such as a window or tab) in which the user authenticated the program.

## Removed functionality

Sierra removes support for garbage collection from the [Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C/) runtime, a memory-management system that was added in [Mac OS X Leopard (version 10.5)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/) and declared deprecated in favor of Automatic Reference Counting in [OS X Mountain Lion (version 10.8)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/). Applications that have been compiled with garbage collection will no longer run.

Apple removed native support for the VPN protocol PPTP and made recommendations for alternatives that it considers more secure.

The "time remaining" estimate has been removed in the 10.12.2 update after complaints of the battery life of 2016 MacBook Pros.

The Game Center app has been removed. However, the service still exists.

## Reinstallation

Following the download of macOS Sierra (10.12) from the Mac App Store, the installer does not show under a users' "Purchased" tab in the Mac App Store app. Users can still re-download the Sierra installer by visiting the macOS Sierra page on the Mac App Store.

## Reception

macOS Sierra has received generally positive reviews. Users and critics have praised its functionality, including the addition of Siri and support for Apple Pay in Safari. Macworld gave it 4.5 stars out of 5. Engadget gave it a rating of 87 out of 100 praising the new features such as Siri integration, Universal Clipboard, and Apple Pay while criticizing the unreliability of Auto Unlock, that "Siri isn't always smart enough" and some of the Messages features are only available on [iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/). Developers of apps that rely on the PDFKit library built into macOS have complained that radical changes to PDFKit introduced in Sierra are causing instability and potential data corruption.

## Release history

**Unsupported**

Version 	Build 	Release date 	Darwin 	Notes 	Standalone download

10.12 	16A323 	September 20, 2016 	16.0.0 	Original Mac App Store release 	N/A

10.12.1 	16B2555 	October 24, 2016 	16.1.0 	About the macOS Sierra 10.12.1 Update 	macOS Sierra 10.12.1 Update

16B2657 	October 27, 2016

10.12.2 	16C67 	December 13, 2016 	16.3.0 	About the macOS Sierra 10.12.2 Update 	macOS Sierra 10.12.2 Update

macOS Sierra 10.12.2 Combo Update

16C68 	December 14, 2016

10.12.3 	16D32 	January 23, 2017 	16.4.0 	About the macOS Sierra 10.12.3 Update 	macOS Sierra 10.12.3 Update

macOS Sierra 10.12.3 Combo Update

10.12.4 	16E195 	March 27, 2017 	16.5.0 	About the macOS Sierra 10.12.4 Update 	macOS Sierra 10.12.4 Update

macOS Sierra 10.12.4 Combo Update

10.12.5 	16F73 	May 15, 2017 	16.6.0 	About the macOS Sierra 10.12.5 Update 	macOS Sierra 10.12.5 Update

macOS Sierra 10.12.5 Combo Update

16F2073 	June 5, 2017

10.12.6 	16G29 	July 19, 2017 	16.7.0 	About the macOS Sierra 10.12.6 Update 	macOS Sierra 10.12.6 Update

macOS Sierra 10.12.6 Combo Update

16G1036 	October 31, 2017 	About the security content of Security Update 2017-001 Sierra 	Security Update 2017-001 Sierra

16G1114 	December 6, 2017 	About the security content of Security Update 2017-002 Sierra 	Security Update 2017-002 Sierra

16G1212 	January 23, 2018 	About the security content of Security Update 2018-001 Sierra 	Security Update 2018-001 Sierra

16G1314 	March 29, 2018 	About the security content of Security Update 2018-002 Sierra 	Security Update 2018-002 Sierra

16G1408 	June 1, 2018 	About the security content of Security Update 2018-003 Sierra 	Security Update 2018-003 Sierra

16G1510 	July 9, 2018 	About the security content of Security Update 2018-004 Sierra 	Security Update 2018-004 Sierra

16G1618 	October 30, 2018 	About the security content of Security Update 2018-005 Sierra 	Security Update 2018-005 Sierra

16G1710 	December 5, 2018 	About the security content of Security Update 2018-006 Sierra 	Security Update 2018-006 Sierra

16G1815 	January 22, 2019 	About the security content of Security Update 2019-001 Sierra 	Security Update 2019-001 Sierra

16G1917 	March 25, 2019 	About the security content of Security Update 2019-002 Sierra 	Security Update 2019-002 Sierra

16G1918 	March 29, 2019 	About the security content of Security Update 2019-002 Sierra 	Security Update 2019-002 Sierra

16G2016 	May 14, 2019 	About the security content of Security Update 2019-003 Sierra 	Security Update 2019-003 Sierra

16G2127 	July 22, 2019 	About the security content of Security Update 2019-004 Sierra 	Security Update 2019-004 Sierra

16G2128 	July 29, 2019 	About the security content of Security Update 2019-004 Sierra 	Security Update 2019-004 Sierra

16G2136 	September 26, 2019 	About the security content of Security Update 2019-005 Sierra 	Security Update 2019-005 Sierra

***

## Sources

[Wikipedia - MacOS 10.12 (Sierra)](https://en.wikipedia.org/wiki/MacOS_Sierra)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Friday September 24th at 4:50 pm`

**Last revised on:** `2021 Friday September 24th at 4:50 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021, Friday September 24th at 4:50 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

