
***

# Welcome to the WacOS wiki!

_This is the home page of the Wiki. It is not to be confused with the [WacOS Home directory](https://github.com/seanpm2001/WacOS/wiki/Home(Directory))._

WacOS is an open source replacement project for all versions of MacOS, iOS, iPhoneOS, TvOS, WatchOS, and all Apple software.

This Wiki is a glossary of Apple terms, alongside info on how it aligns with WacOS and how well it is supported/its re-development history.

Currently, a lot of articles are based of their Wikipedia counter-parts, being mirrored here, and reformatted in markdown with special details. A lot of articles here need lots of work, it is still good to have them all in one place.

## Start here

[Read the rules for editing this Wiki](https://github.com/seanpm2001/WacOS/wiki/!All_Rules)

[WacOS and ElementaryOS, 2 good choices](https://github.com/seanpm2001/WacOS/wiki/ElementaryOS/)

## All articles:

4 articles total (excluding home page)

[Image Credits (Apple)](https://github.com/seanpm2001/WacOS/wiki/ImageCredits(Apple))

[Finder (Application)](https://github.com/seanpm2001/WacOS/wiki/Finder-(application))

[Home (directory)](https://github.com/seanpm2001/WacOS/wiki/Home(Directory))

[Swift (programming language)](https://github.com/seanpm2001/WacOS/wiki/Swift-(programming-language))

List incomplete

## Categories

### General

[WacOS and ElementaryOS, 2 good choices](https://github.com/seanpm2001/WacOS/wiki/ElementaryOS/)

### Desktop environment

[WacOS Desktop environment](https://github.com/seanpm2001/WacOS/wiki/WacOS_DE/)

> [Skeuowie, the desktop environment WacOS modified](https://github.com/seanpm2001/WacOS/wiki/Skeuowie/)

[Aqua (User Interface)](https://github.com/seanpm2001/WacOS/wiki/Aqua_(User_Interface)/)

### Processor support

[AMD Processor support](https://github.com/seanpm2001/WacOS/wiki/AMD_Processor_Support)

[Intel Processor support](https://github.com/seanpm2001/WacOS/wiki/Intel_Processor_Support)

[PowerPC Processor support](https://github.com/seanpm2001/WacOS/wiki/PowerPC_Processor_Support)

### Common sources

[Wikipedia, the Free Encyclopedia at en.wikipedia.org](https://en.wikipedia.org/)

[Rosetta Code](https://github.com/seanpm2001/WacOS/wiki/RosettaCode/)

### People

[Isaac Newton](https://github.com/seanpm2001/WacOS/wiki/Isaac_Newton/)

[Steve Jobs (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

[Steve Wozniak (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

[Dennis Ritchie (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

[Seanpm2001](https://github.com/seanpm2001/) [Seanpm2001 (link coming soon)](https://github.com/seanpm2001/WacOS/wiki/)

### Special Extras

["Twentieth Century" WACintosh, WAC or WAMMY](https://github.com/seanpm2001/WacOS/wiki/WAMMY/)

### Programming languages

[See all languages used on this project](https://github.com/seanpm2001/WacOS/wiki/Languages_used)

[Swift (programming language)](https://github.com/seanpm2001/WacOS/wiki/Swift-(programming-language))

[AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript)

[Squeak](https://github.com/seanpm2001/WacOS/wiki/Squeak)

[Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C)

[Objective-C++](*https://github.com/seanpm2001/WacOS/wiki/Objective-CPP)

[C (Programming language)](https://github.com/seanpm2001/WacOS/wiki/C-(Programming-language))

[YAML](https://github.com/seanpm2001/WacOS/wiki/YAML)

### Applications

[Finder (Application)](https://github.com/seanpm2001/WacOS/wiki/Finder-(application))

WacOS Equivalent: currently unavailable

[MacWrite](https://github.com/seanpm2001/WacOS/wiki/MacWrite)

WacOS Equivalent: [WacWrite](https://github.com/seanpm2001/WacOS/wiki/WacWrite/)

[MacPaint](https://github.com/seanpm2001/WacOS/wiki/MacPaint)

WacOS Equivalent: [WacPaint](https://github.com/seanpm2001/WacOS/wiki/WacPaint)

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime)

WacOS Equivalent: currently unavailable

#### Third party

[Growl](https://github.com/seanpm2001/WacOS/wiki/Growl(Software))

WacOS Equivalent: None

### Features

[DMG](https://github.com/seanpm2001/WacOS/wiki/DMG)

[IPA](https://github.com/seanpm2001/WacOS/wiki/IPA)

Linux

XNU

File systems

NOT LINKED

### Subsystems

[BaSYS](https://github.com/seanpm2001/WacOS/wiki/BaSYS/) - A subsystem for Classic Mac OS

### Web browsers

[Cyberdog](https://github.com/seanpm2001/WacOS/wiki/Cyberdog/)

[OpenCyberdog](https://github.com/seanpm2001/WacOS/wiki/OpenCyberdog/)

[Safari](https://github.com/seanpm2001/WacOS/wiki/Safari/)

[Savannah](https://github.com/seanpm2001/WacOS/wiki/Savannah/)

[Firefox](https://github.com/seanpm2001/WacOS/wiki/Firefox/)

[Internet Explorer for Mac](https://github.com/seanpm2001/WacOS/wiki/Internet_Explorer_for_Mac/)

* [Full browser list]((https://github.com/seanpm2001/WacOS/wiki/Browser_list/)

### Standards to follow

[Acid1](https://github.com/seanpm2001/WacOS/wiki/acid1)

[Acid2](https://github.com/seanpm2001/WacOS/wiki/acid2)

[Acid3](https://github.com/seanpm2001/WacOS/wiki/acid3)

[Computing longevity](https://github.com/Computing-longevity) [Wiki link unavailable](https://github.com/seanpm2001/WacOS/wiki/)

### File system and structure

[Home (directory)](https://github.com/seanpm2001/WacOS/wiki/Home(Directory))

[Default File Systems in WacOS](https://github.com/seanpm2001/WacOS/wiki/Default_File_Systems/)

[Cloud support](https://github.com/seanpm2001/WacOS/wiki/Cloud/)

[Kernel](https://github.com/seanpm2001/WacOS/wiki/Kernel/)

[Languages used](https://github.com/seanpm2001/WacOS/wiki/Languages_used)

[Snapshots version control system](https://github.com/seanpm2001/WacOS/wiki/Snapshots-(version-control))

[Project language file](https://github.com/seanpm2001/WacOS/wiki/Project_Language_File/)

### Meta Wiki

_Section renamed from `Wiki Meta` to `Meta Wiki` on 2021 Thursday September 23rd, as it produced a broken link, and ignored the word Wiki in the anchor link_

[_Footer](https://github.com/seanpm2001/WacOS/wiki/_Footer) - The footer of the Wiki, appears at the bottom of every page

[_Sidebar](https://github.com/seanpm2001/WacOS/wiki/_Sidebar) - The sidebar of the Wiki, under the pages section (which becomes a dropdown when you create the sidebar)

[.TODO](https://github.com/seanpm2001/WacOS/wiki/.TODO) - My main todo list for what to work on on this Wiki

[.Redirect](https://github.com/seanpm2001/WacOS/wiki/.Redirect) - A page to redirect you to the right article that you are looking for. I hope to automate this process in the future

[.TEMPLATE_Year](https://github.com/seanpm2001/WacOS/wiki/.TEMPLATE_Year) - A template used to make year articles faster

[!Collection_list_of_collections](https://github.com/seanpm2001/WacOS/wiki/!Collection_list_of_collections) - An article that lists all the collection articles on this Wiki.

[!Collection_list_of_Wiki_templates](https://github.com/seanpm2001/WacOS/wiki/!Collection_list_of_Wiki_templates) - A list article that lists all the Wiki templates on this Wiki

### Line of computers

#### Macintosh

[Macintosh 128K](https://github.com/seanpm2001/WacOS/wiki/Macintosh_128K)

#### iPhone

List is currently empty.

#### iPod

List is currently empty.

#### iPad

List is currently empty.

### Apple operating systems

#### MacOS

[MacOS](https://github.com/seanpm2001/WacOS/wiki/MacOS) is Apples infamous desktop operating system.

##### Classic

[Classic MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Classic-MacOS-version-history/)

[System 1](https://github.com/seanpm2001/WacOS/wiki/Apple-System-1)

[System 2](https://github.com/seanpm2001/WacOS/wiki/Apple-System-2)

[System 3](https://github.com/seanpm2001/WacOS/wiki/Apple-System-3)

[System 4](https://github.com/seanpm2001/WacOS/wiki/Apple-System-4)

[System 5](https://github.com/seanpm2001/WacOS/wiki/Apple-System-5)

[System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6)

[System 7/MacOS 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/)

[MacOS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/)

[MacOS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/)

##### Mac OS X

[Mac OS X version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-version-history/)

[Mac OS X 10.0 Public Beta](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Public-Beta/)

[Mac OS X 10.0 (Cheetah)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/)

[Mac OS X 10.1 (Puma)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-1-Puma/)

[Mac OS X 10.2 (Jaguar)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-2-Jaguar/)

[Mac OS X 10.3 (Panther)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-3-Panther/)

[Mac OS X 10.4 (Tiger)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger/)

[Mac OS X 10.5 (Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/)

[Mac OS X 10.6 (Snow Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/)

##### OS X

[OS X version history](https://github.com/seanpm2001/WacOS/wiki/OS-X-version-history/)

[OS X 10.7 (Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-7-Lion/)

[OS X 10.8 (Mountain Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/)

[OS X 10.9 (Mavericks)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-9-Mavericks/)

[OS X 10.10 (Yosemite)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-10-Yosemite/)

[OS X 10.11 (El Capitan)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-11-El-Capitan/)

##### MacOS Modern

[Complete MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Complete-MacOS-version-history/)

[Modern MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Modern-MacOS-version-history/)

[MacOS 10.12 (Sierra)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-12-Sierra/)

[MacOS 10.13 (High Sierra)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-13-High-Sierra/)

[MacOS 10.14 (Mojave)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-14-Mojave/)

[MacOS 10.15 (Catalina)](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-15-Catalina/)

[MacOS 11.0 (Big Sur)](https://github.com/seanpm2001/WacOS/wiki/MacOS-11-0-Big-Sur/)

[MacOS 12.0 (Monterey)](https://github.com/seanpm2001/WacOS/wiki/MacOS-12-0-Monterey/)

### iOS

#### iPhoneOS

_[iPhoneOS](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS/) is a mobile operating system by Apple Inc, the predecessor to [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) and [iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/).

[iPhoneOS version history](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-Version-History)

[iPhoneOS 1](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-1/)

[iPhoneOS 2](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-2/)

[iPhoneOS 3](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-3/)

##### Features

[iPhoneOS Dock](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-Dock/)

[iPhoneOS Wallpaper info](https://github.com/seanpm2001/WacOS/wiki/iPhoneOS-Wallpaper-info/)

#### Modern iOS

_[iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/) is a mobile operating system by Apple Inc._

[iOS version history](https://github.com/seanpm2001/WacOS/wiki/iOS-version-history/)

[iOS 4](https://github.com/seanpm2001/WacOS/wiki/iOS-4/)

[iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS-5/)

[iOS 6](https://github.com/seanpm2001/WacOS/wiki/iOS-6/)

[iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/)

[iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/)

[iOS 9](https://github.com/seanpm2001/WacOS/wiki/iOS-9/)

[iOS 10](https://github.com/seanpm2001/WacOS/wiki/iOS-10/)

[iOS 11](https://github.com/seanpm2001/WacOS/wiki/iOS-11/)

[iOS 12](https://github.com/seanpm2001/WacOS/wiki/iOS-12/)

[iOS 13](https://github.com/seanpm2001/WacOS/wiki/iOS-13/)

[iOS 14](https://github.com/seanpm2001/WacOS/wiki/iOS-14/)

[iOS 15](https://github.com/seanpm2001/WacOS/wiki/iOS-15/)

#### iPadOS

_[iPadOS](https://github.com/seanpm2001/WacOS/wiki/iPadOS/) is a fork of [iOS](https://github.com/seanpm2001/WacOS/wiki/iOS/)._

[iPadOS version history](https://github.com/seanpm2001/WacOS/wiki/iPadOS-version-history/)

[iPadOS 13](https://github.com/seanpm2001/WacOS/wiki/iPadOS-13/)

[iPadOS 14](https://github.com/seanpm2001/WacOS/wiki/iPadOS-14/)

[iPadOS 15](https://github.com/seanpm2001/WacOS/wiki/iPadOS-15/)

### Other

[Copland](https://github.com/seanpm2001/WacOS/wiki/Copland)

[Rhapsody](https://github.com/seanpm2001/WacOS/wiki/Rhapsody)

[Mac OS X Server 1.0](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Server-1-0/)

[TaligentOS](https://github.com/seanpm2001/WacOS/wiki/Taligent-OS)

[NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP)

[OPENSTEP](https://github.com/seanpm2001/WacOS/wiki/OPENSTEP)

[Darwin](https://github.com/seanpm2001/WacOS/wiki/Darwin/)

> [Darwin version history](https://github.com/seanpm2001/WacOS/wiki/Darwin-version-history/)

### Culture and humor

For the culture and humor of Apple

[DogCow](https://github.com/seanpm2001/WacOS/wiki/Dogcow)

[Stevenote](https://github.com/seanpm2001/WacOS/wiki/SteveNote)

[Happy Mac](https://github.com/seanpm2001/WacOS/wiki/Happy-Mac/)

[Sad Mac](https://github.com/seanpm2001/WacOS/wiki/Sad-Mac/)

### Privacy

For info on Apple and user privacy.

[Apple and Privacy (1976-2013)](https://github.com/seanpm2001/WacOS/wiki/Apple-and-privacy-(1976-2013))

[PRISM (Mass Surveillance Program by the USA: NSA & CIA](https://github.com/seanpm2001/WacOS/wiki/PRISM-(Surveillance-program))

[Apple and Privacy (2013-2021)](https://github.com/seanpm2001/WacOS/wiki/Apple-and-privacy-(2013-2021))

[iCloud 2021 privacy concerns](https://github.com/seanpm2001/WacOS/wiki/iCloud-2021-privacy-problems)

### Security

[iCloud 2014 celebrity photo leak](https://github.com/seanpm2001/WacOS/wiki/iCloud-2014-celebrity-photo-leak)

### Criticism

For criticism of Apple Inc. and related criticism from misuse of Apple products

[300 page iPhone Bill](https://github.com/seanpm2001/WacOS/wiki/300-Page-iPhone-Bill)

[iCon (book)](https://github.com/seanpm2001/WacOS/wiki/iCon(Book))

### Advertising

For Apples advertising.

[Notable Apple advertisements](https://github.com/seanpm2001/WacOS/wiki/Notable_Apple_Advertisements)

> [1984 (Apple Ad)](https://github.com/seanpm2001/WacOS/wiki/1984(Advertisement))

> > [Related: Nineteen Eighty Four (Dystopia)](https://github.com/seanpm2001/WacOS/wiki/1984(Dystopia))

### Books

For books about Apple Inc. and its employees

[iCon](https://github.com/seanpm2001/WacOS/wiki/iCon(Book))

### Litigation

For Apples legal history.

[Full history of litigation (article coming soon)](https://github.com/seanpm2001/WacOS/wiki/Apple-litigation)

[Apple vs. Microsoft & IBM (Windows 2.0)](https://github.com/seanpm2001/WacOS/wiki/Windows-2-litigation)

### History

Apple was founded on 1976, April 1st.

[1976](https://github.com/seanpm2001/WacOS/wiki/1976/)

[1977](https://github.com/seanpm2001/WacOS/wiki/1977/)

[1978](https://github.com/seanpm2001/WacOS/wiki/1978/)

[1979](https://github.com/seanpm2001/WacOS/wiki/1979/)

[1980](https://github.com/seanpm2001/WacOS/wiki/1980/)

[1981](https://github.com/seanpm2001/WacOS/wiki/1981/)

[1982](https://github.com/seanpm2001/WacOS/wiki/1982/)

[1983](https://github.com/seanpm2001/WacOS/wiki/1983/)

[1984](https://github.com/seanpm2001/WacOS/wiki/1984/)

[1985](https://github.com/seanpm2001/WacOS/wiki/1985/)

[1986](https://github.com/seanpm2001/WacOS/wiki/1986/)

[1987](https://github.com/seanpm2001/WacOS/wiki/1987/)

[1988](https://github.com/seanpm2001/WacOS/wiki/1988/)

[1989](https://github.com/seanpm2001/WacOS/wiki/1989/)

[1990](https://github.com/seanpm2001/WacOS/wiki/1990/)

[1991](https://github.com/seanpm2001/WacOS/wiki/1991/)

[1992](https://github.com/seanpm2001/WacOS/wiki/1992/)

[1993](https://github.com/seanpm2001/WacOS/wiki/1993/)

[1994](https://github.com/seanpm2001/WacOS/wiki/1994/)

[1995](https://github.com/seanpm2001/WacOS/wiki/1995/)

[1996](https://github.com/seanpm2001/WacOS/wiki/1996/)

[1997](https://github.com/seanpm2001/WacOS/wiki/1997/)

[1998](https://github.com/seanpm2001/WacOS/wiki/1998/)

[1999](https://github.com/seanpm2001/WacOS/wiki/1999/)

[2000](https://github.com/seanpm2001/WacOS/wiki/2000/)

[2001](https://github.com/seanpm2001/WacOS/wiki/2001/)

[2002](https://github.com/seanpm2001/WacOS/wiki/2002/)

[2003](https://github.com/seanpm2001/WacOS/wiki/2003/)

[2004](https://github.com/seanpm2001/WacOS/wiki/2004/)

[2005](https://github.com/seanpm2001/WacOS/wiki/2005/)

[2006](https://github.com/seanpm2001/WacOS/wiki/2006/)

[2007](https://github.com/seanpm2001/WacOS/wiki/2007/)

[2008](https://github.com/seanpm2001/WacOS/wiki/2008/)

[2009](https://github.com/seanpm2001/WacOS/wiki/2009/)

[2010](https://github.com/seanpm2001/WacOS/wiki/2010/)

[2011](https://github.com/seanpm2011/WacOS/wiki/2011/)

[2012](https://github.com/seanpm2011/WacOS/wiki/2012/)

[2013](https://github.com/seanpm2011/WacOS/wiki/2013/)

[2014](https://github.com/seanpm2011/WacOS/wiki/2014/)

[2015](https://github.com/seanpm2011/WacOS/wiki/2015/)

[2016](https://github.com/seanpm2011/WacOS/wiki/2016/)

[2017](https://github.com/seanpm2011/WacOS/wiki/2017/)

[2018](https://github.com/seanpm2011/WacOS/wiki/2018/)

[2019](https://github.com/seanpm2011/WacOS/wiki/2019/)

[2020](https://github.com/seanpm2011/WacOS/wiki/2020/)

[2021](https://github.com/seanpm2011/WacOS/wiki/2021/)

### Apple structures

[Apple Campus](https://github.com/seanpm2001/WacOS/wiki/Apple_Campus)

[Apple Park](https://github.com/seanpm2001/WacOS/wiki/Apple_Park)

[Apple Store](https://github.com/seanpm2001/WacOS/wiki/Apple_Store)

### Subsidiaries and ventures

[Taligent](https://github.com/seanpm2001/WacOS/wiki/Taligent-(company))

[Claris](https://github.com/seanpm2001/WacOS/wiki/Claris)

### Apple WorldWide Developers Conference

[Apple WWDC1987](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1987/)

[Apple WWDC1988](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1988/)

[Apple WWDC1989](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1989/)

[Apple WWDC1990](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1990/)

[Apple WWDC1991](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1991/)

[Apple WWDC1992](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1992/)

[Apple WWDC1993](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1993/)

[Apple WWDC1994](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1994/)

[Apple WWDC1995](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1995/)

[Apple WWDC1996](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1996/)

[Apple WWDC1997](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1997/)

[Apple WWDC1998](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1998/)

[Apple WWDC1999](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-1999/)

[Apple WWDC2000](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2000/)

[Apple WWDC2001](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2001/)

[Apple WWDC2002](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2002/)

[Apple WWDC2003](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2003/)

[Apple WWDC2004](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2004/)

[Apple WWDC2005](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2005/)

[Apple WWDC2006](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2006/)

[Apple WWDC2007](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2007/)

[Apple WWDC2008](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2008/)

[Apple WWDC2009](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2009/)

[Apple WWDC2010](https://github.com/seanpm2001/WacOS/wiki/Apple-WWDC-2010/)

[Apple WWDC2011](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2011/)

[Apple WWDC2012](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2012/)

[Apple WWDC2013](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2013/)

[Apple WWDC2014](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2014/)

[Apple WWDC2015](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2015/)

[Apple WWDC2016](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2016/)

[Apple WWDC2017](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2017/)

[Apple WWDC2018](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2018/)

[Apple WWDC2019](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2019/)

[Apple WWDC2020](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2020/)

[Apple WWDC2021](https://github.com/seanpm2011/WacOS/wiki/Apple-WWDC-2021/)

#### Other

[Apple Public Source License](https://github.com/seanpm2001/WacOS/wiki/Apple-Public-Source-License)

[Seanpm2001's Apple experience](https://github.com/seanpm2001/WacOS/wiki/Seanpm2001-Apple-experience/)

### Credits

[Image Credits (Apple)](https://github.com/seanpm2001/WacOS/wiki/ImageCredits(Apple))

***

## Article info

**Wiki homepage version:** `8 (Friday, 2021 September 24h at 6:28 pm)`

**Wiki homepage version 3 release date:** `Wednesday, 2021 September 15th at 5:10 pm) accidentally published early.`

**Wiki homepage version 4 release date:** `Wednesday, 2021 September 15th at 5:16 pm) accidentally published early. I am now going to use Gedit instead, I can't keep risking it, I hate this GitHub shortcut`

**First version:** `1 (2020 May 27th at 1:59 pm)`

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**Language:** `English (US) / Markdown (.md)`

***

