  
***

# Complete MacOS version history

## Classic MacOS

[Main article: Classic MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Classic-MacOS-version-history/)

( **Predecessor:** [LisaOS version history](https://github.com/seanpm2001/WacOS/wiki/LisaOS-version-history/) | **Successor:** [Mac OS X Version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-version-history/) )

### System 1

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 1.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-1/), 1.1, and 2.0 use a flat file system named Macintosh File System (MFS). The Finder provides virtual folders that could be used to organize files, but these folders are not visible from any other application and do not actually exist on the disk.

### System 2

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 2.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-2/) added support for AppleTalk and the newly introduced LaserWriter to use it.

System 2.1 (Finder 5.0) introduced the Hierarchical File System (HFS) which has real directories. This version was specifically to support the Hard Disk 20 and only implements HFS in RAM; startup and most floppy disks remain MFS 400 K volumes.

### System 3

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 3.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-3/) (Finder 5.1) was introduced with the Macintosh Plus, officially implementing [HFS](https://github.com/seanpm2001/WacOS/wiki/HFS/), 800K startup drives, support for several new technologies including SCSI and AppleShare, and Trash "bulging" (i.e., when the Trash contains files, it gains a bulged appearance).

### System 4

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 4.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-4/) was released with the Macintosh SE and System 4.1 first shipped with the Macintosh II—these new machines required additional support for the first expansion slots, the Apple Desktop Bus (ADB), internal hard drives and, on the Macintosh II, external color displays and the first Motorola 68020 processor.

These releases can only run one application at a time, except for desk accessories, though special application shells such as Multi-Mac or Switcher (discussed under MultiFinder) could work around this. Visible changes are best reflected in the version number of the Finder, where major leaps are found between 1.x, 4.x, [5.x](https://github.com/seanpm2001/WacOS/wiki/Apple-System-5/), and [6.x.](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/)

System Software Release	System Version 	Release Date	Finder Version 	LaserWriter Version	Release Information

Macintosh System Software 	1.0 (.97) 	January 24, 1984	1.0 		Initial Release

Macintosh System Software (0.1) 	1.1 	May 5, 1984	1.1g 		Maintenance Release, Added Mountain scene, About box, Clean Up Command

Macintosh System Software (0.3 & 0.5) 	2.0 	April 1985 	4.1 		Finder Update: Introduced multiple folders, "Shut Down" command, and installation of a "MiniFinder" application for quickly launching any of the chosen applications

System: Introduced screenshots using ⌘ Command+⇧ Shift+3

Macintosh System Software	2.1	September 1985	5.0 		Release for Hard Disk 20 support

Macintosh System Software (0.7) 	3.0 	January 1986 	5.1 	1.1 	Introduced with Macintosh Plus

System Software 1.0 	3.1 	February 1986	5.2 	1.1 	

System Software 1.1 	3.2 	June 1986 	5.3 	3.1 	Fixed problems with data loss, system crashes; updated Chooser and Calculator.

AppleShare 1.0 	3.3 	January 1987 	5.4 		AppleShare 1.0 Work Station Installer disk (for the Macintosh 512K)

AppleShare 1.1 	3.3	1987 	5.5 		AppleShare 1.1 Work Station Installer disk (for the Macintosh 512K)

AppleShare 2.0 	3.4	1988 	6.1		AppleShare 2.0 Macintosh 512Ke Work Station Installer disk

System Software 2.0 	4.0 	January 1987	5.4 	3.3 	Release for Macintosh SE. Introduced AppleShare

System Software 2.0.1 	4.1 	March 2, 1987 	5.5 	4.0 	Release for Macintosh II. Updated LaserWriter Driver 

### System 5

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

Towards the end of [1987](https://github.com/seanpm2001/WacOS/wiki/1987/), Apple introduced a package titled "Apple Macintosh System Software Update 5.0". For the first time, the Macintosh operating system was offered as a distinct retail product that included four 800K disks and three manuals, at a cost of US$49. The software itself was still freely available through user groups and bulletin board services. While the product box presented this update to the operating system as "version 5.0", this number does not appear in the software itself. Three of the four disks (System Tools 1, System Tools 2 and Utilities 1) are all bootable, and the user can boot off of whichever floppy contain the tools the user needs. For instance, System Tools 2 is the only disk with printer drivers, and Utilities 1 is the only disk with Disk First Aid and Apple HD SC Setup. Because the disks are named System Tools, users and the press commonly referred to this version as "System Tools 5.0".

The primary new feature of [System 5](https://github.com/seanpm2001/WacOS/wiki/Apple-System-5/) is MultiFinder, an extension which lets the system run several programs at once. The system uses a cooperative multitasking model, meaning that time is given to the background applications only when the foreground application yields control. A change in system functions that applications were already calling to handle events make many existing applications share time automatically, as well as being allowed to perform tasks in the background. Users can also choose not to use MultiFinder, thereby using a single application at a time. In [1990](https://github.com/seanpm2001/WacOS/wiki/1990/) InfoWorld tested four multitasking options for PC and Mac, viewing MultiFinder positively overall, but noting that its presence halved the speed of file transfer and printing compared to the single-tasking [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) without MultiFinder.

System Software

Release	Release Date 	System Version 	Software Version 	Release Information Finder 	MultiFinder 	LaserWriter

5.0 	October 1987	4.2 	6.0 	1.0 	5.0 	Initial Release

5.1 	November 1987 	4.3 	5.1 	Updated LaserWriter Driver and new version of Apple HD SC Setup 

### System 6

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/6/Macintosh_system_6.0.8.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/6/Macintosh_system_6.0.8.png)

[System Software 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) (also referred to as "System 6") is a consolidation release of the Macintosh system software, producing a complete, stable, and long-lasting operating system. Two major hardware introductions requiring additional support under [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) are the 68030 processor and 1.44 MB SuperDrive debuting with the Macintosh IIx and Macintosh SE/30. Later updates include support for the first specialized laptop features with the introduction of the Macintosh Portable. From [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) forward, the Finder has a unified version number closely matching that of the System, alleviating much of the confusion caused by the often considerable differences between earlier Systems.

System

Version	Release

Date	Software Version 	Release Information

Finder 	MultiFinder 	LaserWriter

6.0 	April 1988 	6.1 	6.0 	5.2 	Initial Release

6.0.1 	September 19, 1988 	6.1.1 	6.0.1 	Release for Macintosh IIx (1988)

6.0.2 	Late 1988 	6.1 	Maintenance Release

6.0.3 	March 7, 1989 	6.0.3 	Release for Macintosh IIcx (1989)

6.0.4 	September 20, 1989 	6.1.4 	6.0.4 	Release for Macintosh Portable and IIci (1989)

6.0.5 	March 19, 1990 	6.1.5 	6.0.5 	Release for Macintosh IIfx (1990)

6.0.6 	October 15, 1990 	6.1.6 	6.0.6 	Not released because of AppleTalk bug

6.0.7 	October 16, 1990 	6.1.7 	6.0.7 	Official release for Macintosh LC, IIsi and Classic (1990)

6.0.8 	May 13, 1991 	6.1.8 	6.0.8 	7.0 	Updated printing software to match software of System 7.0

6.0.8L 	March 23, 1992 	Limited maintenance release for Pacific customers 

### Mac OS 7

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/7/Mac_OS_7.6.1_emulated_inside_of_SheepShaver.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/7/Mac_OS_7.6.1_emulated_inside_of_SheepShaver.png)

On May 13, 1991, [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) was released. It is a major upgrade over [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/), adding a significant user interface overhaul, new applications, stability improvements and many new features. Its introduction coincides with the release of and provided support for the 68040 Macintosh line. The [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) era saw numerous changes in the Macintosh platform including a proliferation of Macintosh models, the 68k to Power Macintosh transition as well as the rise of Microsoft Windows, increasing use of computer networking and the explosion in popularity of the Internet.

One of the most significant features of [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) is virtual memory support, an essential subsystem anticipated for years, which only exists for previous Systems in a third party extension named Virtual from Connectix. Accompanying this was a move to 32-bit memory addressing, necessary for the ever-increasing amounts of RAM available to the Motorola 68030 CPU, and 68020 CPUs with a 68851 PMMU. This process involves making all of the routines in OS code use the full 32-bits of a pointer as an address—prior systems used the upper 8 bits as flags. This change is known as being "32-bit clean". While System 7 itself is 32-bit clean, many existing machines and thousands of applications were not, so it was some time before the process was completed. To ease the transition, the "Memory" control panel contains a switch to disable this feature, allowing for compatibility with older applications.

Another notable [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) feature is built-in cooperative multitasking. In System Software 6, this function was optional through the MultiFinder. [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) also introduced aliases, similar to symbolic links on Unix, shortcuts that were introduced in later versions of Microsoft Windows, and shadows in IBM OS/2. System extensions were enhanced by being moved to their own subfolder; a subfolder in the System Folder was also created for the control panels. In System 7.5, Apple includes the Extensions Manager, a previously third-party program which simplified the process of enabling and disabling extensions.

The Apple menu, home only to desk accessories in [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/), was made more general-purpose: the user could now make often-used folders and applications—or anything else they desired—appear in the menu by placing aliases to them in an "Apple Menu Items" subfolder of the System Folder. [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) also introduced the following: [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/), a scripting language for automating tasks; 32-bit QuickDraw, supporting so-called "true color" imaging, previously available as a system extension; and TrueType, an outline font standard.

The Trash, under [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) and earlier, empties itself automatically when shutting down the computer—or, if MultiFinder is not running, when launching an application. [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) reimplements the Trash as a special hidden folder, allowing files to remain in it across reboots until the user deliberately chose the "Empty Trash" command.

#### System 7.1

System 7.1 is mainly a bugfix release, with a few minor features added. One of the major new features of System 7.1 was moving fonts out of the System file into the Fonts folder in the System Folder. Previously a resource-copying utility such as ResEdit or Font D/A Mover was required for installing fonts. System 7.1 is not only the first Macintosh operating system to cost money (all previous versions were free or sold at the cost of the floppies), but also received a "Pro" sibling (version 7.1.1) with extra features. System 7.1.2 was the first version to support PowerPC-based Macs. System 7.1 also introduces the System Enablers as a method to support new models without updating the actual System file. This leads to extra files inside the system folder (one per new model supported).

#### System 7.5

System 7.5 introduces a large number of new features, many of which are based on shareware applications that Apple bought and included into the new system. On the newer PowerPC machines, System 7.5 may have stability problems partly due to a new memory manager (which can be turned off), and issues with the handling of errors in the [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) code (all PowerPC exceptions map to Type 11). These issues do not affect 68k-architecture machines. System 7.5 is contemporary with Apple's failed [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) effort as well as the release of Windows 95, which coincides with Apple's purchase of several shareware system enhancements to include as new system features.

#### Mac OS 7.6

Stability improved in [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/)-based Macs with Mac OS 7.6, which dropped the "System" moniker as a more trademarkable name was needed in order to license the OS to the growing market of third-party Macintosh clone manufacturers. Mac OS 7.6 required 32-bit-clean ROMs, and so it dropped support for every Mac with a 68000 processor, as well as the Mac II, Mac IIx, Mac IIcx, and Mac SE/30. 

System Version	Release Information

System 7.0 	integrated MultiFinder always enabled

System 7.0.1 	introduced with LC II and Quadra series

System 7.0.1P 	

System 7 Tuner 	update for both 7.0 and 7.0.1

System 7.1 	introduced the Fonts folder

System 7.1P 	

System 7.1P1 	

System 7.1P2 	

System 7.1P3 	last "P" release with new features

System 7.1P4 	

System 7.1P5 	

System 7.1P6 	

System 7.1 Pro 	version 7.1.1, combined with PowerTalk, Speech Manager, MacInTalk, Thread Manager

System 7.1.2 	Macs equipped with a PowerPC processor

System 7.1.2P 	only for Performa/LC/Quadra 630 series, very quickly replaced by 7.5

System 7.5 	

System 7.5.1 	System 7.5 Update 1.0—the first Macintosh operating system to call itself "Mac OS"

System 7.5.2 	Power Macs that use PCI, usable only on these Power Macs and PowerBooks 5300, 190, and Duo 2300

System 7.5.3 	System 7.5 Update 2.0

System 7.5.3L 	only for Macintosh clones

System 7.5.3 Revision 2 	

System 7.5.3 Revision 2.1 	only for Performa 6400/180 and 6400/200

System 7.5.4 	withdrawn within hours of release and replaced by 7.5.5

System 7.5.5 	last to support non-32-bit-clean Macs, including all with less than a 68030 CPU except the Macintosh LC

Mac OS 7.6 	name formally changed because of the experimental clone program, although System 7.5.1 and later used the "Mac OS" name on the splash screen

Mac OS 7.6.1 	proper PowerPC error handling introduced

### Mac OS 8

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/8/Mac_OS_8.1_emulated_inside_of_SheepShaver.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/8/Mac_OS_8.1_emulated_inside_of_SheepShaver.png)

[Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) was released on July 26, [1997](https://github.com/seanpm2001/WacOS/wiki/1997/), the same month [Steve Jobs](https://github.com/seanpm2001/WacOS/wiki/Steve_Jobs/) became the de facto CEO of Apple. It was mainly released to keep the Mac OS moving forward during a difficult time for Apple. Initially planned as Mac OS 7.7, it was renumbered "8" to exploit a legal loophole and accomplish Jobs's goal of terminating third-party manufacturers' licenses to [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) and shutting down the Macintosh clone market.

[Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) added a number of features from the abandoned [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) project, while leaving the underlying operating system unchanged. A multi-threaded Finder was included; files could now be copied in the background. The GUI was changed in appearance to a new shaded greyscale look named Platinum, and the ability to change the appearance themes (also known as skins) was added with a new control panel (though Platinum was the only one shipped). This capability was provided by a new "appearance" API layer within the OS, one of the few significant changes.

Apple sold 1.2 million copies of [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) in its first two weeks of availability and 3 million within six months. In light of Apple's financial difficulties at the time, there was a large grassroots movement among Mac users to upgrade and "help save Apple". Even some pirate groups refused to redistribute the OS.

#### Mac OS 8.1

Mac OS 8.1 introduced an updated version of the [Hierarchical File System](https://github.com/seanpm2001/WacOS/wiki/HFS/) named [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS-Plus/), which fixed many of the limitations of the earlier system and continued to be used in macOS up until [macOS High Sierra](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-13-High-Sierra/), when it was replaced with the [Apple File System](https://github.com/seanpm2001/WacOS/wiki/APFS/). There are some other interface changes such as separating network features from printing, and some improvements to application switching. However, in underlying technical respects, [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) is not very different from [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/).

#### Mac OS 8.5

Mac OS 8.5 focuses on speed and stability, with most 68k code replaced by modern code native to the PowerPC. It also improved the appearance of the user interface, although the theming feature was cut late in development.

System Version 	Release Information

Mac OS 8.0 	first version to require a 68040 processor, dropping support for the remainder of the Macintosh II series and other 68030 Macs. It also added support for the PowerPC G3 processor

Mac OS 8.1 	last Mac OS release to run on a 68k processor, and it added support for USB on the iMac and added support for the HFS+ filesystem, also called Mac OS Extended

Mac OS 8.5 	first version to run solely on a PowerPC processor, and it added built-in support for FireWire. It also added Sherlock and added support for the Power Macintosh G3

Mac OS 8.5.1 	added bug fixes to lessen system crashes

Mac OS 8.6 	included a new nanokernel for improved performance and Multiprocessing Services 2.0 support, improved PowerBook battery life, and added support for the PowerPC G4 processor 

### Mac OS 9

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/Mac_OS_9.0.4_emulated_inside_of_the_SheepShaver_emulator.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/Mac_OS_9.0.4_emulated_inside_of_the_SheepShaver_emulator.png)

[Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/), the last major revision of the classic Mac OS, was released on October 23, [1999](https://github.com/seanpm2001/WacOS/wiki/1999/). It is generally a steady evolution from [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/). Early development releases of Mac OS 9 were numbered 8.7.

[Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) added improved support for AirPort wireless networking. It introduced an early implementation of multi-user support. Though not a true multi-user operating system, [Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) does allow multiple desktop users to have their own data and system settings. An improved Sherlock search engine added several new search plug-ins. Mac OS 9 also provides a much improved memory implementation and management. [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) was improved to allow TCP/IP and networking control. [Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) also makes the first use of the centralized Apple Software Update to find and install OS and hardware updates.

Other new features included its on-the-fly file encryption software with code signing and Keychain technologies, Remote Networking and File Server packages, and much improved list of USB drivers.

[Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) also added some transitional technologies to help application developers adopt some [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) features before the introduction of the new OS to the public, to help ease the transition. These included new APIs for the file system and the bundling of the Carbon library that apps could link against instead of the traditional API libraries—apps that were adapted to do this could be run natively on [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) as well. Other changes were made beginning with the Mac OS 9.1 update to allow it to be launched in the Classic Environment within [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/).

The final update to the classic Mac OS was version 9.2.2, released on December 5, [2001](https://github.com/seanpm2001/WacOS/wiki/2001/).

System Version	Release Information

Mac OS 9.0 	initial retail version of Mac OS 9

Mac OS 9.0.2 	

Mac OS 9.0.3

Mac OS 9.0.4

Mac OS 9.1 	included with Mac OS X 10.0

Mac OS 9.2 	update for improved Mac OS X compatibility

Mac OS 9.2.1 	

Mac OS 9.2.2 	final release of classic Mac OS 

## Mac OS X

[Main article: Mac OS X Version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-version-history/)

( **Predecessor:** [Classic MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Classic-MacOS-version-history/) | **Successor:** [OS X Version history](https://github.com/seanpm2001/WacOS/wiki/OS-X-version-history/) )

### Rhapsody

Rhapsody Developer Release 	Grail1Z4 	1997-08-31 	Rhapsody 5.0 	IA-32, PowerPC

Rhapsody Developer Release 2 	Titan1U 	1998-05-14 	Rhapsody 5.1

Rhapsody Premier 		1998 	Rhapsody 5.2 	PowerPC

Mac OS X Server 1.0 	Hera1O9 	1999-03-16 	Rhapsody 5.3

Mac OS X Server 1.0.1 	1999-04-15 	Rhapsody 5.4

Mac OS X Server 1.0.2 	Hera1O9+Loki2G1 	1999-07-29 	Rhapsody 5.5

Mac OS X Server 1.2 	Pele1Q10 	2000-01-14 	Rhapsody 5.6

Mac OS X Server 1.2 v3 	Medusa1E3 	2000-10-27 [4][5]

### Mac OS X Server 1.0

<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X Server 1.0 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS-Server/1.0/Logo/MacOSX_Server1.0_Logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS-Server/1.0/Logo/MacOSX_Server1.0_Logo.png)

</details>

Version 	Code name 	Date 	OS name

Mac OS X Server 1.0 	Hera1O9 	March 16, 1999 	Rhapsody 5.3

Mac OS X Server 1.0.1 	April 15, 1999 	Rhapsody 5.4

Mac OS X Server 1.0.2 	Hera1O9+Loki2G1 	July 29, 1999 	Rhapsody 5.5

Mac OS X Server 1.2 	Pele1Q10 	January 14, 2000 	Rhapsody 5.6

Mac OS X Server 1.2 v3 	Medusa1E3 	October 27, 2000 	Rhapsody 5.6 

### Mac OS X Public Beta

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/Public_Beta/Macosxpb.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/Public_Beta/Macosxpb.png)

No version history, only 1 release

### Mac OS X 10.0 (Cheetah)

<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.0 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.0_Cheetah/MacOS10.1.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.0_Cheetah/MacOS10.1.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.0_Cheetah/MacOSX10-0screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.0_Cheetah/MacOSX10-0screenshot.png)

Version 	Build 	Date 	OS name 	Notes

10.0 	4K78 	March 24, 2001 	Darwin 1.3.1 	Original retail CD-ROM release

10.0.1 	4L13 	April 14, 2001 	Apple: Mac OS X 10.0: Software Update 1.3.1, 10.0.1 Update, and Epson Printer Driver Update Provide Feature Enhancement, Address Issues

10.0.2 	4P12 	May 1, 2001 	

10.0.3 	4P13 	May 9, 2001 	Update and Before You Install Information

10.0.4 	4Q12 	June 21, 2001 	Apple: 10.0.4 Update and Before You Install Information 

### Mac OS X 10.1 (Puma)

<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.1 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.1_Puma/MacOS10.1.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.0_Cheetah/MacOS10.1.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.1_Puma/Mac_OS_X_10.1_Puma_screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.1_Puma/Mac_OS_X_10.1_Puma_screenshot.png)

Version 	Build 	Date 	OS name 	Notes

10.1 	5G64 	September 25, 2001 	Darwin 1.4.1 	Original retail CD-ROM release; 5L14 and 5L17b available after certain security updates

10.1.1 	5M28 	November 12, 2001 	Darwin 5.1 	Mac OS X Update 10.1.1: Information and Download

10.1.2 	5P48 	December 21, 2001 	Darwin 5.2 	Mac OS X Update 10.1.2: Information and Download

10.1.3 	5Q45 	February 19, 2002 	Darwin 5.3 	Mac OS X Update 10.1.3: Information and Download

10.1.4 	5Q125 	April 17, 2002 	Darwin 5.4 	Mac OS X Update 10.1.4: Information and Download

10.1.5 	5S60 	June 5, 2002 	Darwin 5.5 	Mac OS X Update 10.1.5: Information and Download; 5S66 after networking update 

### Mac OS X 10.2 (Jaguar)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar_on_G4.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar_on_G4.png)

Version 	Build 	Date 	OS name 	Notes

10.2 	6C115 	August 24, 2002 	Darwin 6.0 	Original retail release

6C115a

10.2.1 	6D52 	September 18, 2002 	Darwin 6.1 	About the Mac OS X 10.2.1 Update, codename Jaguar Red

10.2.2 	6F21 	November 11, 2002 	Darwin 6.2 	About the Mac OS X 10.2.2 Update, codename Jaguar Blue or Merlot

10.2.3 	6G30 	December 19, 2002 	Darwin 6.3 	About the Mac OS X 10.2.3 Update, codename Jaguar Green

6G37 		Updated retail release

6G50 		Server edition; retail release

10.2.4 	6I32 	February 13, 2003 	Darwin 6.4 	About the Mac OS X 10.2.4 Update, codename Jaguar Pink

10.2.5 	6L29 	April 10, 2003 	Darwin 6.5 	About the Mac OS X 10.2.5 Update, codename Jaguar Plaid

10.2.6 	6L60 	May 6, 2003 	Darwin 6.6 	About the Mac OS X 10.2.6 Update, codename Jaguar Black

10.2.7 	6R65 	September 22, 2003 	Darwin 6.7 	Removed from distribution due to defects

10.2.8 	6R73 	October 3, 2003 	Darwin 6.8 	About the Mac OS X 10.2.8 Update; released as 6R50 for one day

6S90 	About the Mac OS X 10.2.8 (G5) Update

Mac OS X 10.2.7 (codenames Blackrider, Smeagol) was only available to the new Power Mac G5s and aluminum PowerBook G4s released before [Mac OS X Panther](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-3-Panther/). Officially, it was never released to the general public.

Mac OS X 10.2.8 is the last version of Mac OS X officially supported on the "Beige G3" desktop, minitower, and all-in-one systems as well as the PowerBook G3 Series (1998) also known as Wallstreet/PDQ; though later releases can be run on such Macs with the help of unofficial, unlicensed, and unsupported third-party tools such as XPostFacto. 

### Mac OS X 10.3 (Panther)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.3_Panther/Mac_OS_X_Panther_(logo).png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.3_Panther/Mac_OS_X_Panther_(logo).png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.3_Panther/AM_MacOSX_Panther.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.3_Panther/AM_MacOSX_Panther.png)

Version 	Build 	Date 	OS name 	Notes

10.3 	7B85 	October 24, 2003 	Darwin 7.0 	Original retail release set

7B86 	Server Edition

10.3.1 	7C107 	November 10, 2003 	Darwin 7.1 	Mac OS X Update 10.3.1: Information and Download

10.3.2 	7D24 	December 17, 2003 	Darwin 7.2 	Mac OS X: About the Mac OS X 10.3.2 Update

7D28 		Updated retail release

10.3.3 	7F44 	March 15, 2004 	Darwin 7.3 	Mac OS X: About the Mac OS X 10.3.3 Update (Combo)

10.3.4 	7H63 	May 26, 2004 	Darwin 7.4 	About the Mac OS X 10.3.4 Update

10.3.5 	7M34 	August 9, 2004 	Darwin 7.5 	About the Mac OS X 10.3.5 Update (Delta); Updated retail release set

10.3.6 	7R28 	November 5, 2004 	Darwin 7.6 	About the Mac OS X 10.3.6 Update (Delta)

10.3.7 	7S215 	December 15, 2004 	Darwin 7.7 	About the Mac OS X 10.3.7 Update (Delta)

10.3.8 	7U16 	February 9, 2005 	Darwin 7.8 	About the Mac OS X 10.3.8 Update (Delta)

10.3.9 	7W98 	April 15, 2005 	Darwin 7.9 	About the Mac OS X 10.3.9 Update (Delta)

### Mac OS X 10.4 (Tiger)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.4_Tiger/Macosx.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.4_Tiger/Macosx.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.4_Tiger/TigerDesk.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.4_Tiger/TigerDesk.png)

10.4 	8A428 	April 29, 2005 	Darwin 8.0 	Preinstalled on much of new line

8A432 	Original retail release

10.4.1 	8B15 	May 16, 2005 	Darwin 8.1 	About the Mac OS X 10.4.1 Update

8B17 	May 19, 2005 	Server edition

10.4.2 	8C46 	July 12, 2005 	Darwin 8.2 	About the Mac OS X 10.4.2 Update (Delta)

8C47 	Server edition

8E102 	October 12, 2005 	Exclusively for Front Row iMac G5 released on same date

8E45 	October 19, 2005 	Exclusively for PowerBook G4s released on same date

8E90 	Exclusively for Power Mac G5 Dual and Quad released on same date

10.4.3 	8F46 	October 31, 2005 	Darwin 8.3 	About the Mac OS X 10.4.3 Update (Delta) Updated retail release

10.4.4 	8G32 	January 10, 2006 	Darwin 8.4 	About the Mac OS X 10.4.4 Update (Delta) PowerPC

8G1165 	Shipped on initial Intel-based Macs

10.4.5 	8H14 	February 14, 2006 	Darwin 8.5 	About the Mac OS X 10.4.5 Update (delta) PowerPC

8G1454 	About the Mac OS X 10.4.5 Update (delta) Intel

10.4.6 	8I127 	April 3, 2006 	Darwin 8.6 	About the Mac OS X 10.4.6 Update (delta) PowerPC; Final retail release

8I1119 	About the Mac OS X 10.4.6 Update (delta) Intel

10.4.7 	8J135 	June 27, 2006 	Darwin 8.7 	About the Mac OS X 10.4.7 Update (delta) PowerPC

8J2135a 	About the Mac OS X 10.4.7 Update (delta) Intel

8K1079 	August 7, 2006 	exclusively for Mac Pro released the same date

8N5107 	exclusively for Apple TV (formerly codenamed iTV)

10.4.8 	8L127 	September 29, 2006 	Darwin 8.8 	About the Mac OS X 10.4.8 Update (delta)] PowerPC

8L2127 	Update (delta) Intel and Universal Server Edition

10.4.9 	8P135 	March 13, 2007 	Darwin 8.9 	About the Mac OS X 10.4.9 Update (delta) PowerPC

8P2137 	About the Mac OS X 10.4.9 Update (delta) Intel and Universal Server Edition

10.4.10 	8R218 	June 20, 2007 	Darwin 8.10 	About the Mac OS X 10.4.10 Update (delta) PowerPC

8R2218 	About the Mac OS X 10.4.10 Update (delta) Intel and Universal Server Edition

8R2232

10.4.11 	8S165 	November 14, 2007 	Darwin 8.11 	About the Mac OS X 10.4.11 Update PowerPC

8S2167 	About the Mac OS X 10.4.11 Update Intel and Universal Server Edition

### Mac OS X 10.5 (Leopard)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/Leopard_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/Leopard_Desktop.png)

Version 	Build 	Date 	OS name 	Notes 	Download

10.5 	9A581 	October 26, 2007 	Darwin 9.0 	Original retail DVD release 	N/A

10.5.1 	9B18 	November 15, 2007 	Darwin 9.1 	About the Mac OS X 10.5.1 Update; Second retail DVD release 	Mac OS X 10.5.1 Update

10.5.2 	9C31 	February 11, 2008 	Darwin 9.2 	About the Mac OS X 10.5.2 Update 	Mac OS X 10.5.2 Combo Update

9C7010

10.5.3 	9D34 	May 28, 2008 	Darwin 9.3 	About the Mac OS X 10.5.3 Update 	Mac OS X 10.5.3 Update

Mac OS X 10.5.3 Combo Update

10.5.4 	9E17 	June 30, 2008 	Darwin 9.4 	About the Mac OS X 10.5.4 update; Third retail DVD release 	Mac OS X 10.5.4 Update

Mac OS X 10.5.4 Combo Update

10.5.5 	9F33 	September 15, 2008 	Darwin 9.5 	About the Mac OS X 10.5.5 Update 	Mac OS X 10.5.5 Update

Mac OS X 10.5.5 Combo Update

10.5.6 	9G55 	December 15, 2008 	Darwin 9.6 	About the Mac OS X 10.5.6 Update 	Mac OS X 10.5.6 Update

Mac OS X 10.5.6 Combo Update

9G66 	January 6, 2009 	Fourth retail DVD release (part of Mac Box Set) 	N/A

10.5.7 	9J61 	May 12, 2009 	Darwin 9.7 	About the Mac OS X 10.5.7 Update 	Mac OS X 10.5.7 Update

Mac OS X 10.5.7 Combo Update

10.5.8 	9L30 	August 5, 2009 	Darwin 9.8 	About the Mac OS X 10.5.8 Update 	Mac OS X 10.5.8 Update

Mac OS X 10.5.8 Combo Update

### Mac OS X 10.6 (Snow Leopard)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.6_Snow_Leopard/Snow_Leopard_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.6_Snow_Leopard/Snow_Leopard_Desktop.png)

10.6 	10A432 	August 28, 2009 	Darwin 10.0 	Original retail DVD release 	N/A

10A433 	Server edition; Original retail DVD release

10.6.1 	10B504 	September 10, 2009 	Darwin 10.1 	About the Mac OS X v10.6.1 Update 	Mac OS X v10.6.1 Update

10.6.2 	10C540 	November 9, 2009 	Darwin 10.2 	About the Mac OS X v10.6.2 Update 	Mac OS X v10.6.2 Update

Mac OS X v10.6.2 Combo Update

10.6.3 	10D573 	March 29, 2010 	Darwin 10.3 	About the Mac OS X v10.6.3 Update 	Mac OS X v10.6.3 Update

10D575 	April 1, 2010 	Second retail DVD release 	N/A

10D578 	April 13, 2010 	About the Mac OS X v10.6.3 Update; v1.1 	Mac OS X v10.6.3 v1.1 Update (Combo)

10.6.4 	10F569 	June 15, 2010 	Darwin 10.4 	About the Mac OS X v10.6.4 Update 	Mac OS X v10.6.4 Update

Mac OS X v10.6.4 Update (Combo)

10.6.5 	10H574 	November 10, 2010 	Darwin 10.5 	About the Mac OS X v10.6.5 Update 	Mac OS X v10.6.5 Update

Mac OS X v10.6.5 Update (Combo)

10.6.6 	10J567 	January 6, 2011 	Darwin 10.6 	About the Mac OS X v10.6.6 Update 	Mac OS X v10.6.6 Update

Mac OS X v10.6.6 Update (Combo)

10.6.7 	10J869 	March 21, 2011 	Darwin 10.7 	About the Mac OS X v10.6.7 Update 	Mac OS X v10.6.7 Update

Mac OS X v10.6.7 Update (Combo)

10J3250 	For the early 2011 Macbook Pro 	Mac OS X v10.6.7 Update for early 2011 MacBook Pro

10J4138 	May 4, 2011 	For the early 2011 Macbook Pro 	MacBook Pro Software Update 1.4

10.6.8 	10K540 	June 23, 2011 	Darwin 10.8 	About the Mac OS X v10.6.8 Update 	Mac OS X v10.6.8 Update (Combo)

10K549 	July 25, 2011 	About the Mac OS X v10.6.8 Update; v1.1 	Mac OS X v10.6.8 Update v.1.1

Mac OS X v10.6.8 v1.1 Update (Combo)

Mac OS X Server includes these features and other server-related features. Apple initially stated that Server would include ZFS support, but mention of this feature later disappeared from Apple's website and it was not included in the final release due to licensing issues.

On January 27, 2016, Apple released an update for the Mac App Store on Mac OS X 10.6. The update was titled "Mac App Store Update for OS X Snow Leopard". The download was 3.5 MB.

## OS X Version history

[Main article: OS X version history](https://github.com/seanpm2001/WacOS/wiki/OS-X-version-history/)

***

## OS X version history

_Not to be confused with [Mac OS X Version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Version-history/), [Classic MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Classic-MacOS-version-history/), or [Modern MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Modern-MacOS-Version-history/)_

( **Predecessor:** [Mac OS X version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-version-history/) | **Successor:** [Modern MacOS Version history](https://github.com/seanpm2001/WacOS/wiki/Modern-MacOS-Version-history/) )

### OS X 10.7 (Lion)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/OS_X_Lion_icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/OS_X_Lion_icon.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/Mac_OSX_Lion_screen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/Mac_OSX_Lion_screen.png)

Version 	Build	Date 	OS name 	Notes 	Download

10.7 	11A511 	July 20, 2011 	Darwin 11.0 	Original retail Mac App Store release 	Available from the Mac App Store

11A511s 	August 16, 2011 	Original retail USB Thumb Drive release 	N/A

11A2061	July 20, 2011 	Darwin 11.0.2 	For Mid 2011 Mac Mini (11A2061) and Mid 2011 MacBook Air (11A2063) 	Lion Internet Recovery (⌘ Cmd+⌥ Opt+R upon reboot on Mid-2011 or later Macs)

11A2063

10.7.1 	11B26 	August 16, 2011 	Darwin 11.1.0 	About the OS X Lion v10.7.1 Update 	Mac OS X 10.7.1 Update

11B2118 	For the Mid 2011 Mac Mini and Mid 2011 MacBook Air 	Mac OS X 10.7.1 Update (for MacBook Air and Mac Mini 2011)

10.7.2 	11C74 	October 12, 2011 	Darwin 11.2 	About the OS X Lion v10.7.2 Update

Adds iCloud, various bug fixes, minor user interface tweaks, Safari 5.1.1, and the ability to boot into Lion Recovery from a Time Machine disk. 	Mac OS X 10.7.2 Update

Mac OS X 10.7.2 Update (Combo)

10.7.3 	11D50 	February 1, 2012 	Darwin 11.3 	About the OS X Lion v10.7.3 Update

Various bug fixes, Safari 5.1.3, adds Catalan, Croatian, Greek, Hebrew, Romanian, Slovak, Thai, and Ukrainian language support. 	Mac OS X 10.7.3 Update (Combo)

10.7.4 	11E53 	May 9, 2012 	Darwin 11.4 	About the OS X Lion v10.7.4 Update

Various bug fixes, Safari 5.1.6. 	Mac OS X 10.7.4

Mac OS X 10.7.4 Update (Combo)

10.7.5 	11G56 	September 19, 2012 	Darwin 11.4.2 	About the OS X Lion v10.7.5 Update

Various bug fixes, Safari 5.1.7, adds Gatekeeper functionality. 	Mac OS X 10.7.5 Update

Mac OS X 10.7.5 Update (Combo)

11G63 	October 4, 2012

### OS X 10.8 (Mountain Lion)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/MountainLionHero.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/MountainLionHero.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/OS_X_Mountain_Lion_Screenshot.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/OS_X_Mountain_Lion_Screenshot.jpg)

Version 	Build	Date 	OS name 	Notes 	Standalone download

10.8 	12A269 (GM) 	July 25, 2012 	Darwin 12.0 	Original retail Mac App Store release 	

10.8.1 	12B19 	August 23, 2012 	Darwin 12.1 	About OS X Mountain Lion v10.8.1 Update 	OS X v10.8.1 Individual update

10.8.2 	12C54 	September 19, 2012 	Darwin 12.2 	About OS X Mountain Lion v10.8.2 Update 	OS X v10.8.2 Individual update

OS X v10.8.2 Combo update

12C60 	October 4, 2012 	About OS X Mountain Lion v10.8.2 Update

(supplementary update described at the end)

OS X v10.8.2 Supplemental Update 1.0

12C2034 	October 23, 2012 	For Mac Mini (Late 2012) (Pulled)[

12C3104 	November 29, 2012 	For Mac Mini (Late 2012) 	OS X v10.8.2 Supplemental Update 2.0

10.8.3 	12D78 	March 14, 2013 	Darwin 12.3 	About OS X Mountain Lion v10.8.3 Update 	OS X v10.8.3 Individual update

OS X v10.8.3 Combo update

10.8.4 	12E55 	June 4, 2013 	Darwin 12.4 	About OS X Mountain Lion v10.8.4 Update 	OS X v10.8.4 Individual update

OS X v10.8.4 Combo update

12E3067 	June 10, 2013 	For MacBook Air (Mid 2013) 	

12E4022 	September 25, 2013 	For iMac (Late 2013) 	

10.8.5 	12F37 	September 12, 2013 	Darwin 12.5 	About the OS X Mountain Lion v10.8.5 Update 	OS X v10.8.5 Individual update

OS X v10.8.5 Combo update

12F45 	October 3, 2013 	About the OS X Mountain Lion v10.8.5 Supplemental Update 	OS X v10.8.5 Supplemental Update

12F2501 	March 9, 2015 	About Security Update 2015-002 	Security Update 2015-002 Mountain Lion

12F2518 	April 8, 2015 	About the security content of Security Update 2015-004 	Security Update 2015-004 Mountain Lion

12F2542 	June 30, 2015 	About the security content of Security Update 2015-005 	Security Update 2015-005 Mountain Lion

12F2560 	August 13, 2015 	About the security content of Security Update 2015-006 	Security Update 2015-006 Mountain Lion

Note: Combo updates include all previous releases (ex: 10.8 to 10.8.3). Individual update is a smaller package size and can be used if currently using the previous release (ex: 10.8.2 to 10.8.3).

### OS X 10.9 (Mavericks)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/Osx-mavericks-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/Osx-mavericks-logo.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/OS_X_Mavericks_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/OS_X_Mavericks_Desktop.png)

Version 	Build 	Date 	OS name 	Notes 	Standalone download

10.9 	13A603 (GM2) 	October 22, 2013 	Darwin 13.0 	Original Mac App Store release 	N/A

10.9.1 	13B42 	December 16, 2013 	About the OS X Mavericks v10.9.1 Update 	OS X Mavericks 10.9.1 Individual update

10.9.2 	13C64 	February 25, 2014 	Darwin 13.1 	About the OS X Mavericks v10.9.2 Update 	OS X Mavericks 10.9.2 Individual update

OS X Mavericks 10.9.2 Combo update

13C1021 	April 22, 2014 	About Security Update 2014-002 Mavericks 	Security Update 2014-002 Mavericks

10.9.3 	13D65 	May 15, 2014 	Darwin 13.2 	About the OS X Mavericks v10.9.3 Update 	OS X Mavericks 10.9.3 Individual update

OS X Mavericks 10.9.3 Combo update

10.9.4 	13E28 	June 30, 2014 	Darwin 13.3 	About the OS X Mavericks v10.9.4 Update 	OS X Mavericks 10.9.4 Individual update

OS X Mavericks 10.9.4 Combo update

10.9.5 	13F34 	September 17, 2014 	Darwin 13.4 	About the OS X Mavericks v10.9.5 Update 	OS X Mavericks 10.9.5 Individual update

OS X Mavericks 10.9.5 Combo update

October 16, 2014 	About the security content of Security Update 2014-005 Mavericks 	Security Update 2014-005 Mavericks

January 27, 2015 	About the security content of Security Update 2015-001 Mavericks 	Security Update 2015-001 Mavericks

13F1066 	March 9, 2015 	About the security content of Security Update 2015-002 Mavericks 	Security Update 2015-002 Mavericks

13F1077 	April 8, 2015 	About the security content of Security Update 2015-004 Mavericks 	Security Update 2015-004 Mavericks

13F1096 	June 30, 2015 	About the security content of Security Update 2015-005 Mavericks 	Security Update 2015-005 Mavericks

13F1112 	August 13, 2015 	About the security content of Security Update 2015-006 Mavericks 	Security Update 2015-006 Mavericks

13F1134 	October 21, 2015 	About the security content of Security Update 2015-007 Mavericks 	Security Update 2015-007 Mavericks

13F1507 	December 8, 2015 	About the security content of Security Update 2015-008 Mavericks 	Security Update 2015-008 Mavericks

13F1603 	January 19, 2016 	About the security content of Security Update 2016-001 Mavericks 	Security Update 2016-001 Mavericks

13F1712 	March 21, 2016 	About the security content of Security Update 2016-002 Mavericks 	Security Update 2016-002 Mavericks

13F1808 	May 16, 2016 	About the security content of Security Update 2016-003 Mavericks 	Security Update 2016-003 Mavericks

13F1911 	July 18, 2016 	About the security content of Security Update 2016-004 Mavericks 	Security Update 2016-004 Mavericks

### OS X 10.10 (Yosemite)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/Osx-yosemite-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/Osx-yosemite-logo.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/OS_X_Yosemite_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/OS_X_Yosemite_Desktop.png)

Version 	Build 	Date 	OS name 	Notes 	Standalone download

10.10 	14A389 	October 16, 2014 	Darwin 14.0 	Original Mac App Store release 	N/A

10.10.1 	14B25 	November 17, 2014 	About the OS X Yosemite v10.10.1 Update 	OS X Yosemite 10.10.1 Individual update

10.10.2 	14C109 	January 27, 2015 	Darwin 14.1 	About the OS X Yosemite v10.10.2 Update 	OS X Yosemite 10.10.2 Individual update

OS X Yosemite 10.10.2 Combo update

14C1510 	March 9, 2015 	About Security Update 2015-002 Yosemite 	Security Update 2015-002 Yosemite

14C1514 	March 19, 2015 	About Security Update 2015-003 Yosemite 	Security Update 2015-003 Yosemite

14C2043 	March 10, 2015 	Security Update 2015-003

Shipped with Early 2015 MacBook Air – Forked build

N/A

14C2513 	March 20, 2015

10.10.3 	14D131 	April 8, 2015 	Darwin 14.3 	About the OS X Yosemite v10.10.3 Update

This release unified the previously forked build for the early 2015 MacBook Air 	OS X Yosemite 10.10.3 Individual update

OS X Yosemite 10.10.3 Combo update

14D136 	April 16, 2015 	Supplemental Update

Fixes issue with video driver issue that may prevent Mac from starting up when running certain apps that capture video 	OS X Yosemite 10.10.3 Supplemental Update 1.0

10.10.4 	14E46 	June 30, 2015 	Darwin 14.4 	About the OS X Yosemite v10.10.4 Update 	OS X Yosemite 10.10.4 Individual update

OS X Yosemite 10.10.4 Combo update

10.10.5 	14F27 	August 13, 2015 	Darwin 14.5 	About the OS X Yosemite v10.10.5 Update 	OS X Yosemite 10.10.5 Individual update

OS X Yosemite 10.10.5 Combo update

14F1021 	October 21, 2015 	About the security content of Security Update 2015-004 Yosemite 	Security Update 2015-004 Yosemite

14F1505 	November 12, 2015 	About the security content of Security Update 2015-005 Yosemite 	Included in Security Update 2015-006 Yosemite

14F1509 	December 11, 2015 	About the security content of Security Update 2015-006 Yosemite 	Security Update 2015-006 Yosemite

14F1605 	January 19, 2016 	About the security content of Security Update 2016-001 Yosemite 	Security Update 2016-001 Yosemite

14F1713 	March 21, 2016 	About the security content of Security Update 2016-002 Yosemite 	Security Update 2016-002 Yosemite

14F1808 	May 18, 2016 	About the security content of Security Update 2016-003 Yosemite 	Security Update 2016-003 Yosemite

14F1909 	July 18, 2016 	About the security content of Security Update 2016-004 Yosemite 	Security Update 2016-004 Yosemite

14F1912 	September 1, 2016 	About the security content of Security Update 2016-005 Yosemite 	Included in Security Update 2016-006 Yosemite

14F2009 	October 24, 2016 	About the security content of Security Update 2016-006 Yosemite 	Security Update 2016-006 Yosemite

14F2109 	December 13, 2016 	About the security content of Security Update 2016-007 Yosemite 	Security Update 2016-007 Yosemite

14F2315 	March 27, 2017 	About the security content of Security Update 2017-001 Yosemite 	Security Update 2017-001 Yosemite

14F2411 	May 15, 2017 	About the security content of Security Update 2017-002 Yosemite 	Security Update 2017-002 Yosemite

14F2511 	July 19, 2017 	About the security content of Security Update 2017-003 Yosemite 	Security Update 2017-003 Yosemite

### OS X 10.11 (El Capitan)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.11_El_Capitan/OS_X_El_Capitan_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.11_El_Capitan/OS_X_El_Capitan_logo.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.11_El_Capitan/OS_X_El_Capitan_screenshot.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.11_El_Capitan/OS_X_El_Capitan_screenshot.png)

Version 	Build 	Date 	Darwin 	Notes 	Standalone download

10.11 	15A284 	September 30, 2015 	15.0.0 	Original Mac App Store release 	N/A

10.11.1 	15B42 	October 21, 2015 	About the OS X El Capitan v10.11.1 Update 	OS X El Capitan 10.11.1 Update

10.11.2 	15C50 	December 8, 2015 	15.2.0 	About the OS X El Capitan v10.11.2 Update 	OS X El Capitan 10.11.2 Update

OS X El Capitan 10.11.2 Combo Update

10.11.3 	15D21 	January 19, 2016 	15.3.0 	About the OS X El Capitan v10.11.3 Update 	OS X El Capitan 10.11.3 Update

OS X El Capitan 10.11.3 Combo Update

10.11.4 	15E65 	March 21, 2016 	15.4.0 	About the OS X El Capitan v10.11.4 Update 	OS X El Capitan 10.11.4 Update

OS X El Capitan 10.11.4 Combo Update

10.11.5 	15F34 	May 16, 2016 	15.5.0 	About the OS X El Capitan v10.11.5 Update 	OS X El Capitan 10.11.5 Update

OS X El Capitan 10.11.5 Combo Update

10.11.6 	15G31 	July 18, 2016 	15.6.0 	About the OS X El Capitan v10.11.6 Update 	OS X El Capitan 10.11.6 Update

OS X El Capitan 10.11.6 Combo Update

15G1004 	September 1, 2016 	About the security content of Security Update 2016-001 El Capitan 	Security Update 2016-001 El Capitan

15G1011 			

15G1108 	October 24, 2016 	About the security content of Security Update 2016-002 El Capitan 	Security Update 2016-002 El Capitan

15G1212 	December 13, 2016 	About the security content of Security Update 2016-003 El Capitan 	Security Update 2016-003 El Capitan

15G1217 	January 17, 2017 	About the security content of Security Update 2016-003 El Capitan 	Security Update 2016-003 El Capitan

Security Update 2016-003 Supplemental (10.11.6)

15G1421 	March 27, 2017 	About the security content of Security Update 2017-001 El Capitan 	Security Update 2017-001 El Capitan

15G1510 	May 15, 2017 	About the security content of Security Update 2017-002 El Capitan 	Security Update 2017-002 El Capitan

15G1611 	July 19, 2017 	About the security content of Security Update 2017-003 El Capitan 	Security Update 2017-003 El Capitan

15G17023 	October 31, 2017 	About the security content of Security Update 2017-004 El Capitan 	Security Update 2017-004 El Capitan

15G18013 	December 6, 2017 	About the security content of Security Update 2017-005 El Capitan 	Security Update 2017-005 El Capitan

15G19009 	January 23, 2018 	About the security content of Security Update 2018-001 El Capitan 	Security Update 2018-001 El Capitan

15G20015 	March 29, 2018 	About the security content of Security Update 2018-002 El Capitan 	Security Update 2018-002 El Capitan

15G21013 	June 1, 2018 	About the security content of Security Update 2018-003 El Capitan 	Security Update 2018-003 El Capitan

15G22010 	July 9, 2018 	About the security content of Security Update 2018-004 El Capitan 	Security Update 2018-004 El Capitan

## Modern MacOS version history

[Main article: Modern MacOS version history](https://github.com/seanpm2001/WacOS/wiki/Modern-MacOS-version-history/)

( **Predecessor:** [OS X version history](https://github.com/seanpm2001/WacOS/wiki/OS-X-version-history/) | **Successor:** `None` )

## MacOS 10.12 (Sierra)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_wordmark.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.12_Sierra/MacOS_Sierra_Desktop.png)


**Unsupported**

Version 	Build 	Release date 	Darwin 	Notes 	Standalone download

10.12 	16A323 	September 20, 2016 	16.0.0 	Original Mac App Store release 	N/A

10.12.1 	16B2555 	October 24, 2016 	16.1.0 	About the macOS Sierra 10.12.1 Update 	macOS Sierra 10.12.1 Update

16B2657 	October 27, 2016

10.12.2 	16C67 	December 13, 2016 	16.3.0 	About the macOS Sierra 10.12.2 Update 	macOS Sierra 10.12.2 Update

macOS Sierra 10.12.2 Combo Update

16C68 	December 14, 2016

10.12.3 	16D32 	January 23, 2017 	16.4.0 	About the macOS Sierra 10.12.3 Update 	macOS Sierra 10.12.3 Update

macOS Sierra 10.12.3 Combo Update

10.12.4 	16E195 	March 27, 2017 	16.5.0 	About the macOS Sierra 10.12.4 Update 	macOS Sierra 10.12.4 Update

macOS Sierra 10.12.4 Combo Update

10.12.5 	16F73 	May 15, 2017 	16.6.0 	About the macOS Sierra 10.12.5 Update 	macOS Sierra 10.12.5 Update

macOS Sierra 10.12.5 Combo Update

16F2073 	June 5, 2017

10.12.6 	16G29 	July 19, 2017 	16.7.0 	About the macOS Sierra 10.12.6 Update 	macOS Sierra 10.12.6 Update

macOS Sierra 10.12.6 Combo Update

16G1036 	October 31, 2017 	About the security content of Security Update 2017-001 Sierra 	Security Update 2017-001 Sierra

16G1114 	December 6, 2017 	About the security content of Security Update 2017-002 Sierra 	Security Update 2017-002 Sierra

16G1212 	January 23, 2018 	About the security content of Security Update 2018-001 Sierra 	Security Update 2018-001 Sierra

16G1314 	March 29, 2018 	About the security content of Security Update 2018-002 Sierra 	Security Update 2018-002 Sierra

16G1408 	June 1, 2018 	About the security content of Security Update 2018-003 Sierra 	Security Update 2018-003 Sierra

16G1510 	July 9, 2018 	About the security content of Security Update 2018-004 Sierra 	Security Update 2018-004 Sierra

16G1618 	October 30, 2018 	About the security content of Security Update 2018-005 Sierra 	Security Update 2018-005 Sierra

16G1710 	December 5, 2018 	About the security content of Security Update 2018-006 Sierra 	Security Update 2018-006 Sierra

16G1815 	January 22, 2019 	About the security content of Security Update 2019-001 Sierra 	Security Update 2019-001 Sierra

16G1917 	March 25, 2019 	About the security content of Security Update 2019-002 Sierra 	Security Update 2019-002 Sierra

16G1918 	March 29, 2019 	About the security content of Security Update 2019-002 Sierra 	Security Update 2019-002 Sierra

16G2016 	May 14, 2019 	About the security content of Security Update 2019-003 Sierra 	Security Update 2019-003 Sierra

16G2127 	July 22, 2019 	About the security content of Security Update 2019-004 Sierra 	Security Update 2019-004 Sierra

16G2128 	July 29, 2019 	About the security content of Security Update 2019-004 Sierra 	Security Update 2019-004 Sierra

16G2136 	September 26, 2019 	About the security content of Security Update 2019-005 Sierra 	Security Update 2019-005 Sierra

## MacOS 10.13 (High Sierra)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.13_High_Sierra/MacOS_High_Sierra_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.13_High_Sierra/MacOS_High_Sierra_wordmark.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.13_High_Sierra/MacOS_High_Sierra_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.13_High_Sierra/MacOS_High_Sierra_Desktop.png)

Version 	Build 	Date 	Darwin 	Notes 	Standalone download

10.13 	17A365 	September 25, 2017 	17.0.0 	Original Mac App Store release

About the security content of macOS High Sierra 10.13 	N/A

17A405 	October 5, 2017 	About the security content of macOS High Sierra 10.13 Supplemental Update 	macOS 10.13 Supplemental

10.13.1 	17B48 	October 31, 2017 	17.2.0 	About the macOS High Sierra 10.13.1 Update

About the security content of macOS High Sierra 10.13.1 	macOS High Sierra 10.13.1 update

17B1002 	November 29, 2017 	About the security content of Security Update 2017-001 	Security Update 2017-001 macOS High Sierra v10.13.1

17B1003

10.13.2 	17C88 	December 6, 2017 	17.3.0 	About the macOS High Sierra 10.13.2 Update

About the security content of macOS High Sierra 10.13.2 	macOS High Sierra 10.13.2 Update

macOS High Sierra 10.13.2 Combo Update

17C89

17C205 	January 8, 2018 	About the security content of macOS High Sierra 10.13.2 Supplemental Update 	macOS High Sierra 10.13.2 Supplemental

17C2205

10.13.3 	17D47 	January 23, 2018 	17.4.0 	About the macOS High Sierra 10.13.3 Update

About the security content of macOS High Sierra 10.13.3 	macOS High Sierra 10.13.3 Update

macOS High Sierra 10.13.3 Combo Update

17D2047

17D102 	February 19, 2018 	About the security content of macOS High Sierra 10.13.3 Supplemental Update 	macOS High Sierra 10.13.3 Supplemental

17D2102

10.13.4 	17E199 	March 29, 2018 	17.5.0 	About the macOS High Sierra 10.13.4 Update

About the security content of macOS High Sierra 10.13.4 	macOS High Sierra 10.13.4 Update

macOS High Sierra 10.13.4 Combo Update

17E202 	April 24, 2018 	About the security content of Security Update 2018-001 	Security Update 2018-001 macOS High Sierra v10.13.4

10.13.5 	17F77 	June 1, 2018 	17.6.0 	About the macOS High Sierra 10.13.5 Update

About the security content of macOS High Sierra 10.13.5 	macOS High Sierra 10.13.5 Update

macOS High Sierra 10.13.5 Combo Update

10.13.6 	17G66 	July 9, 2018 	17.7.0 	About the macOS High Sierra 10.13.6 Update

About the security content of macOS High Sierra 10.13.6 	macOS High Sierra 10.13.6 Update

macOS High Sierra 10.13.6 Combo Update

17G2208

17G3025 	October 30, 2018 	17.7.0 	About the security content of Security Update 2018-002 High Sierra 	Security Update 2018-002 High Sierra

17G4015 	December 5, 2018 	17.7.0 	About the security content of Security Update 2018-003 High Sierra 	Security Update 2018-003 High Sierra

17G5019 	January 22, 2019 	17.7.0 	About the security content of Security Update 2019-001 High Sierra 	Security Update 2019-001 High Sierra

17G6029 	March 25, 2019 	17.7.0 	About the security content of Security Update 2019-002 High Sierra 	Security Update 2019-002 High Sierra

17G6030 	March 29, 2019 	17.7.0 	About the security content of Security Update 2019-002 High Sierra 	Security Update 2019-002 High Sierra

17G7024 	May 13, 2019 	17.7.0 	About the security content of Security Update 2019-003 High Sierra 	Security Update 2019-003 High Sierra

17G8029 	July 22, 2019 	17.7.0 	About the security content of Security Update 2019-004 High Sierra 	Security Update 2019-004 High Sierra

17G8030 	July 29, 2019 	17.7.0 	About the security content of Security Update 2019-004 High Sierra 	Security Update 2019-004 High Sierra

17G8037 	September 26, 2019 	17.7.0 	About the security content of Security Update 2019-005 High Sierra 	Security Update 2019-005 High Sierra

17G9016 	October 29, 2019 	17.7.0 	About the security content of Security Update 2019-006 High Sierra 	Security Update 2019-006 High Sierra

17G10021 	December 10, 2019 	17.7.0

xnu-4570.71.63~1 	About the security content of Security Update 2019-007 High Sierra 	Security Update 2019-007 High Sierra

17G11023 	January 28, 2020 	17.7.0

xnu-4570.71.69~1 	About the security content of Security Update 2020-001 High Sierra 	Security Update 2020-001 High Sierra

17G12034 	March 24, 2020 	17.7.0

xnu-4570.71.73~1 	About the security content of Security Update 2020-002 High Sierra 	Security Update 2020-002 High Sierra

17G13033 	May 26, 2020 	17.7.0

xnu-4570.71.80~1 	About the security content of Security Update 2020-003 High Sierra 	Security Update 2020-003 High Sierra

17G13035 	June 1, 2020 	17.7.0

xnu-4570.71.80.1~1 	About the security content of Security Update 2020-003 High Sierra 	Security Update 2020-003 High Sierra

17G14019 	July 15, 2020 	17.7.0

xnu-4570.71.82.5~1 	About the security content of Security Update 2020-004 High Sierra 	Security Update 2020-004 High Sierra

17G14033 	September 24, 2020 	17.7.0

xnu-4570.71.82.6~1 	About the security content of Security Update 2020-005 High Sierra 	Security Update 2020-005 High Sierra

17G14042 	November 12, 2020 	17.7.0

xnu-4570.71.82.8~1 	About the security content of Security Update 2020-006 High Sierra 	Security Update 2020-006 High Sierra

## MacOS 10.14 (Mojave)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.14_Mojave/MacOS_Mojave_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.14_Mojave/MacOS_Mojave_wordmark.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.14_Mojave/Mojave_desktop_marzipan.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.14_Mojave/Mojave_desktop_marzipan.jpg)

_This release is still actively updated as of writing this (2021, Friday September 24th) and will need future updates._

**Previous release** 		**Current release**

Version 	Build 	Date 	Darwin 	Release Notes 	Standalone download

10.14 	18A391 	September 24, 2018 	18.0.0 	Original Mac App Store release

About the security content of macOS Mojave 10.14 	N/A

10.14.1 	18B75 	October 30, 2018 	18.2.0

xnu-4903.221.2~2 	About the macOS Mojave 10.14.1 Update

About the security content of macOS Mojave 10.14.1 	macOS Mojave 10.14.1 Update

18B2107 	October 30, 2018 		Added support for the new Vega GPUs in the MacBook Pro and MacBook Air 	

18B3094

10.14.2 	18C54 	December 5, 2018 	18.2.0

xnu-4903.231.4~2 	About the macOS Mojave 10.14.2 Update

About the security content of macOS Mojave 10.14.2 	macOS Mojave 10.14.2 Update

macOS Mojave 10.14.2 Combo Update

10.14.3 	18D42 	January 22, 2019 	18.2.0

xnu-4903.241.1~4 	About the macOS Mojave 10.14.3 Update

About the security content of macOS Mojave 10.14.3 	macOS Mojave 10.14.3 Update

macOS Mojave 10.14.3 Combo Update

18D43 	January 25, 2019

18D109 	February 7, 2019 	About the security content of macOS Mojave 10.14.3 Supplemental Update 	macOS Mojave 10.14.3 Supplemental Update

10.14.4 	18E226 	March 25, 2019 	18.5.0

xnu-4903.251.3~3 	About the macOS Mojave 10.14.4 Update

About the security content of macOS Mojave 10.14.4 	macOS Mojave 10.14.4 Update

macOS Mojave 10.14.4 Combo Update

18E227

10.14.5 	18F132 	May 13, 2019 	18.6.0

xnu-4903.261.4~2 	About the macOS Mojave 10.14.5 Update

About the security content of macOS Mojave 10.14.5 	macOS Mojave 10.14.5 Update

macOS Mojave 10.14.5 Combo Update

10.14.6 	18G84 	July 22, 2019 	18.7.0

xnu-4903.270.47~4 	About the macOS Mojave 10.14.6 Update

About the security content of macOS Mojave 10.14.6 	macOS Mojave 10.14.6 Update

macOS Mojave 10.14.6 Combo Update

18G87 	August 1, 2019 	Addressed the Wake from Sleep bug, which caused Macs not waking from sleep properly. 	macOS Mojave 10.14.6 Supplemental Update

18G95 	August 26, 2019 	18.7.0

xnu-4903.271.2~2 	Security updates and bug fixes

Addressed: MacBooks shutting down during sleep

Addressed: Performance throttling when handling large files

Addressed: iLife applications (Pages, Keynote, Numbers, GarageBand, and iMovie) not updating

Re-patched a vulnerability that was accidentally unpatched in the previous update, which could lead to hacking attempts

macOS Mojave 10.14.6 Supplemental Update

18G103 	September 26, 2019 	Security updates and bug fixes 	macOS Mojave 10.14.6 Supplemental Update

18G1012 	October 29, 2019 	18.7.0

xnu-4903.278.12~4 	About the security content of Security Update 2019-001 	Security Update 2019-001 (Mojave)

18G2022 	December 10, 2019 	18.7.0

xnu-4903.278.19~1 	About the security content of Security Update 2019-002 	Security Update 2019-002 (Mojave)

18G3020 	January 28, 2020 	18.7.0

xnu-4903.278.25~1 	About the security content of Security Update 2020-001 	Security Update 2020-001 (Mojave)

18G4032 	March 24, 2020 	18.7.0

xnu-4903.278.28~1 	About the security content of Security Update 2020-002 	Security Update 2020-002 (Mojave)

18G5033 	May 26, 2020 	18.7.0

xnu-4903.278.35~1 	About the security content of Security Update 2020-003 	Security Update 2020-003 (Mojave)

18G6020 	July 15, 2020 	18.7.0

xnu-4903.278.43~1 	About the security content of Security Update 2020-004 	Security Update 2020-004 (Mojave)

18G6032 	September 24, 2020 	18.7.0

xnu-4903.278.44~1

Pulled 2020-09-30 	About the security content of Security Update 2020-005 	Security Update 2020-005 (Mojave)

18G6032 	October 1, 2020 	18.7.0

xnu-4903.278.44~1

About the security content of macOS 10.14.6 Supplemental Update 	Security Update 2020-005 (Mojave)

18G6042 	November 12, 2020 	18.7.0

xnu-4903.278.44.0.2~1

About the security content of Security Update 2020-006 	Security Update 2020-006 (Mojave)

18G7016 	December 14, 2020 	18.7.0

xnu-4903.278.51~1

About the security content of Security Update 2020-007 	Security Update 2020-007 (Mojave)

18G8012 	February 1, 2021 	18.7.0

xnu-4903.278.56~1

About the security content of Security Update 2021-001 	Security Update 2021-001 (Mojave)

18G8022 	February 9, 2021 	About the security content of Security Update 2021-002 	Security Update 2021-002 (Mojave)

18G9028 	April 26, 2021 	18.7.0

xnu-4903.278.65~1

About the security content of Security Update 2021-003 	Security Update 2021-003 (Mojave)

18G9216 	May 24, 2021 	18.7.0

xnu-4903.278.68~1

About the security content of Security Update 2021-004 	Security Update 2021-004 (Mojave)

18G9323 	July 21, 2021 	18.7.0

xnu-4903.278.70~1

About the security content of Security Update 2021-005 	Security Update 2021-005 (Mojave)

## MacOS 10.15 (Catalina)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.15_Catalina/MacOS_Catalina_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.15_Catalina/MacOS_Catalina_wordmark.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.15_Catalina/MacOS_Catalina_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_10/10.15_Catalina/MacOS_Catalina_Desktop.png)

_This release is still actively updated as of writing this (2021, Friday September 24th) and will need future updates._

**Previous release** 		**Current release**

Version 	Build 	Date 	Darwin 	Release Notes 	Standalone download

10.15 	19A583 	October 7, 2019 	19.0.0 	Original Software Update release

Security content
	
19A602 	October 15, 2019 	Supplemental update 	

19A603 	October 21, 2019 	Revised Supplemental update 	

10.15.1 	19B88 	October 29, 2019 	19.0.0

xnu-6153.41.3~29 	About the macOS Catalina 10.15.1 Update

Security content

macOS 10.15.1 Update

10.15.2 	19C57 & 19C58 	December 10, 2019 	19.2.0

xnu-6153.61.1~20 	About the macOS Catalina 10.15.2 Update

Security content

macOS 10.15.2 Update

macOS 10.15.2 Combo Update

10.15.3 	19D76 	January 28, 2020 	19.3.0

xnu-6153.81.5~1 	About the macOS Catalina 10.15.3 Update

Security content

macOS 10.15.3 Update

macOS 10.15.3 Combo Update

10.15.4 	19E266 	March 24, 2020 	19.4.0

xnu-6153.101.6~15 	About the macOS Catalina 10.15.4 Update

Security content

macOS 10.15.4 Update

macOS 10.15.4 Combo Update

19E287 	April 8, 2020 	Supplemental update 	macOS 10.15.4 Supplemental Update

10.15.5 	19F96 	May 26, 2020 	19.5.0

xnu-6153.121.1~7 	About the macOS Catalina 10.15.5 Update

Security content

macOS 10.15.5 Update

macOS 10.15.5 Combo Update

19F101 	June 1, 2020 	19.5.0

xnu-6153.121.2~2 	Supplemental update

Security content

macOS 10.15.5 Supplemental Update

10.15.6 	19G73 	July 15, 2020 	19.6.0

xnu-6153.141.1~9

Jul 5 00:43:10 PDT 2020 	About the macOS Catalina 10.15.6 Update

Security content

macOS 10.15.6 Update

macOS 10.15.6 Combo Update

19G2021 	August 12, 2020 	19.6.0

xnu-6153.141.1~1

Jun 18 20:49:00 PDT 2020 	Supplemental update 	macOS 10.15.6 Supplemental Update

10.15.7 	19H2 	September 24, 2020 	19.6.0

xnu-6153.141.2~1

Mon Aug 31 22:12:52 PDT 2020 	About the macOS Catalina 10.15.7 Update

Security content

macOS 10.15.7 Update

macOS 10.15.7 Combo Update

19H4 	October 27, 2020

19H15 	November 5, 2020 	19.6.0

xnu-6153.141.2.2~1

Thu Oct 29 22:56:45 PDT 2020 	Supplemental update

Security content

macOS 10.15.7 Supplemental Update

macOS 10.15.7 Supplemental Update (Combo)

19H114 	December 14, 2020 	19.6.0

xnu-6153.141.10~1

Tue Nov 10 00:10:30 PST 2020 	About the security content of Security Update 2020-001 	Security Update 2020-001 (Catalina)

19H512 	February 1, 2021 	19.6.0

xnu-6153.141.16~1

Tue Jan 12 22:13:05 PST 2021 	About the security content of Security Update 2021-001 	Security Update 2021-001 (Catalina)

19H524 	February 9, 2021 	Supplemental Update

Security content

macOS Catalina 10.15.7 Supplemental Update 2

19H1030 	April 26, 2021 	19.6.0

xnu-6153.141.28.1~1

Mon Apr 12 20:57:45 PDT 2021 	About the security content of Security Update 2021-002 	Security Update 2021-002 (Catalina)

19H1217 	May 24, 2021 	19.6.0

xnu-6153.141.33~1

Thu May 6 00:48:39 PDT 2021 	About the security content of Security Update 2021-003 	Security Update 2021-003 (Catalina)

19H1323 	July 21, 2021 	19.6.0

xnu-6153.141.35~1

Thu Jun 22 19:49:55 PDT 2021 	About the security content of Security Update 2021-004 	Security Update 2021-004 (Catalina)

19H1417 	September 13, 2021 	19.6.0

xnu-6153.141.40~1

Tue Aug 24 20:28:00 PDT 2021 	About the security content of Security Update 2021-005 	Security Update 2021-005 (Catalina)

19H1419 	September 23, 2021 	19.6.0

xnu-6153.141.40.1~1

Thu Sep 16 20:58:47 PDT 2021 	About the security content of Security Update 2021-006 	Security Update 2021-006 (Catalina)

## MacOS 11.0 (Big Sur)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_11/MacOS_Big_Sur_wordmark_2.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_11/MacOS_Big_Sur_wordmark_2.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_11/MacOS_Big_Sur_Beta_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_11/MacOS_Big_Sur_Beta_Desktop.png)

_This release is still actively updated as of writing this (2021, Friday September 24th) and will need future updates._

**Previous release** 		**Current release** 		**Current developer release**

Version 	Build 	Date 	Darwin version 	Release notes 	Notes

11.0 	20A2411 	November 17, 2020 	20.1.0

xnu-7195.41.8~9 	N/A 	Preinstalled on MacBook Air (M1, 2020), MacBook Pro (13-inch, M1, 2020), and Mac mini (M1, 2020)

11.0.1 	20B29 	November 12, 2020 	20.1.0

xnu-7195.50.7~2 	Security content 	Initial public release

20B50 	November 19, 2020 		Available for all Macs except Late 2013 and Mid 2014 13" MacBook Pros

11.1 	20C69 	December 14, 2020 	20.2.0

xnu-7195.60.75~1 	Release notes

Security content
	
11.2 	20D64 	February 1, 2021 	20.3.0

xnu-7195.81.3~1 	Release notes

Security content
	
11.2.1 	20D74 	February 9, 2021 	Security content 	

20D75 	February 15, 2021 	Fixes bug where installation with insufficient free space could cause data loss - exclusive to the full installer[58]

11.2.2 	20D80 	February 25, 2021 	N/A 	

11.2.3 	20D91 	March 8, 2021 	Security content 	

11.3 	20E232 	April 26, 2021 	20.4.0

xnu-7195.101.1~3 	Release notes

Security content
	
11.3.1 	20E241 	May 3, 2021 	20.4.0

xnu-7195.101.2~1 	Security content 	

11.4 	20F71 	May 24, 2021 	20.5.0

xnu-7195.121.3~9 	Release notes

Security content
	
11.5 	20G71 	July 21, 2021 	20.6.0

xnu-7195.141.2~5

Wed Jun 23 00:26:31 PDT 2021 	Release notes

Security content
	
11.5.1 	20G80 	July 26, 2021 	Release notes

Security content
	
11.5.2 	20G95 	August 11, 2021 	Release notes 	

11.6 	20G165 	September 13, 2021 	20.6.0

xnu-7195.141.6~3

Mon Aug 30 06:12:21 PDT 2021 	Release notes

Security content

## MacOS 12.0 (Monterey)
![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_12/12.0_Monterey/MacOS_Monterey_wordmark.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_12/12.0_Monterey/MacOS_Monterey_wordmark.svg)

No desktop screenshot available yet

_This release is still actively updated as of writing this (2021, Friday September 24th) and will need future updates._

Release history

**Previous release** 		**Current release** 		**Current developer release**

Version 	Build 	Date 	Darwin version 	Release notes 	Notes

12.0 Beta 1 	21A5248p 	June 7, 2021 	21.0.0 	macOS Monterey 12 Beta 1 Release Notes 	

12.0 Beta 2 	21A5268h 	June 28, 2021 		macOS Monterey 12 Beta 2 Release Notes 	

12.0 Beta 3 	21A5284e 	July 14, 2021 		macOS Monterey 12 Beta 3 Release Notes 	

12.0 Beta 4 	21A5294g 	July 27, 2021 		macOS Monterey 12 Beta 4 Release Notes 	

12.0 Beta 5 	21A5304g 	August 11, 2021 		macOS Monterey 12 Beta 5 Release Notes 	

12.0 Beta 6 	21A5506j 	August 30, 2021 		macOS Monterey 12 Beta 6 Release Notes 	

12.0 Beta 7 	21A5522h 	September 21, 2021 		macOS Monterey 12 Beta 7 Release Notes

***

## Sources

[Wikipedia - Classic MacOS](https://en.wikipedia.org/wiki/Classic_Mac_OS)

[Wikipedia - System 1](https://en.wikipedia.org/wiki/System_1)

[Wikipedia - System 6](https://en.wikipedia.org/wiki/System_6)

[Wikipedia - System 7 / Mac OS 7](https://en.wikipedia.org/wiki/System_7)

[Wikipedia - Mac OS 8](https://en.wikipedia.org/wiki/Mac_OS_8)

[Wikipedia - Mac OS 9](https://en.wikipedia.org/wiki/Mac_OS_9)

[Wikipedia - Mac OS X Server 1.0](https://en.wikipedia.org/wiki/Mac_OS_X_Server_1.0)

[Wikipedia - Mac OS X 10.0 Public Beta](https://en.wikipedia.org/wiki/Mac_OS_X_Public_Beta)

[Wikipedia - Mac OS X 10.0 (Cheetah)](https://en.wikipedia.org/wiki/Mac_OS_X_10.0)

[Wikipedia - Mac OS X 10.1 (Puma)](https://en.wikipedia.org/wiki/Mac_OS_X_10.1)

[Wikipedia - Mac OS X 10.2 (Jaguar)](https://en.wikipedia.org/wiki/Mac_OS_X_Jaguar)

[Wikipedia - Mac OS X 10.3 (Panther)](https://en.wikipedia.org/wiki/Mac_OS_X_Panther)

[Wikipedia - Mac OS X 10.4 (Tiger)](https://en.wikipedia.org/wiki/Mac_OS_X_Tiger)

[Wikipedia - Mac OS X 10.5 (Leopard)](https://en.wikipedia.org/wiki/Mac_OS_X_Leopard)

[Wikipedia - Mac OS X 10.6 (Snow Leopard)](https://en.wikipedia.org/wiki/Mac_OS_X_Snow_Leopard)

[Wikipedia - OS X 10.7 (Lion)](https://en.wikipedia.org/wiki/OS_X_Lion)

[Wikipedia - OS X 10.8 (Mountain Lion)](https://en.wikipedia.org/wiki/OS_X_Mountain_Lion)

[Wikipedia - OS X 10.9 (Mavericks)](https://en.wikipedia.org/wiki/OS_X_Mavericks)

[Wikipedia - OS X 10.10 (Yosemite)](https://en.wikipedia.org/wiki/OS_X_Yosemite)

[Wikipedia - OS X 10.11 (El Capitan](https://en.wikipedia.org/wiki/OS_X_El_Capitan)

[Wikipedia - MacOS 10.12 (Sierra)](https://en.wikipedia.org/wiki/MacOS_Sierra)

[Wikipedia - MacOS 10.13 (High Sierra)](https://en.wikipedia.org/wiki/MacOS_High_Sierra)

[Wikipedia - MacOS 10.14 (Mojave)](https://en.wikipedia.org/wiki/MacOS_Mojave)

[Wikipedia - MacOS 10.15 (Catalina)](https://en.wikipedia.org/wiki/MacOS_Catalina)

[Wikipedia - MacOS 11.0 (Big Sur)](https://en.wikipedia.org/wiki/MacOS_Big_Sur)

[Wikipedia - MacOS 12.0 (Monterey)](https://en.wikipedia.org/wiki/MacOS_Monterey)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## See also

[Complete iOS version history](https://github.com/seanpm2001/WacOS/wiki/Complete-iOS-version-history/)

***

## Article info

**Written on:** `2021 Friday September 24th at 2:55 pm`

**Last revised on:** `2021 Friday September 24th at 2:55 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `1,615`

**Language:** `English (US) / Markdown`

**Article version:** `1 (2021 Friday September 24th at 2:55 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

