
***

# Regarding criticism to Skeuomorphism

This article is currently an early draft. It is still in development.

## 2021 September

On 2021 September 24th, around midnight, I came across a comment that kind of shocked me, as someone was criticizing skeuomorphism, and they used the exact wording I used a year ago ("flat and soulless") in a quick title to a GitHub Gist. I am not sure if they read it from my profile and repeated it without knowing/with knowing/this was a common phrase and you don't own it, but it peaked my interests in defending Skeuomorphism again.

This document will go over the common criticisms I see with Skeuomorphism. I don't want it to become something that you have to tell the difference between (like vegetarianism and veganism, or Socialism and Communism)

## "flat and soulless"

This is a common term for criticizing flat design, people don't always care to look into the meaning, they just flaunt the words you said back at you annoyingly, like this:

"FlAt AnD sOuLlEsS"

These 2 words have a strong meaning here. Flat design is a design system with little to no effort, but the soul-less part is because people don't even put their heart into their work when making flat design, because they don't care enough about graphic design. Flat design on a computer takes mere seconds to finish, while skeuomorphism is a highly detailed craft that can take months or even years of work to perfect, similar to pixel art. With flat design, sometimes you won't even bother to add gradient or some other basic pattern. It is repetitive and ugly. Not everything should look the same.

## iOS and Android example

A common problem with flat design is that it is so common that it makes everything look the same. For example, iOS 7 (onward) and Android 7 (onward) you can hardly tell the difference between most of the design elements in this system, as they are identical: solid white with black text (literally just the fill bucket in MS-PAINT but on everything) if you were to move some icons and features around, and change the wallpaper, these systems would look identical, and you wouldn't be able to tell the difference between the 2 pictures.

## Skeuomorphism is cartoony?

What exactly is wrong with cartoony design? Would you rather have this:

![/TF2_1080P.png](/Graphics/Skeuomorphism/Team-Fortress-2/TF2_1080P.png)

_Just an example_

or this?

![/CartoonyFlatDesign.jpeg](/Graphics/Flat-design/Pingfong/Baby-Shark/CartoonyFlatDesign.jpeg)

See, flat design can be cartoony as well.

## Usability

In studies from the 2000s and 2010s, it was proven that skeuomorphic design is 35% more user friendly than flat design for computer users over the age of 30. For Google icons prior to 2020, skeuomorphism is over 80% more user friendly

![Google2020Icons.png](/Graphics/Flat-design/Google/2020/Google2020Icons.png)

Although consistent, these icons are incredibly hard to navigate with, and the majority of Internet users in 2020 and 2021 hate these icons compared to the original (above the flat 4 color ones)

Google is paying workers millions for this garbage that can be crapped out in a couple seconds. Why would you want to support such low effort? An infant (pre-toddler) could make better icons than this for free (and not a paid position that can pay you enough to be a multi-millionaire)

Lets not forget this either:

![BigTechCorporateArtystyle.jpeg](/Graphics/Flat-design/Corporate-Memphis/BigTechCorporateArtystyle.jpeg)

A majority of Internet users hate this, and still support flat design (which is what is shown in this picture) this is where all flat artwork leads to, Corporate Memphis.

## Originality

![Opera_GX_Icon.svg](/Graphics/Flat-design/Opera/Opera_GX_Icon.svg)

Public domain: This logo image consists only of simple geometric shapes or text. **It does not meet the threshold of originality** needed for copyright protection, and is therefore in the public domain.

Flat design is unoriginal, and in many cases is ineligable for copyright or ownership rights (even the ability to claim you made it sometimes) for example, the modern icon for the Opera web browser consists of basic geometric shapes, and cannot be copyrighted, and thus does not belong to the Opera software group, or anyone. By definition, they didn't even make the icon you are looking at. Anyone can claim they made it and they would be right. Most flat design icons are literally just a letter or a small set of letters, or an overly basic glyph. When you redo the logo in a different font, it is all the same.

## Effort

I tend to support projects that have effort put into them more compared to a project with little effort or care. Flat design takes very little effort, and I don't support projects as well when they only support this design philosophy. You can at least put some gradients in, or have pixel art somewhere.

***

## File info

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**File version:** `1 (Friday, 2021 September 24th at 9:20 pm)`

**Line count (including blank lines and compiler line):** `119`

***

## File history

**Version 1 (2021, Friday September 24th at 9:20 pm)**

> Changes:

> * Started the file

> * Added the title section

> * Added the "flat and soulless" section

> * Added the iOS and Android example section

> * Added the 2021 September section

> * Added the Skeuomorphism is cartoony? section

> * Added the usability section

> * Added the originality section

> * Added the effort section

> * Added the file info section

> * Added the file history section

> * No other changes in version 1

**Version 2 (Coming soon)**

> Changes:

> * Coming soon

> * No other changes in version 2

***

