  
***

# Taligent (Company)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Taligent/Taligent_company_logo.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Taligent/Taligent_company_logo.svg)

( **Predecessor:** `None` | **Successor:** `None` )

Taligent (a portmanteau of "talent" and "intelligent") was an American software company. Based on the Pink object-oriented operating system conceived by Apple in [1988](https://github.com/seanpm2001/WacOS/wiki/1988/), Taligent Inc. was incorporated as an Apple/IBM partnership in [1992](https://github.com/seanpm2001/WacOS/wiki/1992/), and was dissolved into IBM in [1998](https://github.com/seanpm2001/WacOS/wiki/1998/).

In [1988](https://github.com/seanpm2001/WacOS/wiki/1988/), after launching [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) and MultiFinder, Apple initiated the exploratory project named Pink to design the next generation of Mac OS. Though diverging into a sprawling new dream system unrelated to Mac OS, Pink was wildly successful within Apple and a subject of industry hype without. In [1992](https://github.com/seanpm2001/WacOS/wiki/1992/), the new AIM alliance spawned an Apple/IBM partnership corporation named Taligent Inc., with the purpose of bringing Pink to market. In [1994](https://github.com/seanpm2001/WacOS/wiki/1994/), Hewlett-Packard joined the partnership with a 15% stake. After a two-year series of goal-shifting delays, Taligent OS was eventually canceled, but the CommonPoint application framework was launched in [1995](https://github.com/seanpm2001/WacOS/wiki/1995/) for AIX with a later beta for OS/2. CommonPoint had technological acclaim but an extremely complex learning curve, so sales were very low.

[Taligent OS](https://github.com/seanpm2001/WacOS/wiki/Taligent-OS/) and CommonPoint mirrored the sprawling scope of IBM's complementary Workplace OS, in redundantly overlapping attempts to become the ultimate universal system to unify all of the world's computers and operating systems with a single microkernel. From [1993](https://github.com/seanpm2001/WacOS/wiki/1993/) to [1996](https://github.com/seanpm2001/WacOS/wiki/1996/), Taligent was seen as competing with Microsoft Cairo and [NeXTSTEP](https://github.com/seanpm2001/WacOS/wiki/NeXTSTEP/), even though Taligent didn't ship a product until 1995 and Cairo never shipped at all. From 1994 to 1996, Apple floated the [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) operating system project intended to succeed [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/), but never had a modern OS sophisticated enough to run Taligent technology.

In [1995](https://github.com/seanpm2001/WacOS/wiki/1995/), Apple and HP withdrew from the Taligent partnership, licensed its technology, and left it as a wholly owned subsidiary of IBM. In January 1998, Taligent Inc. was finally dissolved into IBM. Taligent's legacy became the unbundling of CommonPoint's best compiler and application components and converting them into VisualAge C++ and the globally adopted Java Development Kit 1.1 (especially internationalization).

In 1996, Apple instead bought NeXT and began synthesizing classic Mac OS onto the NeXTSTEP operating system. Mac OS X was launched on March 24, 2001 as the future of the Macintosh and eventually the iPhone. In the late 2010s, some of Apple's personnel and design concepts from Pink and from Purple (the first iPhone's codename) would resurface and blend into Google's Fuchsia operating system.

Along with Workplace OS, [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/), and Cairo, Taligent is cited as a death march project of the 1990s, suffering from development hell as a result of feature creep and the second-system effect.

## History

### Development

The entire history of Pink and Taligent from 1988 to 1998 is that of a widely admired, anticipated, and theoretically competitive staff and its system, but is also overall defined by development hell, second-system effect, empire building, secrecy, and vaporware.

#### Pink team

The pace of addition (to System 6 and 7) was staggering, so much so that Apple never had time to recode the low-level OS and fix some of its shortcomings. By [1990](https://github.com/seanpm2001/WacOS/wiki/1990/), these shortcomings, including no preemptive multitasking and no memory protection for applications, began to affect the quality of the product. The Mac was the easiest computer to use but also one of the most fragile.

Tom Saulpaugh in 1999, Mac OS engineer from June [1985](https://github.com/seanpm2001/WacOS/wiki/1985/), co-architect of [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) and JavaOS

Apple's cofounders Steve Wozniak and Steve Jobs had departed the company in [1985](https://github.com/seanpm2001/WacOS/wiki/1985/). This vacuum of entrepreneurial leadership created a tendency to promote low-level engineers up to management and allowed increasingly redundant groups of engineers to compete and co-lead by consensus, and to manifest their own bottom-up corporate culture. In 1988, Apple released System 6, a major release of the flagship Macintosh operating system, to a lackluster reception. The system's architectural limitations, set forth by the tight hardware constraints of its original [1984](https://github.com/seanpm2001/WacOS/wiki/1984/) [release](https://github.com/seanpm2001/WacOS/wiki/Apple-System-1/), now demanded increasingly ingenious workarounds for incremental gains such as MultiFinder's cooperative multitasking, while still lacking memory protection and virtual memory. Having committed these engineering triumphs which were often blunted within such a notoriously fragile operating system, a restless group of accomplished senior engineers were nicknamed the Gang of Five: Erich Ringewald, David Goldsmith, Bayles Holt, Gene Pope, and Gerard Schutten. The Gang gave an ultimatum that they should either be allowed to break from their disliked management and take the entrepreneurial and engineering risks needed to develop the next generation of the Macintosh operating system, or else leave the company.

In March 1988, the Gang, their management, and software manager and future Taligent CTO Mike Potel, met at the Sonoma Mission Inn and Spa. To roadmap the future of the operating system and thus of the organizational chart, ideas were written on colored index cards and pinned to a wall. Ideas that were incremental updates to the existing system were written on blue colored cards, those that were more technologically advanced or long-term were written on pink cards, and yet more radical ideas were on red cards because they "would be pinker than Pink". The Blue group would receive the Gang's former management duo, along with incremental improvements in speed, RAM size, and hard drive size. Pink would receive the Gang, with Erich Ringewald as technical lead, plus preemptive multitasking and a componentized application design. Red would receive speech recognition and voice commands, thought to be as futuristic as the Star Trek science fiction series.

Erich Ringewald led the Gang of Five as the new Pink group, located one floor below the Apple software headquarters in the De Anza 3 building, to begin a feasibility study with a goal of product launch in two years. Remembering the small but powerful original Macintosh group, he maintained secrecy and avoided the micromanagement of neighboring senior executives, by immediately relocating his quintet off the main Apple campus. They used the nondescript Bubb Road warehouse which was already occupied by the secretly sophisticated Newton project. Pink briefly garnered an additional code name, "Defiant".

#### Pink system

The Pink team was faced with the two possible architectural directions of either using legacy System 6 code or starting from scratch. Having just delivered the System 6 overhaul in the form of MultiFinder, Ringewald was adamant that Pink's intense ambitions were deliverable within a realistic two year timeframe only if the team heavily improved its legacy compatibility code. He pragmatically warned them, "We're going to have enough trouble just reimplementing the Mac." In Apple's contentious corporate culture of consensus, this mandate was soon challenged; David Goldsmith resigned from Pink after making a counter-ultimatum for a complete redesign which obviates all legacy problems, and some other staff escalated their complaints to upward management in agreement with that. Months later, a senior executive finally overrode Ringewald, thus redeveloping Pink from scratch as a new and unique system with no System 6 legacy.

The Pink team numbered eleven when the six-person kernel team within Apple's Advanced Technology Group (ATG) was ingested into Pink to begin designing its new microkernel named Opus. Embellishing upon the pink index cards, Pink's overall key design goals were now total object-orientation, memory protection, preemptive multitasking, internationalization, and advanced graphics. Many ideas from the red cards would later be adopted. After its first two months, Pink had a staff of about 25.

By October 1988, the Gang of Five had become only one Bayles Holt, because Gene Pope, Gerard Schutten, and Erich Ringewald then exited the sprawling Pink. The former leader held "grave doubts" over the feasibility of this "living, breathing, money-consuming thing" which was "out of control". Meanwhile, the remaining group and all of Apple were enamored and doubtless of Pink's world-changing vision, trying to join its staff of more than 100 by April 1989. It was a flourishing project that drained personnel from various other departments. All groups outside of Blue became defensively secretive in a company-wide culture of empire-building. Pink's secretive and turf warring culture didn't share source code or product demonstrations, even with the next generation Jaguar workstation design group, until so ordered by CEO John Sculley, and only then under extreme security and monitoring. Throughout Apple, the project and the system were considered successful, but from April 1989 and on into the 1990s, the running joke had always been and would always be, "When is Pink going to ship? Two years."

In 1990, Pink became the Object Based Systems group with Senior Vice President Ed Birss and a diverse staff of 150, including marketing and secretaries. Meanwhile, the hundreds of personnel in the Blue design group were constrained by the commercial pragmatism of maintaining their billion-dollar legacy operating system, which required them to refuse many new features, which earned them the infamous nickname "Blue Meanies". This group had well established the evolution of System 6 which would be released in 1991 as System 7. RAM chips and hard drives were extremely expensive so most personal computers were critically resource constrained, and System 7 would already barely fit onto existing Macintosh systems. Pink would therefore be hard-pressed to include backward compatibility for System 7 applications atop itself — assuming the team wanted to do so. This physical and economical constraint is a crucial aspect of the second-system effect.

By late 1989, Pink was a functional prototype of a desktop operating system on Macintosh hardware, featuring advanced graphics and dynamic internationalized text. Pink engineer Dave Burnard, Ph.D., said it was "a real OS that could demonstrate the core technology" much deeper than System 6 could do. In June 1990, Bill Bruffey abandoned the idea of Pink becoming a new Mac OS. He got permission to create yet another new microkernel named NuKernel, intended explicitly for a new Mac OS. His team of six engineers worked a few months to demonstrate a microkernel-based Mac OS on a Macintosh IIci — which would years later become Copland and the proposed Mac OS 8.

In the early 1990s, Pink's graphical user interface (GUI) is based on a faux 3D motif of isometric icons, beveled edges, non-rectangular windows, and drop shadows. One designer said "The large UI team included interaction and visual designers, and usability specialists." That essential visual design language would be an influence for several years into Copland, Mac OS 8, and CommonPoint. Magazines throughout the early 1990s showed various mock-ups of what Pink could look like. The People, Places, and Things metaphor extends beyond the traditional desktop metaphor and provides the user with GUI tools to easily drag documents between people and things, such as fax machines and printers. The system had a component-based document model that is similar to what would become OpenDoc. In mid-1991, Apple CEO John Sculley bragged that Apple had written 1.5 million lines of code for Pink. An IBM engineer described the first impression of this sophisticated prototype in 1991:

[Pink] had proven that an operating system ... could, in fact, be built on a microkernel. ... This microkernel then exported C++ interfaces, providing an object-oriented 'wrapper'. ... All the code that traditionally had resided in a kernel was implemented in system frameworks. This was not a monolithic kernel, but a collection of object-oriented servers performing specific kernel-type tasks. There were frameworks for file systems, for device drivers, for databases, for networking, and so on. But they all resided outside the kernel. And in the [Pink] world, these things were objects.

#### AIM alliance

In 1992, the earth shook: IBM and Apple clasped hands and pronounced themselves allies. From this union sprang Taligent ... developing nothing less than a universal operating system.

On October 2, 1991, the historic AIM alliance was formed and announced by Apple, IBM, and Motorola. It was conceived to cross-pollinate Apple's personal products and IBM's enterprise products, to better confront Microsoft's monopoly, and to design a new grandly unified platform for the computing industry. This alliance spun off two partner corporations: Kaleida Labs to develop multimedia software, and Taligent Inc. to bring Pink to market sometime in the mid-90s.

Pink was a massive draw for this alliance, where Apple had been initially approached by two different parts of IBM. One IBM group sought customers for its new POWER CPU hardware, therefore discovering Pink and a new desire to port it to this hardware. The other IBM group sought third party interest in its Grand Unifying Theory of Systems (GUTS) as the solution to the deeply endemic crisis that is software development, which would soon result in Workplace OS.  In an April 12, 1991 demonstration of Pink and its architecture, IBM was profoundly impressed and its GUTS outline was immediately impacted. By 1993, IBM's ambitious global roadmap would include the unification of the diverse world of computing by converting Pink to become one of many personalities of Workplace OS, and the ending of the need to write new major applications by instead making smaller additions to Pink's generalized frameworks.

Even before the signing of the alliance contract, the very existence of Pink was identified as a potential second-system threat if its revolutionary aura could prompt customers to delay their adoption of OS/2.

#### Taligent Inc.

On March 2, 1992, Taligent Inc. was launched as the first product of the AIM alliance. Moving from a temporary lease at Apple headquarters to an office down the street in Cupertino, the company launched with 170 employees,  most of whom had been re-hired directly from Apple plus CEO Joe Guglielmi. At age 50, he was a 30 year marketing veteran of IBM and former leader of the OS/2 platform up to its soon-launched version 2.0. The company's mission was to bring Pink to market.

##### Culture and purpose

Enthusiastically dismissing industry skepticism, he said Taligent would form its own corporate culture, independent of the established cultures and potential failures of its two founding investors and future customers, Apple and IBM. The two were recent allies carrying five other joint initiatives, and a deep rivalry of more than a decade. Dr. Dobb's Journal reflected, "It was fairly surreal for the Apple and IBM employees who went to Taligent and found themselves working for bosses still loyal to the opposition. Not a typical Silicon Valley career move, maybe, but perhaps a portent of other weird twists to come. Ignoring the politics as much as possible, the Taligent programmers buckled down and wrote a lotta lines of code." Commenting on the corporate culture shock of combining free-spirited Apple and formal IBM personnel, Fortune compared the company's cultural engineering challenge as possibly exceeding its software engineering challenge. The openminded but sensible CEO reigned it in, saying, "I'm tired of (Apple) folklore ... I want some data." Comparing the eager startup Taligent to its billion dollar investors, a leader at Kaleida said "The culture of IBM and Apple is largely about getting more benefits, perks, larger offices, fancier computers, and more employees".  Dr. Dobb's Journal would describe the increased abstraction in corporate culture resulting from Hewlett-Packard's upcoming 1994 addition to the partnership: "Now you could be (a former) Apple programmer working for (a former) IBM boss who reported (externally) to HP. Or some combination thereof. Twisteder and twisteder."

Apple and IBM did share a progressive culture of object orientation, as seen in their deep portfolios since the early 1980s. IBM had delivered objects on System/38 and AS/400, partnered with Patriot Partners, and integrated System Object Model (SOM) and Distributed SOM into OS/2 and AIX. Apple had already delivered Lisa, prototyped the fully object-oriented Pink operating system, and delivered object oriented frameworks using MacApp. Both companies had worked with Smalltalk.

Within one month of its founding, there was immediate industry-wide confusion about Taligent's purpose and scope. An industry analyst said "IBM and Apple blew it ... they should have announced everything (about Taligent) or nothing." Especially regarding Taligent's potential relationship to the Macintosh, Apple reiterated that its existing flagship legacy would continue indefinitely with System 7 and Macintosh hardware. COO Michael Spindler said "The Mac is not dead" and others said that they had never claimed that Pink would supersede the Macintosh. Charles Oppenheimer, Director of Marketing for Macintosh system software, said "We can't say for sure how (the two) will fit together." The industry was further confused as to the very existence of any Taligent software, not realizing that it was already beyond the concept stage and in fact consisted of volumes of Pink-based software in development by Apple for years. One year later in February 1993, Wired magazine would assert its suspicion that Apple and IBM's core messengers are maintaining "the big lie"—that Taligent's technology is merely a concept, has no existing software, and is actually years away from production—in order to protect their established multi-billion-dollar core legacy of Macintosh and OS/2 products from a potentially superior replacement and to divert the second system effect.

Upon its launch, CEO Joe Guglielmi soon organized the company into three divisions: a native system group for its self-hosted Pink OS, a development tools group, and a complementary products group for application frameworks to be ported to other OSes.

Taligent spent much of its first two years developing its operating system and simultaneously trying to find a market for it. They started a large project surveying potential customers, only to find little interest in a new OS. It is a point of controversy whether the lack of interest was real or the survey fell prey to question-framing problems and political issues with investors. If asked the question "Do you want a new OS?", there were few who would say yes. The survey did, however, show there was sufficient support for the benefits TalOS would bring.

##### Technology

The Pink operating system is now formally named Taligent Object Services (TOS or TalOS) whether hosted natively on its microkernel or non-natively on a third party OS, but the nickname "Pink" will always remain industry lore, such as with the developer phone number 408-TO-B-PINK. The entire graphics subsystem is 3D, including the 2D portions which are actually 3D constructs. It is based extensively on object-oriented frameworks from the kernel upward, including device drivers, the Taligent IO system, and ensembles. By 1993, IBM discussed decoupling most of TalOS away from its native Opus microkernel, and retargeting most of TalOS onto the IBM Microkernel which was already used as the base for IBM's tandem project, Workplace OS. Its text handling and localization via Unicode was intended to begin enabling the globalization of software development, especially in simplifying Japanese.

In January 1993, Taligent's VP of Marketing said the strong progress of native TalOS development could encourage its early incremental release prior to the full 1995 schedule for TalAE. Apple's business manager to Taligent Chris Espinosa acknowledged the irony of Apple and IBM building competing Taligent-based platforms, which had originated at Apple as Pink. He forecast Apple's adoption of Taligent components into the irreplaceably personal Mac OS—while empowering its competitiveness with IBM's future Taligent-based general purpose systems, and easing corporate users' migration toward Apple's Enterprise Systems Division's future Taligent-based computers.

On January 10, 1993, The Wall Street Journal reported on the state of Taligent, saying the company and its platform had the broad optimistic support of Borland, WordPerfect, and Novell. Borland CEO Philippe Kahn said "Technically, [Pink] is brilliant, and Taligent is running much faster than I expected." A software venture capitalist expected new entrepreneurs to appreciate the platform's newness and lack of legacy baggage, and the industry expected Apple loyalists to embrace a new culture. Regardless of genuine merit, many in the industry reportedly expected Taligent's success to depend upon wounding Microsoft's monopoly. On January 18, InfoWorld reported, "Taligent draws rave reviews from software developers".

By April 1993, Taligent, Inc. had grown to about 260 employees, mostly from Apple or "some other loose Silicon Valley culture". MacWEEK reported that the company remained on schedule or ahead through 1993 into 1994.

On June 23, 1993, Apple preannounced MacApp's direct successor, the new object-oriented crossplatform SDK codenamed Bedrock. Positioned as "the most direct path for migration" from System 7 to Pink, it was intended to provide source code compatibility between System 7, Windows 3.1, Windows NT, OS/2, and Pink. Bedrock would be abruptly discontinued 18 months later with no successor, and leaving Apple with no connection between System 7 and Pink.

[Taligent engineer Tom Chavez's] theory is that for the past few years [the industry's] hardware has become very fast and that it's traditional OSes that have been slowing [users] down.

Taligent CTO, Mike Potel

By 1994, the platform consisted of Taligent Object Services (TOS or TalOS), Taligent Application Environment (TAE or TalAE), and the Taligent Development System (TDS or TalDS). The initial plan was to deploy TalAE in early 1994 to help seed the market with a base of applications for TalOS, which was intended to be launched in 1995, with the whole platform going mainstream in two to five years—surely expecting a modern OS from Apple by 1994 or 1995. Influenced by the results of the survey effort, CEO Joe Guglielmi acknowledged the unavoidable risk of creating its own second-system effect, if the TalAE enhancements could make third party operating systems into competitors of native TalOS. The first internal development environment was an IBM RS/6000 model 250 with a PowerPC 601 CPU running AIX, building TalOS natively for the 68k Macintosh.

##### HP, CommonPoint beta

We used to joke that the [CommonPoint] frameworks were so powerful that you could write any program in three lines of code, but it would take you 6 months to figure out what those three lines were.

Stephen Kurtzman, project lead on the IBM Microkernel

[NeXT is] ahead today, but the race is far from over. ... [In 1996,] Cairo will be very close behind, and Taligent will be very far behind.

Steve Jobs,

When is Pink going to ship? Two years.

—a running joke at Apple

In January 1994, fellow object technology pioneer Hewlett-Packard joined Apple and IBM as the third co-owner of Taligent at 15% holding. HP held deeply vested experience in object technology since the 1980s with the NewWave desktop environment, the Softbench IDE, Distributed Smalltalk, Distributed Object Management Facility (DOMF), and having cofounded the Object Management Group. Taligent's object oriented portfolio was broadened with HP's compilers, DOMF, and intention to integrate TalOS and TalAE into HP-UX. HP had already partnered with Taligent's well-established competitor NeXT to integrate OPENSTEP into HP-UX, and Taligent had pursued partnerships with both Sun and HP for several months, all serving to improve HP's competitive bargaining in its offer to Taligent. A Taligent engineer reportedly said, "It wasn't that HP was driven by OpenStep to go to Taligent, but that OpenStep allowed them to make a much better deal." NeXTWORLD summarized that "[HP covered] all bets in the race for the object market", and Sun CEO Scott McNealy derided the partnership as HP being Taligent's "trophy spouse".  Dr. Dobb's Journal quipped: "Now you could be [a former] Apple programmer working for [a former] IBM boss who reported [externally] to HP. Or some combination thereof. Twisteder and twisteder.

By March 1994, Taligent had reportedly begun shipping code to its three investors, and some parts of TalAE had shipped to developers though without source code by policy. The first public Taligent technology demonstration was at SFA in Atlanta as an "amazingly fast" and crash-tolerant five-threaded 3D graphics application on native TalOS on a Macintosh IIci. Also in March 1994 at the PC Forum conference, Taligent gave the first public demonstration of TalAE applications, to an impressed but hesitant reception. A show of hands indicated one out of approximately 500 attendees were actively developing on TalAE, but Taligent reported 60 members in its future second wave of developer program. The frameworks already present allowed the integration of advanced TalAE features into pre-existing platform-native applications. CEO Joe Guglielmi reported on TalAE gaining the ongoing outside interest of IBM, but suffering relative uninvolvement from Apple—possibly due to Apple's failure to deliver a mainstream OS capable of running it. On April 18, 1994, InfoWorld reported Taligent's future plans for its SDK to be distributed. In November 1994 at Comdex, the public debut of third-party TalAE applications was on an RS/6000 running AIX to demonstrate prototypes made by seven vendors.

In late 1994, TalAE was renamed to CommonPoint, TalDE was renamed to cpProfessional, and Taligent User Interface Builder was renamed to cpConstructor.  CommonPoint was being beta tested at 100 sites, with an initial target market of internal corporate developers. TalOS was still scheduled to ship in 1996. Apple considered MacApp's lifespan to have "run its course" as the primary Macintosh SDK, while Taligent considered MacApp to be prerequisite experience for its own platform. Meanwhile, Apple and CILabs had begun an internal mandate for all new development to be based on the complementary and already published OpenDoc. CILabs was committed to publishing its source code, while Taligent was committed against publishing its own.

Taligent's role in the world is to create an environment in which all the applications we buy individually are built directly into the operating system. Because the apps are programmable, you can put together your own custom-made suites. Taligent could mean the end of all applications as we know them. ... The suites are here to battle Taligent.
— John C. Dvorak

Taligent was now considered to be a venerable competitor in the desktop operating system and enterprise object markets even without any product release, and being late. John C. Dvorak described Taligent as a threat in the desktop market of integrated application suites, particularly to the "spooked" Microsoft which responded with many vaporware product announcements (such as Chicago, Cairo, Daytona, and Snowball) to distract the market's attention from Taligent. ComputerWorld described the enterprise computing market as shifting away from monolithic and procedural application models and even application suites, toward object-oriented component-based application frameworks — all in Taligent's favor. Its theoretical newness was often compared to NeXT's older but mature and commercially established platform. Sun Microsystems held exploratory meetings with Taligent before deciding upon building out its object application framework OpenStep in partnership with NeXT as a "preemptive move against Taligent and [Microsoft's] Cairo". Having given up on seeing Pink go to market soon, Apple publicly announced Copland in March 1994 intended to compete with the upcoming Windows 95.

Apple was and will remain the only vendor of a desired target OS which is physically incapable of receiving Taligent's heavy payload due to [System 7's](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) critical lack of modern features such as preemptive multitasking. However, Taligent reportedly remains so committed to boosting the industry's confidence in Apple's modernization that it is considering creating a way to hybridize TalOS applications for the nascent System 7, and Apple reportedly intends for the upcoming Power Macintosh to boot native TalOS as a next-generation alternative to System 7. The second-system effect is uniquely intensified because Apple is beginning to view the architecturally superior TalOS as a competitor against the protractedly weak System 7 which has no successor in sight. InfoWorld reported this: "Developers and analysts also said that Taligent's fate is closely tied to that of OS/2 and the other as-yet-undelivered operating systems that it is designed to run on top of." This included Apple, Windows NT, and the yet unreleased Windows 95. A 1994 detailed report by INPUT assesses that Taligent's "very risky" future will depend not on its technology, but on support from IBM and major developers, the rapid and cheap development of applications and complex integration tasks, and the ability to create new markets.

In June 1994, Taligent shipped its first deliverable, considered to be somewhat late for its three investors and approximately 100 developer companies. It is a prebeta developer preview called the Partners Early Experience Kit (PEEK), consisting of 80 frameworks for AIX and OS/2. It received mixed reviews, with InfoWorld saying it is "inhibited by a massive footprint, a shortage of development tools, and a mind-boggling complexity". TalDE was scheduled to ship in Q2 1995.

At this point, Apple was reportedly "hedging its bets" in formulating a strategy to deliver the second-system TalAE, while remaining primarily devout to System 7. The company intended to soon introduce the PowerOpen platform of PowerPC AIX, which would deliver TalAE for running a hopefully forthcoming class of applications, simultaneously alongside Macintosh Application Services for running legacy System 7 personal applications.

In May 1995, Taligent canceled the delayed release of its natively hosted TalOS, to focus on its TalAE application framework programming environment that would run on any modern operating system. Having been developed mainly upon AIX, the plan was to port TalAE to HP-UX, OS/2, Windows NT, and Copland. Those vendors are intended to port and bundle TalAE directly with their operating systems, and Taligent will port for those who don't.

### CommonPoint

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Taligent/CommonPoint_logo_color.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Taligent/CommonPoint_logo_color.svg)

Developer(s)	Taligent Inc.

Written in	C++

Operating system	AIX, OS/2

License	Proprietary

No company is going to bet their project or job on a piece of software that is a 1.0 release. [Taligent has] another year or year and a half's worth of work ahead, because you only prove reliability from being out there.

Steve Jobs, 1995

Taligent said that it wants CommonPoint to be the definitive software industry standard, like a local app store in every computer. "Shake n bake" application development in four steps. Each app would have minimal package delivery size because customers already have most of the code in the form of the shared CommonPoint framework. The CommonPoint frameworks are divided into three categories: Application, Domain, and Support.

On July 28, 1995, Taligent shipped its first final product, CommonPoint 1.1, after seven years in development as Pink and then TalAE. First released only for its reference platform of AIX, it was initially priced at US$1,500 (equivalent to $2,548 in 2020) for only the runtime framework for users; or US$5,900 (equivalent to $10,021 in 2020) for the runtime framework and the software development kit, which further requires the US$1,800 Cset++ compiler because TalDE is still scheduled for a later release. The runtime has an overhead of 18MB RAM for each machine and 32 MB total system RAM is recommended. Though essentially on schedule by the company's own PEEK projections last year,[31] some analysts considered it to be "too little, too late" especially compared to the maturely established NeXT platform. Several PEEK beta test sites and final release customers were very pleased with the platform, though disappointed in the marked lack of crossplatform presence on HP/UX, Mac OS, and Windows NT which strictly limited any adoption of CommonPoint even among enthusiasts. Hewlett-Packard wrote a beginner's guide for CommonPoint programmers to address its steep learning curve, saying that its survey showed that experienced C++ framework programmers needed at least three months to even approach their first application. At its launch, InfoWorld told CEO Joe Guglielmi that "corporate users don't generally understand what CommonPoint is for" and have trouble differentiating CommonPoint and OpenDoc. IBM reportedly conducted a "full-court press" to analyze and promote customers' awareness of CommonPoint, by training its direct sales and consulting staff, attending industry conferences to make CommonPoint presentations, and "talking with any third-party software vendor and systems integrator who will listen".

The CommonPoint beta for OS/2 was released on December 15, 1995.[5] This was coincidentally the same day as the gold master of the Workplace OS final beta, IBM's complementary cousin operating system to TalOS. The final beta of Workplace OS was released on January 5, 1996 in the form of OS/2 Warp Connect (PowerPC Edition) and then immediately discontinued without ever receiving a release of CommonPoint.

Meanwhile, at Apple, the one-year-old Copland reached a primitive and notoriously unstable developer preview release, and Apple's frustrated lack of operating system strategy still had not shipped anything physically capable of running any Taligent software.

## New leadership

By 1995, it was estimated that the three investors had spent more than $100 million on Taligent, Inc., with its closure being predicted by sources of the Los Angeles Times due to the decline of its parent companies and due to the inherent difficulty of anyone in the IT industry remaining committed beyond 18 months.

In September 1995, CEO Joe Guglielmi unexpectedly exited Taligent to become VP of Motorola, intensifying the industry's concerns. Dick Gurino, a general manager of a PC and software development division at IBM, was named the interim CEO and tasked with searching for a permanent CEO. In October 1995, Gurino died of a heart attack while jogging, leaving the company without a CEO. On December 19, 1995, founding Taligent employee and Apple veteran Debbie Coutant was promoted to CEO.

On that same day it received what would be its final CEO, Taligent Inc. also ended its partnership form. Apple and HP sold out their holdings in the company, making Taligent Inc. a wholly owned subsidiary of IBM alone. While dissolving the partnership, each of the three former partners expressed approval of Taligent's progress. In what they called overall enterprise-wide cost-cutting processes, Apple and HP wanted to simply maintain technology licenses, IBM wanted to use its own redundant marketing and support departments, and Taligent wanted to focus only on technology. In the process, nearly 200 of the 375 employees were laid off, leaving only engineering staff. Apple veteran and Taligent cofounding employee, Mike Potel, was promoted from VP of Technology to CTO, saying, "We're better protected inside the IBM world than we would be trying to duke it out as an independent company that has to pay its bills every day."

In November 1996, the final public demonstration of the complete native TalOS was given, titled "The Cutting Edge Scenario". While referring to the original codename of "Pink", Taligent had already officially abandoned the never-published native TalOS in favor of CommonPoint.

TalOS was unique in its architecture. It was object oriented from the kernel up, and provided true pre-emptive multi-threaded multi-tasking. The end user experience revolved around a compound document-centric, multi-user networked, direct manipulation interface with infinite session undo. The principal interface theme was People, Places and Things. The networked interface represented remote users, as well as collaborative work spaces. In many ways it was more a graphic MOO (multi-user dimension-object oriented) than a traditional operating system.

— Tom Dougherty, Taligent engineer

## Unbundling

In 1997, Taligent's mission as an IBM subsidiary was to unbundle the technology of CommonPoint, and to redistribute it across IBM's existing products or license it to other companies — all with a special overall focus on Java. On September 1, 1997, Dr. Dobb's Journal observed, "I guess it's easier to develop hot technology when the guys before you have already written most of it. Like inheriting from a rich uncle. And having another rich uncle to sell it for you doesn't hurt, either."

The wider mass market debut of CommonPoint technology was in the form of VisualAge C++ 3.5 for Windows, with the bundling of the Compound Document Framework to handle OLE objects. In February 1997, the first comprehensive shipment of CommonPoint technology was its adoption into IBM's well-established VisualAge for C++ 4.0, which PC Magazine said was "unmatched" in "sheer breadth of features" because "Now, the best of the CommonPoint technology is being channeled into Open Class for VisualAge." This bundled SDK adaptation includes several CommonPoint frameworks: desktop (infrastructure for building unified OCX or OpenDoc components); web (called WebRunner, for making drag-and-drop compound documents for the web, and server CGIs); graphics for building 2D GUI apps; international text for Unicode and localization; filesystems; printing; and unit tests. Through 1997, Taligent was at the core of IBM's companywide shift to a Java-based middleware strategy. Taligent provided all Unicode internationalization support for Sun's 1997 release of Java Development Kit 1.1 through 1.1.4. Taligent was still leasing the same building from Apple, and JavaSoft was located across the street. But its parent IBM, and the related Lotus, were located on the east coast and were not fully aware of Taligent's plans and deliverables.

WebRunner is a set of Java- and JavaBeans-based development tools at $149. In June 1997, Places for Project Teams was launched at $49 per user as a groupware GUI which hides the ugly interface of Lotus Notes. Taligent had several products, licenses, trademarks, and patents.

Apple canceled the unstable and unfinished Copland project in August 1996, which had already been presumptively renamed "Mac OS 8", again leaving only a System 7 legacy. Apple's own book Mac OS 8 Revealed (1996) had been the definitive final roadmap for Copland, naming the platform's competitors and allies, and yet its 336 pages contain no mention of Pink or Taligent. In late 1996, Apple was ever more desperately scrambling to find any operating system strategy whatsoever beyond System 7, even after having already planned its upcoming announcement of it to be made in December 1997.[15]: 228–229  The company had failed to deliver even a functional developer preview of Copland in two years; and it discarded the successful A/UX and PowerOpen platforms in 1995, and the new AIX-based Apple Network Server of 1996-1997. To build the future Mac OS, the company seriously explored licensing other third party OSes such as Solaris, Windows NT, and TalOS.

## Dissolution

On September 16, 1997, IBM announced that Taligent Inc. would be dissolved by the end of the year, with its approximately 100 software engineers being "offered positions at IBM's Santa Teresa Laboratory to work on key components for IBM's VisualAge for Java programming tools, and at the recently announced Java porting center that IBM is setting up with Sun Microsystems and Netscape" IBM withdrew CommonPoint for OS/2 from the market on August 3, 1999.

## Reception

By 1993, one year after incorporation and two years before shipping its first product, Taligent was nonetheless seen as a significant competitor in the industry. UnixWorld said that "NeXT needs to increase its volume three-fold [over its existing 50,000 installations] in order to build enough momentum to forestall Microsoft and Taligent in the object-oriented software business."

In 1994, several PEEK beta test sites were impressed with CommonPoint, including one production success story at American Express which replaced its existing six month legacy application in only six weeks. At first in 1994, they'd said "We are almost overwhelmed by the complexity of [CommonPoint]. I don't know if the typical corporate developer is going to be able to assimilate this in their shop." but in 1995 they concluded the project with, "The CommonPoint frameworks — and I'm not exaggerating — are brilliant in the way they cover the technical issues [of that project]." Others were disappointed in the marked lack of crossplatform presence on HP/UX, Mac OS, and Windows NT which strictly limited any adoption of CommonPoint even among enthusiasts.

In a survey we conducted, learnability was mentioned as a main inhibitor to framework use by developers familiar with frameworks, and early developers with Taligent experienced "a stiff learning curve" even for experienced C++ programmers. ... The time it takes to become a productive developer with Taligent frameworks is long (at least three months until you can approach your first application)."

A Beginner's Guide to Developing with the Taligent Application Frameworks, Hewlett-Packard, 1995

Once you learn CommonPoint and Taligent's system you will be [an] expert C++ programmer, whether you want to or not. ... Basing apps on CommonPoint results in programs that are more consistent internally, cleaner, and allows the framework to do significant grunt work in cooperation with the Taligent environment. ... Taligent's frameworks are all coordinated much better than others I've seen. They're designed to work together with the underlying kernel, in a fashion similar to the Mac's ROM Toolbox calls, but on a supremely more advanced level. Nextstep is the closest thing to Taligent but it's already old and not nearly as advanced—despite the fact that until now it's been the fastest development platform, bar none. We have spoken with people who have used Nextstep and we considered it, but it's clear to us that CommonPoint is the next Nextstep, if you will.

Nisus Software, March 1995, after three months of Taligent training and three of coding

In March 1995, IEEE Software magazine said "Taligent's very nature could change the contour of the application landscape. ... [I]t's clear that Taligent is sitting on, using, and refining what is ostensibly the world's best developed, comprehensive, object-oriented development and system environment." The system was described as virtually "a whole OS of nothing but hooks"—which rests upon, integrates deeply with, and "replaces the host's original operating system", leaving "no lowest common denominator". Therefore, any Taligent native application is expected to run just the same on any supported host OS. Any degree of clean portability, especially with native integration, in the software industry was described as a holy grail to which many aspire and few deliver, citing the fact that Microsoft Word 6.0 for Macintosh still works like a foreign Windows application because the foundation was redundantly ported with each application. In February 1997, at the first comprehensive mass release of Taligent technology in the form of VisualAge C++ 4.0, PC Magazine said "Now, the best of the CommonPoint technology is being channeled into Open Class for VisualAge. ... Although the technology was lauded by many, the size and complexity of the CommonPoint frameworks proved too daunting for practical purposes. ... For sheer breadth of features, the Taligent frameworks are unmatched. An all-encompassing OOP framework has always proved a difficult ideal to realize, but VisualAge's Open Class Technology Preview is by far the most credible attempt we've seen.".

In 2008, PCWorld named the native Taligent OS as number 4 of the 15 top vaporware products of all time.

Due to the second-system effect and corporate immune response, Wired writer Fred Davis compared Taligent's relationship with Apple and IBM to a classic Greek tragedy: "A child is born, destined to kill its father and commit even more unspeakable acts against its mother. The parents love their child and are unwilling to kill it, so they imprison it in a secret dungeon. Despite its mistreatment, the child grows stronger, even more intent on committing its destined crimes."

In 1995, IT journalist Don Tennant asked Bill Gates to reflect upon "what trend or development over the past 20 years had really caught him by surprise". Gates responded with what Tennant described as biting, deadpan sarcasm: "Kaleida and Taligent had less impact than we expected." Tennant believed the explanation to be that "Microsoft's worst nightmare is a conjoined Apple and IBM. No other single change in the dynamics of the IT industry could possibly do as much to emasculate Windows."

## Legacy

The founding lead engineer of Pink, Erich Ringewald, departed Apple in 1990 to become the lead software architect at Be Inc. and design the new BeOS. Mark Davis, who had previously cofounded the Unicode Consortium, had at Apple co-written WorldScript, Macintosh Script Manager, and headed the localization of Macintosh to Arabic, Hebrew, and Japanese (KanjiTalk), was Taligent's Director of Core Technologies and architect of all its internationalization technology, and then became IBM's Chief Software Globalization Architect, moved to Google to work on internationalization and Unicode, and now helps to choose the emojis for the world's smartphones. Ike Nassi had been VP of Development Tools at Apple, launched MkLinux, served on the boards of Taligent and the OpenDoc Foundation, and worked on the Linksys iPhone.

IBM used parts of CommonPoint to create the Open Class libraries for VisualAge for C++, and spawned an open-source project called International Components for Unicode from part of this effort. Resulting from Taligent's work led by Mark Davis, IBM published all of the internationalization libraries that are in Java Development Kit 1.1 through 1.1.4 along with source code which was ported to C++ and partially to C. Enhanced versions of some of these classes went into ICU for Java (ICU4J) and ICU for C (ICU4C). The JDK 1.1 received Taligent's JavaBeans Migration Assistant for ActiveX, to convert ActiveX into JavaBeans. Davis's group became the Unicode group at the IBM Globalization Center of Competency in Cupertino.

Taligent created a set of Java- and JavaBeans-based development tools called WebRunner, a groupware product based on Lotus Notes called Places for Project Teams. Taligent licensed various technologies to Sun which are today part of Java, and to Oracle Corporation and Netscape. HP released the Taligent C++ compiler technology (known within Taligent as "CompTech") as its "ANSI C++" compiler, aCC. HP also released some Taligent graphics libraries.

In the 2010s, some of Apple's personnel and design concepts from Pink and Purple (the first iPhone's codename) would resurface and blend into Google's Fuchsia operating system. Based on an object-oriented kernel and application frameworks, its open-source code repository was launched in 2016 with the phrase "Pink + Purple == Fuchsia".

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - Taligent](https://en.wikipedia.org/wiki/Taligent/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 5:12 pm`

**Last revised on:** `2021 Thursday September 23rd at 5:12 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 5:12 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

