  
***

# OS X 10.9 (Mavericks)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/Osx-mavericks-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/Osx-mavericks-logo.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/OS_X_Mavericks_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.9_Mavericks/OS_X_Mavericks_Desktop.png)

( **Predecessor:** [OS X 10.8 (Mountain Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/) | **Successor:** [OS X 10.10 (Yosemite)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-10-Yosemite/) )

OS X Mavericks (version 10.9) is the tenth major release of macOS, Apple Inc.'s desktop and server operating system for Macintosh computers. OS X Mavericks was announced on June 10, [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), at WWDC 2013, and was released on October 22, 2013 worldwide.

The update emphasized battery life, Finder improvements, other improvements for power users, and continued iCloud integration, as well as bringing more of Apple's iOS apps to OS X. Mavericks, which was named after the surfing location in Northern California was the first in the series of OS X releases named for places in Apple's home state; earlier releases used the names of big cats.

OS X Mavericks was the first OS X major release to be a free upgrade and the second overall since [Mac OS X 10.1 "Puma"](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-1-Puma/).

## History

Apple announced OS X Mavericks on June 10, 2013, during the company's Apple Worldwide Developers Conference (WWDC) keynote (which also introduced [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/), a revised MacBook Air, the sixth-generation AirPort Extreme, the fifth-generation AirPort Time Capsule, and a redesigned Mac Pro). During a keynote on October 22, 2013, Apple announced that the official release of 10.9 on the Mac App Store would be available immediately, and that unlike previous versions of OS X, 10.9 would be available at no charge to all users running [Snow Leopard (10.6.8)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/) or later.

On October 22, 2013, Apple offered free upgrades for life on OS X and iWork.

## System requirements

OS X Mavericks can run on any Mac that can run OS X Mountain Lion; as with Mountain Lion, 2 GB of RAM, 8 GB of available storage, and OS X 10.6.8 (Snow Leopard) or later are required. Mavericks and later versions are all available for free.

The full list of compatible models:

iMac (Mid 2007 or later)

MacBook (13-inch Aluminum, Late 2008), (13-inch Polycarbonate, Early 2009 or later)

MacBook Pro (13-inch, Mid/Late 2007 or later), (15-inch or 17-inch, Mid/Late 2007 or later)

MacBook Air (Late 2008 or later)

Mac Mini (Early 2009 or later)

Mac Pro (Early 2008 or later)

Xserve (Early 2009)

## System features

The menu bar and the Dock are available on each display. Additionally, AirPlay compatible displays such as the Apple TV can be used as an external display. Mission Control has been updated to organize and switch between Desktop workspaces independently between multiple displays.

OS X Mavericks introduced App Nap, which sleeps apps that are not currently visible. Any app running on Mavericks can be eligible for this feature by default.

Compressed Memory is a virtual memory compression system which automatically compresses data from inactive apps when approaching maximum memory capacity.

Timer coalescing is a feature that enhances energy efficiency by reducing CPU usage by up to 72 percent. This allows MacBooks to run for longer periods of time and desktop Macs to run cooler.

Apple now supports OpenGL 4.1 Core Profile and OpenCL 1.2. Server Message Block version 2 (SMB2) is now the default protocol for sharing files, rather than AFP. This is to increase performance and cross-platform compatibility.

Some skeuomorphs, such as the leather texture in Calendar, the legal pad theme of Notes, and the book-like appearance of Contacts, have been removed from the UI.

iCloud Keychain stores a user's usernames, passwords and Wi-Fi passwords to allow the user to fill this information into forms when needed.

The system has native LinkedIn sharing integration.

IPoTB (Internet Protocol over Thunderbolt Bridge) Thunderbolt networking is supported in Mavericks. This feature allows the user to quickly transfer a large amount of data between two Macs.

Notification Center allows the user to reply to notifications instantly, allows websites to send notifications, and, when the user wakes up a Mac that was in a sleep state, displays a summary of missed notifications before the machine is unlocked. Some system alerts, such as low battery, removal of drives without ejecting, and a failed Time Machine backup have been moved to Notification Center.

The "traffic light" close, minimize, and maximize window buttons have appeared somewhat brighter than [Mac OS X Lion](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-7-Lion/) and [OS X Mountain Lion](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/).

## App features

Finder gets enhancements such as tabs, full-screen support, and document tags. Pinch-to-zoom and swipe-to-navigate-history gestures have been removed, although both are supported anywhere else.

The new iBooks application allows the user to read books purchased through the iBooks Store. The app also allows the user to purchase new content from the iBooks Store, and a night mode to make it easier to read in dark environments.

The new Maps application allows the user the same functionality as in iOS Maps.

The Calendar app has enhancements such as being able to add Facebook events, and an estimate for the travel time to an event.

The Safari browser has a significantly enhanced JavaScript performance which Apple claims is faster than Chrome and Firefox. A Top Sites view allows the user to quickly access the most viewed sites by default. However, the user can pin or remove websites from the view. The sidebar now allows the user to view their bookmarks, reading list and shared links. Safari can also auto-generate random passwords and remember them through iCloud Keychain.

## Other applications found in Mavericks

AirPort Utility

App Store

Archive Utility

Audio MIDI Setup

Automator

Bluetooth File Exchange

Boot Camp Assistant

Calculator

Chess

ColorSync Utility

Console

Contacts

Dictionary

Digital Color Meter

Disk Utility

DVD Player

FaceTime

Font Book

Game Center

GarageBand (may not be pre-installed)

Grab

Grapher

iMovie (may not be pre-installed)

iTunes

Image Capture

Ink (can only be accessed by connecting a graphics tablet to your Mac)

Keychain Access

Keynote (may not be pre-installed)

Mail

Messages

Migration Assistant

Notes

Notification Center

Numbers (may not be pre-installed)

Pages (may not be pre-installed)

Photo Booth

Preview

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) Player

Reminders

Script Editor

Stickies

System Information

Terminal

[TextEdit](https://github.com/seanpm2001/WacOS/wiki/TextEdit/)

Time Machine

VoiceOver Utility

X11/XQuartz (may not be pre-installed)

## Removed functionality

The Open Transport API has been removed. USB syncing of calendar, contacts and other information to iOS devices has been removed, instead requiring the use of iCloud. QuickTime 10 no longer supports many older video codecs and converts them to the ProRes format when opened. Older video codecs cannot be viewed in Quick Look. Apple also removed the ability to sync mobile iCloud Notes if iOS devices were upgraded from iOS 8 to iOS 9, effectively forcing all Mavericks users to update or upgrade their computers.

## Reception

OS X Mavericks has received mixed reviews.

One complaint is that Apple removed the local sync services, which forces users to get iCloud to sync iOS devices with the desktop OS. However, this feature has since returned in the 10.9.3 and iTunes 11.2 updates.

The Verge stated that OS X Mavericks was “a gentle evolution of the Mac operating system”.

## Release history

**Unsupported**

Version 	Build 	Date 	OS name 	Notes 	Standalone download

10.9 	13A603 (GM2) 	October 22, 2013 	Darwin 13.0 	Original Mac App Store release 	N/A

10.9.1 	13B42 	December 16, 2013 	About the OS X Mavericks v10.9.1 Update 	OS X Mavericks 10.9.1 Individual update

10.9.2 	13C64 	February 25, 2014 	Darwin 13.1 	About the OS X Mavericks v10.9.2 Update 	OS X Mavericks 10.9.2 Individual update

OS X Mavericks 10.9.2 Combo update

13C1021 	April 22, 2014 	About Security Update 2014-002 Mavericks 	Security Update 2014-002 Mavericks

10.9.3 	13D65 	May 15, 2014 	Darwin 13.2 	About the OS X Mavericks v10.9.3 Update 	OS X Mavericks 10.9.3 Individual update

OS X Mavericks 10.9.3 Combo update

10.9.4 	13E28 	June 30, 2014 	Darwin 13.3 	About the OS X Mavericks v10.9.4 Update 	OS X Mavericks 10.9.4 Individual update

OS X Mavericks 10.9.4 Combo update

10.9.5 	13F34 	September 17, 2014 	Darwin 13.4 	About the OS X Mavericks v10.9.5 Update 	OS X Mavericks 10.9.5 Individual update

OS X Mavericks 10.9.5 Combo update

October 16, 2014 	About the security content of Security Update 2014-005 Mavericks 	Security Update 2014-005 Mavericks

January 27, 2015 	About the security content of Security Update 2015-001 Mavericks 	Security Update 2015-001 Mavericks

13F1066 	March 9, 2015 	About the security content of Security Update 2015-002 Mavericks 	Security Update 2015-002 Mavericks

13F1077 	April 8, 2015 	About the security content of Security Update 2015-004 Mavericks 	Security Update 2015-004 Mavericks

13F1096 	June 30, 2015 	About the security content of Security Update 2015-005 Mavericks 	Security Update 2015-005 Mavericks

13F1112 	August 13, 2015 	About the security content of Security Update 2015-006 Mavericks 	Security Update 2015-006 Mavericks

13F1134 	October 21, 2015 	About the security content of Security Update 2015-007 Mavericks 	Security Update 2015-007 Mavericks

13F1507 	December 8, 2015 	About the security content of Security Update 2015-008 Mavericks 	Security Update 2015-008 Mavericks

13F1603 	January 19, 2016 	About the security content of Security Update 2016-001 Mavericks 	Security Update 2016-001 Mavericks

13F1712 	March 21, 2016 	About the security content of Security Update 2016-002 Mavericks 	Security Update 2016-002 Mavericks

13F1808 	May 16, 2016 	About the security content of Security Update 2016-003 Mavericks 	Security Update 2016-003 Mavericks

13F1911 	July 18, 2016 	About the security content of Security Update 2016-004 Mavericks 	Security Update 2016-004 Mavericks

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - OS X 10.9 (Mavericks)](https://en.wikipedia.org/wiki/OS_X_Mavericks)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 1:51 pm`

**Last revised on:** `2021 Thursday September 23rd at 1:51 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 1:51 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

