  
***

# OS X 10.8 (Mountain Lion)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/MountainLionHero.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/MountainLionHero.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/OS_X_Mountain_Lion_Screenshot.jpg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/OS_X_Mountain_Lion_Screenshot.jpg)

( **Predecessor:** [OS X 10.7 (Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-7-Lion/) | **Successor:** [OS X 10.9 (Mavericks)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-9-Mavericks/) )


OS X Mountain Lion (version 10.8) is the ninth major release of macOS, Apple Inc.'s desktop and server operating system for Macintosh computers. OS X Mountain Lion was released on July 25, [2012](https://github.com/seanpm2001/WacOS/wiki/2012/) for purchase and download through Apple's Mac App Store, as part of a switch to releasing OS X versions online and every year, rather than every two years or so. Named to signify its status as a refinement of the previous OS X version, Lion, Apple's stated aims in developing Mountain Lion were to allow users to more easily manage and synchronise content between multiple Apple devices and to make the operating system more familiar.

The operating system gained the new malware-blocking system Gatekeeper and integration with Apple's online Game Center and iCloud services, while the Safari web browser was updated to version 6. As on iOS, Notes and Reminders became full applications, separate from Mail and Calendar, while the iChat application was replaced with a version of iOS's Messages. Mountain Lion also added a version of iOS's Notification Center, which groups updates from different applications in one place. Integrated links allowing the user to rapidly transfer content to Twitter were present in the operating system from launch. Facebook integration was also planned but unfinished at launch date. It was released as a downloadable update later.

OS X Mountain Lion received positive reviews, with critics praising Notification Center, Messages, and speed improvements over Mac OS X Lion, while criticizing iCloud for unreliability and Game Center for lack of games. Mountain Lion sold three million units in the first four days, and has sold 28 million units as of June 10, [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), making it Apple's most popular OS X release. Mountain Lion was the last paid upgrade for an OS X major release, with OS X Mavericks and later being free. Apple later allowed free downloads of the OS, starting on June 30, [2021](https://github.com/seanpm2001/WacOS/wiki/2021/).

## History

OS X Mountain Lion was announced at WWDC 2012 at Moscone West.

OS X Mountain Lion was officially announced by Apple on their website on February 16, 2012, as a successor [to OS X Lion.](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-7-Lion/) It achieved golden master status on July 9, 2012.

During the Apple Worldwide Developers Conference keynote on June 11, 2012, Apple announced a "near final" release version of Mountain Lion for developers, with the public version arriving in July 2012 at a price tag of US$19.99 (€15.99 in Europe, £13.99 in the UK, $20.99 in Australia and ￥128 in Mainland China). The third generation MacBook Pro, revised MacBook Air, iPad Smart Case, and third-generation AirPort Express were announced at the keynote as well.

The specific release date of July 25 was not confirmed until the day before, July 24, by Apple CEO, Tim Cook, as part of Apple's 2012 third-quarter earnings announcement. It was released to the Mac App Store on July 25, 2012, where it sold 3 million units in the first four days of release.

An update for Mountain Lion, version 10.8.1, was released on August 23, 2012. It resolved issues with iMessages, Migration Assistant, Safari, Microsoft Exchange Server, Mail, and many other applications. Tests of the update revealed that 10.8.1 also improved battery life on laptops, albeit gaining back only half of the battery life that was lost in updating to Mountain Lion. Although 10.8.1 improved battery life for some customers, others continue to complain about reduced battery life and a constant drop in battery health, ultimately resulting in a "Service Battery" message.

## System requirements

The official system requirements of OS X 10.8 are 2 GB RAM, 8 GB available storage, OS X 10.6.8 (Snow Leopard) or later, on any of the following Macs:

iMac (Mid 2007 or newer. Late 2006 is supported if an app called MlPostFactor v0.3 is used.)

MacBook (Aluminum, Late 2008), (Polycarbonate, Early 2009 or newer)

MacBook Pro (Mid/Late 2007 or newer)

MacBook Air (Late 2008 or newer)

Mac Mini (Early 2009 or newer)

Mac Pro (Early 2008 or newer)

Xserve (Early 2009)

As in 10.7, the earliest models supporting AirDrop are the late-2008 MacBook Pro, late-2010 MacBook Air, late-2008 MacBook, mid-2010 Mac Mini, and early-2009 Mac Pro with an AirPort Extreme card. Any Mac released in or after 2011, except the MacBook, supports AirPlay Mirroring. Power Nap is supported on the mid-2011 or newer MacBook Air and the MacBook Pro with Retina display.

The technical basis for these requirements is incompatibility with 32-bit EFI and 32-bit kernel extensions (most importantly, drivers for GPUs shipped in some older Macs). In order to prevent potentially incompatible systems from installing 10.8, the installer contains a whitelist of supported motherboard IDs. Users have bypassed these limitations so that 10.8 may run with varying functionality on some officially unsupported computers.

## New and changed features

### Notification Center

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/Notification_Center_Mountain_Lion.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.8_Mountain_Lion/Notification_Center_Mountain_Lion.png)

_Notification Center in OS X Mountain Lion, showing a banner, the Tweet and Post buttons._

Notification Center was added in the operating system. It provides an overview of alerts from applications and displays notifications until the user completes an associated action, rather than requiring instant resolution. Users may choose what applications appear in Notification Center, and how they are handled. There are three types of notifications: banners, alerts, and badges. Banners are displayed for a short period of time in the upper right corner of the Mac's screen, and then slide off to the right. The icon of the application is displayed on the left side of the banner, while the message from the application will be displayed on the right side. Alerts are the same as banners, but will not disappear from the screen until the user takes action. Badges are red notification icons that are displayed on the application's icon. They indicate the number of items available for the application.

Notification Center can be accessed by clicking the icon in the right corner of the menu bar. When open, the user can click a button to tweet, post status updates to Facebook, or view all notifications in the sidebar pane. Swiping up will reveal the option to disable Notification Center for one day. Many settings of Notification Center can be customized under the "Notifications" pane in System Preferences. Each application can have three ways to display notifications: none, banners, and alerts. Options to toggle the app icons and sounds are also available. Users can click and drag an app in the pane to change the order the applications are displayed within Notification Center.

### Notes

Notes, another transfer from iOS, is added. It is separate from Mail in its own application, with support for desktop notes added (syncs along with its iOS counterpart). Created notes are synced through all the user's Apple devices through the iCloud service. Notes can be arranged in folders, and pinned to the user's desktop. When the application is closed, the pinned note still remains.

Notes can be created in three different default fonts - Noteworthy, Marker Felt, and Helvetica. Users can add custom fonts by visiting the Show Fonts menu. The menu allows users to change text size, format lists, choose the alignment (left, center, justify, or right), assign a writing direction, and indent text. Attachments, images, and hyperlinks can also be added into a note. Attachments cannot be viewed on iOS devices.

### Messages

Messages, an instant messaging software application, is added in Mountain Lion. It was announced on February 16, 2012, as part of the OS X Mountain Lion developer preview. Starting with this release, Messages replaced iChat as the default OS X instant-messaging client. A free beta version of Messages was available to download for Mac OS X Lion from the Apple website until June 2012. The final version of Messages was included with the release version of OS X Mountain Lion.

As with its predecessor, Messages has text messaging, audio, and screen-sharing capabilities. Messages also contains native video conversation support, utilizing Apple's FaceTime video calling application where possible. However, it does retain video capabilities for interfacing with other instant messaging clients. Messages supports Apple's iMessage, a free instant messaging service previously only available on devices running iOS 5. It also supports both Extensible Messaging and Presence Protocol (XMPP) (shown in the application under its former name, Jabber) and the AOL Instant Messenger (AIM) OSCAR protocol. It also offers a direct connection to Yahoo! Messenger and Google Talk.

### Game Center

The Game Center application from iOS was added in OS X Mountain Lion. It is an online multiplayer social-gaming network, and allows users to invite friends to play a game, start a multiplayer game through matchmaking, track their achievements, and compare their high scores on a leader board. Points are awarded to players as a part of Game Center's achievement tracking system. Players can earn points by meeting specific in-game challenges.

A player must establish an Apple ID to associate with a Game Center nickname. A player has the option to create an Apple ID from within Game Center if they do not already have one. Only one nickname may be associated with an Apple ID at any given time. Each player is assigned a profile in Game Center. A profile consists of the player's nickname, the number of Game Center-compatible games the player owns, the number of friends the player has, the number of achievement points a player has, and an optional photo and player-defined status.

### Application updates

OS X Mountain Lion added updates for many applications on the operating system. The Chess app supports Game Center. Dashboard widgets can be managed in a UI similar to Launchpad. Mail adds new VIP feature to save frequent contacts. The Preview app gets an improved user interface. It is able to fill out forms in PDF documents that don't contain actual PDF form fields. Reminders is a new to-do list application, separate from Calendar in its own application that syncs along with its iOS counterpart. Safari 6 gets a new release and features a new address bar; a combination of the address bar and the search field. The address bar also has a "Reader" button, showing the user just the text of the article without advertisements and distraction. When the user is on a website with no article, the button is disabled. Safari 6 is available as a download for Mac OS X Lion. Time Machine is able to do rotating backups on more than one storage medium.

### Other applications found in Mountain Lion

AirPort Utility

App Store

Archive Utility

Audio MIDI Setup

Automator

Bluetooth File Exchange

Boot Camp Assistant

Calculator

ColorSync Utility)

Console

Contacts

Dictionary

Digital Color Meter

Disk Utility

DVD Player

FaceTime

Font Book

GarageBand (may not be pre-installed)

Grab

Grapher

iMovie (may not be pre-installed)

iTunes

Image Capture

Keychain Access

Keynote (may not be pre-installed)

Messages

Migration Assistant

Notes

Notification Center

Numbers (may not be pre-installed)

Pages (may not be pre-installed)

Photo Booth

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) Player

Script Editor

Stickies

System Information

Terminal

[TextEdit](https://github.com/seanpm2001/WacOS/wiki/TextEdit/)

VoiceOver Utility

### Other updates

AirPlay Mirroring is added, which allows wireless mirroring of a Mac's screen to an Apple TV. System-wide integration of AirPlay audio transmission is added. There are many new features for Chinese users, including support for Baidu as an option for Safari search engine, QQ, 163.com and 126.com services for Mail, Contacts and Calendar, Youku, Tudou and Sina Weibo are integrated into share sheets. Dictation, new in Mountain Lion, is a system-wide voice input mechanism that requires a broadband Internet connection. Facebook gained full integration following an update in late 2012. Some of the features include single-sign on and integration in Notification Center, Contacts and Share Sheets. Gatekeeper, also new to Mountain Lion, is an anti-malware feature based on digital signatures and the Mac App Store.

Power Nap allows flash storage-based Macintoshes (late 2010 MacBook Air and later, or the MacBook Pro with Retina display) to synchronize with iCloud (Reminders, Calendars, Photo Stream, Notes, Mail, and Find My Mac) while sleeping and also allows a Mac to download App Store and OS X updates as well as make periodic Time Machine backups when it is plugged in and sleeping. Several new screensavers were added. Share Sheets, a "Share" button and dialog box in Safari and other applications, are added. Twitter was integrated with almost all of the applications, with single-sign on, tweeting from an app, Tweet Sheets, tweeting photos and links, using multiple Twitter accounts, Twitter notifications, profile picture integration, and Location Services available.

Application updates automatically install from the Mac App Store. The iCloud library User interface (UI) was integrated throughout the operating systems, which includes new Open and Save dialog boxes across built-in applications, iWork and third-party applications via an Application programming interface (API). Applications that make use of this API support a new user interface to view and manage documents in the cloud that are specific to the application being used. Documents can be renamed from the title bar. iWork documents automatically synchronize with iCloud. The full screen ability is on every display.

The Dock has received an updated look, emulating the appearance of the aluminum metal surface that much of Apple's current hardware line-up sports. Scroll bars widen when the mouse hovers over them. Finder displays a progress bar in the "size" column when copying a file, and on icons in Launchpad when downloading from the Mac App Store. Launchpad has Spotlight search for finding applications. Address Book was renamed "Contacts", and iCal was renamed "Calendar".

## Dropped and changed features

MobileMe was replaced entirely by iCloud, specifically in System Preferences options.

RSS support in Mail and Safari was removed; a message is shown to suggest to users that they search the Mac App Store for an RSS app.

The Software Update service was unified into the Mac App Store.

The list of updates installed in the past was removed.

The "Web Sharing" option was removed from System Preferences. Apache is still included with the operating system and can be enabled using third-party software.

When the X11 app is opened, users are directed to the open source XQuartz project instead.

Xgrid support was removed (including in OS X Server edition).

The Display Preferences status menu was replaced by the AirPlay icon, and it is no longer possible to quickly switch resolutions without first opening up preferences.

The option in Menu Bar to display battery life using "Time" is no longer offered. Instead, the only option is to display battery "Percentage". However, battery time can still be viewed in the dropdown by clicking on the battery icon.

## Reception

Reception for OS X Mountain Lion has generally been positive, with users considering it to be a major improvement over 10.7 Lion. John Siracusa of Ars Technica said that 10.8 corrected and simplified UI changes made with Lion, saying that it had become "what 10.7 should've been" and that the faster speeds and features merit the upgrade, then adding that "If we'd had to wait for two years after 10.6 for the next major release of OS X, chances are good that the worst of the missteps in Lion would just be landing on our doorsteps today. I'll take 10.8, thanks." Many reviewers found that Mountain Lion was far more stable than its predecessor, including Jason Snell of Macworld, who said "All told, I found Mountain Lion to be a stable, solid release. Even prerelease builds were far more stable than I've come to expect from OS X betas, leading me to wonder if Apple's new annual schedule is leading to more careful incremental updates (with fewer bugs) rather than great leaps (with more, nastier bugs)."

The general attitude towards Mountain Lion was that it was faster and smoother, including Brian Heater of Engadget, who said the following:

Taken as a whole, the features mark a fairly aggressive bid to fold the best of OS X and iOS into one product -- a strategy we first saw with the introduction of the Mac App Store on Snow Leopard, and with the arrival of Launchpad last year in Lion. [...] That said, it seems time for Apple to make a bold new pronouncement on the desktop front. The company appears to have most of its resources invested in the mobile side -- and there's no question as to why: the iPhone and iPad have reinvigorated the company, making it a computing player on a scale that no one (save, perhaps, for Jobs himself) could have predicted a decade ago. Still, it might be hard for OS X users not to feel neglected -- many of the latest new features feel a bit like iOS hand-me-downs. When and if Apple rolls out a new operating system this time next year, hopefully we'll be seeing a very different side of Mac OS.

MG Siegler of TechCrunch said that the difference between Lion and Mountain Lion was not comparable to the difference between Leopard and Snow Leopard because Mountain Lion adds many new features that were not available in Lion. He also praised the application compatibility and said that the only updates needed were to add Notification Center features to applications. Jim Dalrymple of The Loop commented "there will be tens of thousands of words published on Wednesday when Mountain Lion hits the Mac App Store, but let's face it, what you really want to know is whether Mountain Lion is worth the upgrade. Let's get that out of the way now — yes, it is definitely worth it," and said that at $19.99, Mountain Lion was a "bargain". David Pogue of The New York Times said "Over all, then, Mountain Lion is a gentle, thoughtful upgrade. All 200 new features? No, not really. But 10 that you'll use every day? For $20? Yes."

While the operating system in general was well received, some reviewers dissented from that viewpoint. Jesus Diaz of Gizmodo felt that Apple was running out of ideas and that Microsoft's Windows 8 may out-innovate OS X. Apple also received criticism for failing to provide an official upgrade pathway for owners of 2006 Mac Pro workstation computers.

Game Center was the most criticised aspect of Mountain Lion. Reviewers criticized the service for the lack of games available, reliability issues and the lack of integration with iOS games. Scott Stein of CNET commented "Game Center-compatible titles will have achievements, leaderboard info...and, potentially, a way of playing cross-platform games. As of the time of this post, I could find only seven Game Center games featured the Mac App Store," and "Until Game Center becomes a complete portal for all games on the Mac, and a true method of cross-platform iOS/Mac play, I'm not sure many people will even bother checking it out." Matt Clark of MacLife also commented that if developers don't develop applications for Game Center, it is "likely doomed to sit unnoticed on your hard drive".

Mountain Lion sold 3 million units in the first four days, making it Apple's most successful OS X release to date. A report by Chitika Insights revealed that OS X Mountain Lion had been used by 3.2% of OS X users within the first 48 hours of release, and 10% penetration in the first month.

## Release history

**Unsupported**

Version 	Build	Date 	OS name 	Notes 	Standalone download

10.8 	12A269 (GM) 	July 25, 2012 	Darwin 12.0 	Original retail Mac App Store release 	

10.8.1 	12B19 	August 23, 2012 	Darwin 12.1 	About OS X Mountain Lion v10.8.1 Update 	OS X v10.8.1 Individual update

10.8.2 	12C54 	September 19, 2012 	Darwin 12.2 	About OS X Mountain Lion v10.8.2 Update 	OS X v10.8.2 Individual update

OS X v10.8.2 Combo update

12C60 	October 4, 2012 	About OS X Mountain Lion v10.8.2 Update

(supplementary update described at the end)

OS X v10.8.2 Supplemental Update 1.0

12C2034 	October 23, 2012 	For Mac Mini (Late 2012) (Pulled)[

12C3104 	November 29, 2012 	For Mac Mini (Late 2012) 	OS X v10.8.2 Supplemental Update 2.0

10.8.3 	12D78 	March 14, 2013 	Darwin 12.3 	About OS X Mountain Lion v10.8.3 Update 	OS X v10.8.3 Individual update

OS X v10.8.3 Combo update

10.8.4 	12E55 	June 4, 2013 	Darwin 12.4 	About OS X Mountain Lion v10.8.4 Update 	OS X v10.8.4 Individual update

OS X v10.8.4 Combo update

12E3067 	June 10, 2013 	For MacBook Air (Mid 2013) 	

12E4022 	September 25, 2013 	For iMac (Late 2013) 	

10.8.5 	12F37 	September 12, 2013 	Darwin 12.5 	About the OS X Mountain Lion v10.8.5 Update 	OS X v10.8.5 Individual update

OS X v10.8.5 Combo update

12F45 	October 3, 2013 	About the OS X Mountain Lion v10.8.5 Supplemental Update 	OS X v10.8.5 Supplemental Update

12F2501 	March 9, 2015 	About Security Update 2015-002 	Security Update 2015-002 Mountain Lion

12F2518 	April 8, 2015 	About the security content of Security Update 2015-004 	Security Update 2015-004 Mountain Lion

12F2542 	June 30, 2015 	About the security content of Security Update 2015-005 	Security Update 2015-005 Mountain Lion

12F2560 	August 13, 2015 	About the security content of Security Update 2015-006 	Security Update 2015-006 Mountain Lion

Note: Combo updates include all previous releases (ex: 10.8 to 10.8.3). Individual update is a smaller package size and can be used if currently using the previous release (ex: 10.8.2 to 10.8.3).

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - OS X 10.8 (Mountain Lion)](https://en.wikipedia.org/wiki/OS_X_Mountain_Lion)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 1:32 pm`

**Last revised on:** `2021 Thursday September 23rd at 1:32 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 1:32 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

