  
***

# OS X 10.10 (Yosemite)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/Osx-yosemite-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/Osx-yosemite-logo.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/OS_X_Yosemite_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.10_Yosemite/OS_X_Yosemite_Desktop.png)

( **Predecessor:** [OS X 10.9 (Mavericks)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/) | **Successor:** [OS X 10.11 (El Capitan)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-11-El-Capitan/) )

OS X Yosemite (/joʊˈsɛmɪti/ yoh-SEM-it-ee; version 10.10) is the eleventh major release of macOS, Apple Inc.'s desktop and server operating system for Macintosh computers.

OS X Yosemite was announced and released to developers on June 2, [2014](https://github.com/seanpm2001/WacOS/wiki/2014/), at WWDC 2014 and released to public beta testers on July 24, 2014. Yosemite was released to consumers on October 16, 2014. Following the Northern California landmark-based naming scheme introduced with OS X Mavericks, Yosemite is named after the national park.

## System requirements

All Macintosh products capable of running [OS X Mountain Lion](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/) (v10.8.x) are able to run Yosemite as the two operating systems have the same requirements However, to take full advantage of the Handoff feature, additional minimum system requirements include a Mac with Bluetooth LE (Bluetooth 4.0). As with Mavericks and Mountain Lion, 2 GB of RAM, 8 GB of available storage, and OS X 10.6.8 (Snow Leopard) or later are required.

These are the models that are compatible with OS X Yosemite (with exceptions):

iMac (Mid 2007 or later)

MacBook (Aluminum Late 2008 and Early 2009 or later)

MacBook Pro (13-inch, Mid 2009 or later; 15-inch, Mid/Late 2007 or later; 17-inch, Late 2007 or later)

MacBook Air (Late 2008 or later)

Mac Mini (Early 2009 or later)

Mac Pro (Early 2008 or later) (Can run on a mid-2006 version if one upgrades to a supported graphics chip and utilizes a custom bootloader)

Xserve (Early 2009)

These are the models that support new features such as Handoff, Instant Hotspot as well as AirDrop between Mac computers and iOS devices:[6]

MacBook Air (Mid 2012 or later)

MacBook Pro (Mid 2012 or later)

iMac (Late 2012 or later)

Mac Mini (Late 2012 or later)

Mac Pro (Late 2013)

## Features

### Design

Yosemite introduced a major overhaul of OS X's user interface, emphasizing flat graphic design over skeuomorphism, following the aesthetic introduced with [iOS 7](https://github.com/seanpm2001/WacOS/wiki/iOS-7/). It is the first major redesign of the OS X user interface since 10.5 Leopard. Other changes include thinner fonts and blurred translucency effects. Some icons have been changed to correspond with those of iOS 7 and iOS 8. Yosemite maintains the OS X desktop metaphor.

Other design changes include new icons, light and dark color schemes, and the replacement of Lucida Grande with Helvetica Neue as the default system typeface. It was the only macOS version to use Helvetica Neue as the default typeface, as in El Capitan it was again changed, this time to Apple's own, newly-designed San Francisco typeface. The Dock is now a 2D translucent rectangle instead of a skeuomorphic glass shelf, reminiscent of the Dock design used in early versions of OS X through Tiger and in iOS since iOS 7.

### Continuity

Many of Yosemite's new features focus on the theme of continuity, increasing its integration with other Apple platforms and services such as iOS and iCloud. The Handoff functionality allows the operating system to integrate with iOS 8 devices over Bluetooth LE and Wi-Fi; users can place and answer phone calls using their iPhone as a conduit, send and receive text messages, activate personal hotspots, or load items being worked on in a mobile app (such as Mail drafts or Numbers spreadsheets) directly into their desktop equivalent.

### Notification Center

Notification Center features a new "Today" view, similar to that in iOS. The Today view can display information and updates from various sources, along with widgets. The widgets in the Today view are similar to those of [iOS 8](https://github.com/seanpm2001/WacOS/wiki/iOS-8/).
Photos

As of OS X 10.10.3, Photos replaces both iPhoto and Aperture. It uses iCloud Photo Library to upload all the user's photos across their devices.

### Applications found on OS X 10.10 Yosemite


AirPort Utility

App Store

Archive Utility

Audio MIDI Setup

Automator

Bluetooth File Exchange

Boot Camp Assistant

Calculator

Calendar

Chess

ColorSync Utility

Console

Contacts

Dictionary

Digital Color Meter

Disk Utility

DVD Player

FaceTime

Font Book

Game Center

GarageBand (may not be pre-installed)

Grab

Grapher

iBooks (now Apple Books)

iMovie (may not be pre-installed)

iTunes

Image Capture

Ink (can only be accessed by connecting a graphics tablet to your Mac)

Keychain Access

Keynote (may not be pre-installed)
 
Maps

Messages

Migration Assistant

Notes

Notification Center

Numbers (may not be pre-installed)

Pages (may not be pre-installed)

Photo Booth

Preview

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) Player

Reminders

Script Editor

Stickies

System Information

Terminal

[TextEdit](https://github.com/seanpm2001/WacOS/wiki/TextEdit/)

Time Machine

VoiceOver Utility

X11/XQuartz (may not be pre-installed)

### Other

Spotlight is a more prominent part of the operating system; it now displays its search box in the center of the screen and can include results from online sources, including Bing, Maps, and Wikipedia. Stock applications such as Safari and Mail have been updated. In particular, many security features have been added to Safari, such as a custom history clearing option that lets users clear history, cookies, and other data from the previous hour, day, or two days. In addition, Apple added DuckDuckGo to its search offerings, a non-tracking search engine that doesn’t store users’ data. Safari allows you to remotely close tabs from an iOS device. Safari now supports browsing in private browsing mode with certain windows (as opposed to all the windows having to be either in or out of private browsing).

The green "zoom" button on windows now has a different function in applications that support full-screen mode. Instead of simply enlarging the window, the button now enters full-screen mode, eliminating the full-screen button at the top-right corner of windows that has been present since Mac OS X Lion. However, holding the Option key (⌥) while clicking the zoom button or double-clicking on the window chrome continues to invoke the original behavior.

JavaScript for Automation (JXA) is the new system-wide support for scripting with JavaScript, built upon JavaScriptCore and the Open Scripting Architecture. It features an Objective-C bridge which enables entire Cocoa applications to be programmed in JavaScript.

Along with other framework changes, CloudKit was integrated in this release. CloudKit functions as a Mobile Backend as a Service (MBaaS) and is one method for app developers to integrate access to Apple’s iCloud servers into their apps.

There is a "dark mode" in System Preferences which makes the Dock and menu bar darker.

## Beta testing

Apple initiated a new public beta program for OS X, a practice not seen with its operating systems since 2000's US$29.95 Mac OS X Public Beta, which had preceded the release of Mac OS X v10.0. Yosemite is part of the OS X Beta Seed Program, a public program that allows the first 1 million users to download and test the Yosemite beta at no charge. Beta testers are required to acknowledge the potential risks involved with prerelease software, and sign a non-disclosure agreement (NDA). The program began releasing Public Betas on July 24, 2014. Six public betas of Yosemite were released.
Reception

On release, Yosemite received positive reviews, with users praising the simplified user interface. Programmer John Siracusa, who had reviewed every OS release, wrote for Ars Technica that "Yosemite is an aesthetic one-way valve... switching back to Mavericks after a week or two in Yosemite is like returning to iOS 6. Everything looks embarrassingly chunky, glossy, and gaudy." Macworld's review generally praised Yosemite for its design, but noted that it had found WiFi network issues and that Continuity had proved unreliable.

## Criticism

Yosemite faced problems with network stability and the discoveryd DNS system. Because of this, Apple replaced discoveryd with the mDNSResponder system (used in Mavericks) in 10.10.4. Another notable bug experienced on Yosemite was the 'Unicode of death' problem, following a similar bug in 2013, in which a meaningless Arabic text string could crash applications using the system text-display APIs. Some users who upgraded to Yosemite complained that the Finder fails to show the contents of folders.

Software developers and users have argued that Apple's yearly release schedule and development practices have compromised stability, and mean that no version of OS X is truly recommendable for users prioritizing reliability over new user interface design and features.

Spotlight on Yosemite by default reports the user's current location (at the city level) and all their search queries to Apple and third parties. Reporting by Spotlight can be disabled by the user, although, even if this is done, the Safari web browser will continue to send search terms to Apple unless the function is separately disabled.

## Release history

**Unsupported**

Version 	Build 	Date 	OS name 	Notes 	Standalone download

10.10 	14A389 	October 16, 2014 	Darwin 14.0 	Original Mac App Store release 	N/A

10.10.1 	14B25 	November 17, 2014 	About the OS X Yosemite v10.10.1 Update 	OS X Yosemite 10.10.1 Individual update

10.10.2 	14C109 	January 27, 2015 	Darwin 14.1 	About the OS X Yosemite v10.10.2 Update 	OS X Yosemite 10.10.2 Individual update

OS X Yosemite 10.10.2 Combo update

14C1510 	March 9, 2015 	About Security Update 2015-002 Yosemite 	Security Update 2015-002 Yosemite

14C1514 	March 19, 2015 	About Security Update 2015-003 Yosemite 	Security Update 2015-003 Yosemite

14C2043 	March 10, 2015 	Security Update 2015-003

Shipped with Early 2015 MacBook Air – Forked build

N/A

14C2513 	March 20, 2015

10.10.3 	14D131 	April 8, 2015 	Darwin 14.3 	About the OS X Yosemite v10.10.3 Update

This release unified the previously forked build for the early 2015 MacBook Air 	OS X Yosemite 10.10.3 Individual update

OS X Yosemite 10.10.3 Combo update

14D136 	April 16, 2015 	Supplemental Update

Fixes issue with video driver issue that may prevent Mac from starting up when running certain apps that capture video 	OS X Yosemite 10.10.3 Supplemental Update 1.0

10.10.4 	14E46 	June 30, 2015 	Darwin 14.4 	About the OS X Yosemite v10.10.4 Update 	OS X Yosemite 10.10.4 Individual update

OS X Yosemite 10.10.4 Combo update

10.10.5 	14F27 	August 13, 2015 	Darwin 14.5 	About the OS X Yosemite v10.10.5 Update 	OS X Yosemite 10.10.5 Individual update

OS X Yosemite 10.10.5 Combo update

14F1021 	October 21, 2015 	About the security content of Security Update 2015-004 Yosemite 	Security Update 2015-004 Yosemite

14F1505 	November 12, 2015 	About the security content of Security Update 2015-005 Yosemite 	Included in Security Update 2015-006 Yosemite

14F1509 	December 11, 2015 	About the security content of Security Update 2015-006 Yosemite 	Security Update 2015-006 Yosemite

14F1605 	January 19, 2016 	About the security content of Security Update 2016-001 Yosemite 	Security Update 2016-001 Yosemite

14F1713 	March 21, 2016 	About the security content of Security Update 2016-002 Yosemite 	Security Update 2016-002 Yosemite

14F1808 	May 18, 2016 	About the security content of Security Update 2016-003 Yosemite 	Security Update 2016-003 Yosemite

14F1909 	July 18, 2016 	About the security content of Security Update 2016-004 Yosemite 	Security Update 2016-004 Yosemite

14F1912 	September 1, 2016 	About the security content of Security Update 2016-005 Yosemite 	Included in Security Update 2016-006 Yosemite

14F2009 	October 24, 2016 	About the security content of Security Update 2016-006 Yosemite 	Security Update 2016-006 Yosemite

14F2109 	December 13, 2016 	About the security content of Security Update 2016-007 Yosemite 	Security Update 2016-007 Yosemite

14F2315 	March 27, 2017 	About the security content of Security Update 2017-001 Yosemite 	Security Update 2017-001 Yosemite

14F2411 	May 15, 2017 	About the security content of Security Update 2017-002 Yosemite 	Security Update 2017-002 Yosemite

14F2511 	July 19, 2017 	About the security content of Security Update 2017-003 Yosemite 	Security Update 2017-003 Yosemite

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - OS X 10.10 (Yosemite)](https://en.wikipedia.org/wiki/OS_X_Yosemite)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 2:08 pm`

**Last revised on:** `2021 Thursday September 23rd at 2:08 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 2:08 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

