  
***

# Mac OS 9

<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS 9 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/MacOS9.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/MacOS9.png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/Mac_OS_9.0.4_emulated_inside_of_the_SheepShaver_emulator.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/Mac_OS_9.0.4_emulated_inside_of_the_SheepShaver_emulator.png)

( **Predecessor:** [Mac OS 8 (1997)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) | **Successors:** [Mac OS X Public Beta (2000)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Public-Beta) & [Mac OS X 10.0 (Cheetah) (2001)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) & [Mac OS X Server 1.0 (2000)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Server-1-0/) )

<!-- Mac OS 9 is the ninth major version of the classic MacOS series of operating systems produced by Apple Inc, the final release in the Classic MacOS series of operating systems. !-->

Mac OS 9 is the ninth major release of Apple's classic Mac OS operating system which was succeeded by [OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/). Introduced on October 23, [1999](https://github.com/seanpm2001/WacOS/wiki/1999/), it was promoted by Apple as "The Best Internet Operating System Ever", highlighting Sherlock 2's Internet search capabilities, integration with Apple's free online services known as iTools and improved Open Transport networking. While Mac OS 9 lacks protected memory and full pre-emptive multitasking, lasting improvements include the introduction of an automated Software Update engine and support for multiple users.

Apple discontinued development of Mac OS 9 in late [2001](https://github.com/seanpm2001/WacOS/wiki/2001/), transitioning all future development to [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/). The final updates to Mac OS 9 addressed compatibility issues with [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) while running in the Classic Environment and compatibility with Carbon applications. At the [2002](https://github.com/seanpm2001/WacOS/wiki/2002/) Worldwide Developers Conference, Steve Jobs began his keynote address by staging a mock funeral for OS 9.

## Features

Apple billed Mac OS 9 as including "50 new features" and heavily marketed its Sherlock 2 software, which introduced a "channels" feature for searching different online resources and introduced a [QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/)-like metallic appearance. Mac OS 9 also featured integrated support for Apple's suite of Internet services known as iTools (later re-branded as .Mac, then MobileMe, which was replaced by iCloud) and included improved TCP/IP functionality with Open Transport 2.5.

Other features new to Mac OS 9 include:

Integrated support for multiple user accounts without using At Ease.

Support for voice login through VoicePrint passwords.

Keychain, a feature allowing users to save passwords and textual data encrypted in protected keychains.

A Software Update control panel for automatic download and installation of Apple system software updates.

A redesigned Sound control panel and support for USB audio.

Speakable Items 2.0, also known as PlainTalk, featuring improved speech synthesis and recognition along with [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) integration.

Improved font management through FontSync.

Remote Access Personal Server 3.5, including support for TCP/IP clients over Point-to-Point Protocol (PPP).

An updated version of [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) with support for TCP/IP.

Personal File Sharing over TCP/IP.

USB Printer Sharing, a control panel allowing certain USB printers to be shared across a TCP/IP network.

128-bit file encryption in the Finder.

Support for files larger than 2 GB.

Unix volume support.

CD Burning in the Finder (introduced in Mac OS 9.1).

Addition of a "Window" menu to the Finder (introduced in Mac OS 9.1)

## Mac OS 9 and the Classic Environment

[PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) versions of Mac OS X prior to [10.5](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/) include a compatibility layer (a shell) called Classic, enabling users to run applications and hardware requiring Mac OS 9 from within OS X. This is achieved through running Mac OS 9 without access to its Finder inside OS X. This requires Mac OS 9 to be installed on the computer even though computers that can run the Classic environment are not necessarily able to boot into Mac OS 9. Some Mac OS 9 applications do not run well in Classic. They demonstrate screen redraw problems and lagging performance. In addition, some drivers and other software which directly interact with the hardware fail to work properly.

In May [2002](https://github.com/seanpm2001/WacOS/wiki/2002/), at Apple's Worldwide Developers Conference in San Jose, California, Steve Jobs, accompanied by a coffin, held a mock funeral to announce that Apple had stopped development of Mac OS 9. Mac OS 9.2.2, released in December [2001](https://github.com/seanpm2001/WacOS/wiki/2001/), was the final version of Mac OS 9 and the "classic" Mac OS. In June 2005, Jobs announced that the Macintosh platform would be transitioning to Intel x86 microprocessors. Developer documentation of the Rosetta [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) emulation layer revealed that applications written for [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) or 9 would not run on x86-based Macs. The Classic Environment remains in the PowerPC version of 10.4; however, x86 versions of OS X do not support the Classic environment.

Mac OS 9 can be emulated by using [SheepShaver](https://github.com/seanpm2001/WacOS/wiki/SheepShaver/), a [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) emulator available on multiple operating systems, including Intel-based Macs. However, SheepShaver cannot run Mac OS versions newer than 9.0.4, as there is no support for a memory management unit. The PearPC PowerPC emulator does not support Mac OS 9. QEMU has experimental support for running Mac OS 9 using [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) G4 emulation.

Any G4 Macs that have a 1 GHz and higher processor and all G5 Macs can not boot Mac OS 9 natively as the "Mac OS ROM" was never updated to allow those Macs, which were developed during the [OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) era, to directly boot it. In recent years, unofficial patches for Mac OS 9 and the Mac OS ROM have been made to allow unsupported G4 Macs to boot into Mac OS 9 (G5 Macs still can't run Mac OS 9 at all since Mac OS 9 doesn't recognize the G5 processor), though this is not officially supported by Apple.

## Availability

While Mac OS 9 is no longer supported by Apple, retail copies are still available from several Internet businesses at varying prices.

Although now classed as abandonware, as development on it has ended, it is still in use by those who cannot upgrade to [OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) due to hardware limitations or prefer it to [OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/). Mac OS 9 is also a popular choice for retrocomputing hobbyists. Mac gamers also sometimes revert to Classic (often via emulation) or native OS 9 in order to play games that are not supported on OS X; for example: Bugdom, Nanosaur, Oregon Trail, Civilization II, and the Marathon Trilogy.

## Other uses

Aside from Apple-branded hardware that is still maintained and operated, Mac OS 9 can be operated in other environments such as Windows and Unix.[ For example, the aforementioned [SheepShaver](https://github.com/seanpm2001/WacOS/wiki/SheepShaver/) software was not designed for use on x86 platforms and required an actual PowerPC processor present in the machine it was running on similar to a hypervisor. Although it provides PowerPC processor support, it can only run up to Mac OS 9.0.4 because it does not emulate a memory management unit.

## Version history

Version 	Release Date 	Changes 	Codename 	Computer 	Price

9.0 	October 23, 1999 	

Initial release

Sonata 	iMac G3 	99 USD

9.0.2 	February 2000

(Shipped with Macs)
	
Bug fixes.

N/A 	PowerBook (FireWire) 	Only shipped with referred Macs

9.0.3 	March 2000

(Shipped with Macs)

iMac/iMac DV/iMac DV SE

9.0.4 	April 4, 2000 	

Improved USB and FireWire support.

Other bug fixes.


Minuet 	iMac G3 (slot loading) 	Free Update

9.1 	January 9, 2001 	

Integrated Disc Burning within Finder.

Implementation of Finder 'Window' menu.

Memory management unit required.

Improved stability.

Fortissimo 	iBook 14 inch and 12 inch

9.2 	June 18, 2001

(Shipped with Macs)
	
G3 processor as minimum system requirement.

Improved speed and Classic Environment support.

Moonlight 	Power Mac G4 (QuickSilver) 	Only shipped with referred Macs

9.2.1 	August 21, 2001 	

Minor bug fixes.

Limelight 	iBook (Late 2001), PowerBook G4 (Gigabit Ethernet) 	Free Update

9.2.2 	December 5, 2001 	

Bug fixes relating to Classic Environment.

LU1 	eMac

Updates to Mac OS 9 include 9.0.4, 9.1, 9.2.1, and 9.2.2. Mac OS 9.0.4 was a collection of bug fixes primarily relating to USB and FireWire support. Mac OS 9.1 included integrated CD burning support in the Macintosh Finder and added a new Window menu in the Finder for switching between open windows. Mac OS 9.2 increased performance noticeably and improved Classic Environment support.

## Compatibility

Macintosh Model 	9.0	9.1 	9.2.1	9.2.2

Power Macintosh 6100 	Yes 	Yes: Must install from CD 	No

Power Macintosh 7100

Power Macintosh 8100

PowerBook 2300 	Yes

PowerBook 2400c

PowerBook 5300

PowerBook 1400 	Partial: Password Security unsupported

PowerBook 3400 	Yes: Hard disk driver must not be updated

Power Macintosh 5200 LC 	Yes

Power Macintosh 5300 LC

Power Macintosh 5500

Power Macintosh 4400

Power Macintosh 6200

Power Macintosh 6300

Power Macintosh 6400

Power Macintosh 6500

Power Macintosh 7200

Power Macintosh 7300

Power Macintosh 7500

Power Macintosh 8500

Power Macintosh 7600

Power Macintosh 8600

Power Macintosh 9600

Twentieth Anniversary Macintosh

PowerBook G3

PowerBook G3 Series 	Yes 	Yes

PowerBook (FireWire) 	Yes: Machine-specific version only

PowerBook G4	No 	Yes: Machine-specific version only

PowerBook G4 (Gigabit Ethernet 	No 	Yes: Machine-specific version only

PowerBook G4 (DVI)	No 	Yes: Machine-specific version only

PowerBook G4 (1 GHz/867 MHz)

PowerBook G4 (12-inch)	Partial: Classic Environment only

PowerBook G4 (17-inch)

PowerBook G4 (12-inch DVI)

PowerBook G4 (12-inch 1.33 GHz)

PowerBook G4 (12-inch 1.5 GHz)

PowerBook G4 (15-inch FW 800)

PowerBook G4 (15-inch 1.5/1.33 GHz)

PowerBook G4 (17-inch 1.33 GHz)

PowerBook G4 (17-inch 1.5 GHz)

iBook 	Yes 	Yes 	Yes 	Yes

iBook (FireWire) 	Yes: Machine-specific version only

iBook (Dual USB) 	No 	Yes: Machine-specific version only

iBook (Late 2001)

iBook (14.1 LCD) 	No 	Partial: Classic Environment only

iBook (16 VRAM)

iBook (Opaque 16 VRAM)

iBook (32 VRAM)

iBook (14.1 LCD 32 VRAM)

iBook (Early 2003) 	Yes: Machine-specific version only

iBook G4 	Partial: Classic Environment only

iBook G4 (14-inch)

iBook G4 (Early 2004)

Power Macintosh G3 All-In-One 	Yes

Power Macintosh G3

Power Macintosh G3 (Blue and White)

iMac G3

iMac G3 (266 MHz, 333 MHz)

iMac G3 (Slot Loading)

iMac G3 (Summer 2000) 	Yes: Machine-specific version only 	Yes 	Yes

iMac G3 (Early 2001) 	No 	Yes: Machine-specific version only

iMac G3 (Summer 2001)

iMac G4 	No 	Yes

iMac G4 (February 2003)	Partial: Classic Environment only

iMac G4 (17-inch 1 GHz)

iMac G4 (USB 2.0)

iMac G5

iMac G5 (Ambient Light Sensor)

iMac G5 (iSight)

eMac 	Yes

eMac (ATI Graphics CD-ROM drive)	Yes: Machine-specific version only

eMac (ATI Graphics Combo drive)

eMac (ATI Graphics SuperDrive) 	Partial: Classic Environment only

eMac (USB 2.0)

eMac (2005)

Power Mac G4 (PCI Graphics) 	Yes 	Yes

Power Mac G4 (AGP Graphics)

Power Mac G4 (Gigabit Ethernet) 	Yes: Machine-specific version only

Power Mac G4 Cube

Power Mac G4 (Digital Audio)	No 	Yes: Machine-specific version only 	Yes

Power Mac G4 (QuickSilver)	No

Power Mac G4 (QuickSilver 2002) 	No 	Yes: Machine-specific version only

Power Mac G4 (Mirrored Drive Doors)

Power Mac G4 (FW 800)	Partial: Classic Environment only

Power Mac G4 (Mirrored Drive Doors 2003)	Yes: Machine-specific version only

Power Mac G5 	Partial: Classic Environment only

Power Mac G5 (June 2004)

Power Mac G5 (Late 2004)

Power Mac G5 (Early 2005)

Power Mac G5 (Late 2005)

Mac Mini (G4)

Some newest G3 and most G4 Macs can only run at least Mac OS 9.1, and some only run at least Mac OS 9.2. This is because the late development of G3 Macs and the mid-development of G4 Macs was during the development of Mac OS 9 and only the versions the G4 Macs support were designed to be compatible with those G4 Macs.

Some newest G4 and all G5 Macs can only run at least Mac OS 9.2, and can only run its compatible versions of Mac OS 9 in OS X's Classic Environment because the "Mac OS ROM" was never updated to allow those Macs, which were developed during the OS X era, to directly boot it (but probably continued to run in userspace, with the restriction that it would only run at least Mac OS 9.2, so it was still supported in the Classic Environment).

<!-- **This article on classic Mac OS is a stub. You can help by expanding it.** !-->

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - Mac OS 9](https://en.wikipedia.org/wiki/Mac_OS_9)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 4:01 pm`

**Last revised on:** `2021 Thursday September 23rd at 4:01 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 4:01 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

