  
***

# Mac OS 8

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/8/Mac_OS_8.1_emulated_inside_of_SheepShaver.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/8/Mac_OS_8.1_emulated_inside_of_SheepShaver.png)

( **Predecessor:** [Mac OS 7 (1991)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) | **Successor:** [Mac OS 9 (1999)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) )

Mac OS 8 is the eighth major version of the classic MacOS series of operating systems produced by Apple Inc.

Mac OS 8 is an operating system that was released by Apple Computer, Inc. on July 26, [1997](https://github.com/seanpm2001/WacOS/wiki/1997/). It includes the largest overhaul of the classic Mac OS experience since the release of [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/), approximately six years before. It emphasizes color more than prior versions. Released over a series of updates, Mac OS 8 represents an incremental integration of many of the technologies which had been developed from 1988 to 1996 for Apple's overly ambitious OS named [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/). Mac OS 8 helped modernize the Mac OS while Apple developed its next-generation operating system, Mac OS X (renamed in [2012](https://github.com/seanpm2001/WacOS/wiki/2012/) to OS X and later in [2016](https://github.com/seanpm2001/WacOS/wiki/2016/) to macOS).

Mac OS 8 is one of Apple's most commercially successful software releases, selling over 1.2 million copies in the first two weeks. As it came at a difficult time in Apple's history, many pirate groups refused to traffic in the new OS, encouraging people to buy it instead.

Mac OS 8.0 introduces the most visible changes in the line-up, including the Platinum interface and a native [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) multithreaded Finder. Mac OS 8.1 introduces a new, more efficient file system named [HFS Plus](https://github.com/seanpm2001/WacOS/wiki/HFS_Plus/). Mac OS 8.5 is the first version of the Mac OS to require a [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC_Processor_Support/) processor. It features [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) native versions of QuickDraw, [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/), and the Sherlock search utility. Its successor, [Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/), was released on October 23, [1999](https://github.com/seanpm2001/WacOS/wiki/1999/).

### Copland

Starting in [1988](https://github.com/seanpm2001/WacOS/wiki/1988/), Apple's next-generation operating system, which it originally envisioned to be "System 8" was codenamed [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/). It was announced in March [1994](https://github.com/seanpm2001/WacOS/wiki/1994/) alongside the introduction of the first [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) Macs. Apple intended [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) as a fully modern system, including native [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) code, intelligent agents, a microkernel, a customizable interface named Appearance Manager, a hardware abstraction layer, and a relational database integrated into the Finder. [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) was to be followed by Gershwin, which promised memory protection spaces and full preemptive multitasking. The system was intended to be a full rewrite of the Mac OS, and Apple hoped to beat Microsoft Windows 95 to market with a development cycle of only one year.

The [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) development was hampered by many missed deadlines. The release date was first pushed back to the end of 1995, then to mid-[1996](https://github.com/seanpm2001/WacOS/wiki/1996/), late 1996, and finally to the end of [1997](https://github.com/seanpm2001/WacOS/wiki/1997/). With a dedicated team of 500 software engineers and an annual budget of $250 million, Apple executives began to grow impatient with the project continually falling behind schedule. At the Worldwide Developers Conference in January [1997](https://github.com/seanpm2001/WacOS/wiki/1997/), Apple chief executive officer (CEO) Gil Amelio announced that, rather than release [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) as one monolithic release, [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) features would be phased into the Mac OS following a six-month release cycle. These updates began with Mac OS 7.6, released during WWDC. Mac OS 8.0, released six months later, continued to integrate [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) technologies into the Mac OS.

In August [1996](https://github.com/seanpm2001/WacOS/wiki/1996/), Apple chief technology officer Ellen Hancock froze development of [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) and Apple began a search for an operating system developed outside the company. This ultimately led to Apple buying [NeXT](https://github.com/seanpm2001/WacOS/wiki/NeXT/) and developing [Rhapsody](https://github.com/seanpm2001/WacOS/wiki/Rhapsody/) which would eventually evolve into [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) in [2001](https://github.com/seanpm2001/WacOS/wiki/2001/) (now named macOS).

### Mac OS 8.0

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Splash-Screen/Mac-OS-8/Mac_os_8_splash_screen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Splash-Screen/Mac-OS-8/Mac_os_8_splash_screen.png)

Developed under the codename "Tempo", Mac OS 8.0 was released on July 26, [1997](https://github.com/seanpm2001/WacOS/wiki/1997/). (after being introduced a few days earlier on July 22) The early beta releases of the product which were circulated to developers and Apple internal audiences, were branded as [Mac OS 7.7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/), superseding the then-current release, Mac OS 7.6. The software was renamed Mac OS 8 before final release.

Major changes in this version included the Platinum theme, a Finder which was [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/)-native and multithreaded, and greater customization of the user interface.

Other features introduced in Mac OS 8.0 include the following:

Customization of system fonts and increased use of the user-set accent color.

Pop-up context menus, accessed via ctrl-click with a one-button mouse.

Pop-up (or tabbed) windows in the Finder.

Spring-loaded folders.

Live scrolling.

WindowShade widget in window titlebars.

Multithreaded Finder — file copy operations run in a separate thread and don't block the Finder UI.

Redesigned color picker.

Desktop Pictures control panel, allowing photographs to be set as the desktop background; not only tiled patterns.

Simple Finder, an option which reduces Finder menus to basic operations, to avoid overwhelming new users.

Relocation of the 'Help' menu from an icon at the right end of the menu bar to a standard textual menu positioned after the application's menus.

A faster Apple Guide, featuring HTML help pages.

Native support of Apple Filing Protocol over IP.

Performance improvements to virtual memory, AppleScript execution and system startup times.

Faster desktop rebuilding.

### Mac OS 8.1

Released on January 19, [1998](https://github.com/seanpm2001/WacOS/wiki/1998/), Mac OS 8.1 was the last version of the Mac OS to run on Motorola 68000 series processors. It addressed performance and reliability improvements. It introduced a new file system named [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS_Plus/), also named Mac OS Extended, which supported large file sizes and made more efficient use of larger hard drives via using a smaller block size. To upgrade, users must reformat the hard drive, which deletes the entire contents of the drive. Some third-party utilities later appeared that preserved the user's data while upgrading to [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS_Plus/). The 68040 systems do not support booting from [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS_Plus/) disks; the boot drive must be [HFS](https://github.com/seanpm2001/WacOS/wiki/HFS/).

Mac OS 8.1 was the first system to have a Universal Disk Format (UDF) driver, allowing for DVD support on the Mac for the first time. It also shipped with the new Java runtime (JDK 1.13).

Mac OS 8.1 also included an enhanced version of PC Exchange, allowing Macintosh users to see the long file names (up to 255 characters) on files that were created on PCs running Microsoft Windows, and supporting FAT32.

Mac OS 8.1 is the earliest version of the Mac OS that can run Carbon applications. Carbon support requires a [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) processor and installation of the CarbonLib software from Apple's website; it is not a standard component of Mac OS 8.1. Applications needing later versions of CarbonLib will not run on Mac OS 8.1. More recent versions of CarbonLib require Mac OS 8.6.

As part of Apple's agreement with Microsoft, 8.1 included [Internet Explorer 3](https://github.com/seanpm2001/WacOS/wiki/Internet_Explorer_for_Mac/) initially, but soon switched to [Internet Explorer 4](https://github.com/seanpm2001/WacOS/wiki/Internet_Explorer_for_Mac/) as its default browser.

Mac OS 8.1 was free for Mac OS 8 owners and was available in February 1998 via the apple.com website.

### Mac OS 8.5

Released October 17, [1998](https://github.com/seanpm2001/WacOS/wiki/1998/), Mac OS 8.5 was the first version of the Mac OS to run solely on Macs equipped with a [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) processor. If Mac OS 8.5 is installed on a 68k system, the Sad Mac error screen will appear. As such, it replaced some, but not all, of the 680x0 code with [PowerPC code](https://github.com/seanpm2001/WacOS/wiki/PowerPC-Processor-Support/), improving system performance by relying less on 680x0 emulation.

It introduced the Sherlock search utility. This allowed users to search the contents of documents on hard drives (if the user had let it index the drive), or extend a search to the Internet. Sherlock plug-ins started appearing at this time; these allowed users to search the contents of other websites.

Mac OS 8.5 includes several performance improvements. Copying files over a network was faster than prior versions and Apple advertised it as being "faster than Windows NT".[AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) was also rewritten to use only [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) code, which improved [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) execution speed significantly.

Font Smoothing, system-wide antialiasing for type was also introduced. The HTML format for online help, first adopted by the Finder's Info Center in Mac OS 8, was now used throughout. This made it easier for software companies to write online help systems. The PPP control panel was removed and replaced with Remote Access, which provides the same functionality but also allows connections to AppleTalk Remote Access (ARA) servers.

The installation process was simplified considerably in Mac OS 8.5. In earlier versions the installer worked in segments and often required a user to click to continue in between stages of the installation. This was a holdover from the days when the OS was distributed on multiple floppy disks, disk swapping promoting a natural segmentation model. The Mac OS 8.5 installer generally required very little user interaction once it was started. Customisation options were also much more detailed yet simpler to manage.

From Mac OS 8.5 onward, MacLinkPlus document translation software is no longer bundled as part of the Mac OS.

Mac OS 8.5 was the first version of the Mac OS to support themes, or skins, which could change the default Apple Platinum look of the Mac OS to "Gizmo" or "HiTech" themes. This radical changing of the computer's appearance was removed at the last minute, and appeared only in beta versions, though users could still make (and share) their own themes and use them with the OS. The Appearance control panel was also updated to support proportional scroll bars, and added the option for both scroll arrows to be placed at the bottom of a scroll bar.

Along with themes support, 8.5 was the first version to support 32-bit icons. Icons now had 24-bit color (16.7 million colors) and an 8-bit alpha channel, allowing for transparency-translucency effects.

The application palette made its debut with 8.5 – the application menu at the right side of the menu bar could be resized to show the active application's name, or 'torn off' into a palette of buttons. This palette could be customized in many ways, by removing the window frame and changing the size and layout of the buttons. Apple provided no user interface to set these options, instead making them available via [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) and Apple Events and relying on third parties to provide a user interface for the task. By setting it to display horizontally and turning off the window border, the palette's look and function could be configured to resemble the Windows 95 task bar.

### Mac OS 8.5.1

Mac OS 8.5.1, released December 7, [1998](https://github.com/seanpm2001/WacOS/wiki/1998/), was a minor update to Mac OS 8.5 that fixes several bugs that caused crashes and data corruption.

### Mac OS 8.6

Released May 10, [1999](https://github.com/seanpm2001/WacOS/wiki/1999/), Mac OS 8.6 added support to the Mac OS nanokernel to handle preemptive tasks via the Multiprocessing Services 2.x and later developer API. This update improved PowerBook battery life and added Sherlock 2.1. This free update for Mac users running 8.5 and 8.5.1 was faster and much more stable than either version of 8.5.x and was also the first version of Mac OS to display the version number as part of the startup screen. However, there was still no process separation; the system still used cooperative multitasking between processes, and even a process that is Multiprocessing Services-aware still had a portion that ran in the "blue task", which also ran all programs that were unaware of it, and was the only task that could run 68k code.

### Versions of Mac OS 8

Version 	Release date 	Changes 	Computer 	Codename 	Price

8.0 	July 26, 1997 	Initial release 	Power Macintosh G3 	Tempo 	$99 US

8.1 	January 19, 1998

(download)

HFS+ file system 	iMac (Bondi Blue) Rev. A 	Bride of Buster 	Free update

8.5 	October 17, 1998 	PowerPC required, Sherlock, Themes, 32-bit icons 	iMac (Bondi Blue) Rev. B 	Allegro 	$99 US

8.5.1 	December 7, 1998

Crash, memory leaks and data corruption fixes 	iMac (5 flavors) 	The Ric Ford (of Macintouch) Release 	Free update

8.6 	May 10, 1999

(download)

New nanokernel to support Multiprocessing Services 2.0, battery life improvement 	iBook 	Veronica

## Compatibility

Macintosh model 	8.0	8.1	8.5	8.6

All Centris / Quadra machines 	Yes 	No

Macintosh LC 475, 575, 580

PowerBook 190

PowerBook 520

PowerBook 540

PowerBook Duo 2300 	Yes

PowerBook 5300

PowerBook 1400

PowerBook 2400

PowerBook 3400

Power Macintosh 4400

Power Macintosh 5200

Power Macintosh 5300

Power Macintosh 5400

Power Macintosh 5500

Power Macintosh 6100

Power Macintosh 6200

Power Macintosh 6300

Power Macintosh 6400

Power Macintosh 6500

Power Macintosh 7100

Power Macintosh 7200

Power Macintosh 7300

Power Macintosh 7500

Power Macintosh 8100

Power Macintosh 8500

Power Macintosh 9500

Power Macintosh 7600

Power Macintosh 8600

Power Macintosh 9600

Twentieth Anniversary Macintosh

Power Macintosh G3 All-In-One

Power Macintosh G3 	Yes: machine-specific version only 	Yes

PowerBook G3 	No

iMac G3 	Yes: machine-specific version only 	Yes

iMac G3 (266 MHz, 333 MHz) 	No

Power Macintosh G3 Blue and White 	Yes: machine-specific version only 	Yes

iMac G3 (Slot Loading) 	No 	Yes: machine-specific version only

Power Macintosh G4 (PCI Graphics)

Power Macintosh G4 (AGP Graphics)

iBook

<!-- **This article on classic Mac OS is a stub. You can help by expanding it.** !-->

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - Mac OS 8](https://en.wikipedia.org/wiki/Mac_OS_8)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 3:35 pm`

**Last revised on:** `2021 Thursday September 23rd at 3:35 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 3:35 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

