  
***

# Classic MacOS version history

( **Predecessor:** [LisaOS version history](https://github.com/seanpm2001/WacOS/wiki/LisaOS-version-history/) | **Successor:** [Mac OS X Version history](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Version-history/) )

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

## Early history

The Macintosh project started in late [1978](https://github.com/seanpm2001/WacOS/wiki/1978/) with Jef Raskin, who envisioned an easy-to-use, low-cost computer for the average consumer. In September [1979](https://github.com/seanpm2001/WacOS/wiki/1979/), Raskin began looking for an engineer who could put together a prototype. Bill Atkinson, a member of the Apple Lisa team, introduced Raskin to Burrell Smith, a service technician who had been hired earlier that year.

Apple's concept for the Macintosh deliberately sought to minimize the user's awareness of the operating system. Many basic tasks that required more operating system knowledge on other systems could be accomplished by mouse gestures and graphic controls on a Macintosh. This would differentiate it from its contemporaries such as MS-DOS, which use a command-line interface consisting of terse, abbreviated textual commands.

In January [1981](https://github.com/seanpm2001/WacOS/wiki/1981/), Steve Jobs completely took over the Macintosh project. Jobs and a number of Apple engineers visited Xerox PARC in December [1979](https://github.com/seanpm2001/WacOS/wiki/1979/), three months after the Lisa and Macintosh projects had begun. After hearing about the pioneering GUI technology being developed at Xerox PARC from former Xerox employees like Raskin, Jobs negotiated a visit to see the Xerox Alto computer and Smalltalk development tools in exchange for Apple stock options. The final Lisa and Macintosh operating systems use concepts from the Xerox Alto, but many elements of the graphical user interface were created by Apple including the menu bar, pull-down menus, and the concepts of drag and drop and direct manipulation.

Unlike the IBM PC, which uses 8 kB of system ROM for power-on self-test (POST) and basic input/output system (BIOS), the Mac ROM is significantly larger (64 kB) and holds key OS code. Much of the original Mac ROM was coded by Andy Hertzfeld, a member of the original Macintosh team. He was able to conserve precious ROM space by writing routines in assembly language code optimized with "hacks," or clever programming tricks. In addition to the ROM, he also coded the kernel, the Macintosh Toolbox, and some of the desktop accessories (DAs). The icons of the operating system, which represent folders and application software, were designed by Susan Kare, who later designed the icons for Microsoft Windows 3.0. Bruce Horn and Steve Capps wrote the Macintosh Finder, as well as a number of Macintosh system utilities.

Apple aggressively advertised their new machine. After its release, the company bought all 39 pages of advertisement space in the [1984](https://github.com/seanpm2001/WacOS/wiki/1984/) November/December edition of Newsweek magazine. The Macintosh quickly outsold its more sophisticated but much more expensive predecessor, the Lisa. Apple quickly developed a product named MacWorks, which allowed the Lisa to emulate Macintosh system software through System 3, by which time it had been discontinued as the rebranded Macintosh XL. Many of Lisa's operating system advances would not appear in the Macintosh operating system until [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) or later. 

## System 1

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 1.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-1/), 1.1, and 2.0 use a flat file system named Macintosh File System (MFS). The Finder provides virtual folders that could be used to organize files, but these folders are not visible from any other application and do not actually exist on the disk.

## System 2

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 2.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-2/) added support for AppleTalk and the newly introduced LaserWriter to use it.

System 2.1 (Finder 5.0) introduced the Hierarchical File System (HFS) which has real directories. This version was specifically to support the Hard Disk 20 and only implements HFS in RAM; startup and most floppy disks remain MFS 400 K volumes.

## System 3

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 3.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-3/) (Finder 5.1) was introduced with the Macintosh Plus, officially implementing [HFS](https://github.com/seanpm2001/WacOS/wiki/HFS/), 800K startup drives, support for several new technologies including SCSI and AppleShare, and Trash "bulging" (i.e., when the Trash contains files, it gains a bulged appearance).

## System 4

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

[System 4.0](https://github.com/seanpm2001/WacOS/wiki/Apple-System-4/) was released with the Macintosh SE and System 4.1 first shipped with the Macintosh II—these new machines required additional support for the first expansion slots, the Apple Desktop Bus (ADB), internal hard drives and, on the Macintosh II, external color displays and the first Motorola 68020 processor.

These releases can only run one application at a time, except for desk accessories, though special application shells such as Multi-Mac or Switcher (discussed under MultiFinder) could work around this. Visible changes are best reflected in the version number of the Finder, where major leaps are found between 1.x, 4.x, [5.x](https://github.com/seanpm2001/WacOS/wiki/Apple-System-5/), and [6.x.](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/)

System Software Release	System Version 	Release Date	Finder Version 	LaserWriter Version	Release Information

Macintosh System Software 	1.0 (.97) 	January 24, 1984	1.0 		Initial Release

Macintosh System Software (0.1) 	1.1 	May 5, 1984	1.1g 		Maintenance Release, Added Mountain scene, About box, Clean Up Command

Macintosh System Software (0.3 & 0.5) 	2.0 	April 1985 	4.1 		Finder Update: Introduced multiple folders, "Shut Down" command, and installation of a "MiniFinder" application for quickly launching any of the chosen applications

System: Introduced screenshots using ⌘ Command+⇧ Shift+3

Macintosh System Software	2.1	September 1985	5.0 		Release for Hard Disk 20 support

Macintosh System Software (0.7) 	3.0 	January 1986 	5.1 	1.1 	Introduced with Macintosh Plus

System Software 1.0 	3.1 	February 1986	5.2 	1.1 	

System Software 1.1 	3.2 	June 1986 	5.3 	3.1 	Fixed problems with data loss, system crashes; updated Chooser and Calculator.

AppleShare 1.0 	3.3 	January 1987 	5.4 		AppleShare 1.0 Work Station Installer disk (for the Macintosh 512K)

AppleShare 1.1 	3.3	1987 	5.5 		AppleShare 1.1 Work Station Installer disk (for the Macintosh 512K)

AppleShare 2.0 	3.4	1988 	6.1		AppleShare 2.0 Macintosh 512Ke Work Station Installer disk

System Software 2.0 	4.0 	January 1987	5.4 	3.3 	Release for Macintosh SE. Introduced AppleShare

System Software 2.0.1 	4.1 	March 2, 1987 	5.5 	4.0 	Release for Macintosh II. Updated LaserWriter Driver 

## System 5

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/1/Apple_Macintosh_Desktop.png)

Towards the end of [1987](https://github.com/seanpm2001/WacOS/wiki/1987/), Apple introduced a package titled "Apple Macintosh System Software Update 5.0". For the first time, the Macintosh operating system was offered as a distinct retail product that included four 800K disks and three manuals, at a cost of US$49. The software itself was still freely available through user groups and bulletin board services. While the product box presented this update to the operating system as "version 5.0", this number does not appear in the software itself. Three of the four disks (System Tools 1, System Tools 2 and Utilities 1) are all bootable, and the user can boot off of whichever floppy contain the tools the user needs. For instance, System Tools 2 is the only disk with printer drivers, and Utilities 1 is the only disk with Disk First Aid and Apple HD SC Setup. Because the disks are named System Tools, users and the press commonly referred to this version as "System Tools 5.0".

The primary new feature of [System 5](https://github.com/seanpm2001/WacOS/wiki/Apple-System-5/) is MultiFinder, an extension which lets the system run several programs at once. The system uses a cooperative multitasking model, meaning that time is given to the background applications only when the foreground application yields control. A change in system functions that applications were already calling to handle events make many existing applications share time automatically, as well as being allowed to perform tasks in the background. Users can also choose not to use MultiFinder, thereby using a single application at a time. In [1990](https://github.com/seanpm2001/WacOS/wiki/1990/) InfoWorld tested four multitasking options for PC and Mac, viewing MultiFinder positively overall, but noting that its presence halved the speed of file transfer and printing compared to the single-tasking [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) without MultiFinder.

System Software

Release	Release Date 	System Version 	Software Version 	Release Information Finder 	MultiFinder 	LaserWriter

5.0 	October 1987	4.2 	6.0 	1.0 	5.0 	Initial Release

5.1 	November 1987 	4.3 	5.1 	Updated LaserWriter Driver and new version of Apple HD SC Setup 

## System 6

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/6/Macintosh_system_6.0.8.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/6/Macintosh_system_6.0.8.png)

[System Software 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) (also referred to as "System 6") is a consolidation release of the Macintosh system software, producing a complete, stable, and long-lasting operating system. Two major hardware introductions requiring additional support under [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) are the 68030 processor and 1.44 MB SuperDrive debuting with the Macintosh IIx and Macintosh SE/30. Later updates include support for the first specialized laptop features with the introduction of the Macintosh Portable. From [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) forward, the Finder has a unified version number closely matching that of the System, alleviating much of the confusion caused by the often considerable differences between earlier Systems.

System

Version	Release

Date	Software Version 	Release Information

Finder 	MultiFinder 	LaserWriter

6.0 	April 1988 	6.1 	6.0 	5.2 	Initial Release

6.0.1 	September 19, 1988 	6.1.1 	6.0.1 	Release for Macintosh IIx (1988)

6.0.2 	Late 1988 	6.1 	Maintenance Release

6.0.3 	March 7, 1989 	6.0.3 	Release for Macintosh IIcx (1989)

6.0.4 	September 20, 1989 	6.1.4 	6.0.4 	Release for Macintosh Portable and IIci (1989)

6.0.5 	March 19, 1990 	6.1.5 	6.0.5 	Release for Macintosh IIfx (1990)

6.0.6 	October 15, 1990 	6.1.6 	6.0.6 	Not released because of AppleTalk bug

6.0.7 	October 16, 1990 	6.1.7 	6.0.7 	Official release for Macintosh LC, IIsi and Classic (1990)

6.0.8 	May 13, 1991 	6.1.8 	6.0.8 	7.0 	Updated printing software to match software of System 7.0

6.0.8L 	March 23, 1992 	Limited maintenance release for Pacific customers 

## Mac OS 7

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/7/Mac_OS_7.6.1_emulated_inside_of_SheepShaver.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/7/Mac_OS_7.6.1_emulated_inside_of_SheepShaver.png)

On May 13, 1991, [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) was released. It is a major upgrade over [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/), adding a significant user interface overhaul, new applications, stability improvements and many new features. Its introduction coincides with the release of and provided support for the 68040 Macintosh line. The [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) era saw numerous changes in the Macintosh platform including a proliferation of Macintosh models, the 68k to Power Macintosh transition as well as the rise of Microsoft Windows, increasing use of computer networking and the explosion in popularity of the Internet.

One of the most significant features of [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) is virtual memory support, an essential subsystem anticipated for years, which only exists for previous Systems in a third party extension named Virtual from Connectix. Accompanying this was a move to 32-bit memory addressing, necessary for the ever-increasing amounts of RAM available to the Motorola 68030 CPU, and 68020 CPUs with a 68851 PMMU. This process involves making all of the routines in OS code use the full 32-bits of a pointer as an address—prior systems used the upper 8 bits as flags. This change is known as being "32-bit clean". While System 7 itself is 32-bit clean, many existing machines and thousands of applications were not, so it was some time before the process was completed. To ease the transition, the "Memory" control panel contains a switch to disable this feature, allowing for compatibility with older applications.

Another notable [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) feature is built-in cooperative multitasking. In System Software 6, this function was optional through the MultiFinder. [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) also introduced aliases, similar to symbolic links on Unix, shortcuts that were introduced in later versions of Microsoft Windows, and shadows in IBM OS/2. System extensions were enhanced by being moved to their own subfolder; a subfolder in the System Folder was also created for the control panels. In System 7.5, Apple includes the Extensions Manager, a previously third-party program which simplified the process of enabling and disabling extensions.

The Apple menu, home only to desk accessories in [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/), was made more general-purpose: the user could now make often-used folders and applications—or anything else they desired—appear in the menu by placing aliases to them in an "Apple Menu Items" subfolder of the System Folder. [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) also introduced the following: [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/), a scripting language for automating tasks; 32-bit QuickDraw, supporting so-called "true color" imaging, previously available as a system extension; and TrueType, an outline font standard.

The Trash, under [System 6](https://github.com/seanpm2001/WacOS/wiki/Apple-System-6/) and earlier, empties itself automatically when shutting down the computer—or, if MultiFinder is not running, when launching an application. [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) reimplements the Trash as a special hidden folder, allowing files to remain in it across reboots until the user deliberately chose the "Empty Trash" command.

### System 7.1

System 7.1 is mainly a bugfix release, with a few minor features added. One of the major new features of System 7.1 was moving fonts out of the System file into the Fonts folder in the System Folder. Previously a resource-copying utility such as ResEdit or Font D/A Mover was required for installing fonts. System 7.1 is not only the first Macintosh operating system to cost money (all previous versions were free or sold at the cost of the floppies), but also received a "Pro" sibling (version 7.1.1) with extra features. System 7.1.2 was the first version to support PowerPC-based Macs. System 7.1 also introduces the System Enablers as a method to support new models without updating the actual System file. This leads to extra files inside the system folder (one per new model supported).

### System 7.5

System 7.5 introduces a large number of new features, many of which are based on shareware applications that Apple bought and included into the new system. On the newer PowerPC machines, System 7.5 may have stability problems partly due to a new memory manager (which can be turned off), and issues with the handling of errors in the [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) code (all PowerPC exceptions map to Type 11). These issues do not affect 68k-architecture machines. System 7.5 is contemporary with Apple's failed [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) effort as well as the release of Windows 95, which coincides with Apple's purchase of several shareware system enhancements to include as new system features.

### Mac OS 7.6

Stability improved in [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/)-based Macs with Mac OS 7.6, which dropped the "System" moniker as a more trademarkable name was needed in order to license the OS to the growing market of third-party Macintosh clone manufacturers. Mac OS 7.6 required 32-bit-clean ROMs, and so it dropped support for every Mac with a 68000 processor, as well as the Mac II, Mac IIx, Mac IIcx, and Mac SE/30. 

System Version	Release Information

System 7.0 	integrated MultiFinder always enabled

System 7.0.1 	introduced with LC II and Quadra series

System 7.0.1P 	

System 7 Tuner 	update for both 7.0 and 7.0.1

System 7.1 	introduced the Fonts folder

System 7.1P 	

System 7.1P1 	

System 7.1P2 	

System 7.1P3 	last "P" release with new features

System 7.1P4 	

System 7.1P5 	

System 7.1P6 	

System 7.1 Pro 	version 7.1.1, combined with PowerTalk, Speech Manager, MacInTalk, Thread Manager

System 7.1.2 	Macs equipped with a PowerPC processor

System 7.1.2P 	only for Performa/LC/Quadra 630 series, very quickly replaced by 7.5

System 7.5 	

System 7.5.1 	System 7.5 Update 1.0—the first Macintosh operating system to call itself "Mac OS"

System 7.5.2 	Power Macs that use PCI, usable only on these Power Macs and PowerBooks 5300, 190, and Duo 2300

System 7.5.3 	System 7.5 Update 2.0

System 7.5.3L 	only for Macintosh clones

System 7.5.3 Revision 2 	

System 7.5.3 Revision 2.1 	only for Performa 6400/180 and 6400/200

System 7.5.4 	withdrawn within hours of release and replaced by 7.5.5

System 7.5.5 	last to support non-32-bit-clean Macs, including all with less than a 68030 CPU except the Macintosh LC

Mac OS 7.6 	name formally changed because of the experimental clone program, although System 7.5.1 and later used the "Mac OS" name on the splash screen

Mac OS 7.6.1 	proper PowerPC error handling introduced

## Mac OS 8

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/8/Mac_OS_8.1_emulated_inside_of_SheepShaver.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/8/Mac_OS_8.1_emulated_inside_of_SheepShaver.png)

[Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) was released on July 26, [1997](https://github.com/seanpm2001/WacOS/wiki/1997/), the same month [Steve Jobs](https://github.com/seanpm2001/WacOS/wiki/Steve_Jobs/) became the de facto CEO of Apple. It was mainly released to keep the Mac OS moving forward during a difficult time for Apple. Initially planned as Mac OS 7.7, it was renumbered "8" to exploit a legal loophole and accomplish Jobs's goal of terminating third-party manufacturers' licenses to [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) and shutting down the Macintosh clone market.

[Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) added a number of features from the abandoned [Copland](https://github.com/seanpm2001/WacOS/wiki/Copland/) project, while leaving the underlying operating system unchanged. A multi-threaded Finder was included; files could now be copied in the background. The GUI was changed in appearance to a new shaded greyscale look named Platinum, and the ability to change the appearance themes (also known as skins) was added with a new control panel (though Platinum was the only one shipped). This capability was provided by a new "appearance" API layer within the OS, one of the few significant changes.

Apple sold 1.2 million copies of [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) in its first two weeks of availability and 3 million within six months. In light of Apple's financial difficulties at the time, there was a large grassroots movement among Mac users to upgrade and "help save Apple". Even some pirate groups refused to redistribute the OS.

### Mac OS 8.1

Mac OS 8.1 introduced an updated version of the [Hierarchical File System](https://github.com/seanpm2001/WacOS/wiki/HFS/) named [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS-Plus/), which fixed many of the limitations of the earlier system and continued to be used in macOS up until [macOS High Sierra](https://github.com/seanpm2001/WacOS/wiki/MacOS-10-13-High-Sierra/), when it was replaced with the [Apple File System](https://github.com/seanpm2001/WacOS/wiki/APFS/). There are some other interface changes such as separating network features from printing, and some improvements to application switching. However, in underlying technical respects, [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/) is not very different from [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/).

### Mac OS 8.5

Mac OS 8.5 focuses on speed and stability, with most 68k code replaced by modern code native to the PowerPC. It also improved the appearance of the user interface, although the theming feature was cut late in development.

System Version 	Release Information

Mac OS 8.0 	first version to require a 68040 processor, dropping support for the remainder of the Macintosh II series and other 68030 Macs. It also added support for the PowerPC G3 processor

Mac OS 8.1 	last Mac OS release to run on a 68k processor, and it added support for USB on the iMac and added support for the HFS+ filesystem, also called Mac OS Extended

Mac OS 8.5 	first version to run solely on a PowerPC processor, and it added built-in support for FireWire. It also added Sherlock and added support for the Power Macintosh G3

Mac OS 8.5.1 	added bug fixes to lessen system crashes

Mac OS 8.6 	included a new nanokernel for improved performance and Multiprocessing Services 2.0 support, improved PowerBook battery life, and added support for the PowerPC G4 processor 

## Mac OS 9

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/Mac_OS_9.0.4_emulated_inside_of_the_SheepShaver_emulator.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/Classic-Mac-OS/9/Mac_OS_9.0.4_emulated_inside_of_the_SheepShaver_emulator.png)

[Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/), the last major revision of the classic Mac OS, was released on October 23, [1999](https://github.com/seanpm2001/WacOS/wiki/1999/). It is generally a steady evolution from [Mac OS 8](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-8/). Early development releases of Mac OS 9 were numbered 8.7.

[Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) added improved support for AirPort wireless networking. It introduced an early implementation of multi-user support. Though not a true multi-user operating system, [Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) does allow multiple desktop users to have their own data and system settings. An improved Sherlock search engine added several new search plug-ins. Mac OS 9 also provides a much improved memory implementation and management. [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/) was improved to allow TCP/IP and networking control. [Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) also makes the first use of the centralized Apple Software Update to find and install OS and hardware updates.

Other new features included its on-the-fly file encryption software with code signing and Keychain technologies, Remote Networking and File Server packages, and much improved list of USB drivers.

[Mac OS 9](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-9/) also added some transitional technologies to help application developers adopt some [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) features before the introduction of the new OS to the public, to help ease the transition. These included new APIs for the file system and the bundling of the Carbon library that apps could link against instead of the traditional API libraries—apps that were adapted to do this could be run natively on [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/) as well. Other changes were made beginning with the Mac OS 9.1 update to allow it to be launched in the Classic Environment within [Mac OS X](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-0-Cheetah/).

The final update to the classic Mac OS was version 9.2.2, released on December 5, [2001](https://github.com/seanpm2001/WacOS/wiki/2001/).

System Version	Release Information

Mac OS 9.0 	initial retail version of Mac OS 9

Mac OS 9.0.2 	

Mac OS 9.0.3

Mac OS 9.0.4

Mac OS 9.1 	included with Mac OS X 10.0

Mac OS 9.2 	update for improved Mac OS X compatibility

Mac OS 9.2.1 	

Mac OS 9.2.2 	final release of classic Mac OS 

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - Classic MacOS](https://en.wikipedia.org/wiki/Classic_Mac_OS)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 9:25 pm`

**Last revised on:** `2021 Thursday September 23rd at 9:25 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 9:25 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

