  
***

# System 6

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/6/Macintosh_system_6.0.8.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/System-software/6/Macintosh_system_6.0.8.png)

( **Predecessor:** [System 5 (1987)](https://github.com/seanpm2001/WacOS/wiki/Apple-System-4/) | **Successor:** [Mac OS 7 (1991)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) )

Apple System 6 is the sixth major version of the then-to-be classic MacOS series of operating systems produced by Apple Inc.

System 6 (or System Software 6) is a graphical user interface-based operating system for Macintosh computers, made by Apple Computer, Inc. It was released in [1988](https://github.com/seanpm2001/WacOS/wiki/1988/), and is part of the classic Mac OS series. It is a monolithic operating system, with cooperative multitasking based on an improved MultiFinder. The boxed version cost US$49 (equivalent to about $110 in [2020](https://github.com/seanpm2001/WacOS/wiki/2020/)), and it was included with all new Macintosh computers until [1991](https://github.com/seanpm2001/WacOS/wiki/1991/), when it was succeeded by [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/).

## Features

### MacroMaker

The MacroMaker utility was introduced in System 6. It records mouse and keyboard input as macros, and has a unique user interface intended to look and act like a tape recorder. MacroMaker was criticized for its lack of features when compared to Microsoft's AutoMac III, which was already available commercially. As MacroMaker records only the locations of mouse-clicks inside windows and not what is being clicked on or exactly when, it can not be used to automate actions in more sophisticated programs. The pre-recorded clicks miss buttons if the buttons had moved since the recording, or if they failed to appear upon playback, It records the start and end locations of mouse movements, but does not track the precise path of a movement or support pauses. MacroMaker is not compatible with [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/), in which it is succeeded by [AppleScript](https://github.com/seanpm2001/WacOS/wiki/AppleScript/).

### Multitasking

Macintosh gained cooperative multitasking in March [1985](https://github.com/seanpm2001/WacOS/wiki/1985/) with Andy Hertzfeld's Switcher, which can switch between multiple full-screen applications. It was not integrated, and was only sold separately by Apple. Not many programs and features function correctly with Switcher, and it does not share the screen between applications simultaneously. Systems 5 and 6 have MultiFinder instead, which is much more mature and widely used in System 6. With MultiFinder, the Finder does not quit to free resources, and the system behaves as in the still-familiar multitasking fashion, with the desktop and other applications' windows in the background.

### Hardware support

System 6 includes support for the Apple ImageWriter LQ and PostScript laser printers. New software drivers allow the ImageWriter LQ to be used on AppleTalk local area networks and supports the use of tabloid or B-size paper (11 in × 17 in or 280 mm × 430 mm). System 6 includes QuickerGraf (originally QuickerDraw), system software used to accelerate the drawing of color images on the Macintosh II. It was licensed to Apple and Radius Inc by its programmer, Andy Hertzfeld.

## Limitations

In comparison to the NeXTSTEP operating system of the time, System 6 does not make much use of sound, and its user interface is limited in file management and window displays. System 6's Apple menu cannot be used to launch applications. The icon in the upper right-hand corner of the menu bar simply shows the open application and is not a menu. System 6 supports 24 bits of addressable RAM (random access memory), which allows for a maximum of 8 megabytes of RAM, with no provision for virtual memory. These limitations were removed in [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/). System 6's version of the HFS file system also has a volume size limit; it supports up to 2 gigabytes (GB) and 65,536 files on any one volume. [System 7.5](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/) increased this limit to 4 GB.

The Trash (known as the "Wastebasket" in the British-English version) empties when the Finder terminates. If MultiFinder is not running, this occurs as soon as an application launches. Icons on the Desktop in System 6 are not organized into a single folder, as in later operating systems. Instead, the system records if a file is on the Desktop. This is inefficient and confusing, as the user cannot browse to the Desktop in applications besides the Finder, even within the standard Open and Save As dialog boxes. Furthermore, these dialogs are primitive, and were mostly unchanged since 1984. The lack of aliases, shortcuts to files, is another limitation of file management on System 6, and custom file and folder icons are not supported. These issues were all remedied in [System 7](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-7/).

A maximum of 15 desk accessories may be installed at one time, including the Chooser, Scrapbook, and Control Panel. System 6 uses the Control Panel desk accessory to access all the installed control panels, which imposes severe user-interface limitations. Desk Accessories cannot be installed or removed within the Finder; this requires the Font/DA Mover utility. System 7 also fixed this. Control Panels, however, are contained in separate files.

The interface is not very customizable. The Finder allows each icon to be assigned a color, but the desktop background is limited to an 8x8-pixel color tiled pattern (color patterns were introduced in System 5), and standard window frames are black-and-white. However, many "INIT" extension files exist to add color and customization. System 7 allows the user to change the color of window frames and various other aspects of the user interface. By [1989](https://github.com/seanpm2001/WacOS/wiki/1989/), the System 6 user interface was in need of a change.
Reception

Initial releases of System 6 are unstable; many third-party developers did not receive advance copies, resulting in widespread compatibility issues. The contemporary versions of many common programs such as Microsoft Excel, Microsoft Works and 4th Dimension were not fully compatible with System 6. There were also software bugs in the Color Manager, Script Manager, and Sound Manager extension files. Apple announced that 66 bugs were fixed with version 6.0.1 update, in September 1988. However, a major bug involving the text-spacing of screen fonts was found, and was fixed in version 6.0.2. Some customers waited longer until moving to System 6 because of its poor reputation.

## Compatibility

System 6 was officially supported by Apple for many different machines, some of which shipped with it. Some unsupported Macintosh computers can run it with limitations.[

Macintosh Model 	Model Date 	6.0.8 	6.0.7	6.0.5 	6.0.4 	6.0.3 	6.0.2

[128K](https://github.com/seanpm2001/WacOS/wiki/Macintosh_128K/) 	[1984](https://github.com/seanpm2001/WacOS/wiki/1984/) 	No 	No 	No 	No 	No 	No

512K 	No 	No 	No 	No 	No 	No

512Ke 	1986 	Yes	Yes 	Yes	Yes 	Yes 	Yes

Macintosh XL 	1985 	No 	No 	No 	No 	No 	No

Plus 	1986 	Yes 	Yes 	Yes 	Yes 	Yes 	Yes

SE 	1987 	Yes 	Yes 	Yes 	Yes 	Yes 	Yes

SE/30 	1989 	Yes 	Yes 	Yes 	No 	Yes 	Yes

Classic 	1990 	Yes 	Yes 	Yes 	Yes 	Yes	No

Classic II 	1991 	Yes: 6.0.8L 	No 	No 	No 	No 	No

Portable 	1989 	Yes 	Yes 	Yes 	Yes 	Yes 	Yes

II 	1987 	Yes 	Yes 	Yes 	Yes 	Yes 	Yes

IIx 	1988 	Yes 	Yes 	Yes 	Yes 	Yes 	Yes

IIcx 	1989 	Yes 	Yes 	Yes 	Yes 	Yes 	Yes

IIci 	Yes 	Yes 	Yes 	Yes 	No 	No

IIfx 	1990 	Yes 	Yes 	Yes 	No 	No 	No

IIsi 	Yes 	Yes 	No 	No 	No 	No

LC 	Yes 	Yes 	No 	No 	No 	No

LC II 	1992 	Yes 	No 	No 	No 	No 	No

Quadra 700 	1991 	No 	No 	No 	No 	No 	No

Quadra 900/950 	1991/1992 	No 	No 	No 	No 	No 	No

PowerBook 100 	1991 	Yes: 6.0.8L 	Partial: limited	Partial: limited 	No 	No 	No

PowerBook 140

145/145B/170 	1991/1992/1993 	No 	No 	No 	No 	No 	No

## Version history

System version 	Release date	Finder version 	MultiFinder version	LaserWriter version	Release information

6.0 	April 1988 	6.1 	6.0 	5.2 	Initial release

6.0.1 	September 19, 1988 	6.1.1 	6.0.1 	Release for Macintosh IIx (1988)

6.0.2 	September 19, 1988 	6.1 	6.0.1 	Maintenance release

6.0.3 	December 23, 1988 	6.0.3 	Maintenance release with bug fixes for Apple File Exchange, Time Manager, and other components. New York 18 and 24 fonts were removed.

6.0.4 	September 20, 1989 	6.1.4 	6.0.4 	Release for Macintosh Portable and IIci (1989)

6.0.5 	March 19, 1990 	6.1.5 	6.0.5 	Release for Macintosh IIfx (1990)

6.0.6 	March 19, 1990 - October 15, 1990 	6.1.6 	6.0.6 	Packed with early Macintosh IIsi, LC, and Classic; contains bugs with keyboard and AppleTalk.

6.0.7 	October 15, 1990 	6.1.7 	6.0.7 	Official release for Macintosh LC, IIsi, and Classic (1990)

6.0.8 	May 13, 1991 	6.1.8 	6.0.8 	7.0 	Updated printing software to match the printing software of System 7.0

6.0.8L 	March 23, 1992	Used only on the Macintosh Classic, Classic II, LC, LC II, and PowerBook 100.

**This article on classic Mac OS is a stub. You can help by expanding it.**

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - System 6](https://en.wikipedia.org/wiki/System_6)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Thursday September 23rd at 2:55 pm`

**Last revised on:** `2021 Thursday September 23rd at 2:55 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Thursday September 23rd at 2:55 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

