  
***

# OS X 10.7 (Lion)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/OS_X_Lion_icon.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/OS_X_Lion_icon.png)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/Mac_OSX_Lion_screen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/OS_X/10.7_Lion/Mac_OSX_Lion_screen.png)

( **Predecessor:** [Mac OS X 10.6 (Snow Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/) | **Successor:** [OS X 10.8 (Mountain Lion)](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-8-Mountain-Lion/) )

OS X Lion, also known as Mac OS X Lion, (version 10.7) is the eighth major release of macOS, Apple's desktop and server operating system for Macintosh computers.

A preview of Mac OS X 10.7 Lion was publicly shown at the "Back to the Mac" Apple Special Event on October 20, [2010](https://github.com/seanpm2001/WacOS/wiki/2010/). It brought many developments made in Apple's iOS, such as an easily navigable display of installed applications, to the Mac, and includes support for the Mac App Store, as introduced in [Mac OS X 10.6 Snow Leopard](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/) version 10.6.6. On February 24, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), the first developer's preview of Lion (11A390) was released to subscribers to the Apple Developer program. Other developer previews were subsequently released, with Lion Preview 4 (11A480b) being released at WWDC 2011.

Lion was released to manufacturing on July 1, [2011](https://github.com/seanpm2001/WacOS/wiki/2011/), followed by its final release via the Mac App Store on July 20, 2011. Apple reported over one million Lion sales on the first day of its release. As of October 2011, Mac OS X Lion had sold over six million copies worldwide.

Lion is the final release whose development was overseen by Bertrand Serlet, considered the "founding father of Mac OS X".

Although originally paid, Apple later allowed free downloads of the OS, starting on June 30, 2021.

## Release and distribution

Mac OS X Lion was announced alongside [iOS 5](https://github.com/seanpm2001/WacOS/wiki/iOS_5/) and iCloud at WWDC 2011 at Moscone West.

On June 6, 2011, at the Apple Worldwide Developers Conference, it was announced that the official release for Lion would be in July 2011. The specific release date of July 20 was not confirmed until the day before, July 19, by Apple CFO, Peter Oppenheimer, as part of Apple's 2011 third-quarter earnings announcement.

Apple did not initially announce any physical media distribution for Lion, such as a set of CD-ROMs or a DVD-ROM as used for past releases. Instead, the operating system was said to be available exclusively as a download from the Mac App Store for US$29.99. The only prior version of OS X that supports the Mac App Store is Snow Leopard, which implied that any machines that support Lion currently running [Tiger](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger/) or [Leopard](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/) would first have to be upgraded to [Snow Leopard](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/), as opposed to allowing a direct upgrade to Lion.

Apple later announced two alternative distribution mechanisms for the benefit of users without broadband Internet access: in-store downloads at retail Apple Stores, and a USB flash drive containing the OS, priced at US$69, available through the online Apple Store beginning in August. On August 4, 2011, Apple started to take orders for Mac OS X Lion's USB installation flash drives for $69.99.

The Server portion of Lion is available as a separate download from the Mac App Store for US$49.99, which is in addition to the purchase price of Lion itself.

In July [2012](https://github.com/seanpm2001/WacOS/wiki/2012/), Lion was removed from the Mac App Store and retail Apple stores following the release of OS X Mountain Lion. Following the removal of Lion from the Mac App Store, customers could still purchase Lion by phone at the reduced price of $20. In October [2013](https://github.com/seanpm2001/WacOS/wiki/2013/), Lion was returned to the Apple Store website concurrently with Mountain Lion following the release of OS X Mavericks for the convenience of users who cannot run Mavericks on older Mac models.

## Hardware support

The first developer preview of Lion added TRIM support for Solid-state drives (SSD) shipped with Macs, which is also included in the latest version of Snow Leopard (10.6.8) shipping with MacBook Pros before July 20, 2011. Other SSDs have built-in TRIM-like optimization, while yet others require OS patching.

## System requirements

x86-64 CPU (64-bit Macs, with an Intel Core 2 Duo, Intel Core i5, Intel Core i7, or Xeon processor.)

At least 2 GB of memory

Mac OS X 10.6.6 or later (Mac OS X 10.6.8 is recommended)

7 GB of available space

AirDrop is supported on the following Mac models: MacBook Pro (late 2008 or newer), MacBook Air (late 2010 or newer), MacBook (late 2008 or newer), iMac (early 2009 or newer), Mac Mini (mid-2010 or newer), Mac Pro (early 2009 with AirPort Extreme card and mid-2010 or newer).

## New or changed features

Some new features were announced at the "Back to the Mac" keynote in October 2010, and the Apple website was updated in February 2011, with more details. Other features were announced at the WWDC 2011 keynote or on Apple's Mac OS X Lion Web site after the keynote. Apple states that there are over 250 new or changed features in Lion, including:

Address Book uses an iPad-like user interface. It also includes improved Yahoo support and FaceTime calling.

AirDrop – Lion-to-Lion direct file sharing via Wi-Fi Direct, with no wireless access point required.

Address space layout randomization – Address space layout randomization (ASLR), a security technique that puts important data in unpredictable locations, making it harder to target known weaknesses, is available for 32-bit applications, and "has been improved for all applications", in Lion.

Apple Push Notification Service – Send over-the-air alerts, such as news updates or social networking status changes, using Apple's Push Notification service to applications that support APNS. APNS allows Mac OS X Lion and iOS clients to receive push changes to items such as mail, calendar and contacts from a configured OS X Lion Server.

Auto-correction behaves much like on iOS devices, displaying an iOS-like popup box.

Auto Save – As in iOS, documents in applications written to use Auto Save are saved automatically so users do not have to worry about manually managing their documents. The Auto Save feature significantly alters traditional workflow patterns and is a controversial addition to the system.

Emoji support – Apple has added a new Emoji font commonly used in chat to express ideograms.

Exposé in the Dock, a way of activating Exposé for a single application from the Dock, a feature added in Mac OS X 10.6, is altered. One must double-tap with two fingers on a dock icon to initiate single-application Exposé, or simply right-click or control-click and select Show All Windows.

FaceTime comes bundled with Lion.

[FileVault](https://github.com/seanpm2001/WacOS/wiki/FileVault/) offers full disk encryption and added security with XTS-AES 128 data encryption. Support for FileVault on external hard drives has also been added.

Finder improvements – Finder search allows multiple search criteria to be specified without creating a smart folder, Finder search offers suggestions, files can be grouped by various attributes, and one can merge files under two folders with the same name – a prompt appears asking to replace or keep both files. The navigation sidebar lost the ability to show the specific icon of a map or volume (by default; there is a hack to still add the old ability), instead it shows a grey standard map icon.

Font Book 3 – Font Book 3 provides more flexible displays of character glyphs supplied by a particular font face. Duplicate font files are flagged with a warning icon, and can be fixed automatically or resolved manually.

Full-screen apps – Native, system-wide support for full-screen applications running in their own space. Supporting applications display a new button at the top right of application window, this button opens applications in full-screen mode. However, full screen mode is not supported for dual screen setups.

High-quality multilingual speech voices – users can download new high-quality voices in more than forty languages and dialects.

iCal has an updated user interface, an annual view, and support for a full-screen view.

iChat has support for logging into Yahoo! Messenger. Users can audio- and video-chat with other iChat users using their Yahoo! accounts.

Languages/Localization – Arabic, Czech, Turkish and Hungarian are added as full system languages, to make the total number of twenty-two languages available in Mac OS X.

Launchpad – An application launcher that displays an iOS-like icon grid of installed applications. It features the ability to make multiple pages and group apps into folders that function the same as folders in iOS.

Mac App Store – An application store built in the image of the iOS App Store. Like in iOS, it provides ways for shoppers to discover apps, one-click installation of apps, and one-click updates of all or selected installed applications. Despite being announced as a future feature of Lion, the Mac App Store was released for Mac OS X 10.6 Snow Leopard on January 6, 2011, as it was bundled with the Mac OS X 10.6.6 update.

Mail 5 – Uses an iPad-like user interface, has a fullscreen-optimized view, uses chronological "Conversations" to organize messages, and supports Exchange 2010 (but not through the Exchange ActiveSync protocol, as iOS).

Mission Control replaces the "All windows" Exposé feature. It gives an overview of all running applications just like "All windows" but groups windows from the same application. At the top of the screen it gives quick access to the Dashboard, Spaces, and running full-screen applications.

Multi-touch gestures – Similar to iOS, additional gestures performed using a multi-touch input device (e.g. Magic Mouse, Magic Trackpad) allow the user to scroll, swipe to different pages, and enter Mission Control. While this is not the first official multi-touch support for Mac OS X, it has been expanded; other frameworks, such as Lux, have already created multi-touch support.

Multi-User Screen Sharing – The built-in Screen Sharing feature allows remote users to log into a separate user account from the one that is currently logged in. While one user is logged into a machine, a second user can log into the same machine remotely, seeing their own desktop and user environment.

Preview gains several features, including full-screen support and the ability to sign a document just by holding a signed piece of paper up to the camera.

Profile Manager provides several features, including push notification-based management of OS X Lion and above.

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) reincorporates some features from QuickTime Pro. New features cited include Copy/Paste, Insert Clip, Crop Video, Rotate Video, Resize, Trim, and more Export options.

Recovery Partition – Apple has introduced a recovery partition that includes utilities generally found on the OS X discs. This partition permits the user to restore their computer to its original factory state. If the partition were to become damaged or otherwise not available, such as with a new drive, a new copy of OS X Lion can be installed over the internet.

Resume – Applications resume in the same state when re-opened as already seen in iOS.

Safari – With full-screen mode and the new WebKit2 layout engine.

System Information – This feature is a re-design of System Profiler, which has been completely altered with new views which display graphical information on displays, storage devices, memory usage along with other hardware information. The previous layout remains available by clicking "System Report". Early builds of Lion also used System Information as a replacement for "About This Mac", although the final release reinstated the version of this dialog box found in Snow Leopard.

Terminal has extra features, including full screen mode.

[TextEdit](https://github.com/seanpm2001/WacOS/wiki/TextEdit/) gains a new graphical toolbar with font selection and text highlighting. The new TextEdit also supports Apple's new automatic file saving and versions technologies.

Versions – Time Machine-like saving and browsing of past versions of documents for applications written to use Versions.

Vertical text – Lion supports vertical layouts for East Asian languages.

The complete list was on Apple's website but has since been taken down; it can now be found on the Internet Archive. The developer release notes may also be of interest.

### Server features

Wiki Server 3 – Making it easier to collaborate, share, and exchange information. Users can quickly switch between a server's home page, My Page, Updates, Wikis, People, and Podcasts. File sharing is simpler, and a new Page Editor is added for easy customization.

WebDAV File Sharing – Lion Server delivers wireless file sharing for clients that support WebDAV. Enabling WebDAV in Lion Server gives iOS users the ability to access, copy, and share documents on the server from applications such as Keynote, Numbers, and Pages.

Profile Manager – Profile Manager delivers simple, profile-based setup and management for Mac OS X Lion, iPhone, iPad, and iPod touch devices. It also integrates with existing directory services and delivers automatic over-the-air profile updates using the Apple Push Notification service.

### User interface changes

Redesigned Aqua user interface elements, including buttons and progress bars. The red, yellow, and green buttons in the window decorations have also been made smaller, with a slightly changed design.

Flexible window resizing from any corner or edge of the window, similar to window resizing in Microsoft Windows and many window managers for X11.

The metal finish has also been slightly altered. It is a lighter shade of grey and features a speckled texture.

Scrollbar arrows have been removed.

Scrolling is reversed by default, to act more like a touch screen device, so that content moves in the direction of finger movement on touch-pad or mouse (with the scrollbar moving in the opposite direction), rather than the scrollbar moving in the direction of finger movement (with the content moving in the opposite direction). Also, like in iOS, scrolling "bounces" when the scroll bar hits the top or bottom of the window.

When resizing a window by clicking on the green button (left-top), a transform effect animates the enlargement.

New windows fly to the front (like opening an app in iOS).

The dashboard is its own space in Mission Control, rather than in previous versions of OS X where the widgets simply flew in and the background dimmed. The "ripple effect" that was seen previously when adding widgets is no longer there due to this change. Users have the option to return to the old dashboard configuration in System Preferences.

Tabs, when selected, have a recessed and darkened appearance as opposed to previous versions where selected tabs were highlighted in aqua blue.

### Dropped features

Save As – replaced by Duplicate and Revert functions due to the introduction of Auto Save and Versions (only applies to applications modified to support Auto Save, such as TextEdit; applications not modified to support Auto Save, such as Microsoft Word, retain this functionality).

Front Row, a media center application. The application has been copied into Lion by third-party users, however its incompatibility with iTunes 10.4 renders some features useless.

Rosetta, software that makes possible the execution of PowerPC software on x86 hardware, is no longer available. This disables some programs that ran on previous versions of Mac OS X. Programs requiring Rosetta to operate are not allowed to be distributed via the Mac App Store.

Adobe Flash Player and Apple's Java Runtime Environment (JRE) are not included in new installations of Lion, but both can still be downloaded and installed manually. Apple is no longer actively maintaining its JRE, but Software Update offers to download Snow Leopard's JRE when a user tries to run a Java program and the JRE is not installed. Programs using Java are not allowed to be distributed via the Mac App Store.

iSync, software used for syncing contacts and calendars to third-party mobile phones, is no longer included; however, iSync v3.1.2 from Snow Leopard continues to work.

Remote Install Mac OS X, software that allows OS X to be installed using the Remote Disk feature. Using Target Disk Mode, users can circumvent this omission. This is replaced by the Recovery Partition, which does exactly the same thing but without needing an external disk, as long as the hard disk is not damaged.

Apple USB Modem is not compatible with Lion.

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) Streaming Server, software used to deliver video and audio on request to users over a computer network, including the Internet.

WPA Enterprise configuration for wireless networks was replaced by the requirement to obtain a configuration profile.

Intro Videos were removed.

## Reception

Reception for OS X Lion has been mixed; complaints include a substantial backlash by "Pro" users with workflows affected by the Autosave/Revert workflow. Other highly criticized decisions include the change to "natural scrolling", hiding of the scroll bar, the omission of the iSync program necessary to synchronize a Mac with non-Apple mobile devices, as well as abandoned functionality in Exposé and Spaces.

However, in an extensive review of the operating system, Ars Technica recommended Lion. They noted that it feels like it is the start of a new line of operating systems that will continue to be influenced by Apple's iOS platform. The review also compared the introduction of Lion, along with its new conventions that change traditional ways of computing, with the original Mac OS X and when it replaced the classic Mac OS. Macworld called Lion a "radical revision", praising the changes made to the operating system to be more user friendly to new Mac users who are familiar with the iOS interface, while criticizing the limited utility of the interface. Ultimately, the magazine considered Lion an operating system worth getting, giving it 4.5 out of 5 stars. guardian.co.uk called Lion a substantial improvement from its predecessors and considered it a "steal" given its price.

On the other hand, Gizmodo stated that the new interface "feels like a failure" and concluded by saying that "it doesn't feel like a must-have upgrade". Ted Landau of MacObserver also had serious criticism of Lion, reversing his earlier praise of Autosave and writing, "Auto Save takes irritatingly long when working with large documents. Still others lament the loss of the Save As… command, noting that the new Duplicate option is not as convenient to use. The consensus is that none of this would matter much — if you could disable Auto Save. If you like how it works, leave things as is. Otherwise, get rid of it. But Lion offers no way to turn Auto Save off. This is the heart of the "my way or the highway" complaint. A posting sums it up: "The new features are intrusive, non-respectful of the users' choices, and cannot be changed."

Due to Lion's enhanced security features, including application sandboxing, Dino Dai Zovi, principal of security consultancy Trail of Bits and the coauthor (with Charles Miller) of The Mac Hacker's Handbook, characterized Lion's security as "a significant improvement, and the best way that I've described the level of security in Lion is that it's Windows 7, plus, plus. I generally tell Mac users that if they care about security, they should upgrade to Lion sooner rather than later, and the same goes for Windows users, too."

## Software incompatibilities

Applications depending on Rosetta, such as Office for Mac 2004, AppleWorks, and early versions of Quicken for Mac 2007, are no longer supported. This affects applications listed as Classic or PowerPC in System Profiler.

Unix package managers for Mac OS X such as Fink and MacPorts require reinstalling and then running Xcode.

## Release history

**Unsupported**

Version 	Build	Date 	OS name 	Notes 	Download

10.7 	11A511 	July 20, 2011 	Darwin 11.0 	Original retail Mac App Store release 	Available from the Mac App Store

11A511s 	August 16, 2011 	Original retail USB Thumb Drive release 	N/A

11A2061	July 20, 2011 	Darwin 11.0.2 	For Mid 2011 Mac Mini (11A2061) and Mid 2011 MacBook Air (11A2063) 	Lion Internet Recovery (⌘ Cmd+⌥ Opt+R upon reboot on Mid-2011 or later Macs)

11A2063

10.7.1 	11B26 	August 16, 2011 	Darwin 11.1.0 	About the OS X Lion v10.7.1 Update 	Mac OS X 10.7.1 Update

11B2118 	For the Mid 2011 Mac Mini and Mid 2011 MacBook Air 	Mac OS X 10.7.1 Update (for MacBook Air and Mac Mini 2011)

10.7.2 	11C74 	October 12, 2011 	Darwin 11.2 	About the OS X Lion v10.7.2 Update

Adds iCloud, various bug fixes, minor user interface tweaks, Safari 5.1.1, and the ability to boot into Lion Recovery from a Time Machine disk. 	Mac OS X 10.7.2 Update

Mac OS X 10.7.2 Update (Combo)

10.7.3 	11D50 	February 1, 2012 	Darwin 11.3 	About the OS X Lion v10.7.3 Update

Various bug fixes, Safari 5.1.3, adds Catalan, Croatian, Greek, Hebrew, Romanian, Slovak, Thai, and Ukrainian language support. 	Mac OS X 10.7.3 Update (Combo)

10.7.4 	11E53 	May 9, 2012 	Darwin 11.4 	About the OS X Lion v10.7.4 Update

Various bug fixes, Safari 5.1.6. 	Mac OS X 10.7.4

Mac OS X 10.7.4 Update (Combo)

10.7.5 	11G56 	September 19, 2012 	Darwin 11.4.2 	About the OS X Lion v10.7.5 Update

Various bug fixes, Safari 5.1.7, adds Gatekeeper functionality. 	Mac OS X 10.7.5 Update

Mac OS X 10.7.5 Update (Combo)

11G63 	October 4, 2012 		

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - OS X 10.7 (Lion)](https://en.wikipedia.org/wiki/OS_X_Lion)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Wednesday September 22nd at 6:16 pm`

**Last revised on:** `2021 Wednesday September 22nd at 6:16 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Wednesday September 22nd at 6:16 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

