  
***

# Mac OS X 10.6 (Snow Leopard)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.6_Snow_Leopard/Snow_Leopard_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.6_Snow_Leopard/Snow_Leopard_Desktop.png)

( **Predecessor:** [Mac OS X 10.5 (Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/) | **Successor:** [OS X 10.7 (Lion)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-7-Lion/) )

Mac OS X Snow Leopard (version 10.6) is the seventh major release of macOS, Apple's desktop and server operating system for Macintosh computers.

Snow Leopard was publicly unveiled on June 8, [2009](https://github.com/seanpm2001/WacOS/wiki/2009/) at Apple’s Worldwide Developers Conference. On August 28, 2009, it was released worldwide, and was made available for purchase from Apple's website and retail stores at the price of US$29 for a single-user license. As a result of the low price, initial sales of Snow Leopard were significantly higher than that of its predecessors whose price started at US$129. The release of Snow Leopard came nearly two years after the launch of Mac OS X Leopard, the second longest time span between successive Mac OS X releases (the time span between [Tiger](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger/) and [Leopard](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-5-Leopard/) was the longest).

Unlike previous versions of Mac OS X, the goals of Snow Leopard were improved performance, greater efficiency and the reduction of its overall memory footprint. Apple famously marketed Snow Leopard as having "zero new features". Its name signified its goal to be a refinement of the previous OS X version, Leopard. Much of the software in Mac OS X was extensively rewritten for this release in order to take full advantage of modern Macintosh hardware and software technologies (64-bit, Cocoa, etc.). New programming frameworks, such as OpenCL, were created, allowing software developers to use graphics cards in their applications. This was also the first Mac OS release since System 7.1.1 that does not support Macs using PowerPC processors, as Apple dropped support for them and focused on Intel-based products. As support for Rosetta was dropped in Mac OS X Lion, Snow Leopard is the last version of Mac OS X that is able to run PowerPC-only applications.

Though the final release only supports Intel processors, two development builds that supported PowerPC processors are known to exist, builds 10A96 and 10A190.

Snow Leopard was succeeded by [OS X Lion](https://github.com/seanpm2001/WacOS/wiki/OS-X-10-7-Lion/) (version 10.7) on July 20, 2011. For several years, Apple continued to sell Snow Leopard at its online store for the benefit of users that required Snow Leopard in order to upgrade to later versions of OS X. Snow Leopard was the last version of Mac OS X to be distributed primarily through optical disc, as all further releases were mainly distributed through the Mac App Store introduced in the Snow Leopard 10.6.6 update.

Snow Leopard was the last release of Mac OS X to support the 32-bit Intel Core Solo and Intel Core Duo CPUs. Because of this, Snow Leopard still remained somewhat popular alongside OS X Lion, despite its lack of continued support, mostly because of its ability to run PowerPC-based applications.

Snow Leopard was also the last release of Mac OS X to ship with a welcome video at first boot after installation. Reception of Snow Leopard was positive.

## System requirements

Apple states the following basic Snow Leopard system requirements are:

Mac computer with an Intel processor (IA-32). "Yonah" processors such as Core Solo and Core Duo can run only 32-bit applications; later x86-64 architecture processors such as Core 2 Duo, Core i5 and i7 are also able to run 64-bit applications.

1 GB of RAM

5 GB of free disk space

DVD drive (also accessible via Remote Disc) or external USB or FireWire DVD drive for installation

Additional requirements to use certain features:

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) H.264 hardware acceleration support requires an Nvidia GeForce 9400M, 320M, or GT 330M graphics card

OpenCL requires a supported Nvidia or ATI graphics card

Snow Leopard releases do not support PowerPC-based Macs (e.g., Power Macs, PowerBooks, iBooks, iMacs (G3-G5), all eMacs, plus pre-February 2006 Mac minis and the Power Mac G4 Cube), although PowerPC applications are supported via Rosetta, which is now an optional install. In 2020, two developer previews of Snow Leopard that are universal appeared on the Internet that can be booted on select G4 and G5 Power Macs with modification and patching.

## License

Snow Leopard is available as an upgrade for Intel-based Macintosh computers. Single-user licenses and "family pack" licenses for up to five computers are available. For qualifying Mac computers bought after June 8, 2009, Apple offered a discounted price through its "up-to-date" program, provided that customers' orders were faxed or postmarked by December 26, 2009. The standalone retail version of Snow Leopard is marketed as being restricted to users of Mac OS X Leopard, while the recommended upgrade path from Apple for Mac OS X Tiger is through the "Mac Box Set", which includes Mac OS X Snow Leopard and the current versions of iLife and iWork.

There are three licenses available. These licenses differ in their requirements for pre-installed versions of Mac OS X:

Leopard Upgrade: requires that [Mac OS X Leopard](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-Leopard/) already be installed.

If you have purchased an Upgrade for Mac OS X Leopard license, then subject to the terms and conditions of this License, you are granted a limited non-exclusive license to install, use and run one (1) copy of the Apple Software on a single Apple-branded computer as long as that computer has a properly licensed copy of Mac OS X Leopard already installed on it.

A "Family Pack Upgrade for Mac OS X Leopard" license is also mentioned as a subset of the Leopard Upgrade.

Single Use: places no restriction on which (if any) version of Mac OS X should already be installed. Used for the non-upgrade and Mac Box Set versions of Snow Leopard.

Subject to the terms and conditions of this License ... you are granted a limited non-exclusive license to install, use and run one (1) copy of the Apple Software on a single Apple-branded computer at a time.

Family Pack: identical to the Single Use license in this respect.

It is not entirely clear which license is offered with the retail version of Snow Leopard. As noted above, Apple's website advertised this version as an "upgrade from Mac OS X Leopard for $29" and suggest that others upgrade using the Mac Box Set, implying the stand-alone retail version to be a "Leopard Upgrade" license. On the other hand, some Apple press materials appear to indicate that this version is, in fact, the "Single Use" license:

The Snow Leopard single user license will be available for a suggested retail price of $29 (US)

However, even if the retail edition of Snow Leopard is in fact a "Leopard Upgrade", the company has acknowledged that there is no technical barrier in that edition preventing a direct upgrade from Mac OS X "Tiger".

The Leopard Upgrade license explicitly applies to the Up-To-Date Program (US$9.95) for Macs bought between June 8 and December 26, 2009 and the installation discs provided through this program are clearly marked as upgrades unlike either of the retail editions.

## New or changed features

Mac OS X Snow Leopard is intended to be a release aimed to refine the existing feature set, expand the technological capabilities of the operating system, and improve application efficiency. Many of the changes involve how the system works in the background and are not intended to be seen by the user. For example, the Finder application was completely rewritten in the Cocoa application programming interface. Despite significant changes in the software, users will experience almost no changes in the user interface. Snow Leopard includes the following changes:

Mac App Store – An app marketplace built in the image of the iOS App Store. Released in version 10.6.6.

Boot Camp now allows Windows partitions to read and copy files from HFS+ partitions. The new version also adds support for advanced features on Cinema Displays and a new command-line version of the Startup Disk Control Panel.

The Finder has been completely rewritten in Cocoa to take advantage of the new technologies introduced in Snow Leopard.

A much smaller OS footprint, taking up about 7 GB less space than Mac OS X Leopard. Some of the recovered disk space (~250 MB) is because printer drivers are now downloaded or installed only as needed, rather than being pre-installed. The default install only contains those drivers needed for existing printers and a small subset of popular printers.

iChat enhancements include greater resolution video chats in iChat Theater and lowered upload bandwidth requirements.

Microsoft Exchange support is now integrated into the Mail, Address Book, and iCal applications. However, only Microsoft Exchange 2007 is supported and customers using prior versions of Exchange must either upgrade or use Microsoft Entourage.

Full multi-touch trackpad support has been added to notebooks prior to those introduced in October 2008. While the original MacBook Air and other early multi-touch trackpad enabled notebooks had support for some gestures, they were unable to use four-finger gestures. This limitation has now been removed in Snow Leopard.

Preview can infer the structure of a paragraph in a PDF document.

[QuickTime](https://github.com/seanpm2001/WacOS/wiki/QuickTime/) X (version 10), the next release of QuickTime player and multimedia framework, has been completely rewritten into a full 64-bit Cocoa application and builds on the media technologies in Mac OS X, such as Core Audio, Core Video, and Core Animation, to deliver playback. Apple has redesigned the QuickTime user interface to resemble the full-screen QuickTime view in prior versions, where the entire window displays the video. The titlebar and playback controls fade in and out as needed. QuickTime X also supports HTTP live streaming and takes advantage of ColorSync to provide high-quality color reproduction. If Snow Leopard is installed on a Mac with an nVidia GeForce 9400M, 320M or GT 330M graphics card, QuickTime X will be able to use its video-decoding capabilities to reduce CPU load.

Safari 4 features Top Sites, Cover Flow, VoiceOver, expanded standards support, and built-in crash resistance, which prevents browser crashes caused by plug-ins by running them in separate processes. Safari 4 is bundled with Snow Leopard but does not require it, as it is available for free for Mac OS X Tiger and Leopard as well as Windows.

Time Machine connection establishment and backups are now much faster.

VoiceOver has also been greatly enhanced in Snow Leopard. Reading of web pages is improved with Auto Web Spots — areas of a page automatically designated for quick access. On newer Apple portables, trackpad gestures can be used to control VoiceOver functions, including the "rotor" gesture first seen in VoiceOver for the iPhone 3GS, allowing for the changing of certain VoiceOver navigation options by rotating fingers on the trackpad. Braille Display support is also improved, with Bluetooth displays supported for the first time.

### Refinements to the user interface

While the Finder was completely rewritten in Cocoa, it did not receive a major user interface overhaul. Instead, the interface has been modified in several areas to promote ease of use. These changes include:


The "traffic light" titlebar controls are now slightly lighter in appearance and have less depth than they did in Mac OS X 10.5.

Exposé can now display windows for a single program by left clicking and holding its icon in the dock. Windows are arranged in a new grid pattern.

Contextual menus which come out of Dock icons now have more options and have a new look, with a semi-transparent charcoal background and white text.

An option has been added to the Finder preferences that allows the user to modify search behavior. The default setting can be selected to (1) search the entire computer, (2) search only the current folder from which the search was initiated, or (3) perform the search based on the previously used scope.

Dock Stacks, when viewed as a grid, allow viewing of a subfolder as a new stack, rather than launching a Finder window, in a manner similar to "tunnelling". When viewed as grids or lists, scroll-bars are provided to navigate folders with more items than the current screen resolution will accommodate, as the program does not scale the icons to show as many as possible the way it did in OS X 10.5.

The default gamma has been changed from 1.8 to 2.2 to better serve the color needs of digital content producers and consumers.

Windows can now be minimized directly onto their application's icon in the dock.

Faster PDF and JPEG icon refreshes.

When searching for a network, the AirPort menu-bar icon animates until it finds a network and shows network strength of available networks in the drop down menu.

Prefixes for bytes are now used in strictly decimal meaning (as opposed to their binary meaning) when describing disk space, such that an indicated file size of 1 MB corresponds to 1 million bytes, as commonly used by hard disk manufacturers.

Snow Leopard shuts down and goes to sleep faster.

### New wallpapers

As with most upgrades of Mac OS X, new wallpapers are available. There are new wallpapers in the Nature (two of which are of snow leopards), Plants and Black and White sub-folders under the Apple folder. Furthermore, there are new Apple wallpaper sub-folders with multiple wallpapers:

Art: Dancer on the Stage, Nighthawks, Poppies Blooming, Sunday Afternoon, Suprematism, The Great Wave, and Water Lilies.

Patterns: Pinstripe and Saree.

New solid colors can be used as wallpapers as well. There is a new blue and gray, as well as a solid kelp which serves as the "green wallpaper." The default "space nebula" wallpaper has been updated as well.

### Dropped features

AppleTalk is no longer supported.

It is no longer possible to change an application's language using the Finder's "Get Info" dialogue. While there are workarounds for some applications, others (such as Adobe After Effects CS4) will not be able to be run in a different language than the one selected in the system without using Terminal commands or third-party software. The option to change language for individual apps was added back in macOS Catalina in 2019.

Creator codes, which are per-file metadata attributes that define, for a file that has a creator code, what application should open that file, regardless of its extension, have had their priority in the application selection process reduced.

Creating or updating Hierarchical File System (HFS Plus predecessor) volumes is no longer supported.

### Developer technologies

#### 64-bit architecture

Mac OS X Tiger added limited support for 64-bit applications on machines with 64-bit processors; Leopard extended the support for 64-bit applications to include applications using most of Mac OS X's libraries and frameworks.

In Snow Leopard, most built-in applications have been rebuilt to use the 64-bit x86-64 architecture (excluding iTunes, Front Row, Grapher and DVD Player applications). They will run in 32-bit mode on machines with 32-bit processors, and in 64-bit mode on machines with 64-bit processors.

In addition, the Mac OS X kernel has been rebuilt to run in 64-bit mode on some machines. On those machines, Snow Leopard supports up to 16 terabytes of RAM. Newer Xserve and Mac Pro machines will run a 64-bit kernel by default; newer iMac and MacBook Pro machines can run a 64-bit kernel, but will not do so by default. Users wishing to use the 64-bit kernel on those machines must hold down the numbers 6 and 4 on the keyboard while booting to get the 64-bit kernel to load. A change to the com.apple.Boot.plist will also enable users with compatible computers to permanently boot into 64-bit for those wishing to do so.

Stuart Harris, software product marketing manager at Apple Australia, said, "For the most part, everything that they experience on the Mac, from the 64-bit point of view, the applications, the operating system, is all going to be 64-bit, but that at this stage there were very few things, such as device drivers, that required 64-bit mode at the kernel level".

With Mac OS X Snow Leopard only the following Apple computers run or are capable of running the 64-bit kernel:

Product 	Model identifier 	K64 status on client version 	K64 status on server version

Xserve early 2008 and later 	Xserve2,1 and higher 	Capable 	Default

Mac Pro early 2008 	MacPro3,1

Mac Pro early 2009 	MacPro4,1

Mac Pro mid-2010 	MacPro5,1

MacBook Pro early 2008 	MacBookPro4,1 	Capable

MacBook Pro late 2008 	MacBookPro4,1 and 5,1

MacBook Pro early 2009 	MacBookPro5,2

MacBook Pro mid-2009 	MacBookPro5,3 and 5,4 and 5,5

MacBook Pro mid-2010 	MacBookPro6,1 and 6,2 and 7,1

MacBook Pro early 2011 	MacBookPro8,1 and 8,2 and 8,3 	Default

iMac early 2006 and later 	iMac4,1 and higher 	Capable 	Capable

Mac Mini mid-2010 	Macmini4,1 	Default

^* Amit Singh has reported that the early 2009 Mac Mini and MacBook may be capable of running the 64-bit kernel; however, Apple has set these models to boot into the 32-bit kernel. With some tweaking, the Unibody MacBook can be set to boot the 64-bit kernel.

#### Grand Central Dispatch

Grand Central Dispatch (GCD) uses the multiple processor cores now in every new Macintosh for more efficient performance. Due to the complexity of multithreaded programming and technical difficulties traditionally involved in making applications optimized for multicore CPUs, the majority of computer applications do not effectively use multiple processor cores. As a result, additional processing power, compared to single-core machines, often goes unused. Grand Central Dispatch includes APIs to help programmers efficiently use these cores for parallel programming.

Grand Central Dispatch abstracts the notion of threads away, and instead provides developers with the concept of queues—lists of jobs (blocks of code) that need to be executed. GCD takes the responsibility of distributing the jobs among actual threads and cores, and clearing up unused memory created by inactive or old threads to achieve maximum performance. Apple is also releasing APIs for Grand Central Dispatch for developers to use in their applications and also to analyze specific blocks of code running on Grand Central Dispatch.

A new [C](https://github.com/seanpm2001/WacOS/wiki/C-(Programming-language)/) and [Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C/) language feature named "Blocks" facilitates creation of code that will easily optimize to take advantage of Grand Central Dispatch.

#### OpenCL

OpenCL (Open Computing Language) addresses the power of graphics processing units (GPUs) to leverage them in any application, and not just for graphics-intensive applications like 3D games. OpenCL automatically optimizes for the kind of graphics processor in the Mac, adjusting itself to the available processing power. OpenCL provides consistent numeric precision and accuracy, fixing a problem that has hampered GPU-based programming in the past.

OpenCL includes a C-based programming language with a structure that is already familiar to Mac OS X programmers, who can use Xcode developer tools to adapt their programs to work with OpenCL. Only the most process intensive parts of the application need to be written in OpenCL C without affecting the rest of the code. OpenCL is an open standard that has been supported by AMD, Intel, and Nvidia; it is maintained by Khronos Group.

It serves a similar purpose to Nvidia's C for CUDA and Microsoft's Direct3D 11 compute shaders.

It only works with the following Mac GPUs: NVIDIA GeForce 320M, GT 330M, 9400M, 9600M GT, 8600M GT, GT 120, GT 130, GTX 285, 8800 GT, 8800 GS, Quadro FX 4800, FX 5600 and ATI Radeon HD 4670, HD 4850, HD 4870, HD 5670, HD 5750, HD 5770, HD 5870, HD 6490M, HD 6750M, HD 6770M, HD 6970M. If the system does not possess one of these compatible GPUs, OpenCL code will instead execute on the system's CPU.

#### CUPS

CUPS (the printing system used in many Unix-like operating systems) has been updated to version 1.4 which provides improved driver, networking, and Kerberos support along with performance improvements. CUPS 1.4 is also the first implementation of the Internet Printing Protocol version 2.1.

#### Power management

Power management has been improved, with implementation of a new wake on demand feature supported on more recent Macintosh hardware. Wake on demand takes advantage of the sleep proxy service implemented in AirPort and Time Capsule routers, so that the computer can sleep while the router responds to mDNS queries. Should the request require the host computer to wake up, the router sends the necessary special wake-up-packet to the sleeping computer.
Security

Apple strengthened Mac OS X by implementing stack protection, and sandboxing more Mac OS X components such as the H.264 decoder in QuickTime and browser plug-ins as a separate process in Safari. Secure virtual memory was an option in earlier releases on Snow Leopard, but the checkbox to disable it was removed later. An anti-malware feature was also added to the system that alerts the user if malware is detected. Mac OS X 10.6.8 added regular malware definition updates.

Computer security researcher Charlie Miller claims that OS X Snow Leopard is more vulnerable to attack than Microsoft Windows for lacking full address space layout randomization (ASLR) since Mac OS X Leopard, a technology that Microsoft started implementing in Windows Vista.

The Safari web browser has received updates to version 6.0 in Lion and Mountain Lion, but not in Snow Leopard.

## Compatibility

Snow Leopard breaks compatibility with several older versions of some applications, such as Parallels Desktop 3.0, versions of Aperture before 2.1.1, and versions of Keynote before 2.0.2, among other software. Apple has also published a list of applications with known compatibility issues with Snow Leopard.

Printer and scanner drivers used by previous versions of Mac OS X are not compatible with Snow Leopard and will be replaced during Snow Leopard installation. Since the initial release of Snow Leopard many manufacturers have provided compatible drivers that are available via Software Update. If a native driver is not available Snow Leopard also includes CUPS and Gutenprint open source drivers that may provide limited functionality.

10.6.0 introduced a bug that frequently prevented DNS queries from returning IPv6 addresses. This was resolved in 10.6.8.

## Reception

At the WWDC in 2009, Apple stated that Snow Leopard features no new major visual changes. Instead, the release focuses on refining the operating system to enable better performance.

OSNews reported that Mac OS X Snow Leopard was well received by critics.

Engadget reviewed Snow Leopard and pointed out that the price of Snow Leopard dropped from the $129 Apple charged for previous versions of Mac OS X to $29. Engadget's opinion was that this could be largely because most users would not see a noticeable change in the look and feel of the system. However, most reviews commented on the large improvement in speed of the native Mac OS X applications Finder, iCal, Mail, etc.

CNET editors gave it 4 stars out of 5, stating "Intel Mac users will like Snow Leopard's smartly designed interface enhancements, and its Exchange support is a must-have (especially with Outlook for Mac on the way). With a ton of technological improvements, Snow Leopard is worth the $29 upgrade fee."

On October 21, 2009, SFGate blogger Yobie Benjamin wrote that the "MacBook Pro that came preloaded with Snow Leopard kicks butt and is a screaming fast machine", but "when I tried to upgrade one of my 'older' MacBooks, it was a fricking disaster from hell". Apart from upgrading, Benjamin also tried a clean install. But he complained of slowness even after his clean install. He wrote, "I ended up downgrading back to OSX 10.5.8" then he concluded by writing, "I might try to do it again but it won't be till Apple releases at least 2 major fix updates. If you want to roll the dice and try, go ahead... your upgrade might work, however, random installs not working is not good for me. Lesson learned --- I'll wait."

The single-user upgrade and Family Pack units of Snow Leopard ranked 1 and 2 respectively on Amazon.com's software bestseller charts when Apple announced it would release it within the week.

Testmac.com highlighted other unexpected improvements including the release of a new version of Boot Camp, version 3.0, a cleaner, popup software update process and screen and video recording in the new QuickTime Player.

The BBC reported that a bug in Mac OS X versions 10.6.0 and 10.6.1 which, in rare cases, caused loss of user account data after use of a previously existing guest account by users who had upgraded from a previous version of Mac OS X, received wide publicity. The bug was fixed as of version 10.6.2.

## Release history

Former Apple CEO [Steve Jobs](https://github.com/seanpm2001/WacOS/wiki/Steve_Jobs/) announced Snow Leopard at WWDC on June 9, 2008, and it was privately demonstrated to developers by Senior Vice President of Software Engineering Bertrand Serlet. On Monday, May 11, 2009, after build 10A354, Apple issued a code freeze on Snow Leopard's APIs. The first public demonstration was given at WWDC 2009 by Serlet and Vice President of Mac OS Engineering, Craig Federighi.

**Unsupported**

Version 	Build 	Date 	OS name 	Notes 	Download

10.6 	10A432 	August 28, 2009 	Darwin 10.0 	Original retail DVD release 	N/A

10A433 	Server edition; Original retail DVD release

10.6.1 	10B504 	September 10, 2009 	Darwin 10.1 	About the Mac OS X v10.6.1 Update 	Mac OS X v10.6.1 Update

10.6.2 	10C540 	November 9, 2009 	Darwin 10.2 	About the Mac OS X v10.6.2 Update 	Mac OS X v10.6.2 Update

Mac OS X v10.6.2 Combo Update

10.6.3 	10D573 	March 29, 2010 	Darwin 10.3 	About the Mac OS X v10.6.3 Update 	Mac OS X v10.6.3 Update

10D575 	April 1, 2010 	Second retail DVD release 	N/A

10D578 	April 13, 2010 	About the Mac OS X v10.6.3 Update; v1.1 	Mac OS X v10.6.3 v1.1 Update (Combo)

10.6.4 	10F569 	June 15, 2010 	Darwin 10.4 	About the Mac OS X v10.6.4 Update 	Mac OS X v10.6.4 Update

Mac OS X v10.6.4 Update (Combo)

10.6.5 	10H574 	November 10, 2010 	Darwin 10.5 	About the Mac OS X v10.6.5 Update 	Mac OS X v10.6.5 Update

Mac OS X v10.6.5 Update (Combo)

10.6.6 	10J567 	January 6, 2011 	Darwin 10.6 	About the Mac OS X v10.6.6 Update 	Mac OS X v10.6.6 Update

Mac OS X v10.6.6 Update (Combo)

10.6.7 	10J869 	March 21, 2011 	Darwin 10.7 	About the Mac OS X v10.6.7 Update 	Mac OS X v10.6.7 Update

Mac OS X v10.6.7 Update (Combo)

10J3250 	For the early 2011 Macbook Pro 	Mac OS X v10.6.7 Update for early 2011 MacBook Pro

10J4138 	May 4, 2011 	For the early 2011 Macbook Pro 	MacBook Pro Software Update 1.4

10.6.8 	10K540 	June 23, 2011 	Darwin 10.8 	About the Mac OS X v10.6.8 Update 	Mac OS X v10.6.8 Update (Combo)

10K549 	July 25, 2011 	About the Mac OS X v10.6.8 Update; v1.1 	Mac OS X v10.6.8 Update v.1.1

Mac OS X v10.6.8 v1.1 Update (Combo)

Mac OS X Server includes these features and other server-related features. Apple initially stated that Server would include ZFS support, but mention of this feature later disappeared from Apple's website and it was not included in the final release due to licensing issues.

On January 27, 2016, Apple released an update for the Mac App Store on Mac OS X 10.6. The update was titled "Mac App Store Update for OS X Snow Leopard". The download was 3.5 MB.

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - Mac OS X 10.6 (Snow Leopard)](https://en.wikipedia.org/wiki/Mac_OS_X_10.6/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Wednesday September 22nd at 5:43 pm`

**Last revised on:** `2021 Wednesday September 22nd at 5:43 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Wednesday September 22nd at 5:43 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

