  
***

# Mac OS X 10.5 (Leopard)

<!--
<details>
<summary><p>Click/tap here to expand/collapse</p>
<p>the dropdown containing the Mac OS X 10.2 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.2_Jaguar/Jaguar-logo.png)

</details>
!-->

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/OSXLeopard.svg)

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/Leopard_Desktop.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/MacOS_X/10.5_Leopard/Leopard_Desktop.png)

( **Predecessor:** [Mac OS X 10.4 (Tiger)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger/) | **Successor:** [Mac OS X 10.6 (Snow Leopard)](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/) )

Mac OS X Leopard (version 10.5) is the sixth major release of macOS, Apple's desktop and server operating system for Macintosh computers. Leopard was released on October 26, [2007](https://github.com/seanpm2001/WacOS/wiki/2007/) as the successor of [Mac OS X 10.4 Tiger](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger), and is available in two editions: a desktop version suitable for personal computers, and a server version, Mac OS X Server. It retailed for $129 for the desktop version and $499 for Server Leopard was superseded by [Snow Leopard](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-6-Snow-Leopard/) (version 10.6) in [2009](https://github.com/seanpm2001/WacOS/wiki/2009/). Leopard is the final version of macOS to support the [PowerPC](https://github.com/seanpm2001/WacOS/wiki/PowerPC/) architecture as Snow Leopard functions solely on Intel based Macs.

According to Apple, Leopard contains over 300 changes and enhancements compared to its predecessor, [Mac OS X Tiger](https://github.com/seanpm2001/WacOS/wiki/Mac-OS-X-10-4-Tiger/), covering core operating system components as well as included applications and developer tools. Leopard introduces a significantly revised desktop, with a redesigned Dock, Stacks, a semitransparent menu bar, and an updated Finder that incorporates the Cover Flow visual navigation interface first seen in iTunes. Other notable features include support for writing 64-bit graphical user interface applications, an automated backup utility called Time Machine, support for Spotlight searches across multiple machines, and the inclusion of Front Row and Photo Booth, which were previously included with only some Mac models.

Apple missed Leopard's release time frame as originally announced by Apple's CEO Steve Jobs. When first discussed in June 2005, Jobs had stated that Apple intended to release Leopard at the end of [2006](https://github.com/seanpm2001/WacOS/wiki/2006) or early 2007. A year later, this was amended to Spring 2007; however on April 12, 2007, Apple issued a statement that its release would be delayed until October 2007 because of the development of the [iPhone](https://github.com/seanpm2001/WacOS/wiki/iPhone-2G/).

## New and changed features

### End-user features

Apple advertised that Mac OS X Leopard has 300+ new features, including:

A new and improved Automator, with easy starting points to easily start a workflow. It also can quickly create or edit workflows with new interface improvements. Now it can use a new action called "Watch Me Do" that lets you record a user action (like pressing a button or controlling an application without built-in Automator support) and replay as an action in a workflow. It can create more useful Automator workflows with actions for RSS feeds, iSight camera video snapshots, PDF manipulation, and much more.

Back to My Mac, a feature for MobileMe users that allows users to access files on their home computer while away from home via the internet.

Boot Camp, a software assistant allowing for the installation of other operating systems, such as Windows XP (SP2 or later) or Windows Vista, on a separate partition (or separate internal drive) on Intel-based Macs.

Dashboard enhancements, including Web Clip, a feature that allows users to turn a part of any Web page displayed in Safari into a live Dashboard widget, and Dashcode to help developers code widgets.

New Desktop, comprises a redesigned 3-D dock with a new grouping feature called Stacks, which displays files in either a "fan" style, "grid" style, or (since 10.5.2) a "list" style. Rory Prior, on the ThinkMac blog, criticized the shelf-like Dock along with a number of other changes to the user interface.

Dictionary can now search Wikipedia, and a dictionary of Apple terminology as well. Also included is the Japanese-language dictionary Daijisen, Progressive E-J and Progressive J-E dictionaries, and the 25,000-word thesaurus Tsukaikata no Wakaru Ruigo Reikai Jiten (使い方の分かる類語例解辞典), all of which are provided by the Japanese publisher Shogakukan.

A redesigned Finder, with features similar to those seen in iTunes 7, including Cover Flow and a Source list-like sidebar.

Front Row has been reworked to closely resemble the interface of the original Apple TV.

iCal calendar sharing and group scheduling as well as syncing event invitations from Mail.[18] The icon also reflects the current date even when the application is not running. In previous versions of Mac OS X, the icon would show July 17 in the icon any time the application was not running but the current date when the application was running.

iChat enhancements, including multiple logins, invisibility, animated icons, and tabbed chats, similar to features present in Pidgin, Adium and the iChat plugin Chax; iChat Theater, allowing users to incorporate images from iPhoto, presentations from Keynote, videos from QuickTime, and other Quick Look features into video chats; and Backdrops, which are similar to chroma keys, but use a real-time difference matte technique which does not require a green or blue screen. iChat also implements screen sharing, a feature previously available with Apple Remote Desktop.

Mail enhancements including the additions of RSS feeds, Stationery, Notes, and to-dos. To-dos use a system-wide service that is available to all applications.

Network file sharing improvements include more granular control over permissions, consolidation of AFP, FTP and SMB sharing into one control panel, and the ability to share individual folders, a feature that had not been available since Mac OS 9.

Parental controls now include the ability to place restrictions on use of the Internet and to set parental controls from anywhere using remote setup.

Photo Booth enhancements, including video recording with real-time filters and blue/green-screen technology.

Podcast Capture, an application allowing users to record and distribute podcasts. It requires access to a computer running Mac OS X Server with Podcast Producer.

Preview adds support for annotation, graphics, extraction, search, markup, Instant Alpha and size adjustment tools.

Quick Look, a framework allowing documents to be viewed without opening them in an external application and can preview it in full screen. Plug-ins are available for Quick Look so that you can also view other files, such as Installer Packages.

The Finder, showing files in Cover Flow View and viewing a file using Quick Look

Safari 3, which includes Web Clip.

Spaces, an implementation of virtual desktops (individually called "Spaces"), allows multiple desktops per user, with certain applications and windows in each desktop. Users can organize certain Spaces for certain applications (e.g., one for work-related tasks and one for entertainment) and switch between them. Exposé works inside Spaces, allowing the user to see at a glance all desktops on one screen.) Users can create and control up to 16 spaces, and applications can be switched between each one, creating a very large workspace. The auto-switching feature in Spaces has annoyed some of its users. Apple added a new preference in 10.5.2 which disabled this feature, but there were still bugs found while switching windows. In 10.5.3, this problem was addressed and was no longer an issue.

Spotlight incorporates additional search capabilities such as Boolean operators, as well as the ability to search other computers (with appropriate permissions).

Time Machine, an automated backup utility which allows the user to restore files that have been deleted or replaced by another version of a file. Though generally lauded in the press as a step forward for data recovery, Time Machine has been criticized in multiple publications for lacking the capabilities of third-party backup software. Analyzing the feature for TidBITS, Joe Kissell pointed out that Time Machine does not create bootable copies of backed-up volumes, does not back up to AirPort Disk hard drives and will not back up FileVault encrypted home directories until the user logs out, concluding that the feature is "pretty good at what it does" but he will only use it as part of a "broader backup strategy". One of these issues has been resolved, however; On March 19, 2008, updates were released for AirPort and Time Machine, allowing for Time Machine to use a USB hard disk which has been connected to an AirPort Extreme Base Station.

Universal Access enhancements: significant improvements to applications including VoiceOver, along with increased support for Braille, closed captioning and a new high‐quality Speech synthesis voice.

Many changes to the user interface, such as a transparent menu bar, new icons, and a 3D Dock. As well as this, the Apple icon is now black instead of blue. R.L. Prior, on the ThinkMac blog, criticized a number of changes to Leopard's user interface, including the transparent menu bar and the new folder icons. Decreased transparency of the menu bar, along with the ability to disable the menu bar transparency were added with the 10.5.2 release on February 11, 2008.

Russian language support, bringing the total to 18 languages.

Leopard removes support for Classic applications.

Introduced the Alex voice to VoiceOver.

### Developer technologies

Native support by many libraries and frameworks for 64-bit applications, allowing 64-bit Cocoa applications. Existing 32-bit applications using those libraries and frameworks should continue to run without the need for emulation or translation.

Leopard offers the [Objective-C](https://github.com/seanpm2001/WacOS/wiki/Objective-C/) 2.0 runtime, which includes new features such as garbage collection. Xcode 3.0 supports the updated language and was itself rewritten with it.

A new framework, Core Animation, allows a developer to create complex animations while specifying only a "start" and a "goal" space. The main goal of Core Animation is to enable the creation of complex animations with small amounts of program code.

Apple integrates DTrace from the OpenSolaris project and adds a graphical interface called Instruments (previously Xray). DTrace provides tools that users, administrators and developers can use to tune the performance of the operating system and the applications that run on it.

The new Scripting Bridge allows programmers to use [Python](https://github.com/seanpm2001/WacOS/wiki/Python/) 2.5 and Ruby 1.8.6 to interface with the Cocoa frameworks.

Ruby on Rails is included in the default install.

Leopard’s OpenGL stack has been updated to version 2.1, and uses LLVM to increase its vertex processing speed. Apple has been working to get LLVM integrated into GCC; LLVM’s use within other operating system facilities has not been announced.

The Graphics and Media State of the Union address confirmed many other features are possible because of Core Animation, such as live desktops, improvements to Quartz Composer with custom patches, a new PDF Kit for developers, and improvements to QuickTime APIs.

The FSEvents framework allows applications to register for notifications of changes to a given directory tree.

Leopard includes a read-only implementation of the ZFS file system.

In mid-December 2006, a pre-release version of Leopard appeared to include support for Sun’s ZFS. Jonathan Schwartz, CEO and President of Sun Microsystems, boasted on June 6, 2007, that ZFS had become "the file system" for Leopard. However, the senior project marketing director for Mac OS X stated on June 11, 2007, that the existing [HFS+](https://github.com/seanpm2001/WacOS/wiki/HFS-Plus/), not ZFS, would be used in Leopard. Apple later clarified that a read-only version of [ZFS]https://github.com/seanpm2001/WacOS/wiki/ZFS/) would be included.

Leopard includes drivers for UDF 2.5, necessary for reading HD DVD and Blu-ray discs using third-party drives, but the included DVD Player software can only play HD DVDs authored by DVD Studio Pro.

Leopard includes a framework implementing latent semantic mapping for classifying (e.g. textual) data.

Leopard is the first operating system with open source BSD code to be certified as fully UNIX-compliant. Certification means that software following the Single UNIX Specification can be compiled and run on Leopard without the need for any code modification. The certification only applies to Leopard when run on Intel processors.

Leopard includes J2SE 5.0.

## Security enhancements

New security features intend to provide better internal resiliency to successful attacks, in addition to preventing attacks from being successful in the first place.

### Library Randomization

Leopard implements library randomization, which randomizes the locations of some libraries in memory. Vulnerabilities that corrupt program memory often rely on known addresses for these library routines, which allow injected code to launch processes or change files. Library randomization is presumably a stepping-stone to a more complete implementation of address space layout randomization at a later date.

### Application Layer Firewall

Leopard ships with two firewall engines: the original BSD IPFW, which was present in earlier releases of Mac OS X, and the new Leopard Application Layer Firewall. Unlike IPFW, which intercepts and filters IP datagrams before the kernel performs significant processing, the Application Layer Firewall operates at the socket layer, bound to individual processes. The Application Layer Firewall can therefore make filtering decisions on a per-application basis. Of the two firewall engines, only the Application Layer Firewall is fully exposed in the Leopard user interface. The new firewall offers less control over individual packet decisions (users can decide to allow or deny connections system-wide or to individual applications, but must use IPFW to set fine-grained TCP/IP header-level policies). It also makes several policy exceptions for system processes: neither mDNSResponder nor programs running with superuser privileges are filtered.

### Sandboxes

Leopard includes kernel-level support for role-based access control (RBAC). RBAC is intended to prevent, for example, an application like Mail from editing the password database.

### Application Signing

Leopard provides a framework to use public key signatures for code signing to verify, in some circumstances, that code has not been tampered with. Signatures can also be used to ensure that one program replacing another is truly an "update", and carry any special security privileges across to the new version. This reduces the number of user security prompts, and the likelihood of the user being trained to simply clicking "OK" to everything.

### Secure Guest Account

Guests can be given access to a Leopard system with an account that the system erases and resets at logout.

Security features in Leopard have been criticized as weak or ineffective, with the publisher Heise Security documenting that the Leopard installer downgraded firewall protection and exposed services to attack even when the firewall was re-enabled. Several researchers noted that the Library Randomization feature added to Leopard was ineffective compared to mature implementations on other platforms, and that the new "secure Guest account" could be abused by Guests to retain access to the system even after the Leopard log out process erased their home directory.

## System requirements

Apple states the following basic Leopard system requirements, although, for some specific applications and features (such as iChat backdrops) an Intel processor is required:

Processor: any Intel processor, or PowerPC G5 or G4 (867 MHz and faster) processor

Optical drive: internal or external DVD drive (for installation of the operating system)

Memory: minimum 512 MB of RAM (additional RAM (1 GB) is recommended for development purposes)

Hard drive capacity: Minimum 9 GB of disk space available.

Leopard’s retail version was not released in separate versions for each type of processor, but instead consisted of one universal release that could run on both PowerPC and Intel processors. However, the install discs that ship with Intel-based Macs only contain Intel binaries.

Processor type and speed are checked during installation and installation halted if insufficient; however, Leopard will run on slower G4 processor machines (e.g., a 733 MHz Quicksilver) if the installation is performed on a supported Mac and its hard drive then moved to a slower/unsupported one (the drive may either be an internal mechanism or a Firewire external).

## Supported machines

Leopard can run on the later flat-panel iMac G4s, the iMac G5, iMac Intel Core Duo and iMac Intel Core 2 Duo, PowerBook G4, Power Mac G4, Power Mac G5, iBook G4, MacBook, MacBook Pro, MacBook Air, Mac Pro, Mac Mini, Xserve, Xserve G5, Xserve RAID, Macintosh Server G4, and later eMac models. Leopard can run on older hardware as long as they have a G4 upgrade installed running at the 867 MHz or faster, have at least 9 GB free of hard drive space, 512 MB RAM and have a DVD drive. Leopard however will not run on the 900 MHz iBook G3 models even though they exceed the minimum 867 MHz requirement. This is due to the lack of AltiVec support in the G3 line of processors. Leopard can be "hacked" (see below) to install on these G3 and pre-867 MHz G4 machines but the system may behave erratically and many of the programs, features, and functions may not work properly or at all. As of mid-2010, some Apple computers have firmware factory installed which will no longer allow installation of Mac OS X Leopard. These computers only allow installation of Mac OS X Snow Leopard. However, some computers (such as the 2011 model of the Mac mini) can have Leopard installed on them without hacking.

## Usage on unsupported hardware

Some ways of running Leopard on certain unsupported hardware, primarily PowerPC G4 computers with CPU speeds lower than the official requirement of 867 MHz, have been discovered. A common way is use of the program LeopardAssist, which is a bootloader similar in some respects to XPostFacto (used for installing earlier releases of Mac OS X on unsupported G3 and pre-G3 Macs) that uses the Mac’s Open Firmware to tell Leopard that the machine does have a CPU meeting the 867 MHz minimum requirement that the Installer checks for before installation is allowed to commence, when in reality the CPU is slower. Currently, LeopardAssist only runs on slower G4s and many people have installed Leopard successfully on these older machines.

Users who have access to supported hardware have installed Leopard on the supported machine then simply moved the hard drive to the unsupported machine. Alternatively, the Leopard Installation DVD was booted on a supported Mac, then installed on an unsupported Mac via Firewire Target Disk Mode. Leopard is only compiled for AltiVec-enabled PowerPC processors (G4 and G5) though, as well as Intel, so both of these methods will only work on Macs with G4 or later CPUs. While some of the earlier beta releases were made to run on some later G3 machines (mostly later 800–900 MHz iBooks), no success with the retail version has been officially reported on G3 Macs except for some later iMacs and "Pismo" PowerBook G3s with G4 processor upgrades installed.

For a number of months after Leopard's release it appeared that the only G3 Macs on which Leopard could be run were those with both an aftermarket G4 processor and an AGP graphics card, as failures with the OS partially booting before crashing were reported on older Macs such as the original tray-loading iMacs and the Beige and Blue & White Power Mac G3 (all with G4 upgrades as Leopard will not even begin to load without one) whereas it would boot fine on newer Macs where the Installer restriction had been circumvented. However, more recently it has been reported that with some more work and use of kernel extensions from XPostFacto, Tiger and beta builds of Leopard, the OS can be made to run on G4-upgraded Macs as old as the Power Macintosh 9500, despite the lack of AGP-based graphics. While Leopard can be run on any Mac with a G4 or later processor, some functionality such as Front Row or Time Machine fails to work without a Quartz Extreme-capable graphics card, which many of the earlier G4s did not include in their factory specification.

Since Apple moved to using Intel processors in their computers, the OSx86 community has developed and now also allows Mac OS X Tiger and later releases to be installed and run successfully on non-Apple x86-based computers, albeit in violation of Apple's licensing agreement for Mac OS X.
Packaging

The retail packaging for Leopard is significantly smaller than that of previous versions of Mac OS X (although later copies of Tiger also came in the new smaller box). It also includes a lenticular cover, making the X appear to float above a purple galaxy, somewhat resembling the default Leopard desktop wallpaper.

## Release history

**Unsupported**

Version 	Build 	Date 	OS name 	Notes 	Download

10.5 	9A581 	October 26, 2007 	Darwin 9.0 	Original retail DVD release 	N/A

10.5.1 	9B18 	November 15, 2007 	Darwin 9.1 	About the Mac OS X 10.5.1 Update; Second retail DVD release 	Mac OS X 10.5.1 Update

10.5.2 	9C31 	February 11, 2008 	Darwin 9.2 	About the Mac OS X 10.5.2 Update 	Mac OS X 10.5.2 Combo Update

9C7010

10.5.3 	9D34 	May 28, 2008 	Darwin 9.3 	About the Mac OS X 10.5.3 Update 	Mac OS X 10.5.3 Update

Mac OS X 10.5.3 Combo Update

10.5.4 	9E17 	June 30, 2008 	Darwin 9.4 	About the Mac OS X 10.5.4 update; Third retail DVD release 	Mac OS X 10.5.4 Update

Mac OS X 10.5.4 Combo Update

10.5.5 	9F33 	September 15, 2008 	Darwin 9.5 	About the Mac OS X 10.5.5 Update 	Mac OS X 10.5.5 Update

Mac OS X 10.5.5 Combo Update

10.5.6 	9G55 	December 15, 2008 	Darwin 9.6 	About the Mac OS X 10.5.6 Update 	Mac OS X 10.5.6 Update

Mac OS X 10.5.6 Combo Update

9G66 	January 6, 2009 	Fourth retail DVD release (part of Mac Box Set) 	N/A

10.5.7 	9J61 	May 12, 2009 	Darwin 9.7 	About the Mac OS X 10.5.7 Update 	Mac OS X 10.5.7 Update

Mac OS X 10.5.7 Combo Update

10.5.8 	9L30 	August 5, 2009 	Darwin 9.8 	About the Mac OS X 10.5.8 Update 	Mac OS X 10.5.8 Update

Mac OS X 10.5.8 Combo Update

## Compatibility

After Leopard’s release, there were widely reported incidents of new Leopard installs hanging during boot on the blue screen that appears just before the login process starts. Apple attributed these problems to an outdated version of an unsupported add-on extension called Application Enhancer (APE), from Unsanity which had been incompatible with Leopard. Some users were unaware that APE had been silently installed during installation of Logitech mouse drivers. However, only the users who did not have the latest version of APE installed (2.0.3 at that time) were affected. Apple published a knowledge base article on how to solve this problem.

Google announced that the Chrome browser will be dropping support for Leopard starting with Chrome 21. By that time Chrome will no longer auto-update, and new Chrome installations are not allowed. Their rationale for removal of support is that Leopard is an "OS X version also no longer being updated by Apple."

Firefox also dropped support for Leopard after it shipped Firefox 16 in October 2012. TenFourFox is a port of Firefox for the PPC architecture, released after Firefox dropped support for Leopard. 

**This article is a modified copy of the Wikipedia article of the same subject. It needs to be rewritten to be more original.**

***

## Sources

[Wikipedia - Mac OS X 10.5 (Leopard)](https://en.wikipedia.org/wiki/Mac_OS_X_10.5/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Wednesday September 22nd at 5:20 pm`

**Last revised on:** `2021 Wednesday September 22nd at 5:20 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Wednesday September 22nd at 5:20 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/WacOS/wiki/

!-->

