
***

# The BootDown project

<!-- Remove the parantheses in the title header for better readability !-->
  
![BootDownLogo.png This image failed to load. It may be due to the file not being reached, or a general error. Reload the page to fix a possible general error.](/BootDownLogo.png)

# By:

<!-- ![{Developer name} This image failed to load. It may be due to the file not being reached, or a general error. Reload the page to fix a possible general error.](/Image2.svg) !-->

## [Seanpm2001](https://github.com/seanpm2001/) / [BootDown-dev](https://github.com/BootDown-dev), Et; Al.
  
### Top

# `README.md`

***

## Read this article in a different language

_🌐 List of languages_

**Sorted by:** `A-Z`

[Sorting options unavailable](https://github.com/BootDown-dev/BootDown-dev.github.io/)

( [af Afrikaans](/.github/README_AF.md) Afrikaans | [sq Shqiptare](/.github/README_SQ.md) Albanian | [am አማርኛ](/.github/README_AM.md) Amharic | [ar عربى](/.github/README_AR.md) Arabic | [hy հայերեն](/.github/README_HY.md) Armenian | [az Azərbaycan dili](/.github/README_AZ.md) Azerbaijani | [eu Euskara](/.github/README_EU.md) Basque | [be Беларуская](/.github/README_BE.md) Belarusian | [bn বাংলা](/.github/README_BN.md) Bengali | [bs Bosanski](/.github/README_BS.md) Bosnian | [bg български](/.github/README_BG.md) Bulgarian | [ca Català](/.github/README_CA.md) Catalan | [ceb Sugbuanon](/.github/README_CEB.md) Cebuano | [ny Chichewa](/.github/README_NY.md) Chichewa | [zh-CN 简体中文](/.github/README_ZH-CN.md) Chinese (Simplified) | [zh-t 中國傳統的）](/.github/README_ZH-T.md) Chinese (Traditional) | [co Corsu](/.github/README_CO.md) Corsican | [hr Hrvatski](/.github/README_HR.md) Croatian | [cs čeština](/.github/README_CS.md) Czech | [da dansk](README_DA.md) Danish | [nl Nederlands](/.github/README_NL.md) Dutch | [**en-us English**](/.github/README.md) English |  [EO Esperanto](/.github/README_EO.md) Esperanto | [et Eestlane](/.github/README_ET.md) Estonian | [tl Pilipino](/.github/README_TL.md) Filipino | [fi Suomalainen](/.github/README_FI.md) Finnish |  [fr français](/.github/README_FR.md) French | [fy Frysk](/.github/README_FY.md) Frisian | [gl Galego](/.github/README_GL.md) Galician | [ka ქართველი](/.github/README_KA) Georgian | [de Deutsch](/.github/README_DE.md) German | [el Ελληνικά](/.github/README_EL.md) Greek | [gu ગુજરાતી](/.github/README_GU.md) Gujarati | [ht Kreyòl ayisyen](/.github/README_HT.md) Haitian Creole | [ha Hausa](/.github/README_HA.md) Hausa | [haw Ōlelo Hawaiʻi](/.github/README_HAW.md) Hawaiian | [he עִברִית](/.github/README_HE.md) Hebrew | [hi हिन्दी](/.github/README_HI.md) Hindi | [hmn Hmong](/.github/README_HMN.md) Hmong | [hu Magyar](/.github/README_HU.md) Hungarian | [is Íslenska](/.github/README_IS.md) Icelandic | [ig Igbo](/.github/README_IG.md) Igbo | [id bahasa Indonesia](/.github/README_ID.md) Icelandic | [ga Gaeilge](/.github/README_GA.md) Irish | [it Italiana/Italiano](/.github/README_IT.md) | [ja 日本語](/.github/README_JA.md) Japanese | [jw Wong jawa](/.github/README_JW.md) Javanese | [kn ಕನ್ನಡ](/.github/README_KN.md) Kannada | [kk Қазақ](/.github/README_KK.md) Kazakh | [km ខ្មែរ](/.github/README_KM.md) Khmer | [rw Kinyarwanda](/.github/README_RW.md) Kinyarwanda | [ko-south 韓國語](/.github/README_KO_SOUTH.md) Korean (South) | [ko-north 문화어](README_KO_NORTH.md) Korean (North) (NOT YET TRANSLATED) | [ku Kurdî](/.github/README_KU.md) Kurdish (Kurmanji) | [ky Кыргызча](/.github/README_KY.md) Kyrgyz | [lo ລາວ](/.github/README_LO.md) Lao | [la Latine](/.github/README_LA.md) Latin | [lt Lietuvis](/.github/README_LT.md) Lithuanian | [lb Lëtzebuergesch](/.github/README_LB.md) Luxembourgish | [mk Македонски](/.github/README_MK.md) Macedonian | [mg Malagasy](/.github/README_MG.md) Malagasy | [ms Bahasa Melayu](/.github/README_MS.md) Malay | [ml മലയാളം](/.github/README_ML.md) Malayalam | [mt Malti](/.github/README_MT.md) Maltese | [mi Maori](/.github/README_MI.md) Maori | [mr मराठी](/.github/README_MR.md) Marathi | [mn Монгол](/.github/README_MN.md) Mongolian | [my မြန်မာ](/.github/README_MY.md) Myanmar (Burmese) | [ne नेपाली](/.github/README_NE.md) Nepali | [no norsk](/.github/README_NO.md) Norwegian | [or ଓଡିଆ (ଓଡିଆ)](/.github/README_OR.md) Odia (Oriya) | [ps پښتو](/.github/README_PS.md) Pashto | [fa فارسی](/.github/README_FA.md) |Persian  [pl polski](/.github/README_PL.md) Polish | [pt português](/.github/README_PT.md) Portuguese | [pa ਪੰਜਾਬੀ](/.github/README_PA.md) Punjabi | No languages available that start with the letter Q | [ro Română](/.github/README_RO.md) Romanian | [ru русский](/.github/README_RU.md) Russian | [sm Faasamoa](/.github/README_SM.md) Samoan | [gd Gàidhlig na h-Alba](/.github/README_GD.md) Scots Gaelic | [sr Српски](/.github/README_SR.md) Serbian | [st Sesotho](/.github/README_ST.md) Sesotho | [sn Shona](/.github/README_SN.md) Shona | [sd سنڌي](/.github/README_SD.md) Sindhi | [si සිංහල](/.github/README_SI.md) Sinhala | [sk Slovák](/.github/README_SK.md) Slovak | [sl Slovenščina](/.github/README_SL.md) Slovenian | [so Soomaali](/.github/README_SO.md) Somali | [[es en español](/.github/README_ES.md) Spanish | [su Sundanis](/.github/README_SU.md) Sundanese | [sw Kiswahili](/.github/README_SW.md) Swahili | [sv Svenska](/.github/README_SV.md) Swedish | [tg Тоҷикӣ](/.github/README_TG.md) Tajik | [ta தமிழ்](/.github/README_TA.md) Tamil | [tt Татар](/.github/README_TT.md) Tatar | [te తెలుగు](/.github/README_TE.md) Telugu | [th ไทย](/.github/README_TH.md) Thai | [tr Türk](/.github/README_TR.md) Turkish | [tk Türkmenler](/.github/README_TK.md) Turkmen | [uk Український](/.github/README_UK.md) Ukrainian | [ur اردو](/.github/README_UR.md) Urdu | [ug ئۇيغۇر](/.github/README_UG.md) Uyghur | [uz O'zbek](/.github/README_UZ.md) Uzbek | [vi Tiếng Việt](/.github/README_VI.md) Vietnamese | [cy Cymraeg](/.github/README_CY.md) Welsh | [xh isiXhosa](/.github/README_XH.md) Xhosa | [yi יידיש](/.github/README_YI.md) Yiddish | [yo Yoruba](/.github/README_YO.md) Yoruba | [zu Zulu](/.github/README_ZU.md) Zulu ) Available in 110 languages (108 when not counting English and North Korean, as North Korean has not been translated yet [Read about it here](/OldVersions/Korean(North)/README.md))

Translations in languages other than English are machine translated and are not yet accurate. No errors have been fixed yet as of March 21st 2021. Please report translation errors [here](https://github.com/seanpm2001/BootDown/issues/). Make sure to backup your correction with sources and guide me, as I don't know languages other than English well (I plan on getting a translator eventually) please cite [wiktionary](https://en.wiktionary.org) and other sources in your report. Failing to do so will result in a rejection of the correction being published.

Note: due to limitations with GitHub's interpretation of markdown (and pretty much every other web-based interpretation of markdown) clicking these links will redirect you to a separate file on a separate page that isn't the intended page. You will be redirected to the [.github folder](/.github/) of this project, where the README translations are hosted.

Translations are currently done with Bing translate and DeepL. Support for Google Translate translations is coming to a close due to privacy concerns.

***

# Index

[00.0 - Top](#Top)

> [00.1 - Title](#The-BootDown-project)

> [00.2 - Read this article in a different language](#Read-this-article-in-a-different-language)

> [00.3 - Index](#Index)

[01.0 - Description](#BootDown)

[02.0 - About](#About)

[03.0 - How it works](#How-it-works)

[04.0 - Known limitations](#Known-limitations)

> [04.1 - Total memory limitations](#Total-memory-limitations)

> [04.2 - Lack of multi-lingual support](#Lack-of-multi-lingual-support)

> [04.3 - No Internet support](#No-Internet-support)

> [04.4 - Feature limitations](#Feature-limitations)

> [04.5 - Application support limitation](#Application-support-limitation)

> [04.6 - Other limitations](#Other-limitations)

[05.0 - Architectures](#Architectures)

[06.0 - Concept](#Concept)

> [06.1 - From 2021 September 19th](#From-2021-September-19th)

> > [06.1.1 - About BootDown](#About-BootDown)

> > [06.1.2 - Limitations](#Limitations)

> > [06.1.3 - Naming](#Naming)

> > [06.1.4 - Language](#Language)

> > [06.1.5 - Logo](#Logo)

[07.0 - Software support](#Software-support)

> [07.1 - UEFI Doom](#UEFI-Doom)

> [07.2 - Game Boy emulator (VerilogBoy)](#Game-Boy-emulator-(VerilogBoy))

> [07.3 - Screeen Pong](#Screeen-Pong)

> [07.4 - Grub2 file manager](#Grub2-file-manager)

> [07.5 - BIOS Utilities](#BIOS-Utilities)

[08.0 - Sample programs](#Sample-programs)

[09.0 - History](#History)
  
> [09.1 - Pre-history](#Pre-history)

> [09.2 - Alpha History](#Alpha-history)

> [09.3 - Beta History](#Beta-history)

> [09.4 - Modern History](#Modern-history)

[10.0 - Wiki](#Wiki)

[11.0 - Copying](#Copying)

[12.0 - Credits](#Credits)

[13.0 - Authors](#Authors)

[14.0 - Installation](#Installation)

[15.0 - 404 page](#404-page)

[16.0 - Version history](#Version-history)

[17.0 - Software status](#Software-status)

[18.0 - Sponsor info](#Sponsor-info)

[19.0 - Contributers](#Contributers)

[20.0 - Issues](#Issues)

> [20.1 - Current issues](#Current-issues)

> [20.2 - Past issues](#Past-issues)

> [20.3 - Past pull requests](#Past-pull-requests)

> [20.4 - Active pull requests](#Active-pull-requests)

[21.0 - Resources](#Resources)

[22.0 - Contributing](#Contributing)

[23.0 - About README](#About-README)

[24.0 - README Version history](#README-version-history)

[25.0 - Technical notes](#Technical-notes)

[26.0 - Footer](#You-have-reached-the-end-of-the-README-file)

> [26.9 - End of file](#EOF)

***

# BootDown
An experimental operating system project that runs at the BIOs level, but can be a functional operating system.

***

## About

See above. Also see below for more info.

***

## How it works

BootDown is an extension to a bootloader, but it can also be its own bootloader. It is compatible with GRUB2 as a bootloader extension.

BootDown works at the BIOs level, and the system is accessible within a few seconds of pressing the power button (on Solid State Drives) and can be considered a pre-operating system. You are booting down, not booting up.

Due to the simplicity of this boot stage, there are limitations to how BootDown works.

## Known limitations

Here are the known limitations to BootDown, as of Tuesday, 2021 September 21st at 2:06 pm.

### Total memory limitations

BootDown is a Bootloader extension at a very low boot level, thus it can only access 65,536 bytes of storage for its own usage. Other usage must be read from an existing partition.

### Lack of multi-lingual support

This limit prevents BootDown from doing things like having lots of features, one notable loss is the lack of multi-lingual support. You can only have 1 language at a time. You will have to choose the English version if you speak English, but will need to do a separate installation if you want to choose Esperanto, Spanish, German, etc. I don't even know if Chinese language support is possible with the given constraints, due to the Chinese language being so large and complex (over half of the UTF-16 block is just Chinese radicals

### No Internet support

BootDown isn't a traditional operating system, and is being done at the pre-boot stage. This means it can't access API calls or functions needed to connect to the Internet or run a web browser. Bluetooth isn't available either.

### Feature limitations

Features will be split across multiple variants. For example, there will be CLI version A that has a command line plus some features, CLI version B which is the same, but with some other features, GUI version A, which contains a Graphical User Interface and some features, and GUI version B, which is the same, but with some other features, etc.

### Application support limitation

Application support is only available for programs written in x86 Assembly, VHDL, Verilog, or SystemVerilog. C and C++ programs may be possible, but programs written in Python, Java, C#, Go, Kotlin, and many other languages are not supported.

### Other limitations

This is still an experimental project, limitations are still being found.

## Architectures

BootDown is planned to work on most modern hardware platforms, and also most legacy platforms. These include:

* FPGA (Field-Programmable Gate Array)

* R-PI (Raspberry Pi)

It also is planned to work with:

* BIOs (Basic Input Output system)

* UEFI (Unified Extensible Firmware Interface)

More architectures will be supported in the future.

***

## Concept

### From 2021 September 19th

#### About BootDown

BootDown is an experimental operating system project that runs at the BIOs level, but can be a functional CLI or GUI operating system that can read and write files, access hard drives, and so on, before booting into the main operating system.

#### Limitations

Severe limitations will be in place, such as a low file size limit, possibly pushing to partitions, and so on. I will need to research this concept more, this is an experimental project. Also, due to size reasons, multi-lingual support will be unavailable once you install. Each installation will only support 1 language.

Also, due to how basic the project is, don't expect to be able to do things like run a web browser, or using LibreOffice, but expect things like running Pong, Doom, or other games ported to Assembly, VHDL, Verilog, or SystemVerilog.

#### Naming

The project was originally called BL/S or BL/Ss (which stood for BootLoader System or BootLoader Subsystem) but the name was changed to BootDown, as the project is more than just a bootloader. BootDown is in reference to booting down to a lower level system, rather than booting up to a higher level system.

#### Language

This project is written in 4 different programming languages:

- [x] Assembly

- [x] VHDL (Virtual Hard Disk Language)

- [x] Verilog

- [x] SystemVerilog

It is supplemented by 3 basic computer languages as well:

- [x] GNU Makefile

- [x] Markdown

- [x] Plain text

Multi-lingual support is currently unavailable, but the project is available in English. To install in a different language, you would have to download a different installation image in your preferred language, as this system is so small that it can only support 1 language at a time.

Currently, the project has been written for the following languages:

- [x] English (US)

#### Logo

The boot from the scuba diver from the SpongeBob SquarePants movie (2004) seemed to fit this project well. I used a low resolution image, but this may not stay, as I want an original logo. I want something that resembles a dark and murky boot.

***

## Software support

Here is the featured software that can work directly off the hardware, without an operating system. Most of these don't require BootDown to be installed, but are planned to pair with it.

### UEFI Doom

**From the BootDown organization:** [https://github.com/BootDown-dev/uefidoom](https://github.com/BootDown-dev/uefidoom)

**From the source repository:** [https://github.com/Cacodemon345/uefidoom](https://github.com/Cacodemon345/uefidoom)

### Game Boy emulator (VerilogBoy)

**From the BootDown organization:** [https://github.com/BootDown-dev/VerilogBoy](https://github.com/BootDown-dev/VerilogBoy)

**From the source repository:** [https://github.com/zephray/VerilogBoy](https://github.com/zephray/VerilogBoy)

### Screeen Pong

**From the BootDown organization:** [https://github.com/BootDown-dev/screen-pong](https://github.com/BootDown-dev/screen-pong)

**From the source repository:** [https://github.com/juanmard/screen-pong](https://github.com/juanmard/screen-pong)

### Grub2 file manager

**From the BootDown organization:** [https://github.com/BootDown-dev/grub2-filemanager](https://github.com/BootDown-dev/grub2-filemanager)

**From the source repository:** [https://github.com/a1ive/grub2-filemanager](https://github.com/a1ive/grub2-filemanager)

### BIOS Utilities

**From the BootDown organization:** [https://github.com/BootDown-dev/BIOSUtilities](https://github.com/BootDown-dev/BIOSUtilities)

**From the source repository:** [https://github.com/platomav/BIOSUtilities](https://github.com/platomav/BIOSUtilities)

***

## Sample programs

The `///0/` directory has some sample programs and documentation for the BootDown system. Currently, there is a `README.txt` file, and 2 sample programs, 1 is currently not functional.

A Hello World program is available, which is written in Assembly. It is named `HELLOWLD.asm` due to limitations, such as the 8:3 file system.

A modified version of the Hello World program with a Roman Empire joke is included, which is named `CAESAR.asm` but isn't functional yet. Instead of outputting Hello World, it outputs `Et tu, boot?` which is supposed to translate to `You too, bootis?` from Latin. The first 2 words are proper latin, but I am not sure if `boot` would translate to `bootis` this program is not functional, as it has a line with the following data:

```assembly
    stab 23 ; Caesar was stabbed 23 times, although this may not be valid syntax
```

which may not be valid syntax.

***
  
## History

This project has a short history so far.

### Pre-history

This project was started on 2021 Sunday September 19th as a concept project that was thought of the same day as its creation. The other concept from this day was the [ScreenTeX project](https://github.com/ScreenTeX/) the concept was partially written down in a private repository, but was made public on 2021 Monday September 20th after I created [the organization for this project](https://github.com/BootDown-dev/). The project was worked on extensively today, and the concept was further implanted. It still isn't functional yet.

### Alpha history

On 2021 Tuesday September 21st, this projects `README.md` file was updated, and it received its own website.

### Beta history

No Beta history to show for this project.

### Modern history

No Modern history to show for this project.

***

## Wiki

[Click/tap here to view this projects Wiki](https://github.com/BootDown-dev/BootDown/wiki/)

If the project has been forked, the Wiki was likely removed. Luckily, I include an embedded version. You can view it [here](/External/ProjectWiki/).

***

## Copying

View the copying license for this project [here](/COPYING) (if you haven't built the project yet with the makefile, here is the original link: [COPYINGL](/COPYINGL)

Please note that you also have to follow the rules of the GNU General Public License v3 (GPL3) which you can view [here](/LICENSE.txt)

***

## Credits

View the credits file for this project and see the people who got together to make this project by [clicking/tapping here](/CREDITS)

***

## Authors

View the authors file for this project and see the authors of this project by [clicking/tapping here](/AUTHORS)

***

## Installation

View the installation instructions file for this project [here](/INSTALL)

Requirements: Jekyll, GitHub emulator (may not exist yet)

***

## 404 page

Test the 404 page for this project by [clicking/tapping here](/Site/404/THIS-WILL-NEVER-WORK/ABJAB/DXV48/22846/FILE.xabcdfgxlma329)

Getting a different 404 page? View the 404 page directly by [clicking/tapping here](/404.htm;)

***

## Sponsor info

![SponsorButton.png](/SponsorButton.png)

You can sponsor this project if you like, but please specify what you want to donate to. [See the funds you can donate to here](https://github.com/seanpm2001/Sponsor-info/tree/main/For-sponsors/)

You can view other sponsor info [here](https://github.com/seanpm2001/Sponsor-info/)

Try it out! The sponsor button is right up next to the watch/unwatch button.

***

## Version history

**Version history currently unavailable**

**No other versions listed**

***

## Software status

All of my works are free some restrictions. DRM (**D**igital **R**estrictions **M**anagement) is not present in any of my works.

![DRM-free_label.en.svg](/DRM-free_label.en.svg)

This sticker is supported by the Free Software Foundation. I never intend to include DRM in my works.

I am ussing the abbreviation "Digital Restrictions Management" instead of the more known "Digital Rights Management" as the common way of addressing it is false, there are no rights with DRM. The spelling "Digital Restrictions Management" is more accurate, and is supported by [Richard M. Stallman (RMS)](https://en.wikipedia.org/wiki/Richard_Stallman/) and the [Free Software Foundation (FSF)](https://en.wikipedia.org/wiki/Free_Software_Foundation/)

This section is used to raise awareness for the problems with DRM, and also to protest it. DRM is defective by design and is a major threat to all computer users and software freedom.

Image credit: [defectivebydesign.org/drm-free/...](https://www.defectivebydesign.org/drm-free/how-to-use-label/)

***

## Contributers

Currently, I am the only contributer. Contributing is allowed, as long as you follow the rules of the [CONTRIBUTING.md](/CONTRIBUTING.md) file.

> * 1. [seanpm2001](https://github.com/seanpm2001/) - 46 commits (As of 2021, Tuesday September 21st at 2:40 pm)

> * 2. No other contributers.

***

## Issues

### Current issues

* None at the moment

* No other current issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past issues

* None at the moment

* No other past issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past pull requests

* None at the moment

* No other past pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Active pull requests

* None at the moment

* No other active pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

***

## Resources

Here are some other resources for this project:

[Project language file A](/PROJECT_LANG_1.htm)

[Project language file AA](/PROJECT_LANG_1.asm)

[Project language file AB](/PROJECT_LANG_2.vhdl)

[Project language file AC](/PROJECT_LANG_1.v)

[Project language file AD](/PROJECT_LANG_1.sv)

[View the editor configuration file for this project](/.editorconfig)

[View the linguist attributes file for this project](/.gitattributes)

[View the Git Ignore file for this project](/.gitignore)

[View the organization for this project](https://github.com/BootDown-dev/)

[Build/view the makefile for this project](/makefile.mk)

[Join the discussion on GitHub](https://github.com/BootDown-dev/BootDown/discussions/)

[View the issues/Raise an issue for this project](https://github.com/BootDown-dev/BootDown/issues/)

No other resources at the moment.

***

## Contributing

Contributing is allowed for this project, as long as you follow the rules of the `CONTRIBUTING.md` file.

[Click/tap here to view the contributing rules for this project](/CONTRIBUTING.md)

***

## About README

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**File version:** `1 (Tuesday, 2021 September 21st at 2:40 pm)`

**Line count:** `0,788`

***

## README version history

Version 0.1 (Sunday, March 21st 2021 at 7:50 pm)

> Changes:

> * Started the file

> * Added the title section

> * Added the index

> * Added the about section

> * Added the Wiki section

> * Added the version history section

> * Added the issues section.

> * Added the past issues section

> * Added the past pull requests section

> * Added the active pull requests section

> * Added the contributors section

> * Added the contributing section

> * Added the about README section

> * Added the README version history section

> * Added the resources section

> * Added a software status section, with a DRM free sticker and message

> * Added the sponsor info section

> * No other changes in version 0.1

Version 0.11 (Friday, July 16th 2021 at 9:20 pm)

> Changes:

> * Updated several sections with corrected template syntax

> * Added the history section

> * Updated the language list switcher section

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11

Version 0.11B (Friday, July 16th 2021 at 9:25 pm)

> Changes:
  
> * Fixed the footer, removed bad link (ddg.com does not redirect to duckduckgo)
  
> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11B

Version 0.12A (Thursday, July 22nd 2021 at 6:26 pm)

> Changes:
  
> * The typo `SNU Erotica` was removed entirely

> * Added a better name than file.svg

> * Fixed the title section
  
> * Fixed the index
  
> > * Added the history section

> * Minor formatting fixes

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11B

Version 0.13 (2021, Saturday August 21st 2021 at 5:02 pm)

> Changes:
  
> * Times are now compliant with ISO:8601 and use YYYY-MM-DD rather than MM-DD-YYYY

> * Updated the title section

> * Fixed and update template links

> * Updated the index

> * Added the copying section

> * Added the credits section

> * Added the installation section

> * Added the 404 page test section

> * Updated the resources section

> * Updated the contributors section

> * Added the technical notes section

> * Updated the footer

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 6 (0.13)

Version 0.14 (2021, Tuesday August 24th 2021 at 9:31 pm)

> Changes:
  
> * Times are now compliant with ISO:8601 and use YYYY-MM-DD rather than MM-DD-YYYY

> * Updated the index

> * Added the authors section

> * Updated the footer, adding support for the Swisscows search engine as a 4th option

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 6 (0.13)

Version 1 (2021, Tuesday September 21st at 2:40 pm)

> Changes:

> * Updated the file

> * Updated the title section

> * Updated the index

> * Updated the repo info section

> * Updated the about section

> * Added the How it works section

> * Added the Known limitations section

> > * Added the Total memory limitations subsection

> > * Added the Lack of multi-lingual support subsection

> > * Added the No Internet support subsection

> > * Added the Feature limitations subsection

> > * Added the Application support limitation subsection

> > * Added the Other limitations subsection

> * Added the Architectures section

> * Added the Concept section

> > * Added the From 2021 September 19th subsection

> > * Added the About BootDown subsection

> > * Added the Limitations subsection

> > * Added the Naming subsection

> > * Added the Language subsection

> > * Added the Logo subsection

> * Added the Software support section

> > * Added the UEFI Doom subsection

> > * Added the Game Boy emulator (VerilogBoy) subsection

> > * Added the Screeen Pong subsection

> > * Added the Grub2 file manager subsection

> > * Added the BIOS Utilities subsection

> * Added the Sample programs section

> * Updated the history section

> * Updated the contributors setion

> * Updated the resources section

> * Updated the footer, adding support for the Safe.DuckDuckGo search engine option

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 1

Version 2 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 2

***

## Technical notes

**All times are UTC-7 (PDT/Pacific Time)**

**The encoding is UTF-8 and is compatible with Unicode 5.0 and up**

***

## You have reached the end of the README file

( [Back to top](#Top) | [Exit to GitHub](https://github.com) | [Exit to Bing](https://www.bing.com/) | [Exit to DuckDuckGo](https://duckduckgo.com/) |[Exit to Safe.DuckDuckGo](https://safe.duckduckgo.com/) | [Exit to Ecosia](https://www.ecosia.org/) | [Exit to Swisscows](https://www.swisscows.com/) )

### EOF

***

