
***

# WacOS:Wiki - Rule list

This is the rule list for collaborating on this Wiki once I have some moderation set up. There are some basic rules for editing here. You must follow all of them, or your right to edit the Wiki will be temporarily or permanently disabled.

Until the rules are considered `good`, no editing is allowed.

The rules are currently considered: `low level, not ready`

## General

Each page on the Wiki is considered an article.

Credible sources have not yet been defined.

Please always follow the latest version of the rule list (only the revisions written by @seanpm2001)

Nobody but the repository owner can modify the rule list (unless @seanpm2001 directly gives you permission) Anyone else caught doing this gets a permanent editing permissions suspension.

## Vandalism

Vandalism is not allowed. Replacing articles with white space, posting unrelated or inappropriate link replacements, posting malware/spyware/ransomware in the source code boxes, and lots of other things are considered vandalism. Don't try to bypass these rules, and remember: [don't shove beans up your nose](https://en.wikipedia.org/wiki/Wikipedia:Don%27t_stuff_beans_up_your_nose)

## Misleading info

Misleading info cannot be added to any articles. Make sure your source is backed up with a credible source, or that your opinion is obviously your opinion.

## Image path

Images used in the articles must first be uploaded to `///Graphics/` with a folder name of the subject of the image (eg: `///Graphics/iOS/` the blob link to the file must be included on the Wiki page. This is to ensure that the Wiki will still remain functional if something were to happen to GitHub or the image links.

## Archival

Each revision to a Wiki page is archived under `///External/ProjectWiki/` with the article name being the archive folder, a `1` and `1-100` folder going after, then another folder with the archive folder name. Below that on the original archive folder page, a README is there to output the current version of the article.

I want other people to help do this as well, as it archives the state of the Wiki, as I can't export it any other way, and it is good for showing the history.

[Learn more about the SVCS version control system](https://github.com/Snapshot-Version-Control-System/)

## Credible sources

I allow for credible sources to be linked to. Non-credible sources can still be linked to if they provide a point of view, but depending on their accusation or statement, they may not be used in the article. By default, non-credible sources are not linked to directly, and are in a separate sources section.

Wikipedia is being used as a source for now until I can get better sources. Wikipedia should NOT be the primary source for an article, there needs to be backup sources for each claim in a Wikipedia-inspired edit.  

## Collaborators

Once you become a collaborator on this project, you get access to the Wiki. I am working on changing this to trusted collaborators only. If you were added, you can still edit the Wiki, as long as you follow the rules on this rule list.

## Current moderation

Currently, I have no Wiki moderation software for GitHub. The current state it is in is that nobody can edit, except for me, and any other collaborators added to the project. I do not want to use software for it, as I feel when the software goes down, all hell breaks loose. I still also want to have collaborators on the project, but the Wiki is now a setback.

***

## Article info

**Article type:** `Wiki rule list`

**Article format:** `Markdown document (*.md)`

**First revision info:** `1 (Sunday, September 19th at 7:37 pm)`

**Current revision info:** `1 (Sunday, September 19th at 7:37 pm)`

**Article language:** `English (US) / Markdown`

**Line count (including blank lines and compiler line):** `73`

***

