
***

# Fair use info

Legal notice: This is not a license, but it is a policy reminder in different terms. Info on this page should be similar to or exactly as described in the [GNU General Public License V3](/LICENSE.txt) which is in this project already.

## General

Fair use is a legal doctrine that promotes freedom of expression by permitting the unlicensed use of copyright-protected works in certain circumstances. Section 107 of the Copyright Act provides the statutory framework for determining whether something is a fair use and identifies certain types of uses—such as criticism, comment, news reporting, teaching, scholarship, and research—as examples of activities that may qualify as fair use.  Section 107 calls for consideration of the following four factors in evaluating a question of fair use:

1. Purpose and character of the use, including whether the use is of a commercial nature or is for nonprofit educational purposes:  Courts look at how the party claiming fair use is using the copyrighted work, and are more likely to find that nonprofit educational and noncommercial uses are fair.  This does not mean, however, that all nonprofit education and noncommercial uses are fair and all commercial uses are not fair; instead, courts will balance the purpose and character of the use against the other factors below.  Additionally, “transformative” uses are more likely to be considered fair.  Transformative uses are those that add something new, with a further purpose or different character, and do not substitute for the original use of the work.

2. Nature of the copyrighted work:  This factor analyzes the degree to which the work that was used relates to copyright’s purpose of encouraging creative expression. Thus, using a more creative or imaginative work (such as a novel, movie, or song) is less likely to support a claim of a fair use than using a factual work (such as a technical article or news item). In addition, use of an unpublished work is less likely to be considered fair.

3. Amount and substantiality of the portion used in relation to the copyrighted work as a whole:  Under this factor, courts look at both the quantity and quality of the copyrighted material that was used. If the use includes a large portion of the copyrighted work, fair use is less likely to be found; if the use employs only a small amount of copyrighted material, fair use is more likely. That said, some courts have found use of an entire work to be fair under certain circumstances. And in other contexts, using even a small amount of a copyrighted work was determined not to be fair because the selection was an important part—or the “heart”—of the work.

4. Effect of the use upon the potential market for or value of the copyrighted work:  Here, courts review whether, and to what extent, the unlicensed use harms the existing or future market for the copyright owner’s original work. In assessing this factor, courts consider whether the use is hurting the current market for the original work (for example, by displacing sales of the original) and/or whether the use could cause substantial harm if it were to become widespread.

In addition to the above, other factors may also be considered by a court in weighing a fair use question, depending upon the circumstances. Courts evaluate fair use claims on a case-by-case basis, and the outcome of any given case depends on a fact-specific inquiry. This means that there is no formula to ensure that a predetermined percentage or amount of a work—or specific number of words, lines, pages, copies—may be used without permission.  

Please note that the Copyright Office is unable to provide specific legal advice to individual members of the public about questions of fair use.  See 37 C.F.R. 201.2(a)(3).  

[Source: Copyright.gov (https://www.copyright.gov/fair-use/more-info.html)](https://www.copyright.gov/fair-use/more-info.html)

## For images derived from Wikipedia

It is believed that the use of low-resolution images of book covers and other non-freemedia

* to illustrate an article discussing the book or other media in question

* on the English-language Wikipedia, hosted on servers in the United States by the non-profit Wikimedia Foundation,

qualifies as fair use under the copyright law of the United States. Other use of this image, on Wikipedia or elsewhere, might be copyright infringement.

## Wikimedia

### Notes

**This section was copied from [EN:WIKIPEDIA:WIKI:WIKIPEDIA:NON-FREE_CONTENT](https://en.wikipedia.org/wiki/Wikipedia:Non-free_content) to give a general description of fair use enforcement. It is a placeholder for now to explain how fair use policy works. It should be replaced when an effective alternative is available, or it may be kept. Wikimedia follows a very similar Fair Use policy that I also use. This should be covered by the GPL3 as well, but it is here for reference anyways**

**This section was heavily modified to better comply with very basic Markdown semantics. The formatting here is different than that of the Wikipedia equivalent, but the information is completely unmodified.**

Transcluded from Wikipedia:Non-free content criteria; this is the part of the current page that is official policy

As per the Wikimedia Foundation Licensing policy resolution of March 23, 2007, this document serves as the Exemption Doctrine Policy for the English Wikipedia.

### Rationale

1. To support Wikipedia's mission to produce perpetually free content for unlimited distribution, modification and application by all users in all media.

2. To minimize legal exposure by limiting the amount of non-free content, using more narrowly defined criteria than apply under the fair use provisions in United States copyright law.

3. To facilitate the judicious use of non-free content to support the development of a high-quality encyclopedia.

### Policy

There is no automatic entitlement to use non-free content in an article or elsewhere on Wikipedia. Articles and other Wikipedia pages may, in accordance with the guideline, use brief verbatim textual excerpts from copyrighted media, properly attributed or cited to its original source or author (as described by the citation guideline), and specifically indicated as direct quotations via quotation marks, `<blockquote>`, `{{Quote}}`, or a similar method. Other non-free content—including all copyrighted images, audio and video clips, and other media files that lack a free content license—may be used on the English Wikipedia only where all 10 of the following criteria are met.

1. No free equivalent. Non-free content is used only where no free equivalent is available, or could be created, that would serve the same encyclopedic purpose.

2. Respect for commercial opportunities. Non-free content is not used in a manner that is likely to replace the original market role of the original copyrighted material.

### Minimal usage:

1. Minimal number of items. Multiple items of non-free content are not used if one item can convey equivalent significant information.

2. Minimal extent of use. An entire work is not used if a portion will suffice. Low-resolution, rather than high-resolution/fidelity/bit rate is used (especially where the original could be used for deliberate copyright infringement). This rule also applies to the copy in the File: namespace.

3. Previous publication. Non-free content must be a work which has been published or publicly displayed outside Wikipedia by (or with permission from) the copyright holder, or a derivative of such a work created by a Wikipedia editor.

4. Content. Non-free content meets general Wikipedia content standards and is encyclopedic.

5. Media-specific policy. Non-free content meets Wikipedia's media-specific policy. For example, images must meet Wikipedia:Image use policy.

6. One-article minimum. Non-free content is used in at least one article.

7. Contextual significance. Non-free content is used only if its presence would significantly increase readers' understanding of the article topic, and its omission would be detrimental to that understanding.

8. Restrictions on location. Non-free content is allowed only in articles (not disambiguation pages), and only in the article namespace, subject to exemptions. (To prevent an image category from displaying thumbnails, add __NOGALLERY__ to it; images are linked, not inlined, from talk pages when they are a topic of discussion.)
9. Image description page. The image or media description page contains the following:

9. 1. Identification of the source of the original copyrighted material, supplemented, where possible, with information about the artist, publisher and copyright holder, and year of copyright; this is to help determine the material's potential market value. See: Wikipedia:Citing sources § Multimedia.

9. 2. A copyright tag that indicates which Wikipedia policy provision is claimed to permit the use. For a list of image copyright tags, see Wikipedia:Image copyright tags/Non-free content.

9. 3. The name of each article (a link to each article is also recommended) in which fair use is claimed for the item, and a separate, specific non-free use rationale for each use of the item, as explained at Wikipedia:Non-free use rationale guideline.[2] The rationale is presented in clear, plain language and is relevant to each use.

### Enforcement

1. A file with a valid non-free-use rationale for some (but not all) articles it is used in will not be deleted. Instead, the file should be removed from the articles for which it lacks a non-free-use rationale, or a suitable rationale added.

2. A file on which non-free use is claimed that is not used in any article (criterion 7) may be deleted seven days after notification.

3. A file in use in an article and uploaded after 13 July 2006 that does not comply with this policy 48 hours after notification to the uploading editor will be deleted. To avoid deletion, the uploading editor or another Wikipedian will need to provide a convincing non-free-use defense that satisfies all 10 criteria. For a file in use in an article that was uploaded before 13 July 2006, the 48-hour period is extended to seven days.

Note that it is the duty of users seeking to include or retain content to provide a valid rationale; those seeking to remove or delete it are not required to show that one cannot be created—see burden of proof.

Deletion criteria for non-free content are specified in Wikipedia:Criteria for speedy deletion § Files. 

***

## File version

**File type:** `Markdown document (.md)`

**File version:** `1 (Friday, 2021 September 17th at 9:04 pm)`

**Line count (including blank lines and compiler line):** `112`

***

