  
***

# iOS 6

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the iOS 6 logo</p></summary>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_logo_(2).png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_logo_(2).png)

</details>

![https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_Home_Screen.png](https://github.com/seanpm2001/WacOS/blob/master/Graphics/iOS/IOS_6_Home_Screen.png)

iOS 6 is a mobile operating system created by Apple Inc and was released on 2012 September 19th. It is the 6th major release of iOS.

One of the most notable changes is the 6th (or 5th) row of apps, that was what the ordinary user saw. The actual, significant changes are listed below.

This was the last version of iOS to feature a skeuomorphic interface. Starting with iOS 7, the interface switched to flat design.

## Feature changes

This is from Wikipedia: [IOS 6 On Wikipedia (ENGLISH)](https://en.wikipedia.org/wiki/IOS_6#App_features) and [System features](https://en.wikipedia.org/wiki/IOS_6#System_features)

### Siri

Apple's Siri intelligent personal assistant, introduced in iOS 5 with the release of the iPhone 4S, was updated to include the ability to make restaurant reservations, launch apps, read items from Notification Center, dictate Facebook and Twitter updates, retrieve movie reviews, detailed sports statistics, and more.

Siri received language support for Italian, Korean, and Cantonese, and device support for iPhone 5, fifth-generation iPod Touch, and third-generation iPad.

In iOS 6.1, Siri was integrated with Fandango, allowing users to buy film tickets by voice. The feature was only available in the United States at launch.

### Facebook integration

Facebook came integrated in several of Apple's native apps with iOS 6. Facebook features could be directly accessed from within native apps such as Calendar, which could synchronize Facebook events; Contacts, which could show Facebook friend information; and the App Store and Game Center, which featured Facebook's like button; as well as through a widget in the Notification Center, which allowed users to post status updates to the social network.

### Settings

The Settings app received multiple changes in iOS 6. The icon was revised to match the System Preferences icon used in the then-named OS X computer operating system developed by Apple; and a "Do Not Disturb" mode was added, which allows users to disable phone sounds. Additional options for Do Not Disturb mode include being able to allow phone calls from a specific group of contacts, and allowing sound on the second call if someone calls repeatedly. A crescent moon icon will appear in the status bar when Do Not Disturb mode is enabled.

New privacy settings became available to users. In addition to "Location Services", the following menus were added in iOS 6: "Contacts", "Calendars", "Reminders", and "Photos". The updated privacy menus allow users more fine-grained privacy permission controls for each app, with new notifications when apps want access to information in each of the categories.

iOS 6 also came with a "Limit ad tracking" user control setting to allow users the option to prevent targeted advertising. Apple's "Advertising Identifier" was described by Apple as "a nonpermanent, nonpersonal, device identifier, that advertising networks will use to give you more control over advertisers' ability to use tracking methods. If you choose to limit ad tracking, advertising networks using the Advertising Identifier may no longer gather information to serve you targeted ads."

In iOS 6.1, a "Reset Advertising Identifier" setting was added to allow users to reset the identifier used by advertising companies.

### Other

iOS 6 added a Twitter widget in the Notification Center, where users could tweet without going into the app. This saved resources.

The Share Sheet interface was updated to display a grid of icons, as opposed to a list, of different apps to which users could share content.

### Maps

A new Apple Maps app replaced Google Maps as the default mapping app on the operating system. Apple Maps used Apple's vector-based engine, making for smoother zooming. New to Maps was turn-by-turn navigation with spoken directions and 3D views in certain countries, "Flyover" views in some major cities, and real-time traffic.

At launch, turn-by-turn navigation was only available for iPhone 4S and later, and iPad 2 (cellular capability required) and later, while "Flyover" view was only available for iPhone 4S and later, fifth-generation iPod Touch, and iPad 2 and later.

### Passbook

A new Passbook app was added, to retrieve documents such as boarding passes, admission tickets, coupons and loyalty cards.

An iOS device with Passbook can replace a physical card when scanned to process a mobile payment at participating locations. The app has context-aware features such as notifications for relevant coupons when in the immediate vicinity of a given store, and automatic visibility of boarding passes when the user is at an airport, with notifications for gate changes.

### Photos and Camera

The Camera app was updated to include a new Panorama mode that allowed users to take 240-degree panoramic photos.

The Photos app received updates to the Photo Stream functionality, letting users remove images, as well as share custom Photo Streams with other people or the public.

### App Store

The App Store on iOS 6 had a brand new user interface that removed the "Categories" tab and replaced it with "Genius", Apple's search and recommendation engine. It also made use of cards rather than lists to present apps. There were also tweaks to the App Store's search algorithm, resulting in a "trend to favor newer companies", which sparked both developer concerns and praise.

The App Store also updated apps without requiring the iTunes password, and when installing or updating an app, users were no longer automatically returned to the home screen.

### Phone

Upon receiving calls, iOS 6 enabled users to swipe up the lock screen to reveal "Reply with message" or "Remind me later". The "Reply with message" feature shows several pre-determined messages with an option for a custom message, while the "Remind me later" feature offers several options (such as an hour later, when the user gets home, or when the user leaves the current location) to enable a reminder.

### Podcasts

Podcast functionality was separated from the iTunes app and received its own Podcasts app in iOS 6, in order to "centralize and promote podcast listening and downloading for users".

### Safari

The Safari web browser was updated with a full-screen landscape view for iPhone and iPod Touch users.

Reading List, a feature introduced in iOS 5, received offline support, in which text, images, and layout from saved articles get stored on the user's device.

### FaceTime

FaceTime video calling was updated to work over a cellular connection, in addition to Wi-Fi.

### Clock

The Clock app, which had been on iPhone and iPod Touch since their original release, became available on iPad.[45] The clock design looked similar to a Swiss railway clock, and Apple formed an agreement with the Swiss Federal Railways to license the design for its own use.[46]

***

## Specifications

**Developer**	_Apple Inc._

**Source model**	_Closed, with open source components_

**Initial release**	_September 19, 2012; 8 years ago_

**Latest release**	_6.1.6 (10B500) / February 21, 2014; 7 years ago_

**Platforms**

**iPhone**

iPhone 3GS

iPhone 4

iPhone 4S

iPhone 5

**iPod Touch**

iPod Touch (4th generation)

iPod Touch (5th generation)

**iPad**

iPad 2

iPad (3rd generation)

iPad (4th generation)

iPad Mini (1st generation)

**Kernel type**	Hybrid (XNU)

**License:**	Proprietary (EULA except for open-source components)

**Preceded by**	iOS 5

**Succeeded by**	iOS 7

**Support status**

_No longer getting security updates, but still partial 3rd party app support. Drops support for the iPod Touch (3rd generation), and iPad (1st generation)_

This section was modified from [Wikipedia](https://en.wikipedia.org/wiki/IOS_6)

***

## Community images

I have a community image repository for iOS 6 images. You can view it [by clicking/tapping here](https://github.com/seanpm2001/SeansLifeArchive_Images_iOS_6).

This article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Sources

[Wikipedia](https://en.wikipedia.org/wiki/IOS_6/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Wednesday September 15th at 9:28 pm`

**Last revised on:** `2021 Wednesday September 15th at 9:28 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Article version:** `1 (2021 Wednesday September 15th at 9:28 pm)`

***

