
***

# The SNU-DennisRitchieMemorial project

<!-- Remove the parantheses in the title header for better readability !-->
  
![Dennis_Ritchie_2011.jpg This image failed to load. It may be due to the file not being reached, or a general error. Reload the page to fix a possible general error.](/Dennis_Ritchie_2011.jpg)

# By:

<!-- ![{Developer name} This image failed to load. It may be due to the file not being reached, or a general error. Reload the page to fix a possible general error.](/Image2.svg) !-->

## [Seanpm2001](https://github.com/seanpm2001/) / [SNU-DennisRitchieMemorial](https://github.com/SNU-DennisRitchieMemorial), [SNU-Development](https://github.com/snu-development/), Et; Al.
  
### Top

# `README.md`

***

## Read this article in a different language

_🌐 List of languages_

**Sorted by:** `A-Z`

[Sorting options unavailable](https://github.com/SNU-DennisRitchieMemorial/SNU-DennisRitchieMemorial.github.io/)

( [af Afrikaans](/.github/README_AF.md) Afrikaans | [sq Shqiptare](/.github/README_SQ.md) Albanian | [am አማርኛ](/.github/README_AM.md) Amharic | [ar عربى](/.github/README_AR.md) Arabic | [hy հայերեն](/.github/README_HY.md) Armenian | [az Azərbaycan dili](/.github/README_AZ.md) Azerbaijani | [eu Euskara](/.github/README_EU.md) Basque | [be Беларуская](/.github/README_BE.md) Belarusian | [bn বাংলা](/.github/README_BN.md) Bengali | [bs Bosanski](/.github/README_BS.md) Bosnian | [bg български](/.github/README_BG.md) Bulgarian | [ca Català](/.github/README_CA.md) Catalan | [ceb Sugbuanon](/.github/README_CEB.md) Cebuano | [ny Chichewa](/.github/README_NY.md) Chichewa | [zh-CN 简体中文](/.github/README_ZH-CN.md) Chinese (Simplified) | [zh-t 中國傳統的）](/.github/README_ZH-T.md) Chinese (Traditional) | [co Corsu](/.github/README_CO.md) Corsican | [hr Hrvatski](/.github/README_HR.md) Croatian | [cs čeština](/.github/README_CS.md) Czech | [da dansk](README_DA.md) Danish | [nl Nederlands](/.github/README_NL.md) Dutch | [**en-us English**](/.github/README.md) English |  [EO Esperanto](/.github/README_EO.md) Esperanto | [et Eestlane](/.github/README_ET.md) Estonian | [tl Pilipino](/.github/README_TL.md) Filipino | [fi Suomalainen](/.github/README_FI.md) Finnish |  [fr français](/.github/README_FR.md) French | [fy Frysk](/.github/README_FY.md) Frisian | [gl Galego](/.github/README_GL.md) Galician | [ka ქართველი](/.github/README_KA) Georgian | [de Deutsch](/.github/README_DE.md) German | [el Ελληνικά](/.github/README_EL.md) Greek | [gu ગુજરાતી](/.github/README_GU.md) Gujarati | [ht Kreyòl ayisyen](/.github/README_HT.md) Haitian Creole | [ha Hausa](/.github/README_HA.md) Hausa | [haw Ōlelo Hawaiʻi](/.github/README_HAW.md) Hawaiian | [he עִברִית](/.github/README_HE.md) Hebrew | [hi हिन्दी](/.github/README_HI.md) Hindi | [hmn Hmong](/.github/README_HMN.md) Hmong | [hu Magyar](/.github/README_HU.md) Hungarian | [is Íslenska](/.github/README_IS.md) Icelandic | [ig Igbo](/.github/README_IG.md) Igbo | [id bahasa Indonesia](/.github/README_ID.md) Icelandic | [ga Gaeilge](/.github/README_GA.md) Irish | [it Italiana/Italiano](/.github/README_IT.md) | [ja 日本語](/.github/README_JA.md) Japanese | [jw Wong jawa](/.github/README_JW.md) Javanese | [kn ಕನ್ನಡ](/.github/README_KN.md) Kannada | [kk Қазақ](/.github/README_KK.md) Kazakh | [km ខ្មែរ](/.github/README_KM.md) Khmer | [rw Kinyarwanda](/.github/README_RW.md) Kinyarwanda | [ko-south 韓國語](/.github/README_KO_SOUTH.md) Korean (South) | [ko-north 문화어](README_KO_NORTH.md) Korean (North) (NOT YET TRANSLATED) | [ku Kurdî](/.github/README_KU.md) Kurdish (Kurmanji) | [ky Кыргызча](/.github/README_KY.md) Kyrgyz | [lo ລາວ](/.github/README_LO.md) Lao | [la Latine](/.github/README_LA.md) Latin | [lt Lietuvis](/.github/README_LT.md) Lithuanian | [lb Lëtzebuergesch](/.github/README_LB.md) Luxembourgish | [mk Македонски](/.github/README_MK.md) Macedonian | [mg Malagasy](/.github/README_MG.md) Malagasy | [ms Bahasa Melayu](/.github/README_MS.md) Malay | [ml മലയാളം](/.github/README_ML.md) Malayalam | [mt Malti](/.github/README_MT.md) Maltese | [mi Maori](/.github/README_MI.md) Maori | [mr मराठी](/.github/README_MR.md) Marathi | [mn Монгол](/.github/README_MN.md) Mongolian | [my မြန်မာ](/.github/README_MY.md) Myanmar (Burmese) | [ne नेपाली](/.github/README_NE.md) Nepali | [no norsk](/.github/README_NO.md) Norwegian | [or ଓଡିଆ (ଓଡିଆ)](/.github/README_OR.md) Odia (Oriya) | [ps پښتو](/.github/README_PS.md) Pashto | [fa فارسی](/.github/README_FA.md) |Persian  [pl polski](/.github/README_PL.md) Polish | [pt português](/.github/README_PT.md) Portuguese | [pa ਪੰਜਾਬੀ](/.github/README_PA.md) Punjabi | No languages available that start with the letter Q | [ro Română](/.github/README_RO.md) Romanian | [ru русский](/.github/README_RU.md) Russian | [sm Faasamoa](/.github/README_SM.md) Samoan | [gd Gàidhlig na h-Alba](/.github/README_GD.md) Scots Gaelic | [sr Српски](/.github/README_SR.md) Serbian | [st Sesotho](/.github/README_ST.md) Sesotho | [sn Shona](/.github/README_SN.md) Shona | [sd سنڌي](/.github/README_SD.md) Sindhi | [si සිංහල](/.github/README_SI.md) Sinhala | [sk Slovák](/.github/README_SK.md) Slovak | [sl Slovenščina](/.github/README_SL.md) Slovenian | [so Soomaali](/.github/README_SO.md) Somali | [[es en español](/.github/README_ES.md) Spanish | [su Sundanis](/.github/README_SU.md) Sundanese | [sw Kiswahili](/.github/README_SW.md) Swahili | [sv Svenska](/.github/README_SV.md) Swedish | [tg Тоҷикӣ](/.github/README_TG.md) Tajik | [ta தமிழ்](/.github/README_TA.md) Tamil | [tt Татар](/.github/README_TT.md) Tatar | [te తెలుగు](/.github/README_TE.md) Telugu | [th ไทย](/.github/README_TH.md) Thai | [tr Türk](/.github/README_TR.md) Turkish | [tk Türkmenler](/.github/README_TK.md) Turkmen | [uk Український](/.github/README_UK.md) Ukrainian | [ur اردو](/.github/README_UR.md) Urdu | [ug ئۇيغۇر](/.github/README_UG.md) Uyghur | [uz O'zbek](/.github/README_UZ.md) Uzbek | [vi Tiếng Việt](/.github/README_VI.md) Vietnamese | [cy Cymraeg](/.github/README_CY.md) Welsh | [xh isiXhosa](/.github/README_XH.md) Xhosa | [yi יידיש](/.github/README_YI.md) Yiddish | [yo Yoruba](/.github/README_YO.md) Yoruba | [zu Zulu](/.github/README_ZU.md) Zulu ) Available in 110 languages (108 when not counting English and North Korean, as North Korean has not been translated yet [Read about it here](/OldVersions/Korean(North)/README.md))

Translations in languages other than English are machine translated and are not yet accurate. No errors have been fixed yet as of March 21st 2021. Please report translation errors [here](https://github.com/seanpm2001/SNU-DennisRitchieMemorial/issues/). Make sure to backup your correction with sources and guide me, as I don't know languages other than English well (I plan on getting a translator eventually) please cite [wiktionary](https://en.wiktionary.org) and other sources in your report. Failing to do so will result in a rejection of the correction being published.

Note: due to limitations with GitHub's interpretation of markdown (and pretty much every other web-based interpretation of markdown) clicking these links will redirect you to a separate file on a separate page that isn't the intended page. You will be redirected to the [.github folder](/.github/) of this project, where the README translations are hosted.

Translations are currently done with Bing translate and DeepL. Support for Google Translate translations is coming to a close due to privacy concerns.

***

# Index

[00.0 - Top](#Top)

> [00.1 - Title](#The-SNU-DennisRitchieMemorial-project)

> [00.2 - Read this article in a different language](#Read-this-article-in-a-different-language)

> [00.3 - Index](#Index)

[01.0 - Description](#SNU-DennisRitchieMemorial)

[02.0 - About](#About)

[03.0 - 2021-update](#2021-update)

[04.0 - Notable works](#Notable-works)

> [04.1 - The C programming language](#The-C-programming-language)

> > [04.1.1 - The B programming language (precursor)](#The-B-programming-language)

> [04.2 - ALTRAN](#ALTRAN)

> [04.3 - UNIX](#UNIX)

> > [04.3.1 - Multics (precursor)](#Multics)

> [04.4 - The C programming language (book)](#The-C-programming-language-book)

[05.0 - Awards and honor](#Awards-and-honor)

[06.0 - History](#History)
  
> [06.1 - Pre-history](#Pre-history)

> [06.2 - Alpha History](#Alpha-history)

> [06.3 - Beta History](#Beta-history)

> [06.4 - Modern History](#Modern-history)

[07.0 - Wiki](#Wiki)

[08.0 - Copying](#Copying)

[09.0 - Credits](#Credits)

[10.0 - Authors](#Authors)

[11.0 - Installation](#Installation)

[12.0 - 404 page](#404-page)

[13.0 - Version history](#Version-history)

[14.0 - Software status](#Software-status)

[15.0 - Sponsor info](#Sponsor-info)

[16.0 - Contributers](#Contributers)

[17.0 - Issues](#Issues)

> [17.1 - Current issues](#Current-issues)

> [17.2 - Past issues](#Past-issues)

> [17.3 - Past pull requests](#Past-pull-requests)

> [17.4 - Active pull requests](#Active-pull-requests)

[18.0 - Resources](#Resources)

[19.0 - Contributing](#Contributing)

[20.0 - About README](#About-README)

[21.0 - README Version history](#README-version-history)

[22.0 - Technical notes](#Technical-notes)

[23.0 - Footer](#You-have-reached-the-end-of-the-README-file)

> [23.9 - End of file](#EOF)

***

# SNU-DennisRitchieMemorial
A memorial center for Dennis Ritchie, the grandfather of  UNIX, B, BCPL, ALTRAN, and Multics. One of the most underrated people in the history of computing.

***

## About

See above. This project is a memorial to Dennis Ritchie, who was a computer science pioneer born on September 9th 1941 and went on to create various contributions to computer science still used today, with the help of Ken Thompson, such as the C programming language, the UNIX operating system, and more. Although not a household name, it is said that if you had a magnifying glass for looking inside a computer, you could see his works everywhere, most notably for the standards he made, the C programming language, the UNIX operating system, and the UNIX philosophy.

Circa 2021 October 12th, Dennis Ritchie was found dead in his apartment. His death was not ruled a suicide, but was attributed to worsening prostate cancer and heart disease. Unfortunately, his death was largely overshadowed by the death of Apple founder Steve Jobs (if Dennis Ritchie didn't create what he did, Apple would be a very different company today, or not one at all, so it is sad to see his death get overshadowed like this)

***

## 2021 update

This project received a big update to its tributes on 2021 September 9th, on this day, Dennis Ritchie would have been 80 years old. Unfortunately, he died on 2011 October 12th

On this day, the project was modernized and received its own website. The official language of the project was also changed to C, Dennis's most notable contribution to computer science behind UNIX. HTML is now ignored.

***

## Notable works

### The C programming language

![The_C_Programming_Language_logo](/The_C_Programming_Language_logo.svg)

The C programming language is one of Dennis Ritchies most notable works, and is available on nearly every current computer in the world. It was created in the year 1970 and superceded the B programming language. It has still been going strong, and as of 2021, it has been in the top 3 for most used and most liked programming languages since 2001 or earlier. [Source needed](https://www.example.com/)

Here is an early example of functions in K&R C (Ken and Ritchie C)

```c
long some_function();
/* int */ other_function();

/* int */ calling_function()
{
    long test1;
    register /* int */ test2;

    test1 = some_function();
    if (test1 > 0)
          test2 = 0;
    else
          test2 = other_function();
    return test2;
}
```

Here is the famous C Hello World program:

```c
main()
{
    printf("hello, world\n");
}
```

And here is a conforming version of the above sample:

```c
# include <stdio.h>

int main(void)
{
    printf("hello, world\n");
}
```

#### The B programming language

BCPL, or the B programming language was the precursor to the C programming language. Although not widely used, it was the foundation of what the C programming language was built on.

Source code sample:

```c
/* The following function will print a non-negative number, n, to
   the base b, where 2<=b<=10.  This routine uses the fact that
   in the ASCII character set, the digits 0 to 9 have sequential
   code values.  */

printn(n, b) {
        extrn putchar;
        auto a;
        /* Wikipedia note: auto declares a variable with automatic
           storage (lifetime is function scope), not "automatic typing"
           as in C++11. */

        if (a = n / b)        /* assignment, not test for equality */
                printn(a, b); /* recursive */
        putchar(n % b + '0');
}
```

Another sample:

```c
/* The following program will calculate the constant e-2 to about
   4000 decimal digits, and print it 50 characters to the line in
   groups of 5 characters.  The method is simple output conversion
   of the expansion
     1/2! + 1/3! + ... = .111....
   where the bases of the digits are 2, 3, 4, . . . */

main() {
	extrn putchar, n, v;
	auto i, c, col, a;

	i = col = 0;
	while(i<n)
		v[i++] = 1;
	while(col<2*n) {
		a = n+1 ;
		c = i = 0;
		while (i<n) {
			c =+ v[i] *10;
			v[i++]  = c%a;
			c =/ a--;
		}

		putchar(c+'0');
		if(!(++col%5))
			putchar(col%50?' ': '*n');
	}
	putchar('*n*n');
}
v[2000];
n 2000;
```

These samples are from Dennis Ritchie and Ken Thompsons book on the C programming language.

#### ALTRAN

ALTRAN (ALgebraic TRANslator) is a programming language based on FORTRAN that allows for Algebraic translations. It is not very well known, but it is something he made.

Source code sample:

```fortran
     PROCEDURE MAIN # SIMPLE EXAMPLE OF USE OF FTNOUT
     LONG ALGEBRAIC (X:10,Y:10) F
     ALTRAN FTNOUT
     OPTS(201,72) # FTNOUT REQUIRES A LINE LENGTH OF 72
     F = EXPAND( (X+2*Y+1000000)**3 )
     WRITE F # PRINT F
     WRITE (25) " FUNCTION F(X,Y)"
                "C EXAMPLE PROG WRITTEN WITH FTNOUT." ,
                F ,
                " RETURN"™,       " END"
# WE HAVE WRITTEN A SIMPLE PROGRAM ON UNIT 25, NOW WE INVOKE FTNOUT TO
# THIS ALTRAN OUTPUT TO LEGAL FORTRAN.
     FTNOUT
     END
```

### UNIX

_UNIX does not have its own logo

Dennis Ritchie was one of the 2 original creators of the UNIX operating system and its design philosophy.

UNIX is still widely used today, but not the original system. The UNIX philosophy is still shared in many major modern projects, such as Linux (and its 600+ distributions) BSD (FreeBSD, NetBSD, DragonflyBSD, OpenBSD, MacOS, etc.) Solaris, and more.

![UNIX_Structure.png](/UNIX_Structure.png)

Pictured: the UNIX file structure.

#### Multics

![Multics_logo.gif](/Multics_logo.gif)

MULTICS `Multiplexed Information and Computing Service` was the precursor to the UNIX operating system. It has been said that Multics "has influenced all modern operating systems since, from microcomputers to mainframes." [better source needed, WARNING: Google link](https://www.google.com/books/edition/The_Tym_Before/kn9eDwAAQBAJ?hl=en&gbpv=1&bsq=page 66)

### The C programming language book

The book on the C programming language was created by Dennis Ritchie and Ken Thompson. It was the first detailed guide to the C programming language.

***

## Awards and honor

Dennis Ritchie received some of the highest awards in computer science for his contributions, including:

* IEEE Emanuel R. Piore Award (1982)

* Turing Award (1983)

* National Medal of Technology (1998)

* IEEE Richard W. Hamming Medal (1990)

* Computer Pioneer Award (1994)

* Computer History Museum Fellow (1997)

* Harold Pender Award (2003)

* Japan Prize (2011)

***
  
## History

This project has a short history so far.

### Pre-history

This project was developed under SNU 3. Its development started on 2020 January 16th, but wasn't made public until 2020 June 3rd, when it was uploaded to GitHub during a transition phase (the start of the Git era, and the first month where I started converting my private projects like SNU into public projects)

### Alpha history

On 2020 June 4th, this project received a Wiki, and its own `README.md` file.

On 2021 June 17th, after over a year of no development, this project was brought slightly up to code, and its next big update was planned for 2021 September 9th, the 80th birthday of Dennis Ritchie. This project also received its own organization today.

On 2021 September 9th, this project received a massive documentation and content update and was brought up to date to celebrate 80 years of Dennis Ritchies life and afterlife. This project also received its own website today.

### Beta history

No Beta history to show for this project.

### Modern history

No Modern history to show for this project.

***

## Wiki

[Click/tap here to view this projects Wiki](https://github.com/SNU-DennisRitchieMemorial/SNU-DennisRitchieMemorial/wiki/)

If the project has been forked, the Wiki was likely removed. Luckily, I include an embedded version. You can view it [here](/External/ProjectWiki/).

***

## Copying

View the copying license for this project [here](/COPYING) (if you haven't built the project yet with the makefile, here is the original link: [COPYINGL](/COPYINGL)

Please note that you also have to follow the rules of the GNU General Public License v3 (GPL3) which you can view [here](/LICENSE.txt)

***

## Credits

View the credits file for this project and see the people who got together to make this project by [clicking/tapping here](/CREDITS)

***

## Authors

View the authors file for this project and see the authors of this project by [clicking/tapping here](/AUTHORS)

***

## Installation

View the installation instructions file for this project [here](/INSTALL)

Requirements: Jekyll, GitHub emulator (may not exist yet)

***

## 404 page

Test the 404 page for this project by [clicking/tapping here](/Site/404/THIS-WILL-NEVER-WORK/ABJAB/DXV48/22846/FILE.xabcdfgxlma329)

Getting a different 404 page? View the 404 page directly by [clicking/tapping here](/404.htm;)

***

## Sponsor info

![SponsorButton.png](/SponsorButton.png)

You can sponsor this project if you like, but please specify what you want to donate to. [See the funds you can donate to here](https://github.com/seanpm2001/Sponsor-info/tree/main/For-sponsors/)

You can view other sponsor info [here](https://github.com/seanpm2001/Sponsor-info/)

Try it out! The sponsor button is right up next to the watch/unwatch button.

***

## Version history

**Version history currently unavailable**

**No other versions listed**

***

## Software status

All of my works are free some restrictions. DRM (**D**igital **R**estrictions **M**anagement) is not present in any of my works.

![DRM-free_label.en.svg](/DRM-free_label.en.svg)

This sticker is supported by the Free Software Foundation. I never intend to include DRM in my works.

I am ussing the abbreviation "Digital Restrictions Management" instead of the more known "Digital Rights Management" as the common way of addressing it is false, there are no rights with DRM. The spelling "Digital Restrictions Management" is more accurate, and is supported by [Richard M. Stallman (RMS)](https://en.wikipedia.org/wiki/Richard_Stallman/) and the [Free Software Foundation (FSF)](https://en.wikipedia.org/wiki/Free_Software_Foundation/)

This section is used to raise awareness for the problems with DRM, and also to protest it. DRM is defective by design and is a major threat to all computer users and software freedom.

Image credit: [defectivebydesign.org/drm-free/...](https://www.defectivebydesign.org/drm-free/how-to-use-label/)

***

## Contributers

Currently, I am the only contributer. Contributing is allowed, as long as you follow the rules of the [CONTRIBUTING.md](/CONTRIBUTING.md) file.

> * 1. [seanpm2001](https://github.com/seanpm2001/) - 54 commits (As of 2021 Thursday September 9th at 7:00 pm)

> * 2. No other contributers.

***

## Issues

### Current issues

* None at the moment

* No other current issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past issues

* None at the moment

* No other past issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past pull requests

* None at the moment

* No other past pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Active pull requests

* None at the moment

* No other active pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

***

## Resources

Here are some other resources for this project:

[Project language file A](/PROJECT_LANG_1.htm) | [Project language file AB](/PROJECT_LANG_1.c)

[View the editor configuration file for this project](/.editorconfig)

[View the linguist attributes file for this project](/.gitattributes)

[View the Git Ignore file for this project](/.gitignore)

[View the organization for this project](https://github.com/SNU-DennisRitchieMemorial/)

[Build/view the makefile for this project](/makefile.mk)

[Join the discussion on GitHub](https://github.com/SNU-DennisRitchieMemorial/SNU-DennisRitchieMemorial/discussions/)

[View the issues/Raise an issue for this project](https://github.com/SNU-DennisRitchieMemorial/SNU-DennisRitchieMemorial/issues/)

No other resources at the moment.

***

## Contributing

Contributing is allowed for this project, as long as you follow the rules of the `CONTRIBUTING.md` file.

[Click/tap here to view the contributing rules for this project](/CONTRIBUTING.md)

***

## About README

**File type:** `Markdown (*.md *.mkd *.markdown)`

**File version:** `2 (Thursday, 2021 September 9th at 7:00 pm)`

**Line count:** `0,770`

***

## README version history

**Version 0.1 (Sunday, March 21st 2021 at 7:50 pm)**

> Changes:

> * Started the file

> * Added the title section

> * Added the index

> * Added the about section

> * Added the Wiki section

> * Added the version history section

> * Added the issues section.

> * Added the past issues section

> * Added the past pull requests section

> * Added the active pull requests section

> * Added the contributors section

> * Added the contributing section

> * Added the about README section

> * Added the README version history section

> * Added the resources section

> * Added a software status section, with a DRM free sticker and message

> * Added the sponsor info section

> * No other changes in version 0.1

**Version 0.11 (Friday, July 16th 2021 at 9:20 pm)**

> Changes:

> * Updated several sections with corrected template syntax

> * Added the history section

> * Updated the language list switcher section

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11

**Version 0.11B (Friday, July 16th 2021 at 9:25 pm)**

> Changes:
  
> * Fixed the footer, removed bad link (ddg.com does not redirect to duckduckgo)
  
> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11B

**Version 0.12A (Thursday, July 22nd 2021 at 6:26 pm)**

> Changes:
  
> * The typo `SNU Erotica` was removed entirely

> * Added a better name than file.svg

> * Fixed the title section
  
> * Fixed the index
  
> > * Added the history section

> * Minor formatting fixes

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11B

**Version 0.13 (2021, Saturday August 21st 2021 at 5:02 pm)**

> Changes:
  
> * Times are now compliant with ISO:8601 and use YYYY-MM-DD rather than MM-DD-YYYY

> * Updated the title section

> * Fixed and update template links

> * Updated the index

> * Added the copying section

> * Added the credits section

> * Added the installation section

> * Added the 404 page test section

> * Updated the resources section

> * Updated the contributors section

> * Added the technical notes section

> * Updated the footer

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 6 (0.13)

**Version 0.14 (2021, Tuesday August 24th 2021 at 9:31 pm)**

> Changes:
  
> * Times are now compliant with ISO:8601 and use YYYY-MM-DD rather than MM-DD-YYYY

> * Updated the index

> * Added the authors section

> * Updated the footer, adding support for the Swisscows search engine as a 4th option

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 6 (0.13)

**Version 1 (Thursday, June 4th 2020 at 3:13 pm)**

> Changes:

> * Started the file

> * Added the about section

> * Added the Wiki section

> * Added the version history section

> * Added the contributors section

> * Added the about README section

> * Added the footer section

> * No other changes in version 1

**Version 2 (Thursday, 2021 September 9th at 7:00 pm)**

> Changes:

> * Adopted the GitHub pages V7 template and inherited its history

> * Updated the title section

> * Updated the index

> * Updated the about section

> * Added the notable works section, plus several subsections

> * Added the awards and honor section

> * Updated the history section

> * Updated the footer, adding support for the safe.duckduckgo search engine

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 2

**Version 3 (Coming soon)**

> Changes:

> * Coming soon

> * No other changes in version 3

**Version 4 (Coming soon)**

> Changes:

> * Coming soon

> * No other changes in version 4

***

## Technical notes

**All times are UTC-7 (PDT/Pacific Time)**

**The encoding is UTF-8 and is compatible with Unicode 5.0 and up**

***

## You have reached the end of the README file

( [Back to top](#Top) | [Exit to GitHub](https://github.com) | [Exit to Bing](https://www.bing.com/) | [Exit to DuckDuckGo](https://duckduckgo.com/) |  [Exit to Safe.DuckDuckGo](https://safe.duckduckgo.com/) | [Exit to Ecosia](https://www.ecosia.org/) | [Exit to Swisscows](https://www.swisscows.com/) )

### EOF

***

