
***

# Reforms

## Laptop industry

This is a list of reforms for the laptop industry, and the Personal Computer industry in general. These are legal rules that are designed to be compliant with as many laptop manufacturers as possible, while still being highly ethical and accessible to all users.

## Major points

1. [Battery](#Battery) - How battery should be determined/measured, and how much time it should have on battery.

2. [Weight/thickness](#Weight-and-thickness) - The weight of a laptop, the thickness of a laptop

3. [SD card slot](#SD-card-slot) - Parameters and support for a MicroSD card reader

4. [Operating System choice](#Operating-system-coice) - Give the user choice on what operating system they use, define fair rules on installation, and defining parameters so all laptops can have the same operating system choices

5. [Warranty](#Warranty) - What can and can't void the warranty, warranty renewal at any time, mandatory 1 year warranty for all devices at no additional cost

6. [Right to repair](#Right-to-repair) - Giving users the freedom to repair their devices without difficulty, inconvenience, or impossibility

7. [Non-free software](#Non-free-software) - Defining that non-free software is completely optional, defining what non-free software is, and preventing the force installation of non-free software.

### Battery

Battery percentage SHOULD NOT be determined by idle time. It should be determined by how long it can do hard tasks, such as processing/rendering 8K video, or other activities with at least 50% constant CPU usage.

The laptop battery must last at least 4 hours at 100% CPU usage for budget laptops, and at least 9 hours on 100% CPU usage for higher-end laptops.

### Weight and thickness

Laptops need to be thick enough to have at least 2 USB 3 ports, Dongles should be obsolete, as they are problematic, unnecessary, and cause an additional component to fail on the system that makes it harder to use the device (for example: if the Dongle becomes weak, you have to get a new dongle before you can plug something in)

Laptops should weigh at least 1.0 pound (0.45 kilograms) each. Any laptop weighing less than 1.0 pound (0.45 kilograms) needs to be redesigned and not released.

### SD card slot

The SD card slot is a must for modern laptops (2010 onward) The microSD card reader should be able to read SD cards of up to 2 terabytes or higher capacity, and should not discriminate by which brand/manufacturer they come from. The SD card also should be unmountable by pressing on it, causing it to eject on its own.

The SD card slot should NOT be a replacement for a USB port. You must still provide at least 2 USB 3.0 ports alongside the MicroSD card reader slot.

### Operaring system choice

All laptops should have at least 3 choices for a default Operating System, and you shouldn't get a single byte of a difference for choosing a different operating system (Example: 7,999,999,999 bytes of RAM for choosing Linux, and 8,000,000,000 bytes of RAM for using Windows) (Windows, ChromeOS, Linux/safe (Ubuntu, Triskell, Red Hat Linux, Fedora, Arch, Manjaro, etc.)) the safe option is the difficult one to define, as evil unsafe Linux-based systems such as ChromeOS exist. The 3rd option should be a common Linux distribution that respects the user, Ubuntu isn't the worst when compared to Windows (non-Linux) or ChromeOS, but another common replacement would be Red Hat Linux or Fedora Linux. Come on, people are paying you hundreds/thousands of dollars to buy a laptop, they should at least have more freedom when it comes to which operating system they can choose.

***Additional rules and notes:***

1. MacOS isn't listed as an option here, as any computer that sells with MacOS installed typically won't give you another option. This reform doesn't apply to Apple, as there isn't much that can be done here 

2. BSD isn't listed as an option either, as it is harder to support. I am not against BSD, I just want to create terms that as many laptop manufacturers as possible can get behind. BSD can easily be a 4th option, same goes for Solaris, ReactOS, and other operating systems not yet listed.

3. If you can't choose Windows or ChromeOS for ethical or licensing reasons, replace it with an operating system of your choice. There should ALWAYS be at least 3 different options

4. You must provide an operating system from a different company as one of the options, they all can't be of origin in the same country. There should be at least 2 different country-based operating systems (for example: you cannot have Windows, ChromeOS, and Ubuntu as the only options, as they are all of US origin)

_This section needs a better set of definitions - 2021 Sunday October 24th_

### Warranty

<!-- Draft 1
The following text is supposed to be crossed through. If it is not, please skip from line 19 to line 21

~~Installing a different operating system SHOULD NOT void the warranty. If we really have to talk about it like this: modification of the device system software can void the warranty, unless your system software is open source, you know what, screw the warranty. I am going to rewrite this~~
!-->

Installing a different operating system or modifying the system software SHOULD NOT void the warranty. You paid for the laptop, you should be able to choose what you can do with it.

A warranty must be easily affordable to all, and should last a minimum of 2 years for an extended option. A laptop purchase should automatically come with a 1 year warranty built in, regardless of if the user purchases one or not. I can see what you are going to do, so I am going to rule it out: you cannot increase the device price to compensate for the built-in 1 year warranty.

A laptop warranty should be renewable at any time, so even if you have the device for 10 years without a warranty, you can renew it at that time for repairs.

### Right to repair

The right to repair should be respected on all devices. A hardware manufacturer should NOT put up ANY restrictions for making a device harder to repair.

You cannot implement software or hardware changes that makes it difficult, inconvenient, or impossible for any repair company to repair the device.

All parts of the laptop should be easily replaceable without consequence. This means that replacing the keyboard or any other component doesn't overwrite the operating system. <!-- (yeah, thanks on that one Dell) !-->

### Non-free software

Proprietary software should NOT be installed without the users consent. This includes any form of DRM, "anti-virus" software like McAfee, AVG, Avast, Norton, other anti-virus software, web browsers (such as Google Chrome, Microsoft Edge, Opera, Safari, and other proprietary web browsers) and any other software with a closed source license (such as Dashlane, printer software, etc.) If you are to include these, it MUST be an option to the user, and if the user requests it, it should NOT come with the device, not even as an installer file or Internet/program shortcut.

_The following paragraph is experimental, and may need to be modified to fix problems, as it contradicts several points that have been made here._

If the Linux distribution/other operating system distribution comes with this software (such as Ubuntu, Windows 10, Windows 11, ChromeOS) it MUST be removable, and if it can't be removed easily, you should contact the distribution owner if you can't remove it on a custom distribution. If the device focuses solely on a piece of proprietary software (such as ChromeOS) it must be an option to not have it installed (go back to the operating system choice section)

***

### File info

<details open><summary><p>Click/tap here to expand/collapse the file info section for this document</p></summary>

**File version:** `2 (Sunday, 2021 October 24th at 9:33 pm)`

**File type:** `Markdown document (*.md, *.mkd, *.mdown, *.markdown)`

**Line count (including blank lines and compiler line):** `111`

**Language:** `English (US) / Markdown`

</details>

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

