Valid code distancing guidelines

***

# Valid code distancing guidelines

This file goes over the syntax rules and code distancing rules of this project.

***

## Start and end

### Starting at line 1:
1, 7, 14, 21, 28, 35, 42, 49, 56, 63, 70, 77, 84, 91, 98, 105, 112, 119, 126, 133, 140, 147, 154, 161, 168, 175, 182, 189, 196, 203, 210
Any other line in between with this pattern may have an error and an issue should be raised with the label: "bad code distancing"

### Starting at line 2, 3, 4+. (issue)
Scripts in this repository shouldn't start on the 2nd line. If you spot this, raise an issue with the label: "bad code distancing"

***

## Important notes

Each line has to be at least 6 line breaks apart, whether the line breaks are CR (Carriage Return) LF (Line Feed) or both (Carriage Return + Line Feed, Windows (CR) (LF)) (think of it as an array in Python (Not like an array in languages that start at 1 in their arrays) it starts at 0, not 1, the line itself is 0, the 7th break is 6)

***

## Miscellaneous notes

**Notice: the following line is satire, but the rule of text files and markdown files in documentation being discluded is true.**
Note: plain text files (*.txt) and documentation written in Markdown (*.md) are immune to COVID-19 and don't have to distance itself, as the 2 species don't share the programming DNA structure

***

https://github.com/seanpm2001/Code-distancing/wiki/Valid-code-distancing-guidelines

