Social-distancing

***

# Social distancing

**Source:**

From Wikipedia, [Social distancing](https://en.wikipedia.org/wiki/Social_distancing/), lead section, as of [revision 1045349425](https://en.wikipedia.org/w/index.php?title=Social_distancing&oldid=1045349425)

**Legal:**

_Modified for Markdown support and broken link removal, Text is available under the Creative Commons Attribution-ShareAlike License; additional terms may apply. Wikipedia® is a registered trademark of the Wikimedia Foundation, Inc., a non-profit organization._

In public health, social distancing, also called physical distancing, is a set of non-pharmaceutical interventions or measures intended to prevent the spread of a contagious disease by maintaining a physical distance between people and reducing the number of times people come into close contact with each other. It usually involves keeping a certain distance from others (the distance specified differs from country to country and can change with time) and avoiding gathering together in large groups.

By minimising the probability that a given uninfected person will come into physical contact with an infected person, the disease transmission can be suppressed, resulting in fewer deaths. The measures may be used in combination with others, such as good respiratory hygiene, face masks and hand washing. To slow down the spread of infectious diseases and avoid overburdening healthcare systems, particularly during a pandemic, several social-distancing measures are used, including the closing of schools and workplaces, isolation, quarantine, restricting the movement of people and the cancellation of mass gatherings. Drawbacks of social distancing can include loneliness, reduced productivity and the loss of other benefits associated with human interaction.

Social distancing measures are most effective when the infectious disease spreads via one or more of the following methods, droplet contact (coughing or sneezing), direct physical contact (including sexual contact), indirect physical contact (such as by touching a contaminated surface), and airborne transmission (if the microorganism can survive in the air for long periods). The measures are less effective when an infection is transmitted primarily via contaminated water or food or by vectors such as mosquitoes or other insects. Authorities have encouraged or mandated social distancing during the COVID-19 pandemic as it is an important method of preventing transmission of COVID-19. COVID-19 is much more likely to spread over short distances than long ones. However, it can spread over distances longer than 2 m (6 ft) in enclosed, poorly ventilated places and with prolonged exposure.

Although the term "social distancing" was not introduced until the 21st century, social-distancing measures date back to at least the 5th century BC. The Bible contains one of the earliest known references to the practice in the Book of Leviticus 13:46: "And the leper in whom the plague is... he shall dwell alone; [outside] the camp shall his habitation be." During the Plague of Justinian of 541 to 542, Emperor Justinian enforced an ineffective quarantine on the Byzantine Empire, including dumping bodies into the sea; he predominantly blamed the widespread outbreak on "Jews, Samaritans, pagans, heretics, Arians, Montanists and homosexuals". In modern times, social distancing measures have been successfully implemented in several epidemics. In St. Louis, shortly after the first cases of influenza were detected in the city during the 1918 flu pandemic, authorities implemented school closures, bans on public gatherings and other social-distancing interventions. The influenza fatality rates in St. Louis were much less than in Philadelphia, which had fewer cases of influenza but allowed a mass parade to continue and did not introduce social distancing until more than two weeks after its first cases.

The World Health Organization (WHO) has suggested using the term "physical distancing" instead of "social distancing" because it is physical separation which prevents transmission; people can remain socially connected by meeting outdoors at a safe distance (when there is no stay-at-home order) and by meeting via technology.

***

## Article info

**Article type:** `COVID-19 pandemic information article, modified from Wikipedia`

**Article format:** `Markdown document (*.md *.mkd *.mdown *.markdown)`

**Article version:** `1 (Wednesday, 2021 October 20th at 4:37 pm)`

**Article language:** `English (US) / Markdown`

**Line count (including blank lines and compiler line):** `39`

***

https://github.com/seanpm2001/Code-distancing/wiki/Social-distancing

