
***

# Android version history

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Robot/Head/Flat/Android_robot_head.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Robot/Head/Flat/Android_robot_head.svg)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2019/Android_new_logo_2019.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2019/Android_new_logo_2019.svg)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2015/Android_logo_(2015-2019).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2015/Android_logo_(2015-2019).svg)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2014/Android_Logo_(2014-2015).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2014/Android_Logo_(2014-2015).svg)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2007/Android_logo_(2007-2014).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2007/Android_logo_(2007-2014).svg)

( **Type:** `Mobile operating system` | **Written in:** `C, Java` | **Software type:** `Mixed source (some open source parts, but lots of proprietary parts)` )

The version history of the Android mobile operating system began with the public release of the Android beta on November 5, 2007. The first commercial version, Android 1.0, was released on September 23, 2008. Android is continually developed by Google and the Open Handset Alliance (OHA), and it has seen several updates to its base operating system since the initial release.

## Overview

The development of Android started in 2003 by Android, Inc., which was purchased by Google in 2005. There were at least two internal releases of the software inside Google and the OHA before the beta version was released. The beta was released on November 5, 2007, while the software development kit (SDK) was released on November 12, 2007. Several public beta versions of the SDK were released. These releases were done through software emulation as physical devices did not exist to test the operating system.

The first public release of Android 1.0 occurred with the release of the T-Mobile G1 (aka HTC Dream) in October 2008. Android 1.0 and 1.1 were not released under specific code names. The code names "Astro Boy" and "Bender" were tagged internally on some of the early pre-1.0 milestone builds and were never used as the actual code names of the 1.0 and 1.1 releases of the OS.

The project manager, Ryan Gibson, conceived using a confectionery-themed naming scheme for public releases, starting with Android 1.5 Cupcake. Google announced in August 2019 they were ending the confectionery theming scheme to use numerical ordering for future versions. The first release under the numerical order format was Android 10, which was released September 2019.

In 2017, Google announced that Google Play would begin to require apps to target a recent Android version. Initially the minimum requirement was Android 8, released in the second half of 2017, for which support would be required for new apps by August 2018, and for updates to existing apps by November 2018. This pattern has continued in subsequent years. In November 2020, Google announced new apps will need to target Android 10 by August 2021 and any updates to existing apps will need to target Android 10 by November 2021.

Name 	Internal codename 	Version number(s) 	Initial stable

release date 	Supported

(security fixes) 	API level 	References

Android 1.0 	N/A 	1.0 	September 23, 2008 	No 	1 	

Android 1.1 	Petit Four 	1.1 	February 9, 2009 	No 	2 	

[Android Cupcake](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-1-5-Cupcake/) 	Cupcake 	1.5 	April 27, 2009 	No 	3 

[Android Donut](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-1-6-Donut/) 	Donut 	1.6 	September 15, 2009 	No 	4 	

[Android Eclair](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-2.0-Eclair/) 	Eclair 	2.0 	October 27, 2009 	No 	5 	

2.0.1 	December 3, 2009 	No 	6 	

2.1 	January 11, 2010 	No 	7 	

[Android Froyo](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-2-2-Froyo/) 	Froyo 	2.2 – 2.2.3 	May 20, 2010 	No 	8 	

[Android Gingerbread](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-2-3-Gingerbread/) 	Gingerbread 	2.3 – 2.3.2 	December 6, 2010 	No 	9 	

2.3.3 - 2.3.7 	February 9, 2011 	No 	10 	

[Android Honeycomb](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-3-0-Honeycomb/) 	Honeycomb 	3.0 	February 22, 2011 	No 	11 	

3.1 	May 10, 2011 	No 	12 	

3.2 - 3.2.6 	July 15, 2011 	No 	13 	

[Android Ice Cream Sandwich](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-0-Ice-cream-sandwich/) 	Ice Cream Sandwich 	4.0 – 4.0.2 	October 18, 2011 	No 	14 	

4.0.3 - 4.0.4 	December 16, 2011 	No 	15 	

[Android Jelly Bean](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-1-Jelly-Bean/) 	Jelly Bean 	4.1 – 4.1.2 	July 9, 2012 	No 	16 	

4.2 - 4.2.2 	November 13, 2012 	No 	17 	

4.3 - 4.3.1 	July 24, 2013 	No 	18 	

[Android KitKat](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-4-KitKat/) 	Key Lime Pie 	4.4 – 4.4.4 	October 31, 2013 	No 	19 	

4.4W - 4.4W.2 	June 25, 2014 	No 	20 	

[Android Lollipop](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-5-0-Lollipop/) 	Lemon Meringue Pie 	5.0 – 5.0.2 	November 4, 2014 	No 	21 	

5.1 - 5.1.1 	March 2, 2015 	No 	22 	

[Android Marshmallow](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-6-0-Marshmallow/)  	Macadamia Nut Cookie 	6.0 – 6.0.1 	October 2, 2015 	No 	23 	

[Android Nougat](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-7-0-Nougat/)	New York Cheesecake 	7.0 	August 22, 2016 	No 	24 	

7.1 - 7.1.2 	October 4, 2016 	No 	25 	

[Android Oreo](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-8-0-Oreo/) 	Oatmeal Cookie 	8.0 	August 21, 2017 	No 	26 	

8.1 	December 5, 2017 	Yes 	27 	

[Android Pie](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-9-0-Pie/) 		9 	August 6, 2018 	Yes 	28 	

[Android 10](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-10-0/) 	Quince Tart 	10 	September 3, 2019 	Yes 	29 	

[Android 11](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-11-0/)	Red Velvet Cake 	11 	September 8, 2020 	Yes 	30 	

[Android 12](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-12-0/) 	Snow Cone 	12 	October 4, 2021 	Presupported 	31 	

## Version history

The following tables show the release dates and key features of all Android operating system updates to date, listed chronologically by their official application programming interface (API) levels.

### Android 1.0

Android 1.0 (API 1)

Android 1.0, the first commercial version of the software, was released on September 23, 2008. The first commercially available Android device was the HTC Dream. Android 1.0 incorporated the following features:

Version 	Release date 	Features

1.0 	September 23, 2008 	

Android Market, allowing application downloads and updates through the Market application.

Web browser to show, zoom and pan full HTML and XHTML web pages – multiple pages show as windows ("cards").

Camera support – however, this version lacked the option to change the camera's resolution, white balance, quality, etc.

Folders allowing the grouping of a number of application icons into a single folder icon on the Home screen.

Access to web email servers, supporting POP3, IMAP4, and SMTP.

Gmail synchronization with the Gmail application.

Google Contacts synchronization with the People application.

Google Calendar synchronization with the Calendar application.

Google Maps with Street View to view maps and satellite imagery, as well as find local businesses and obtain driving directions using GPS.

Google Sync, allowing management of over-the-air synchronization of Gmail, People, and Calendar.

Google Search, allowing users to search the Internet and phone applications, contacts, calendar, etc.

Google Talk instant messaging.

Instant messaging, text messaging, and MMS.

Media Player, enabling management, importing, and playback of media files – however, this version lacked video and stereo Bluetooth support.

Notifications appear in the Status bar, with options to set ringtone, LED or vibration alerts.

Voice Dialer allows dialing and placing of phone calls without typing a name or number.

Wallpaper allows the user to set the background image or photo behind the Home screen icons and widgets.

YouTube video player.

Other applications include: Alarm Clock, Calculator, Dialer (Phone), Home screen (Launcher), Pictures (Gallery), and Settings.

Wi-Fi and Bluetooth support.

### Android 1.1

Android 1.1 (API 2)

On February 9, 2009, the Android 1.1 update was released, initially for the HTC Dream only. Android 1.1 was known as "Petit Four" internally, though this name was not used officially. The update resolved bugs, changed the Android API and added a number of features:

Version 	Release date 	Features

1.1 	February 9, 2009 	

Details and reviews available when a user searches for businesses on Maps.

Longer in-call screen timeout by default when using the speakerphone, plus the ability to show/hide the dialpad.

Ability to save attachments in messages.

Support added for marquee in system layouts.

### Android 1.5 Cupcake

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/1.5-Cupcake/Android_Cupcake_home_screen.jpg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/1.5-Cupcake/Android_Cupcake_home_screen.jpg)

Android 1.5 Cupcake (API 3)

On April 27, 2009, the Android 1.5 update was released, based on Linux kernel 2.6.27. This was the first release to officially use a codename based on a dessert item ("Cupcake"), a theme used for all releases until Android Pie, with Android 10 using a number-only system. The update included several new features and UI amendments:

Version 	Release date 	Features 	Image(s)

1.5 	April 27, 2009 	

Support for third-party virtual keyboards with text prediction and a user dictionary for custom words.

Support for Widgets – miniature application views that can be embedded in other applications (such as the Home screen) and receive periodic updates.

Video recording and playback in MPEG-4 and 3GP formats.

Auto-pairing and stereo support for Bluetooth (A2DP and AVRCP profiles).

Copy and paste features in web browser.

User pictures shown for Favorites in Contacts.

Specific date/time stamp shown for events in call log, and one-touch access to a contact card from a call log event.

Animated screen transitions.

Auto-rotation option.

New stock boot animation.

Ability to upload videos to YouTube.

Ability to upload photos to Picasa.

Ability to check phone usage history.

### Android 1.6 Donut

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/1.6-Donut/Android_1.6_on_the_Android_SDK.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/1.6-Donut/Android_1.6_on_the_Android_SDK.png)

Android 1.6 Donut (API 4)

On September 15, 2009, Android 1.6 – dubbed Donut – was released, based on Linux kernel 2.6.29. Included in the update were numerous new features:[62]

Version 	Release date 	Features 	Image(s)

1.6 	September 15, 2009	

Voice and text entry search enhanced to include bookmark history, contacts, and the web.

Ability for developers to include their content in search results.

Multi-lingual speech synthesis engine to allow any Android application to "speak" a string of text.

Easier searching and the ability to view app screenshots in Android Market.

Gallery, Camera and camcorder more fully integrated, with faster camera access.

Ability for users to select multiple photos for deletion.

Updated technology support for CDMA/EVDO, 802.1x, VPNs, and a text-to-speech engine.

Support for WVGA screen resolutions.

Speed improvements in searching and camera applications.

Expanded Gesture framework and a new GestureBuilder development tool.

### Android 2.0 Eclair

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/2.0-Eclair/Nexus_one_home_screen_21.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/2.0-Eclair/Nexus_one_home_screen_21.png)

Android 2.0 Eclair (API 5)

On October 27, 2009, the Android 2.0 SDK was released, based on Linux kernel 2.6.29 and codenamed Eclair. Changes include the ones listed below.

Version 	Release date 	Features 	Image(s)

2.0 	October 27, 2009 	

Expanded Account sync, allowing users to add multiple accounts to a device for synchronization of an email and contacts.

Microsoft Exchange email support, with a combined inbox to browse an email from multiple accounts in one page.

Bluetooth 2.1 support.

Ability to tap a Contacts photo and select to call, SMS, or email the person.

Ability to search all saved SMS and MMS messages, with the added ability to delete the oldest messages in a conversation automatically deleted when a defined limit is reached.

Numerous new camera features, including flash support, digital zoom, scene mode, white balance, color effect and macro focus.

Improved typing speed on a virtual keyboard, with a smarter dictionary that learns from word usage and includes contact names as suggestions.

Refreshed browser UI with bookmark thumbnails, double-tap zoom and support for HTML5.

Calendar agenda view enhanced, showing attending status for each invitee, and the ability to invite new guests to events.

Optimized hardware speed and revamped UI.

Support for more screen sizes and resolutions, with better contrast ratio.

Improved Google Maps 3.1.2.

MotionEvent class enhanced to track multi-touch events.

Pressure-sensitive touch support in API, even though no according hardware existed at that time.

Addition of live wallpapers, allowing the animation of home-screen background images to show movement.

Android 2.0.1 Eclair

Android 2.0.1 Eclair (API 6)

Version 	Release date 	Features 	Image(s)

2.0.1 	December 3, 2009

Minor API changes, bug fixes and framework behavioral changes.

Android 2.1 Eclair

Android 2.1 Eclair (API 7)

Version 	Release date 	Features 	Image(s)

2.1 	January 11, 2010	

Minor amendments to the API and bug fixes.

	Nexus one home screen 21.png

### Android 2.2 Froyo

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/2.2-Froyo/Android_2.2_Froyo_home.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/2.2-Froyo/Android_2.2_Froyo_home.png)

Android 2.2 Froyo (API 8)

On May 20, 2010, the SDK for Android 2.2 (Froyo, short for frozen yogurt) was released, based on Linux kernel 2.6.32.

Version 	Release date 	Features 	Image(s)

2.2 	May 20, 2010 	

Speed, memory, and performance optimizations.

Additional application speed improvements, implemented through JIT compilation.

Integration of Chrome's V8 JavaScript engine into the Browser application.

Support for the Android Cloud to Device Messaging (C2DM) service, enabling push notifications.

Improved Microsoft Exchange support, including security policies, auto-discovery, GAL look-up, calendar synchronization and remote wipe.

Improved application launcher with shortcuts to Phone and Browser applications.

USB tethering and Wi-Fi hotspot functionality

Option to disable data access over a mobile network.

Updated Market application with batch and automatic update features.

Quick switching between multiple keyboard languages and their dictionaries.

Support for Bluetooth-enabled car and desk docks.

Support for numeric and alphanumeric passwords.

Support for file upload fields in the Browser application.

The browser now shows all frames of animated GIFs instead of just the first frame only.

Support for installing applications to expandable memory.

Adobe Flash support.

Support for high-PPI displays (up to 320 ppi), such as four-inch 720p screens.

Gallery allows users to view picture stacks using a zoom gesture.

2.2.1 	September 27, 2010 	

Bug fixes, security updates and performance improvements.

2.2.2 	January 21, 2011 	

Minor bug fixes, including SMS routing issues that affected the Nexus One.

2.2.3 	November 21, 2011

Two security updates.

### Android 2.3 Gingerbread

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/2.3-Gingerbread/Android_screenshot.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/2.3-Gingerbread/Android_screenshot.png)

Android 2.3 Gingerbread (API 9)

On December 6, 2010, the Android 2.3 (Gingerbread) SDK was released, based on Linux kernel 2.6.35. Changes included:

Version 	Release date 	Features 	Image(s)

2.3 	December 6, 2010 	

Updated user interface design with increased simplicity and speed.

Support for extra-large screen sizes and resolutions (WXGA and higher).

Native support for SIP VoIP internet telephones.

Faster, more intuitive text input on a virtual keyboard, with improved accuracy, better suggested text and voice input mode.

Enhanced copy/paste functionality, allowing users to select a word by press-holding, copying, and pasting.

Support for Near Field Communication (NFC), allowing the user to read an NFC tag embedded in a poster, sticker, or advertisement.

New audio effects such as reverb, equalization, headphone virtualization, and bass boost.

New Download Manager, giving users easy access to any file downloaded from the browser, email, or another application.

Support for multiple cameras on the device, including a front-facing camera, if available.

Support for WebM/VP8 video playback, and AAC audio encoding.

Improved power management with a more active role in managing applications that are keeping the device awake for too long.

Enhanced support for native code development.

Switched from YAFFS to ext4 on newer devices.

Audio, graphical, and input enhancements for game developers.

Concurrent garbage collection for increased performance.

Native support for more sensors (such as gyroscopes and barometers).

First Android version to feature an Easter egg. It was an image of the Bugdroid standing next to a zombie gingerbread man, with many more zombies in the background.

2.3.1 	December 22, 2010 	

Improvements and bug fixes for the Nexus S.

2.3.2 	January 21, 2011 	

Improvements and bug fixes for the Nexus S.

Android 2.3.3 Gingerbread

Android 2.3.3 Gingerbread (API 10)

Version 	Release date 	Features 	Image(s)

2.3.3 	February 9, 2011

Several improvements and API fixes.

2.3.4 	April 28, 2011

Support for voice or video chat using Google Talk.

Open Accessory Library support. Open Accessory was introduced in 3.1 (Honeycomb) but the Open Accessory Library grants 2.3.4 added support when connecting to a USB peripheral with compatible software and a compatible application on the device.

Switched the default encryption for SSL from AES256-SHA to RC4-MD5.

Fixed a spontaneous reboot on Samsung Galaxy S Plus.

2.3.5 	July 25, 2011	

Improved network performance for the Nexus S 4G, among other fixes and improvements.

Fixed a Bluetooth bug on Samsung Galaxy S.

Fixed a Wi-Fi crash on Samsung Galaxy S Plus.

Improved the Gmail application.

Shadow animations for list scrolling.

Camera software enhancements.

Improved battery efficiency.

2.3.6 	September 2, 2011	

Fixed a voice search bug.

2.3.7 	September 21, 2011 	

Google Wallet support for the Nexus S 4G.

### Android 3.0 Honeycomb

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/3.0-Honeycomb/Android3.0.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/3.0-Honeycomb/Android3.0.png)

Android 3.0 Honeycomb (API 11)

On February 22, 2011, the Android 3.0 (Honeycomb) SDK – the first tablet-only Android update – was released, based on Linux kernel 2.6.36. The first device featuring this version, the Motorola Xoom tablet, was released on February 24, 2011. The update's features included:

Version 	Release date 	Features 	Image(s)

3.0 	February 22, 2011 	

Optimized tablet support with a new “holographic” user interface (removed again the following year with version 4.2).

New Easter egg, an image of a Tron-themed bumblebee.

Added System Bar, featuring quick access to notifications, status, and soft navigation buttons, available at the bottom of the screen.

Added the Action Bar, giving access to contextual options, navigation, widgets, or other types of content at the top of the screen.

Simplified multitasking – tapping Recent Applications in the System Bar allows users to see snapshots of the tasks underway and quickly jump from one application to another.

Redesigned the keyboard, making typing fast, efficient and accurate on larger screen sizes

Simplified, more intuitive copy/paste interface.

Multiple browser tabs replacing browser windows, plus form auto-fill and a new “incognito” mode allowing somewhat anonymous browsing.

Quick access to camera exposure, focus, flash, zoom, front-facing camera, time-lapse, and other camera features.

Ability to view albums and other collections in full-screen mode in Gallery, with easy access to thumbnails for other photos.

New two-pane Contacts UI and Fast Scroll to let users easily organize and locate contacts.

New two-pane Email UI to make viewing and organizing messages more efficient, allowing users to select one or more messages.

Hardware acceleration.

Support for multi-core processors.

Ability to encrypt all user data.

HTTPS stack improved with Server Name Indication (SNI).

Filesystem in Userspace (FUSE; kernel module).

Disallows applications from having to write access to secondary storage (memory cards on devices with internal primary storage) outside of designated, application-specific directories. Full access to primary internal storage is still allowed through a separate application-level permission.

Android 3.0 home screen

Android 3.1 Honeycomb

Android 3.1 Honeycomb (API 12)

Version 	Release date 	Features 	Image(s)

3.1 	May 10, 2011	

UI refinements.

Connectivity for USB accessories (USB On-The-Go).

Expanded Recent Applications list.

Resizable Home screen widgets.

Support for external keyboards and pointing devices.

Support for joysticks and gamepads.

Support for FLAC audio playback.

High-performance Wi-Fi lock, maintaining high-performance Wi-Fi connections when the device screen is off.

Support for HTTP proxy for each connected Wi-Fi access point.

Android 3.2 Honeycomb

Android 3.2 Honeycomb (API 13)

Version 	Release date 	Features 	Image(s)

3.2 	July 15, 2011	

Improved hardware support, including optimizations for a wider range of tablets.

Increased ability of applications to access files on the SD card, e.g. for synchronization.

Compatibility display mode for applications that have not been optimized for tablet screen resolutions.

New display support functions, giving developers more control over display appearance on different Android devices.

3.2.1 	September 20, 2011 	

Bug fixes and minor security, stability and Wi-Fi improvements.

Update to Android Market with automatic updates and easier-to-read Terms and Conditions text.

Update to Google Books.

Improved Adobe Flash support in browser.

Improved Chinese handwriting prediction.

3.2.2 	September 30, 2011 	

Bug fixes and other minor improvements for the Motorola Xoom 4G.

3.2.4 	December 15, 2011 	

Pay As You Go for 3G and 4G tablets.

3.2.6 	February 15, 2012 	

Fixed data connectivity issues when coming out of Airplane mode on the US 4G Motorola Xoom.

### Android 4.0 Ice Cream Sandwich

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.0-Ice-cream-sandwich/Android_4.0.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.0-Ice-cream-sandwich/Android_4.0.png)

Android 4.0 Ice Cream Sandwich (API 14)

The SDK for Android 4.0.1 (Ice Cream Sandwich), based on Linux kernel 3.0.1, was publicly released on October 19, 2011. Google's Gabe Cohen stated that Android 4.0 was "theoretically compatible" with any Android 2.3.x device in production at that time. The source code for Android 4.0 became available on November 14, 2011. Ice Cream Sandwich was the last version to officially support Adobe Systems' Flash player. The update introduced numerous new features:

Version 	Release date 	Features 	Image(s)

4.0 	October 18, 2011

Major refinements to the "Holo" interface with the new Roboto font family.

Soft buttons from Android 3.x are now available for use on phones.

Separation of widgets in a new tab, listed in a similar manner to applications.

Easier-to-create folders, with a drag-and-drop style.

Improved visual voicemail with the ability to speed up or slow down voicemail messages.

Pinch-to-zoom functionality in the Calendar.

Integrated screenshot capture (accomplished by holding down the Power and Volume-Down buttons).

Improved error correction on the keyboard.

Ability to access applications directly from the lock screen.

Improved copy-and-paste functionality.

Better voice integration and continuous, real-time speech-to-text dictation.

Face Unlock, a feature that allows users to unlock handsets using facial recognition software.

Automatic syncing of browser with users' Chrome bookmarks.

Data Usage section in settings that lets users set warnings when they approach a certain usage limit, and disable data use when the limit is exceeded.

Ability to shut down applications from the recent apps list with a swipe.

Improved camera application with zero shutter lag, time lapse settings, panorama mode, and the ability to zoom while recording.

Built-in photo editor.

New gallery layout, organized by location and person.

Refreshed the "People" application with social network integration, status updates and hi-res images.

Android Beam, a near-field communication feature allowing the rapid short-range exchange of web bookmarks, contact info, directions, YouTube videos and other data.

Support for the WebP image format.

Hardware acceleration of the UI.

Wi-Fi Direct.

1080p video recording for stock Android devices.

Android VPN Framework (AVF), and TUN (but not TAP) kernel module. Prior to 4.0, VPN software required a rooted Android device.

4.0.1 	October 19, 2011 	

Fixed minor bugs for the Samsung Galaxy Nexus.

4.0.2 	November 28, 2011 	

Fixed minor bugs on the Verizon Galaxy Nexus, the US launch of which was later delayed until December 2011.

Android 4.0.3 Ice Cream Sandwich

Android 4.0.3 Ice Cream Sandwich (API 15)

Version 	Release date 	Features 	Image(s)

4.0.3 	December 16, 2011	

Numerous bug fixes and optimizations.

Improvements to graphics, databases, spell-checking and Bluetooth functionality.

New APIs for developers, including a social stream API in the Contacts provider.

Calendar provider enhancements.

New camera applications enhancing video stabilization and QVGA resolution.

Accessibility refinements such as improved content access for screen readers.

4.0.4 	March 28, 2012 	

Stability improvements.

Better camera performance.

Smoother screen rotation.

Improved phone number recognition.

### Android 4.1 Jelly Bean

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.1-Jelly-bean/Android_4.2_on_the_Nexus_4.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.1-Jelly-bean/Android_4.2_on_the_Nexus_4.png)

Android 4.1 Jelly Bean (API 16)

Google announced Android 4.1 (Jelly Bean) at the Google I/O conference on June 27, 2012. Based on Linux kernel 3.0.31, Jelly Bean was an incremental update with the primary aim of improving the functionality and performance of the user interface. The performance improvement involved "Project Butter", which uses touch anticipation, triple buffering, extended vsync timing and a fixed frame rate of 60 fps to create a fluid and "buttery-smooth" UI. Android 4.1 Jelly Bean was released to the Android Open Source Project on July 9, 2012, and the Nexus 7 tablet, the first device to run Jelly Bean, was released on July 13, 2012.

Version 	Release date 	Features 	Image(s)

4.1 	July 9, 2012 	

Smoother user interface:

Vsync timing across all drawing and animation done by the Android framework, including application rendering, touch events, screen composition and display refresh.

Triple buffering in the graphics pipeline.

CPU input boost.

Synchronizing touch to vsync timing.

Enhanced accessibility.

Bi-directional text and other language support.

User-installable keyboard maps.

Expandable notifications.

TLS v1.1 and v1.2 support added.

Ability to turn off notifications on an application-specific basis.

Shortcuts and widgets can automatically be re-arranged or re-sized to allow new items to fit on home screens.

Bluetooth data transfer for Android Beam.

Tablets with smaller screens now use an expanded version of the interface layout and home screen used by phones.

Improved camera application.

Multichannel audio.

The Fraunhofer FDK AAC codec becomes standard in Android, adding AAC 5.1 channel encoding/decoding.

USB audio (for external sound DACs).

Audio chaining (also known as gapless playback).

Ability for other launchers to add widgets from the application drawer without requiring root access.

4.1.1 	July 9, 2012 	

Fixed a bug on the Nexus 7 regarding the inability to change screen orientation in any application.

4.1.2 	October 9, 2012 	

Lock/home screen rotation support.

One-finger gestures to expand/collapse notifications.

Bug fixes and performance enhancements.

Android 4.2 Jelly Bean

Android 4.2 Jelly Bean (API 17)

Google was expected to announce Jelly Bean 4.2 at an event in New York City on October 29, 2012, but the event was cancelled due to Hurricane Sandy. Instead of rescheduling the live event, Google announced the new version with a press release, under the slogan "A new flavor of Jelly Bean". Jelly Bean 4.2 was based on Linux kernel 3.4.0, and debuted on Google's Nexus 4 and Nexus 10, which were released on November 13, 2012.

Version 	Release date 	Features

4.2 	November 13, 2012

Lock screen improvements, including widget support (removed again in 2014) and the ability to swipe directly to the camera.

Notification power controls ("Quick Settings").

"Daydream" screensavers, showing information when idle or docked (later renamed to "screen saver" following the launch of the unrelated Google Daydream VR platform in 2016).

Multiple user accounts (tablets only).

Rewritten Bluetooth stack, switching from Bluez to Broadcom open source BlueDroid, allowing improved support for multiple displays and wireless display (Miracast).

Native right-to-left, always-on VPN and application verification. A new NFC stack was added at the same time.

Accessibility improvements: triple-tap to magnify the entire screen, pan and zoom with two fingers. Speech output and Gesture Mode navigation for blind users.

New clock application with a built-in world clock, stop watch and timer.

All devices now use the same interface layout, previously adapted from phones on 4.1 for smaller tablets (with centered software buttons, the system bar at the top of the screen, and a home screen with a dock and centered application menu), regardless of screen size.

Increased number of extended notifications and Actionable Notifications for more applications, allowing users to respond to certain notifications within the notification bar and without launching the application directly.

SELinux support.

Premium SMS confirmation.

Group Messaging support.

4.2.1 	November 27, 2012 	

Fixed a bug in the People application where December was not displayed on the date selector when adding an event to a contact.

Added Bluetooth gamepads and joysticks as supported HIDs (Human interface devices).

4.2.2 	February 11, 2013 	

Fixed Bluetooth audio streaming bugs.

Long-pressing the Wi-Fi and Bluetooth icons in Quick Settings now toggles the on/off state.

New download notifications, which now show the percentage and estimated time remaining for active application downloads.

New sounds for wireless charging and low battery.

New Gallery application animation allows faster loading.

USB debug whitelist.

Bug fixes and performance enhancements.

Android 4.3 Jelly Bean

Android 4.3 Jelly Bean (API 18)

Google released Jelly Bean 4.3 under the slogan "An even sweeter Jelly Bean" on July 24, 2013, during an event in San Francisco called "Breakfast with Sundar Pichai". Most Nexus devices received the update within a week, although the second-generation Nexus 7 tablet was the first device to officially ship with it. A minor bug fix update was released on August 22, 2013.

Version 	Release date 	Features

4.3 	July 24, 2013	

Bluetooth low energy support.

Bluetooth Audio/Video Remote Control Profile (AVRCP) 1.3 support.

OpenGL ES 3.0 support, allowing improved game graphics.

Restricted access mode for new user profiles.

Filesystem performance improvement by running the fstrim command while a device is idle.

Dial pad auto-complete in the Phone application.

Volume for incoming calls (ringtone) and notification alerts is no longer adjustable separately.

Improvements to Photo Sphere.

Reworked camera UI, previously introduced on Google Play edition phones.

Addition of "App Ops", a fine-grained application permissions control system (hidden by default).

SELinux enabled by default.

4K resolution support.

Numerous security updates, performance enhancements, and bug fixes.

System-level support for geofencing and Wi-Fi scanning APIs.

Background Wi-Fi location still runs even when Wi-Fi is turned off.

Developer logging and analyzing enhancements.

Added support for five more languages.

Changed digital rights management (DRM) APIs.

Right-to-left (RTL) languages now supported.

Clock in the status bar disappears if it is selected as a lockscreen widget.

Native emoji support.

4.3.1 	October 3, 2013	

Bug fixes and small tweaks for the Nexus 7 LTE.

### Android 4.4 KitKat

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.4-KitKat/Nexus_5_(Android_4.4.2)_Screenshot.jpg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.4-KitKat/Nexus_5_(Android_4.4.2)_Screenshot.jpg)

Android 4.4 KitKat (API 19)

Google announced Android 4.4 KitKat on September 3, 2013. Although initially under the "Key Lime Pie" ("KLP") codename, the name was changed because "very few people actually know the taste of a key lime pie." Some technology bloggers also expected the "Key Lime Pie" release to be Android 5. KitKat debuted on Google's Nexus 5 on October 31, 2013, and was optimized to run on a greater range of devices than earlier Android versions, having 512 MB of RAM as a recommended minimum; those improvements were known as "Project Svelte" internally at Google. The required minimum amount of RAM available to Android is 340 MB, and all devices with less than 512 MB of RAM must report themselves as "low RAM" devices.

Version 	Release date 	Features 	Image(s)

4.4 	October 31, 2013	

Refreshed interface with white elements instead of blue.

Clock no longer shows bold hours; all digits are thin. The H, M, and S markings for the stopwatch and timer have been removed, leaving just the numbers.

Ability for applications to trigger translucency in the navigation and status bars.

Ability for applications to use "immersive mode" to keep the navigation and status bars hidden while maintaining user interaction.

Action overflow menu buttons are always visible, even on devices with a "Menu" key, which was officially deprecated by Android 4.0.

Write access disabled for user-installed applications on external storage (i.e. MicroSD), except for their own directories inside Android/data.

Purging of app data directories in user storage (internal user storage and MicroSD) upon uninstallation

Optimizations for performance on devices with lower specifications, including zRAM support and "low RAM" device API.

Wireless printing capability.

NFC host card emulation, enabling a device to replace smart cards.

WebViews are now based on the Chromium engine (feature parity with Chrome for Android 30).

Expanded functionality for notification listener services.

Public API for developing and managing text messaging clients.

Storage Access Framework, an API allowing apps to retrieve files in a consistent manner. As part of the framework, a new system file picker allows users to access files from various sources (including those exposed by apps, such as online storage services).

New framework for UI transitions.

Sensor batching, step detector and counter APIs.

Settings application now makes it possible to select default text messaging and the home (launcher) application.

Audio tunneling, audio monitoring and loudness enhancer.

Built-in screen recording feature (primarily for developers, as usage of ADB is required).

Native infrared blaster API.

Verified boot.

Enforcing SELinux.

Expanded accessibility APIs and system-level closed captioning settings.

Android Runtime (ART) introduced as a new experimental application runtime environment, not enabled by default, as a replacement for the Dalvik virtual machine.

Bluetooth Message Access Profile (MAP) support.

Disabled access to battery statistics by third-party applications.

Settings application no longer uses a multi-pane layout on devices with larger screens.

Wi-Fi and mobile data activity (TX/RX) indicators are moved to quick settings.

Disables text wrapping in the WebView browser component.

Nexus 5 (Android 4.4.2) Screenshot.jpg

Android 4.4 home screen

4.4.1 	December 5, 2013	

Better application compatibility for the experimental Android Runtime (ART).

Camera application now loads Google+ Photos instead of Gallery when swiping away from the camera view.

Miscellaneous improvements and bug fixes.

4.4.2 	December 9, 2013	

Further security enhancements and bug fixes.

Removal of the "App Ops" application permissions control system, introduced in Android 4.3.

4.4.3 	June 2, 2014

Refreshed the Dialer app's interface.

Updated the Chromium-based WebView to version 33 (screencasting to DevTools, HTML5 Canvas hardware acceleration performance improvements, vibration API, HTML5 form validation, and an HTML5 datalist).

Miscellaneous improvements and bug fixes.

4.4.4 	June 19, 2014	

CVE-2014-0224 fixed, eliminating an OpenSSL man-in-the-middle vulnerability.

Android 4.4W KitKat, with wearable extensions

Android 4.4W KitKat, with wearable extensions (API 20)

On June 24, 2014, a version of Android KitKat exclusive to Android Wear devices was released.

Version 	Release date 	Features

4.4W 	June 25, 2014 	

Initial release of the Android Wear platform for smartwatches: the same as Android 4.4 "KitKat", but with wearable extensions added.

4.4W.1 	September 6, 2014	

UI updates for Google Maps navigation and alarms.

4.4W.2 	October 21, 2014

Offline music playback.

GPS support.

### Android 5.0 Lollipop

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/5.0-Lollipop/Android_5.0-en.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/5.0-Lollipop/Android_5.0-en.png)

Android 5.0 Lollipop (API 21)

Android 5.0 "Lollipop" was unveiled under the codename "Android L" on June 25, 2014, during Google I/O. It became available as an official over-the-air (OTA) update on November 12, 2014, for select devices that run distributions of Android serviced by Google, including Nexus and Google Play edition devices. Its source code was made available on November 3, 2014.

Lollipop features a redesigned user interface built around a responsive design language referred to as "material design". Other changes include improvements to the notifications, which can be accessed from the lockscreen and displayed within applications as top-of-the-screen banners. Furthermore, Google made internal changes to the platform, with the Android Runtime (ART) officially replacing Dalvik for improved application performance, and with changes intended to improve and optimize battery usage, known internally as Project Volta.

Version 	Release date 	Features 	Image(s)

5.0 	November 04, 2014	

Android Runtime (ART) with ahead-of-time (AOT) compilation and improved garbage collection (GC), replacing Dalvik that combines bytecode interpretation with trace-based just-in-time (JIT) compilation.

Support for 64-bit CPUs.

OpenGL ES 3.1 and Android Extension Pack (AEP) on supported GPU configurations.

Recent activities screen with tasks instead of applications, up to a configured maximum of tasks per application.

Vector drawables, which scale without losing definition.

Support for print previews.

Material design, bringing a restyled user interface and “ripple effect” for buttons.

Refreshed lock screen, no longer supporting widgets.

Refreshed notification tray and quick settings pull-down.

Project Volta, for battery life improvements.

Searches can be performed within the system settings for quicker access to particular settings.

Lock screen provides shortcuts to application and notification settings.

Guest logins and multiple user accounts are available on more devices, such as phones.

Audio input and output through USB devices.

Third-party applications regain the ability to read and modify data located anywhere on external storage, such as on SD cards. However, those must be adapted to the storage access framework of Android API level 21 or higher.

Pinning of an application's screen for restricted user activity.

Recently used applications are remembered even after restarting the device.

WebViews receive updates independently through Google Play for security reasons, instead of relying on system-wide vendor updates.

Addition of 15 new languages: Basque, Bengali, Burmese, Chinese (Hong Kong), Galician, Icelandic, Kannada, Kyrgyz, Macedonian, Malayalam, Marathi, Nepali, Sinhala, Tamil and Telugu.

Tap and Go allows users to quickly migrate to a new Android device, using NFC and Bluetooth to transfer Google Account details, configuration settings, user data and installed applications.

A flashlight-style application is included, working on supported devices with a camera flash.

User-customizable priorities for application notifications.

Smart lock feature.

SELinux in enforcing mode for all domains.

Updated emoji.

Improved accessibility support (e.g. switch access support).

Block-based over-the-air (OTA) updates for new devices.

Task listing access disabled for third-party applications.

5.0.1 	December 2, 2014

A few bug fixes, including resolving issues with video playback and password failures handling.

5.0.2 	December 19, 2014	

Fixes a bug with TRIM support (introduced in Version 4.3), which prevented devices from running on-charger cleanups of file system allocations if the device was turned off at midnight, or if it was charged only when in use.

Changes how alarms wake the CPU, and how alarms compete for system resources.

Android 5.1 Lollipop

Android 5.1 Lollipop (API 22)

Version 	Release date 	Features 	Image(s)

5.1 	March 2, 2015	

Improvements and bug fixes to the Overview screen.

Ability to join Wi-Fi networks and control paired Bluetooth devices from quick settings.

Official support for multiple SIM cards.

Device protection: if a device is lost or stolen it will remain locked until the owner signs into their Google account, even if the device is reset to factory settings.

High-definition voice calls, available between compatible 4G LTE devices running Android 5.1.

Improvements to the notification priority system, to more closely replicate the silent mode that was removed from Android 5.0.

5.1.1 	April 20, 2015	

Various bug fixes

Native Wi-Fi calling support

### Android 6.0 Marshmallow

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/6.0-Marshmallow/Android_6.0-en.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/6.0-Marshmallow/Android_6.0-en.png)

Android 6.0 Marshmallow (API 23)

Android 6.0 "Marshmallow" was unveiled under the codename "Android M" during Google I/O on May 28, 2015, for the Nexus 5 and Nexus 6 phones, Nexus 9 tablet, and Nexus Player set-top box, under the build number MPZ44Q. The third developer preview (MPA44G) was released on August 17, 2015 for the Nexus 5, Nexus 6, Nexus 9 and Nexus Player devices, and was updated to MPA44I that brought fixes related to Android for Work profiles.

Version 	Release date 	Features 	Image(s)

6.0 	October 2, 2015	

Precluded rudimentary file manager (package name: com.android.documentsui), accessible from storage settings.

Memory card mounted to /storage/????-????/ rather than /storage/extSdCard/, with a hexadecimal volume serial number in place of the wildcard the question marks.

Contextual search from keywords within apps.

Introduction of Doze mode, which reduces CPU speed while the screen is off in order to save battery life.

App Standby feature.

Alphabetically accessible vertical application drawer.

Application search bar and favorites.

Native fingerprint reader support.

Direct Share feature for target-specific sharing between apps.

Renamed "Priority" mode to "Do Not Disturb" mode.

App Linking for faster instinctive opening of links with corresponding applications.

Larger Application folders with multiple pages.

Post-install/run-time permission requests.

USB-C support.

Demo Mode feature for screenshot-capture usage.

Automatic full data backup and restore for apps.

4K display mode for apps.

Adoptable External storage to behave like Internal Storage.

MIDI support for musical instruments.

Experimental multi-window feature.

Support for actions by third-party apps in the text selection menu.

App permissions now granted individually at run-time, not all-or-nothing at install time. Similar to App Ops.

Miracast support dropped.

Many new essential commands supported by Android's Linux shell (/bin/sh).

No screen rotation during touch.

6.0.1 	December 7, 2015

Unicode 7.0 & 8.0 emoji support.

Descriptions for USB connection options.

Double-press the power button to open the camera.

### Android 7.0 Nougat

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_7.0-en.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_7.0-en.png)

Android 7.0 Nougat (API 24)

Android "Nougat" (codenamed N in-development) is the seventh major release of the Android operating system. It was first released as a developer preview on March 9, 2016, with factory images for supported Nexus devices, as well as with the new "Android Beta Program" which allows supported devices to be upgraded directly to the Android Nougat beta via an over-the-air update. The final release was on August 22, 2016. The final preview build was released on July 18, 2016,[253] with the build number NPD90G.

Version 	Release date 	Features 	Image(s)

7.0 	August 22, 2016	

Support for file-based encryption.

Unicode 9.0 emoji and skin tone modifier support (and exposes a subset of ICU4J APIs).

Ability to display color calibration.

Ability to zoom in the screen.

Ability to switch to the last opened app by double-tapping the overview button.

Added an Emergency information part.

Added the "Clear All" button to the Overview screen.

Another system partition, which gets updated when not in use, allowing for seamless system updates.

Daydream virtual reality platform (VR interface).

Improved Doze functionality, which aims to prolong battery life.

Improvements to the file browser.

Ability to move files added to Storage Access Framework

More Quick Settings options.

Multi-window support, which supports floating apps on a desktop layout.

New Data Saver mode, which can force apps to reduce bandwidth usage.

New JIT Compiler, making for 75 percent faster app installations and a 50 percent reduction in compiled code size.

Just in Time (JIT) compiler with code profiling to ART, which lets it constantly improve the performance of Android apps as they run.

Picture-in-picture support for Android TV.

Redesigned notification shade, featuring instant access to certain settings.

Redesigned Overview screen.

Replaced notification cards with notification sheets.

Settings app navigation drawer.

Vulkan 3D rendering API.

Multiple Device Locales

Discontinuation of Android Camera V1 API

Restricted file system access

Android 7.1 Nougat

Android 7.1 Nougat (API 25)

On October 19, 2016, Google released Android 7.1.1 as a developer preview for the Nexus 5X, Nexus 6P and the Pixel C. A second preview became available on November 22, 2016, before the final version was released to the public on December 5, 2016.

Version 	Release date 	Features 	Image(s)

7.1 	October 4, 2016 	

Rearranged notification shade.

"Restart" option added to power button menu

Touch/display performance improvements.

Moves (Fingerprint swipe down gesture – opt-in).

Opt-in with new hardware required:

Seamless A/B system updates.

Daydream VR mode.

Developer features:

Shortcut manager APIs.

Circular app icons support.

Keyboard image insertion.

Fingerprint sensor gesture to open/close notification shade.

Manual storage manager Intent for apps.

Improved VR thread scheduling.

Enhanced wallpaper metadata.

Multi-endpoint call support.

Support for various MNO requirements.

PCDMA voice privacy property.

Source type support for Visual Voicemail.

Carrier config options for managing telephone videos.

Manual storage manager – identifies files and apps using storage.

7.1.1 	December 1, 2016	

New set of emojis adding different skin tones and haircuts to existing ones.

Send GIFs directly from the default keyboard.

App shortcuts: Launch actions on apps by long-pressing the app icon.

Developer Options: Show CPU Usage feature removed.

7.1.2 	April 2, 2017 	

Battery usage alerts.

### Android 8.0 Oreo

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_8.1_screenshot.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_8.1_screenshot.png)

Android 8.0 Oreo (API 26)

Android Oreo is the eighth major release of the Android operating system. It was first released as a developer preview, codenamed Android O, on March 21, 2017, with factory images for supported Nexus and Pixel devices. The final developer preview was released on July 24, 2017, with the stable version released in August 2017.

Version 	Release date 	Features 	Image(s)

8.0 	August 21, 2017 	

Project Treble, the biggest change to the foundations of Android to date: a modular architecture that makes it easier and faster for hardware makers to deliver Android updates.

Picture-in-picture support.

Support for Unicode 10.0 emoji (5.0) and replacement of all blob-shaped emojis by round ones with gradients and outlines.

Redesigned Quick Settings and Settings with a white background and respectively black and Accent font colors.

Restructured Settings by regrouping sections into similar entries.

Adaptive icons

Notification improvements.

Notification channels.

Notification dots (badges).

Notification snoozing.

Notification shade multi-colors (for music album art, messengers, etc.).

System-wide Autofill framework.

Support for AAC, Sony's LDAC and Qualcomm's aptX and aptX HD codecs.

App-specific unknown sources.

Multi-display support.

2 times faster boot time compared to Nougat according to Google, testing on their Pixel devices.

Apps background execution and location limits.

Google Play Protect.

Downloadable fonts.

Integrated printing support.

Color management (deep color and wide color gamut).

Wi-Fi Assistant.

Android 8.1.0 Oreo

Android 8.1.0 Oreo (API 27)

Android 8.1 Oreo is the sixteenth minor release of the Android operating system. It was first released as a developer preview on October 25, 2017, with factory images for current Nexus and Pixel devices. A second developer preview was made available on November 27, 2017, for Nexus and Pixel devices, before the stable version was released on December 5, 2017.

Version 	Release date 	Features 	Image(s)

8.1.0	December 5, 2017

Neural networks API.

Shared memory API.

WallpaperColors API.

Bluetooth battery level for connected devices, accessible in Quick Settings.

Android Oreo Go Edition, a lightweight distribution of Android that runs better than normal Android on devices with less than 1 GB of RAM.

Autofill framework updates.

Programmatic Safe Browsing actions.

Navigation buttons dim when not in use.

Visual changes to 'Power Off' and 'Restart', including a new screen and floating toolbar.

Toast messages are now white with the same existing transparency.

Automatic light and dark themes.

New Easter egg in the form of an official Oreo cookie picture.

### Android 9 Pie

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/9.0-Pie/Android_Pie.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/9.0-Pie/Android_Pie.png)

Android 9 Pie (API 28)

Android Pie is the ninth major version of the Android operating system. It was first announced by Google on March 7, 2018, and the first developer preview was released on the same day. The second preview, considered beta quality, was released on May 8, 2018. The final beta of Android Pie (fifth preview, also considered as a "Release Candidate") was released on July 25, 2018. The first official release was released on August 6, 2018.

Version 	Release date 	Features 	Image(s)

9 	August 6, 2018 	

New user interface for the quick settings menu.

The clock has moved to the left of the notification bar.

The "dock" now has a semi-transparent background.

Battery Saver no longer shows an orange overlay on the notification and status bars.

A "screenshot" button has been added to the power options.

A new "Lockdown" mode which disables biometric authentication once activated.

Rounded corners across the UI.

New transitions for switching between apps, or activities within apps.

Richer messaging notifications, where a full conversation can be seen within a notification, full-scale images, and smart replies akin to Google's new app, Reply.

Support for display cutouts.

Redesigned volume slider.

Battery percentage now shown in Always-On Display.

Lock screen security changes include the possible return of an improved NFC Unlock.

Experimental features (which are currently hidden within a menu called Feature Flags) such as a redesigned About Phone page in settings, and automatic Bluetooth enabling while driving.

DNS over TLS.

A new optional gesture-based system interface, allowing users to navigate the OS using swipes more often than the traditional UI.

Redesigned multitask app switcher with the Google search bar and app drawer built-in.

Android Dashboard, which tells the user how much time they are spending on their device and in apps, and allows the user to set time limits on apps.

"Shush", an enhanced version of Do Not Disturb mode activated by placing the phone face down, which mutes standard notifications.

"Adaptive Battery" prediction, which makes use of Doze to hibernate user apps the OS determines the user will not use.

Auto-Brightness feature modifies screen brightness based on user habits.

Wind Down option lets Android users set a specific bedtime that enables Do Not Disturb and turns the entire phone's interface gray to discourage further use at night.

Vulkan 1.1 support.

Call recording options fully disabled

### Android 10

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/10.0/Android_10_screenshot.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/10.0/Android_10_screenshot.png)

Android 10 (API 29)

Android 10 is the tenth major version of the Android operating system. The stable version of Android 10 was released on September 3, 2019.

Version 	Release date 	Features 	Image(s)

10 	September 3, 2019 	

Revamped full-screen gesture navigation with new app open/close animations.

Scoped storage restrictions

New permissions required to access location in background and to access photo, video and audio files.

Background apps can no longer jump into the foreground.

Limited access to non-resettable device identifiers.

Background (idle) access to camera, microphone and sensors disabled for more privacy protection with the side effect of disabling antitheft software.

Sharing shortcuts, which allow sharing content with a contact directly.

Floating settings panel, that allows changing system settings directly from apps.

Dynamic depth format for photos, which allow changing background blur after taking a photo.

Support for the AV1 video codec, the HDR10+ video format and the Opus audio codec.

Support for aptX Adaptive, LHDC, LLAC, CELT and AAC LATM codecs

A native MIDI API, allowing interaction with music controllers.

Better support for biometric authentication in apps.

Support for the WPA3 Wi-Fi security protocol.

Support for foldable phones.

Support for Notification Bubbles.

New system-wide dark theme/mode

TLS v1.3 support added.

Project Mainline, allows core OS components to be updated via the Google Play Store, without requiring a complete system update[295]

### Android 11

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Pixel_4a_Android_11_Launcher.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Pixel_4a_Android_11_Launcher.png)

Android 11 (API 30)

Android 11 is the eleventh major version of the Android operating system. It was first announced by Google on February 19, 2020, and the first developer preview released on the same day.

Android 11 Beta was postponed from being launched on June 3, 2020 to June 10, 2020.

Version 	Release date 	Features 	Image(s)

11 	September 8, 2020 	

Chat bubbles.

Screen recorder.

Notification history.

New permissions controls.

API distinction between standalone 5G NR and non-standalone 5G.

One-time permission

Permissions auto-reset.

Wireless Android Auto on devices with 5GHz Wi-Fi.

Increased number of updatable core OS components in Google Play from 12 to 21.

Enterprise work profile privacy protections now apply on company-owned devices.

Independent left and right edge sensitivity for gesture navigation.

### Android 12

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/12.0/%EC%95%88%EB%93%9C%EB%A1%9C%EC%9D%B4%EB%93%9C_12_%ED%99%88%ED%99%94%EB%A9%B4.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/12.0/%EC%95%88%EB%93%9C%EB%A1%9C%EC%9D%B4%EB%93%9C_12_%ED%99%88%ED%99%94%EB%A9%B4.png)

Android 12 (API 31)

Android 12 is the twelfth major version of the Android operating system. It was first announced by Google on February 18, 2021, and the first developer preview released on the same day.

Version 	Release date 	Features 	Image(s)

12 	October 4, 2021 	

Easier Wi-Fi sharing.

AVIF image support.

Material You, an updated design language based on Material Design.

Android Runtime (ART) module added to the updatable core OS components via Google Play, added functionality to existing modules.

Gestures can work in immersive mode.

Performance improvements to system services to improve transitions, power efficiency, and reduce app startup times.

## Hardware requirements

The main hardware platform for Android is the ARM architecture (ARMv7 and ARMv8-A architectures; formerly also ARMv5), with x86 and MIPS architectures also officially supported in later versions of Android, but MIPS support has since been deprecated and support was removed in NDK r17.

Android 1.0 through 1.5 required a 2 megapixel camera with autofocus camera. This was relaxed to a fixed-focus camera with Android 1.6.

In 2012, Android devices with Intel processors began to appear, including phones[314] and tablets. While gaining support for 64-bit platforms, Android was first made to run on 64-bit x86 and then on ARM64. Since Android 5.0 Lollipop, 64-bit variants of all platforms are supported in addition to the 32-bit variants.

Requirements for the minimum amount of RAM for devices running Android 7.1 depend on screen size and density and type of CPU, ranging from 816 MB–1.8 GB for 64-bit and 512 MB–1.3 GB for 32-bit meaning in practice 1 GB for the most common type of display (while minimum for Android watch is 416 MB). The recommendation for Android 4.4 is to have at least 512 MB of RAM, while for "low RAM" devices 340 MB is the required minimum amount that does not include memory dedicated to various hardware components such as the baseband processor. Android 4.4 requires a 32-bit ARMv7, MIPS or x86 architecture processor, together with an OpenGL ES 2.0 compatible graphics processing unit (GPU). Android supports OpenGL ES 1.1, 2.0, 3.0, 3.2 and since Android 7.0 Vulkan (and version 1.1 available for some devices). Some applications may explicitly require a certain version of the OpenGL ES, and suitable GPU hardware is required to run such applications. In 2021, Android was ported to RISC-V. In 2021, Qualcomm said it will support more updates.

## Alternatives

If you can't get away from Android easily, it is recommended to try and use it in a virtual machine via Android x86 and get eased into using it this way. However, the devices it runs on are still relevant (as of 2021 October 4th) here are some other alternatives to Android 12.x:

LineageOS

GrapheneOS

ReplicantOS

RemixOS (Android 5.0 and higher)

[Suggest an alternative](https://github.com/seanpm2001/Degoogle-your-life/issues/)

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android version history](https://en.wikipedia.org/wiki/Android_version_history)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 4:19 pm`

**Last revised on:** `2021 Monday, October 4th at 4:19 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `1599`

**Article language:** `English (US) / Markdown`

**Article version:** `1 (2021 Monday, October 4th at 4:19 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

