
***

# Android 9.0 (Pie)

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android Pie logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/9.0-Pie/Android_P_logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/9.0-Pie/Android_P_logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/9.0-Pie/Android_Pie.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/9.0-Pie/Android_Pie.png)

( **Preceeded by:** [Android 8.0 (Oreo)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-8-0-Oreo/) | **Succeeded by:** [Android 10.0](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-10-0/) )

**Developer:**	Google

**General availability:**	August 6, 2018

**Latest release:**	9.0.0_r72 (PSV1.210329.013) / September 8, 2021;

**Kernel type:**	Monolithic Kernel (Linux Kernel)

**Official website:**	[www.android.com/versions/pie-9-0/](https://www.android.com/versions/pie-9-0/)

**Support status:** Supported

Android Pie (codenamed Android P during development) is the ninth major release and the 16th version of the Android mobile operating system. It was first released as a developer preview on March 7, 2018, and was released publicly on August 6, 2018.

On August 6, 2018, Google officially announced the final release of Android 9 under the title "Pie", with the update initially available for current Google Pixel devices, and releases for Android One devices and others to follow "later this year". The Essential Phone was the first third-party Android device to receive an update to Pie, notably coming day-and-date with its final release. The Sony Xperia XZ3 was the first device with Android Pie pre-installed.

As of September 2021, 14.77% of Android devices run Pie (API 28), making it the third most used version of Android.

## History

Android Pie, then referred to as "Android P", was first announced by Google on March 7, 2018, and the first developer preview was released on the same day. The second preview, considered beta quality, was released on May 8, 2018. The third preview, called Beta 2, was released on June 6, 2018. The fourth preview, called Beta 3, was released on July 2, 2018. The final beta of Android P was released on July 25, 2018.

## Custom distributions

There are, as of August 2019, a handful of notable custom Android distributions (ROMs) of 9.0 Pie.

## Features

### User experience

Android Pie utilizes a refresh of Google's "material design" language, unofficially referred to as "Material Design 2.0". The revamp provides more variance in aesthetics, encouraging the creation of custom "themes" for the base guidelines and components rather than a standardized appearance. Bottom-aligned navigation bars are also more prominent. As applied to Android Pie's interface, rounded corners (influenced by the proprietary Google theme used by in-house software implementing Material Design 2.0) are more prominent. In addition, Pie contains official support for screen cutouts ("notches"), including APIs and system behaviors depending on their size and position. Android certification requirements restrict devices to two cutouts, which may only be along the top or bottom of the screen.

The most significant user interface change on Pie is a redesigned on-screen navigation bar. Unlike previous versions of Android, it only consists of a slim home button, and a back button rendered only when available. The bar utilizes gesture navigation: swiping up opens the "Overview" screen, a redesign of the existing recent apps menu. Swiping the handle to the right activates application switching. The gesture bar is used primarily on new devices such as the Pixel 3; existing devices may either use the previous navigation key setup or offer the ability to opt into gesture navigation. As opposed to the previous recent apps menu, Overview utilizes a horizontal layout rather than vertical, and text may also be selected and copied from apps appearing there (although this uses OCR rather than the native text as to conserve resources). The Pixel Launcher exclusively supports the ability to access the app drawer and most recently used apps from the overview as well. However, this integration is proprietary, as there are no current plans to offer the necessary integration to third-party software due to security concerns. In addition, when rotation lock is enabled, rotating the device causes a screen rotation button to appear on the navigation bar.

The notification area was redesigned, with the clock moved to the left, and the number of icons that may be displayed at once limited to four, in order to accommodate displays that may have "notch" cutouts in the center. The drop-down panels attached to quick settings items have been removed; long-pressing a toggle directs users to the relevant settings screen. Notifications for chats can now be threaded, displaying previous messages within (complementing the existing inline reply functionality). If a particular type of notification is frequently dismissed, the user will now be offered to disable it. The Do Not Disturb mode has been overhauled with a larger array of settings.

The power menu now contains a screenshot button (which itself now supports cropping an image after taking one), and an optional "lockdown" mode that disables biometric unlock methods. The volume pop-up now only controls media volume, as well as the choice of sound, vibrate, or silent modes for notifications. Users are directed to the settings menu to change the volume of notifications. A magnifier display has been added to text selection, and "smart linkify" offers access to relevant apps if particular types of text (such as phone numbers or addresses) are highlighted.

### Platform

Android Pie introduces a major change to power management, using algorithms to prioritize background activity by apps based on long-term usage patterns and predictions, dividing apps into "Active", "Working Set" (run often), "Frequent", "Rare", and "Never". Similar "adaptive brightness" settings are adjusted automatically based on detected lighting conditions. Both of these features were developed in collaboration with DeepMind.

The "PrecomputedText" API (also available as a compatibility library compatible with Android 4.0 and newer) can be used to perform text display processing in a background thread as opposed to a UI thread to improve performance.

The fingerprint authentication API has also been revamped to account for different types of biometric authentication experiences (including face scanning and in-screen fingerprint readers).

Android Runtime can now create compressed bytecode files, and profiler data can be uploaded to Google Play servers to be bundled with apps when downloaded by users with a similar device.

Apps targeting older Android API levels (beginning with Android 4.2) display a warning when launched. Google Play Store is now requiring all apps to target an API level released within the past year, and will also mandate 64-bit support in 2019.

Android Pie supports IEEE 802.11mc, including Wi-Fi Round Trip Time for location positioning.

The camera API now supports accessing multiple cameras at once. Apps may no longer perform background audio or video recording unless they run a foreground service. There is support for the High Efficiency Image File Format (subject to patent licensing and hardware support) and VP9 Profile 2.

DNS over TLS is supported under the name "Private DNS".

Android Go for Android Pie uses less storage than the previous release, and has enhancements to security and storage tracking.

## Reception

Shortly after its launch, several users on Pixel devices and the Essential Phone noted a decrease in battery life. As Android Pie became available to more phones, some users on various devices reported similar comparisons.

***

## Alternatives

Android 9.x is aging, and it is recommended to use it in a virtual machine via Android x86. However, the devices it runs on are still relevant (as of 2021 October 4th) here are some other alternatives to Android 9.x:

LineageOS

GrapheneOS

ReplicantOS

RemixOS (Android 5.0 and higher)

[Suggest an alternative](https://github.com/seanpm2001/Degoogle-your-life/issues/)

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android Pie](https://en.wikipedia.org/wiki/Android_Pie)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 2:50 pm`

**Last revised on:** `2021 Monday, October 4th at 2:50 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `127`

**Article language:** `English (US) / Markdown`

**Article version:** `1 (2021 Monday, October 4th at 2:50 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

