
***

# Android 8.0 (Oreo)

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android Oreo logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_8.1_logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_8.1_logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_8.1_screenshot.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_8.1_screenshot.png)

( **Preceeded by:** [Android 7.0 (Nougat)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-7-0-Nougat/) | **Succeeded by:** [Android 9.0 (Pie)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-9-0-Pie/) )

**Developer:**	Google

**General availability:**	August 21, 2017;

**Latest release:**	8.1.0_r92 (OSN1.210329.013) /

**Kernel type:**	Monolithic Kernel (Linux Kernel)

**Official website:**	www.android.com/versions/oreo-8-0/

**Support status:** Android 8.0 Unsupported / Android 8.1 Supported

Android Oreo (codenamed Android O during development) is the eighth major release and the 15th version of the Android mobile operating system. It was first released as an alpha quality developer preview in March 2017 and released to the public on August 21, 2017.

It contains a number of major features, including notification grouping, picture-in-picture support for video, performance improvements, and battery usage optimization, and support for autofillers, Bluetooth 5, system-level integration with VoIP apps, wide color gamuts, and Wi-Fi Aware. Android Oreo also introduces two major platform features: Android Go – a software distribution of the operating system for low-end devices – and support for implementing a hardware abstraction layer.

As of August 2021, 11.63% of Android devices run Oreo, with 3.55% on Android 8.0 (API 26) and 8.08% using Android 8.1 (API 27).

## History

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/8.0-Oreo/Android_Oreo_logo.svg)

_Android O 8.0 logo_

### Android 8.0 home screen

Android Oreo was internally codenamed "Oatmeal Cookie." On March 21, 2017, Google released the first developer preview of Android "O", available for the Nexus 5X, Nexus 6P, Nexus Player, Pixel C, and both Pixel smartphones. The second, considered beta quality, was released on May 17, 2017. The third developer preview was released on June 8, 2017 and offered a finalized version of the API. DP3 finalized the release's API to API level 26, changed the camera UI, reverted the Wi-Fi and cellular connectivity levels in the status bar back to Wi-Fi being on the left, added themed notifications, added a battery animation in Settings: Battery, a new icon and darker background for the Clock app, and a teardrop icon shape for apps.

On July 24, 2017, a fourth developer preview was released which included the final system behaviors and the latest bug fixes and optimizations. Android "O" was officially released on August 21, 2017 under the name "Oreo". Its lawn statue was unveiled at a promotional event across from Chelsea Market in New York City—a building which formerly housed a Nabisco factory where Oreo cookies were first produced. Factory images were made available for compatible Pixel and Nexus devices later that day. The Sony Xperia XZ1 and Sony Xperia XZ1 Compact were the first devices available with Oreo pre-installed.

Android 8.1 was released in December 2017 for Pixel and Nexus devices, which features minor bug fixes and user interface changes.

## Features

### User experience

Notifications can be snoozed, and batched into topic-based groups known as "channels". The 'Major Ongoing' feature orders the alerts by priority, pinning the most important application to the top slot.[19] Android Oreo contains integrated support for picture-in-picture modes (supported in the YouTube app for YouTube Premium subscribers). The "Settings" app features a new design which has been reduced in size, with a white theme and deeper categorization of different settings, while its ringtone, alarm and notification sound settings now contain an option for adding custom sounds to the list.

The Android 8.1 update supports the display of battery percentages for connected Bluetooth devices, makes the notification shade slightly translucent, and dims the on-screen navigation keys in order to reduce the possibility of burn-in.

### Platform

Android Oreo adds support for Neighborhood Aware Networking (NAN) for Wi-Fi based on Wi-Fi Aware,[29] Bluetooth 5,[30] wide color gamuts in apps,[31] an API for autofillers, multiprocess and Google Browsing support for WebViews, an API to allow system-level integration for VoIP apps, and launching activities on remote displays Android Runtime (ART) features performance improvements.[6] Android Oreo contains additional limits on apps' background activities in order to improve battery life.[32] Apps can specify "adaptive icons" for differently-shaped containers specified by themes, such as circles, squares, and squircles.[33]

Android Oreo adds native support for Advanced Audio Coding, aptX, aptX HD and LDAC Bluetooth codecs.[34] Android Oreo supports new emoji that were included in the Unicode 10 standard. A new emoji font was also introduced, which notably redesigns its face figures to use a traditional circular shape, as opposed to the "blob" design that was introduced on KitKat.

The underlying architecture of Android was revised so that low-level, vendor-specific code for supporting a device's hardware can be separated from the Android OS framework using a hardware abstraction layer known as the "vendor interface". Vendor interfaces must be made forward compatible with future versions of Android. This new architecture, called Project Treble, allows the quicker development and deployment of Android updates for devices, as vendors would only need to make the necessary modifications to their bundled software. All devices shipping with Oreo must support a vendor interface, but this feature is optional for devices being updated to Oreo from an earlier version. The "seamless updates" system introduced in Android 7.0 was also modified to download update files directly to the system partition, rather than requiring them to be downloaded to the user partition first. This reduces storage space requirements for system updates.[41]

Android Oreo introduces a new automatic repair system known as "Rescue Party"; if the operating system detects that core system components are persistently crashing during startup, it will automatically perform a series of escalating repair steps. If all automatic repair steps are exhausted, the device will reboot into recovery mode and offer to perform a factory reset.

The Android 8.1 update also introduces a neural network API, which is designed to "[provide] apps with hardware acceleration for on-device machine learning operations." This API is designed for use with machine learning platforms such as TensorFlow Lite, and specialized co-processors such as the Pixel Visual Core (featured in Google's Pixel 2 smartphones, but dormant until 8.1 is installed), but it also provides a CPU fallback mode.

### Android Go

A tailored distribution for low-end devices known as Android Go was unveiled for Oreo; it is intended for devices with 1 GB of RAM or less. This mode has platform optimizations designed to reduce mobile data usage (including enabling Data Saver mode by default), and a special suite of Google Mobile Services designed to be less resource- and bandwidth-intensive. The Google Play Store would also highlight lightweight apps suited for these devices.[46][47] The operating system's interface is also modified, with the quick settings panel providing greater prominence to information regarding the battery, mobile data limit, and available storage, the recent apps menu using a modified layout and being limited to four apps (in order to reduce RAM consumption), and an API for allowing mobile carriers to implement data tracking and top-ups within the Android settings menu. Google Play Services was also modularized to reduce its memory footprint.[30]

Android Go was made available to OEMs for Android 8.1.

### Security

Android Oreo re-brands automatic scanning of Google Play Store and sideloaded apps as "Google Play Protect", and gives the feature, as well as Find My Device (formerly Android Device Manager) higher prominence in the Security menu of the Settings app. As opposed to a single, system-wide setting for enabling the installation of apps from sources outside of the Google Play Store, this function is now implemented as a permission that can be granted to individual apps (i.e. clients for third-party app repositories such as Amazon Appstore and F-Droid). A verified boot now includes a "Rollback Protection" feature, which enforces a restriction on rolling back the device to a previous version of Android, aimed at preventing a potential thief from bypassing security measures by installing a previous version of the operating system that doesn't have them in place.

## Alternatives

Android 8.x is aging, and it is recommended to use it in a virtual machine via Android x86. However, the devices it runs on are still relevant (as of 2021 October 4th) here are some other alternatives to Android 8.x:

LineageOS

GrapheneOS

ReplicantOS

RemixOS (Android 5.0 and higher)

[Suggest an alternative](https://github.com/seanpm2001/Degoogle-your-life/issues/)

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android Oreo](https://en.wikipedia.org/wiki/Android_Oreo)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 2:40 pm`

**Last revised on:** `2021 Monday, October 4th at 2:40 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `125`

**Article language:** `English (US) / Markdown`

**Article version:** `1 (2021 Monday, October 4th at 2:40 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

