
***

# Android 7.0 (Nougat)

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android Nougat logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_Nougat_Logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_Nougat_Logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_Nougat_screenshot_20170116-070000.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_Nougat_screenshot_20170116-070000.png)

( **Preceeded by:** [Android 6.0 (Lollipop)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-6-0-Lollipop/) | **Succeeded by:** [Android 8.0 (Oreo)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-8-0-Oreo/) )

**Developer:**	Google

**General availability:**	August 22, 2016;

**Latest release:**	7.1.2_r39 (5787804) / October 4, 2019;

**Kernel type:**	Linux kernel 4.1

**Official website:**	[www.android.com/versions/nougat-7-0/](https://www.android.com/versions/nougat-7-0/)

**Support status:** Unsupported

Android Nougat (codenamed Android N during development) is the seventh major version and 14th original version of the Android operating system. First released as an alpha test version on March 9, 2016, it was officially released on August 22, 2016, with Nexus devices being the first to receive the update. The LG V20 was the first smartphone released with Nougat.

Nougat introduces notable changes to the operating system and its development platform, including the ability to display multiple apps on-screen at once in a split-screen view, support for inline replies to notifications, and an expanded Doze power-saving mode that restricts device functionality once the screen has been off for a period of time. Additionally, the platform switched to an OpenJDK-based Java environment and received support for the Vulkan graphics rendering API, and seamless system updates on supported devices.

Nougat received positive reviews. The new app notification format received particular praise; while the multitasking interface was seen as a positive change, reviewers experienced that several apps were incompatible with the feature. Critics had mixed experiences with the Doze power-saving mode, but faster app installs and tweaks to the user interface were also reviewed positively.

As of 2021, 6.66% of Android devices run Nougat (no longer receiving security updates), with 4.09% on Android 7.0 and 2.57% using Android 7.1. Relatively higher proportion is using those versions on tablets than on smartphones.

## History

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_7.0-en.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_7.0-en.png)

_Android 7.0 home screen_

The release was internally codenamed "New York Cheesecake". On March 9, 2016, ahead of the Google I/O developer conference, Google released the first alpha version of Android "N" as part of a new "Android Beta Program" intended for testing by developers and enthusiasts before official its release "this summer". The developer preview builds were compatible with only current Google Nexus devices; the 5X, 6P, 6, 9, Pixel C, and Nexus Player. The "Android Beta Program" that was introduced allowed testers to opt-in for over-the-air updates to new beta versions as they were released.

On April 13, 2016, Android N Beta Preview 2 was released. Google further discussed Android "N" during the I/O keynote on May 18, 2016, and unveiled its new virtual reality platform, Daydream. Beta Preview 3, the first preview release deemed suitable for wider public beta testing, was released at this time. Google also announced that it would hold a contest to determine the official release name of the operating system.

Beta Preview 4 was released on June 15, 2016. On June 30, 2016, Google announced that N's release name would be "Nougat"; it was also confirmed that Nougat would be version 7.0 of Android.

The final Beta Preview, 5, was released on July 18, 2016.

Android 7.0 was officially released on August 22, 2016, with the Nexus 6, 5X, 6P, 9, Nexus Player, Pixel C, and General Mobile 4G as the first devices to receive the update. Dave Burke, Android's Vice President of Engineering, stated in August 2016 that updates to Nougat would be released quarterly as maintenance releases focusing on "continued refinements and polish". On September 6, 2016, LG announced the V20, the first smartphone to ship with Nougat pre-installed. Google unveiled the first-party Pixel and Pixel XL smartphones during a hardware-focused event on October 4, 2016, with the Pixel phones replacing the Nexus series.

Updates to existing devices vary by manufacturer and carrier, and driver support for the version by the manufacturer of a device's respective system-on-chip. Major manufacturers, including HTC, Sony, and Motorola announced intents to update a range of their recent devices to Nougat. Qualcomm stated that it would not support Nougat on devices using its Snapdragon 800 and 801 system-on-chips for undisclosed reasons. Although developer preview builds of Nougat were released for the device, Sony stated that it would not upgrade the Xperia Z3 (which uses the Snapdragon 801) to the final version due to "unforeseen platform limitations". It was reported that the Google Compatibility Test Suite (whose tests must be passed in order to receive official certification) specified that all devices running Nougat must support either Vulkan or OpenGL ES 3.1 graphics APIs—neither of which are supported by the device's Adreno 330 graphics core. The Fairphone 2 is purported to be the only device with the Qualcomm Snapdragon 801 chipset to provide official support for Android 7.1.2, delivering on their effort towards increased longevity for a more sustainable device.

A post-release update known as Android 7.1 was pre-loaded onto Google's Pixel and Pixel XL smartphones released in October 2016; the new version added support for the Google Daydream VR platform, image keyboards, expanded emoji support (including male and female versions), support for actions to be displayed in menus on home screen app shortcuts, and other new features. A preview of 7.1 for existing Nexus devices was released via Android Beta Program later in the month, and officially released as Android 7.1.1 on December 5, 2016. As of 7.1.1, the Nexus 6 and Nexus 9 were considered end-of-life, and did not receive any further updates.

Android 7.1.2 was released in April 2017, providing various improvements and minor functionality improvements to Nexus and Pixel-branded devices.

## Features

### User experience

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_7.0_(Nougat)_Notification_Center.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/7.0-Nougat/Android_7.0_(Nougat)_Notification_Center.png)

_The updated notification shade on Nougat_

Nougat redesigns the notification shade, which now features a smaller row of icons for settings, replacing notification cards with a new "sheet" design, and allowing inline replies for notifications. Multiple notifications from a single app can also be "bundled", and there is greater per-app control over notifications.

A split-screen display mode was introduced for phones, in which two apps can be snapped to occupy halves of the screen. An experimental multi-window mode is also available as a hidden feature, where multiple apps can appear simultaneously on the screen in overlapping windows.

The "Doze" power saving mechanism introduced in Android Marshmallow was expanded to include a state activated when the device is running and the screen has been off for a period of time but is not stationary. In this state, network activity is restricted, and apps are granted "maintenance windows" in which they can access the network and perform background tasks. As in Marshmallow, the full Doze state is activated if the device is stationary with its screen off for a period of time. A new "Data Saver" mode restricts background mobile data usage, and can trigger internal functions in apps that are designed to reduce bandwidth usage, such as capping the quality of streaming media.

### Platform

In December 2015, Google announced that Android Nougat would switch its Java Runtime Environment from the defunct Apache Harmony to OpenJDK—the official open source implementation of the Java platform maintained by Oracle Corporation and the Java community. The Android Runtime (ART) now incorporates a profile-guided compilation system, utilizing a JIT compiler and profiling alongside its current ahead-of-time compiler to further optimize apps for a device's hardware and other conditions in the background.

Nougat introduces a system for enabling "seamless", automatic system updates, based upon and sharing some code with the implementation of similar functionality on Chrome OS. The system uses a pair of SquashFS partitions; the Android system executes from an "online" partition, while updates are applied in the background to a redundant "offline" partition. On the next boot following the installation of an update, the redundant partition is designated as active to boot into the updated OS. This system removes the requirement for the device to reboot into the system recovery environment to apply the update (which prevents the device from being used until the update is complete), and also provides a backup of the existing OS in case of failure. Google chose to enable seamless updates only for devices shipped with Nougat (or later), rather than enabling earlier devices to support the feature after repartitioning. Additionally, due to the ART changes on Nougat, apps no longer need to be re-compiled upon the first boot after a system update.

Developer Preview 2 added platform support for Vulkan, a new low-level 3D-rendering API alternative to OpenGL ES with higher graphics performance.

Nougat is the first version featuring Unicode 9.0 support, and comes with updated emoji, plus support for emoji skin tones.

Android 7.1 adds native API support for implementing image keyboards; multi-endpoint telephones; shortcut menus and rounded icon assets for apps on launchers; and support for the Google Daydream virtual reality platform. The Daydream environment includes a "sustained performance mode" to assist developers in optimizing apps to a device's thermal profile, a new head tracking algorithm which combines the input from various device sensors, and integration of system notifications into the VR user interface.

### Security

In response to the Stagefright family of bugs disclosed and fixed in 2015, several changes were made to harden the media stack against future vulnerabilities. Runtime integer overflow detection was implemented, preventing the majority of Stagefright-like programming bugs from becoming vulnerabilities, in addition to helping fix and prevent such bugs. Android's monolithic MediaServer process was redesigned to better adhere to the principle of least privilege. MediaServer is now split into several separate processes, each running in its own unprivileged sandbox, and granted only the permissions required for its task. For example, only the AudioServer can access Bluetooth, and libstagefright now runs within the MediaCodecService sandbox, which is only granted GPU access. Further constraints were placed on the media stack through seccomp.

Various mechanisms were enabled to reduce the possibility of malicious code being injected and/or executed inside the Linux kernel, including dividing kernel memory into logical segments for code and data, with page access permissions of read-only and no-execute as appropriate. The kernel was also restricted from directly accessing user space memory, and stronger stack protection was enabled in the GCC compiler to reduce stack smashing. To limit exposure of the kernel to potentially malicious code, perf was disabled by default, ioctl commands were restricted by SELinux, and seccomp-bpf was enabled to grant processes the ability to restrict system calls.

On devices shipping with Android Nougat, the "Verified Boot" policy (introduced partially on KitKat, and displaying notifications on startup on Marshmallow) must be strictly enforced. If system files are corrupted or otherwise modified, the operating system will only allow operation in a limited-use mode or will refuse to boot at all.

Android Nougat supports an alternative drive encryption scheme known as "file-based encryption". As opposed to full disk encryption, it allows less-sensitive contents of the storage—such as operating system files—to be encrypted using only a hardware key rather than requiring credentials. Sensitive user data remains encrypted using credentials. File-based encryption removes the requirement for pre-boot authentication: instead, Android boots normally without additional intervention, but access to credential-protected data is restricted until the user unlocks the device for the first time ("Direct boot"). In the meantime, background services can access data they store in the device-encrypted context (such as alarms or messaging notifications, particularly after automatic reboots due to updates or crashes) to maintain limited functionality until the user unlocks the credential-encrypted storage.

## Reception

Dieter Bohn of The Verge praised the new multitasking interface in Android Nougat, calling it "long overdue" for Android tablets. Although he initially found the implementation "confusing", he wrote that it worked well once he understood it properly, though he noted that "some apps don’t fully support split screen, while others work fine but pop up a warning anyway". Bohn also liked the new way to reply to any message notification, stating "Android has long had an advantage in useful and consistent notifications" versus iOS, and added "now that quick replies are standard on it I don't see that lead diminishing". He also noted "tweaks" throughout the OS as welcome changes, including quick toggles in the notification drawer, a Settings menu with more visual information, and a Camera app that has been "cleaned up a bit". Bohn stated that he didn't notice any significant battery improvements despite the Doze power-saving feature in Nougat. He also wrote extensively about the fact that, even though Nougat is "great", "it’s a shame it will take so long for anybody to see it", writing about the lack of updates to most Android devices, and that "unless you have a Nexus, it could be a few months, it could be a year [sic], before it becomes available on your phone".

Chris Velazco of Engadget also praised the new, bundled app notifications, writing that prior Android versions' notifications "just sort of sit there" until interaction, but Nougat "does a much better job of bundling them by app and letting you get things done". He highlighted the ability to expand a bundled Gmail notification to see subjects and senders of individual messages. Velazco stated that split-screen multitasking was a "big deal", but he also encountered non-compatible apps. Visual elements in the Settings app, quick toggles in the notification dropdown, and new language and emoji support were also positive highlights in the review. Velazco did note a battery improvement from the Doze power-saving feature, stating his "Nexus 6P seemed to gain about an hour or two of standby battery life". He also wrote that installing and launching apps might be "a little faster than usual" thanks to Nougat's new app compiler, and he hoped game developers would utilize the new Vulkan API for some "seriously good-looking mobile gaming".

***

## Alternatives

Android 7.x is aging, and it is recommended to use it in a virtual machine via Android x86. However, the devices it runs on are still relevant (as of 2021 October 4th) here are some other alternatives to Android 7.x:

LineageOS

GrapheneOS

ReplicantOS

RemixOS (Android 5.0 and higher)

[Suggest an alternative](https://github.com/seanpm2001/Degoogle-your-life/issues/)

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android Nougat](https://en.wikipedia.org/wiki/Android_Nougat)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 2:26 pm`

**Last revised on:** `2021 Monday, October 4th at 2:26 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `149`

**Article language:** `English (US) / Markdown`

**Article version:** `1 (2021 Monday, October 4th at 2:26 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

