
***

# Android 5.0 (Lollipop)

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android Lollipop logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/5.0-Lollipop/Android_Lollipop_Logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/5.0-Lollipop/Android_Lollipop_Logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/5.0-Lollipop/Android_5.0-en.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/5.0-Lollipop/Android_5.0-en.png)

_Android Lollipop home screen with some stock Google apps_

( **Preceeded by:** [Android 4.4 (KitKat))](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-4-KitKat/) | **Succeeded by:** [Android 6.0 (Marhsmallow)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-6-0-Marshmallow/) )

**Developer:**	Google

**General availability:**	November 4, 2014;

**Latest release:**	5.1.1_r38 (LMY49M) / July 5, 2016;

**Kernel type:**	Monolithic Kernel (Linux Kernel)

**Official website:**	[www.android.com/versions/lollipop-5-0/](https://www.android.com/versions/lollipop-5-0/)

**Support status:** Unsupported

Android Lollipop (codenamed Android L during development) is the fifth major version of the Android mobile operating system developed by Google and the 12th version of Android, spanning versions between 5.0 and 5.1.1. Unveiled on June 25, 2014 at the Google I/O 2014 conference, it became available through official over-the-air (OTA) updates on November 12, 2014, for select devices that run distributions of Android serviced by Google (such as Nexus and Google Play edition devices). Its source code was made available on November 3, 2014. It is the fifth major update and the twelfth version of Android.

One of the most prominent changes in the Lollipop release is a redesigned user interface built around a design language known as Material Design, which was made to retain a paper-like feel to the interface. Other changes include improvements to the notifications, which can be accessed from the lockscreen and displayed within applications as top-of-the-screen banners. Google also made internal changes to the platform, with the Android Runtime (ART) officially replacing Dalvik for improved application performance, and with changes intended to improve and optimize battery usage.

Android Lollipop was succeeded by Android Marshmallow, which was released in October 2015.

As of August 2021, 1.21% of Android devices run Lollipop 5.0 (API 21), and 2.71% run Lollipop 5.1 (API 22), with a combined 3.92% of usage share.

## Development

The release was internally codenamed "Lemon Meringue Pie". Android 5.0 was first unveiled under the codename "Android L" on June 25, 2014 during a keynote presentation at the Google I/O developers' conference. Alongside Lollipop, the presentation focused on a number of new Android-oriented platforms and technologies, including Android TV, in-car platform Android Auto, wearable computing platform Android Wear, and health tracking platform Google Fit.

Part of the presentation was dedicated to a new cross-platform design language referred to as "material design". Expanding upon the "card" motifs first seen in Google Now, it is a design with increased use of grid-based layouts, responsive animations and transitions, padding, and depth effects such as lighting and shadows. Designer Matías Duarte explained that "unlike real paper, our digital material can expand and reform intelligently. Material has physical surfaces and edges. Seams and shadows provide meaning about what you can touch." The material design language would not only be used on Android, but across Google's suite of web software as well, providing a consistent experience across all platforms.

## Features

Android 5.0 introduces a refreshed notification system. Individual notifications are now displayed on cards to adhere to the material design language, and batches of notifications can be grouped by the app that produced them. Notifications are now displayed on the lock screen as cards, and "heads up" notifications can also be displayed as large banners across the top of the screen, along with their respective action buttons. A do-not-disturb feature is also added for notifications. The recent apps menu was redesigned to use a three-dimensional stack of cards to represent open apps. Individual apps can also display multiple cards in the recents menu, such as for a web browser's open tabs. Upon the release of this version, for Most android devices, the navigation buttons were completely changed from a left arrow, a house, and two squares, to a left triangle, a circle and a square.

Lollipop also contains major new platform features for developers, with over 5,000 new APIs added for use by applications. For example, there is the possibility to save photos in a raw image format. Additionally, the Dalvik virtual machine was officially replaced by Android Runtime (ART), which is a new runtime environment that was introduced as a technology preview in KitKat. ART is a cross-platform runtime which supports the x86, ARM, and MIPS architectures in both 32-bit and 64-bit environments. Unlike Dalvik, which uses just-in-time compilation (JIT), ART compiles apps upon installation, which are then run exclusively from the compiled version from then on. This technique removes the processing overhead associated with the JIT process, improving system performance.

Lollipop also aimed to improve battery consumption through a series of optimizations known as "Project Volta". Among its changes are a new battery saver mode, job-scheduling APIs which can restrict certain tasks to only occur over Wi-Fi, and batching of tasks to reduce the overall amount of time uthat internal radios are active on. The new developer tool called "Battery Historian" can be used for tracking battery consumption by apps while in use. The Android Extension Pack APIs also provide graphics functions such as new shaders, aiming to provide PC-level graphics for 3D games on Android devices.

A number of system-level, enterprise-oriented features were also introduced under the banner "Android for Work". The Samsung Knox security framework was initially planned to be used as a foundation for "Android for Work", but instead Google opted to use its own technology for segregating personal and work-oriented data on a device, along with the accompanying APIs for managing the environment. With the "Smart Lock" feature, devices can also be configured so users do not have to perform device unlocking with a PIN or pattern when being on a trusted location, or in proximity of a designated Bluetooth device or NFC tag. Lollipop was, additionally, to have device encryption enabled by default on all capable devices; however, due to performance issues, this change was held over to its successor, Android Marshmallow.

## Release

A developer preview of Android L, build LPV79, was released for the Nexus 5 and 2013 Nexus 7 on June 26, 2014 in the form of flashable images. Source code for GPL-licensed components of the developer preview was released via Android Open Source Project (AOSP) in July 2014. A second developer preview build, LPV81C, was released on August 7, 2014, alongside the beta version of the Google Fit platform and SDK. As with the previous build, the second developer preview build is available only for the Nexus 5 and 2013 Nexus 7.

On October 15, 2014, Google officially announced that Android L would be known as Android 5.0 "Lollipop". The company also unveiled launch devices for Android 5.0‍—‌including Motorola's Nexus 6 and HTC's Nexus 9‍—‌for release on November 3, 2014. Google stated that Nexus (including the Nexus 4, 5, 7, and 10) and Google Play edition devices would receive updates to Lollipop "in the coming weeks"; one more developer preview build for Nexus devices and the new SDK revision for application developers would be released on October 17, 2014. Update schedules for third-party Android devices may vary by manufacturer.

The full source code of Android 5.0 was pushed to AOSP on November 3, 2014, allowing developers and OEMs to begin producing their own builds of the operating system. On December 2, 2014, factory images for Nexus smartphones and tablets were updated to the 5.0.1 version, which introduces a few bug fixes, and a serious bug that affected Nexus 4 devices and prevented the audio from working during phone calls. A device-specific Lollipop 5.0.2 (LRX22G) version was released for the first-generation Nexus 7 on December 19, 2014.

Android 5.1, an updated version of Lollipop, was unveiled in February 2015 as part of the Indonesian launch of Android One, and is preloaded on Android One devices sold in Indonesia and the Philippines. Google officially announced 5.1 by releasing updates for existing devices on March 9, 2015.

In 2015, Amazon.com forked Lollipop to produce Fire OS 5 "Bellini" for Amazon's Fire HD-series devices.

***

## Alternatives

Android 5.x is aging, and it is recommended to use it in a virtual machine via Android x86. However, the devices it runs on are still relevant (as of 2021 October 4th) here are some other alternatives to Android 5.x:

LineageOS

GrapheneOS

ReplicantOS

RemixOS (Android 5.0 and higher)

[Suggest an alternative](https://github.com/seanpm2001/Degoogle-your-life/issues/)

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android Marshmallow](https://en.wikipedia.org/wiki/Android_Lollipop/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 1:45 pm`

**Last revised on:** `2021 Monday, October 4th at 1:45 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `115`

**Article language:** `English (US) / Markdwn`

**Article version:** `1 (2021 Monday, October 4th at 1:45 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

