
***

# Android 4.0 (Ice cream sandwich)

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android 4.0 logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.0-Ice-cream-sandwich/Android_Ice_Cream_Sandwich_Logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.0-Ice-cream-sandwich/Android_Ice_Cream_Sandwich_Logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.0-Ice-cream-sandwich/Android_4.0.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.0-Ice-cream-sandwich/Android_4.0.png)

( **Preceeded by:** [Android 2.3 (Gingerbread) (cell phones)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-2-3-Gingerbread/) **also Preceeded by:** [Android 3.0 (Honeycomb) (tablets)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-3-0-Honeycomb/) | **Succeeded by:** [Android 4.1 (Jelly Bean)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-1-Jelly-bean/))

**Developer:**	Google

**Released to manufacturing:**	October 19, 2011;

**Latest release:**	4.0.4_r2.1 (IMM76L / June 6, 2012;

**Kernel type:**	Monolithic Kernel (Linux Kernel)

**Official website:**	[developer.android.com/about/versions/android-4.0-highlights.html](http://developer.android.com/about/versions/android-4.0-highlights.html)

**Support status:** Unsupported

Android Ice Cream Sandwich is the 9th major version of the Android mobile operating system developed by Google. Unveiled on October 19, 2011, Android 4.0 builds upon the significant changes made by the tablet-only release Android Honeycomb, in an effort to create a unified platform for both smartphones and tablets.

Android 4.0 was focused on simplifying and modernizing the overall Android experience around a new set of human interface guidelines. As part of these efforts, it introduced a new visual appearance codenamed "Holo", which is built around a cleaner, minimalist design, and a new default typeface named Roboto. It also introduced a number of other new features, including a refreshed home screen, near-field communication (NFC) support and the ability to "beam" content to another user using the technology, an updated web browser, a new contacts manager with social network integration, the ability to access the camera and control music playback from the lock screen, visual voicemail support, face recognition for device unlocking ("Face Unlock"), the ability to monitor and limit mobile data usage, and other internal improvements.

Android 4.0 received positive reviews by critics, who praised the cleaner, revamped appearance of the operating system in comparison to previous versions, along with its improved performance and functionality. However, critics still felt that some of Android 4.0's stock apps were still lacking in quality and functionality in comparison to third-party equivalents, and regarded some of the operating system's new features, particularly the "face unlock" feature, as being gimmicks.

As of April 2020, statistics issued by Google indicate that 0.2% of all Android devices accessing Google Play run Ice Cream Sandwich.

## Development

Following the tablet-only release "Honeycomb", it was announced at Google I/O 2011 that the next version of Android, code named "Ice Cream Sandwich" (ICS), would be emphasized providing a unified user experience between both smartphones and tablets. In June 2011, details also began to surface surrounding a then-new Nexus phone by Samsung to accompany ICS, which would notably exclude hardware navigation keys. Android blog RootzWiki released photos in August 2011 showing a Nexus S running a build of ICS, depicting a new application menu layout resembling that of Honeycomb, and a new interface with blue-colored accenting. An official launch event for Android 4.0 and the new Nexus phone was originally scheduled for October 11, 2011, at a CTIA trade show in San Diego. However, out of respect for the death of Apple co-founder Steve Jobs, Google and Samsung postponed the event to October 19, 2011, in Hong Kong. Android 4.0 and its launch device, the Galaxy Nexus, were officially unveiled on October 19, 2011. Andy Rubin explained that 4.0 was intended to provide a "enticing and intuitive" user experience across both smartphones and tablets.

Matias Duarte, Google's vice president of design, explained that development of Ice Cream Sandwich was based around the question "What is the soul of the new machine?"; user studies concluded that the existing Android interface was too complicated, and thus prevented users from being "empowered" by their devices. The overall visual appearance of Android was streamlined for Ice Cream Sandwich, building upon the changes made on the tablet-oriented Android 3.0, his first project at Google; Duarte admitted that his team had cut back support for smaller screens on Honeycomb to prioritize sufficient tablet support, as he wanted Android OEMs to "stop doing silly things like taking a phone UI and stretching it out to a 10-inch tablet." Judging Android's major competitors, Duarte felt that the interface of iOS was too skeuomorphic and kitschy, Windows Phone's Metro design language looked too much like "airport lavatory signage", and that both operating systems tried too hard to enforce conformity, "[without] leaving any room for the content to express itself." For Ice Cream Sandwich, his team aimed to provide interface design guidelines which would evoke a modern appearance, while still allowing flexibility for application developers. He characterized the revised look of Ice Cream Sandwich as having "toned down the geeky nerd quotient" in comparison to Honeycomb, which carried a more futuristic appearance that was compared by critics to the aesthetics of Tron.

In January 2012, following the official launch of Ice Cream Sandwich, Duarte and Google launched an Android Design portal, which features human interface guidelines, best practices, and other resources for developers building Android applications designed for Ice Cream Sandwich.

## Release

The Galaxy Nexus was the first Android device to ship with Android 4.0. Android 4.0.3 was released on December 16, 2011, providing bug fixes, a new social stream API, and other internal improvements. The same day, Google began a rollout of Ice Cream Sandwich to the predecessor of the Galaxy Nexus, the Nexus S. However, on December 20, 2011, the Nexus S roll-out was "paused" so the company could "monitor feedback" related to the update.

On March 29, 2012, Android 4.0.4 was released, adding several performance improvements to the camera and screen rotation, and other bug fixes.

Google Play Services support for 4.0 ended in February 2019.

## Features

### Visual design

The user interface of Android 4.0 represents an evolution of the design introduced by Honeycomb, although the futuristic aesthetics of Honeycomb were scaled back in favor of flat design with neon blue accenting, hard edges, and drop shadows for depth. Ice Cream Sandwich also introduced a new default system font, Roboto; designed in-house to replace the Droid font family, Roboto is primarily optimized for use on high-resolution mobile displays. The new visual appearance of Ice Cream Sandwich is implemented by a widget toolkit known as "Holo"; to ensure access to the Holo style across all devices—even if they use a customized interface skin elsewhere, all Android devices certified to ship with Google Play Store (formerly Android Market) must provide the capability for apps to use the unmodified Holo theme.

As with Honeycomb, devices can now render navigation buttons—"Back", "Home", and "Recent apps"—on a "system bar" across the bottom of the screen, removing the need for physical equivalents. The "Menu" button that was present on previous generations of Android devices is deprecated, in favor of presenting buttons for actions within apps on "action bars", and menu items which do not fit on the bar in "action overflow" menus, designated by three vertical dots. Hardware "Search" buttons are also deprecated, in favor of search buttons within action bars. On devices without a "Menu" key, a temporary "Menu" key is displayed on-screen while running apps that are not coded to support the new navigation scheme. On devices that use a hardware "Menu" key, action overflow buttons are hidden in apps and are mapped to the "Menu" key.

### User experience

The default home screen of Ice Cream Sandwich displays a persistent Google Search bar across the top of the screen, a dock across the bottom containing the app drawer button in the middle, and four slots for app shortcuts alongside it. Folders of apps can be made by dragging an app and hovering it over another. The app drawer is split into two tabs; one for apps, and the latter holding widgets to be placed on home screen pages. Widgets themselves can be resizable and contain scrolling content. Android 4.0 contains an increased use of swiping gestures; apps and notifications can now be removed from the recent apps menu and dismissed from the notifications area by sliding them away, and a number of stock and Google apps now use a new form of tabs, in which users can navigate between different panes by either tapping their name on a strip, or swiping left and right.

The phone app was updated with a Holo design, the ability to send pre-configured text message responses in response to incoming calls, and visual voicemail integration within the call log display. The web browser app incorporates updated versions of WebKit and V8, supports syncing with Google Chrome, has an override mode for loading a desktop-oriented version of a website rather than a mobile-oriented version, as well as offline browsing. The "Contacts" section of the phone app was split off into a new "People" app, which offers integration with social networks such as Google+ to display recent posts and synchronize contacts, and a "Me" profile for the device's user. The camera app was redesigned, with a reduction in shutter lag, face detection, a new panorama mode, and the ability to take still photos from a video being recorded in camcorder mode. The photo gallery app now contains basic photo editing tools. The lock screen now supports "Face Unlock", includes a shortcut for launching the camera app, and can house playback controls for music players. The keyboard incorporates improved autocomplete algorithms, and improvements to voice input allow for continuous dictation. The ability to take screenshots by holding down the power and "Volume down" buttons together was also added.

On devices supporting near-field communication (NFC), "Android Beam" allows users to share links to content from compatible apps by holding the back of their device up against the back of another NFC-equipped Android device, and tapping the screen when prompted. Certain "System" apps (particularly those pre-loaded by carriers) that cannot be uninstalled can now be disabled. This hides the application and prevents it from launching, but the application is not removed from storage. Android 4.0 introduced features for managing data usage over mobile networks; users can display the total amount of data they have used over a period of time, and display data usage per app. Background data usage can be disabled globally or on a per-app basis, and a cap can be set to automatically disable data if usage reaches a certain quota as calculated by the device.

### Platform

Android 4.0 inherits platform additions from Honeycomb, and also adds support for ambient temperature and humidity sensors, Bluetooth Health Device Profile, near-field communication (NFC), and Wi-Fi Direct. The operating system also provides improved support for stylus and mouse input, along with new accessibility, calendar, keychain, spell checking, social networking, and virtual private network APIs. For multimedia support, Android 4.0 also adds support for ADTS AAC, Matroska containers for Vorbis and VP8, WebP, streaming of VP8, OpenMAX AL, and HTTP Live Streaming 3.0.

## Reception

Android 4.0 was released to positive reception: Ars Technica praised the Holo user interface for having a "sense of identity and visual coherence that were previously lacking" in comparison to previous versions of Android, also believing that the new interface style could help improve the quality of third-party apps. The stock apps of Android 4.0 were also praised for having slightly better functionality in comparison to previous versions. Other features were noted, such as the improvements to text and voice input, along with the data usage controls (especially given the increasing use of metered data plans), and its overall performance improvements in comparison to Gingerbread. However, the Face Unlock feature was panned for being an insecure gimmick, and although providing an improved experience over the previous version, some of its stock applications (such as its email client) were panned for still being inferior to third-party alternatives.

Engadget also acknowledged the maturing quality of the Android experience on Ice Cream Sandwich, and praised the modern feel of its new interface in comparison to Android 2.3, along with some of the new features provided by Google's stock apps and the operating system itself. In conclusion, Engadget felt that Android 4.0 was "a gorgeous OS that offers great performance and—for the most part—doesn't feel like a half-baked effort." However, Engadget still felt that some of Android 4.0's new features (such as Face Unlock) had a "beta feel" to them, noted the lack of Facebook integration with the new People app, and that the operating system was still not as intuitive for new users as its competitors.

PC Magazine acknowledged influence from Windows Phone 7 in the new "People" app and improved benchmark performance on the web browser, but considered both Android Beam and Face Unlock to be gimmicks, and criticized the lack of support for certain apps and Adobe Flash on launch.

***

## Alternatives

Android 3.0 shouldn't be in use on a mobile tablet anymore. If you still want to use Android 3.0, it is recommended to do it in a virtual machine. Try using Android x86 with an Android 3.0 disk image, and enjoy the operating system.

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android Ice cream sandwich](https://en.wikipedia.org/wiki/Android_Ice_Cream_Sandwich)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 1:05 pm`

**Last revised on:** `2021 Monday, October 4th at 1:05 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `119`

**Article language:** `English (US)`

**Article version:** `1 (2021 Monday, October 4th at 1:05 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

