
***

# Android 11.0

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android R logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Android_11_Developer_Preview_logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Android_11_Developer_Preview_logo.svg)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Android_11_logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Android_11_logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Pixel_4a_Android_11_Launcher.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/11.0/Pixel_4a_Android_11_Launcher.png)

( **Preceeded by:** [Android 10.0](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-10-0/) | **Succeeded by:** [Android 12.0](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-12-0/) )

**Developer:**	Google

**OS family:**	Android

**General availability:**	September 8, 2020; 12 months ago

**Latest release:**	11.0.0_r45 (RD2A.210905.003) / September 7, 2021;

**Kernel type:**	Monolithic Kernel (Linux Kernel)

**Official website:**	[www.android.com/android-11/](https://www.android.com/android-11/)

**Support status:** Supported

Android 11 is the eleventh major release and 18th version of Android, the mobile operating system developed by the Open Handset Alliance led by Google. It was released on September 8, 2020.

The first phone launched in Europe with Android 11 was the Vivo X51 5G and after its full stable release, the first phone in the world which came with Android 11 after Google Pixel 5 was OnePlus 8T.

As of September 2021, 30.08% of Android devices run Android 11 (API 30), making it the most used version of Android.

## History

Android 11 was intended for three monthly developer preview builds to be released before the first beta release, initially due in May, with a total of three monthly beta releases before the actual release. A state of "platform stability" was planned for July 2020, and the final release occurred on September 8, 2020.

The first developer preview build of Android 11 was released on February 19, 2020 as a factory image for supported Google Pixel smartphones (excluding the first-generation Pixel and Pixel XL). Developer Preview 2 was then released on March 18, followed by Developer Preview 3 on April 23. On May 6, Google released an unexpected Developer Preview 4, as they pushed the whole roadmap for Android 11 forward a month, setting the date for the first beta for June 3.

The release of the first public beta was originally set to take place on June 3 at Google I/O, which was ultimately canceled due to the COVID-19 pandemic, an online release event being planned instead. Following the George Floyd protests, Google announced that the release of the first Android 11 beta would be postponed. Beta 1 was finally released on June 10, 2020, followed by Beta 2 on July 8. A hotfix Beta 2.5 was then released on July 22, with Beta 3 released on August 6. It was released on September 8, 2020.

## Features

### User experience

Android 11 introduces "conversations" notifications; they are designed for chat and messaging, and can be presented in pop-up overlays known as "bubbles" when supported by apps. Conversations can also be marked as "priority" to give them greater prominence (pushing them to the top of notifications, and allowing them to bypass do not disturb mode). Notification history over the past 24 hours can also be displayed. Bubbles is designed to replace the existing overlay permission, which is being deprecated in the future due to security (due to its use by clickjacking malware) and performance concerns.

The menu displayed when holding the power button now includes an area devoted to controlling smart home devices (only on Pixel devices). Media controls are displayed as part of the quick settings area and no longer as a persistent notification. The screenshot button is moved to the recents screen (only on Pixel devices). Apps can be pinned on the share menu.

Android 11 includes a built-in screen recorder.

The media player is now separate from the notifications. And if the user is running 2 or more media apps, the user can swipe from either side to switch between the media players.

### Accessibility

The voice control system is capable of recognizing screen context.

### Platform

Android 11 contains various APIs designed for detecting the presence of 5G network connectivity in order to provide enhanced in-app experiences. Android 11 contains new APIs for handling devices with hinged displays (such as foldable smartphones) and ultra-curved "waterfall" displays.

A new API can be used to monitor a device's temperature and adjust application operations accordingly. OpenSL ES is deprecated in favor of Oboe. Android 11 supports wireless debugging.

Android 11 Go Edition has performance improvements, privacy enhancement, increasing storage, upgraded RAM storage and new app features, with Google stating that apps would launch 20% quicker than on Android 10.

### Privacy and security

If automatically rebooting after a system update, apps can automatically resume and regain access to credential-encrypted storage without authentication.

Android 11 introduces "one-time" permissions for camera, microphone, and location; when requested by an app, the user must choose whether to grant access whenever they are using the app, only once, or deny. Repeatedly denying permission will imply an indefinite rejection. Apps must require users to go to the system settings menu in order to enable background location tracking, and all "sensitive" permissions are automatically reset if the user has not used an app for several months.

Apps targeting Android 11 are only allowed to access files in external storage that they have created themselves ("scoped storage"), preferably contained within an app-specific directory, and audio, image, and video files contained within the Music, Pictures, or Videos directories. Any other file may only be accessed via user intervention through the Storage Access Framework.

To "ensure that the EXIF location metadata is correctly processed based on the location permissions defined within the app", Android 11 restricts image and video capture Intents to system camera apps only. This does not affect cameras built into apps (such as, for example, Instagram or Snapchat).

***

## Alternatives

Android 11.x is aging, and it is recommended to use it in a virtual machine via Android x86. However, the devices it runs on are still relevant (as of 2021 October 4th) here are some other alternatives to Android 11.x:

LineageOS

GrapheneOS

ReplicantOS

RemixOS (Android 5.0 and higher)

[Suggest an alternative](https://github.com/seanpm2001/Degoogle-your-life/issues/)

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android 10](https://en.wikipedia.org/wiki/Android_10/)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 3:08 pm`

**Last revised on:** `2021 Monday, October 4th at 3:08 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `129`

**Article language:** `English (US) / Markdown`

**Article version:** `1 (2021 Monday, October 4th at 3:08 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

