
***

# Android 4.1 - Jelly bean

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Android Jelly Bean logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.1-Jelly-bean/Android_Jelly_Bean_Logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.1-Jelly-bean/Android_Jelly_Bean_Logo.svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.1-Jelly-bean/Android_4.2_on_the_Nexus_4.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Versions/4.1-Jelly-bean/Android_4.2_on_the_Nexus_4.png)

( **Preceeded by:** [Android 4.0 (Ice Cream Sandwich)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-0-Ice-cream-sandwich/) | **Succeeded by:** [Android 4.4 (KitKat)](https://github.com/seanpm2001/Degoogle-your-life/wiki/Android-4-4-KitKat/) )

**Developer:**	Google

**Released to manufacturing:**	June 9, 2012;

**Latest release:**	4.3.1_r1 (JLS36I) / October 7, 2013;

**Kernel type:**	Monolithic Kernel (Linux Kernel)

**Official website:**	[www.android.com/versions/jelly-bean-4-3/](https://www.android.com/versions/jelly-bean-4-3/)

**Support status:** Unsupported

Android Jelly Bean is the codename given to the tenth version of the Android mobile operating system developed by Google, spanning three major point releases (versions 4.1 through 4.3.1). Among the devices that run Android 4.3 are the Asus Nexus 7 (2013) and the LG Nexus 4.

The first of these three releases, 4.1, was unveiled at Google's I/O developer conference in June 2012. It focused on performance improvements designed to give the operating system a smoother and more responsive feel, improvements to the notification system allowing for expandable notifications with action buttons, and other internal changes. Two more releases were made under the Jelly Bean name in October 2012 and July 2013 respectively, including 4.2—which included further optimizations, multi-user support for tablets, lock screen widgets, quick settings, and screen savers, and 4.3—which contained further improvements and updates to the underlying Android platform.

Jelly Bean versions are not receiving updates by Google Play Services. As of July 2021, 0.46% of Android devices run Jelly Bean.

## Development

Android 4.1 Jelly Bean was first unveiled at the Google I/O developer conference on June 27, 2012, with a focus on "delightful" improvements to the platform's user interface, along with improvements to Google's search experience on the platform (such as Knowledge Graph integration, and the then-new digital assistant Google Now), the unveiling of the Asus-produced Nexus 7 tablet, and the unveiling of the Nexus Q media player.

For Jelly Bean, work was made on optimizing the operating system's visual performance and responsiveness through a series of changes referred to as "Project Butter": graphical output is now triple buffered, vsync is used across all drawing operations, and the CPU is brought to full power when touch input is detected—preventing the lag associated with inputs made while the processor is in a low-power state. These changes allow the operating system to run at a full 60 frames per second on capable hardware.

Following 4.1, two more Android releases were made under the Jelly Bean codename; both of these releases focused primarily on performance improvements and changes to the Android platform itself, and contained relatively few user-facing changes. Alongside Android 4.1, Google also began to decouple APIs for its services on Android into a new system-level component known as Google Play Services, serviced through Google Play Store. This allows the addition of certain forms of functionality without having to distribute an upgrade to the operating system itself, addressing the infamous "fragmentation" problems experienced by the Android ecosystem.

## Release

Attendees of the Google I/O conference were given Nexus 7 tablets pre-loaded with Android 4.1, and Galaxy Nexus smartphones which could be upgraded to 4.1. Google announced an intent to release 4.1 updates for existing Nexus devices and the Motorola Xoom tablet by mid-July. The Android 4.1 upgrade was released to the general public for GSM Galaxy Nexus models on July 10, 2012. In late 2012, following the official release of Jelly Bean, a number of third-party Android OEMs began to prepare and distribute updates to 4.1 for their existing smartphones and tablets, including devices from Acer, HTC, LG, Motorola, Samsung, Sony, and Toshiba. In August 2012, nightly builds of the aftermarket firmware CyanogenMod based on 4.1 (branded as CyanogenMod 10) began to be released for selected devices, including some Nexus devices (the Nexus S and Galaxy Nexus), the Samsung Galaxy S, Galaxy S II, Galaxy Tab 2 7.0, Motorola Xoom, and Asus Transformer.

On October 29, 2012, Google unveiled Android 4.2, dubbed "a sweeter tasting Jelly Bean", alongside its accompanying launch devices, the Nexus 4 and Nexus 10. Firmware updates for the Nexus 7 and Galaxy Nexus were released in November 2012. Android 4.3 was subsequently released on July 24, 2013 via firmware updates to the Galaxy Nexus, 2012 Nexus 7, Nexus 4, and Nexus 10.

## Features

### User experience

Visually, Jelly Bean's interface reflects a refinement of the Holo appearance introduced by Android 4.0. The default home screen of Jelly Bean received new features, such as the ability for other shortcuts and widgets on a home screen page to re-arrange themselves to fit an item being moved or resized. The notification system was also improved with the addition of expandable and actionable notifications; individual notifications can now display additional content or action buttons (such as Call back or Message on a missed call), accessible by dragging open the notification with a two-finger gesture. Notifications can also be disabled individually per app.

Android 4.2 added additional features to the user interface; the lock screen can be swiped to the left to display widget pages, and swiped to the right to go to the camera. A pane of quick settings toggles (a feature often seen in OEM Android skins) was also added to the notification area— accessible by either swiping down with two fingers on phones, swiping down from the top-right edge of the screen on tablets, or pressing a button on the top-right corner of the notifications pane. The previous Browser application was officially deprecated on 4.2 in favor of Google Chrome for Android. 4.2 also adds gesture typing on the keyboard, a redesigned Clock app, and a new screensaver system known as Daydreams. On tablets, Android 4.2 also supports multiple users.

To promote consistency between device classes, Android tablets now use an expanded version of the interface layout and home screen used by phones by default, with centered navigation keys and a status bar across the top. These changes took effect for small tablets (such as the Nexus 7) on 4.1, and for larger tablets on 4.2. Small tablets on Android are optimized primarily for use in a portrait (vertical) orientation, giving apps expanded versions of the layouts used by phones. When used in a "landscape" (horizontal) orientation, apps adjust themselves into the widescreen-oriented layouts seen on larger tablets. On large tablets, navigation buttons were previously placed in the bottom-left of a bar along the bottom of the screen, with the clock and notification area in the bottom-right.

## Platform

For developers, 4.1 also added new accessibility APIs, expanded language support with bi-directional text support and user-supplied keymaps, support for managing external input devices (such as video game controllers), support for multichannel, USB, and gapless audio, a new media routing API, low-level access to hardware and software audio and video codecs, and DNS-based service discovery and pre-associated service discovery for Wi-Fi. Android Beam can now also be used to initiate Bluetooth file transfers through near-field communication.

Android 4.2 added a rewritten Bluetooth stack, changing from the previous Bluez stack (GPL created by Qualcomm) to a rewritten Broadcom open source stack called BlueDroid. The new stack, initially considered "immature", promised several forward-looking benefits, including improved support for multiple displays, support for Miracast, native right-to-left support, updated developer tools, further accessibility improvements such as zooming gestures, and a number of internal security improvements such as always-on VPN support and app verification. A new NFC stack was added at the same time.

Android 4.3 consisted of further low-level changes, including Bluetooth low energy and AVRCP support, SELinux, OpenGL ES 3.0, new digital rights management (DRM) APIs, the ability for apps to read notifications, a VP8 encoder, and other improvements.

Android 4.3 also included a hidden privacy feature known as "App Ops", which allowed users to individually deny permissions to apps. However, the feature was later removed on Android 4.4.2; a Google spokesperson stated that the feature was experimental and could prevent certain apps from functioning correctly if used in certain ways. The concept was revisited as the basis of a redesigned permissions system for Android 6.0.

## Alternatives

Android 4.1-4.3 shouldn't be in use on a mobile tablet anymore. If you still want to use Android 4.1-4.3, it is recommended to do it in a virtual machine. Try using Android x86 with an Android 4.1.x, 4.2.x, or 4.3.x disk image, and enjoy the operating system.

_This article on versions of the Android operating system is a stub. You can help by expanding it._

***

## Sources

[Wikipedia - Android Jelly Bean](https://en.wikipedia.org/wiki/Android_Jelly_Bean)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being half a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Monday, October 4th at 1:15 pm`

**Last revised on:** `2021 Monday, October 4th at 1:15 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `105`

**Article language:** `English (US)`

**Article version:** `1 (2021 Monday, October 4th at 1:15 pm)`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

***

