
***

# Google Summer of code

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Summer-of-Code/Logo/GSoC-icon.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Summer-of-Code/Logo/GSoC-icon.svg)

## Statistics

**Status:**	Active

**Begins**	April – May

**Ends:**	August

**Frequency:**	Annually

**Country:**	Worldwide

**Years active:**	17 (2005 – present)

**Inaugurated:**	2005

**Founder:**	Sergey Brin and Larry Page

**Participants:**	Students

**Website:**	[summerofcode.withgoogle.com](http://summerofcode.withgoogle.com)

The Google Summer of Code, often abbreviated to GSoC, is an international annual program in which Google awards stipends to students who successfully complete a free and open-source software coding project during the summer. The program is open to university students aged 18 or over. It was first held from May to August 2005. The amount of the stipend depends on the purchasing power parity of the country where the student's university is located. Project ideas are listed by host organizations involved in open-source software development, though students can also propose their own project ideas.

The idea for the Summer of Code came directly from Google's founders, Sergey Brin and Larry Page. From 2007 until 2009 Leslie Hawthorn, who has been involved in the project since 2006, was the program manager. From 2010 until 2015, Carol Smith was the program manager. In 2016, Stephanie Taylor took over management of the program.

## Overview

Each year, the program follows a timeline. First, open-source organizations apply to participate. If accepted, each organization provides a list of initial project ideas and invites students to their development communities. Students who meet the eligibility criteria then submit up to 3 proposals that detail the software-coding projects that interest them. These applications are then evaluated by the corresponding mentoring organization, with mentors and organizational administrators reviewing the applications and deciding how many "slots" to request from Google and which proposals to accept. Google allocates slots to each organization, taking into account organizational capacity, mentoring history, and the number of applications the organization has received. Finally, organizations select top proposals to fill their slots and Google verifies eligibility before announcing accepted students. In the event of a single student being marked in more than one organization, Google mediates between all the involved organizations and decides who "gets" that student. The other mentoring organization then unmarks the student and marks a new proposal for acceptance, or gives their slot back to the pool, after which it is redistributed.

## History

### 2005

In 2005, more than 8,740 project proposals were submitted for the 200 available student positions. Due to the overwhelming response, Google expanded the program to 419 positions.

The mentoring organizations were responsible for reviewing and selecting proposals, and then providing guidance to those students to help them complete their proposal. Students that successfully completed their proposal to the satisfaction of their mentoring organization were awarded $4500 and a Google Summer of Code T-shirt, while $500 per project was sent to the mentoring organization. Approximately 80% of the projects were successfully completed in 2005, although completion rates varied by organization: Ubuntu, for example, reported a completion rate of only 64%, and KDE reported a 67% completion rate. Many projects were continued past summer, even though the SOC period was over, and some changed direction as they developed.

For the first Summer of Code, Google was criticized for not giving sufficient time to open source organizations so they could plan projects for the Summer of Code. Despite these criticisms there were 41 organizations involved, including FreeBSD, Apache, KDE, Ubuntu, Blender, Mozdev, and Google itself.

According to a blog post by Chris DiBona, Google's open source program manager, "something like 30 percent of the students stuck with their groups past SoC [Summer of Code]." Mozilla developer Gervase Markham also commented that none of the 10 Google-sponsored Mozilla projects survived after the event. However, the Gaim (now Pidgin) project was able to enlist enough coding support through the event to include the changes into Gaim (now Pidgin) 2.0; the Jabber Software Foundation (now XMPP Standards Foundation) and KDE project also counted a few surviving projects of their own from the event (KDE only counted 1 continuing project from out of the 24 projects which it sponsored).

### 2006

In 2006, around 6,000 applications were submitted, less than the previous year because all applicants were required to have Google Accounts, thereby reducing the number of spam applications received. Google and most mentors are also of the opinion that the proposals were of much higher quality than 2005's applications. Also, the number of participating organizations more than doubled to 102. In addition to the organizations that participated in 2005, organizations such as Debian, GNU, Gentoo, Adium, PHP, and ReactOS participated in 2006. Google had decided to sponsor around 600 projects.

The student application deadline was extended until 2006-05-09, at 11:00 PDT. Although the results were to be declared by 5:00 PM PDT, there was considerable delay in publishing it as Google had not expected several students to be selected in more than one organization. Google allows one student to undertake only one project as part of the program. It took Google several hours to resolve the duplicate acceptances. The acceptance letters were sent out on May 24, at 3:13 AM PDT, but the letters were also sent out to some 1,600 applicants who had in fact, not been accepted by Google's SoC committee. At 3:38 AM PDT, Chris DiBona posted an apology to the official mailing list, adding that "We're very deeply sorry for this. If you received two e-mails, one that said you were accepted and one that you were not, this means you were not."

Google has released a final list of projects accepted into the program on the SoC website. The proposals themselves were visible to the public for a few hours, after which they were taken down in response to complaints by the participants about the "sensitive and private" information that their applications contained. However, Google has since resolved these issues by allowing each student involved in Summer of Code to provide a brief abstract message that is publicly viewable and completely separate from the content of the actual proposal that was submitted to Google.

The Summer of Code 2006 ended on 2006-09-08. According to Google, 82% of the students received a positive evaluation at the end of the program.

### 2007

In 2007, Google accepted 131 organizations and over 900 students. Those 131 organizations had a total of nearly 1500 mentors.

Students were allowed to submit up to 20 applications although only one could be accepted. Google received nearly 6,200 applications.

To allow more students to apply, Google extended the application deadline from March 24 to March 26 at the last minute. It was then extended again to March 27.

On April 11, the acceptance letters were delayed due to additional efforts involved in resolving duplicate submissions. At one point, the web interface changed each application to have a status of Not Selected. Google officials reported that only the acceptance email was the definitive indication of acceptance.

### 2008

In 2008, Google chose 174 open source organizations to participate in Summer of Code, greatly increased from 131 the year before and 102 in 2006. Each organization was chosen based on a number of criteria, such as the virtue of the projects, the ideas given for students to work on, and the ability of the mentors to ensure students successfully completed projects. Nearly 7100 proposals were received for the 2008 Summer of Code, of which 1125 were selected.

The university results were announced on May 8, 2008 at Google's "Open Source at Google" blog. According to it, University of Moratuwa came first in both "Top 10 Universities of 2008 GSoC applicants" and "Top 10 accepted universities 2008 GSoC" categories. Wrocław University of Technology able to secure the second place in "2008 GSoC Accepted: Top 10 Universities" category, while Universidade Estadual de Campinas became second in "2008 GSoC Applicants: Top 10 Universities" category.

### 2009

For 2009 Google reduced the number of software projects to 150, and capped the number of student projects it would accept at 1,000, 85 percent of which were successfully completed.

As of 2009, University of Moratuwa in Sri Lanka ranks first in terms of the number of awards received by students for the five-year period 2005–2009 securing 79 accepted students.

### 2010

In 2010 Google accepted 150 software projects and 1,026 students from 69 countries worldwide. The top ten countries by number of students accepted in 2010 are: United States (197), India (125), Germany (57), Brazil (50), Poland (46), Canada (40), China (39), United Kingdom (36), France (35), Sri Lanka (34).

### 2011

The number of organizations was increased to 175, of which 50 were new. 1,115 students were accepted.

A total of 595 different universities participated in the program, 160 of which were new to the program. The 13 universities with the highest number of students accepted into the 2011 Google Summer of Code account for 14.5% of the students.

University of Moratuwa, Sri Lanka secured first position in 2011's program with 27 accepted students. Polytechnic University of Bucharest, Romania was the second with 23 accepted students while Indian Institute of Technology, Kharagpur, India placed third with 14 students.

The breakdown of college degrees for the 2011 Google Summer of Code program was as follows: 55% of the students were undergraduates, 23.3% were pursuing their master's degrees, 10.2% were working on their PhDs and 11.5% did not specify which degree they were working toward.

### 2012

Google announced the Google Summer of Code 2012 on February 4, 2012. On April 23, 2012, Google announced that 1,212 proposals were accepted in 180 organizations. For the first time since inception, the highest number of GSoC participants came from India (227) followed by the USA (173) and Germany (72). The University of Moratuwa continued its dominance with 29 selections, followed by Dhirubhai Ambani Institute of Information and Communication Technology leading from India at 3rd rank. For the first time, Mauritius, an African country, participated in the Google Summer of Code.

### 2013

Google announced the Google Summer of Code 2013 on February 11, 2013. On April 8, 2013, Google announced that 177 open source projects and organizations would take part that year. 1,192 student project proposals were accepted. This was the first time that Cameroon was represented in the program by 2 students..

### 2014

Google announced the Google Summer of Code 2014 on February 3, 2014. On April 21, 2014, Google announced that 190 open source projects and organizations would take part that year. 1,307 student project proposals were accepted. The 2014 edition was the first time for students from Ethiopia, Honduras, Kenya, Malawi and Uganda have been accepted to this program. Kenya and Cameroon taking the lead with 3 students and the other countries with one student.

### 2015

Google announced the Google Summer of Code 2015 on February 9, 2015. On March 2, 2015, Google announced that 137 open source projects and organizations would take part that year, some notable exceptions including Mozilla, the Linux Foundation, and the Tor Project. The student application period began on March 16, 2015. The accepted student proposals were announced on April 27, 2015, with 1051 student proposals accepted. The highest number of GSoC participants came from India (335) followed by the USA (127) and Sri Lanka (58).

### 2016

Google announced the Google Summer of Code 2016 on February 9, 2016. The deadline for organization application was set to February 19, 2016. The student application period began on March 14, 2016, and student application deadline was set to March 25, 2016. 180 organizations were accepted. It saw 18,981 total registered students (up 36% from 2015) with 7,543 student proposals from 5,107 students in 142 countries. The accepted student proposals were announced on April 22, 2016, with 1,206 student proposals accepted.

### 2017

The number of organizations was increased to 201, of which 39 were new.

The 1,318 students accepted into the program hailed from 575 universities, of which 142 have students participating for the first time.

Over 20,651 students from 144 countries registered for the program, which is an 8.8% increase over the previous high for the program.

4,764 students from 108 countries submitted a total of 7,089 project proposals.

### 2018

212 organizations were accepted in 2018.

### 2019

207 organizations were accepted in 2019.

### 2020

199 organizations and 1199 student projects were accepted in 2020.

### 2021

202 organizations and 1292 student projects were accepted in 2021.

## Alternatives

There are some alternatives to Google Summer of code, the top 16 include:

1. Codeforces. Programming competitions and contests, programming community.

compete.imagine.microsoft.com

2. Microsoft Imagine Cup

Imagine Cup is an annual competition sponsored and hosted by Microsoft Corp. which brings together student developers worldwide to help resolve toughest problem

3. International Obfuscated C Code Contest (IOCCC)

International Obfuscated C Code Contest

4. Halite

An AI programming challenge for all levels Users code bots to compete on a virtual board in a range of languages, strategies, or using machine learning.

5. Russian AI Cup

Russian AI Cup is the annual championship on programming of an artificial intelligence organized by Mail.Ru Group and My.com.

6. International Collegiate Programming Contest (ICPC)

The ACM International Collegiate Programming Contest (ICPC) is a multitier, team-based, programming competition, sponsored by IBM and headquartered at Baylor Un

azspcs.com

7. Al Zimmermann's Programming Contests

Al Zimmermann's Programming Contests. Demented computer programmers compete for glory and for some cool prizes here.

8. CodeWars

CodeWars is a first-class computer programming competition for high school students. CodeWars is hosted in Hewlett-Packard's Houston campus.

9. International Conference on Functional Programming (ICFP)

ICFP (International Conference on Functional Programming) is an annual programming language conference.

10. Code Golf

Code Golf is a game designed to let you show off your code-fu by solving problems in the least number of characters.

11. Underhanded C Contest

The Underhanded C Contest is a programming contest to turn out code that is malicious, but passes a rigorous inspection, and looks like an honest mistake.

12. Java4K

The Java 4K competition is a game programmer competition. The goal of the competition is to create the best game possible in Java.

13. Multi-Agent Programming Contest

The Multi-Agent Programming Contest is an annual international programming competition with stated goal of stimulating research in the area of multi-agent syste

14. Games Fleadh

Games Fleadh Ireland's Digital Programming Festival.It is an All Ireland games design and programming competition for third level students based which takes pla

15. Internet Problem Solving Contest (IPSC)

The Internet Problem Solving Contest is an online programming competition for teams of up to three people.

16. Benelux Algorithm Programming Contest (BAPC)

The Benelux Algorithm Programming Contest (BAPC) is a contest in which about 50 teams from leading universities in Luxemburg, Belgium and the Netherlands.
	
[Source: Cybrhome.com](https://www.cybrhome.com/website/summerofcode.withgoogle.com/alternatives)

***

## Sources

1. [https://www.cybrhome.com/website/summerofcode.withgoogle.com/alternatives](https://www.cybrhome.com/website/summerofcode.withgoogle.com/alternatives)

2. [Wikipedia - Google Summer of Code](https://en.wikipedia.org/wiki/Google_Summer_of_Code)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being partially copied from Wikipedia.

***

## Article info

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**File version:** `1 (Sunday, 2021 October 3rd at 5:08 pm)`

**Line count (including blank lines and compiler line):** `243`

***

## Technical notes

**All times are UTC-7 (PDT/Pacific Time)**

**The encoding is UTF-8 and is compatible with Unicode 5.0 and up**

***

