
***

# Google Chrome version history

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2011-2014/Google_Chrome_icon_(2011).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2011-2014/Google_Chrome_icon_(2011).svg)

Google Chrome is a freeware web browser developed by Google LLC. The development process is split into different "release channels", each working on a build in a separate stage of development. Chrome provides 4 channels: Stable, Beta, Dev, and Canary. On the stable builds, Chrome is updated every two to three weeks for minor releases and every six weeks for major releases. This article will go over the full version history of Google Chrome

_This information is as of 2021 October 3rd. More information will need to be added in the future.

## Versions

The following table summarizes the release history for the Google Chrome web browser.

Discontinued 		Stable channel 		Beta channel 		Developer channel 		Canary channel

Major version 	Release date 	Layout engine 	V8 engine 	Significant changes 	Issues/Bugs

0.2.149 	2008-09-02 	WebKit 522 	0.3 	

First release
	
0.3.154 	2008-10-29 	

Improved plugin performance and reliability

Spell checking for input fields

Improved web proxy performance and reliability

Tab and window management updates
	
0.4.154 	2008-11-24 	WebKit 525 	

Bookmark manager with import and export support

Privacy section added to the application options

New blocked popup notification
	
1.0.154 	2008-12-11 	WebKit 528 	

First stable release
	
2.0.172 	2009-05-24 	WebKit 530 	0.4 	

35% faster JavaScript on the SunSpider benchmark

Mouse wheel support

Full-screen mode

Full-page zoom

Form auto-fill

Sort bookmarks by title

Tab docking to browser and desktop edges

Basic Greasemonkey support
	
3.0.195 	2009-10-12 	WebKit 532 	1.2 	

New "new tab" page for improved customization

25% faster JavaScript

HTML5 video and audio tag support

Lightweight theme support
	
4.0.249 	2010-01-25 	WebKit 532.5 	1.3 	

Extensions

Bookmark synchronization

Enhanced developer tools

Improved HTML5 support

Performance improvements

Full ACID3 pass

HTTP byte range support

Experimental new anti-reflected-XSS feature called "XSS Auditor"
	
4.1.249 	2010-03-17 	

Translate infobar

New privacy features

Disabled XSS Auditor
	
5.0.375 	2010-05-21 	WebKit 533 	2.1 	

Browser preference synchronizing

Increased HTML5 support (Geolocation API, App Cache, web sockets, and file drag-and-drop)

Revamped bookmark manager

Adobe Flash Player integrated

First stable releases for macOS, 32 bit Linux, and 64 bit Linux
	
6.0.472 	2010-09-02 	WebKit 534.3 	2.2 	

Updated and more streamlined UI with simplified Omnibox

New tab page

Merged menu buttons

Form auto-fill

Expanded synchronization support to include extensions and auto-fill data

Support for WebM videos

Built-in PDF support (disabled by default)
	
7.0.517 	2010-10-21 	WebKit 534.7 	2.3.11 	

Implemented HTML5 parsing algorithm

File API

Directory upload via input tag

macOS version gained AppleScript support for UI automation

Late binding enabled for SSL sockets: high priority SSL requests are now always sent to the server first.

New options for managing cookies

Updated New Tab page to enable featuring of web applications
	
8.0.552 	2010-12-02 	WebKit 534.10 	2.4.9 	

Chrome Web Store

Built-in PDF viewer that works inside Chrome's sandbox for increased security

Expanded synchronization support to include web applications

Improved plug-in handling

This release added "about:flags" to showcase experimental features such as Chrome Instant, side tabs on Windows, tabbed settings, Click to Play, background web applications, Remoting, disables outdated plug-ins, XSS Auditor, Cloud Print Proxy, GPU-accelerated compositing, WebGL support for the canvas element, and a "tab overview" mode (like Exposé) for macOS.
	
9.0.597 	2011-02-03 	WebKit 534.13 	2.5.9 	

WebGL enabled by default

Adobe Flash sandboxing on Windows and Chrome Instant (a la Google Instant) option

WebP support

New flags: print preview, GPU-accelerated compositing, GPU-accelerated Canvas 2D, Google Native Client, CRX-less Web Apps, Web page prerendering, experimental Extension APIs, disable hyperlink auditing
	
10.0.648 	2011-03-08 	WebKit 534.16 	3.0.12 	

Google Cloud Print sign-in interface enabled by default

Partially implemented sandboxing of the GPU process

Faster JavaScript performance due to incorporation of Crankshaft, an improved compiler for V8

Settings pages that open in a tab, rather than a dialog box

Malware reporting and disabling outdated plugins

Password sync

GPU accelerated video

Background WebApps

webNavigation extension API
	
11.0.696 	2011-04-27 	WebKit 534.24 	3.1.8 	

HTML5 Speech Input API

Updated icon
	
12.0.742 	2011-06-07 	WebKit 534.30 	3.2.10 	

Hardware accelerated 3D CSS

New Safe Browsing protection against downloading malicious files

Ability to delete Flash cookies from inside Chrome

Launch Apps by name from the Omnibox

Integrated Sync into new settings pages

Improved screen reader support

New warning when hitting Command-Q on Mac

New flags: P2P API

Existing tab on foreground on open

Experimental new tab page

Add grouping to tab context menu

Run PPAPI Flash in the renderer process

Multiple profiles

Removed Google Gears

Print and Save buttons in the PDF viewe
	
13.0.782 	2011-08-02 	WebKit 535.1 	3.3.10 	

Instant Pages (pre-rendering of Web pages)

Native print interface and preview (Linux and Windows only)

Experimental new tab page

Experimental Restrict Instant To Search option
	
14.0.835 	2011-09-16 	3.4.14 	

Native Client (NaCl) enabled for apps in the Chrome Web Store

Web Audio API

Additional macOS Lion feature support

Sync Encryption for all data

Print preview on Mac

Validation of HTTPS sites

Experimental Web Request extension API

Experimental Content Settings extension API
	
15.0.874 	2011-10-25 	WebKit 535.2 	3.5.10 	

Faster print preview

Redesigned new tab page on by default

JavaScript fullscreen API enabled by default

Inline installation of Chrome Web Store items by verified sites

Omnibox History synchronization

Switched to FFmpeg native VP8 decoder

Extensions integrated into settings pages

GPU Accelerated Canvas 2D disabled
	
16.0.912 	2011-12-13 	WebKit 535.7 	3.6.6 	

Multiple profiles on by default

Optional permissions in Chrome extensions, so the user can opt-in or opt-out of the optional permissions at installation time

Experimental support for side tabs was removed.
	
17.0.963 	2012-02-08 	WebKit 535.11 	3.7.12 	

Updated Omnibox prerendering of pages

Download scanning protection

New extensions APIs

Improved History tab

Removal of "+" symbol from the "new tab" button

Limited support for changing user agent strings

Adjustable margins in print preview

Search engine synchronization

Disabled GAIA profile info
	
18.0.1025 	2012-03-28

2012-06-27 (Android ARM)

2012-09-26

(18.0.1026, Android x86) 	WebKit 535.19 	3.8.9 	

Hardware-accelerated Canvas2D graphics

WebGL without the need of 3D graphics hardware through the software rasterizer SwiftShader

Brighter "new tab" button

19.0.1084 	2012-05-15

2012-06-28 (iOS) 	WebKit 536.5 	3.9.24 	

Access tabs between devices

Reorganized and searchable settings interface

Better spell check by using the Google search engine spell checker

Web Store link to the bottom of New Tab page

Experimental JavaScript Harmony (ECMAScript 6) support

Experimental Web Intents API
	
20.0.1132 	2012-06-26 	WebKit 536.10 	3.10.6 	

Experimental touch friendly user interface adjustments. Context menus have extra vertical padding between items.

New tab button is bigger and wider
	
21.0.1180 	2012-07-31

2012-08-22 (iOS) 	WebKit 537.1 	3.11.10 	

Media Stream API (getUserMedia) enabled by default. (E.g. webcam access via JavaScript.)

Gamepad API prototype available by default.

Support for (pointer) and (hover) CSS media queries so sites can optimize their user interface for touch when touch-screen support is available.

HTML5 audio/video and WebAudio now support 24-bit PCM wave files

Note: This is the last version of Chrome that will run on Mac OS X 10.5.8 Leopard. (undocumented)
	
22.0.1229 	2012-09-25 	WebKit 537.4 	3.12.19 	

New-style packaged apps are enabled by default.

New menu icon, replacing the wrench icon

Support for TLS 1.1

Support for color management ICC v2 profiles by default
	
23.0.1271 	2012-11-06

2012-11-28 (iOS) 	WebKit 537.11 	3.13.7 	

Do Not Track preference

Hardware video acceleration with 25% more efficient power consumption in some scenarios

Manager for site permission control

New icon for Chrome Web Store when opening new tab

PPAPI Flash Player (or Pepper-based Flash Player) replaced the NPAPI Flash Player on Mac also
	
24.0.1312 	2013-01-10 	WebKit 537.17 	3.14.5 	

Support for MathML

The HTML5 datalist element now supports suggesting a date and time

Experimental support for CSS custom filters
	
25.0.1364 	2013-02-21

2013-02-27 (Android)

2013-03-04 (iOS) 	WebKit 537.22 	3.15.11 	

Support for Opus audio

Support for VP9 video

Silent installs of external extensions are now disabled by default.

Web Speech API

Encrypted omnibox search (https)

Native Client on ARM

Disabled MathML support for the time being

Android version (update from 18):

Newer V8 JavaScript engine

Audio now continues to play while Chrome is in the background

Support for pausing audio in Chrome when phone is in use
	
26.0.1410 	2013-03-26

2013-04-03 (Android)

2013-04-09 (iOS) 	WebKit 537.31 	3.16.14 	

Improved spell checker (grammar and homonym checking)

Desktop shortcuts for multiple users (profiles) on Windows

Asynchronous DNS resolver on Mac and Linux

Android version:

Autofill and password sync

Performance and stability improvements
	
27.0.1453 	2013-05-21

2013-05-22 (Android)

2013-06-03 (iOS) 	WebKit 537.36 	3.17.6 	

Resource handling optimized for faster page loads

Improved Omnibox predictions and spelling correction

syncFileSystem API for Google Drive data synchronization

Stop packaging Manifest version 1.0 extensions

Android version:

Fullscreen on phones (scrolling down the page makes the toolbar disappear)

Simpler searching (the query stays visible in the omnibox, making it easier to edit)

Client-side certificate support

Tab history on tablets

"A ton of stability and performance fixes"
	
28.0.1500 	2013-06-17 (Linux)

2013-07-09

(macOS and Windows)

2013-07-10 (Android)

2013-07-17 (iOS) 	Blink 28 (except iOS) 	3.18.5 	

Replaced layout engine with Blink, a fork of WebKit on all platforms besides iOS

Faster page loads with the new Blink threaded HTML parser

Rich Notifications and Notification Center (HTML-based notifications deprecated)

Major improvements to the asm.js benchmark performances

Support for the CSS :unresolved pseudoclass for Custom Elements

Support for the CSS @supports conditional blocks to test for property:value pairs

Android version:

Fullscreen API support (fullscreen browsing on tablets)

Experimental WebGL, Web Audio, WebRTC support behind flags

Built-in translation

iOS version:

Improved interoperability with many other Google Apps

Voice Search enhancements

Fullscreen for iPad

Data usage savings (rolling out over time)

Access to browser history
	
29.0.1547 	2013-08-20

(Linux, macOS, and Windows)

2013-08-21 (Android)

2013-09-12 (iOS) 	Blink 29 (except iOS) 	3.19.18 	

Support for VP9 final

Support for TLS 1.2

Preliminary QUIC support

Improved Omnibox suggestions based on the recency of visited sites

Ability to reset user profile back to its original state

New apps and extensions APIs (such as Native Messaging API for connecting Chrome with native applications installed on the same computer - an alternative to NPAPI)

Android version:

WebRTC support

WebAudio support

Improved scrolling responsiveness and visual indication when scrolling to the top or bottom of a page

Startup performance and stability improvements

New color picker user interface for web forms

Support for Google's experimental data compression service (comparable to Opera Turbo) that lets Google servers quickly read and optimize a Web page for mobile devices, then transmit it to the smartphone using Google's SPDY network technology.

Rudimentary tab groups implemented

iOS version:

Get back to Search Results faster

Data cost savings enhancements (rolled out incrementally)

Voice search pronoun support (e.g. queries like: “Who is the president of the United States?” followed by “Who is his wife?”)

Improvements to Single Sign On with other Google Apps

Support for WebP image format
	
30.0.1599 	2013-09-18 (iOS)

2013-10-01

(Linux, macOS, and Windows)

2013-10-02 (Android) 	Blink 30 (except iOS) 	3.20.17 	

New image context menu item: "Search Google for this image"

New Chrome Apps APIs: webview.request, media gallery write support and downloads

New platform features (both in desktop and mobile): support for the WebRTC Device Enumeration API, allowing users to change their microphones and/or camera on the fly without having to restart the WebRTC call, DevTools now supports CSS source maps, Chrome will now match the behavior of IE and not honor the Refresh header or tags when the URL to be refreshed to has a javascript: scheme

Android version:

New gesture: swipe horizontally across the top toolbar to quickly switch tabs

New gesture: drag vertically down from the toolbar to enter into the tab switcher view

New gesture: drag down from the menu to open the menu and select wanted item without having to lift finger

WebGL is enabled by default on high-end devices

DeviceMotion (device acceleration and rotation rates) events

Media Source Extension is enabled on Android 4.1+

Two new experimental features behind a flag: Web Speech API (recognition) and the Vibration API

iOS version:

New look and feature enhancements for iOS7

Improvements to Fullscreen behavior especially on iPad (iOS7 only)

New Settings UI

Maps and email links launch the Google Maps and Gmail apps (if installed) automatically. You can change your preference in Settings

Stability / security improvements and bug fixes
	
31.0.1650 	2013-11-12

(Linux, macOS, and Windows)

2013-11-14 (Android)

2013-11-20 (iOS) 	Blink 31 (except iOS) 	3.21.18 	

Payment requestAutocomplete() on Chrome for Android, Windows, Chrome OS

PNaCl on desktop versions of Chrome

New Chrome Apps APIs: With URL handlers for apps, Chrome App developers can now specify URLs to be handled by a Chrome App. For example, a document link on a website could open a document editor Chrome App. This gives users more seamless entry points into their favorite Chrome Apps.

Directory access for Apps allows Chrome Apps to access and write to user-approved folders. This feature can be used to share files between a Chrome App and a native app. For example, a Chrome App code editor could modify files managed by a native Git client.

SCTP for WebRTC Data Channel allows P2P data transfers between browsers to be either best effort, reliable, or semi reliable, opening up use cases such as gaming.

Alpha channel support for WebM video enables transparency masking (a.k.a. green screen effects) in WebM videos.

Speech recognition with the JavaScript Web Speech API is now supported on Chrome for Android.

window.devicePixelRatio now takes full-page zoom (but not pinch zoom) into account

Support for { alpha: false } in getContext('2d') lets you create an opaque canvas. This is similar to existing WebGL functionality and can improve the rendering performance of your app.

The Media Source API has been unprefixed and is now supported on Chrome for Android. It allows JavaScript to generate media streams for playback, addressing use cases like adaptive streaming and time shifting live streams.

2D canvas now supports the "ellipse" method.

Support for several Mutation Events has been removed. Consider using MutationObserver instead.

iOS version:

Fast form completion with Autofill

Long press on an image to search for related images

Stability / security improvements and bug fixes
	
32.0.1700 	2014-01-14

(Linux, macOS, and Windows)

2014-01-15 (Android)

2014-01-27 (iOS) 	Blink 32 (except iOS) 	3.22.24 	

Tab indicators for sound, webcam and casting

A different look for Win8 Metro mode

Automatically blocking malware files

A number of new apps/extension APIs

Various under-the-hood changes for stability and performance

Android version:

Add web page shortcuts right to your home screen more easily from the menu

Reduce data usage in Chrome up to 50%. Visit Settings > Bandwidth management > Reduce data usage to enable.

iOS version:

Translate

When you come across a page written in a language that you don't understand, just look for the translation bar. One tap and the page is quickly translated for you.

Reduce Data Usage

Reduce your data usage by up to 50%. Enable this feature and view your savings: Settings > Bandwidth > Reduce Data Usage.

New Tab Page update to make searching faster and easier

This feature is being rolled out and will be available to all users over time, beginning on iPhone.
	
33.0.1750 	2014-02-18 (iOS)

2014-02-20

(Linux, macOS, and Windows)

2014-02-26 (Android) 	Blink 33 (except iOS) 	3.23.17 	

Custom Elements

Ogg Opus in MSE and `<video>`

Page Visibility API

VTTCue 

Web Speech API (synthesis)

Font-kerning

requestAutocomplete()

Speech Synthesis

Android version:

Download progress notification for file downloads using the Chrome network stack

Updated help and feedback UI

Support for `<datalist>` tag

iOS version:

Stability and security updates
	
34.0.1847 	2014-04-02 (Android)

2014-04-08

(Linux, macOS, and Windows)

2014-04-29 (iOS) 	Blink 34 (except iOS) 	3.24.35 	

Responsive Images and Unprefixed Web Audio

Import supervised users onto new computers

A different look for Windows 8 Metro mode

A number of new apps/extension APIs

New scroll bar look

Ignores autocomplete="off" on password input fields

Android version:

Battery usage optimizations

iOS version:

Updated tour when you start Chrome for the first time

Support for autocomplete in the omnibox for right to left languages
	
35.0.1916 	2014-05-20 (Android)

2014-05-20

(Linux, macOS, and Windows)

2014-05-28 (iOS) 	Blink 35 (except iOS) 	3.25.28 	

More developer control over touch input

New JavaScript features

Unprefixed Shadow DOM v0

A number of new apps/extension APIs

Opus updated to version v1.1

Android version:

Undo Tab Close

Fullscreen video with Subtitles and HTML5 controls

Support for some multi-window devices

iOS version:

Added right-to-left support to the omnibox for Arabic and Hebrew

See your search term in the omnibox, instead of the long search query URL

Easily refine your search queries and view more results on the search results page

Stability improvements and bug fixes

Linux version:

Switched graphics interface backend from GTK+ to Aura
	
36.0.1985 	2014-07-15 (iOS)

2014-07-16

(Linux, macOS, and Windows)

2014-07-16 (Android) 	Blink 36 (except iOS) 	3.26.31 	

Rich Notifications Improvements

An Updated Incognito / Guest NTP design

The addition of a Browser crash recovery bubble

Multiple stability and performance improvements

Android version:

Improved text rendering on non-mobile optimized sites

Doodles return to the new tab page

iOS version:

Allows mobile sites that have added Cast support to work with your Cast-enabled device

Stability improvements and bug fixes

Linux version:

Chrome App Launcher
	
37.0.2062 	2014-08-26

(Linux, macOS, and Windows)

2014-09-03 (Android)

2014-09-22 (iOS) 	Blink 37 (except iOS) 	3.27.34 	

DirectWrite support on Windows for improved font rendering

A number of new apps/extension APIs

Multiple stability and performance improvements

Removal of the showModalDialog API, breaking several enterprise web apps

Android version:

Signing into Chrome signs you into your favorite Google sites

Updated look and feel with elements of Material Design

Multiple performance improvements and bug fixes

Windows version:

64-bit Windows support
	
38.0.2125 	2014-10-07

(Linux, macOS, and Windows)

2014-10-07 (iOS)

2014-10-08 (Android) 	Blink 38 (except iOS) 	3.28.71 	

A number of new apps/extension APIs

Support for logging into sites using FIDO U2F Security Key (a USB or smartcard security token) as a factor in 2-factor authentication

Under-the-hood changes for stability and performance

Android version:

Support for Battery Status and Screen orientation APIs

Additional Material Design updates

Bug fixes and performance improvements

iOS version:

Better support for iPhone 6 and 6+

Download and open files in Google Drive

Stability improvements and bug fixes

Security fix

39.0.2171 	2014-11-12 (Android)

2014-11-18

(Linux, macOS, and Windows)

2014-11-24 (iOS) 	Blink 39 (except iOS) 	3.29.88 	

Removes SSL/TLS protocol version fallback to SSLv3

64-bit support for Mac

A number of new apps/extension APIs

Under-the-hood changes for stability and performance

Android version:

Number of bug fixes and performance improvements

Experimental Reader Mode can be enabled via chrome://flags, is not available for tablets in this version
	
40.0.2214 	2015-01-20 (iOS)

2015-01-21

(Linux, macOS, and Windows)

2015-01-21 (Android) 	Blink 40 (except iOS) 	3.30.33 	

Disabled SSLv3 support by default

The minimum SSL/TLS version can now be set through about:flags

Updated info dialog for Chrome app on Windows and Linux

A new clock behind/ahead error message

Android version:

Updated page info and content settings UI

Number of bug fixes and performance improvements

iOS version:

New look with Material Design bringing bold graphics, fluid motion, and tactile surfaces

iOS 8 optimizations and support for bigger phones

Support handoff from Chrome to your default browser on macOS

Stability improvements and bug fixes

41.0.2272 	2015-03-03

(Linux, macOS, and Windows)

2015-03-11 (Android)

2015-03-16 (iOS) 	Blink 41 (except iOS) 	4.1.0 	

A number of new apps/extension APIs

Many under the hood changes for stability and performance

Aero interface is disabled in Windows Vista

Android version:

The ability to pull to reload at the top of most pages

A number of bug fixes and performance improvements
	
42.0.2311 	2015-04-14

(Linux, macOS, and Windows)

2015-04-15 (Android)

2015-04-16 (iOS) 	Blink 42 (except iOS) 	4.2.77 	

Support for NPAPI plugins disabled by default

A number of new apps, extension and Web Platform APIs (including the Push API)

Many under the hood changes for stability and performance

Add Bookmark is now redesigned.

Android version:

Getting the latest updates from sites with notifications

Adding your favorite sites to your homescreen is now even easier

Bug fixes and speedy performance improvements
	
43.0.2357 	2015-05-19

(Linux, macOS, and Windows)

2015-05-27 (Android)

2015-06-01 (iOS) 	Blink 43 (except iOS) 	4.3.61 	

Numerous bug fixes and security fixes

Android version:

Faster Checkout – Quickly and securely complete checkout forms with data from Google Wallet

Touch to Search – Learn more about words and phrases by touching them on your screen

Bug fixes and speedy performance improvements

No longer supports Android 4.0 (Ice Cream Sandwich)
	
44.0.2403 	2015-07-21

(Linux, macOS, and Windows)

2015-07-22 (iOS)

2015-07-29 (Android) 	Blink 44 (except iOS) 	4.4.63 	

A number of new apps/extension APIs

Change in the loading page circle on Chrome tabs

Many under the hood changes for stability and performance

Android version:

Fixed a boatload of bugs and performance issues.

iOS version:

Swipe to navigate: swipe right or left to navigate backwards and forwards

Support for accessing Physical Web content from the Today view

Stability improvements and bug fixes[r 107]
	
45.0.2454 	2015-09-01

(Linux, macOS, and Windows)

2015-09-01 (Android)

2015-09-02 (iOS) 	Blink 45 (except iOS) 	4.5.103 	

Support for NPAPI plugins permanently disabled

A number of fixes and improvements

Android version:

A number of fixes for a whole bunch of performance/stability/other issues.
	
46.0.2490 	2015-10-13

(Linux, macOS, and Windows)

2015-10-14 (Android)

2015-10-22 (iOS) 	Blink 46 (except iOS) 	4.6.85 	

Change in taskbar logo design

A number of fixes and improvements.

Android version:

Under the hood performance and stability tweaks.

47.0.2526 	2015-12-01 (iOS)

2015-12-01

(Linux, macOS, and Windows)

2015-12-02 (Android) 	Blink 47 (except iOS) 	4.7.80 	

Change in appearance on closing tabs with red x's

New PDF viewer design

Security fixes

Android version:

"More than a barge load of performance and stability fixes".

iOS version:

Added support for more keyboard shortcuts. Bluetooth keyboards can open, close or change tabs or conduct a voice search.

Support for 3D touch on iPhone 6s/+. Force touch the Chrome icon to quickly open a new tab, a new incognito* tab, or conduct a voice search.
	
48.0.2564 	2016-01-20

(Linux, macOS, and Windows)

2016-01-27 (iOS)

2016-01-27 (Android) 	Blink 48 (except iOS) 	4.8.271 	

"Tab discarding" was enabled by default in chrome://flags

Window change in right-clicking an embedded web link

The key icon in "Save your password" turns black

"Clear browsing history" has been improved

A large number of fixes and improvements

Android version:

Bug fixes and speedy performance improvements.

iOS version:

This version uses WKWebView, the latest rendering engine from Apple.

The crash rate was reduced by 70% and JavaScript execution is now faster.

Redesigned icons on the New Tab page: easier access to more of your frequently-visited sites.

Spotlight integration: Drag down or right from the Home screen and search for your Chrome bookmarks.
	
49.0.2623 	2016-03-02

(Linux, macOS, and Windows)

2016-03-09 (iOS)

2016-03-09 (Android) 	Blink 49 (except iOS) 	4.9.385 	

Extension icons now appear near search tab.

Changes in bookmark bar appearances.

Change in Incognito mode window.

Change in scrollbar movement.

Changed Downloads page appearance/design.

A large number of fixes and improvements

Removed Windows 8 Mode (Metro mode)

Last version available for Windows XP and Vista, as well as Mac OS X 10.6, 10.7, and 10.8.

Android version:

"More than a barge full of performance and stability fixes."

iOS version:

Bookmarks has a new look: Easily find your favorites!

Bug and stability fixes.
	
50.0.2661 	2016-04-13

(Linux, macOS, and Windows)

2016-04-20 (iOS)

2016-04-26 (Android) 	Blink 50 (except iOS) 	5.0.71 	

Windows XP, Vista, Mac OS X 10.6, 10.7, and 10.8 compatibility broken.

Auto-fill form letters are now highlighted in bold.

A number of fixes and improvements.[r 117]

Android version:

Bug fixes and speedy performance improvements.

iOS version:

Bug and stability fixes.
	
51.0.2704 	2016-05-25

(Linux, macOS, and Windows)

2016-06-01 (iOS)

2016-06-01 (Android) 	Blink 51 (except iOS) 	5.1.281 	

A number of fixes and improvements.

Android version:

Brought tab switching back into Chrome (Android L+)

Bug fixes and speedy performance improvements.

iOS version:

Bug and stability fixes.
	
52.0.2743 	2016-07-20

(Linux, macOS, and Windows)

2016-07-27 (iOS)

2016-07-27 (Android) 	Blink 52 (except iOS) 	5.2.361 	

It is impossible to disable DirectWrite.

Bar on the bottom now shows darker text when hovering your mouse over the link.

"A number of fixes and improvements."

Android version:

Bug fixes and speedy performance improvements

iOS version:

Accelerated Mobile Pages ("AMP") – news and articles from many of your favorite publishers will now load instantly.

Lightning bolt and "AMP" next to articles in the "Top Stories" section of search results indicate faster web page loading.
	
53.0.2785 	2016-08-31

(Linux, macOS, and Windows)

2016-09-07 (iOS)

2016-09-07 (Android) 	Blink 53 (except iOS) 	5.3.332 	

New browser's inside look, including a new bookmark

"A number of fixes and improvements."

'Simplify page' option removed from 'Save as PDF'.

Shadow DOM v1

Android version:

Bug fixes and speedy performance improvements

Muted autoplay for video

iOS version:

Chrome's History has a new look and it's now easier to review, find, and delete your browsing history.

Voice Search has been updated with a fresh look. Voice Search can now answer contextual questions such as "How tall is the Eiffel Tower?" followed by "When was it built?"
	
54.0.2840 	2016-10-12

(Linux, macOS, and Windows)

2016-10-19 (iOS)

2016-10-19 (Android) 	Blink 54 (except iOS) 	5.4.500 	

"Other bookmarks" tab has changed appearance

The message "Right-click to play Adobe Flash Player" now appears while pages with Adobe Flash Player are loading.

"A number of fixes and improvements."

Android version:

Bug fixes and speedy performance improvements

View article suggestions for you on the new tab page

Play media in the background for sites that support it

Update saved passwords when you change or reset your password

iOS version:

No internet connection? Smile and tap the dinosaur

Fixed bookmark icons not displaying correctly

Fixed phone number detection issues in web pages

Stability improvements and bug fixes
	
55.0.2883 	2016-12-01

(Linux, macOS, and Windows)

2016-12-05 (iOS)

2016-12-06 (Android) 	Blink 55 (except iOS) 	5.5.372 	

The History page has changed and is no longer in "Settings"

Flash Player is now off by default for most sites

"A number of fixes and improvements."

It is not possible to disable top level Material Design

iOS version:

You can swipe down or right from the iOS Home screen to search. Searching for "voice" or "incognito" enables you to start Chrome in Voice Search mode or in a new Incognito Tab, respectively. The appearance of items in Spotlight Search will only work for devices that support Spotlight Actions.

The folder named "All Bookmarks" has been removed from the Bookmarks view. You can access all your other devices’ Bookmarks by clicking on the other folders.

Android version:

Bug fixes and speedy performance improvements

Easily download music, videos, and even full web pages for viewing offline

View and share your downloads within Chrome

See misspelled words highlighted in text fields

Improvements to contextual search UI
	
56.0.2924 	2017-01-25

(Linux, macOS, and Windows)

2017-02-01 (iOS)

2017-02-01 (Android) 	Blink 56 (except iOS) 	5.6.326 	

HTML5 enabled by default

Adobe Flash Player is automatically blocked for most sites that require the plugin

Labeling of unsecured HTTP sites

"A number of fixes and improvements."

iOS version:

Scan a QR code or barcode by using 3D Touch on the app logo or searching for "QR" in Spotlight.

We've redesigned the tab switcher layout on iPad to make it easier to access your open sites.

Android version:

Easily download music, videos, and even full web pages for viewing offline

View and share your downloads within Chrome

See misspelled words highlighted in text fields

Improvements to contextual search UI

Bug fixes and significant memory savings
	
57.0.2987 	2017-03-09

(Linux, macOS, and Windows)

2017-03-14 (iOS)

2017-03-16 (Android) 	Blink 57 (except iOS) 	5.7.492 	

CSS grid layout

Improved "Add to Home" screen

Media Session API

"A number of fixes and improvements."

WebAssembly

Background tab policy changes

Removed the chrome://plugins page.

iOS version:

Chrome can add pages to your Reading List.

Find in Page now works correctly in iOS 10.3.

Android version:

Quickly use emails, addresses, and phone numbers in web pages by tapping on them

Easily access downloaded files and web pages from the new tab page

Long press article suggestions on the new tab page to download them

Bug fixes and performance improvements

58.0.3029 	2017-04-19

(Linux, macOS, and Windows)

2017-04-20 (Android)

2017-04-25 (iOS) 	Blink 58 (except iOS) 	5.8.283 	

"A number of fixes and improvements."

IndexedDB 2.0

Workers and SharedWorkers in data-URLs.

Android version:

Useful actions like “Find in page” available in apps that open web pages using Chrome

More frequently updated article suggestions on the New Tab page

Use recently visited search engines as your default search engine

See Physical Web suggestions, based on your surroundings, in the address bar

Bug fixes and performance improvements

iOS version:

Stability improvements and bug fixes.
	
59.0.3071 	2017-06-05

(Linux, macOS, and Windows)

2017-06-06 (iOS)

2017-06-06 (Android) 	Blink 59 (except iOS) 	5.9.211 	

"A number of fixes and improvements."

Revamped Settings and "About Google Chrome" page with Material Design

Headless mode in Linux and macOS.

iOS version:

Fixed a user-reported issue that resulted in hangs and significant slowdowns when switching tabs.

Fixed a crash involving dialogs presented while switching tabs.

Stability improvements and bug fixes.

Android version:

View and manage in-progress downloads on the Downloads page

View and clear your browsing data more easily on the redesigned History page

Long-press a link to open it in a new Chrome tab (from Chrome Custom Tabs)

Bug fixes and performance improvements
	
60.0.3112 	2017-07-25

(Linux, macOS, and Windows)

2017-07-25 (iOS)

2017-07-31 (Android) 	Blink 60 (except iOS) 	6.0.286 	

MacBook Pro Touch Bar support.

"A number of fixes and improvements."

iOS version:

"Request Mobile Site" button can switch from a website's desktop version back to its mobile version

Android version:

Load pages faster and use less memory with an updated JavaScript engine
Bug fixes and performance improvements
Clear browsing data more easily
	
61.0.3163 	2017-09-05

(Linux, macOS, and Windows)

2017-09-05 (iOS)

2017-09-05 (Android) 	Blink 61 (except iOS) 	6.1.534 	

Native support for JavaScript modules

"A number of fixes and improvements."

iOS version:

Added a new button for scanning QR codes above the virtual keyboard

Android version:

Addition of Web Share API

Bug fixes and performance improvements

Translate pages with a more compact and intuitive toolbar

Pick images to post online with an improved image picker
	
62.0.3202 	2017-10-17

(Linux, macOS, and Windows)

2017-10-18 (iOS)

2017-10-19 (Android) 	Blink 62 (except iOS) 	6.2.414 	

The "Save Your Password" icon gets a new appearance

"A number of fixes and improvements."

Support for OpenType variable fonts

Network Information API updated to report users actual Internet speed, not just connection type, to websites

HTTP sites that request user data will now be flagged as "non-secure" (red) in the Chrome Omnibox

iOS version:

Two new Today widgets are added by tapping the Edit button at the bottom of the iOS Search screen

Ability to drag a URL from another app and drop it into Chrome's omnibox or the tab strip, or from Chrome's content area to another app on iOS 11 iPads

The Payment Request API has been introduced

Android version:

Download files faster with accelerated downloads

View and copy passwords saved with Chrome if device lock is enabled

Quickly see your data savings in the Chrome menu when Data Saver is on

63.0.3239 	2017-12-05 (iOS)

2017-12-05 (Android)

2017-12-06

(Linux, macOS, and Windows) 	Blink 63 (except iOS) 	6.3.292 	

Various fixes from internal audits, fuzzing and other initiatives

"A number of fixes and improvements."

Browser allows you to import JavaScript modules dynamically

With async generator functions and the async iteration protocol, consumption or implementation of streaming data sources becomes streamlined

You can override the browser's default overflow scroll behavior with the CSS overscroll-behavior property

iOS version:

Swipe up on the New Tab Page to explore suggested content from the web

The ability to reorder bookmarks is back!

Android version:

Chrome for Android will make permission requests modal dialogs

"Stability and performance improvements."
	
64.0.3282 	2018-01-23 (Android)

2018-01-24 (iOS)

2018-01-24

(Linux, macOS, and Windows) 	Blink 64 (except iOS) 	6.4.388 	

"A number of fixes and improvements."

Audio playback rates of below 0.5 and above 4.0 supported due to new, high-quality algorithm for stretching audio: "WSOLA" (Waveform-Similarity-Overlap-Add)

Support for ResizeObservers, will notify you when an element's content rectangle has changed its size.

Modules can now access to host specific metadata with import.meta.

The pop-up blocker gets stronger.

window.alert() no longer changes tab focus.

Chrome now supports named captures in regular expressions.

The default preload value for `<audio>` and `<video>` elements is now metadata.

You can now use Request.prototype.cache to view the cache mode of a Request and determine whether a request is a reload request.

Using the Focus Management API, you can now focus an element without scrolling to it with the preventScroll attribute.

Extensions page generates packages in CRX3 format now.

Android version:

Prevents sites with abusive ad experiences from opening new windows or tabs without your permission.

"Stability and performance improvements."

iOS version:

You can now disable Article Suggestions without also disabling omnibox suggestions by going to Chrome Settings

If you previously turned off "Search and Site Suggestions" to disable Article Suggestions and would like to turn back on your Search Suggestions in the omnibox, you can do that from Chrome Settings > Privacy

Support for iPhone X

Now requires iOS 10 or later

65.0.3325 	2018-03-06

(Linux, macOS, and Windows)

2018-03-06 (iOS)

2018-03-06 (Android) 	Blink 65 (except iOS) 	6.5.254 	

"A number of fixes and improvements."

New extension UI

The CSS Paint API allows you to programmatically generate an image

The Server Timing API allows web servers to provide performance timing information via HTTP headers

The new CSS display: contents property can make boxes disappear

Fixed a bug that affected some timestamps

The syntax for specifying HSL and HSLA, and RGB and RGBA coordinates for the color property now match the CSS Color 4 spec

There's a new feature policy that allows you to control synchronous XHRs through an HTTP header or the iframe allow attribute

Last version available for OS X 10.9.

Android version:

Set language preferences for web content in Settings > Languages

Turn on the prompt for simplified view for all supported articles in Settings > Accessibility settings

Share and delete downloads more easily on the Downloads page

Disable screen capture on incognite mode

iOS version:

Fixed a bug that affected some streaming audio players

Stability and performance improvements

66.0.3359 	2018-04-17

(Linux, macOS, and Windows)

2018-04-17 (iOS)

2018-04-17 (Android) 	Blink 66 (except iOS) 	6.6.346 	

"A number of fixes and improvements."

CSS manipulation becomes easier with the new CSS Typed Model Object

Access to the clipboard is now asynchronous

There's a new rendering context for canvas elements

TextArea and Select now support the autocomplete attribute

Setting autocapitalize on a form element will apply to any child form fields, improving compatibility with Safari's implementation of autocapitalize

trimStart() and trimEnd() are now available as the standards-based way of trimming whitespace from strings

Android version:

Find your saved passwords more easily – just tap the new Search icon in Settings > Passwords

iOS version:

Export passwords saved in Chrome and use them in another app

Stability and performance improvements
	
67.0.3396 	2018-05-29

(Linux, macOS, and Windows)

2018-05-29 (iOS)

2018-05-31 (Android) 	Blink 67 (except iOS) 	6.7.288 	

"A number of fixes and improvements."

Progressive Web Apps are coming to the desktop

The generic sensor API makes it way easier to get access to device sensors like the accelerometer, gyroscope and more

BigInt's make dealing with big integers way easier.

Credential Management API provides a framework for creating, retrieving and storing credentials

The Web Authentication API adds a third credential type, PublicKeyCredential, which allows browsers to authenticate a user with a private/public key pair generated by an authenticator

Android version:

"Stability and performance improvements."

iOS version:

Improved handling of boarding passes, movie tickets, etc. in Wallet

Updated app selection UI when you tap on an email link

Improved support for external keyboards

Improved issue reporting: now you can draw on screenshots you are sending with feedback reports to obscure private data

A fix has been provided for autofill issue (June 13)
	
68.0.3440 	2018-07-24 (iOS)

2018-07-24

(Linux, macOS, and Windows)

2018-07-24 (Android) 	Blink 68 (except iOS) 	6.8.275 	

"A number of fixes and improvements."

HTTP sites marked as "not secure".[

The Page Lifecycle API tells you when your tab has been suspended or restored.

The Payment Handler API makes it possible for web-based payment apps to support the Payment Request experience.

Content embedded in an iframe requires a user gesture to navigate the top-level browsing context to a different origin.

Since Chrome 1, the CSS cursor values for grab and grabbing have been prefixed; standard, un-prefixed values now supported.

Android version:

Fix for an Autofill issue.

The Add to Home Screen behavior on Android is changing to give you more control.

iOS version:

Improved downloading from websites. Downloading now works while the app is in the background. You can also continue browsing in the same tab while your file downloads.

Improvements to Forms Autofill.

Improved handling of links to the App Store.
	
69.0.3497 	2018-09-04

(Linux, macOS, and Windows)

2018-09-04 (iOS)

2018-09-04 (Android) 	Blink 69 (except iOS) 	6.9.427 	

"A number of fixes and improvements."

New browser interface

CSS Scroll Snap allows you to create smooth, slick, scroll experiences.

Display Cutouts lets you use the full area of the screen, including any space behind the display cutout, sometimes called a notch.

The Web Locks API allows you to asynchronously acquire a lock, hold it while work is performed, then release it.

You can now create color transitions around the circumference of a circle, using conic gradients.

New toggleAttribute() method on elements toggles the existence of an attribute, similar to classList.toggle().

JavaScript arrays are getting two new methods: flat() and flatMap().

OffscreenCanvas moves work off the main thread in a worker, helping to eliminate performance bottlenecks.

Android version:

Secure and easy mobile payments via 3rd party payment apps

Password generation now works on more sites

iOS version:

New bottom toolbar: easier to reach frequently used functions, like Back, Search, tabs, and the menu

New tab grid: see bigger previews of your tabs, including tabs open on other devices

Features like Bookmarks and Reading Lists are now easily accessible on the New Tab Page

Press firmly on the app icon to see shortcuts (3D Touch)

Credit cards you enter on your device are now securely synced to Google Pay for use on other devices (if enabled)
	
70.0.3538 	2018-10-16

(Linux, macOS, and Windows)

2018-10-16 (iOS)

2018-10-17 (Android) 	Blink 70 (except iOS) 	7.0.276 	

"A number of fixes and improvements."

Desktop Progressive Web Apps on Windows

The credential management API adds support for Public Key Credentials

Named workers

Web Bluetooth is now available in Windows 10

Chrome can send intervention and deprecation messages to your servers using the Report-To HTTP Response header field or surface them in the ReportingObserver interface

Support for AV1 video decoder (“Main” profile 0)

A number of important deprecations

Android version

"Stability and performance improvements"

Cleaner, more modern design

iOS version:

Bug fixes and design polish for the redesign

Updates to how Chrome launches other apps to improve reliability and security

Fixes to authentication issues caused by using out-of-date cookies

71.0.3578 	2018-12-04

(Linux, macOS, and Windows)

2018-12-04 (iOS)

2018-12-04 (Android) 	Blink 71 (except iOS) 	7.1.302 	

"A number of fixes and improvements."

Displaying relative times is now part of the Intl API

Specifying which side of the text the underline should appear on for text that flows vertically

Requiring user activation before using the speech synthesis API

The default credentials mode for module script requests has changed from omit to same-origin

Shadow DOM v1 spec; calculation for specificity for the :host() and :host-context() pseudo classes as well as for the arguments for ::slotted()

Removed SpeechSynthesis.speak() without user activation

Removed prefixed versions of APIs

Removed URL.createObjectURL from MediaStream

Removed document.origin

Deprecations and removals of APIs

Android version:

The Element.requestFullscreen() method can now be customized

"Stability and performance improvements."

Last version available for Android 4.1-4.3 (Jelly Bean)

iOS version:

You can now long-press on an image and save to clipboard and paste in other apps

Autofill now works better on sites with iframes (embedded pages)
	
72.0.3626 	2019-01-29

(Linux, macOS, and Windows)

2019-01-29 (iOS)

2019-01-29 (Android) 	Blink 72 (except iOS) 	7.2.502 	

"A number of fixes and improvements."

Creating public class fields in JavaScript is now much cleaner

New User Activation API

Localizing lists becomes way easier with the Intl.format() API

Chrome 72 changes the behavior of Cache.addAll() to better match the spec

Requests for favicons are now handled by the service worker, as long as the request URL is on the same origin as the service worker

Pages may no longer use window.open() to open a new page during unload

Removal of HTTP-Based Public Key Pinning

Removal of rendering FTP resources

Deprecation of TLS 1.0 and TLS 1.1

Deprecation of PaymentAddress.languageCode

Android version:

"Stability and performance improvements."

Now requires Android 4.4 or later

iOS version:

Support for more search engines

Fixed crashes on some page translations and added translations on previously untranslated websites

A Siri Shortcut to start a new search is available

73.0.3683 	2019-03-12

(Linux, macOS, and Windows)

2019-03-12 (iOS)

2019-03-12 (Android) 	Blink 73 (except iOS) 	7.3.492 	

"A number of fixes and improvements."

Creating portable content is easier with signed HTTP exchanges

Dynamically changing styles becomes way easier with constructable style sheets

Support for Progressive Web Apps arrives on macOS, bringing support for PWAs to all desktop and mobile platforms

matchAll() is a new regular expression matching method on the string prototype, and returns an array containing the complete matches

The `<link>` element now supports imagesrcset and imagesizes properties to correspond to srcset and sizes attributes of HTMLImageElement

Blink's shadow blur radius implementation now matches Firefox and Safari

Dark mode is now supported on Mac, and Windows support is on the way

Removal of EXPLAIN and REINDEX support in WebSQL

Removal of isomorphic decoding of URL fragment identifier

Deprecation of 'drive-by downloads' in sandboxed iframes

Stoppage of support for external web extensions in CRX2 format, making CRX3 format required

Android version:

Offline Content on the Dino Page: easily browse suggested articles while offline

Lite pages: get optimized pages that save data and load faster

iOS version:

Tap on the icons above the keyboard and easily access your saved passwords, addresses and credit card information

Updated default search engines list

View JavaScript console messages
	
74.0.3729 	2019-04-23

(Linux, macOS, and Windows)

2019-04-24 (Android)

2019-04-29 (iOS) 	Blink 74 (except iOS) 	7.4.288 	

"A number of fixes and improvements."

Creating private class fields in JavaScript is now much cleaner

You can detect when the user has requested a reduced motion experience

CSS transition events

Adds new feature policy APIs to check if features are enabled or not

Removal of PaymentAddress's languageCode property

No popups during page unload

Deprecation of drive-by downloads in sandboxed iframes

Android version:

Translate any web page instantly by selecting Translate from the menu

iOS version:

You can now paste pictures from your clipboard into the omnibox to search

A fix has been included for translation not being offered on some English pages.
	
75.0.3770 	2019-06-04

(Linux, macOS, and Windows)

2019-06-04 (iOS)

2019-06-04 (Android) 	Blink 75 (except iOS) 	7.5.288 	

"A number of fixes and improvements."

A new way to reduce latency on canvas elements

Web apps can now share files to other installed apps using the system level share sheet

Numeric literals now allow underscores as separators to make them more readable[

Removal of overflow: -webkit-paged-x and overflow: -webkit-paged-y

Android version:

Generate strong and unique passwords with Chrome's built-in password manager

Quickly look up your passwords by tapping any password field and using the new keyboard option

iOS version:

Links that are clicked in Incognito mode will no longer open native applications

Custom search engine settings now show the search engine's icon
	
76.0.3809 	2019-07-30

(Linux, macOS, and Windows)

2019-07-30 (iOS)

2019-07-30 (Android) 	Blink 76 (except iOS) 	7.6.303 	

"A number of fixes and improvements."

Support for prefers-color-scheme media query, bringing dark mode to websites

An install button in the omnibox to make installation of Progressive Web Apps on desktop easier

Addition of Promise.allSettled()

Reading blobs is easier

Image support in the async clipboard API

Removal of feature policy: lazyload

Removal of outputs from MediaStreamAudioDestinationNode

Removal of insecure usage of DeviceMotionEvent

Removal of insecure usage of DeviceOrientationEvent

Android version:

"Stability and performance improvements."

Preventing the mini-infobar from appearing on Progressive Web Apps on mobile

More frequent updates of WebAPKs

iOS version:

Find In Page now works on iFrames, including AMP (Accelerated Mobile Pages)

A suggestion for a strong and unique password on a keyboard when signing up to a new site

Control of all Sync and Google services settings in one place

Some users will see a new design for the way Chrome offers to save passwords
	
77.0.3865 	2019-09-10

(Linux, macOS, and Windows)

2019-09-10 (iOS)

2019-09-10 (Android) 	Blink 77 (except iOS) 	7.7.299 	

A number of fixes and improvements."

Forms get some new capabilities

The formdata event

Form-associated custom elements

Native lazy loading

Chrome DevSummit 2019 is happening November 11–12, 2019

Introduction of Content Picker API

New measurement units in the intl.NumberFormat API

Removal of card issuer networks as payment method names

Deprecation of Web MIDI use on insecure origins

Deprecation of WebVR 1.1 API

Android version:

"Stability and performance improvements."

A better way to track the performance of your site with Largest Contentful Paint

iOS version:

A new language settings page

You can clear your browsing data from a specific range of time

Omnibox suggestions are easier to read with added thumbnails and icons

Easily close tabs that are maliciously showing JavaScript dialogues
	
78.0.3904 	2019-10-22 (iOS)

2019-10-22 (Android)

2019-10-22

(Linux, macOS, and Windows) 	Blink 78 (except iOS) 	7.8.279 	

"A number of fixes and improvements."

CSS Properties and Values API

Fresher service workers

New origin trials

Native File System

SMS Receiver

Removal of XSS Auditor

Android version:

"Stability and performance improvements."

Dark theme for Chrome menus, settings, and surfaces

iOS version:

The ability to switch Chrome to dark mode if your device has been upgraded to iOS 13

Bookmarks, History, Recent Tabs, and Reading List are now presented as cards on iOS 13

The ability to add a new credit card directly in Chrome from the settings page

A fix for a navigation-related crash
	
79.0.3945 	2019-12-10 (iOS)

2019-12-10

(Linux, macOS, and Windows)

2019-12-10 (Android) 	Blink 79 (except iOS) 	7.9.317 	

"A number of fixes and improvements."

The ability to create immersive experiences with the WebXR Device API

The Wake Lock API is available as an origin trial

The rendersubtree attribute is available as an origin trial

Videos from the Chrome DevSummit are now online

Changes -webkit-appearance keywords to work only with specific element types

Android version:

"Stability and performance improvements."

Password safety

Support for virtual reality

The ability to reorder bookmarks

Installed Progressive Web Apps on Android now support maskable icons

iOS version:

Chrome will check if username and password are leaked if signed in to Chrome and then in to a website

Starting a search in the address bar will initiate top suggestions even if network connection is slow

80.0.3987 	2020-02-04

(Linux, macOS, and Windows)

2020-02-04 (Android)

2020-02-05 (iOS) 	Blink 80 (except iOS) 	8.0.426 	

"A number of fixes and improvements."

Modules in workers

Optional chaining in JavaScript

New origin trials

Origin trial graduations

Using #:~:text=something will have Chrome scroll to and highlight the first instance of that text fragment

Setting display: minimal-ui on a Desktop PWA adds a back and reload button to the title bar of the installed PWA

Support for using SVG images as favicons

Disallowed Synchronous XMLHTTPRequest() in Page Dismissal

Deprecation of FTP support

Removal of allowing popups during page reload

Non-origin-clean ImageBitmap serialization and transferring removed

Protocol handling now requires a secure context

Web Components v0 removed

Removal of -webkit-appearance:button for arbitrary elements

Android version:

"Stability and performance improvements."

Quieter notifications

SameSite cookies are enabled by default

Insecure audio and video on secure pages are automatically upgraded to secure connections

iOS version:

Starting a search in the address bar brings up top suggestions served locally even in Incognito Mode
	
81.0.4044 	2020-04-07

(Linux, macOS, and Windows)

2020-04-07 (Android)

2020-04-07 (iOS) 	Blink 81 (except iOS) 	8.1.307 	

"A number of fixes and improvements."

Updated Chrome release schedule

WebXR hit testing

App icon badging

New origin trial of Web NFC and other origin trials

The media session API now supports tracking position state

INTL API now provides a DisplayNames method

Deprecation and removal of "basic-card" support Payment Handler

Removal of supportedType field from BasicCardRequest

Removal of `<discard>` element

TLS 1.3 downgrade hardening bypass (Removal of TLS 1.0 and 1.1 is delayed to Chrome 84 due to the COVID-19 pandemic.)

Android version:

"Stability and performance improvements."

27 languages were added, including Burmese, Armenian, Urdu, Central Khmer, and Punjabi

Notification of whether a password is typed and saved on an unsafe site

iOS version:

Updated Terms of Service

Finding downloads in the downloads folder in Chrome's menu or in the device's Files app

Search suggestions will also include suggestions from the middle of words

Fixes for crashes related to bookmarks and security
	
83.0.4103 	2020-05-19

(Linux, macOS, and Windows)

2020-05-19 (Android)

2020-05-21 (iOS) 	Blink 83 (except iOS) 	8.3.110 	

Version 82 was skipped due to the COVID-19 pandemic. [bullshit, you only did this to increase your version number, which doesn't matter at all when you do things like this]

"A number of fixes and improvements."

Trusted types help prevent cross site scripting vulnerabilities

Form elements get an important make-over

A new way to detect memory leaks

The native file system API starts a new origin trial with added functionality

New cross-origin policies

The Web Vitals program provides unified guidance for quality signals that are essential to delivering a great user experience on the web

Chrome now supports the Barcode Detection API, which provides the ability to detect and decode barcodes

The new CSS @supports function provides feature detection for CSS selectors

New ARIA annotations support screen reader accessibility for comments, suggestions, and text highlights with semantic meanings (similar to `<mark>`)

The prefers-color-scheme media query lets authors support their own dark theme so they have full control over experiences they build

JavaScript now supports modules in shared workers

Disallowing of downloads in Sandboxed iframes

Android version:

No longer supports Android 4.4 (KitKat)

"Stability and performance improvements."

iOS version:

Allows users to see their last 5 search queries by tapping the address bar in a new tab when signed in with a Google account

Prompts and messages from Chrome have a refreshed look

iPhone users can change webpage text to a comfortable size by opening Chrome's menu and tapping "Zoom Text..." or by going to their Accessibility settings

Updated Terms of Service.
	
84.0.4147 	2020-07-14

(Linux, macOS, and Windows)

2020-07-14 (iOS)

2020-07-14 (Android) 	Blink 84 (except iOS) 	8.4.371 	

"A number of fixes and improvements."

App Icon Shortcuts

The Web Animations API adds support for a slew of previously unsupported features

Wake lock can prevent the screen from dimming or locking

The Content Indexing API helps surface content that is available offline

New origin trials for idle detection and Web Assembly SIMD

Same Site Cookie policy changes are starting to roll out again

Sites with abusive permission requests, or abusive notifications, will automatically be enrolled in our quieter notifications UI

New origin trial for QuicTransport

@import rules in CSSStyleSheet.replace() removed

Removal of TLS 1.0 and TLS 1.1

Android version:

"Stability and performance improvements."

iOS version:

New Safe Browsing features

Better mouse and trackpad support

You can now share a web page by creating and sharing a QR code

You can find your downloads in the downloads folder in Chrome's menu, or in your device's Files app

Addition of nicknames to your payment cards saved in Chrome

Windows:

Lightbox (JavaScript) (window inside window) no longer functions properly in Chromium based browsers.

85.0.4183 	2020-08-25

(Linux, macOS, and Windows)

2020-08-25 (iOS)

2020-08-25 (Android) 	Blink 85 (except iOS) 	8.5.210 	

"A number of fixes and improvements."

AppCache Removal Begins

Rejection of insecure SameSite=None cookies

-webkit-box quirks from -webkit-line-clamp

iOS version:

Ability to use passwords saved to Chrome in other apps on the device

Site information has a new look

Users can drag links between the apps when another app is open next to Chrome in split view

Fixes for clipboard crash and stability improvements

Android version:

"Stability and performance improvements."
	
86.0.4240 	2020-09-30 (iOS)

2020-10-06 (Android)

2020-10-06

(Linux, macOS, and Windows) 	Blink 86 (except iOS) 	8.6.395 	

"A number of fixes and improvements."

The File System Access API is now available

New origin trials for Web HID and the Multi-screen Window Placement API

The new CSS selector, :focus-visible, lets the user opt-in to the same heuristic the browser uses when it's deciding whether to display the default focus indicator

The user can customize the color, size, or type of number or bullet for lists with the CSS ::marker Pseudo-Element

Removal of WebComponents v0

Deprecation of FTP support

Android version:

"Stability and performance improvements."

iOS version:

Ability to make Chrome the default browser

Ability to check if saved passwords have been compromised and, if so, how to fix them

More sharing, opening, and other options when user taps and holds Bookmarks, history, recent tabs, and read later

Improvements to the personalized stories on New tab page

Chrome will offer some additional protection by checking known phishing websites with Google in real time if "Make searches and browsing better" is turned on.
	
87.0.4280 	2020-11-17

(Linux, macOS, and Windows)

2020-11-17 (Android)

2020-11-18 (iOS) 	Blink 87 (except iOS) 	8.7.220 

Automatic live captions for English video and audio.

"A number of fixes and improvements."

Users can now control pan, tilt, and zoom on webcams that support it

Range requests and service workers don't require as many workarounds

The font access API starts its origin trial

Flash Player end of support notifications now displaying at every launch unless Flash is disabled.

Transferable Streams - ReadableStream, WritableStream, and TransformStream objects can now be passed as arguments to postMessage()

Implemented most granular flow-relative features of the CSS Logical Properties and Values spec, including shorthands and offsets to make these logical properties and values a bit easier to write

New @font-face descriptors have been added to ascent-override, descent-override, and line-gap-override to override metrics of the font

Several new text-decoration and underline properties

A number of changes related to cross-origin isolation

Removal of comma separator in iframe allow attribute

Removal of -webkit-font-size-delta

Deprecation of FTP support

Altered macOS icon to match the design style of MacOS Big Sur

Android version:

"Stability and performance improvements."

iOS version

Users can now have multiple windows of Chrome at the same time on their iPad

New feature in Settings: Safety Check

Auto-fill is now more secure

88.0.4324 	2021-01-19

(Linux, macOS, and Windows)

2021-01-19 (Android) 	Blink 88 (except iOS) 	8.8.278 	

"A number of fixes and improvements."

Users can now upload extensions using manifest v3 to the Chrome Web Store

CSS aspect-ratio property

Heavy throttling of chained JavaScript timers

Play billing in Trusted Web Activity

To conform to a change in the HTML standard, anchor tags with target="_blank" will now imply rel="no-opener" by default

Pointer Lock API allows users to disable mouse acceleration

addEventListener now takes an Abort Signal as an option

No popups during page unload (enterprises)

Web Components v0 removed

Dropped support for OS X Yosemite

FTP support disabled

Android version:

"Stability and performance improvements."

iOS version:

Chrome 88 has been skipped over due to many Google products not updating in iOS since November 2020.
	
89.0.4389 	2021-03-02

(Linux, macOS, and Windows)

2021-03-02 (Android) 	Blink 89 (except iOS) 	8.9.255 	

"A number of fixes and improvements."

WebHID, WebNFC, and Web Serial are now available

Closed a loophole a few developers used to skirt the PWA installability checks

The arrival of Web Share and Web Share Target

Chrome now allows top level await within JavaScript modules

Updated icon shown in the omnibox for installable PWAs

Allowed users to sign up for the Digital Goods API origin trial if they have used a Trusted Web Activity to make their PWA available in the Play Store for Chrome OS

Removal of legacy prefixed events (webkitprerenderstart, webkitprerenderstop, webkitprerenderload, and webkitprerenderdomcontentloaded) dispatched on `<link rel=prerender>`

Stopped cloning sessionStorage for windows opened with noopener number

Dropped support for older x86 processors that don't support SSE3

Android version:

"Stability and performance improvements."

iOS version:

Chrome 89 has been skipped over due to many Google products not updating in iOS since November 2020.
	
90.0.4430 	2021-04-13 (Android)

2021-04-14

(Linux, macOS, and Windows)

2021-05-10 (iOS) 	Blink 90 (except iOS) 	9.0.257 	

"A number of fixes and improvements."

A new value for the CSS overflow property

The Feature Policy API has been renamed to Permissions Policy

A new way to implement and use Shadow DOM directly in HTML

Chrome's address bar will use https:// by default

AV1 encoder in desktop that is specifically optimized for video conferencing with WebRTC integration

Removal of Content Security Policy directive 'plugin-types'

Removal of WebRTC RTP data channels

Return of empty for navigator.plugins and navigator.mimeTypes

Android version

"Stability and performance improvements."

iOS version

Search and Dino widgets available on iOS 14

Users can edit saved usernames and passwords in Chrome Settings

Stability and performance improvements.
	
91.0.4472 	2021-05-25 (Android)

2021-05-25

(Linux, macOS, and Windows)

2021-06-03 (iOS) 	Blink 91 (except iOS) 	9.1.269 	

"A number of fixes and improvements."

Web apps that interact with files can now suggest file names and directories when using the File System Access API

The user can read files from the clipboard

If the website has more than one domain, and they share the same account management backend, the user can tell Chrome they're the same, allowing the password manager to suggest the right credentials

Web Transport-previously called Quic Transport has undergone a number of changes and is starting a new origin trial

Web Assembly SIMD has finished its origin trial and is available to all users

The `<link>` element's media attribute will be honored for link rel="icon", meaning the user can define different icons based on media queries

Android version:

"Stability and performance improvements."

The refreshed form elements have finally landed on Android, improving the user experience

iOS version:

Stability and performance improvements.

Tab Grid View can no longer be disabled

92.0.4515 	2021-07-20 (iOS)

2021-07-20

(Linux, macOS, and Windows)

2021-07-20 (Android) 	Blink 92 (except iOS) 	9.2.230 	

"A number of fixes and improvements."

Removal of payment handlers for standardized payment method identifiers

Android version:

"Stability and performance improvements."

iOS version:

Users can take a screenshot of the whole webpage, then look for the "Full Page" option at the top of the screenshot editor

Users can add more security to their Incognito tabs with Touch ID, Face ID, or a Passcode

New Discover design on the New Tab Page makes exploring interests easier

The ability to ask for confirmation if users want to close all tabs from the Tab Switcher

Users can share, bookmark, and add individual tabs to their reading list from the Tab Switcher

Stability and performance improvements.
	
93.0.4577 	2021-08-31 (iOS)

2021-08-31

(Linux, macOS, and Windows)

2021-08-31 (Android) 	Blink 93 (except iOS) 	9.3.345 	

"A number of fixes and improvements."

Users can now load CSS style sheets with import statements, just like JavaScript modules

Installed PWAs can register as URL handlers, making it possible for users to jump straight into their PWA

The Multi-Screen Window Placement API has been updated based on feedback and starts a second origin trial

Shortened release cycle

Flexbox and flexbox items have added support for the alignment keywords: start, end, self-start, self-end, left, and right

The async clipboard API now supports SVG files

The media attribute will be honored when setting meta theme-color

Blocked ports 989 and 990

Removal of 3DES in TLS

Deprecation of WebAssembly cross-origin module sharing

Android version:

"Stability and performance improvements."

iOS version:

Updated context menu when users tap and hold a link or image in a web site

Users already signed in to a Google Account can now sign in more easily to Chrome and other Google services on the web

Signed-in users can now both use and save payment methods from their Google Account, without sync

Stability and performance improvements

94.0.4606 	2021-09-21 (iOS)

2021-09-21

(Linux, macOS, and Windows)

2021-09-21 (Android) 	Blink 94 (except iOS) 	9.4.146 	

"A number of fixes and improvements."

The default color space for `<canvas>` elements is now formally defined in the spec as SRGB, and users can change it to Display P3

WebCodecs is a new, low level way to access built in audio and video codecs, important for streaming games, video editors, and such

WebGPU starts its origin trial

The prioritized scheduler.postTask() method allows users to schedule tasks, and dynamically change their priorities, or cancel them all together

The scrollbar-gutter property provides control over the presence of scrollbar gutters, allowing users to prevent layout changes as content expands

Virtual keybaord API gives users more control over how and when the virtual, on-screen keyboard is shown

Deprecation and removal of WebSQL in third-party contexts

Restriction of private network requests for subresources to secure contexts

Android version:

"Stability and performance improvements."

iOS version:

Users can now act on multiple tabs at once

Stability and performance improvements

95.0.4638 	2021-09-15 (iOS)

2021-09-23 (Android)

2021-09-24

(Linux, macOS, and Windows) 	Blink 95 (except iOS) 	9.5 	Current Beta channel 	

96.0 	2021-09-14 (iOS)

2021-09-24 (Android)

2021-09-24

(Linux, macOS, and Windows) 	Blink 96 (except iOS) 	9.6 	Current Dev channel 	

96.0 	2021-09-11

(macOS and Windows)

2021-09-11 (Android) 	Blink 96 	9.6 	Current Canary channel 	

Major version 	Release date 	Layout engine	V8 engine 	Significant changes 	Issues/Bugs

***

## Sources

1. [Wikipedia - Google Chrome version history](https://en.wikipedia.org/wiki/Google_Chrome_version_history)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being partially copied from Wikipedia.

***

## Article info

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**File version:** `1 (Sunday, 2021 October 3rd at 6:34 pm)`

**Line count (including blank lines and compiler line):** `2797`

***

## Technical notes

**All times are UTC-7 (PDT/Pacific Time)**

**The encoding is UTF-8 and is compatible with Unicode 5.0 and up**

***

