
***

# Android (Google operating system)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2019/Android_new_logo_2019.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Android/Logotype/2019/Android_new_logo_2019.svg)

Android is a mobile operating system based on a modified version of the Linux kernel and other open source software, designed primarily for touchscreen mobile devices such as smartphones and tablets. Android is developed by a consortium of developers known as the Open Handset Alliance and commercially sponsored by Google. It was unveiled in November 2007, with the first commercial Android device, the HTC Dream, being launched in September 2008.

It is free and open-source software; its source code is known as Android Open Source Project (AOSP), which is primarily licensed under the Apache License. However most Android devices ship with additional proprietary software pre-installed, most notably Google Mobile Services (GMS) which includes core apps such as Google Chrome, the digital distribution platform Google Play and associated Google Play Services development platform.

Over 70 percent of Android smartphones run Google's ecosystem; some with vendor-customized user interface and software suite, such as TouchWiz and later One UI by Samsung, and HTC Sense. Competing Android ecosystems and forks include Fire OS (developed by Amazon) or LineageOS. However the "Android" name and logo are trademarks of Google which impose standards to restrict "uncertified" devices outside their ecosystem to use Android branding.

The source code has been used to develop variants of Android on a range of other electronics, such as game consoles, digital cameras, portable media players, PCs and others, each with a specialized user interface. Some well known derivatives include Android TV for televisions and Wear OS for wearables, both developed by Google. Software packages on Android, which use the APK format, are generally distributed through proprietary application stores like Google Play Store, Samsung Galaxy Store, Huawei AppGallery, Cafe Bazaar, and GetJar, or open source platforms like Aptoide or F-Droid.

Android has been the best-selling OS worldwide on smartphones since 2011 and on tablets since 2013. As of May 2021, it has over three billion monthly active users, the largest installed base of any operating system, and as of January 2021, the Google Play Store features over 3 million apps. Android 11, released on September 8, 2020, is the latest and most popular version (and that single version is close to as popular as all iPhones combined, with all Android versions combined having a dominant market share). 

## See also

[Android version history](https://github.com/seanpm2001/Degoogle-your-life/Android-version-history/)

[List of Google operating systems](https://github.com/seanpm2001/Degoogle-your-life/List-of-Google-operating-systems/)

[Android 1.5 (Cupcake)](https://github.com/seanpm2001/Degoogle-your-life/Android-1-5-Cupcake/)

## Alternatives

Alternative operating systems include:

RemixOS

ReplicantOS

LineageOS

GrapheneOS

PostMarketOS

TizenOS

iOS

iPadOS

Ubuntu Touch

Manjaro Linux

Android x86 (possibly PC only (note: PC does not mean Windows, it means Windows, MacOS, BSD, Linux, AmigaOS, Solaris, and various other operating systems on a personal computer))

[Suggest a new/better one](https://github.com/seanpm2001/Degoogle-your-life/issues/)

Note: the entries `iOS`, `iPadOS` and `TizenOS` do not respect user privacy that well.

Note: Samsung phones in the USA that have knox "security" are currently not able to be rooted due to deep DRM and another operating system cannot be placed on the phone (as of yet, people are actively working on cracking it. It is always cracked, it just may take multiple years) Samsung phones in Europe and other countries can be rooted, along with most other mobile device manufacturers.

***

## Sources

![https://en.wikipedia.org/wiki/Android_(operating_system)](https://en.wikipedia.org/wiki/Android_(operating_system))

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being partially copied from Wikipedia.

***

## Article info

**File type:** `Markdown document (*.md *.mkd *.markdown)`

**File version:** `1 (Sunday, 2021 October 3rd at 6:57 pm)`

**Line count (including blank lines and compiler line):** `85`

***

## Technical notes

**All times are UTC-7 (PDT/Pacific Time)**

**The encoding is UTF-8 and is compatible with Unicode 5.0 and up**

***

