
***

# Nothing to hide argument

If you think you have nothing to hide, **you are absolutely wrong**. This argument has been debunked many times over:

[Via Wikipedia](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism)

1. Edward Snowden remarked "Arguing that you don't care about the right to privacy because you have nothing to hide is no different than saying you don't care about free speech because you have nothing to say. "When you say, ‘I have nothing to hide,’ you’re saying, ‘I don’t care about this right.’ You’re saying, ‘I don’t have this right, because I’ve got to the point where I have to justify it.’ The way rights work is, the government has to justify its intrusion into your rights."

2. Daniel J. Solove stated in an article for The Chronicle of Higher Education that he opposes the argument; he stated that a government can leak information about a person and cause damage to that person, or use information about a person to deny access to services even if a person did not actually engage in wrongdoing, and that a government can cause damage to one's personal life through making errors. Solove wrote "When engaged directly, the nothing-to-hide argument can ensnare, for it forces the debate to focus on its narrow understanding of privacy. But when confronted with the plurality of privacy problems implicated by government data collection and use beyond surveillance and disclosure, the nothing-to-hide argument, in the end, has nothing to say."

3. Adam D. Moore, author of Privacy Rights: Moral and Legal Foundations, argued, "it is the view that rights are resistant to cost/benefit or consequentialist sort of arguments. Here we are rejecting the view that privacy interests are the sorts of things that can be traded for security." He also stated that surveillance can disproportionately affect certain groups in society based on appearance, ethnicity, sexuality, and religion.

4. Bruce Schneier, a computer security expert and cryptographer, expressed opposition, citing Cardinal Richelieu's statement "If one would give me six lines written by the hand of the most honest man, I would find something in them to have him hanged", referring to how a state government can find aspects in a person's life in order to prosecute or blackmail that individual. Schneier also argued "Too many wrongly characterize the debate as 'security versus privacy.' The real choice is liberty versus control."

5. Harvey A. Silverglate estimated that the common person, on average, unknowingly commits three felonies a day in the US.

6. Emilio Mordini, philosopher and psychoanalyst, argued that the "nothing to hide" argument is inherently paradoxical. People do not need to have "something to hide" in order to hide "something". What is hidden is not necessarily relevant, claims Mordini. Instead, he argues an intimate area which can be both hidden and access-restricted is necessary since, psychologically speaking, we become individuals through the discovery that we could hide something to others.

7. Julian Assange stated "There is no killer answer yet. Jacob Appelbaum (@ioerror) has a clever response, asking people who say this to then hand him their phone unlocked and pull down their pants. My version of that is to say, 'well, if you're so boring then we shouldn't be talking to you, and neither should anyone else', but philosophically, the real answer is this: Mass surveillance is a mass structural change. When society goes bad, it's going to take you with it, even if you are the blandest person on earth."

8. Ignacio Cofone, law professor, argues that the argument is mistaken in its own terms because, whenever people disclose relevant information to others, they also disclose irrelevant information. This irrelevant information has privacy costs and can lead to other harms, such as discrimination.

These are just the top 8 examples, there are many more examples, I hope to list more in the future.

9. A prominent anti vaccination figure gave out his phone number at a rally, claiming he had "nothing to hide" and just 2 days later, he is begging people to stop calling him. [Source 1](https://editorials24.com/2021/09/a-prominent-anti-vaxxer-gave-out-his-phone-number-at-a-rally-because-he-has-nothing-to-hide-two-days-later-hes-begging-people-to-stop-calling-him/) [Source 2](https://news.yahoo.com/prominent-anti-vaxxer-gave-phone-043219750.html) **Need better sources on this**

10. (World War II) On 27 March 1943, a cell of the Dutch resistance committed an attack on the municipal register of Amsterdam. The German occupier had found this register to be extremely convenient: it contained the details of 70.000 Jews in Amsterdam. Also, it proved useful as a means of cross-checking information on identity cards.

**3 major reasons from DuckDuckGo plus 6 additional reasons**

11. 1) Privacy isn’t about hiding information; privacy is about protecting information, and surely you have information that you’d like to protect.

Do you close the door when you go to the bathroom? Would you give your bank account information to anyone? Do you want all your search and browsing history made public? Of course not.

Simply put, everyone wants to keep certain things private and you can easily illustrate that by asking people to let you make all their emails, texts, searches, financial information, medical information, etc. public. Very few people will say yes.

12. 2) Privacy is a fundamental right and you don't need to prove the necessity of fundamental rights to anyone.

You should have the right to free speech even if you feel you have nothing important to say right now. You should have the right to assemble even if you feel you have nothing to protest right now. These should be fundamental rights just like the right to privacy.

And for good reason. Think of commonplace scenarios in which privacy is crucial and desirable like intimate conversations, medical procedures, and voting. We change our behavior when we're being watched, which is made obvious when voting; hence, an argument can be made that privacy in voting underpins democracy.

13. 3) Lack of privacy creates significant harms that everyone wants to avoid.

14. You need privacy to avoid unfortunately common threats like identity theft, manipulation through ads, discrimination based on your personal information, harassment, the filter bubble, and many other real harms that arise from invasions of privacy.

15. In addition, what many people don’t realize is that several small pieces of your personal data can be put together to reveal much more about you than you would think is possible. For example, an analysis conducted by MIT researchers found that “just four fairly vague pieces of information — the dates and locations of four purchases — are enough to identify 90 percent of the people in a data set recording three months of credit-card transactions by 1.1 million users.”

16. It’s critical to remember that privacy isn't just about protecting a single and seemingly insignificant piece of personal data, which is often what people think about when they say, “I have nothing to hide.” For example, some may say they don't mind if a company knows their email address while others might say they don't care if a company knows where they shop online.

17. However, these small pieces of personal data are increasingly aggregated by advertising platforms like Google and Facebook to form a more complete picture of who you are, what you do, where you go, and with whom you spend time. And those large data profiles can then lead much more easily to significant privacy harms. If that feels creepy, it’s because it is.

18. We can't stress enough that your privacy shouldn’t be taken for granted. The ‘I have nothing to hide’ response does just that, implying that government and corporate surveillance should be acceptable as the default.

19. Privacy should be the default. We are setting a new standard of trust online and believe getting the privacy you want online should be as easy as closing the blinds.

**Commentary on the argument from Eduzaurus:**

20. Solove’s uses the ethos appeal to get to the audience to think about the ethical. He does this by starting an argument, “I’ve got nothing to hide…only if you’re doing something wrong should you worry, and then you don’t deserve to keep it private” (734). He also uses a logical tone to appeal to the audience he explains how this brief argument goes from faulty to explaining what privacy really means as well as what we retain from the information given.

21. “Thus, some might argue, the privacy interest is minimal, and the security interest in preventing terrorism is much more important. In the less extreme form, the nothing-to-hide argument is a formidable one. (737)” He uses logos to point of the fact that privacy issues aren’t as important as the terrorism issues we have in the world pathos is because he wants to evoke the emotional aspect of his readers. The statement builds trust between Solove and the audience. He recognizes a similar belief that the government does not have the right to go through their privacy without permission, which many of the audience members can relate to.

22. He wants his audience to conclude that it’s lousy for the government to get involved in people’s privacy. We should do something to protect our privacy. To establish a relationship and persuade the audience, to investigate their privacy and see what the government is monitoring what we are doing. He also argues that the process of information storage and analysis creates a power imbalance between the people and the government. The government is always monitoring what we say and do online. He says, “If you’ve got nothing to hide, you’ve got nothing to fear” (735). Everyone has something to hide nobody watches what they say or do all the time.

23. Solove said you have nothing to hide and nothing to fear, whereas Aleksandr Solzhenitsyn says “Everyone is guilty of something or has something to conceal. All one has to do is look hard enough to find what it is” (736), which means that everyone secretly has something they don’t want to turn up or the government to see. Everyone values their privacy even if they act like they don’t care. There is no sentient human in the world who doesn’t have any regard to their personal privacy.

24. Everyone has some concern for what the government and others look at or come across when searching the web. The nothing to hide argument simply states, “not all personal information but only to the type of data the government is likely to collect” (737). All the information that is collected is closed off from the public and it is very rare for someone to see the information that is collected yet it will always be accessible. The only way to know your privacy is to know the laws around it.

25. More examples coming soon

***

# Sources

1. [https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism)

2. [https://editorials24.com/2021/09/a-prominent-anti-vaxxer-gave-out-his-phone-number-at-a-rally-because-he-has-nothing-to-hide-two-days-later-hes-begging-people-to-stop-calling-him](https://editorials24.com/2021/09/a-prominent-anti-vaxxer-gave-out-his-phone-number-at-a-rally-because-he-has-nothing-to-hide-two-days-later-hes-begging-people-to-stop-calling-him)

3. [https://news.yahoo.com/prominent-anti-vaxxer-gave-phone-043219750.html](https://news.yahoo.com/prominent-anti-vaxxer-gave-phone-043219750.html)

4. [During World War 2, we did have something to hide (Medium)](https://medium.com/@hansdezwart/during-world-war-ii-we-did-have-something-to-hide-40689565c550)

5. [https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism)

6. [https://spreadprivacy.com/three-reasons-why-the-nothing-to-hide-argument-is-flawed/](https://spreadprivacy.com/three-reasons-why-the-nothing-to-hide-argument-is-flawed/)

7. [https://eduzaurus.com/free-essay-samples/nothing-to-hide-argument-has-nothing-to-say/](https://eduzaurus.com/free-essay-samples/nothing-to-hide-argument-has-nothing-to-say/)

I need more sources and better sources for this article. This article is also a stub, and needs to be expanded and rewritten in some parts.

***

## Article info

**Written on:** `2021 Saturday, October 2nd at 5:13 pm`

**Last revised on:** `2021 Saturday, October 2nd at 5:13 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `117`

**Article version:** `1 (2021 Saturday, October 2nd at 5:13 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/Degoogle-your-life/wiki/

!-->

