
***

# Don't be evil

"Don't be evil" is a phrase used in Google's corporate code of conduct, which it also formerly preceded as a motto.

Following Google's corporate restructuring under the conglomerate Alphabet Inc. in October 2015, Alphabet took "Do the right thing" as its motto, also forming the opening of its corporate code of conduct. The original motto was retained in Google's code of conduct, now a subsidiary of Alphabet. In April 2018, the motto was removed from the code of conduct's preface and retained in its last sentence.

## History

The motto was first suggested either by Google employee Paul Buchheit at a meeting about corporate values that took place in early 2000 or in 2001 or, according to another account, by Google engineer Amit Patel in 1999. Buchheit, the creator of Gmail, said he "wanted something that, once you put it in there, would be hard to take out", adding that the slogan was "also a bit of a jab at a lot of the other companies, especially our competitors, who at the time, in our opinion, were kind of exploiting the users to some extent".

While the official corporate philosophy of Google does not contain the words "Don't be evil", they were included in the prospectus (on Form S-1) of Google's 2004 IPO (a letter from Google's founders, later called the "'Don't Be Evil' manifesto"): "Don't be evil. We believe strongly that in the long term, we will be better served—as shareholders and in all other ways—by a company that does good things for the world even if we forgo some short term gains." The motto is sometimes incorrectly stated as Do no evil.

By early 2018, the motto was still cited in the preface to Google's Code of Conduct:

"Don't be evil." Googlers generally apply those words to how we serve our users. But "Don't be evil" is much more than that...

The Google Code of Conduct is one of the ways we put "Don't be evil" into practice...

Between 21 April and 4 May 2018, Google removed the motto from the preface, leaving a mention in the final line: "And remember… don't be evil, and if you see something that you think isn't right – speak up!"

## Interpretations

In their 2004 founders' letter prior to their initial public offering, Larry Page and Sergey Brin argued that their "Don't be evil" culture prohibited conflicts of interest, and required objectivity and an absence of bias:

Google users trust our systems to help them with important decisions: medical, financial and many others. Our search results are the best we know how to produce. They are unbiased and objective, and we do not accept payment for them or for inclusion or more frequent updating. We also display advertising, which we work hard to make relevant, and we label it clearly. This is similar to a well-run newspaper, where the advertisements are clear and the articles are not influenced by the advertisers’ payments. We believe it is important for everyone to have access to the best information and research, not only to the information people pay for you to see.

In 2009, Chris Hoofnagle, director of University of California, Berkeley Law's information privacy programs, stated that Google's original intention expressed by the "don't be evil" motto was linked to the company's separation of search results from advertising. However, he observed that clearly separating search results from sponsored links is required by law, thus, Google's practice had since become mainstream and was no longer remarkable or good. Hoofnagle argued that Google should abandon the motto because:

The evil talk is not only an albatross for Google, it obscures the substantial consumer benefits from Google’s advertising model. Because we have forgotten the original context of Google’s evil representations, the company should remind the public of the company’s contribution to a revolution in search advertising, and highlight some overlooked benefits of their model.

In a 2013 NPR interview, Eric Schmidt revealed that when Larry Page and Sergey Brin recommended the motto as a guiding principle for Google, he "thought this was the stupidest rule ever", but then changed his opinion after a meeting where an engineer successfully referred to the motto when expressing concerns about a planned advertising product, which was eventually cancelled. Journalists have raised questions about the actual definition of what Google considered "evil". On the user-facing 'What We Believe' page, Google appeared to replace the original motto altogether (a carefully reworded version stood as of 10 April 2015, "You can make money without doing evil", which varied significantly from the absolute imperative of DON'T be evil).

## Use in criticism of Google

Critics of Google frequently spin the motto in a negative way, such as InfoWorld's 2014 article "Google? Evil? You have no idea". Google's 2012 announcement to "begin tracking users universally across all its services" (via "Google Plus" accounts) resulted in public backlash on the motto, like "Google's Broken Promise: The End of 'Don't Be Evil'" on Gizmodo. In the same year, major social networks even co-developed a Don't be evil browser bookmarklet (specifically to expose alleged SERP manipulation promoting Google-owned content over that of others).

On 16 May 2013, Margaret Hodge MP, the chair of the United Kingdom Public Accounts Committee, accused Google of being "calculated and unethical" over its use of highly contrived and artificial distinctions to avoid paying billions of pounds in corporation tax owed by its UK operations. The company was accused by the committee, which represents the interests of all UK taxpayers, of being "evil" for not paying its "fair amount of tax". She told Matt Brittin, head of Google UK, "I think that you do evil". In 2015, the UK Government introduced a new law intended to penalise Google and other large multinational corporations' artificial tax avoidance.

In 2015, the Commercial Appeal reported that "critics say Google's recent moves belie search giant's motto".

## Sources

[Don't be evil on Wikipedia](https://en.wikipedia.org/wiki/Don%27t_be_evil)

I need more sources and better sources for this article. This article also needs to be rewritten, as it is a copy and paste from Wikipedia.

***

## Article info

**Written on:** `2021 Saturday, October 2nd at 8:15 pm`

**Last revised on:** `2021 Saturday, October 2nd at 8:15 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `73`

**Article version:** `1 (2021 Saturday, October 2nd at 8:15 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/Degoogle-your-life/wiki/

!-->

