
***

# DRM

DRM is a highly restrictive set of malicious software imposed on computer users who want to view content.

## Overview

For other information about why DRM is a problem, [click/tap here](https://www.defectivebydesign.org/)

A general description of DRM: <!-- I worked on making this as easy as possible to read for non-tech savvy people !-->

DRM is a restrictive form of software that prevents you from being able to freely access digital works. In short, when you use DRM, you don't own what you are using, the computer uses you. DRM can be malicious and highly anti-competitive, and it is bad for the environment and your devcies battery life and lifespan due to excessive use of the CPU (processor) and GPU (Graphics card) for example, it can make it so an eBook you download isn't owned by you, and the seller can modify the book or delete it without your permission, as you don't own that book. [Source 1](https://www.quora.com/Can-Amazon-delete-books-on-my-Kindle?share=1) [Source 2](https://www.syfy.com/syfywire/amazon_deletes_1984_from) [Source 3](https://www.npr.org/templates/story/story.php?storyId=106989048) [Source 4](https://mashable.com/2009/07/17/amazon-kindle-1984/) [Source 5](https://www.nytimes.com/2009/07/18/technology/companies/18amazon.html)

WideVine is the most common video DRM, which restricts your access to videos on a website (such as Netflix, Disney+, Hulu, etc.) it is completely unnecessary, and can lock you out of a service (for example, many streaming services don't work on browsers other than Google Chrome (not even browsers based on Google Chromium, the source code for Chrome, can access these sites) due to Googles DRM monopoly) [see below for more info](#Anti-competitive).

***

## Anti-competitive

DRM has to be licensed to be used with a browser. Google is extremely slow on reviewing and accepting people, and often refuses people to use it in their products with no reasoning. [Source 1](https://blog.samuelmaddock.com/posts/google-DRM-blocked-my-browser/) [Source 2 (the email thread that went on for over 4 months and resulted in nothing but disappointment)](https://blog.samuelmaddock.com/DRM/gmail-thread.html)

Google has made it much harder for browsers like Brave or Firefox to compete with its pushing of this piece of DRM. Even just using the Electron framework itself will prevent its DRM from working (so you can't visit sites like Netflix, Hulu, etc.) [Source 3](https://github.com/brave/browser-laptop/issues/10449) [Source 4](https://github.com/electron/electron/issues/12427)

***

## Cost

DRM costs money monthly to implement, making only the wealthy able to survive in software. This is similar to the high requirements to run Android Studio to develop Android apps, and the Registration + device ownership required to make Apple software (requiring either an expensive apple device alongside your usual device, or a well-made "illegal" hackintosh virtual machine)

***

## Prevents screenshots and recording

Some DRM can detect if you are using a screen recorder or taking screenshots. While most would say that this is just copyright infringement prevention, people don't see that this is a loss of software freedom. There are very legitimate cases in which a screenshot or screenclip is necessary and falls under fair use (such as reporting a site bug, or reporting rule breaking/illegal content found online) but that isn't possible unless you crack DRM, which is very easy to do (see below)

***

## Blocking out users

Due to the restrictiveness of DRM, certain websites (such as HBO Max) have used the DRM to outright lock millions of would-be Linux HBO Max streamers from even using the site. The same can be done for any operating system that HBO disagrees with, and this ban could easily apply to BSD, MacOS, Windows, Solaris, or other operating systems, as criticism doesn't always work with companies.

Linux is not a system that you should block, as you are blocking out most of the tech savvy users, and over ten million people, as Linux is A LOT bigger now than it was in the early 1990s. The same can be said for BSD, MacOS and Windows, although Windows has always been pretty big since Windows 3.1 and Windows 95.

***

## Bugs

DRM has been a center of controversy due to its severe bugs that make its users suffer even more. A common problem occurred in 2021 April when Googles WideVine was auto-updated, and Netflix was unable to let anyone stream content above 480p. With a bug like this, it is entirely possible for a DRM bug to come along that will completely block all video playback on any site that uses it.

No other bugs are listed yet.

***

## Why DRM is not needed

DRM is not needed in a functional society, it just places extra restrictions on the users, and takes extra time and resources to enforce these restrictions, albeit unsuccessfully.

DRM is easily crackable, no DRM is actually secure. For DRM, there are already hundreds of legitimate downloading tools that can bypass DRM.

It claims to be a security thing, when in fact, it is an insecurity. Let your content be free. It isn't making it any harder for people to rip and download your content, why do you want to add the restriction if it is meaningless?

DRM is bad for the environment due to the extra resources it takes, and how it wears down hardware faster.

DRM is bad for the user, as it places unnecessary restrictions on them.

DRM is bad for the developer, as it puts the developer through lots of extra stress on a pointless task that doesn't benefit anybody.

DRM is bad for the world, as it is bad on the environment, the user, and even the developer.

We can live without DRM. It is a crutch we seem to have accepted, but the crutch is being used for a perfectly working set of legs.

***

## Asserting Googles dominance

Googles uses DRM to assert its dominance with Google Chrome, as it doesn't work on many other browsers they disagree with, even other Chromium-based browsers, such as Brave.

It also asserts Googles dominance on their Android operating system, certain aspects of their DRM make rooted Android devices (such as those with LineageOS) to be unable to do certain tasks.

Google knows this is a way to get what they want, and they have a history of taking down any repository that they find that can crack/break DRM DRM.

As of Google Chrome V57 (2017 March) and later, Google forces DRM to be installed for the browser, and doesn't let you remove it.

***

## Violation of web standards

DRM has always been controversial. Originally, when DRM was proposed for HTML5, it was approved because of Netflix, and it was so controversial, that the web standards group lost one of its founding members (EFF, Electronic Frontiers Foundation) as they accepted this damaging problem. Since then, DRM has become much more common, but still needs to be combated.

With Googles usage of DRM, and its history of locking other browsers out of its features, it is possible that Google may try to make Chrome the only browser that can use DRM, and restrict other browsers from using it.

***

## Lack of freedom

DRM is used to prevent users from interacting with video on websites. It is a form of digital restrictions managements that prevents you from downloading the video, viewing the video offline, or even taking a screenshot. It is proprietary software and due to its issues with privacy, it is not installed by default on most Linux distributions. It is limiting the freedoms of the web due to its use by Netflix, Disney, and YouTube movies. Your access to the content can be taken away at any time for no reason.

***

## Memory usage

DRM is bad on memory. Compared to just normally viewing a video without DRM, DRM will use heavy amounts of CPU and RAM. It is bad on battery life, and it gives no benefits from standard HTML5 video playback.

***

## Privacy

[G](https://en.wikipedia.org/wiki/Criticism_of_Google)[o](https://en.wikipedia.org/wiki/PRISM_(surveillance_program))[o](https://www.reddit.com/r/degoogle/)[g](https://www.wired.com/2012/06/opinion-google-is-evil/)[l](https://securitygladiators.com/chrome-privacy-bad/)[e](https://www.zdnet.com/article/goodbye-google-why-and-how-to-take-back-your-privacy/) [h](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[a](https://www.vox.com/recode/2020/2/21/21146998/google-new-mexico-children-privacy-school-chromebook-lawsuit)[s](https://www.eff.org/deeplinks/2019/08/dont-play-googles-privacy-sandbox-1) [a](https://money.cnn.com/2017/10/11/technology/google-home-mini-security-flaw/index.html) [v](https://www.huffpost.com/entry/why-googles-spying-on-use_b_3530296)[e](https://medium.com/digiprivacy/i-stopped-using-google-as-my-search-engine-heres-why-7a3a1b4fef81)[r](https://www.theguardian.com/technology/2019/nov/05/fitbit-google-acquisition-health-data)[y](https://www.computerworld.com/article/3128791/how-google-homes-always-on-will-affect-privacy.html) [v](https://protonmail.com/blog/google-privacy-problem/)[e](https://www.forbes.com/sites/gordonkelly/2020/02/23/google-chrome-80-upgrade-deep-linking-update-chrome-browser/)[r](https://www.wired.co.uk/article/duckduckgo-google-alternative-search-privacy)[y](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism) [b](https://spreadprivacy.com/three-reasons-why-the-nothing-to-hide-argument-is-flawed/)[a](https://eduzaurus.com/free-essay-samples/nothing-to-hide-argument-has-nothing-to-say/)[d](https://www.cnet.com/how-to/google-collects-a-frightening-amount-of-data-about-you-you-can-find-and-delete-it-now/) [r](https://www.nbcnews.com/tech/tech-news/google-sells-future-powered-your-personal-data-n870501)[e](https://www.eff.org/deeplinks/2020/03/google-says-it-doesnt-sell-your-data-heres-how-company-shares-monetizes-and)[c](https://www.wired.com/story/google-tracks-you-privacy/)[o](https://www.theguardian.com/commentisfree/2018/mar/28/all-the-data-facebook-google-has-on-you-privacy)[r](https://www.dailymail.co.uk/sciencetech/article-5743829/Googles-vision-TOTAL-data-collection-revealed.html)[d](https://www.reuters.com/article/us-alphabet-google-privacy-lawsuit-idUSKBN23933H) [w](https://www.wired.com/story/health-fitness-data-privacy/)[h](https://www.pcmag.com/news/google-sued-over-kids-data-collection-on-education-chromebooks)[e](https://mashable.com/article/google-android-data-collection-study/)[n](https://www.engadget.com/australian-government-google-data-collection-lawsuit-182043643.html) [i](https://www.maketecheasier.com/studyandroid-data-google-ios-apple/)[t](https://www.washingtonpost.com/technology/2019/07/23/never-googlers-web-users-take-ultimate-step-guard-their-data/) [c](https://www.cnn.com/2019/11/12/business/google-project-nightingale-ascension/index.html)[o](https://en.wikipedia.org/wiki/2018_Google_data_breach)[m](https://moz.com/blog/where-does-google-draw-the-data-collection-line)[e](https://mashable.com/article/google-android-data-collection-study/)[s](https://eandt.theiet.org/content/articles/2020/06/google-sued-over-data-collection-from-users-in-incognito-mode/) [t](https://www.nytimes.com/2019/01/21/technology/google-europe-gdpr-fine.html)[o](https://www.bloomberg.com/news/articles/2017-11-30/google-sued-over-data-claims-on-behalf-of-5-million-iphone-users) [u](https://time.com/23782/google-flu-trends-big-data-problems/)[s](https://www.reuters.com/article/dataprivacy-googleyoutube-kidsdata-idUSL1N2J306W)[e](https://www.adweek.com/performance-marketing/google-is-collecting-your-data-even-when-your-phone-isnt-in-use/)[r](https://www.computerworld.com/article/2914838/project-fi-will-help-google-amass-even-more-data-about-you.html) [p](https://topclassactions.com/lawsuit-settlements/privacy/google-says-class-action-lawsuit-plaintiffs-consented-to-data-collection/)[r](https://arstechnica.com/information-technology/2014/01/what-google-can-really-do-with-nest-or-really-nests-data/)[i](https://www.cbsnews.com/news/google-education-spies-on-collects-data-on-millions-of-kids-alleges-lawsuit-new-mexico-attorney-general/)[v](https://www.nationalreview.com/2018/04/the-student-data-mining-scandal-under-our-noses/)[a](https://www.wired.com/insights/2012/10/google-opt-out/)[c](https://www.nytimes.com/2019/09/04/technology/google-youtube-fine-ftc.html)[y](https://medium.com/@hansdezwart/during-world-war-ii-we-did-have-something-to-hide-40689565c550)[.](https://medium.com/digitalprivacywise/why-you-should-stop-using-google-chrome-6c934c9a827c) (I could go on and on with evidence of this, but it took a long time to find and go through all these articles)

Privacy is not a thing with DRM. Proprietary software is designed so that you can't see what is going on at all. With Googles history, it is highly likely that the WideVine DRM piece is an additional piece of software that is spying on you, reading your documents, and other bad things.

If you think you have nothing to hide, **you are absolutely wrong**. This argument has been debunked many times over:

[Via Wikipedia](https://en.wikipedia.org/wiki/Nothing_to_hide_argument#Criticism)

1. Edward Snowden remarked "Arguing that you don't care about the right to privacy because you have nothing to hide is no different than saying you don't care about free speech because you have nothing to say. "When you say, ‘I have nothing to hide,’ you’re saying, ‘I don’t care about this right.’ You’re saying, ‘I don’t have this right, because I’ve got to the point where I have to justify it.’ The way rights work is, the government has to justify its intrusion into your rights."

2. Daniel J. Solove stated in an article for The Chronicle of Higher Education that he opposes the argument; he stated that a government can leak information about a person and cause damage to that person, or use information about a person to deny access to services even if a person did not actually engage in wrongdoing, and that a government can cause damage to one's personal life through making errors. Solove wrote "When engaged directly, the nothing-to-hide argument can ensnare, for it forces the debate to focus on its narrow understanding of privacy. But when confronted with the plurality of privacy problems implicated by government data collection and use beyond surveillance and disclosure, the nothing-to-hide argument, in the end, has nothing to say."

3. Adam D. Moore, author of Privacy Rights: Moral and Legal Foundations, argued, "it is the view that rights are resistant to cost/benefit or consequentialist sort of arguments. Here we are rejecting the view that privacy interests are the sorts of things that can be traded for security." He also stated that surveillance can disproportionately affect certain groups in society based on appearance, ethnicity, sexuality, and religion.

4. Bruce Schneier, a computer security expert and cryptographer, expressed opposition, citing Cardinal Richelieu's statement "If one would give me six lines written by the hand of the most honest man, I would find something in them to have him hanged", referring to how a state government can find aspects in a person's life in order to prosecute or blackmail that individual. Schneier also argued "Too many wrongly characterize the debate as 'security versus privacy.' The real choice is liberty versus control."

5. Harvey A. Silverglate estimated that the common person, on average, unknowingly commits three felonies a day in the US.

6. Emilio Mordini, philosopher and psychoanalyst, argued that the "nothing to hide" argument is inherently paradoxical. People do not need to have "something to hide" in order to hide "something". What is hidden is not necessarily relevant, claims Mordini. Instead, he argues an intimate area which can be both hidden and access-restricted is necessary since, psychologically speaking, we become individuals through the discovery that we could hide something to others.

7. Julian Assange stated "There is no killer answer yet. Jacob Appelbaum (@ioerror) has a clever response, asking people who say this to then hand him their phone unlocked and pull down their pants. My version of that is to say, 'well, if you're so boring then we shouldn't be talking to you, and neither should anyone else', but philosophically, the real answer is this: Mass surveillance is a mass structural change. When society goes bad, it's going to take you with it, even if you are the blandest person on earth."

8. Ignacio Cofone, law professor, argues that the argument is mistaken in its own terms because, whenever people disclose relevant information to others, they also disclose irrelevant information. This irrelevant information has privacy costs and can lead to other harms, such as discrimination.

***

# Alternative methods

Media should not be restricted, online or offline. If people wanted to watch the video without the DRM, they will always find a way to do it. Every piece of software can be cracked. 

[modified excerpt from Wikipedia] Valve president Gabe Newell has stated "most DRM strategies are just dumb" because they only decrease the value of a game in the consumer's eyes. Newell suggests that the goal should instead be "[creating] greater value for customers through service value". Note that Valve operates Steam, a service which serves as an online store for PC games, as well as a social networking service and a DRM platform

This point isn't valid just for video games, it can be applied to anything on a computer. Your computer shouldn't be in complete control of a crazy company that uses bad Artificial Intelligence to delete its users and their work (YouTube, etc.) and has such a bad record. Your computer shouldn't be restricted because a company refuses to share like a badly behaved child. Your computer should be owned by you, and no-one else. You should get rid of DRM altogether, as the content is not worth giving up control of your computer for. These companies have hundreds of billions of dollars. If they do something stupid like this, you should protest it. You could even just download the video elsewhere and view it, as they should be losing money for doing stupid things like this. Copyright infringement isn't a bad thing. People who can't afford movies will download them elsewhere, it has been happening since the start of the global Internet and with the invention of the VHS tape. It hardly affects their revenue, as they wouldn't be able to get that money anyway. DRM is defective by design.

***

## What you can do to help

You can protest DRM. It may seem insignificant, but the more people who go against it, the more that is being done about it.

If you are on Linux and using Firefox, make sure that DRM isn't installed (it normally isn't by default) and don't bother installing it. 

If you are on Windows or MacOS, you may have a much harder time, as DRM is installed by default on these systems, and may auto-reinstall.

Try to avoid the following sites:

[Hulu](https://hulu.com)

[Disney+](https://www.disneyplus.com/)

[Paramount+](https://www.paramountplus.com/)

[Netflix](https://www.netflix.com/)

Basically, almost any online video streaming service should be avoided, as the majority of them use DRM and you can't use the site without losing your freedom. It isn't worth it. Send the [MPAA](https://en.wikipedia.org/wiki/Motion_Picture_Association) a message and stop streaming these shows.

You should also avoid any "free with ads" options on the following sites (as this method requires DRM)

[YouTube](https://www.youtube.com)

You can also protest DRM with a message on your projects `README.md` file. Here is what I use:

***

## Sources

This list is incomplete.

### Good sources

This is a list of the primary sources for this project.

[https://www.eff.org/deeplinks/2017/09/open-letter-w3c-director-ceo-team-and-membership/](https://www.eff.org/deeplinks/2017/09/open-letter-w3c-director-ceo-team-and-membership/)

**Comment:** The EFF left the W3C for the inclusion of DRM.

[https://privacybadger.org/](https://privacybadger.org/)

**Comment:** The homepage for the privacy badger tracker blocking extension.

> [Firefox](https://addons.mozilla.org/en-US/android/addon/privacy-badger17/) - Privacy badger for Firefox

[https://arstechnica.com/gadgets/2020/08/hbo-max-cranks-up-the-DRM-drm-leaves-linux-users-in-the-cold/](https://arstechnica.com/gadgets/2020/08/hbo-max-cranks-up-the-DRM-drm-leaves-linux-users-in-the-cold/)

**Comment:** Context: HBO increases usage of DRM and attempts to lock out millions of Linux users from using their service.

[https://www.raspberrypi.org/forums/viewtopic.php?p=1910100](https://www.raspberrypi.org/forums/viewtopic.php?p=1910100/)

**Comment:** Context: DRM DRM has problems on Raspberry Pi devices

[https://torrentfreak.com/google-takes-down-repositories-that-circumvent-its-DRM-drm-201113/](https://torrentfreak.com/google-takes-down-repositories-that-circumvent-its-DRM-drm-201113/)

**Comment:** Reminder: Google does not care about you at all

[https://www.theverge.com/2021/4/9/22375527/pixel-5-users-hd-netflix-drm-DRM-issue-firmware-fix](https://www.theverge.com/2021/4/9/22375527/pixel-5-users-hd-netflix-drm-DRM-issue-firmware-fix/)

**Comment:** Tip: You shouldn't have used it in the first place

[https://news.ycombinator.com/item?id=18828654](https://news.ycombinator.com/item?id=18828654/)

**Comment:** Info: a tool that cracks DRM DRM

[https://9to5google.com/2021/07/10/pixel-DRM-l3/](https://9to5google.com/2021/07/10/pixel-DRM-l3/)

**Comment:** Info: a tool that cracks DRM DRM

[https://torrentfreak.com/netflix-use-of-google-drm-means-rooted-android-devices-are-banned-170515/](https://torrentfreak.com/netflix-use-of-google-drm-means-rooted-android-devices-are-banned-170515/)

**Comment:** Tip: This is why DRM is bad, it restricts your freedom and makes you stay with the abuser (Google)

[https://www.androidpolice.com/2019/01/02/googles-DRM-l3-drm-used-by-netflix-hulu-and-hbo-has-been-broken/](https://www.androidpolice.com/2019/01/02/googles-DRM-l3-drm-used-by-netflix-hulu-and-hbo-has-been-broken/)

**Comment:** Info: a tool that cracks DRM DRM

[https://support.brave.com/hc/en-us/articles/360023851591-How-do-I-view-DRM-protected-content-/](https://support.brave.com/hc/en-us/articles/360023851591-How-do-I-view-DRM-protected-content-/)

**Comment:** Info: Brave does not support the DRM DRM, as Google refused to let them use it, and now it has to be done in an extra malicious way to work

[https://www.pcmag.com/news/report-googles-DRM-l3-drm-cracked](https://www.pcmag.com/news/report-googles-DRM-l3-drm-cracked/)

**Comment:** Info: a tool that cracks DRM DRM

[https://www.slashgear.com/some-pixel-phones-cant-play-hd-netflix-due-to-DRM-drm-bug-06667408/](https://www.slashgear.com/some-pixel-phones-cant-play-hd-netflix-due-to-DRM-drm-bug-06667408/)

**Comment:** Tip: Netflix is bad, but DRM is mostly at fault here

[https://reposhub.com/javascript/misc/tomer8007-DRM-l3-decryptor.html](https://reposhub.com/javascript/misc/tomer8007-DRM-l3-decryptor.html)

**Comment:** Info: a tool that cracks DRM DRM

[https://android.gadgethacks.com/how-to/netflix-caps-video-quality-based-your-phones-DRM-drm-level-heres-check-for-hdr-fhd-support-0329213/](https://android.gadgethacks.com/how-to/netflix-caps-video-quality-based-your-phones-DRM-drm-level-heres-check-for-hdr-fhd-support-0329213/)

**Comment:** Tip: Don't use Netflix

[https://www.tomshardware.com/news/chrome-57-permanently-enabled-drm,33527.html](https://www.tomshardware.com/news/chrome-57-permanently-enabled-drm,33527.html)

**Comment:** Tip: Just delete Chrome already, every other browser works better.

[https://linuxhint.com/enabling_DRM_drm_ubuntu/](https://linuxhint.com/enabling_DRM_drm_ubuntu/)

**Comment:** Tip: Don't, just don't.

### Tracker free sources

This list is not available yet, as it requires a lot of work and extra moderation. For now, just use a good tracker blocker, like the Firefox web browser, or the Privacy Badger browser extension.

### Extra sources

These sources are used for people who don't trust the other ones, or for sources that contain good info from a controversial owner.

[https://poorrichardsnews.com/why-does-bmw-usa-on-their-website-use-googles-DRM-to-spy-on-you/](https://poorrichardsnews.com/why-does-bmw-usa-on-their-website-use-googles-DRM-to-spy-on-you/)

**Comment:** TL;DR: BMW (car manufacturer) supposedly uses DRM on their site to track who watches stuff, and prevents people from interacting with their content.

https://www.reddit.com/r/netsec/comments/bj13yh/breaking_DRM_content_protection_drm_on/

**Comment:** Info: Network security info on how easy DRM is to break. Reddit also isn't usable as a source most of the time.

***

## Other things to check out

[Defective by design - A campaign by the Free Software Foundation that is working on exposing and eliminating DRM usage](https://www.defectivebydesign.org/)

[The Google Graveyard (killedbygoogle.com) - a sorted list of the 224+ products Google has killed](https://killedbygoogle.com/)

> [GitHub link](https://github.com/codyogden/killedbygoogle)

[Alphabet worker union - The new workers union at Google with over 800 members](https://alphabetworkersunion.org/people/our-union/)

There are other alternates, just search for them.

***

## Article info

**File type:** `Markdown (*.md)`

**File version:** `8 (Sunday, 2021 September 12th at 2:30 pm)`

**Line count (including blank lines and compiler line):** `834`

***

## History

This project has a short history so far.

### Pre-history

This project was created on 2021 February 8th as part of my new DeGoogle efforts on GitHub. It received basic amounts of work on this day.

### Alpha history

On 2021 April 8th, this project was updated to add new data and research, and several translations.

On 2021 April 23rd, this project received many new translations,

On 2021 May 10th, the article was updated to version 5

On 2021 May 11th, this project was updated to contain a new transparent version of the DRM logo by the GitHub contributor [@GaurPeeyush](https://github.com/GaurPeeyush/) the article was this updated to version 6.

On 2021 May 12th, the article was updated again.

On 2021 August 26th, the project was brought up to date, except for the article, as it became my most popular project.

On 2021 September 9th, to celebrate 16 stars, the project was updated again and received its first release.

On 2021 September 10th, to celebrate 17 stars, the project was updated to contain plans for the next update, which wasn't done until 2 days later.

On 2021 September 12th, the project received a big article update, renovations, its own GitHub organization, and its own website.

### Beta history

No Beta history to show for this project.

### Modern history

No Modern history to show for this project.

***

## Article info

**Written on:** `2021 Saturday, October 2nd at 8:56 pm`

**Last revised on:** `2021 Saturday, October 2nd at 8:56 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `353`

**Article version:** `1 (2021 Saturday, October 2nd at 8:56 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/Degoogle-your-life/wiki/

!-->

