
***

# Criticism of Google

## Condensed version

Criticism of Google includes concern for tax avoidance, misuse and manipulation of search results, its use of others' intellectual property, concerns that its compilation of data may violate people's privacy and collaboration with the US military on Google Earth to spy on users, censorship of search results and content, and the energy consumption of its servers as well as concerns over traditional business issues such as monopoly, restraint of trade, antitrust, "idea borrowing", indexing and presenting false information and propaganda in search results, and being an "Ideological Echo Chamber"

Google's parent company, Alphabet Inc., is an American multinational public corporation invested in Internet search, cloud computing, and advertising technologies. Google hosts and develops a number of Internet-based services and products, and generates profit primarily from advertising through its AdWords program.

Google's stated mission is "to organize the world's information and make it universally accessible and useful"; this mission, and the means used to accomplish it, have raised concerns among the company's critics. Much of the criticism pertains to issues that have not yet been addressed by cyber law.

Shona Ghosh, a journalist for Business Insider, noted that an increasing digital resistance movement against Google has grown.

## Tax avoidance
	
Google has been accused by a number of countries of avoiding paying tens of billions of dollars of tax through a convoluted scheme of inter-company licensing agreements and transfers to tax havens. For example, Google has used highly contrived and artificial distinctions to avoid paying billions of pounds in corporate tax owed by its UK operations.

On May 15, 2013, Margaret Hodge, the chair of the United Kingdom Public Accounts Committee, accused Google of being "calculated and [...] unethical" over its use of the scheme. Google Chairman Eric Schmidt has claimed that this scheme of Google is "capitalism", and that he was "very proud" of it.

In November 2012, the UK government announced plans to investigate Google, along with Starbucks and Amazon.com, for possible tax avoidance. In 2015, the UK Government introduced a new law intended to penalize Google and other large multinational corporations's artificial tax avoidance.

On 20 January 2016, Google announced that it would pay £130m in back taxes to settle the investigation. However, only 8 days later, it was announced that Google could end up paying more, and UK tax officials were under investigation for what has been termed a "sweetheart deal" for Google.[

Google cut its taxes by $3.1 billion in the period of 2007 to 2009 using a technique that moves most of its foreign profits through Ireland and The Netherlands to Bermuda. Afterwards, the company started to send £8 billion in profits a year to Bermuda Google's income shifting—involving strategies known to lawyers as the "Double Irish" and the "Dutch Sandwich"—helped reduce its overseas tax rate to 2.4 percent, the lowest of the top five U.S. technology companies by market capitalization, according to regulatory filings in six countries.

According to economist and member of the PvdA delegation inside the Progressive Alliance of Socialists & Democrats in the European Parliament (S&D) Paul Tang, the EU lost, from 2013 to 2015, a loss estimated to be 3 955 million of euros from Google. When comparing to others countries outside the EU, the EU is only taxing Google with a rate of 0,36 – 0,82% of their revenue (approx. 25-35% of their EBT) whereas this rate is near 8% in countries outside the EU. Even if a rate of 2 to 5% - as suggested by ECOFIN council - would have been applied during this period (2013-2015), a fraud of this rate from Facebook would have mean a loss from 1 262 to 3 155 million of euros in the EU.

Revenues, profits, tax and effective tax rates, Alphabet Inc. (Google) 2013–2015. 	Revenue (m EUR) 	EBT (m EUR) 	Tax (m EUR) 	Tax / EBT 	Tax / Revenue

Total 	EU 	Rest of the world 	Total 	EU 	Rest of the world 	Total 	EU 	Rest of the world 	Total 	EU 	Rest of the world 	Total 	EU 	Rest of the world

Alphabet Inc.

(Google)

2013 	40 257 	18 614 	21 643 	11 529 	343 	11 186 	1 986 	84 	1 902 	17% 	25% 	17% 	4,93% 	0,45% 	8,79%

2014 	54 362 	19 159 	35 203 	14 215 	285 	13 930 	2 997 	69 	2 928 	21% 	24% 	21% 	5,51% 	0,36% 	8,32%

2015 	68 879 	25 320 	43 559 	18 050 	586 	17 464 	3 034 	207 	2 827 	17% 	35% 	16% 	4,40% 	0,82% 	6,49%

## Antitrust

### European Union

The European Commission has pursued several competition law cases against Google, namely:

Complaint that Google abused its position as a dominant search engine to favor its own services over those of competitors. In particular, Google operated a free comparison shopping website Froogle, which it abandoned in favor of a paid-placement-only site called Google Shopping. Other comparison sites complained of a precipitous drop in web traffic due to changes in the Google search algorithm, and some were driven out of business. The investigation began in 2010 and concluded in July 2017 with a €2.42 billion fine against the parent company Alphabet, and an order to change its practices within 90 days.

Complaint opened in 2015 that the dominance of the Android operating system was abused to make it difficult for competing third-party apps and search engines to be pre-installed on mobile phones. (See European Union vs. Google.)

Complaint opened in 2016 that Google abused its market dominance to prevent competing advertising companies to sell ads to web sites already using Google AdSense

### U.S. antitrust issues

In June 2015, Google reached an advertising agreement with Yahoo!, which would have allowed Yahoo! to feature Google advertisements on its web pages. The alliance between the two companies was never completely realized because of antitrust concerns by the U.S. Department of Justice. As a result, Google pulled out of the deal in November 2018.

In testimony before a U.S. Senate antitrust panel in September 2011, Eric Schmidt, Google's chairman, said that "the Internet is the ultimate level playing field" where users were "one click away" from competitors. Beyond the existence of alternatives, Google's large market share was another aspect of the debate, as this exchange between Senator Herb Kohl and Mr. Schmidt at the September Senate hearing illustrates:

Senator Kohl asked: "But you do recognize that in the words that are used and antitrust kind of oversight, your market share constitutes a monopoly, dominant – special power dominant – special power dominant for a monopoly firm. You recognize you're in that area?"

Schmidt replied: "I would agree, sir, that we're in that area.... I'm not a lawyer, but my understanding of monopoly findings is this is a judicial process."

During the hearing Mike Lee, Republican of Utah, accused Google of cooking its search results to favor its own services. Mr. Schmidt replied, "Senator, I can assure we haven't cooked anything."

In testimony before the same Senate panel, Jeffrey Katz and Jeremy Stoppelman, the chief executives from Google's competitors Nextag and Yelp, said that Google tilts search results in its own favor, limiting choice and stifling competition.

In October 2012, it was reported that the U.S. Federal Trade Commission staff were preparing a recommendation that the government sue Google on antitrust grounds. The areas of concern include accusations of manipulating the search results to favor Google services such as Google Shopping for buying goods and Google Places for advertising local restaurants and businesses; whether Google's automated advertising marketplace, AdWords, discriminates against advertisers from competing online commerce services like comparison shopping sites and consumer review Web sites; whether Google's contracts with smartphone makers and carriers prevent them from removing or modifying Google products, such as its Android operating system or Google Search; and Google's use of its smartphone patents. A likely outcome of the antitrust investigations is a negotiated settlement where Google would agree not to discriminate in favor of its products over smaller competitors. Federal Trade Commission ended its investigation during a period which the co-founder of Google, Larry Page, had met with individuals at the White House and the Federal Trade Commission, leading to voluntary changes by Google; since January 2009 to March 2015 employees of Google have met with officials in the White House about 230 times according to The Wall Street Journal.

### Android

On April 20, 2016, the European Union filed a formal antitrust complaint against Google's leverage over Android vendors, alleging that the mandatory bundling of the entire suite of proprietary Google software, hindered the ability for competing search providers to be integrated into Android and that barring vendors from producing devices running forks of Android both constituted anti-competitive practices. In June 2018, the European Commission determined a $5 billion fine for Google regarding the April 2016 complaints.

In August 2016, Google was fined US$6.75 million by the Russian Federal Antimonopoly Service (FAS) under similar allegations by Yandex.

On April 16, 2018, Umar Javeed, Sukarma Thapar, Aaqib Javeed vs. Google LLC & Ors. resulted in the Competition Commission of India ordering a wider probe investigation order against Google Android illegal business practices. The investigations arm of the CCI should complete the wider probe in the case within 150 days, the order said, though such cases at the watchdog typically drag on for years. The CCI also said the role of any Google executive in the alleged abuse of the Android platform should also be examined.

## Criticism of search engine

### Possible misuse of search results

In 2006/2007, a group of Austrian researchers observed a tendency to misuse the Google engine as a "reality interface". Ordinary users as well as journalists tend to rely on the first pages of Google Search, assuming that everything not listed there is either not important or simply does not exist. The researchers say that "Google has become the main interface for our whole reality. To be precise: with the Google interface, the user gets the impression that the search results imply a kind of totality. In fact, one only sees a small part of what one could see if one also integrates other research tools".
Eric Schmidt, former executive chairman of Google

Eric Schmidt, Google's chief executive, said in a 2007 interview with the Financial Times: "The goal is to enable Google users to be able to ask the question such as 'What shall I do tomorrow?' and 'What job shall I take?'". Schmidt reaffirmed this during a 2010 interview with The Wall Street Journal: "I actually think most people don't want Google to answer their questions, they want Google to tell them what they should be doing next."

Numerous companies and individuals, for example, MyTriggers.com and transport tycoon Sir Brian Souter have voiced concerns regarding the fairness of Google's PageRank and search results after their web sites disappeared from Google's first-page results. In the case of MyTriggers.com, the Ohio-based shopping comparison search site accused Google of favoring its own services in search results (although the judge eventually ruled that the site failed to show harm to other similar businesses).

### Danger of ranking manipulation

PageRank, Google's page ranking algorithm, can and has been manipulated for political and humorous reasons. To illustrate the view that Google's search engine could be subjected to manipulation, Google Watch implemented a Google bomb by linking the phrase "out-of-touch executives" to Google's own page on its corporate management. The attempt was mistakenly attributed to disgruntled Google employees by The New York Times, which later printed a correction.

Daniel Brandt started the Google Watch website and has criticized Google's PageRank algorithms, saying that they discriminate against new websites and favor established sites. Chris Beasley, who started Google Watch-Watch, disagrees, saying that Mr. Brandt overstates the amount of discrimination that new websites face and that new websites will naturally rank lower when the ranking is based on a site's "reputation". In Google's world, a site's reputation is in part determined by how many and which other sites link to it (links from sites with a "better" reputation of their own carry more weight). Since new sites will seldom be as heavily linked as older more established sites, they aren't as well known, won't have as much of a reputation, and will receive a lower page ranking.

In testimony before a U.S. Senate antitrust panel in September 2011, Jeffrey Katz, the chief executive of NexTag, said that Google's business interests conflict with its engineering commitment to an open-for-all Internet and that: "Google doesn't play fair. Google rigs its results, biasing in favor of Google Shopping and against competitors like us." Jeremy Stoppelman, the chief of Yelp, said sites like his have to cooperate with Google because it is the gateway to so many users and "Google then gives its own product preferential treatment." In earlier testimony at the same hearing Eric Schmidt, Google's chairman, said that Google does not "cook the books" to favor its own products and services.

### Portrayals of race and gender

In 2013, Emily McManus, managing editor for TED.com, searched for "english major who taught herself calculus" which prompted Google to ask,  "Did you mean: english major who taught himself calculus?" Her tweet of the incident gained traction online. One response included a screengrab of a search for "how much is a wnba ticket?" to which the auto-correct feature suggested, "how much is an nba ticket?" Google responded directly to McManus and explained that the phrase "taught himself calculus" appeared about 282,000 times, whereas the phrase "taught herself calculus" appeared about 4,000 times. The company also made note of its efforts to bring more women into STEM fields.

In 2015, a man tweeted a screengrab showing that Google Photos had tagged two African American people as gorillas. Google apologized, saying they were "appalled and genuinely sorry" and was "working on longer-term fixes." An investigation by WIRED two years later showed that the company's solution has been to censor searches for "gorilla," "chimp," "chimpanzee," and "monkey."

### Google Shopping rankings

In late May 2012, Google announced that they will no longer be maintaining a strict separation between search results and advertising. Google Shopping (formerly known as Froogle) will be replaced with a nearly identical interface, according to the announcement, but only paid advertisers will be listed instead of the neutral aggregate listings shown previously. Furthermore, rankings will be determined primarily by which advertisers place the highest "bid", though the announcement does not elaborate on this process. The transition will be complete in the fall of 2012.

As a result of this change to Google Shopping, Microsoft, who operates the competing search engine Bing, launched a public information campaign titled Scroogled. The ad campaign was developed by leading political campaign strategist Mark Penn.

It is unclear how consumers have reacted to this move. Critics charge that Google has effectively abandoned its "Don't be evil" motto and that small businesses will be unable to compete against their larger counterparts. There is also concern that consumers who did not see this announcement will be unaware that they are now looking at paid advertisements and that the top results are no longer determined solely based on relevance but instead will be manipulated according to which company paid the most.

## Copyright issues

### Google Print, Books, and Library

Google's ambitious plans to scan millions of books and make them readable through its search engine have been criticized for copyright infringement. The Association for Learned and Professional Society Publishers and the Association of American University Presses both issued statements strongly opposing Google Print, stating that "Google, an enormously successful company, claims a sweeping right to appropriate the property of others for its own commercial use unless it is told, case by case and instance by instance, not to."

### China Written Works Copyright Society (CWWCS)

In a separate dispute in November 2009, the China Written Works Copyright Society (CWWCS), which protects Chinese writers' copyrights, accused Google of scanning 18,000 books by 570 Chinese writers without authorization, for its Google Books library. Toward the end of 2009 representatives of the CWWCS said talks with Google about copyright issues are progressing well, that first they "want Google to admit their mistake and apologize", then talk about compensation, while at the same time they "don't want Google to give up China in its digital library project". On November 20, 2009, Google agreed to provide a list of Chinese books it had scanned, but did not admit having "infringed" copyright laws. In a January 9, 2010 statement the head of Google Books in the Asia-Pacific said "communications with Chinese writers have not been good enough" and apologized to the writers.

### Links and cached data

Kazaa and the Church of Scientology have used the Digital Millennium Copyright Act (DMCA) to demand that Google remove references to allegedly copyrighted material on their sites.

Search engines such as Google's that link to sites in "good faith" fall under the safe harbor provisions of the Online Copyright Infringement Liability Limitation Act which is part of DMCA. If they remove links to infringing content after receiving a take down notice, they are not liable. Google removes links to infringing content when requested, provided that supporting evidence is supplied. However, it is sometimes difficult to judge whether or not certain sites are infringing and Google (and other search engines) will sometimes refuse to remove web pages from its index. To complicate matters there have been conflicting rulings from U.S. courts on whether simply linking to infringing content constitutes "contributory infringement" or not.

The New York Times has complained that the caching of their content during a web crawl, a feature utilized by search engines including Google Web Search, violates copyright. Google observes Internet standard mechanisms for requesting that caching be disabled via the robots.txt file, which is another mechanism that allows operators of a website to request that part or all of their site not be included in search engine results, or via META tags, which allow a content editor to specify whether a document can be crawled or archived, or whether the links on the document can be followed. The U.S. District Court of Nevada ruled that Google's caches do not constitute copyright infringement under American law in Field v. Google and Parker v. Google.

On February 20, 2017, Google agreed to a voluntary United Kingdom code of practice obligating it to demote links to copyright-infringing content in its search results.

## Google Map Maker

Google Map Maker allows user-contributed data to be put into the Google Maps service, similar to OpenStreetMap it includes concepts such as organising mapping parties and mapping for humanitarian efforts. It has been criticized for taking work done for free by the general public and claiming commercial ownership of it without returning any contributions back to the commons as their restrictive license makes it incompatible with most open projects by preventing commercial use or use by competitive services.

## Google Pinyin

Google allegedly used code from Chinese company Sohu's Sogou Pinyin for its own input method editor, Google Pinyin.

## Where's the Fair Use?

On February 16, 2016, internet reviewer Doug Walker (The Nostalgia Critic) posted a video about his concerns related to YouTube's current copyright-claiming system, which was apparently being tipped in favor of claimants rather than creators despite many of those videos being reported as covered under Fair Use laws. The video featured stories of other YouTubers' experiences with the copyright system, including fellow Channel Awesome producer Brad Jones, who received a strike on his channel for uploading a film review that took place in a parked car and contained no footage from the film itself. In the video, Walker encouraged others to spread the message using the hashtag #WTFU (Where's the Fair Use?) on social media. The hashtag spread among multiple YouTubers, who gave their support to Walker and Channel Awesome and relaying their own stories of issues with YouTube's copyright system, including Dan Murrell of Screen Junkies, GradeAUnderA, and Let's Play producers Mark Fishbach (Markiplier) and Seán William McLoughlin (Jacksepticeye).

Ten days later, on February 26, 2016, YouTube CEO Susan Wojcicki tweeted a link to a post from the YouTube Help Forum and thanked the community for bringing the issue to their attention. The post, written by a member of the YouTube Policy Team named Spencer (no last name was given), stated that they will be working to strengthen communication between creators and YouTube Support and "improvements to increase transparency into the status of monetization claims."

## Privacy

PRISM: a clandestine surveillance program under which the NSA collects user data from companies like Google.

Google's March 1, 2012 privacy change enables the company to share data across a wide variety of services. This includes embedded services in millions of third-party websites using AdSense and Analytics. The policy was widely criticized as creating an environment that discourages Internet innovation by making Internet users more fearful online.

In December 2009, after privacy concerns were raised, Google's CEO, Eric Schmidt, declared: "If you have something that you don't want anyone to know, maybe you shouldn't be doing it in the first place. If you really need that kind of privacy, the reality is that search engines—including Google—do retain this information for some time and it's important, for example, that we are all subject in the United States to the Patriot Act and it is possible that all that information could be made available to the authorities."

Privacy International has raised concerns regarding the dangers and privacy implications of having a centrally located, widely popular data warehouse of millions of Internet users' searches, and how under controversial existing U.S. law, Google can be forced to hand over all such information to the U.S. government. In its 2007 Consultation Report, Privacy International ranked Google as "Hostile to Privacy", its lowest rating on their report, making Google the only company in the list to receive that ranking.

At the Techonomy conference in 2010, Eric Schmidt predicted that "true transparency and no anonymity" is the way forward for the internet: "In a world of asynchronous threats it is too dangerous for there not to be some way to identify you. We need a [verified] name service for people. Governments will demand it." He also said that "If I look at enough of your messaging and your location, and use artificial intelligence, we can predict where you are going to go. Show us 14 photos of yourself and we can identify who you are. You think you don't have 14 photos of yourself on the internet? You've got Facebook photos!"

In the summer of 2016, Google quietly dropped its ban on personally identifiable info in its DoubleClick ad service. Google's privacy policy was changed to state it "may" combine web-browsing records obtained through DoubleClick with what the company learns from the use of other Google services. While new users were automatically opted-in, existing users were asked if they wanted to opt-in, and it remains possible to opt-out by going to the Activity controls in the My Account page of a Google account. ProPublica states that "The practical result of the change is that the DoubleClick ads that follow people around on the web may now be customized to them based on your name and other information Google knows about you. It also means that Google could now, if it wished to, build a complete portrait of a user by name, based on everything they write in email, every website they visit and the searches they conduct." Google contacted ProPublica to correct the fact that it doesn't "currently" use Gmail keywords to target web ads.

## Censorship

Google has been criticized for various instances of censoring its search results, many times in compliance with the laws of various countries, most notably while it operated in China from January 2006 to March 2010.
Web search
See also: Censorship by Google § Google Search

As of December 12, 2012, Google's SafeSearch feature applies to image searches in the United States. Prior to the change three SafeSearch settings—"on", "moderate", and "off"—were available to users. Following the change, two "Filter explicit results" settings—"on" and "off"—were newly established. The former and new "on" settings are similar and exclude explicit images from search results. The new "off" setting still permits explicit images to appear in search results, but users need to enter more specific search requests, and no direct equivalent of the old "off" setting exists following the change. The change brings image search results into line with Google's existing settings for web and video search.

Some users have stated that the lack of a completely unfiltered option amounts to "censorship" by Google. A Google spokesperson disagreed, saying that Google is "not censoring any adult content," but "want to show users exactly what they are looking for—but we aim not to show sexually-explicit results unless a user is specifically searching for them."

The search term "bisexual" was blacklisted for Instant Search until 2012, when it was removed at the request of the BiNet USA advocacy organization.

### China

Google has been involved in the censorship of certain sites in specific countries and regions. Until March 2010, Google adhered to the Internet censorship policies of China, enforced by filters colloquially known as "The Great Firewall of China". Google.cn search results were filtered to remove some information perceived to be harmful to the People's Republic of China (PRC). Google claimed that some censorship is necessary in order to keep the Chinese government from blocking Google entirely, as occurred in 2002. The company claims it did not plan to give the government information about users who search for blocked content, and will inform users that content has been restricted if they attempt to search for it. As of 2009, Google was the only major China-based search engine to explicitly inform the user when search results are blocked or hidden. As of December 2012, Google no longer informs the user of possible censorship for certain queries during search.

Some Chinese Internet users were critical of Google for assisting the Chinese government in repressing its own citizens, particularly those dissenting against the government and advocating for human rights. Furthermore, Google had been denounced and called hypocritical by Free Media Movement for agreeing to China's demands while simultaneously fighting the United States government's requests for similar information. Google China had also been condemned by Reporters Without Borders, Human Rights Watch and Amnesty International.

In 2009, China Central Television, Xinhua News Agency, and People's Daily all reported on Google's "dissemination of obscene information", and People's Daily claimed that "Google's 'don't be evil' motto becomes a fig leaf". The Chinese government imposed administrative penalties to Google China, and demanded a reinforcement of censorship.

In 2010, according to a leaked diplomatic cable from the U.S. Embassy in Beijing, there were reports that the Chinese Politburo directed the intrusion of Google's computer systems in a worldwide coordinated campaign of computer sabotage and the attempt to access information about Chinese dissidents, carried out by "government operatives, public security experts and Internet outlaws recruited by the Chinese government." The report suggested that it was part of an ongoing campaign in which attackers have "broken into American government computers and those of Western allies, the Dalai Lama and American businesses since 2002."

In response to the attack, Google announced that they were "no longer willing to continue censoring our results on Google.cn, and so over the next few weeks we will be discussing with the Chinese government the basis on which we could operate an unfiltered search engine within the law, if at all." On March 22, 2010, after talks with Chinese authorities failed to reach an agreement, the company redirected its censor-complying Google China service to its Google Hong Kong service, which is outside the jurisdiction of Chinese censorship laws. From the business perspective, many recognize that the move was likely to affect Google's profits: "Google is going to pay a heavy price for its move, which is why it deserves praise for refusing to censor its service in China." However, at least as of March 23, 2010, "The Great Firewall" continues to censor search results from the Hong Kong portal, www.google.com.hk (as it does with the US portal, www.google.com) for controversial terms such as "Falun gong" and "the June 4 incident" (Tiananmen Square incident).

In 2018, Lhadon Tethong, director of the Tibet Action Institute, said there was a, "crisis of repression unfolding across China and territories it controls." and that, "it is shocking to know that Google is planning to return to China and has been building a tool that will help the Chinese authorities engage in censorship and surveillance." She further noted that "Google should be using its incredible wealth, talent, and resources to work with us to find solutions to lift people up and help ease their suffering — not assisting the Chinese government to keep people in chains."

### Turkey

Google has been involved in censorship of Google Maps satellite imagery countrywide affecting Android and iOS apps using .com, .tr, and .tld automatically. Desktop users can easily evade this censorship by just removing .tr, and .tld from the URL but the same technique is impossible with smartphone apps.

### Russia

Google removed the Smart Voting app from the Play Store before the 2021 Russian legislative election. The application, which had been created by the associates of the imprisoned opposition leader Alexei Navalny, offered voting advice for all voting districts in Russia. It was removed after a meeting with Russian Federation Council officials on 16 September 2021. The Wired reported that several Google employees were threatened with criminal prosecution. Google's actions were condemned as political censorship by Russian opposition figures.

### AdSense/AdWords

In February 2003, Google stopped showing the advertisements of Oceana, a non-profit organization protesting a major cruise ship operation's sewage treatment practices. Google cited its editorial policy at the time, stating "Google does not accept advertising if the ad or site advocates against other individuals, groups, or organizations." The policy was later changed.

In April 2008, Google refused to run ads for a UK Christian group opposed to abortion, explaining that "At this time, Google policy does not permit the advertisement of websites that contain 'abortion and religion-related content.'" The UK Christian group sued Google for discrimination, and as a result, in September 2008 Google changed its policy and anti-abortion ads were allowed.

In August 2008, Google closed the AdSense account of a site that carried a negative view of Scientology, the second closing of such a site within 3 months. It is not certain if the account revocations actually were on the grounds of anti-religious content, however, the cases have raised questions about Google's terms in regards to AdSense/AdWords. The AdSense policy states that "Sites displaying Google ads may not include […] advocacy against any individual, group, or organization", which allows Google to revoke the above-mentioned AdSense accounts.

In May 2011, Google cancelled the AdWord advertisement purchased by a Dublin sex worker rights group named "Turn Off the Blue Light" (TOBL), claiming that it represented an "egregious violation" of company ad policy by "selling adult sexual services". However, TOBL is a nonprofit campaign for sex worker rights and is not advertising or selling adult sexual services. In July, after TOBL members held a protest outside Google's European headquarters in Dublin and wrote to complain, Google relented, reviewed the group's website, found its content to be advocating a political position, and restored the AdWord advertisement.

In June 2012, Google rejected the Australian Sex Party's ads for AdWords and sponsored search results for the July 12 by-election for the state seat of Melbourne, saying the Party breached its rules which prevent solicitation of donations by a website that did not display tax-exempt status. Although the Sex Party amended its website to display tax deductibility information, Google continued to ban the ads. The ads were reinstated on election eve after it was reported in the media that the Sex Party was considering suing Google. On September 13, 2012, the Party lodged formal complaints against Google with the US Department of Justice and the Australian competition watchdog, accusing Google of "unlawful interference in the conduct of a state election in Victoria with corrupt intent" in violation of the Foreign Corrupt Practices Act.

### YouTube

YouTube is a video sharing website acquired by Google in 2006. YouTube's Terms of Service prohibits the posting of videos which violate copyrights or depict pornography, illegal acts, gratuitous violence, or hate speech. User-posted videos that violate such terms may be removed and replaced with a message stating: "This video is no longer available because its content violated YouTube's Terms of Service".

YouTube has been criticized by national governments for failing to police content. For example, videos have been critically accused for being "left up", among other videos featuring unwarranted violence or strong ill-intention against people who probably didn't want this to be published. In 2006, Thailand blocked access to YouTube for users with Thai IP addresses. Thai authorities identified 20 offensive videos and demanded that YouTube remove them before it would unblock any YouTube content. In 2007 a Turkish judge ordered access to YouTube blocked because of content that insulted Mustafa Kemal Atatürk, which is a crime under Turkish law. On February 22, 2008, Pakistan Telecommunications Authority (PTA) attempted to block regional access to YouTube following a government order. The attempt inadvertently caused a worldwide YouTube blackout that took 2 hours to correct. Four days later, PTA lifted the ban after YouTube removed controversial religious comments made by a Dutch Member of Parliament concerning Islam.

YouTube has also been criticized by its users for attempting to censor content. In November 2007, the account of Wael Abbas, a well known Egyptian activist who posted videos of police brutality, voting irregularities and anti-government demonstrations, was blocked for three days.

In February 2008, a video produced by the American Life League that accused a Planned Parenthood television commercial of promoting recreational sex was removed, then reinstated two days later. In October, a video by political speaker Pat Condell criticizing the British government for officially sanctioning sharia law courts in Britain was removed, then reinstated two days later. YouTube also pulled a video of columnist Michelle Malkin showing violence by Muslim extremists. Siva Vaidhyanathan, a professor of Media Studies at the University of Virginia, commented that while, in his opinion, Michelle Malkin disseminates bigotry in her blog, "that does not mean that this particular video is bigoted; it's not. But because it's by Malkin, it's a target."

In December 2018, a channel called Mumkey Jones was taken down by YouTube due to receiving three community guidelines strikes because of videos documenting and commenting on Elliot Rodger, the perpetrator of the 2014 Isla Vista killings, being considered hate speech. However, one of the strikes was on a private video with zero views with the title "elliott amv" leading many viewers to believe that YouTube had struck down the channel in an act of censorship.

In 2019, YouTube settled for $170 million the FTC and the New York Attorney General for alleged violations of the US Children's Online Privacy Protection Act (COPPA), which prohibits internet companies from collecting data from kids under 13. YouTube's enactment of the settlement started in January 2020; this required creators to indicate whether their videos were intended for children, with fines of up to $42,530 per violation of COPPA. Some features that depend on user data are disabled on videos designated for children, including comments and channel branding watermarks; the 'donate' button; cards and end screens; live chat and live chat donations; notifications; and 'save to playlist' or 'watch later' features. Such channels will also become "ungooglable".

### Ungoogleable

In 2013, Google successfully prevented the Swedish Language Council from including the Swedish version of the word "ungoogleable" ("ogooglebar [sv]") in its list of new words. Google objected to its definition (which referred to web searches in general without mentioning Google specifically) and the council was forced to remove it to avoid legal confrontation with Google. They also accused Google of "trying to control the Swedish language".

## Labor practices

Several former Google employees have spoken out about working conditions, practices, and ethics at the company. As the company became more concerned about leaks to the press in 2019, it scaled employee all-hands meetings from weekly to monthly, limiting question topics to business and product strategy. Google CEO Sundar Pichai told employees in late 2019 that the company is "genuinely struggling with some issues" including transparency and employee trust.

On 2 December 2020, the National Labor Relations Board (NLRB) filed a complaint against Google for 'terminations and intimidation in order to quell workplace activism'. The complaint was filed after a year-long investigation by a terminated employee. He filed a petition in 2019, after that many Google employees carried out internal protests against Google's work with US Customs and Border Protection.

### Diversity politics

A widely circulated internal memo, written by senior engineer James Damore, Google's Ideological Echo Chamber, sharply criticized Google's political biases and employee policies. Google said the memo was "advancing harmful gender stereotypes" and fired Damore. After which some argued that Google proved itself to be political, and some even demanded the resignation of its CEO Sundar Pichai for mishandling the case.

Ads criticizing Pichai and Google for the firing were put up shortly after at various Google locations. Some have called to boycott Google and its services, with a hashtag #boycottGoogle coming up on Twitter. A rally against Google alleged partisanship was planned as "March on Google", but later cancelled due to threats and the Charlottesville mayhem.

Arne Wilberg, an ex-YouTube recruiter, claimed that he was fired in November 2017 when he complained about Google's new practices in not hiring white and Asian men to YouTube in favor of women and minority applicants. According to the lawsuit, an internal policy document stated that for three months in 2017, YouTube recruiters should only hire diverse candidates.

In June 2021, Google removed its global lead for diversity strategy and research after being made aware of an antisemitic comment he made in 2007.

### Sexual harassment

On November 1, 2018 approximately 20,000 employees of Google engaged in a worldwide walkout to protest the way in which the company has handled sexual harassment, and other grievances.

In January 2020, the San Francisco Pride organization voted to ban Google and YouTube from their annual Pride parade due to hate speech on their platforms and retaliation against LBGTQ activists.

In 2020, HR executive Eileen Naughton joined long-time Chief Legal Counsel David Drummond in stepping down from their positions over a lawsuit naming them and the company founders in accusations of mishandling years of sexual harassment complaints. In February 2020, the U.S. Equal Employment Opportunity Commission opened an investigation into a former Google employee's allegations of pregnancy discrimination.

### Age discrimination

In July 2019, Google settled a long-running age discrimination lawsuit brought by 227 over-40 employees and job seekers. Although Google denied it had age discrimination, it agreed to a settlement of $11 million for the plaintiffs, to train its employees not to have age-based bias, and to have its recruiting department focus on age diversity among its engineering employees.
Allegations of union busting

The official settlement agreement that Google signed with the NLRB in 2019 includes this notice to be sent to employees:

"YOU HAVE THE RIGHT to discuss wages, hours, and working conditions with other employees, the press/media, and other third parties, and WE WILL NOT do anything to interfere with your exercise of those rights."

Google has been criticized for hiring IRI Consultants, a firm that advertises its accomplishments in helping organizations prevent successful union organizing. Google Zurich attempted to cancel employee-organized meetings about labor rights in June and October 2019. Some Google employees and contractors are already unionized, including security guards, some service workers, and analysts and trainers for Google Shopping in Pittsburgh employed by contractor HCL.

As of December 2019, the National Labor Relations Board is investigating whether several firings were in retaliation for labor organizing-related activities. One of the fired employees was tasked with informing her colleagues about Google policy changes, and created a message informing them that they, "have the right to participate in protected concerted activities," when they visited the IRI Consultants site.

## Other

### Non-alignment with US defense

Former Deputy Defense Secretary Robert O. Work in 2018 criticized Google and its employees have stepped into a Moral Hazard for themselves as not continuing Pentagon's artificial intelligence project, Project Maven, while helping China's AI technology that "could be used against the United States in a conflict." He described Google as hypocritical, given it has opened an AI center in China and "Anything that's going on in the AI center in China is going to the Chinese government and then will ultimately end up in the hands of the Chinese military." Work said "I didn't see any Google employee saying, 'Hmm, maybe we shouldn't do that.'" Google's dealings with China is decrying as unpatriotic.

Chairman of the Joint Chiefs of Staff General Joseph Dunford also criticizes Google as "it's inexplicable" that it continue investing in China, "who uses censorship technology to restrain freedoms and crackdown on people there and has long history of intellectual property and patent theft which hurts U.S. companies," while simultaneously not renewing further research and development collaborations with the Pentagon. He said, "I'm not sure that people at Google will enjoy a world order that is informed by the norms and standards of Russia or China." He urges Google to work directly with the U.S. government instead of making controversial inroads into China. Senator Mark Warner (D-VA) criticized Dragonfly evidences China's success at "recruit[ing] U.S. companies to their information control efforts" while China exports cyber and censorship infrastructure to authoritarian regimes like Venezuela, Ethiopia, and Pakistan.

### Energy consumption

Google has been criticized for the high amount of energy used to maintain its servers, but was praised by Greenpeace for the use of renewable sources of energy to run them. Google has pledged to spend millions of dollars to investigate cheap, clean, renewable energy, and has installed solar panels on the roofs at its Mountain View facilities. In 2010, Google also invested $39 million in wind power.

### Google bus protests

In late 2013, activists in the San Francisco Bay Area began protesting the use of shuttle buses by Google and other tech companies, viewing them as symbols of gentrification and displacement in a city where the rapid growth of the tech sector has driven up housing prices.

### Google Video

On August 15, 2007 Google discontinued its Download-to-own/Download-to-rent (DTO/DTR) program. Some videos previously purchased for ownership under that program were no longer viewable when the embedded Digital Rights Management (DRM) licenses were revoked. Google gave refunds for the full amount spent on videos using "gift certificates" (or "bonuses") to their customers' "Google Checkout Account". After a public uproar, Google issued full refunds to the credit cards of the Google Video users without revoking the gift certificates.

### Search within search

For some search results, Google provides a secondary search box that can be used to search within a website identified from the first search. It sparked controversy among some online publishers and retailers. When performing a second search within a specific website, advertisements from competing and rival companies often showed up together with the results from the website being searched. This has the potential to draw users away from the website they were originally searching. "While the service could help increase traffic, some users could be siphoned away as Google uses the prominence of the brands to sell ads, typically to competing companies." In order to combat this controversy, Google has offered to turn off this feature for companies who request to have it removed.

According to software engineer Ben Lee and Product Manager Jack Menzel, the idea for search within search originated from the way users were searching. It appeared that users were often not finding exactly what they needed while trying to explore within a company site. "Teleporting" on the web, where users need only type part of the name of a website into Google (no need to remember the entire URL) in order to find the correct site, is what helps Google users complete their search. Google took this concept a step further and instead of just "teleporting", users could type in keywords to search within the website of their choice.

### Naming of Go programming language

Google is criticized for naming their programming language "Go" while there is already an existing programming language called "Go!".

### Potential security threats

Google's Street View has been criticized for providing information that could potentially be useful to terrorists. In the United Kingdom during March 2010, Liberal Democrats MP Paul Keetch and unnamed military officers criticized Google for including pictures of the entrance to the British Army Special Air Service (SAS) base, stating that terrorists might use the information to plan attacks. Google responded that it "only takes images from public roads and this is no different to what anyone could see traveling down the road themselves, therefore there is no appreciable security risk." Military sources stated that "It is highly irresponsible for military bases, especially special forces, to be pictured on the internet. [...] The question is, why risk a very serious security breach for the sake of having a picture on a website?" Google was subsequently forced to remove images of the SAS base and other military, security and intelligence installations, admitting that its trained drivers had failed to not take photographs in areas banned under the Official Secrets Act.

In 2008, Google complied with requests from The Pentagon to remove Street View images of the entrances to military bases.

### Politics

Despite being one of the world's largest and most influential companies, unlike many other technology companies, Google does not disclose its political spending. In August 2010, New York City Public Advocate Bill de Blasio launched a national campaign urging the corporation to disclose all of its political spending.

Google sponsors several non-profit lobbying groups, such as the Coalition for a Digital Economy (Coadec) in the UK. Google has sponsored meetings of the conservative Competitive Enterprise Institute who have had speakers including libertarian Republican and Tea Party member, and Senator for Kentucky, Rand Paul.

Peter Thiel stated that Google had too much influence on the Obama administration, claiming that the company "had more power under Obama than Exxon had under Bush 43". There are many revolving door examples between Google and the U.S. government. This includes: 53 revolving door moves between Google and the White House; 22 former White House officials who left the administration to work for Google and 31 Google executives who joined the White House; 45 Obama for America campaign staffers leaving for Google or Google controlled companies; 38 revolving door moves between Google and government positions involving national security, intelligence or the Department of Defense; 23 revolving door moves between Google and the State Department; and 18 Pentagon officials moving to Google.

Additionally, studies found that employees of Alphabet donated largely to support the election of candidates from the Democratic Party.

### Climate change

In 2013, Google joined the American Legislative Exchange Council (ALEC). In September 2014, Google chairman Eric Schmidt announced the company would leave ALEC for lying about climate change and "hurting our children".

In 2018, Google started an oil, gas, and energy division, hiring Darryl Willis, a 25-year BP executive who The Wall Street Journal said was intended "to court the oil and gas industry." Google Cloud signed an agreement with the French oil company Total S.A., "to jointly develop artificial intelligence solutions for subsurface data analysis in oil and gas exploration and production." A partnership with Houston oil investment bank Tudor, Pickering, Holt & Co. was described by the Houston Chronicle as giving Google "a more visible presence in Houston as one of its oldest industries works to cut costs in the wake of the oil bust and remain competitive as electric vehicles and renewable power sources gain market share." Other agreements were made with oilfield services companies Baker Hughes and Schlumberger, and Anadarko Petroleum, to use "artificial intelligence to analyse large volumes of seismic and operational data to find oil, maximise output and increase efficiency,"[ and negotiations were started with petroleum giant Saudi Aramco.

In 2019, Google was criticised for sponsoring a conference that included a session promoting climate change denial. LibertyCon speaker Caleb Rossiter belongs to the CO2 Coalition, a nonprofit that advocates for more carbon dioxide in the atmosphere. In November 2019, over 1,000 Google employees demanded that the company commit to zero emissions by 2030 and cancel contracts with fossil fuel companies.

#### AGreenerGoogle.com

In April 2020, Extinction Rebellion launched "agreenergoogle.com", a spoof website containing a fake announcement by Google CEO Sundar Pichai claiming that "they would stop funding of organizations that deny or work to block action on climate change, effective immediately".

### YouTube user comments

Most YouTube videos allow users to leave comments, and these have attracted attention for the negative aspects of both their form and content. In 2006, Time praised Web 2.0 for enabling "community and collaboration on a scale never seen before", and added that YouTube "harnesses the stupidity of crowds as well as its wisdom. Some of the comments on YouTube make you weep for the future of humanity just for the spelling alone, never mind the obscenity and the naked hatred". The Guardian in 2009 described users' comments on YouTube as:

Juvenile, aggressive, misspelled, sexist, homophobic, swinging from raging at the contents of a video to providing a pointlessly detailed description followed by a LOL, YouTube comments are a hotbed of infantile debate and unashamed ignorance – with the occasional burst of wit shining through.

In September 2008, The Daily Telegraph commented that YouTube was "notorious" for "some of the most confrontational and ill-formed comment exchanges on the internet", and reported on YouTube Comment Snob, "a new piece of software that blocks rude and illiterate posts". The Huffington Post noted in April 2012 that finding comments on YouTube that appear "offensive, stupid and crass" to the "vast majority" of the people is hardly difficult.

On November 6, 2013, Google implemented a new comment system that requires all YouTube users to use a Google+ account to comment on videos, thereby making the comment system Google+-orientated. The corporation stated that the change is necessary to personalize comment sections for viewers, eliciting an overwhelmingly negative public response—YouTube co-founder Jawed Karim also expressed disdain by writing on his channel: "why the fuck do I need a Google+ account to comment on a video?". The official YouTube announcement received over 62,000 "thumbs down" votes and only just over 4,000 "thumbs up" votes, while an online petition demanding Google+'s removal gained more than 230,000 signatures in just over two months. Writing in the Newsday blog Silicon Island, Chase Melvin noted: "Google+ is nowhere near as popular a social media network as Facebook, but it's essentially being forced upon millions of YouTube users who don't want to lose their ability to comment on videos.] In the same article Melvin adds:

    Perhaps user complaints are justified, but the idea of revamping the old system isn't so bad. Think of the crude, misogynistic and racially-charged mudslinging that has transpired over the last eight years on YouTube without any discernible moderation. Isn't any attempt to curb unidentified libelers worth a shot? The system is far from perfect, but Google should be lauded for trying to alleviate some of the damage caused by irate YouTubers hiding behind animosity and anonymity.

On July 27, 2015, Google announced that Google+ would no longer be required for using various services, including YouTube. Users are now able to delete their Google+ profile without losing features or content.

### Zero-rating

Google has supported net neutrality in the US, while opposing it in India by supporting zero-rating.

### 2016 April Fools' joke

On April 1, 2016, the Mic Drop April Fools' joke in Gmail caused damage for users who accidentally clicked the button Google installed on that occasion.

### Think Tank meddling

The New York Times reported that Google has pressured the New America think tank which is supported by it, to remove a statement supporting the EU antitrust fine against Google. After Eric Schmidt voiced his displeasure from the statement, the whole research group involved were sidelined in the New America think tank, which gets funding from Google. Consequently, the Open Markets research group went to open their own think tank, which will not get any funding from Google.

### ANS patent controversy

Wide attention in Polish media has resulted from Google's attempt to patent video compression application of ANS coding, which is now widely used in products of e.g. Apple, Facebook and Google. Its author has helped Google in this adaptation for 3 years through public forum, but was not included in the patent application. He was supported in fighting this patent by his employer: Jagiellonian University.

### Spatial data and the city

Google's huge share of spatial information services, including Google Maps and the Google Places API, has been criticised by activists and academics in terms of the cartographic power it affords Google to map and represent the world's cities. In addition, given Google and Alphabet Inc.'s increasing involvement with urban planning, particularly through subsidiaries like Sidewalk Labs, this has resulted in criticism that Google is exerting an increasing power over urban areas that may not be beneficial to democracy in the long term. This criticism is also related to wider concerns around democracy and Smart Cities that has been directed to a number of other large corporations.

### Breach of court order

On 10 December 2018, a New Zealand court ordered that the name of a man accused of murdering British traveller Grace Millane be withheld from the public (a gag order). The next morning, Google named the man in an email it sent people who had subscribed to "what's trending in New Zealand". Lawyers warned that this could compromise the trial, and Justice Minister Andrew Little said that Google was in contempt of court. Google said that it had been unaware of the court order, and that the email had been created by algorithms.

### Electronic pop-up books patent

In 2016, Google filed a patent application for interactive pop-up books with electronics. Jie Qi noticed that the patent resembled work she had shared when she visited Google ATAP in 2014 as a PhD student at the MIT Media Lab; two of the Google employees listed on the application as inventors had also interviewed her during the same visit. After Qi submitted prior art to the USPTO, the application was abandoned.

### Project Nightingale

Project Nightingale is a health care data sharing project financed by Google and Ascension, a Catholic health care system, the second largest in the United States. Ascension owns comprehensive health care information on millions of former and current patients who are part of its system. Google and Ascension have been processing this data, in secret, since sometime in 2018, without the knowledge and consent of patients and doctors. The work they are doing appears to comply with federal health care law which includes "robust protections for patient data." However, concerns have been voiced whether the transfer really is HIPAA compliant. The project is Google's attempt to gain a large scale foot hold into the healthcare industry.

### YouTube: ads forced on all videos, without revenue-share

In 2020 Google-owned YouTube changed its policy so that it could include ads on all videos, regardless of whether the content-creator wanted them or not. Those who were not part of Google's Partner Program would receive no revenue for this. To join the program, creators must have more than 1,000 subscribers and 4,000 hours of viewed content in the last 12 months.

***

# Sources

[The 250 sources from within the October 2nd ~4:00 pm revision of this article: Criticism of Google - Wikipedia (EN)](https://en.wikipedia.org/w/index.php?title=Criticism_of_Google&oldid=1046318512)

More sources coming soon, this article needs to also be rewritten to be less of a copy/paste+markdown edit from Wikipedia

***

## Article info

**Written on:** `2021 Saturday, October 2nd at 4:42 pm`

**Last revised on:** `2021 Saturday, October 2nd at 4:42 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `401`

**Article version:** `1 (2021 Saturday, October 2nd at 4:42 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/Degoogle-your-life/wiki/

!-->

