  
***

# Google Chrome

<details>
<summary><p>[Click/tap here to expand/collapse</p>
<p>the dropdown containing the Chrome logo</p></summary>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Wordmark/Google_Chrome_logo_with_wordmark_(2015).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Wordmark/Google_Chrome_logo_with_wordmark_(2015).svg)

</details>

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Windows/10/Google_Chrome_on_Windows_10_screenshot.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Windows/10/Google_Chrome_on_Windows_10_screenshot.png)

_Google Chrome on Windows 10._

_This article is on the proprietary web browser by Google. For the open source browser, see [Chromium](https://github.com/seanpm2001/Degoogle-your-life/wiki/Google-Chromium/) for the proprietary web browser for cheap laptops, see [ChromeOS](https://github.com/seanpm2001/Degoogle-your-life/wiki/ChromeOS/) for the development channel of ChromeOS that is open source, see [ChromiumOS](https://github.com/seanpm2001/Degoogle-your-life/wiki/ChromiumOS/) for ChromeOS hardware, see ( [Chromebook](https://github.com/seanpm2001/Degoogle-your-life/wiki/Chromebook/), [Chromebase](https://github.com/seanpm2001/Degoogle-your-life/wiki/Chromebase/), [Chromebox](https://github.com/seanpm2001/Degoogle-your-life/wiki/ChromeBox/), [Chromeblet](https://github.com/seanpm2001/Degoogle-your-life/wiki/Chromeblet/), [Chromebit](https://github.com/seanpm2001/Degoogle-your-life/wiki/ChromeBit/) ) for the device casting service, see [Chromecast](https://github.com/seanpm2001/Degoogle-your-life/wiki/Chromecast/)

Google Chrome is a proprietary web browser by [Google](https://github.com/seanpm2001/Degoogle-your-life/wiki/Google/) first introduced in 2008. At the time of its release, the second browser war had ended, and Firefox overtook Internet Explorer in marketshare.

Upon the release of Chrome, a lot of people switched, as Google wasn't visibly as evil for about a year after its release, and the privacy issues didn't come to light until 2013 and later. Google Chrome originally respected web standards, and was considered the fastest browser of the time by some. Over time, issues came to light, and Chrome started becoming the new Internet Explorer as its marketshare grew and grew.

With the Chromium project, other browsers couldn't compete, as Google forced bad changes on other browsers (such as making YouTube perform poorly on non-Google browsers, and giving constant popups on their sites on every other browser, telling you to "switch to Chrome") as of 2021, Google Chrome has over 60% marketshare, but hardly any browsers exist that aren't based on Chromium now, Firefox being the only non-Chromium top browser, with less than 7% marketshare, while Chromium-based browsers make up over 90% of browsers, as of May 2021)

## History

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2008-2011/Google-Chrome_FirstLogo.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2008-2011/Google-Chrome_FirstLogo.png)

_The Google Chrome logo from 2008 to 2011_

Google CEO Eric Schmidt opposed the development of an independent web browser for six years. He stated that "at the time, Google was a small company", and he did not want to go through "bruising browser wars". After co-founders Sergey Brin and Larry Page hired several Mozilla Firefox developers and built a demonstration of Chrome, Schmidt said that "It was so good that it essentially forced me to change my mind."

In September 2004, rumors of Google building a web browser first appeared. Online journals and U.S. newspapers stated at the time that Google was hiring former Microsoft web developers among others. It also came shortly after the release of Mozilla Firefox 1.0, which was surging in popularity and taking market share from Internet Explorer, which had noted security problems. Development of the browser began in 2006 spearheaded by Sundar Pichai.

Google Chrome was first released on 2008 September 2nd, released 1 day earlier than its planned release of 2008 September 3rd. Its beta was first made available for Windows XP. In December 2009, beta support was expanded to Mac OS and Linux.

Most of the source I am reading from goes over marketshare, which isn't something that should be the sole focus. However, Chrome usage did skyrocket over time, becoming a monopoly, and peaking in 2018 with over 75% marketshare.

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2011-2014/Google_Chrome_icon_(2011).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2011-2014/Google_Chrome_icon_(2011).svg)

_The Google Chrome logo from 2011 to 2014_

Google Chrome development continued. On 2011, the logo was changed. The browser continued to receive updates, less and less innovative over time starting in 2013, where the privacy scandal started, and dangerous features started getting announced more and more frequently. Chrome began to abandon web standards and favor sites that only work in Google Chrome, and nowhere else (not even another Chromium based browser, or Google Chromium itself)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2014/Google_Chrome_icon_(September_2014).svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/2014/Google_Chrome_icon_(September_2014).svg)

The logo was changed again in 2014 to match Googles [Material Design](https://github.com/seanpm2001/Degoogle-your-life/wiki/Material-Design/)

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/Canary/Chrome-canary-logo.svg](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Logo/Canary/Chrome-canary-logo.svg)

The logo for beta releases of Chrome.

## Performance problems

Google Chrome was always a resource hog, as it used an inefficient method of making a separate instance of the browser for every single open tab, rather than just the data for each tab. This adds about 10-117 megabytes of RAM usage for every open tab, whether it is active or inactive. This made the browser require ridiculous amounts of RAM compared to other browsers like Firefox. This was done to "prevent a single tab crash from bringing down the whole browser" which is completely unnecessary, as other browsers have methods of showing something like this:

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Crash/Chrome-crash.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Crash/Chrome-crash.png)

without the entire browser crashing.

## Incognito mode

![https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Incognito/Google_Chrome_Incognito.png](https://github.com/seanpm2001/Degoogle-your-life/blob/main/Graphics/Google-Chrome/Incognito/Google_Chrome_Incognito.png)

There is a common myth that incognito mode helps protect you from tracking and helps you stay private. This is completely false, even on browsers like Firefox (where it is known as private browsing mode, and is still a lot safer than Chrome by default due to better built-in tracking protection) Incognito mode just prevents your search history from being added on to. Each website can still see that you are browsing in incognito mode.

## Alternatives

It is very easy to alternate from Google Chrome. Here are some of the common browsers people switch to:

Mozilla Firefox

> Waterfox

> TenFourFox (Firefox for Mac OS X 10.0 to 10.4)

Pale Moon

SeaMonkey

Tor

Brave

Microsoft Edge

Safari

DuckDuckGo (browser)

Samsung Internet

Opera

> Opera GX

> Opera Mini

> Opera mobile

_This list is incomplete._

Not all these alternates are good for privacy however.

***

## Sources

[Wikipedia - Google Chrome](https://en.wikipedia.org/wiki/Google-Chrome)

Other sources are needed, and this article needs LOTS of improvement and original work to prevent it from being partially copied from Wikipedia.

***

## Article info

**Written on:** `2021 Friday, October 1st at 5:12 pm`

**Last revised on:** `2021 Friday, October 1st at 5:12 pm`

**File format** `Markdown document (*.md *.mkd *.markdown)`

**Line count (including blank lines and compiler line):** `137`

**Article version:** `1 (2021 Friday, October 1st at 5:12 pm)`

***

<!-- Tools

Quick copy and paste

https://github.com/seanpm2001/Degoogle-your-life/wiki/

!-->

