
***

# About the Album Cover Collection

***

## About

Starting on 2021 October 25th, I have begun to start exporting music videos into audio-only format. I will still keep the original videos, but these smaller audio files will be more portable, and easier on my current laptops CPU (my current laptop has poor video drivers, and can't even play a still image video without high CPU usage)

The thing that inspired me most to do this was the metadata customization ability in VLC, especially the ability to add/download custom album art.

This directory aims to be a quick reference archive place for every album cover across the entire collection. It is still a work in progress, as of 2021 Wednesday, October 27th.

***

## The new thing

Album art is currently the new big thing for me in VLC, along with the metadata additions and slimming projects (converting video to audio)

I still retain the original videos and audio, I am building a separate smaller version.

***

## Animated GIF

I have not attempted to put animated GIFs as the cover for a file, as I feel adding animation to an MP3 or OGG file defeats the purpose. I have confirmed that the GIF file format works as an album cover, but again, I have not attempted to do animated GIFs yet.

**Update:** I have attempted animated GIFs on 2021 November 9th. The result: they are supported, just not animated.

See more file types below.

***

## Supported file types

Album art can be added in the following formats

| File format | Supported?         | Usage in audio collection |
| ------- | ------------------ |-----------------|
| PNG | :white_check_mark: | :white_check_mark: |
| JPG | :white_check_mark: | :white_check_mark: |
| JPEG | :white_check_mark: | :white_check_mark: |
| GIF (Animated) | :white_check_mark: | :x: |
| GIF (Non-Animated) | :white_check_mark: | :white_check_mark: |
| SVG | :question: | :x: |
| BMP | :question: | :x: |
| TIF | :question: | :x: |
| TIFF | :question: | :x: |
| JFIF | :question: | :x: |
| JIF | :question: | :x: |
| ICO | :question: | :x: |
| WIM | :question: | :x: |
| WebP | :question: | :x: |
| PSD | :question: | :x: |
| WMF | :question: | :x: |
| PNS | :question: | :x: |
| QT | :question: | :x: |
| APNG | :question: | :x: |
| DIB | :question: | :x: |
| JP2 | :question: | :x: |
| Other | :question: | :x: |

I have not tested with any other formats yet.

***

## Downloading album art

I have noted so far that right clicking the album art and clicking the option "download album art" either doesn't work, or I don't know where it is saving the file.

***

## Adding album art

To add album art to a media file, go to `Tools` > `Media information` then right click the traffic cone icon under the comments section and click the option `Add cover art from file` then navigate to an image file you want to add to the file. Once you are done, make sure to click the save button before closing.

**Note:** _Be careful with the size and dimensions of the album art being added. Album art that is over 500 kilobytes, and or contains dimensions at or higher than 1900x1900 may lag out the process and the file._

**Additionally:** _Album art doesn't have to be an exact square, rectangles work as well, but only to a certain degree. Transparent images are also supported._

***

## Album art sources

Album covers are downloaded from either Discogs or Wikimedia. Sometimes another source is used if it is needed.

It is suggested that lower quality album art counts as fair use.

***

## Feature request(s)

1. There should be an option to remove album art/set it to the default image again

<!-- Notes
I usually label the ownership rights to the creator and not the record company. The creator made it, they deserve the credit.

If the song is over 70 years old, I label it public domain.

It would be nice to have a copyleft option

Sections VLC won't let me fill out: Now playing, encoded by

Playlist complications with multi-line descriptions on the first playlist entry

Song titles are now named with an underscore separating the artist from the song name
!-->

2. No other feature requests at the moment

***

## Article info

<details><summary><p>Click/tap here to expand/collapse this section</p></summary>

**Article version:** `3 (2021, Tuesday, November 9th at 7:58 pm)`

**Line count (including blank lines and compiler line):** `134`

**File type:** `Markdown document (*.md *.mkd *.mdown *.markdown)`

**Article language:** `English (US) / Markdown / HTML5`

**All times are UTC-7 (PDT/Pacific Time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

</details>

***

