
***

# Contributing.md

## For: Touch Pets Dogs 2 Rewritten

You are encouraged to contribute to this project as you wish, although you need to follow the rules of this 

## How can I contribute?

You can help contribute by submitting pull requests to this project with new changes. To create a pull request, you must first fork the project. Modify this fork until it has everything you want to contribute, then request a pull request. I will accept it if it meets the guidelines, if not, you have your own version thaty you can work with. Please try to keep the commits to a minimum, and don't include more than 1000 files per pull request, as it is harder to review, and gives me less time to review other peoples pull requests.

## Guidelines

You must follow the guidelines for your review to be accepted.

### Structure

Please follow the guidelines and keep files uploaded in the neat file structure provided. Please do not add files outside of folders unless completely necessary. This may be a factor in me rejecting your pull request.

### Graphic design

Artists are welcome to contribute. I am working on recreating a past video game, so please use older graphics of the game exactly, and don't draw in a different style. Graphics should be first written as a vector format (.svg) in as high quality as possible. Please remember to use the games skeuomorphic design and not try recreating the game in Flat design (Material Design, Fluent design, etc.)

It is a difficult job, I will pay artists in the future, but I don't have any funding yet, so right now, volunteers only. If you don't feel like volunteering and want to get paid for your submission, please wait until I come up with applicable funding.

All graphics will be released under the GNU General Public v3 license

### Audio

I am working on recreating the games audio as well. If you know how to do this/want to, please help with it. There are samples on the Internet, but I don't know how to recreate them.

The games audio will be in OGG format and will be released under the GNU General Public v3 license.

### Programming

This project is mainly written in Python, but there are exceptions for the usage of other languages.

#### Web mode

For web mode, you can use HTML with embedded CSS and JavaScript. Do not use PHP or Ruby. Also, keep the code WHATWG compliant (meaning it is standard, and will  work on any modern web browser without having to be reprogrammed for each browser, and not just 1 specific browser)

#### Apple platforms

For Apple platforms (such as MacOS, iOS, iPadOS, iPhoneOS) you can use Objective-C (for older versions before 2012) and Swift (for versions after 2012) please be careful with permissions and not use super-user permissions.

#### Windows platforms

I don't want this project to be written in a .NET language for Windows. Python is universally supported on all versions of Windows that this project supports, so please use Python for Windows platforms.

#### Linux platforms

For Linux platforms, please use Python. Additionally, you can also use QT along with Python. Please be careful with Linux programming, nothing should require super-user access. Also thank you for contributing to Linux and making content more available to the growing base of Linux users.

##### Android

Despite Android having known privacy issues, please do not include spyware in the code here either.

##### Ubuntu Snap

I currently don't plan to support Snap for Ubuntu. Please release versions compatible with the `*.deb` file format.

##### FlatPak

I am currently deciding on FlatPak support.

#### Spyware

Please **DO NOT** include tracking code/spyware in any commit you push. This project is supposed to respect the users privacy, and you may be banned from contributing here if you are caught adding tracking code.

#### Performance

Please keep performance in mind when programming for any platforms. The game should not require more than 72 Megaherts of CPU/128 Megabytes of RAM on 32 bit platforms, and 144 Megahertz of CPU/256 Megabytes of RAM on any 64 bit platform. I want to keep this software as light as possible, so please focus on optimization.

### Core files

Please do not modify core files or delete files. Files such as `IGNORE.md` can be only be deleted by me, and do not modify documentation files. You can modify the `README.md` file but only with strict permissions. No user other than me is allowed to modify the `LICENSE.txt` or `CONTRIBUTING.md` files. Also, please don't delete files that you didn't upload. If you delete a file, please give reasons. I can't name every file, so just pay attention to what is obvious and follow that.

***

## File info

File type: `Markdown document (*.md)`

File category: `Documentation, CONTRIBUTING rules`

Contributing file version: `1 (Saturday, June 19th 2021 at 4:03 pm)`

Line count (including blank lines and compiler line): `93`

***

