
***

# Contributing.md

Contributions originally weren't allowed here. This is a personal project for my journaling archive, and I originally didn't need help, but now I want community help with certain projects.

## How can I contribute

You can help contribute by submitting pull requests to this project with new iOS 6 images. To create a pull request, you must first fork the project. Modify this fork until it has everything you want to contribute, then request a pull request. I will accept it if it meets the guidelines, if not, you have your own version to work with. Please try to keep the commits to a minimum, and don't include more than 1000 files per pull request, as it is harder to review, and gives me less time to review other peoples pull requests.

## Guidelines

You must follow the guidelines for your review to be accepted.

### Structure

Please follow the guidelines and keep images uploaded in the neat structure provided. This means that images of 1 category (in example: calculator images) shouldn't be mixed in with images of the notepad.

Also, do not include more than 1000 files per folder, folders can only have a maximum of 1000 files and folders each. Contents within the folder of the folder don't count, it is just a GitHub restriction.

### Copyright

These images are used in fair use. I may have to change to the LGPL3 license if needed. Please upload original works (stuff you took with your own camera, or modified with software like Krita, or GIMP) and don't steal images. It is also preferable to not have any watermarks.

### Topic

Please only upload images of iOS 6. Images of iOS 5 and below may be accepted, but that is due to them being too similar to differentiate. I will immediately be able to tell if you are uploading images of iOS 7 and up, or images of Android or some other mobile operating system, compared to iOS. That being said, iOS 5 is so similar to iOS 6 that I might not always be able to tell, and they may be accepted, but please stay on topic.

### Core files

Please do not modify core files or delete files. Files such as `IGNORE.md` can be only be deleted by me, and do not modify documentation files. You can modify the `README.md` file but only with strict permissions. No user other than me is allowed to modify the `LICENSE.txt` or `CONTRIBUTING.md` files. Also, please don't delete files that you didn't upload. If you delete a file, please give reasons. I can't name every file, so just pay attention to what is obvious and follow that.

***

## File info

File type: `Markdown document (*.md)`

File category: `Documentation, CONTRIBUTING rules`

Contributing file version: `2 (Wednesday, June 2nd 2021 at 5:19 pm)`

Line count (including blank lines and compiler line): `47`

***

