***

<!-- # `README.md` !-->

![SNU_blue_and_gold_legacy_icon.png failed to load](/SNU_blue_and_gold_legacy_icon.png)

# SNU Programming Tools

Programming with any language online.

***

# SNU_2D_ProgrammingTools
The programming center of SNU, with planned support for every computer language, including punchcard languages. This build is required for programmer SNU distributions. Click here to learn how to build SNU: https://gist.github.com/seanpm2001/745564a46186888e829fdeb9cda584de

***

## Read this article in a different language

_🌐 List of languages_

**Sorted by:** `A-Z`

[Sorting options unavailable](https://github.com/Degoogle-your-Life)

( [af Afrikaans](/.github/README_AF.md) Afrikaans | [sq Shqiptare](/.github/README_SQ.md) Albanian | [am አማርኛ](/.github/README_AM.md) Amharic | [ar عربى](/.github/README_AR.md) Arabic | [hy հայերեն](/.github/README_HY.md) Armenian | [az Azərbaycan dili](/.github/README_AZ.md) Azerbaijani | [eu Euskara](/.github/README_EU.md) Basque | [be Беларуская](/.github/README_BE.md) Belarusian | [bn বাংলা](/.github/README_BN.md) Bengali | [bs Bosanski](/.github/README_BS.md) Bosnian | [bg български](/.github/README_BG.md) Bulgarian | [ca Català](/.github/README_CA.md) Catalan | [ceb Sugbuanon](/.github/README_CEB.md) Cebuano | [ny Chichewa](/.github/README_NY.md) Chichewa | [zh-CN 简体中文](/.github/README_ZH-CN.md) Chinese (Simplified) | [zh-t 中國傳統的）](/.github/README_ZH-T.md) Chinese (Traditional) | [co Corsu](/.github/README_CO.md) Corsican | [hr Hrvatski](/.github/README_HR.md) Croatian | [cs čeština](/.github/README_CS.md) Czech | [da dansk](README_DA.md) Danish | [nl Nederlands](/.github/README_NL.md) Dutch | [**en-us English**](/.github/README.md) English |  [EO Esperanto](/.github/README_EO.md) Esperanto | [et Eestlane](/.github/README_ET.md) Estonian | [tl Pilipino](/.github/README_TL.md) Filipino | [fi Suomalainen](/.github/README_FI.md) Finnish |  [fr français](/.github/README_FR.md) French | [fy Frysk](/.github/README_FY.md) Frisian | [gl Galego](/.github/README_GL.md) Galician | [ka ქართველი](/.github/README_KA) Georgian | [de Deutsch](/.github/README_DE.md) German | [el Ελληνικά](/.github/README_EL.md) Greek | [gu ગુજરાતી](/.github/README_GU.md) Gujarati | [ht Kreyòl ayisyen](/.github/README_HT.md) Haitian Creole | [ha Hausa](/.github/README_HA.md) Hausa | [haw Ōlelo Hawaiʻi](/.github/README_HAW.md) Hawaiian | [he עִברִית](/.github/README_HE.md) Hebrew | [hi हिन्दी](/.github/README_HI.md) Hindi | [hmn Hmong](/.github/README_HMN.md) Hmong | [hu Magyar](/.github/README_HU.md) Hungarian | [is Íslenska](/.github/README_IS.md) Icelandic | [ig Igbo](/.github/README_IG.md) Igbo | [id bahasa Indonesia](/.github/README_ID.md) Icelandic | [ga Gaeilge](/.github/README_GA.md) Irish | [it Italiana/Italiano](/.github/README_IT.md) | [ja 日本語](/.github/README_JA.md) Japanese | [jw Wong jawa](/.github/README_JW.md) Javanese | [kn ಕನ್ನಡ](/.github/README_KN.md) Kannada | [kk Қазақ](/.github/README_KK.md) Kazakh | [km ខ្មែរ](/.github/README_KM.md) Khmer | [rw Kinyarwanda](/.github/README_RW.md) Kinyarwanda | [ko-south 韓國語](/.github/README_KO_SOUTH.md) Korean (South) | [ko-north 문화어](README_KO_NORTH.md) Korean (North) (NOT YET TRANSLATED) | [ku Kurdî](/.github/README_KU.md) Kurdish (Kurmanji) | [ky Кыргызча](/.github/README_KY.md) Kyrgyz | [lo ລາວ](/.github/README_LO.md) Lao | [la Latine](/.github/README_LA.md) Latin | [lt Lietuvis](/.github/README_LT.md) Lithuanian | [lb Lëtzebuergesch](/.github/README_LB.md) Luxembourgish | [mk Македонски](/.github/README_MK.md) Macedonian | [mg Malagasy](/.github/README_MG.md) Malagasy | [ms Bahasa Melayu](/.github/README_MS.md) Malay | [ml മലയാളം](/.github/README_ML.md) Malayalam | [mt Malti](/.github/README_MT.md) Maltese | [mi Maori](/.github/README_MI.md) Maori | [mr मराठी](/.github/README_MR.md) Marathi | [mn Монгол](/.github/README_MN.md) Mongolian | [my မြန်မာ](/.github/README_MY.md) Myanmar (Burmese) | [ne नेपाली](/.github/README_NE.md) Nepali | [no norsk](/.github/README_NO.md) Norwegian | [or ଓଡିଆ (ଓଡିଆ)](/.github/README_OR.md) Odia (Oriya) | [ps پښتو](/.github/README_PS.md) Pashto | [fa فارسی](/.github/README_FA.md) |Persian  [pl polski](/.github/README_PL.md) Polish | [pt português](/.github/README_PT.md) Portuguese | [pa ਪੰਜਾਬੀ](/.github/README_PA.md) Punjabi | No languages available that start with the letter Q | [ro Română](/.github/README_RO.md) Romanian | [ru русский](/.github/README_RU.md) Russian | [sm Faasamoa](/.github/README_SM.md) Samoan | [gd Gàidhlig na h-Alba](/.github/README_GD.md) Scots Gaelic | [sr Српски](/.github/README_SR.md) Serbian | [st Sesotho](/.github/README_ST.md) Sesotho | [sn Shona](/.github/README_SN.md) Shona | [sd سنڌي](/.github/README_SD.md) Sindhi | [si සිංහල](/.github/README_SI.md) Sinhala | [sk Slovák](/.github/README_SK.md) Slovak | [sl Slovenščina](/.github/README_SL.md) Slovenian | [so Soomaali](/.github/README_SO.md) Somali | [[es en español](/.github/README_ES.md) Spanish | [su Sundanis](/.github/README_SU.md) Sundanese | [sw Kiswahili](/.github/README_SW.md) Swahili | [sv Svenska](/.github/README_SV.md) Swedish | [tg Тоҷикӣ](/.github/README_TG.md) Tajik | [ta தமிழ்](/.github/README_TA.md) Tamil | [tt Татар](/.github/README_TT.md) Tatar | [te తెలుగు](/.github/README_TE.md) Telugu | [th ไทย](/.github/README_TH.md) Thai | [tr Türk](/.github/README_TR.md) Turkish | [tk Türkmenler](/.github/README_TK.md) Turkmen | [uk Український](/.github/README_UK.md) Ukrainian | [ur اردو](/.github/README_UR.md) Urdu | [ug ئۇيغۇر](/.github/README_UG.md) Uyghur | [uz O'zbek](/.github/README_UZ.md) Uzbek | [vi Tiếng Việt](/.github/README_VI.md) Vietnamese | [cy Cymraeg](/.github/README_CY.md) Welsh | [xh isiXhosa](/.github/README_XH.md) Xhosa | [yi יידיש](/.github/README_YI.md) Yiddish | [yo Yoruba](/.github/README_YO.md) Yoruba | [zu Zulu](/.github/README_ZU.md) Zulu ) Available in 110 languages (108 when not counting English and North Korean, as North Korean has not been translated yet [Read about it here](/OldVersions/Korean(North)/README.md))

Translations in languages other than English are machine translated and are not yet accurate. No errors have been fixed yet as of June 23rd 2021. Please report translation errors [here](https://github.com/seanpm2001/SNU_2D_ProgrammingTools/issues/). Make sure to backup your correction with sources and guide me, as I don't know languages other than English well (I plan on getting a translator eventually) please cite [wiktionary](https://en.wiktionary.org) and other sources in your report. Failing to do so will result in a rejection of the correction being published.

Note: due to limitations with GitHub's interpretation of markdown (and pretty much every other web-based interpretation of markdown) clicking these links will redirect you to a separate file on a separate page that isn't my GitHub profile page. You will be redirected to the [seanpm2001/seanpm2001 repository](https://github.com/seanpm2001/seanpm2001), where the README is hosted.

Translations are done with Google Translate due to limited or no support for the languages I need in other translation services like DeepL and Bing Translate. I am working on finding an alternative. For some reason, the formatting (links, dividers, bolding, italics, etc.) is messed up in various translations. It is tedious to fix, and I do not know how to fix these issues in languages with non-latin characters, and right to left languages (like Arabic) extra help is needed in fixing these issues

***

## Index

[00.0 - Title](#SNU-Programming-Tools)

> [00.1 - Subtitle](#SNU_2D_Programming_Tools)

> [00.2 - Read this article in a different language](#Read-this-article-in-a-different-language)

> [00.3 - Index](#Index)

[01.0 - About](#About)

[02.0 - Alternatives](#Alternatives)

[03.0 - Samples](#Samples)

> [03.1 - Python Samples](#Python-samples)

> > [03.1.1 - Hello World in Python](#Hello-World-in-Python)

> [03.2 - C Samples](#C-samples)

> > [03.2.1 - Hello World in C](#Hello-World-in-C)

> > [03.2.2 - Long keyword in C](#Long-keyword-in-C)

> [03.3 - C++ Samples](#C-Plus-Plus-samples)

> > [03.3.1 - Hello World in C++](#Hello-World-in-C-Plus-Plus)

> > [03.3.2 - Exception Handling in C Plus Plus](#Exception-Handling-in-C-Plus-Plus)

[04.0 - Contributing](#Contributing)

[05.0 - Contributors](#Contributors)

[06.0 - Wiki](#Wiki)

[07.0 - Sponsor info](#Sponsor-info)

[08.0 - Version history](#Version-history)

[09.0 - Software status](#Software-status)

[10.0 - Issues](#Issues)

> [10.1 - Current issues](#Current-issues)

> [10.2 - Past issues](#Past-issues)

> [10.3 - Active pull requests](#Active-pull-requests)

[11.0 - Resources](#Resources)

[12.0 - History](#History)

[13.0 - Punch card support](#Punch-card-support)

[14.0 - Mod projects](#Mod-projects)

[15.0 - About README](#About-README)

[16.0 - File history](#File-history)

[17.0 - Footer](#Footer)

> [17.9 - EOF](#EOF)

***

# About

See above.

This is the place on SNU where programs can be tested online, and programmed online, with any programming language, markup language, etc.

Every language is also separated into its own repository, via an IDE (Integrated Development Environment) which is an environment with tools that helps you program in each language.

[View the organization here](https://github.com/SNU-Programming-Tools)

This project is still in early development, and is part of the [SNU project](https://github.com/snu-development)

## Alternatives

Some alternatives to online programming include:

[TIO (Try it Online)](https://tio.run/)

[Codeskulptor (Python only)](http://www.codeskulptor.org/)

> [Python 2.x](https://py2.codeskulptor.org/)

> [Python 3.x](https://py3.codeskulptor.org/)

[Repl.it](https://replit.com/) - Online programming IDE in 50+ languages

## Samples

### Python Samples

#### Hello World in Python

```python
print('Hello, world!')
```

### C samples

#### Hello World in C

```c
#include <stdio.h>

int main(void)
{
    printf("hello, world\n");
}
```

#### Long keyword in C

```c
long some_function();
/* int */ other_function();

/* int */ calling_function()
{
    long test1;
    register /* int */ test2;

    test1 = some_function();
    if (test1 > 0)
          test2 = 0;
    else
          test2 = other_function();
    return test2;
}
```

### C Plus Plus samples

#### Hello World in C Plus Plus

```cpp
#include <iostream>

int main()
{
    std::cout << "Hello, world!\n";
}
```

#### Exception Handling in C Plus Plus

```cpp
#include <iostream>
#include <vector>
#include <stdexcept>

int main() {
    try {
        std::vector<int> vec{3, 4, 3, 1};
        int i{vec.at(4)}; // Throws an exception, std::out_of_range (indexing for vec is from 0-3 not 1-4)
    }
    // An exception handler, catches std::out_of_range, which is thrown by vec.at(4)
    catch (std::out_of_range &e) {
        std::cerr << "Accessing a non-existent element: " << e.what() << '\n';
    }
    // To catch any other standard library exceptions (they derive from std::exception)
    catch (std::exception &e) {
        std::cerr << "Exception thrown: " << e.what() << '\n';
    }
    // Catch any unrecognised exceptions (i.e. those which don't derive from std::exception)
    catch (...) {
        std::cerr << "Some fatal error\n";
    }
}
```

***

## Contributing

Do you want to contribute to this project?

[Click/tap here to read contribution instructions](/CONTRIBUTING.md)

***

## Contributers

Currently, I am the only contributer.

> * 1. [seanpm2001](https://github.com/seanpm2001/) - 2174+ commits (As of Wednesday, June 23rd 2021 at 3:14 pm)

> * 2. No other contributers at the moment

> * 3. Contributer slot 3

> * 4. Contributer slot 4

> * 5. Contributer slot 5

> * 6. Contributer slot 6

> * 7. Contributer slot 7

> * 8. Contributer slot 8

> * 9. Contributer slot 9

> * 10. Contributer slot 10

***

## Wiki

[Click/tap here to view this projects Wiki](https://github.com/seanpm2001/<repoName>/wiki)

If the project has been forked, the Wiki was likely removed. Luckily, I include an embedded version. You can view it [here](/External/ProjectWiki/).

***

## Sponsor info

![SponsorButton.png](SponsorButton.png)

You can sponsor this project if you like, but please specify what you want to donate to. [See the funds you can donate to here](https://github.com/seanpm2001/Sponsor-info/tree/main/For-sponsors)

You can view other sponsor info [here](https://github.com/seanpm2001/Sponsor-info/)

Try it out! The sponsor button is right up next to the watch/unwatch button.

***

## Version history

**Version history currently unavailable**

**No other versions listed**

***

## Software status

All of my works are free some restrictions. DRM (**D**igital **R**estrictions **M**anagement) is not present in any of my works.

![DRM-free_label.en.svg](DRM-free_label.en.svg)

This sticker is supported by the Free Software Foundation. I never intend to include DRM in my works.

I am using the abbreviation "Digital Restrictions Management" instead of the more known "Digital Rights Management" as the common way of addressing it is false, there are no rights with DRM. The spelling "Digital Restrictions Management" is more accurate, and is supported by [Richard M. Stallman (RMS)](https://en.wikipedia.org/wiki/Richard_Stallman) and the [Free Software Foundation (FSF)](https://en.wikipedia.org/wiki/Free_Software_Foundation)

This section is used to raise awareness for the problems with DRM, and also to protest it. DRM is defective by design and is a major threat to all computer users and software freedom.

Image credit: [defectivebydesign.org/drm-free/...](https://www.defectivebydesign.org/drm-free/how-to-use-label)

***

## Issues

### Current issues

* None at the moment

* No other current issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past issues

* None at the moment

* No other past issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past pull requests

* None at the moment

* No other past pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Active pull requests

* None at the moment

* No other active pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

***

## Resources

Here are some other resources for this project:

[Project language file](PROJECT_LANG.<fileExtensionForProgrammingLanguage>)

[Join the discussion on GitHub](https://github.com/seanpm2001/<repoName>/discussions)

No other resources at the moment.

***

## History

SNU Programming Tools started out as the programming module for the website SNU that [seanpm2001](https://github.com/seanpm2001) started developing in 2018. This part didn't get created until 2020, when development went from Google Sites to self-hosted, and later to GitHub + Self hosting.

***

## Punch card support

This project has special support for classic programming language, and supports a virtual punch card format for languages like ALGOL, FORTRAN, and Assembly (early, pre-1970 versions) These punchcards are designed to emulate the experience of punchcard programming without having physical punch cards. This feature is still under development.

***

## Mod projects

Mod projects are separate projects included within the SNU Programming Tools set before the project was fully set on programming. They are still supported, and are planned to have continued support. Mods give support for software pieces, emulating sites like GitHub, and more.

***

## About README

File type: `Markdown (*.md)`

File version: `3 (Wednesday, June 23rd 2021 at 3:14 pm)`

Line count: `0,075`

***

## File history

Version 1 (Sunday, June 7th 2020 at 3:19 pm)

> Changes:

> * Started the `README.md` file

> * Added the title section

> * Added the about section

> * Added the Wiki section

> * Added the version history section

> * Added the contributors section

> * Added the about `README` section

> * Added the footer

> * No other changes in version 1

Version 2 (Monday, June 8th 2020 at 3:14 pm)

> Changes:

> * Updated all dividers (changed `---` to `***`)

> * Added the contributing section

> * Updated the file info section

> * No other changes in version 2

Version 3 (Wednesday, June 23rd 2021 at 3:50 pm)

> Changes:

> * Updated the title section

> * Added a logo

> * Added the switch languages section

> * Added the index

> * Updated the about section

> * Added the alternatives section

> * Added the samples section

> > * Added 1 Python sample

> > * Added 2 C samples

> > * Added 2 C++ samples

> * Updated the contributors section

> * Updated the contributing section

> * Updated the Wiki section

> * Added the Sponsor info section

> * Added the software status section

> * Added the issues section

> * Added the pull requests section

> * Added the resourses section

> * Added the history section

> * Added the punch card support section

> * Added the mods section

> * Updated the file info section

> * Added the file history section

> * Updated the footer

> * No other changes in version 3

Version 4 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 4

Version 5 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 5

Version 6 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 6

***

## Footer

You have reached the end of this file.

{ [Back to top](#Top) | [Return to GitHub](https://github.com) )

### EOF

***

