
***

# Docs for WacOS

## Developers

### WacOS spoken language support

**See also:** [WacOS computer language support](/Docs/Developers/Language/Computer/README.md)

This article goes over spoken languages that MacOS is written in. As of 2021 December 23rd, WacOS is only available in English (US) I hope to get some translations to other languages soon.

#### Problems

The Wiki is English only, and there isn't an easy/known way to add multi-lingual support.

Translations are not coming in yet.

#### A guide for translators

Do you know the English language well? You are reading this, so you are already qualified.

There are 2 types of translators for this project:

1. Mother tongue translator - Can speak English and a 2nd/(or 3rd, or 4th, etc.) language fluently without using a translator

2. Machine translator - Can understand English, but not a second language. This type of translator should use a translation service.

You can use whatever translation service you want, whether it be DeepL, Bing Translate, Google Translate, or another one. Machine translation in its current state isn't good enough on its own, so type 2 translators can produce content with errors, and type 1 translators (and the general public) can point out syntax or grammar problems, and open pull requests/issues to fix them.

The content MUST be copy and pasted in its entirety for machine translation. Note that Google Translate has a 5000 character limit PER PAGE but you can easily copy over 100000 characters to translate, and it will give you multiple pages of translated content. Just make sure to stitch it together in the right order, and take out any markdown bugs.

Type 1 translators are greatly appreciated as well. Type 1 translators can translate documents by hand, or go and find errors in machine translations.

#### Languages in use

<details open><summary><p lang="en">Click/tap here to expand/collapse this section</p></summary>

The following spoken languages are in use on WacOS:

- 1. [x] English (US)

- 2. [ ] No other languages in use yet

#### Language requests

<details open><summary><p lang="en">Click/tap here to expand/collapse this section</p></summary>

I am looking for help translating the project into the following languages at the moment.

The categories are sorted by terms of importance to the project. There are 5 priority levels.

**Priority 1** - For the most common languages

- [ ] Spanish

- [ ] French

- [ ] Portuguese

- [ ] Esperanto

- [ ] Russian

- [ ] Chinese (Traditional)

- [ ] Chinese (Simplified)

- [ ] Arabic

- [ ] Bengali

- [ ] Turkish

**Priority 2** - For the lesser most common languages

- [ ] Japanese

- [ ] Korean (South)

- [ ] Belarusian

- [ ] Thai

- [ ] Khmer

- [ ] Punjabi

- [ ] Other

**Priority 3** - For common languages

- [ ] German

- [ ] Greek

- [ ] Hebrew

- [ ] Polish

- [ ] Yiddish

- [ ] Swedish

- [ ] Telugu

- [ ] Dutch

- [ ] Armenian

- [ ] Catalan

- [ ] Pashto

- [ ] Telugu

- [ ] Swahili

- [ ] Malay

- [ ] Malayalam

- [ ] Vietnamese

- [ ] Javanese

- [ ] Estonian

- [ ] Kannada

- [ ] Tajik

- [ ] Tatar

- [ ] English (UK)

- [ ] Georgian

- [ ] Hawaiian

- [ ] Italian

- [ ] Czech

- [ ] Laos

- [ ] Finnish

- [ ] Icelandic

- [ ] Urdu

- [ ] Xhosa

- [ ] Zulu

- [ ] Other

**Priority 4** - For in-danger languages

- [ ] Uyghur

- [ ] Kurdish

- [ ] Ukrainian

- [ ] Igbo

- [ ] Wallow

- [ ] Other

**Priority 5** - For other (and dead) languages

- [ ] Latin

- [ ] Ancient Egyptian (as a fun task)

- [ ] Korean (North)

- [ ] Other

</details>

#### Other languages

<details open><summary><p lang="en">Click/tap here to expand/collapse this section</p></summary>

I am not looking for any other languages at the moment.

***

## Improvements to this document

<details open><summary><p lang="en">Click/tap here to expand/collapse this section</p></summary>

- [ ] Sort all entries by A-Z (should be done with software, not by hand)

- [ ] Add in any other missed common/in danger languages (very long term goal)

</details>

***

## File info

<details open><summary><p lang="en">Click/tap here to expand/collapse this section</p></summary>

**File type:** `Markdown document (*.md *.mkd *.mdown *.markdown)`

**File version:** `1 (2021, Thursday, December 23rd at 3:50 pm)`

**Line count (including blank lines and compiler line):** `0,277`

**All times are UTC-7 (PDT/Pacific Time) (please also account for daylight savings time)**

**You may need special rendering support for the `<dropdown>` HTML tag being used in this document**

</details>

***

## File history

<details><summary><p lang="en">This section has been collapsed for readability and relevance. Click/tap here to expand/collapse this section</p></summary>

**Version 1 (2021, Thursday, December 23rd at 3:50 pm)**

> Changes:

> * Started the file

> * Added the title section

> * Added the lead section

> * Added the Problems section

> * Added the A guide for translators section

> * Added the Languages in use section

> * Added the Language requests section

> * Added the other languages section

> * Added the improvements to this document section

> * Added the file info section

> * Added the file history section

> * Added the footer

> * No other changes in version 1

**Version 2 (Coming soon)**

> Changes:

> * Coming soon!

> * No other changes in version 2

</details>

***

## Footer

You have reached the end of this document

### EOF

***

