
***

# The UCALC (Ultimate Calculator) project

![CalcIcon.jpeg This image failed to load. It may be due to the file not being reached, or a general error. Reload the page to fix a possible general error.](/CalcIcon.jpeg)

# By:

## [Seanpm2001](https://github.com/seanpm2001/) / [UltimateCalculator](https://github.com/UltimateCalculator), Et; Al.
  
### Top

# `README.md`

***

## Read this article in a different language

_🌐 List of languages_

**Sorted by:** `A-Z`

[Sorting options unavailable](https://github.com/UltimateCalculator/UltimateCalculator.github.io/)

( [af Afrikaans](/.github/README_AF.md) Afrikaans | [sq Shqiptare](/.github/README_SQ.md) Albanian | [am አማርኛ](/.github/README_AM.md) Amharic | [ar عربى](/.github/README_AR.md) Arabic | [hy հայերեն](/.github/README_HY.md) Armenian | [az Azərbaycan dili](/.github/README_AZ.md) Azerbaijani | [eu Euskara](/.github/README_EU.md) Basque | [be Беларуская](/.github/README_BE.md) Belarusian | [bn বাংলা](/.github/README_BN.md) Bengali | [bs Bosanski](/.github/README_BS.md) Bosnian | [bg български](/.github/README_BG.md) Bulgarian | [ca Català](/.github/README_CA.md) Catalan | [ceb Sugbuanon](/.github/README_CEB.md) Cebuano | [ny Chichewa](/.github/README_NY.md) Chichewa | [zh-CN 简体中文](/.github/README_ZH-CN.md) Chinese (Simplified) | [zh-t 中國傳統的）](/.github/README_ZH-T.md) Chinese (Traditional) | [co Corsu](/.github/README_CO.md) Corsican | [hr Hrvatski](/.github/README_HR.md) Croatian | [cs čeština](/.github/README_CS.md) Czech | [da dansk](README_DA.md) Danish | [nl Nederlands](/.github/README_NL.md) Dutch | [**en-us English**](/.github/README.md) English |  [EO Esperanto](/.github/README_EO.md) Esperanto | [et Eestlane](/.github/README_ET.md) Estonian | [tl Pilipino](/.github/README_TL.md) Filipino | [fi Suomalainen](/.github/README_FI.md) Finnish |  [fr français](/.github/README_FR.md) French | [fy Frysk](/.github/README_FY.md) Frisian | [gl Galego](/.github/README_GL.md) Galician | [ka ქართველი](/.github/README_KA) Georgian | [de Deutsch](/.github/README_DE.md) German | [el Ελληνικά](/.github/README_EL.md) Greek | [gu ગુજરાતી](/.github/README_GU.md) Gujarati | [ht Kreyòl ayisyen](/.github/README_HT.md) Haitian Creole | [ha Hausa](/.github/README_HA.md) Hausa | [haw Ōlelo Hawaiʻi](/.github/README_HAW.md) Hawaiian | [he עִברִית](/.github/README_HE.md) Hebrew | [hi हिन्दी](/.github/README_HI.md) Hindi | [hmn Hmong](/.github/README_HMN.md) Hmong | [hu Magyar](/.github/README_HU.md) Hungarian | [is Íslenska](/.github/README_IS.md) Icelandic | [ig Igbo](/.github/README_IG.md) Igbo | [id bahasa Indonesia](/.github/README_ID.md) Icelandic | [ga Gaeilge](/.github/README_GA.md) Irish | [it Italiana/Italiano](/.github/README_IT.md) | [ja 日本語](/.github/README_JA.md) Japanese | [jw Wong jawa](/.github/README_JW.md) Javanese | [kn ಕನ್ನಡ](/.github/README_KN.md) Kannada | [kk Қазақ](/.github/README_KK.md) Kazakh | [km ខ្មែរ](/.github/README_KM.md) Khmer | [rw Kinyarwanda](/.github/README_RW.md) Kinyarwanda | [ko-south 韓國語](/.github/README_KO_SOUTH.md) Korean (South) | [ko-north 문화어](README_KO_NORTH.md) Korean (North) (NOT YET TRANSLATED) | [ku Kurdî](/.github/README_KU.md) Kurdish (Kurmanji) | [ky Кыргызча](/.github/README_KY.md) Kyrgyz | [lo ລາວ](/.github/README_LO.md) Lao | [la Latine](/.github/README_LA.md) Latin | [lt Lietuvis](/.github/README_LT.md) Lithuanian | [lb Lëtzebuergesch](/.github/README_LB.md) Luxembourgish | [mk Македонски](/.github/README_MK.md) Macedonian | [mg Malagasy](/.github/README_MG.md) Malagasy | [ms Bahasa Melayu](/.github/README_MS.md) Malay | [ml മലയാളം](/.github/README_ML.md) Malayalam | [mt Malti](/.github/README_MT.md) Maltese | [mi Maori](/.github/README_MI.md) Maori | [mr मराठी](/.github/README_MR.md) Marathi | [mn Монгол](/.github/README_MN.md) Mongolian | [my မြန်မာ](/.github/README_MY.md) Myanmar (Burmese) | [ne नेपाली](/.github/README_NE.md) Nepali | [no norsk](/.github/README_NO.md) Norwegian | [or ଓଡିଆ (ଓଡିଆ)](/.github/README_OR.md) Odia (Oriya) | [ps پښتو](/.github/README_PS.md) Pashto | [fa فارسی](/.github/README_FA.md) |Persian  [pl polski](/.github/README_PL.md) Polish | [pt português](/.github/README_PT.md) Portuguese | [pa ਪੰਜਾਬੀ](/.github/README_PA.md) Punjabi | No languages available that start with the letter Q | [ro Română](/.github/README_RO.md) Romanian | [ru русский](/.github/README_RU.md) Russian | [sm Faasamoa](/.github/README_SM.md) Samoan | [gd Gàidhlig na h-Alba](/.github/README_GD.md) Scots Gaelic | [sr Српски](/.github/README_SR.md) Serbian | [st Sesotho](/.github/README_ST.md) Sesotho | [sn Shona](/.github/README_SN.md) Shona | [sd سنڌي](/.github/README_SD.md) Sindhi | [si සිංහල](/.github/README_SI.md) Sinhala | [sk Slovák](/.github/README_SK.md) Slovak | [sl Slovenščina](/.github/README_SL.md) Slovenian | [so Soomaali](/.github/README_SO.md) Somali | [[es en español](/.github/README_ES.md) Spanish | [su Sundanis](/.github/README_SU.md) Sundanese | [sw Kiswahili](/.github/README_SW.md) Swahili | [sv Svenska](/.github/README_SV.md) Swedish | [tg Тоҷикӣ](/.github/README_TG.md) Tajik | [ta தமிழ்](/.github/README_TA.md) Tamil | [tt Татар](/.github/README_TT.md) Tatar | [te తెలుగు](/.github/README_TE.md) Telugu | [th ไทย](/.github/README_TH.md) Thai | [tr Türk](/.github/README_TR.md) Turkish | [tk Türkmenler](/.github/README_TK.md) Turkmen | [uk Український](/.github/README_UK.md) Ukrainian | [ur اردو](/.github/README_UR.md) Urdu | [ug ئۇيغۇر](/.github/README_UG.md) Uyghur | [uz O'zbek](/.github/README_UZ.md) Uzbek | [vi Tiếng Việt](/.github/README_VI.md) Vietnamese | [cy Cymraeg](/.github/README_CY.md) Welsh | [xh isiXhosa](/.github/README_XH.md) Xhosa | [yi יידיש](/.github/README_YI.md) Yiddish | [yo Yoruba](/.github/README_YO.md) Yoruba | [zu Zulu](/.github/README_ZU.md) Zulu ) Available in 110 languages (108 when not counting English and North Korean, as North Korean has not been translated yet [Read about it here](/OldVersions/Korean(North)/README.md))

Translations in languages other than English are machine translated and are not yet accurate. No errors have been fixed yet as of March 21st 2021. Please report translation errors [here](https://github.com/seanpm2001/UltimateCalculator/issues/). Make sure to backup your correction with sources and guide me, as I don't know languages other than English well (I plan on getting a translator eventually) please cite [wiktionary](https://en.wiktionary.org) and other sources in your report. Failing to do so will result in a rejection of the correction being published.

Note: due to limitations with GitHub's interpretation of markdown (and pretty much every other web-based interpretation of markdown) clicking these links will redirect you to a separate file on a separate page that isn't the intended page. You will be redirected to the [.github folder](/.github/) of this project, where the README translations are hosted.

Translations are currently done with Bing translate and DeepL. Support for Google Translate translations is coming to a close due to privacy concerns.

***

# Index

[00.0 - Top](#Top)

> [00.1 - Title](#The-UCALC (Ultimate Calculator)-project)

> [00.2 - Read this article in a different language](#Read-this-article-in-a-different-language)

> [00.3 - Index](#Index)

[01.0 - Description](#UCALC (Ultimate Calculator))

[02.0 - About](#About)

[03.0 - History](#History)
  
> [03.1 - Pre-history](#Pre-history)

> [03.2 - Alpha History](#Alpha-history)

> [03.3 - Beta History](#Beta-history)

> [03.4 - Modern History](#Modern-history)

[04.0 - Wiki](#Wiki)

[05.0 - Version history](#Version-history)

[06.0 - Project info](#Project-info)

[07.0 - Installation](#Installation)

[08.0 - Credits](#Credits)

[09.0 - Copying](#Copying)

[10.0 - Dependencies](#Dependencies)

[11.0 - FAQ (Frequently Asked Questions)](#FAQ-(Frequently-Asked-Questions))

[12.0 - Cool UNIX tricks](#Cool-UNIX-tricks)

[13.0 - Current issues](#Current-issues)

[14.0 - Fixed issues](#Fixed-issues)

[15.0 - Software status](#Software-status)

[16.0 - Sponsor info](#Sponsor-info)

[17.0 - Contributers](#Contributers)

[18.0 - Issues](#Issues)

> [18.1 - Current issues](#Current-issues)

> [18.2 - Past issues](#Past-issues)

> [18.3 - Past pull requests](#Past-pull-requests)

> [18.4 - Active pull requests](#Active-pull-requests)

[19.0 - Resources](#Resources)

[20.0 - Contributing](#Contributing)

[21.0 - About README](#About-README)

[22.0 - README Version history](#README-version-history)

[23.0 - Footer](#You-have-reached-the-end-of-the-README-file)

> [23.9 - End of file](#EOF)

***

# UltimateCalculator
UCALC (Ultimate Calculator) is an advanced Python-based calculator that was my first major Python project.

***

## About

See above. UCALC is a very advanced calculator project that aims to be the most advanced calculator, that can replace current calculators, and serve as a calculator with all the features you would ever need. It is designed to be highly portable, stable, and lightweight. It currently can run on any operating system that supports Python 3. It also has its own planned separate embedded operating system project in the works, planned to be based on Tiny Core Linux or ArchBang Linux (a decision is still underway)

***
  
## History

This project has a long history so far.

### Pre-history

This project was started in early 2018 as a Python calculator project to test my Python knowledge during High School, and try to provide an alternative to the schools calculators. Despite my poor performance in my math classes (I have a problem showing what I know and regurgating certain information) the idea was popular among the people I shared the project with. The project was open source at the time, but I had very little knowledge of technology, as I was still beginning, and didn't fully understand the significance of open source yet. Nevertheless, the project never had any thought on becoming proprietary, and never was made proprietary (freeware and shareware also counts as proprietary, as it is not open source)

The base project was written in Python 3.6.2 under Windows 10, tested with a 4 gigabyte of RAM device with a Intel Celeron CPU.

The project received lots of development for several months, I noted that my schools calculators gave an overflow error when calculating 2^34 or higher, so I concluded that the TI-80 calculators my school mostly used were 33 bit devices, giving me my first marketing point for the project, being that due to it being based on Python, it doesn't stop at 10 digits for calculation, and the Python IDE I used on a low end Windows 10 laptop was able to easily calculate answers that gave you small numbers for several pages without any error (meaning it can easily calculate a number equivalent to several thousand Googols)

The project received additional features, such as screensavers, small video games, but the program as a whole remained a command line only project. (as of August 15th 2021, there is still no GUI, unless you count the usage of ASCII art)

The project was then abandoned for over a year.

### Alpha history

On May 29th 2020, the project was moved to GitHub, and over the course of May 29th to May 30th 2020, the project was fully uploaded to GitHub. It took longer than it would nowadays, as at the time, I didn't know how to upload directories yet (I hadn't discovered that you could yet) and I also had to examine the source code for sensitive content, and found none. The project was then abandoned for 15 months.

On May 26th 2021, this project received its own GitHub organization to better host the projects development.

On Saturday, 2021 August 14th, the project was updated, as I had recently gained interest in the project again with 2 new factors sparking my interest:

* Adding support for Boolean Algebra

* Getting the program to the point of functionality where it can replace my current Linux calculator (GNOME Calculator) and so I can have my own in-house software project (that is not a webpage or web-app) that I contributed a significant role in, to use by me, on a daily basis.

The project received some updates this day, and had a license change. It was also modernized with my modern GitHub standards, along with some newer experimental standards. It also received its own website and Snapcraft Linux package.

On August 15th 2021, the project was updated. Its `README.md` file was updated and modernized, and its website was updated to include the new modernized `README.md` file.

### Beta history

No Beta history to show for this project.

### Modern history

No Modern history to show for this project.

***

## Wiki

[Click/tap here to view this projects Wiki](https://github.com/seanpm2001/UltimateCalculator/wiki/)

If the project has been forked, the Wiki was likely removed. Luckily, I include an embedded version. You can view it [here](/External/ProjectWiki/).

***

## Sponsor info

![SponsorButton.png](/SponsorButton.png)

You can sponsor this project if you like, but please specify what you want to donate to. [See the funds you can donate to here](https://github.com/seanpm2001/Sponsor-info/tree/main/For-sponsors/)

You can view other sponsor info [here](https://github.com/seanpm2001/Sponsor-info/)

Try it out! The sponsor button is right up next to the watch/unwatch button.

***

## Version history

[0.4.06.1alpha1](https://github.com/seanpm2001/UCALC/tree/V0.4.06.1Alpha1)

This release is a pre-release, as 2 areas haven't been filled in yet.

[0.4.06.1alpha2](https://github.com/seanpm2001/UCALC/tree/V0.4.06.1Alpha2)

This release is a pre-release, as even though the 2 areas have been filled in, this is an old release, and is not yet finished.

0.4.07.0beta1
[unavailable](https://www.example.com)

***

## Project info

All versions: over ~~828 (inaccurate)~~ 260 megabytes in size (in the base system (base 10 or base 2, I can't figure it out at the moment. I know it is the one that Windows and Android **Don't** use (which is 1000 bytes per Kilobyte and not 1024 bytes per Kibibyte)

***

## Installation

---
Installing UCALC (Ultimate Calculator)
---

UCALC currently doesn't require installation (as of August 14th 2021) although it requires 1 program/package to be installed:

* Python 3.5 or higher

Once you do this, each individual script should be ran through the Python console, and will act as a separate mode of the calculator.

---
Install instructions file version: 1 (Saturday, August 14th 2021 at 9:23 pm)
---

[View the file separately here](/INSTALL)

***

## Credits

---

{{int:version-credits-summary}}
UCALC (Ultimate Calculator) is a collaborative project released under the GNU General Public License v3. We would like to recognize the following names for their contribution to the product.

This comment block and this file (excluding author names) was modified from MediaWiki/CREDITS

== Maintainers ==
<!-- BEGIN MAINTAINERS LIST !-->

1. @seanpm2001 - Creator and primary maintainer of UCALC

2. No other contributors as of Saturday, August 14th 2021

== Contributors ==
<!-- BEGIN CONTRIBUTOR LIST -->

1. @seanpm2001

2. No other contributors as of Saturday, August 14th 2021

---

[View the file separately here](/CREDITS)

***

## Copying

Note to self: the separate copyleft copying file is not ready to be used on other projects, as it breaks the licensing for the project at the moment via GitHubs automation.

### LICENSE UNDER DEVELOPMENT

Copying UCALC

You are free to copy and distribute my software anywhere, as long as you abide by the rules of the LICENSE (GNU General Public License V3) and follow these 4 rules:

1. Plagiarism - Plagiarism is never allowed for any of my projects. It is my #1 rule. If you are to use this project, you cannot plagiarize it (claim that you made it and that I didn't)

2. Embedding - If you are to embed this projects files or its source code into another project, you must keep this file, the license file, and the README file with credit to Sean Patrick Myrick (@Seanpm2001)
 
3. Ethics - You must use this project for good and not evil. Unethical purposes such as ransomware, programs with anti-virtual machine/anti-emulator source code, and privacy invasive spyware and data collection are not allowed.

4. Credit - Please give credit when using my software. See §Plagiarism

Additionally

<!-- A. NSFW - You can use my software on any project deemed vulgar or repulsive (such as Internet Pornography, Erotica) as long as it isn't illegal usage. !-->

Copyleft (🄯) Seanpm2001 (2018-2021)

File version: 1 (2021, Saturday August 14th at 6:16 pm)

[View the file separately here](/COPYING)

***

## Dependencies

This project currently has 1 package dependency:

1. Python 3.6.2

I know that this version is getting old, and may need to be updated in the future, but due to its source code style, it should still remain functional with all Python versions 3.0 and up (version 3.5 or higher is recommended) (as of 2021 August 15th) as long as the next version of Python isn't as big of a change as Python 2.7 to Python 3.0, as that would break the syntax.

[View the old dependency file here](/BUILD)

***

## FAQ (Frequently Asked Questions)

### Frequently asked questions

No questions have been asked yet, so I have added some that may get asked

***

#### How does this make the TI-80 primitive technology?

The TI-80 (I might have the wrong model number) is only a 33 bit calculator. It performs very basic actions, and has a very small overflow limit.

UCALC is a 64 bit calculator client that is written in Python. For non-decimal equations, the only limit of the calculation is how much processing power you have. UCALC can easily perform equations such as 1000^1000 with a computer with just 4 Gigabytes of RAM and a 2.3 Ghz processor and give the full answer, while the TI can't give you a full answer above 2^33. 

***

FAQ version: 1 (May 29th 2020 at 4:25 pm)

This version of the FAQ is currently highly outdated

[View the file separately here](/FAQ.md)

***

## Cool UNIX tricks

I created these files (COPYING, CREDITS, INSTALL) on August 14th 2021, as I have noted that on Linux/GNOME, these files have a special icon when detected (first discovered through the MediaWiki 7 source code package) and I wanted a project to have them.

No other cool UNIX tricks right now, sorry. Although fun fact, `lslocks` is a command on Ubuntu/GNOME that shows you all dependencies that are locked. Also, `fuser` is a command that displays the PIDs of processes using the specified files or file systems. [Source: ComputerHope](https://www.computerhope.com/unix/fuser.htm)

***

## Current issues

> * 1. Some files were not uploaded yet, as they contained sensitive links. Less than 10 files aren't available on GitHub

> * 2. Program is not yet completely functional in many areas

> * 3. The camera calculation tool (CDoc) is not functioanl yet

***

## Fixed issues

~~> * 1. I have 2 huge directories that I couldn't add in tonight. The English directories inside the UCALC Shell/CLI. It was originally a fairly easy process. I would upload them all at once, I could do it in one go. Newer versions had more versions, so I had to do it in multiple batches (due to a 100 file at once upload limit on GitHub) the problem now is that for 2 versions of the English directory, there are several subdirectories, with more subdirectories inside the directories subdirectories. It is going to be a nightmare to get them all uploaded, due to how long it is going to take.~~

***

## Software status

All of my works are free some restrictions. DRM (**D**igital **R**estrictions **M**anagement) is not present in any of my works.

![DRM-free_label.en.svg](/DRM-free_label.en.svg)

This sticker is supported by the Free Software Foundation. I never intend to include DRM in my works.

I am ussing the abbreviation "Digital Restrictions Management" instead of the more known "Digital Rights Management" as the common way of addressing it is false, there are no rights with DRM. The spelling "Digital Restrictions Management" is more accurate, and is supported by [Richard M. Stallman (RMS)](https://en.wikipedia.org/wiki/Richard_Stallman/) and the [Free Software Foundation (FSF)](https://en.wikipedia.org/wiki/Free_Software_Foundation/)

This section is used to raise awareness for the problems with DRM, and also to protest it. DRM is defective by design and is a major threat to all computer users and software freedom.

Image credit: [defectivebydesign.org/drm-free/...](https://www.defectivebydesign.org/drm-free/how-to-use-label/)

***

## Contributers

Currently, I am the only contributer. Contributing is allowed, as long as you follow the rules of the [CONTRIBUTING.md](/CONTRIBUTING.md) file.

> * 1. [seanpm2001](https://github.com/seanpm2001/) - 407 commits (As of Sunday, August 15th 2021 at 6:25 pm)

> * 2. No other contributers.

***

## Issues

### Current issues

* None at the moment

* No other current issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past issues

* None at the moment

* No other past issues

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Past pull requests

* None at the moment

* No other past pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

### Active pull requests

* None at the moment

* No other active pull requests

If the repository has been forked, issues likely have been removed. Luckily I keep an archive of certain images [here](/.github/Issues/)

[Read the privacy policy on issue archival here](/.github/Issues/README.md)

**TL;DR**

I archive my own issues. Your issue won't be archived unless you request it to be archived.

***

## Resources

Here are some other resources for this project:

[Project language file A](/PROJECT_LANG_1.py)

[Join the discussion on GitHub](https://github.com/seanpm2001/UCALC/discussions/)

No other resources at the moment.

### Extra resources

[Googology Wiki - A fan Wiki for very large numbers](https://googology.wikia.org/wiki/Googology_Wiki/)

No other extra resources at the moment.

***

## Contributing

Contributing is allowed for this project, as long as you follow the rules of the `CONTRIBUTING.md` file.

[Click/tap here to view the contributing rules for this project](/CONTRIBUTING.md)

***

## About README

File type: `Markdown (*.md)`

File version: `6 (Sunday, August 15th 2021 at 6:25 pm)`

Line count: `0,732`

***

## README version history

Version 0.1 (Sunday, March 21st 2021 at 7:50 pm)

> Changes:

> * Started the file

> * Added the title section

> * Added the index

> * Added the about section

> * Added the Wiki section

> * Added the version history section

> * Added the issues section.

> * Added the past issues section

> * Added the past pull requests section

> * Added the active pull requests section

> * Added the contributors section

> * Added the contributing section

> * Added the about README section

> * Added the README version history section

> * Added the resources section

> * Added a software status section, with a DRM free sticker and message

> * Added the sponsor info section

> * No other changes in version 0.1

Version 0.11 (Friday, July 16th 2021 at 9:20 pm)

> Changes:

> * Updated several sections with corrected template syntax

> * Added the history section

> * Updated the language list switcher section

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11

Version 0.11B (Friday, July 16th 2021 at 9:25 pm)

> Changes:
  
> * Fixed the footer, removed bad link (ddg.com does not redirect to duckduckgo)
  
> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11B

Version 0.12A (Thursday, July 22nd 2021 at 6:26 pm)

> Changes:
  
> * The typo `SNU Erotica` was removed entirely

> * Added a better name than file.svg

> * Fixed the title section
  
> * Fixed the index
  
> > * Added the history section

> * Minor formatting fixes

> * Updated the file info section

> * Updated the file history section

> * No other changes in version 0.11B

**This history was inherited by the GitHub pages V5 template `README.md` file**

Version 1 (Friday, 2021 May 29th at 4:15 pm)

> Changes:

> * Started the file

> * Added the about section

> * Added the README info section

> * No other changes in version 1

Version 2 (Friday, 2021 May 29th at 11:07 pm)

> Changes:

> * Added the Contributors section

> * Added the current issues section

> * Added the version history section

> * No other changes in version 2

Version 3 (Saturday, 2021 May 30th at 1:56 pm)

> Changes:

> * Updated the version history section

> * Updated the contributors section

> * Updated the README info section

> * No other changes in version 3

Version 4 (Saturday, 2021 May 30th at 5:05 pm)

> Changes:

> * Added a blank section

> * Updated the contributors section

> * Added the fixed issues section

> * Updated the README info section

> * No other changes in version 4

Version 5 (Saturday, 2021 May 30th at 5:13 pm)

> Changes:

> * Added the project info section

> * Updated the contributors section

> * Updated the current issues section

> * Updated the releases section

> * Updated the README info section

> * No other changes in version 5

Version 6 (Sunday, August 15th 2021 at 6:25 pm)

> Changes:

> * Modernized the file

> * Inherited the file history from `Seanpm2001/Template_GitHubPages_V5/`

> * Updated the title section Version history

> * Updated the repository info section

> * Updated the about section

> * Updated the history section

> * Updated the project info section

> * Updated the index

> * Updated the contributors section

> * Added the Installation section

> * Added the Credits section

> * Added the Copying section

> * Added the Dependencies section

> * Added the FAQ (Frequently Asked Questions) section

> * Added the Cool UNIX tricks section

> * Added the Current issues section

> * Added the Fixed issues section

> * Updated the file info section

> * Updated the file history section

> * Updated the footer section

> * Updated the resources section

> * No other changes in version 6

Version 7 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 7

Version 8 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 8

Version 9 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 9

Version 10 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 10

Version 11 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 11

Version 12 (Coming soon)

> Changes:

> * Coming soon

> * No other changes in version 12

***

## You have reached the end of the README file

( [Back to top](#Top) | [Exit to GitHub](https://github.com) | [Exit to Bing](https://www.bing.com/) | [Exit to DuckDuckGo](https://duckduckgo.com) | [Exit to Ecosia](https://www.ecosia.org/) )

### EOF

***

